/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sf.sdedit.util.PopupActions;
import net.sf.sdedit.util.tree.BreadthFirstSearch;

public class JTreeFacade
implements PopupActions.Provider,
PopupActions.ContextHandler,
TreeCellRenderer {
    private JTree tree;
    private PopupActions popupActions;
    private TreeCellRenderer existingRenderer;
    private Icon nodeIcon;
    private Icon leafIcon;

    public JTreeFacade(JTree tree) {
        this.tree = tree;
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public PopupActions getPopupActions(PopupActions.ContextHandler ch) {
        if (this.popupActions == null) {
            this.popupActions = ch == null ? new PopupActions(this.tree, this) : new PopupActions(this.tree, ch);
        }
        return this.popupActions;
    }

    public PopupActions getPopupActions() {
        return this.getPopupActions(this);
    }

    public void deselectAll() {
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath path : this.tree.getSelectionPaths()) {
                this.tree.removeSelectionPath(path);
            }
        }
    }

    public List<String> getSelections(PathIdenter identer) {
        LinkedList<String> identList = new LinkedList<String>();
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath treePath : this.tree.getSelectionPaths()) {
                identList.add(identer.identify(treePath));
            }
        }
        return identList;
    }

    public void expandSelectedPaths() {
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath path : this.tree.getSelectionPaths()) {
                this.tree.expandPath(path);
            }
        }
    }

    public void expandAll(TreePath path) {
        BreadthFirstSearch bfs = new BreadthFirstSearch(this.tree.getModel(), path.getLastPathComponent());
        while ((path = bfs.next()) != null) {
            this.tree.expandPath(path);
        }
    }

    public void restoreSelections(PathIdenter identer, List<String> selections) {
        this.tree.removeSelectionPaths(this.tree.getSelectionPaths());
        for (String selection : selections) {
            TreePath path = identer.getPath(selection);
            if (path == null) continue;
            this.tree.addSelectionPath(path);
        }
    }

    public List<TreePath> getVisibleNodes() {
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        Enumeration<TreePath> paths = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
        if (paths != null) {
            while (paths.hasMoreElements()) {
                result.add(paths.nextElement());
            }
        }
        return result;
    }

    public Object[] getSelectedObjects() {
        TreePath[] paths = this.tree.getSelectionPaths();
        Object[] objects = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            objects[i] = paths[i].getLastPathComponent();
        }
        return objects;
    }

    public int deselectAncestors(TreePath selectedNode) {
        IdentityHashMap<Object, Object> ancestors = new IdentityHashMap<Object, Object>();
        Object[] path = selectedNode.getPath();
        int n = 0;
        if (this.tree.getSelectionPaths() != null) {
            for (int i = 0; i < path.length - 1; ++i) {
                ancestors.put(path[i], path[i]);
            }
            for (TreePath selection : this.tree.getSelectionPaths()) {
                if (!ancestors.containsKey(selection.getLastPathComponent())) continue;
                this.tree.removeSelectionPath(selection);
                ++n;
            }
        }
        return n;
    }

    public int deselectDescendants(TreePath selectedNode) {
        int n = 0;
        Object node = selectedNode.getLastPathComponent();
        if (this.tree.getSelectionPaths() != null) {
            for (TreePath selection : this.tree.getSelectionPaths()) {
                Object current = selection.getLastPathComponent();
                if (current == node) continue;
                IdentityHashMap<Object, Object> ancestors = new IdentityHashMap<Object, Object>();
                for (Object obj : selection.getPath()) {
                    ancestors.put(obj, obj);
                }
                if (!ancestors.containsKey(node)) continue;
                this.tree.removeSelectionPath(selectedNode);
                ++n;
            }
        }
        return n;
    }

    public <T> List<T> convertSelectedNodes(Class<T> nodeClass, NodeConversion<T> conversion) {
        LinkedList<T> list = new LinkedList<T>();
        if (this.tree.getSelectionPath() != null) {
            for (TreePath selection : this.tree.getSelectionPaths()) {
                Object obj = selection.getLastPathComponent();
                T t = conversion.convert(obj);
                if (t == null) continue;
                list.add(t);
            }
        }
        return list;
    }

    public void selectAndGoToRoot() {
        TreePath path = new TreePath(this.tree.getModel().getRoot());
        this.tree.scrollPathToVisible(path);
    }

    public void selectAndGoTo(TreePath path) {
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    @Override
    public Object getObjectForCurrentContext(JComponent comp) {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            paths = new TreePath[]{};
        }
        return paths;
    }

    public Icon getNodeIcon() {
        return this.nodeIcon;
    }

    public void setNodeIcon(Icon nodeIcon) {
        this.nodeIcon = nodeIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setLeafIcon(Icon leafIcon) {
        this.leafIcon = leafIcon;
    }

    public void useAsRenderer() {
        this.existingRenderer = this.tree.getCellRenderer();
        this.tree.setCellRenderer(this);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)this.existingRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (leaf) {
            label.setIcon(this.leafIcon);
        } else {
            label.setIcon(this.nodeIcon);
        }
        return label;
    }

    public PopupActions.Action getExpandAllAction() {
        return new PopupActions.Action(){
            private TreePath treePath;
            {
                this.putValue("Name", "Expand all");
            }

            @Override
            protected boolean beforePopup(Object context) {
                this.treePath = (TreePath)context;
                return true;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JTreeFacade.this.expandAll(this.treePath);
            }
        };
    }

    public static abstract class JTreeAction
    extends AbstractAction {
        protected abstract boolean beforePopup(TreePath[] var1);
    }

    public static interface PathIdenter {
        public String identify(TreePath var1);

        public TreePath getPath(String var1);
    }

    public static interface NodeConversion<T> {
        public T convert(Object var1);
    }
}

