/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.ot.Glyph;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.graph.font.typecast.ot.T2Glyph;
import jogamp.opengl.Debug;

public class TypecastRenderer {
    private static final boolean DEBUG = Debug.debug("graph.font.Renderer");
    private static final boolean PRINT_CODE = Debug.debug("graph.font.Renderer.Code");

    private static void addShapeMoveTo(float f, OutlineShape outlineShape, Point point) {
        if (PRINT_CODE) {
            System.err.println("// Shape.MoveTo:");
            System.err.printf("shape.closeLastOutline(false);%n", new Object[0]);
            System.err.printf("shape.addEmptyOutline();%n", new Object[0]);
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point.x / f), Float.valueOf((float)point.y / f), true);
        }
        outlineShape.closeLastOutline(false);
        outlineShape.addEmptyOutline();
        outlineShape.addVertex(0, (float)point.x / f, (float)point.y / f, true);
    }

    private static void addShapeMoveTo(float f, OutlineShape outlineShape, float f2, float f3) {
        if (PRINT_CODE) {
            System.err.println("// Shape.MoveTo:");
            System.err.printf("shape.closeLastOutline(false);%n", new Object[0]);
            System.err.printf("shape.addEmptyOutline();%n", new Object[0]);
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf(f2 / f), Float.valueOf(f3 / f), true);
        }
        outlineShape.closeLastOutline(false);
        outlineShape.addEmptyOutline();
        outlineShape.addVertex(0, f2 / f, f3 / f, true);
    }

    private static void addShapeMoveTo(OutlineShape outlineShape, float f, float f2) {
        if (PRINT_CODE) {
            System.err.println("// Shape.MoveTo:");
            System.err.printf("shape.closeLastOutline(false);%n", new Object[0]);
            System.err.printf("shape.addEmptyOutline();%n", new Object[0]);
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf(f), Float.valueOf(f2), true);
        }
        outlineShape.closeLastOutline(false);
        outlineShape.addEmptyOutline();
        outlineShape.addVertex(0, f, f2, true);
    }

    private static void addShapeLineTo(float f, OutlineShape outlineShape, Point point) {
        if (PRINT_CODE) {
            System.err.println("// Shape.LineTo:");
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point.x / f), Float.valueOf((float)point.y / f), true);
        }
        outlineShape.addVertex(0, (float)point.x / f, (float)point.y / f, true);
    }

    private static void addShapeLineTo(OutlineShape outlineShape, float f, float f2) {
        if (PRINT_CODE) {
            System.err.println("// Shape.LineTo:");
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf(f), Float.valueOf(f2), true);
        }
        outlineShape.addVertex(0, f, f2, true);
    }

    private static void addShapeQuadTo(float f, OutlineShape outlineShape, Point point, Point point2) {
        if (PRINT_CODE) {
            System.err.println("// Shape.QuadTo:");
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point.x / f), Float.valueOf((float)point.y / f), false);
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point2.x / f), Float.valueOf((float)point2.y / f), true);
        }
        outlineShape.addVertex(0, (float)point.x / f, (float)point.y / f, false);
        outlineShape.addVertex(0, (float)point2.x / f, (float)point2.y / f, true);
    }

    private static void addShapeQuadTo(float f, OutlineShape outlineShape, Point point, float f2, float f3) {
        if (PRINT_CODE) {
            System.err.println("// Shape.QuadTo:");
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point.x / f), Float.valueOf((float)point.y / f), false);
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf(f2 / f), Float.valueOf(f3 / f), true);
        }
        outlineShape.addVertex(0, (float)point.x / f, (float)point.y / f, false);
        outlineShape.addVertex(0, f2 / f, f3 / f, true);
    }

    private static void addShapeCubicTo(float f, OutlineShape outlineShape, Point point, Point point2, Point point3) {
        if (PRINT_CODE) {
            System.err.println("// Shape.CubicTo:");
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point.x / f), Float.valueOf((float)point.y / f), false);
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point2.x / f), Float.valueOf((float)point2.y / f), false);
            System.err.printf("shape.addVertex(%d, %ff, %ff, %b);%n", 0, Float.valueOf((float)point3.x / f), Float.valueOf((float)point3.y / f), true);
        }
        outlineShape.addVertex(0, (float)point.x / f, (float)point.y / f, false);
        outlineShape.addVertex(0, (float)point2.x / f, (float)point2.y / f, false);
        outlineShape.addVertex(0, (float)point3.x / f, (float)point3.y / f, true);
    }

    public static OutlineShape buildEmptyShape(int n, AABBox aABBox) {
        OutlineShape outlineShape = new OutlineShape();
        if (PRINT_CODE) {
            System.err.printf("%n// Start Empty Shape%n", new Object[0]);
        }
        float f = aABBox.getMinX() / (float)n;
        float f2 = aABBox.getMaxX() / (float)n;
        float f3 = aABBox.getMinY() / (float)n;
        float f4 = aABBox.getMaxY() / (float)n;
        TypecastRenderer.addShapeMoveTo(outlineShape, f, f3);
        TypecastRenderer.addShapeLineTo(outlineShape, f, f4);
        TypecastRenderer.addShapeLineTo(outlineShape, f2, f4);
        TypecastRenderer.addShapeLineTo(outlineShape, f2, f3);
        TypecastRenderer.addShapeLineTo(outlineShape, f, f3);
        outlineShape.closeLastOutline(false);
        float f5 = aABBox.getWidth() < aABBox.getHeight() ? aABBox.getWidth() : aABBox.getHeight();
        float f6 = f5 / (float)n / 20.0f;
        TypecastRenderer.addShapeMoveTo(outlineShape, f + f6, f3 + f6);
        TypecastRenderer.addShapeLineTo(outlineShape, f2 - f6, f3 + f6);
        TypecastRenderer.addShapeLineTo(outlineShape, f2 - f6, f4 - f6);
        TypecastRenderer.addShapeLineTo(outlineShape, f + f6, f4 - f6);
        TypecastRenderer.addShapeLineTo(outlineShape, f + f6, f3 + f6);
        outlineShape.closeLastOutline(false);
        outlineShape.setIsQuadraticNurbs();
        if (PRINT_CODE) {
            System.err.printf("// End Empty Shape%n%n", new Object[0]);
        }
        return outlineShape;
    }

    public static OutlineShape buildShape(int n, Glyph glyph) {
        if (glyph == null) {
            return null;
        }
        OutlineShape outlineShape = new OutlineShape();
        if (glyph instanceof T2Glyph) {
            if (PRINT_CODE) {
                System.err.printf("%n// Start Type-2 Shape for Glyph %d%n", glyph.getID());
            }
            TypecastRenderer.buildShapeType2(n, outlineShape, (T2Glyph)glyph);
        } else {
            if (PRINT_CODE) {
                System.err.printf("%n// Start TTF Shape for Glyph %d%n", glyph.getID());
            }
            TypecastRenderer.buildShapeTTF(n, outlineShape, glyph);
            outlineShape.setIsQuadraticNurbs();
        }
        if (PRINT_CODE) {
            System.err.printf("// End Shape for Glyph %d%n%n", glyph.getID());
        }
        return outlineShape;
    }

    private static int cmod(int n, int n2, int n3) {
        if (n2 >= 0) {
            return n + n2 % n3;
        }
        return n + (n2 + n3);
    }

    private static void buildShapeTTF(float f, OutlineShape outlineShape, Glyph glyph) {
        int n = 0;
        int n2 = 0;
        int n3 = glyph.getPointCount();
        for (int i = 0; i < n3; ++i) {
            ++n2;
            if (!glyph.getPoint((int)i).endOfContour) continue;
            int n4 = n2;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = TypecastRenderer.cmod(n, n5, n4);
                Point point = glyph.getPoint(TypecastRenderer.cmod(n, n5 - 1, n4));
                Point point2 = glyph.getPoint(n6);
                Point point3 = glyph.getPoint(TypecastRenderer.cmod(n, n5 + 1, n4));
                Point point4 = glyph.getPoint(TypecastRenderer.cmod(n, n5 + 2, n4));
                if (DEBUG) {
                    System.err.println("// GlyphShape<" + glyph.getID() + ">: offset " + n5 + " of " + n2 + "/" + n3 + " points");
                    int n7 = TypecastRenderer.cmod(n, n5 - 1, n4);
                    int n8 = TypecastRenderer.cmod(n, n5 + 1, n4);
                    int n9 = TypecastRenderer.cmod(n, n5 + 2, n4);
                    System.err.printf("//  pM[%03d] %s%n", n7, point);
                    System.err.printf("//  p0[%03d] %s%n", n6, point2);
                    System.err.printf("//  p1[%03d] %s%n", n8, point3);
                    System.err.printf("//  p2[%03d] %s%n", n9, point4);
                }
                if (n5 == 0) {
                    if (point2.onCurve) {
                        if (PRINT_CODE) {
                            System.err.printf("// %03d: B0a: move-to p0%n", n6);
                        }
                        TypecastRenderer.addShapeMoveTo(f, outlineShape, point2);
                    } else {
                        if (point.onCurve) {
                            if (PRINT_CODE) {
                                System.err.printf("// %03d: B0b: move-to pM%n", TypecastRenderer.cmod(n, n5 - 1, n4));
                            }
                            TypecastRenderer.addShapeMoveTo(f, outlineShape, point);
                            --n5;
                            --n2;
                            continue;
                        }
                        if (PRINT_CODE) {
                            System.err.printf("// %03d: B0c: move-to pMh%n", n6);
                        }
                        TypecastRenderer.addShapeMoveTo(f, outlineShape, TypecastRenderer.midValue(point.x, point2.x), TypecastRenderer.midValue(point.y, point2.y));
                    }
                }
                if (point2.onCurve) {
                    if (point3.onCurve) {
                        if (PRINT_CODE) {
                            System.err.printf("// %03d: B1: line-to p0-p1%n", n6);
                        }
                        TypecastRenderer.addShapeLineTo(f, outlineShape, point3);
                        ++n5;
                        continue;
                    }
                    if (point4.onCurve) {
                        if (PRINT_CODE) {
                            System.err.printf("// %03d: B2: quad-to p0-p1-p2%n", n6);
                        }
                        TypecastRenderer.addShapeQuadTo(f, outlineShape, point3, point4);
                        n5 += 2;
                        continue;
                    }
                    if (PRINT_CODE) {
                        System.err.printf("// %03d: B4: quad-to p0-p1-p2h **** MID%n", n6);
                    }
                    TypecastRenderer.addShapeQuadTo(f, outlineShape, point3, TypecastRenderer.midValue(point3.x, point4.x), TypecastRenderer.midValue(point3.y, point4.y));
                    n5 += 2;
                    continue;
                }
                if (!point3.onCurve) {
                    if (PRINT_CODE) {
                        System.err.printf("// %03d: B5: quad-to pMh-p0-p1h ***** MID%n", n6);
                    }
                    TypecastRenderer.addShapeQuadTo(f, outlineShape, point2, TypecastRenderer.midValue(point2.x, point3.x), TypecastRenderer.midValue(point2.y, point3.y));
                    ++n5;
                    continue;
                }
                if (PRINT_CODE) {
                    System.err.printf("// %03d: B6: quad-to pMh-p0-p1%n", n6);
                }
                TypecastRenderer.addShapeQuadTo(f, outlineShape, point2, point3);
                ++n5;
            }
            if (PRINT_CODE) {
                System.err.printf("shape.closeLastOutline(false);%n%n", new Object[0]);
            }
            outlineShape.closeLastOutline(false);
            n = i + 1;
            n2 = 0;
        }
    }

    private static void buildShapeType2(float f, OutlineShape outlineShape, T2Glyph t2Glyph) {
        int n = 0;
        int n2 = 0;
        int n3 = t2Glyph.getPointCount();
        for (int i = 0; i < n3; ++i) {
            ++n2;
            if (!t2Glyph.getPoint((int)i).endOfContour) continue;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n + n4 % n2;
                Point point = t2Glyph.getPoint(n5);
                Point point2 = t2Glyph.getPoint(n + (n4 + 1) % n2);
                Point point3 = t2Glyph.getPoint(n + (n4 + 2) % n2);
                Point point4 = t2Glyph.getPoint(n + (n4 + 3) % n2);
                if (DEBUG) {
                    System.err.println("// GlyphShape<" + t2Glyph.getID() + ">: offset " + n4 + " of " + n2 + "/" + n3 + " points");
                    int n6 = n + (n4 + 1) % n2;
                    int n7 = n + (n4 + 2) % n2;
                    int n8 = n + (n4 + 3) % n2;
                    System.err.println("//  p0[" + n5 + "] " + point);
                    System.err.println("//  p1[" + n6 + "] " + point2);
                    System.err.println("//  p2[" + n7 + "] " + point3);
                    System.err.println("//  p3[" + n8 + "] " + point4);
                }
                if (n4 == 0) {
                    TypecastRenderer.addShapeMoveTo(f, outlineShape, point);
                }
                if (point.onCurve && point2.onCurve) {
                    if (PRINT_CODE) {
                        System.err.printf("// %03d: C1: line-to p0-p1%n", n5);
                    }
                    TypecastRenderer.addShapeLineTo(f, outlineShape, point2);
                    ++n4;
                    continue;
                }
                if (point.onCurve && !point2.onCurve && !point3.onCurve && point4.onCurve) {
                    if (PRINT_CODE) {
                        System.err.printf("// %03d: C2: cubic-to p0-p1-p2%n", n5);
                    }
                    TypecastRenderer.addShapeCubicTo(f, outlineShape, point, point3, point4);
                    n4 += 3;
                    continue;
                }
                System.out.println("addContourToPath case not catered for!!");
                break;
            }
            if (PRINT_CODE) {
                System.err.printf("shape.closeLastOutline(false);%n%n", new Object[0]);
            }
            outlineShape.closeLastOutline(false);
            n = i + 1;
            n2 = 0;
        }
    }

    private static int midValue(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    private static void buildShapeImplX(float f, OutlineShape outlineShape, Glyph glyph) {
        int n = 0;
        int n2 = 0;
        int n3 = glyph.getPointCount();
        if (glyph instanceof T2Glyph) {
            throw new RuntimeException("T2Glyph Not Yet Supported: " + glyph);
        }
        if (PRINT_CODE) {
            System.err.printf("%n// Start Shape for Glyph %d%n", glyph.getID());
        }
        for (int i = 0; i < n3; ++i) {
            ++n2;
            if (!glyph.getPoint((int)i).endOfContour) continue;
            TypecastRenderer.addContourToPathX1(f, outlineShape, glyph, n, n2);
            n = i + 1;
            n2 = 0;
        }
        if (PRINT_CODE) {
            System.err.printf("// End Shape for Glyph %d%n%n", glyph.getID());
        }
    }

    private static void addContourToPathX1(float f, OutlineShape outlineShape, Glyph glyph, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n + n3 % n2;
            Point point = glyph.getPoint(n3 == 0 ? n + n2 - 1 : n + (n3 - 1) % n2);
            Point point2 = glyph.getPoint(n4);
            Point point3 = glyph.getPoint(n + (n3 + 1) % n2);
            Point point4 = glyph.getPoint(n + (n3 + 2) % n2);
            if (DEBUG) {
                System.err.println("// GlyphShape<" + glyph.getID() + ">: offset " + n3 + " of " + n2 + " points");
                int n5 = n3 == 0 ? n + n2 - 1 : n + (n3 - 1) % n2;
                int n6 = n + (n3 + 1) % n2;
                int n7 = n + (n3 + 2) % n2;
                System.err.println("//  pM[" + n5 + "] " + point);
                System.err.println("//  p0[" + n4 + "] " + point2);
                System.err.println("//  p1[" + n6 + "] " + point3);
                System.err.println("//  p2[" + n7 + "] " + point4);
            }
            if (n3 == 0) {
                TypecastRenderer.addShapeMoveTo(f, outlineShape, point2);
            }
            if (point2.onCurve && point3.onCurve) {
                if (PRINT_CODE) {
                    System.err.printf("// %03d: B1: line-to p0-p1%n", n4);
                }
                TypecastRenderer.addShapeLineTo(f, outlineShape, point3);
                ++n3;
                continue;
            }
            if (point2.onCurve && !point3.onCurve && point4.onCurve) {
                if (PRINT_CODE) {
                    System.err.printf("// %03d: B2: quad-to p0-p1-p2%n", n4);
                }
                TypecastRenderer.addShapeQuadTo(f, outlineShape, point3, point4);
                n3 += 2;
                continue;
            }
            if (point2.onCurve && !point3.onCurve && !point4.onCurve) {
                if (PRINT_CODE) {
                    System.err.printf("// %03d: B4: quad-to p0-p1-p2h **** MID%n", n4);
                }
                TypecastRenderer.addShapeQuadTo(f, outlineShape, point3, TypecastRenderer.midValue(point3.x, point4.x), TypecastRenderer.midValue(point3.y, point4.y));
                n3 += 2;
                continue;
            }
            if (!point2.onCurve && !point3.onCurve) {
                if (PRINT_CODE) {
                    System.err.printf("// %03d: B5: quad-to pMh-p0-p1h ***** MID%n", n4);
                }
                TypecastRenderer.addShapeQuadTo(f, outlineShape, point2, TypecastRenderer.midValue(point2.x, point3.x), TypecastRenderer.midValue(point2.y, point3.y));
                ++n3;
                continue;
            }
            if (!point2.onCurve && point3.onCurve) {
                if (PRINT_CODE) {
                    System.err.printf("// %03d: B6: quad-to pMh-p0-p1%n", n4);
                }
                TypecastRenderer.addShapeQuadTo(f, outlineShape, point2, point3);
                ++n3;
                continue;
            }
            System.out.println("addContourToPath case not catered for!!");
            break;
        }
        if (PRINT_CODE) {
            System.err.printf("shape.closeLastOutline(false);%n%n", new Object[0]);
        }
        outlineShape.closeLastOutline(false);
    }
}

