/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class EncodingDetector {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private final String encoding;
    private final int skip;
    private final boolean encodingSpecifiedInProlog;

    EncodingDetector(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4);
        bufferedInputStream.mark(4);
        BomResult bomResult = this.processBom(bufferedInputStream);
        bufferedInputStream.reset();
        for (int i = 0; i < bomResult.skip; ++i) {
            bufferedInputStream.read();
        }
        String string = this.getPrologEncoding(bufferedInputStream);
        if (string == null) {
            this.encodingSpecifiedInProlog = false;
            this.encoding = bomResult.encoding;
        } else {
            this.encodingSpecifiedInProlog = true;
            this.encoding = string;
        }
        this.skip = bomResult.skip;
    }

    String getEncoding() {
        return this.encoding;
    }

    int getSkip() {
        return this.skip;
    }

    boolean isEncodingSpecifiedInProlog() {
        return this.encodingSpecifiedInProlog;
    }

    private String getPrologEncoding(InputStream inputStream) {
        String string = null;
        try {
            XMLStreamReader xMLStreamReader = XML_INPUT_FACTORY.createXMLStreamReader(inputStream);
            string = xMLStreamReader.getCharacterEncodingScheme();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return string;
    }

    private BomResult processBom(InputStream inputStream) {
        try {
            int n;
            int n2;
            byte[] byArray = new byte[4];
            for (n2 = 0; n2 < 4 && (n = inputStream.read()) != -1; ++n2) {
                byArray[n2] = (byte)n;
            }
            return this.parseBom(byArray, n2);
        }
        catch (IOException iOException) {
            return new BomResult("UTF-8", 0);
        }
    }

    private BomResult parseBom(byte[] byArray, int n) {
        if (n < 2) {
            return new BomResult("UTF-8", 0);
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return new BomResult("UTF-16BE", 2);
        }
        if (n2 == 255 && n3 == 254) {
            return new BomResult("UTF-16LE", 2);
        }
        if (n < 3) {
            return new BomResult("UTF-8", 0);
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return new BomResult("UTF-8", 3);
        }
        if (n < 4) {
            return new BomResult("UTF-8", 0);
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new BomResult("ISO-10646-UCS-4", 0);
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return new BomResult("ISO-10646-UCS-4", 0);
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return new BomResult("ISO-10646-UCS-4", 0);
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return new BomResult("ISO-10646-UCS-4", 0);
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return new BomResult("UTF-16BE", 0);
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return new BomResult("UTF-16LE", 0);
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return new BomResult("CP037", 0);
        }
        return new BomResult("UTF-8", 0);
    }

    private static class BomResult {
        public final String encoding;
        public final int skip;

        BomResult(String string, int n) {
            this.encoding = string;
            this.skip = n;
        }
    }
}

