/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class MessageFactory {
    private static final ResourceBundle DEFAULT_BUNDLE = ResourceBundle.getBundle("org.apache.el.Messages");
    private static final MessageFactory DEFAULT_MESSAGE_FACTORY = new MessageFactory(DEFAULT_BUNDLE);
    private final ResourceBundle bundle;

    public static String get(String string) {
        return DEFAULT_MESSAGE_FACTORY.getInternal(string);
    }

    public static String get(String string, Object ... objectArray) {
        return DEFAULT_MESSAGE_FACTORY.getInternal(string, objectArray);
    }

    public MessageFactory(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    protected String getInternal(String string) {
        try {
            return this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected String getInternal(String string, Object ... objectArray) {
        String string2 = this.getInternal(string);
        MessageFormat messageFormat = new MessageFormat(string2);
        Format[] formatArray = null;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Number)) continue;
                if (formatArray == null) {
                    formatArray = messageFormat.getFormatsByArgumentIndex();
                }
                if (i >= formatArray.length || formatArray[i] instanceof NumberFormat) continue;
                objectArray[i] = objectArray[i].toString();
            }
        }
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }
}

