/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static final String PRINTWRITER_ENCODING = "UTF8";
    @Deprecated
    protected final PrintWriter out;
    @Deprecated
    protected final boolean canonical;

    public DOMWriter(Writer writer) {
        this(writer, true);
    }

    @Deprecated
    public DOMWriter(Writer writer, boolean bl) {
        this.out = new PrintWriter(writer);
        this.canonical = bl;
    }

    @Deprecated
    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                if (!this.canonical) {
                    this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                Attr[] attrArray;
                this.out.print('<');
                this.out.print(node.getLocalName());
                for (Attr attr : attrArray = this.sortAttributes(node.getAttributes())) {
                    this.out.print(' ');
                    this.out.print(attr.getLocalName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                this.printChildren(node);
                break;
            }
            case 5: {
                if (this.canonical) {
                    this.printChildren(node);
                    break;
                }
                this.out.print('&');
                this.out.print(node.getLocalName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getLocalName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    this.out.print(' ');
                    this.out.print(string);
                }
                this.out.print("?>");
            }
        }
        if (s == 1) {
            this.out.print("</");
            this.out.print(node.getLocalName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private void printChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.print(nodeList.item(i));
            }
        }
    }

    @Deprecated
    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        if (namedNodeMap == null) {
            return new Attr[0];
        }
        int n2 = namedNodeMap.getLength();
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = null;
            string = attrArray[n].getLocalName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = null;
                string2 = attrArray[i].getLocalName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    @Deprecated
    protected String normalize(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        stringBuilder.append("&#");
                        stringBuilder.append(Integer.toString(c));
                        stringBuilder.append(';');
                        continue block7;
                    }
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

