/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class InlineExecutorService
extends AbstractExecutorService {
    private volatile boolean shutdown;
    private volatile boolean taskRunning;
    private volatile boolean terminated;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            this.terminated = !this.taskRunning;
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.terminated) {
                return true;
            }
            this.lock.wait(timeUnit.toMillis(l));
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new RejectedExecutionException();
            }
            this.taskRunning = true;
        }
        runnable.run();
        object = this.lock;
        synchronized (object) {
            this.taskRunning = false;
            if (this.shutdown) {
                this.terminated = true;
                this.lock.notifyAll();
            }
        }
    }
}

