//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#ifndef PXR_BASE_GF_DECLARE_H
#define PXR_BASE_GF_DECLARE_H

#include "pxr/pxr.h"

/// \file gf/declare.h
/// Declares Gf types.
///
/// This file provides forward declarations for Gf types.

PXR_NAMESPACE_OPEN_SCOPE

class GfBBox3d;
class GfFrustum;
class GfInterval;
class GfMultiInterval;
class GfLine;
class GfLineSeg;
class GfPlane;
class GfQuatd;
class GfQuatf;
class GfQuath;
class GfQuaternion;
class GfRay;
class GfRect2i;
class GfRect2i;
class GfRotation;
class GfSize2;
class GfSize3;
class GfMatrix2d;
class GfMatrix2f;
class GfMatrix3d;
class GfMatrix3f;
class GfMatrix4d;
class GfMatrix4f;
class GfRange1d;
class GfRange1f;
class GfRange2d;
class GfRange2f;
class GfRange3d;
class GfRange3f;
class GfVec2d;
class GfVec2f;
class GfVec2h;
class GfVec2i;
class GfVec3d;
class GfVec3f;
class GfVec3h;
class GfVec3i;
class GfVec4d;
class GfVec4f;
class GfVec4h;
class GfVec4i;

PXR_NAMESPACE_CLOSE_SCOPE

#endif // PXR_BASE_GF_DECLARE_H
