/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000e\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirLibrarySessionProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;)V", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fqName", "getFirClassifierContainerFileIfAny", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirScriptContainerFile", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "getFirScriptByFilePath", "path", "", "getFirFilesByPackage", "", "Lorg/jetbrains/kotlin/name/FqName;", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "shouldNotBeCalled", "", "resolve"})
public final class FirLibrarySessionProvider
extends FirProvider {
    @NotNull
    private final FirSymbolProvider symbolProvider;

    public FirLibrarySessionProvider(@NotNull FirSymbolProvider symbolProvider) {
        Intrinsics.checkNotNullParameter(symbolProvider, "symbolProvider");
        this.symbolProvider = symbolProvider;
    }

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getSymbolProvider().getClassLikeSymbolByClassId(classId);
        return firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        this.shouldNotBeCalled();
        throw new KotlinNothingValueException();
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        return null;
    }

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return null;
    }

    @Override
    @Nullable
    public FirFile getFirScriptContainerFile(@NotNull FirScriptSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return null;
    }

    @Override
    @Nullable
    public FirScriptSymbol getFirScriptByFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return null;
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        this.shouldNotBeCalled();
        throw new KotlinNothingValueException();
    }

    private final Void shouldNotBeCalled() {
        throw new IllegalStateException("Should not be called for FirLibrarySessionProvider".toString());
    }
}

