/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.ImagesBundle;
import org.intellij.images.scientific.action.BinarizeImageAction;
import org.intellij.images.scientific.action.ConfigureActions;
import org.intellij.images.scientific.action.DisplaySingleChannelAction;
import org.intellij.images.scientific.action.GrayscaleImageAction;
import org.intellij.images.scientific.action.InvertChannelsAction;
import org.intellij.images.scientific.action.RestoreOriginalImageAction;
import org.intellij.images.scientific.action.ReverseChannelsOrderAction;
import org.intellij.images.scientific.utils.ScientificUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/images/scientific/action/ImageOperationsActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "selectedMode", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "triggerModeAction", "mode", "Companion", "intellij.platform.images"})
public final class ImageOperationsActionGroup
extends DefaultActionGroup
implements CustomComponentAction,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String selectedMode = ORIGINAL_IMAGE;
    @Nls
    @NotNull
    private static final String CHANNEL_1;
    @Nls
    @NotNull
    private static final String CHANNEL_2;
    @Nls
    @NotNull
    private static final String CHANNEL_3;
    @Nls
    @NotNull
    private static final String ORIGINAL_IMAGE;
    @Nls
    @NotNull
    private static final String REVERSED_IMAGE;
    @Nls
    @NotNull
    private static final String INVERTED_IMAGE;
    @Nls
    @NotNull
    private static final String GRAYSCALE_IMAGE;
    @Nls
    @NotNull
    private static final String BINARIZE_IMAGE;
    @Nls
    @NotNull
    private static final String CONFIGURE_ACTIONS;

    public ImageOperationsActionGroup() {
        Presentation presentation;
        Presentation $this$_init__u24lambda_u240 = presentation = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.setPerformGroup(true);
        this.setPopup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean shouldShowTheGroup = Registry.Companion.is("ide.images.sci.mode.channels.operations");
        if (!shouldShowTheGroup) {
            e.getPresentation().setVisible(false);
            return;
        }
        VirtualFile imageFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile virtualFile = imageFile;
        e.getPresentation().setEnabledAndVisible((virtualFile != null ? (Unit)virtualFile.getUserData(ScientificUtils.SCIENTIFIC_MODE_KEY) : null) != null);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        DefaultComboBoxModel<String> defaultComboBoxModel;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.selectedMode = ORIGINAL_IMAGE;
        DefaultComboBoxModel<String> $this$createCustomComponent_u24lambda_u241 = defaultComboBoxModel = new DefaultComboBoxModel<String>();
        boolean bl = false;
        $this$createCustomComponent_u24lambda_u241.addElement(ORIGINAL_IMAGE);
        $this$createCustomComponent_u24lambda_u241.addElement(REVERSED_IMAGE);
        $this$createCustomComponent_u24lambda_u241.addElement(INVERTED_IMAGE);
        $this$createCustomComponent_u24lambda_u241.addElement(GRAYSCALE_IMAGE);
        $this$createCustomComponent_u24lambda_u241.addElement(BINARIZE_IMAGE);
        $this$createCustomComponent_u24lambda_u241.addElement(CHANNEL_1);
        $this$createCustomComponent_u24lambda_u241.addElement(CHANNEL_2);
        $this$createCustomComponent_u24lambda_u241.addElement(CHANNEL_3);
        $this$createCustomComponent_u24lambda_u241.addElement(CONFIGURE_ACTIONS);
        DefaultComboBoxModel<String> comboBoxModel = defaultComboBoxModel;
        Object object = new ComboBox((ComboBoxModel)comboBoxModel);
        ComboBox $this$createCustomComponent_u24lambda_u243 = object;
        boolean bl2 = false;
        $this$createCustomComponent_u24lambda_u243.setSelectedItem((Object)this.selectedMode);
        $this$createCustomComponent_u24lambda_u243.setOpaque(false);
        $this$createCustomComponent_u24lambda_u243.setMaximumRowCount(comboBoxModel.getSize());
        $this$createCustomComponent_u24lambda_u243.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            public JComponent getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index != -1 && (Intrinsics.areEqual((Object)value, (Object)ImageOperationsActionGroup.access$getBINARIZE_IMAGE$cp()) || Intrinsics.areEqual((Object)value, (Object)ImageOperationsActionGroup.access$getORIGINAL_IMAGE$cp()) || Intrinsics.areEqual((Object)value, (Object)ImageOperationsActionGroup.access$getCHANNEL_3$cp()))) {
                    JPanel jPanel;
                    JPanel $this$getListCellRendererComponent_u24lambda_u240 = jPanel = new JPanel();
                    boolean bl = false;
                    this.setIcon(Intrinsics.areEqual((Object)value, (Object)ImageOperationsActionGroup.access$getCONFIGURE_ACTIONS$cp()) ? AllIcons.General.Settings : null);
                    $this$getListCellRendererComponent_u24lambda_u240.setLayout(new BoxLayout($this$getListCellRendererComponent_u24lambda_u240, 1));
                    $this$getListCellRendererComponent_u24lambda_u240.setOpaque(false);
                    $this$getListCellRendererComponent_u24lambda_u240.add(component);
                    $this$getListCellRendererComponent_u24lambda_u240.add(new JSeparator());
                    return jPanel;
                }
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                return (JComponent)component;
            }
        });
        $this$createCustomComponent_u24lambda_u243.addActionListener(arg_0 -> ImageOperationsActionGroup.createCustomComponent$lambda$3$lambda$2($this$createCustomComponent_u24lambda_u243, this, arg_0));
        ComboBox comboBox2 = object;
        Object $this$createCustomComponent_u24lambda_u244 = object = new JPanel(new FlowLayout(1, 0, 0));
        boolean bl3 = false;
        ((JComponent)$this$createCustomComponent_u24lambda_u244).setOpaque(false);
        ((JComponent)$this$createCustomComponent_u24lambda_u244).setBorder(null);
        ((Container)$this$createCustomComponent_u24lambda_u244).add((Component)comboBox2);
        return (JComponent)object;
    }

    private final void triggerModeAction(String mode) {
        ActionManager actionManager = ActionManager.getInstance();
        String string = mode;
        if (Intrinsics.areEqual((Object)string, (Object)ORIGINAL_IMAGE)) {
            actionManager.tryToExecute((AnAction)new RestoreOriginalImageAction(), null, null, null, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)REVERSED_IMAGE)) {
            actionManager.tryToExecute((AnAction)new ReverseChannelsOrderAction(), null, null, null, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)INVERTED_IMAGE)) {
            actionManager.tryToExecute((AnAction)new InvertChannelsAction(), null, null, null, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)GRAYSCALE_IMAGE)) {
            actionManager.tryToExecute((AnAction)new GrayscaleImageAction(), null, null, null, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)BINARIZE_IMAGE)) {
            actionManager.tryToExecute((AnAction)new BinarizeImageAction(), null, null, null, true);
        } else if (Intrinsics.areEqual((Object)string, (Object)CONFIGURE_ACTIONS)) {
            actionManager.tryToExecute((AnAction)new ConfigureActions(), null, null, null, true);
        }
    }

    private static final void createCustomComponent$lambda$3$lambda$2(ComboBox $this_apply, ImageOperationsActionGroup this$0, ActionEvent it) {
        Object selectedItem = $this_apply.getSelectedItem();
        Object object = selectedItem;
        if (Intrinsics.areEqual((Object)object, (Object)CONFIGURE_ACTIONS)) {
            $this_apply.setSelectedItem((Object)this$0.selectedMode);
            this$0.triggerModeAction(CONFIGURE_ACTIONS);
        } else {
            Object[] objectArray = new String[]{CHANNEL_1, CHANNEL_2, CHANNEL_3};
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)object)) {
                int n;
                Object object2 = selectedItem;
                if (Intrinsics.areEqual((Object)object2, (Object)CHANNEL_1)) {
                    n = 0;
                } else if (Intrinsics.areEqual((Object)object2, (Object)CHANNEL_2)) {
                    n = 1;
                } else if (Intrinsics.areEqual((Object)object2, (Object)CHANNEL_3)) {
                    n = 2;
                } else {
                    return;
                }
                int channelIndex = n;
                ActionManager actionManager = ActionManager.getInstance();
                Intrinsics.checkNotNull((Object)selectedItem, (String)"null cannot be cast to non-null type kotlin.String");
                actionManager.tryToExecute((AnAction)new DisplaySingleChannelAction(channelIndex, (String)selectedItem), null, null, null, true);
            } else {
                Intrinsics.checkNotNull((Object)selectedItem, (String)"null cannot be cast to non-null type kotlin.String");
                this$0.selectedMode = (String)selectedItem;
                this$0.triggerModeAction(this$0.selectedMode);
            }
        }
    }

    public static final /* synthetic */ String access$getBINARIZE_IMAGE$cp() {
        return BINARIZE_IMAGE;
    }

    public static final /* synthetic */ String access$getORIGINAL_IMAGE$cp() {
        return ORIGINAL_IMAGE;
    }

    public static final /* synthetic */ String access$getCHANNEL_3$cp() {
        return CHANNEL_3;
    }

    public static final /* synthetic */ String access$getCONFIGURE_ACTIONS$cp() {
        return CONFIGURE_ACTIONS;
    }

    static {
        String string = ImagesBundle.message("image.channels.mode.channel.1", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CHANNEL_1 = string;
        String string2 = ImagesBundle.message("image.channels.mode.channel.2", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CHANNEL_2 = string2;
        String string3 = ImagesBundle.message("image.channels.mode.channel.3", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        CHANNEL_3 = string3;
        String string4 = ImagesBundle.message("image.color.mode.original.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        ORIGINAL_IMAGE = string4;
        String string5 = ImagesBundle.message("image.color.mode.reversed.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        REVERSED_IMAGE = string5;
        String string6 = ImagesBundle.message("image.color.mode.inverted.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        INVERTED_IMAGE = string6;
        String string7 = ImagesBundle.message("image.color.mode.grayscale.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        GRAYSCALE_IMAGE = string7;
        String string8 = ImagesBundle.message("image.color.mode.binarize.image", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        BINARIZE_IMAGE = string8;
        String string9 = ImagesBundle.message("image.color.mode.configure.actions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
        CONFIGURE_ACTIONS = string9;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/intellij/images/scientific/action/ImageOperationsActionGroup$Companion;", "", "<init>", "()V", "CHANNEL_1", "", "CHANNEL_2", "CHANNEL_3", "ORIGINAL_IMAGE", "REVERSED_IMAGE", "INVERTED_IMAGE", "GRAYSCALE_IMAGE", "BINARIZE_IMAGE", "CONFIGURE_ACTIONS", "intellij.platform.images"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

