/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaStarTypeProjection;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u0004R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001b\u0010\u0006\u001a\u00020\u0001*\u00020\u0004R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001b\u0010\u0007\u001a\u00020\u0001*\u00020\u0004R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0004\u00a8\u0006\n"}, d2={"isNullableAnyType", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "KaSession", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)Z", "isNonNullableBooleanType", "isEnum", "isInterface", "containsStarProjections", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/TypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1761#2,3:58\n*S KotlinDebug\n*F\n+ 1 TypeUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/TypeUtilsKt\n*L\n56#1:58,3\n*E\n"})
public final class TypeUtilsKt {
    public static final boolean isNullableAnyType(@NotNull KaSession $context_receiver_0, @NotNull KaType $this$isNullableAnyType) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)$this$isNullableAnyType, (String)"<this>");
        return $context_receiver_0.isAnyType($this$isNullableAnyType) && $context_receiver_0.isMarkedNullable($this$isNullableAnyType);
    }

    public static final boolean isNonNullableBooleanType(@NotNull KaSession $context_receiver_0, @NotNull KaType $this$isNonNullableBooleanType) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)$this$isNonNullableBooleanType, (String)"<this>");
        return $context_receiver_0.isBooleanType($this$isNonNullableBooleanType) && !$context_receiver_0.isMarkedNullable($this$isNonNullableBooleanType);
    }

    public static final boolean isEnum(@NotNull KaSession $context_receiver_0, @NotNull KaType $this$isEnum) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)$this$isEnum, (String)"<this>");
        if (!($this$isEnum instanceof KaClassType)) {
            return false;
        }
        KaClassLikeSymbol classSymbol = ((KaClassType)$this$isEnum).getSymbol();
        return classSymbol instanceof KaClassSymbol && ((KaClassSymbol)classSymbol).getClassKind() == KaClassKind.ENUM_CLASS;
    }

    public static final boolean isInterface(@NotNull KaType $this$isInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterface, (String)"<this>");
        if (!($this$isInterface instanceof KaClassType)) {
            return false;
        }
        KaClassLikeSymbol classSymbol = ((KaClassType)$this$isInterface).getSymbol();
        return classSymbol instanceof KaClassSymbol && ((KaClassSymbol)classSymbol).getClassKind() == KaClassKind.INTERFACE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsStarProjections(@NotNull KaType $this$containsStarProjections) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$containsStarProjections, (String)"<this>");
        if (!($this$containsStarProjections instanceof KaClassType)) return false;
        Iterable $this$any$iv = ((KaClassType)$this$containsStarProjections).getTypeArguments();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            boolean bl2;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KaTypeProjection it = (KaTypeProjection)element$iv;
            boolean bl3 = false;
            if (it instanceof KaStarTypeProjection) return true;
            KaType kaType = it.getType();
            if (kaType != null) {
                if (TypeUtilsKt.containsStarProjections(kaType)) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

