/*
 * Decompiled with CFR 0.152.
 */
package io.github.smiley4.schemakenerator.jsonschema.generator;

import io.github.smiley4.schemakenerator.core.data.CollectionData;
import io.github.smiley4.schemakenerator.core.data.MapData;
import io.github.smiley4.schemakenerator.core.data.MemberData;
import io.github.smiley4.schemakenerator.core.data.MemberKind;
import io.github.smiley4.schemakenerator.core.data.TypeData;
import io.github.smiley4.schemakenerator.core.data.TypeId;
import io.github.smiley4.schemakenerator.jsonschema.JsonSchemaUtils;
import io.github.smiley4.schemakenerator.jsonschema.generator.JsonSchemaGeneratorModule;
import io.github.smiley4.schemakenerator.jsonschema.jsonDsl.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/smiley4/schemakenerator/jsonschema/generator/DefaultJsonSchemaGeneratorModule;", "Lio/github/smiley4/schemakenerator/jsonschema/generator/JsonSchemaGeneratorModule;", "optionalAsNonRequired", "", "<init>", "(Z)V", "schemaUtils", "Lio/github/smiley4/schemakenerator/jsonschema/JsonSchemaUtils;", "applies", "typeData", "Lio/github/smiley4/schemakenerator/core/data/TypeData;", "generate", "Lio/github/smiley4/schemakenerator/jsonschema/jsonDsl/JsonNode;", "context", "Lio/github/smiley4/schemakenerator/jsonschema/generator/JsonSchemaGeneratorModule$Context;", "buildAnySchema", "buildPrimitiveSchema", "buildEnumSchema", "buildCollectionSchema", "buildMapSchema", "buildWithSubtypes", "buildObjectSchema", "buildInlineObjectSchema", "collectMembers", "", "Lio/github/smiley4/schemakenerator/core/data/MemberData;", "typeDataList", "", "schema-kenerator-jsonschema"})
@SourceDebugExtension(value={"SMAP\nDefaultJsonSchemaGeneratorModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultJsonSchemaGeneratorModule.kt\nio/github/smiley4/schemakenerator/jsonschema/generator/DefaultJsonSchemaGeneratorModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1557#2:176\n1628#2,3:177\n1863#2,2:180\n230#2,2:182\n1863#2,2:185\n1#3:184\n*S KotlinDebug\n*F\n+ 1 DefaultJsonSchemaGeneratorModule.kt\nio/github/smiley4/schemakenerator/jsonschema/generator/DefaultJsonSchemaGeneratorModule\n*L\n133#1:176\n133#1:177,3\n145#1:180,2\n158#1:182,2\n166#1:185,2\n*E\n"})
public final class DefaultJsonSchemaGeneratorModule
implements JsonSchemaGeneratorModule {
    private final boolean optionalAsNonRequired;
    @NotNull
    private final JsonSchemaUtils schemaUtils;

    public DefaultJsonSchemaGeneratorModule(boolean optionalAsNonRequired) {
        this.optionalAsNonRequired = optionalAsNonRequired;
        this.schemaUtils = new JsonSchemaUtils();
    }

    public /* synthetic */ DefaultJsonSchemaGeneratorModule(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    public boolean applies(@NotNull TypeData typeData) {
        Intrinsics.checkNotNullParameter((Object)typeData, (String)"typeData");
        return true;
    }

    @Override
    @NotNull
    public JsonNode generate(@NotNull JsonSchemaGeneratorModule.Context context) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!((Collection)context.getTypeData().getSubtypes()).isEmpty()) {
            return this.buildWithSubtypes(context.getTypeData());
        }
        if (context.getTypeData().getEnumData() != null) {
            jsonNode = this.buildEnumSchema(context.getTypeData());
        } else if (context.getTypeData().getCollectionData() != null) {
            jsonNode = this.buildCollectionSchema(context.getTypeData());
        } else if (context.getTypeData().getMapData() != null) {
            jsonNode = this.buildMapSchema(context.getTypeData());
        } else if (Intrinsics.areEqual((Object)context.getTypeData().getId(), (Object)TypeId.Companion.getWILDCARD())) {
            jsonNode = this.buildAnySchema();
        } else if (!((Collection)context.getTypeData().getMembers()).isEmpty()) {
            jsonNode = this.buildObjectSchema(context);
        } else {
            jsonNode = this.buildPrimitiveSchema(context.getTypeData());
            if (jsonNode == null) {
                jsonNode = this.buildObjectSchema(context);
            }
        }
        return jsonNode;
    }

    private final JsonNode buildAnySchema() {
        return this.schemaUtils.anyObjectSchema();
    }

    private final JsonNode buildPrimitiveSchema(TypeData typeData) {
        String string = typeData.getIdentifyingName().getFull();
        return Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Number.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(false, null, null) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, (byte)-128, (byte)127) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, Integer.MIN_VALUE, Integer.MAX_VALUE) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, Long.MIN_VALUE, Long.MAX_VALUE) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(UByte.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, 0L & 0xFFL, (long)-1 & 0xFFL) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(UShort.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, 0L & 0xFFFFL, (long)-1 & 0xFFFFL) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(UInt.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, 0L & 0xFFFFFFFFL, (long)-1 & 0xFFFFFFFFL) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(ULong.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(true, null, null) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(false, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.numericSchema(false, Double.MIN_VALUE, Double.MAX_VALUE) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.booleanSchema() : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE).getQualifiedName()) ? (JsonNode)this.schemaUtils.stringSchema(1, 1) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(String.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.stringSchema(null, null) : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.anyObjectSchema() : (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Unit.class).getQualifiedName()) ? (JsonNode)this.schemaUtils.nullSchema() : null)))))))))))))));
    }

    private final JsonNode buildEnumSchema(TypeData typeData) {
        Object object = typeData.getEnumData();
        return this.schemaUtils.enumSchema(object != null && (object = object.getConstants()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
    }

    private final JsonNode buildCollectionSchema(TypeData typeData) {
        CollectionData collectionData = typeData.getCollectionData();
        Intrinsics.checkNotNull((Object)collectionData);
        CollectionData collectionData2 = typeData.getCollectionData();
        return this.schemaUtils.arraySchema(JsonSchemaUtils.referenceSchema$default(this.schemaUtils, collectionData.getItemType().getType(), false, 2, null), collectionData2 != null ? collectionData2.getUnique() : false);
    }

    private final JsonNode buildMapSchema(TypeData typeData) {
        MapData mapData = typeData.getMapData();
        Intrinsics.checkNotNull((Object)mapData);
        return this.schemaUtils.mapObjectSchema(JsonSchemaUtils.referenceSchema$default(this.schemaUtils, mapData.getValueType().getType(), false, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode buildWithSubtypes(TypeData typeData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = typeData.getSubtypes();
        JsonSchemaUtils jsonSchemaUtils = this.schemaUtils;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeId typeId = (TypeId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsonSchemaUtils.referenceSchema$default(this.schemaUtils, (TypeId)it, false, 2, null));
        }
        return jsonSchemaUtils.subtypesSchema((List)destination$iv$iv);
    }

    private final JsonNode buildObjectSchema(JsonSchemaGeneratorModule.Context context) {
        if (context.getTypeData().isInlineValue()) {
            return this.buildInlineObjectSchema(context);
        }
        Set requiredProperties = new LinkedHashSet();
        Map propertySchemas = new LinkedHashMap();
        Iterable $this$forEach$iv = this.collectMembers(context.getTypeData(), (Collection<TypeData>)context.getKnownTypeData());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean optional;
            MemberData member = (MemberData)element$iv;
            boolean bl = false;
            propertySchemas.put(member.getName(), JsonSchemaUtils.referenceSchema$default(this.schemaUtils, member.getType(), false, 2, null));
            boolean nullable = member.getNullable();
            boolean bl2 = optional = member.getOptional() && this.optionalAsNonRequired;
            if (nullable || optional) continue;
            requiredProperties.add(member.getName());
        }
        return this.schemaUtils.objectSchema(propertySchemas, requiredProperties);
    }

    private final JsonNode buildInlineObjectSchema(JsonSchemaGeneratorModule.Context context) {
        Object v0;
        MemberData inlineType;
        block4: {
            Object element$iv2;
            block3: {
                Iterable $this$first$iv = context.getTypeData().getMembers();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    MemberData it = (MemberData)element$iv2;
                    boolean bl = false;
                    if (!(it.getKind() == MemberKind.PROPERTY)) continue;
                    break block3;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            inlineType = (MemberData)element$iv2;
            Iterable iterable = context.getKnownTypeData();
            for (Object t : iterable) {
                TypeData it = (TypeData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)inlineType.getType())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        TypeData typeData = v0;
        if (typeData == null) {
            throw new NoSuchElementException("Could not find type-data for inline type " + inlineType.getType());
        }
        TypeData inlineTypeData = typeData;
        return context.generate(inlineTypeData);
    }

    private final List<MemberData> collectMembers(TypeData typeData, Collection<TypeData> typeDataList) {
        List list;
        List $this$collectMembers_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = typeData.getSupertypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeData typeData2;
            TypeData typeData3;
            Object v0;
            block2: {
                TypeId supertypeId = (TypeId)element$iv;
                boolean bl2 = false;
                Iterable iterable = typeDataList;
                for (Object t : iterable) {
                    TypeData it = (TypeData)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)supertypeId)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((typeData3 = (TypeData)v0) == null) continue;
            TypeData supertype = typeData2 = typeData3;
            boolean bl4 = false;
            $this$collectMembers_u24lambda_u247.addAll((Collection)this.collectMembers(supertype, typeDataList));
        }
        $this$collectMembers_u24lambda_u247.addAll(typeData.getMembers());
        return CollectionsKt.build((List)list);
    }

    public DefaultJsonSchemaGeneratorModule() {
        this(false, 1, null);
    }
}

