/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Arrays;
import java.util.function.IntSupplier;
import org.openstreetmap.josm.tools.Utils;

public interface ReorderableModel<T> {
    public T getValue(int var1);

    public T setValue(int var1, T var2);

    default public boolean canMove(int delta, IntSupplier rowCount, int ... rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        int[] sortedRows = Utils.copyArray(rows);
        Arrays.sort(sortedRows);
        if (delta < 0) {
            return sortedRows[0] >= -delta;
        }
        if (delta > 0) {
            return sortedRows[sortedRows.length - 1] <= rowCount.getAsInt() - 1 - delta;
        }
        return true;
    }

    default public boolean canMoveUp(IntSupplier rowCount, int ... rows) {
        return this.canMove(-1, rowCount, rows);
    }

    default public boolean canMoveDown(IntSupplier rowCount, int ... rows) {
        return this.canMove(1, rowCount, rows);
    }

    default public boolean doMove(int delta, int ... selectedRows) {
        block4: {
            if (delta == 0) break block4;
            if (delta < 0) {
                for (int row : selectedRows) {
                    this.setValue(row + delta, this.setValue(row, this.getValue(row + delta)));
                }
            } else {
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    int row = selectedRows[i];
                    this.setValue(row + delta, this.setValue(row, this.getValue(row + delta)));
                }
            }
        }
        return delta != 0 && selectedRows.length > 0;
    }
}

