"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = require("fs/promises");
const download_1 = require("./download");
const extension_metadata_1 = require("./extension-metadata");
jest.setTimeout(20000);
describe("extensionTest", () => {
    it("should be able to an extension's basic metadata", async () => {
        const extensionDestination = await (0, download_1.download)("https://open-vsx.org/api/jeanp413/open-remote-ssh/0.0.33/file/jeanp413.open-remote-ssh-0.0.33.vsix", {});
        const metadata = await (0, extension_metadata_1.getExtensionMeta)(extensionDestination);
        expect(metadata.id).toBe("jeanp413.open-remote-ssh");
        expect(metadata.version).toBe("0.0.33");
        // Clean up
        await (0, promises_1.unlink)(extensionDestination);
        console.log(`Deleted ${extensionDestination}`);
    });
});//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/994fd12f8d3a5aa16f17d42c041e5809167e845a/node_modules/node-ovsx-sign/lib/utils/extension-metadata.test.js.map