/**
 * SECTION:simple-query
 * @short_description: A simple text-based contact query.
 * 
 * <para>This is a generic implementation of the <link linkend="FolksQuery"><type>FolksQuery</type></link> interface which supports general UI-style search use cases. It implements case-insensitive prefix matching, with transliteration of accents and other non-ASCII characters to improve matching against accented characters. It also normalises phone numbers to make matches invariant to hyphenation and spacing in phone numbers.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksSearchView"><type>FolksSearchView</type></link>
 *
 * Since: 0.11.0
 */
/**
 * FOLKS_TYPE_SIMPLE_QUERY:
 * 
 * The type for <link linkend="FolksSimpleQuery"><type>FolksSimpleQuery</type></link>.
 */
/**
 * folks_simple_query_new:
 * @query_string: (in): &nbsp;.  <para>text to match contacts against. Results will match all tokens within the whitespace-delimited string (logical-ANDing the tokens). A value of &quot;&quot; will match all contacts. However, it is recommended to not use a query at all if filtering is not required. </para>
 * @match_fields: (in) (array length=match_fields_length1): &nbsp;.  <para>the field names to apply this query to. See <link linkend="FolksQuery--match-fields"><type>"match-fields"</type></link> for more details. An empty array will match all contacts. However, it is recommended to use the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> directly if filtering is not required. <link linkend="FolksPersonaDetail"><type>FolksPersonaDetail</type></link> and <link linkend="folks-persona-store-detail-key"><function>folks_persona_store_detail_key()</function></link> for pre-defined field names. </para>
 * @match_fields_length1: length of the @match_fields array
 * 
 * Create a simple text query.
 *
 * Since: 0.11.0
 */
/**
 * FolksSimpleQuery:query-string:
 * 
 * The text query string.
 * 
 * <para>This re-evaluates the query immediately, so most clients should implement de-bouncing to ensure re-evaluation only happens when (for example) the user has stopped typing a new query.</para>
 *
 * Since: 0.11.0
 */
/**
 * folks_simple_query_get_query_string:
 * @self: the <link linkend="FolksSimpleQuery"><type>FolksSimpleQuery</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksSimpleQuery--query-string"><type>"query-string"</type></link> property.
 * 
 * The text query string.
 * 
 * <para>This re-evaluates the query immediately, so most clients should implement de-bouncing to ensure re-evaluation only happens when (for example) the user has stopped typing a new query.</para>
 * 
 * Returns: the value of the <link linkend="FolksSimpleQuery--query-string"><type>"query-string"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * folks_simple_query_set_query_string:
 * @self: the <link linkend="FolksSimpleQuery"><type>FolksSimpleQuery</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksSimpleQuery--query-string"><type>"query-string"</type></link> property
 * 
 * Set the value of the <link linkend="FolksSimpleQuery--query-string"><type>"query-string"</type></link> property to @value.
 * 
 * The text query string.
 * 
 * <para>This re-evaluates the query immediately, so most clients should implement de-bouncing to ensure re-evaluation only happens when (for example) the user has stopped typing a new query.</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksSimpleQuery:query-locale:
 * 
 * Locale to interpret the <parameter>query_string</parameter> in.
 * 
 * <para>If possible, locale-specific query string transliteration is done to increase the number of matches. Set this property to a POSIX locale name (e.g. ‘en’, ‘de_DE’, ‘de_DE@euro’ or ‘C’) to potentially improve the transliteration performed.</para><para>This may be `null` if the locale is unknown, in which case the current locale will be used. To perform transliteration for no specific locale, use `C`.</para>
 *
 * Since: 0.11.0
 */
/**
 * folks_simple_query_get_query_locale:
 * @self: the <link linkend="FolksSimpleQuery"><type>FolksSimpleQuery</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksSimpleQuery--query-locale"><type>"query-locale"</type></link> property.
 * 
 * Locale to interpret the <parameter>query_string</parameter> in.
 * 
 * <para>If possible, locale-specific query string transliteration is done to increase the number of matches. Set this property to a POSIX locale name (e.g. ‘en’, ‘de_DE’, ‘de_DE@euro’ or ‘C’) to potentially improve the transliteration performed.</para><para>This may be `null` if the locale is unknown, in which case the current locale will be used. To perform transliteration for no specific locale, use `C`.</para>
 * 
 * Returns: the value of the <link linkend="FolksSimpleQuery--query-locale"><type>"query-locale"</type></link> property
 *
 * Since: 0.11.0
 */
/**
 * folks_simple_query_set_query_locale:
 * @self: the <link linkend="FolksSimpleQuery"><type>FolksSimpleQuery</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksSimpleQuery--query-locale"><type>"query-locale"</type></link> property
 * 
 * Set the value of the <link linkend="FolksSimpleQuery--query-locale"><type>"query-locale"</type></link> property to @value.
 * 
 * Locale to interpret the <parameter>query_string</parameter> in.
 * 
 * <para>If possible, locale-specific query string transliteration is done to increase the number of matches. Set this property to a POSIX locale name (e.g. ‘en’, ‘de_DE’, ‘de_DE@euro’ or ‘C’) to potentially improve the transliteration performed.</para><para>This may be `null` if the locale is unknown, in which case the current locale will be used. To perform transliteration for no specific locale, use `C`.</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksSimpleQuery:
 * 
 * A simple text-based contact query.
 * 
 * <para>This is a generic implementation of the <link linkend="FolksQuery"><type>FolksQuery</type></link> interface which supports general UI-style search use cases. It implements case-insensitive prefix matching, with transliteration of accents and other non-ASCII characters to improve matching against accented characters. It also normalises phone numbers to make matches invariant to hyphenation and spacing in phone numbers.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksSearchView"><type>FolksSearchView</type></link>
 *
 * Since: 0.11.0
 */
/**
 * FolksSimpleQueryClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-SIMPLE-QUERY:CAPS"><literal>FOLKS_TYPE_SIMPLE_QUERY</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
