/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.LoopBasedPipe;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public abstract class SpanShapeRenderer
implements ShapeDrawPipe {
    static final RenderingEngine RenderEngine = RenderingEngine.getInstance();
    public static final int NON_RECTILINEAR_TRANSFORM_MASK = 48;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
            try {
                this.renderSpans(sunGraphics2D, sunGraphics2D.getCompClip(), shape, shapeSpanIterator);
            }
            finally {
                shapeSpanIterator.dispose();
            }
        } else {
            this.fill(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        if (shape instanceof Rectangle2D && (sunGraphics2D.transform.getType() & 0x30) == 0) {
            this.renderRect(sunGraphics2D, (Rectangle2D)shape);
            return;
        }
        Region region = sunGraphics2D.getCompClip();
        ShapeSpanIterator shapeSpanIterator = LoopPipe.getFillSSI(sunGraphics2D);
        try {
            shapeSpanIterator.setOutputArea(region);
            shapeSpanIterator.appendPath(shape.getPathIterator(sunGraphics2D.transform));
            this.renderSpans(sunGraphics2D, region, shape, shapeSpanIterator);
        }
        finally {
            shapeSpanIterator.dispose();
        }
    }

    public abstract Object startSequence(SunGraphics2D var1, Shape var2, Rectangle var3, int[] var4);

    public abstract void renderBox(Object var1, int var2, int var3, int var4, int var5);

    public abstract void endSequence(Object var1);

    public void renderRect(SunGraphics2D sunGraphics2D, Rectangle2D rectangle2D) {
        double d;
        double[] dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()};
        dArray[2] = dArray[2] + dArray[0];
        dArray[3] = dArray[3] + dArray[1];
        if (dArray[2] <= dArray[0] || dArray[3] <= dArray[1]) {
            return;
        }
        sunGraphics2D.transform.transform(dArray, 0, dArray, 0, 2);
        if (dArray[2] < dArray[0]) {
            d = dArray[2];
            dArray[2] = dArray[0];
            dArray[0] = d;
        }
        if (dArray[3] < dArray[1]) {
            d = dArray[3];
            dArray[3] = dArray[1];
            dArray[1] = d;
        }
        int[] nArray = new int[]{(int)dArray[0], (int)dArray[1], (int)dArray[2], (int)dArray[3]};
        Rectangle rectangle = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        Region region = sunGraphics2D.getCompClip();
        region.clipBoxToBounds(nArray);
        if (nArray[0] >= nArray[2] || nArray[1] >= nArray[3]) {
            return;
        }
        Object object = this.startSequence(sunGraphics2D, rectangle2D, rectangle, nArray);
        if (region.isRectangular()) {
            this.renderBox(object, nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        } else {
            SpanIterator spanIterator = region.getSpanIterator(nArray);
            while (spanIterator.nextSpan(nArray)) {
                this.renderBox(object, nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
            }
        }
        this.endSequence(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderSpans(SunGraphics2D sunGraphics2D, Region region, Shape shape, ShapeSpanIterator shapeSpanIterator) {
        Rectangle rectangle;
        int[] nArray;
        Object object;
        block6: {
            object = null;
            nArray = new int[4];
            try {
                shapeSpanIterator.getPathBox(nArray);
                rectangle = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                region.clipBoxToBounds(nArray);
                if (nArray[0] < nArray[2] && nArray[1] < nArray[3]) break block6;
                if (object != null) {
                    this.endSequence(object);
                }
                return;
            }
            catch (Throwable throwable) {
                if (object != null) {
                    this.endSequence(object);
                }
                throw throwable;
            }
        }
        shapeSpanIterator.intersectClipBox(nArray[0], nArray[1], nArray[2], nArray[3]);
        object = this.startSequence(sunGraphics2D, shape, rectangle, nArray);
        this.spanClipLoop(object, shapeSpanIterator, region, nArray);
        if (object != null) {
            this.endSequence(object);
        }
    }

    public void spanClipLoop(Object object, SpanIterator spanIterator, Region region, int[] nArray) {
        if (!region.isRectangular()) {
            spanIterator = region.filter(spanIterator);
        }
        while (spanIterator.nextSpan(nArray)) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.renderBox(object, n, n2, nArray[2] - n, nArray[3] - n2);
        }
    }

    public static class Simple
    extends SpanShapeRenderer
    implements LoopBasedPipe {
        @Override
        public Object startSequence(SunGraphics2D sunGraphics2D, Shape shape, Rectangle rectangle, int[] nArray) {
            return sunGraphics2D;
        }

        @Override
        public void renderBox(Object object, int n, int n2, int n3, int n4) {
            SunGraphics2D sunGraphics2D = (SunGraphics2D)object;
            SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
            sunGraphics2D.loops.fillRectLoop.FillRect(sunGraphics2D, surfaceData, n, n2, n3, n4);
        }

        @Override
        public void endSequence(Object object) {
        }
    }

    public static class Composite
    extends SpanShapeRenderer {
        CompositePipe comppipe;

        public Composite(CompositePipe compositePipe) {
            this.comppipe = compositePipe;
        }

        @Override
        public Object startSequence(SunGraphics2D sunGraphics2D, Shape shape, Rectangle rectangle, int[] nArray) {
            return this.comppipe.startSequence(sunGraphics2D, shape, rectangle, nArray);
        }

        @Override
        public void renderBox(Object object, int n, int n2, int n3, int n4) {
            this.comppipe.renderPathTile(object, null, 0, n3, n, n2, n3, n4);
        }

        @Override
        public void endSequence(Object object) {
            this.comppipe.endSequence(object);
        }
    }
}

