/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicLong;

public class UniLogger<T>
extends UniOperator<T, T> {
    private final String identifier;
    private final AtomicLong increment = new AtomicLong(0L);

    public UniLogger(Uni<? extends T> upstream, String identifier) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        String id = ParameterValidation.nonNull(identifier, "identifier");
        if (id.isEmpty()) {
            throw new IllegalArgumentException("The identifier cannot be an empty string");
        }
        this.identifier = id;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniLoggerProcessor(subscriber, this.increment.getAndIncrement()));
    }

    private class UniLoggerProcessor
    extends UniOperatorProcessor<T, T> {
        private final String processorIdentifier;

        public UniLoggerProcessor(UniSubscriber<? super T> downstream, long increment) {
            super(downstream);
            this.processorIdentifier = UniLogger.this.identifier + "." + increment;
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (!this.isCancelled()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "onSubscribe", null, null);
                super.onSubscribe(subscription);
            }
        }

        @Override
        public void onItem(T item) {
            if (!this.isCancelled()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "onItem", item, null);
                super.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "onFailure", null, failure);
                super.onFailure(failure);
            }
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                Infrastructure.logFromOperator(this.processorIdentifier, "cancel", null, null);
                super.cancel();
            }
        }
    }
}

