/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Metrics;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4C7Oversion
extends T4CTTIfun {
    private static final String CLASS_NAME = T4C7Oversion.class.getName();
    static final long VSN_BANNER_FORMAT_BASE = 0L;
    static final long VSN_BANNER_FORMAT_FULL = 1L;
    byte[] rdbmsVersion = new byte[]{78, 111, 116, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 100, 32, 121, 101, 116};
    private final boolean rdbmsVersionO2U = true;
    private final int bufLen = 256;
    private final boolean retVerLenO2U = true;
    int retVerLen = 0;
    private final boolean retVerNumO2U = true;
    long retVerNum = 0L;

    T4C7Oversion(T4CConnection _connection) {
        super(_connection, (byte)3);
        this.setFunCode((short)59);
    }

    void doOVERSION() throws SQLException, IOException {
        this.begin(Metrics.ConnectionEvent.OVERSION);
        this.doRPC();
        this.end(Metrics.ConnectionEvent.OVERSION);
    }

    final CompletionStage<Void> doOVERSIONAsync() {
        return this.doRPCAsync();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.retVerLen = this.meg.unmarshalUB2();
        this.rdbmsVersion = this.meg.unmarshalCHR(this.retVerLen);
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "readRPA", "rdbms version num={0}", (String)null, (Throwable)null, (Object)new String(this.rdbmsVersion, StandardCharsets.US_ASCII));
        this.retVerNum = this.meg.unmarshalUB4();
    }

    @Override
    void processRPA() throws SQLException {
        if (this.rdbmsVersion == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
        }
    }

    byte[] getVersion() {
        return this.rdbmsVersion;
    }

    protected static final int serverReleaseRel(long v) {
        return (int)(v >>> 24 & 0xFFL);
    }

    protected static final int serverReleaseRelUpd(long v) {
        int ret = T4C7Oversion.serverReleaseRel(v) < 18 ? (int)(v >>> 20 & 0xFL) : (int)(v >>> 16 & 0xFFL);
        return ret;
    }

    private static final int serverReleaseRelUpdRev(long v) {
        int ret = T4C7Oversion.serverReleaseRel(v) < 18 ? (int)(v >>> 12 & 0xFFL) : (int)(v >>> 12 & 0xFL);
        return ret;
    }

    private static final int serverReleaseRelUpdInc(long v) {
        int ret = T4C7Oversion.serverReleaseRel(v) < 18 ? (int)(v >>> 8 & 0xFL) : (int)(v >>> 4 & 0xFFL);
        return ret;
    }

    short getVersionNumber() {
        int ver = 0;
        if ((ver += T4C7Oversion.serverReleaseRel(this.retVerNum) * 1000) < 18000) {
            ver += T4C7Oversion.serverReleaseRelUpd(this.retVerNum) * 100;
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getVersionNumber", "version num = {0}", (String)null, (Throwable)null, (Object)ver);
        return (short)ver;
    }

    long getVersionNumberasIs() {
        return this.retVerNum;
    }

    int getMajorVersionNumber() {
        return T4C7Oversion.serverReleaseRel(this.retVerNum);
    }

    int getMinorVersionNumber() {
        return T4C7Oversion.serverReleaseRelUpd(this.retVerNum);
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalO2U(true);
        this.meg.marshalSWORD(256);
        this.meg.marshalO2U(true);
        this.meg.marshalO2U(true);
        if (this.connection.getTTCVersion() >= 11) {
            this.meg.marshalUB4(1L);
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

