"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLAgentRouterRegistry = void 0;
var _ml_agent_router = require("./ml_agent_router");
var _chat_capabilities = require("../../../common/chat_capabilities");
var _generic_ml_router = require("./generic_ml_router");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
/**
 * Registry for ML agent routers
 * This handles the initialization and registration of available routers
 * based on the current environment capabilities
 */
class MLAgentRouterRegistry {
  /**
   * Initialize and register ML agent routers based on environment capabilities
   * This should be called once during plugin setup with current capabilities
   */
  static initialize(capabilities) {
    if (this.initialized) {
      return;
    }

    // Environment detection: register router based on capabilities
    if ((0, _chat_capabilities.hasInvestigationCapabilities)(capabilities)) {
      _ml_agent_router.MLAgentRouterFactory.registerRouter(new _generic_ml_router.GenericMLRouter());
    }
    this.initialized = true;
  }

  /**
   * Reset the registry (primarily for testing)
   */
  static reset() {
    _ml_agent_router.MLAgentRouterFactory.clearRouters();
    this.initialized = false;
  }

  /**
   * Check if the registry has been initialized
   */
  static isInitialized() {
    return this.initialized;
  }
}
exports.MLAgentRouterRegistry = MLAgentRouterRegistry;
_defineProperty(MLAgentRouterRegistry, "initialized", false);