/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Iterator;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.teoz.Bordered;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.skin.SkinParamBackcolored;
import net.sourceforge.plantuml.skin.SkinParamBackcoloredReference;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;

public class TileArguments
implements Bordered {
    private final StringBounder stringBounder;
    private final Real xorigin;
    private final Real yorigin;
    private final LivingSpaces livingSpaces;
    private final Rose skin;
    private final ISkinParam skinParam;
    private Bordered bordered;

    public TileArguments(StringBounder stringBounder, LivingSpaces livingSpaces, Rose skin, ISkinParam skinParam, Real xorigin, Real yorigin) {
        this.stringBounder = stringBounder;
        this.xorigin = xorigin;
        this.yorigin = yorigin;
        this.livingSpaces = livingSpaces;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    public TileArguments withBackColorGeneral(HColor backColorElement, HColor backColorGeneral) {
        return new TileArguments(this.stringBounder, this.livingSpaces, this.skin, new SkinParamBackcolored(this.skinParam, backColorElement, backColorGeneral), this.xorigin, this.yorigin);
    }

    public TileArguments withBackColor(Reference reference) {
        SkinParamBackcoloredReference newSkinParam = new SkinParamBackcoloredReference(this.skinParam, reference.getBackColorElement(), reference.getBackColorGeneral());
        return new TileArguments(this.stringBounder, this.livingSpaces, this.skin, newSkinParam, this.xorigin, this.yorigin);
    }

    public final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public final Real getXOrigin() {
        return this.xorigin;
    }

    public final Real getYOrigin() {
        return this.yorigin;
    }

    public final LivingSpaces getLivingSpaces() {
        return this.livingSpaces;
    }

    public final Rose getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public LivingSpace getLivingSpace(Participant p) {
        return this.livingSpaces.get(p);
    }

    public LivingSpace getFirstLivingSpace() {
        return this.livingSpaces.values().iterator().next();
    }

    public LivingSpace getLastLivingSpace() {
        LivingSpace result = null;
        Iterator<LivingSpace> iterator = this.livingSpaces.values().iterator();
        while (iterator.hasNext()) {
            LivingSpace v;
            result = v = iterator.next();
        }
        return result;
    }

    public void setBordered(Bordered bordered) {
        this.bordered = bordered;
    }

    @Override
    public double getBorder1() {
        return this.bordered.getBorder1();
    }

    @Override
    public double getBorder2() {
        return this.bordered.getBorder2();
    }
}

