// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from MKL26Z4.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && mkl26z4

/*
// MKL26Z4 NXP Microcontroller
*/
//     Redistribution and use in source and binary forms, with or without modification,\nare permitted provided that the following conditions are met:
//     o Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//     o Redistributions in binary form must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation and/or
//     other materials provided with the distribution.
//     o Neither the name of the copyright holder nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
//     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
//     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
//     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
//     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "MKL26Z4"
	CPU          = "CM0PLUS"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// DMA Controller
	IRQ_DMA0 = 0

	// DMA Controller
	IRQ_DMA1 = 1

	// DMA Controller
	IRQ_DMA2 = 2

	// DMA Controller
	IRQ_DMA3 = 3

	// Flash Memory Interface
	IRQ_FTFA = 5

	// Power Management Controller
	IRQ_LVD_LVW = 6

	// Low leakage wakeup unit
	IRQ_LLWU = 7

	// Inter-Integrated Circuit
	IRQ_I2C0 = 8

	// Inter-Integrated Circuit
	IRQ_I2C1 = 9

	// Serial Peripheral Interface
	IRQ_SPI0 = 10

	// Serial Peripheral Interface
	IRQ_SPI1 = 11

	// Universal Asynchronous Receiver/Transmitter
	IRQ_UART0 = 12

	// Universal Asynchronous Receiver/Transmitter (UART)
	IRQ_UART1 = 13

	// Universal Asynchronous Receiver/Transmitter (UART)
	IRQ_UART2 = 14

	// Analog-to-Digital Converter
	IRQ_ADC0 = 15

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	IRQ_CMP0 = 16

	// Timer/PWM Module
	IRQ_TPM0 = 17

	// Timer/PWM Module
	IRQ_TPM1 = 18

	// Timer/PWM Module
	IRQ_TPM2 = 19

	// Secure Real Time Clock
	IRQ_RTC = 20

	// Secure Real Time Clock
	IRQ_RTC_Seconds = 21

	// Periodic Interrupt Timer
	IRQ_PIT = 22

	// Inter-IC Sound / Synchronous Audio Interface
	IRQ_I2S0 = 23

	// Universal Serial Bus, OTG Capable Controller
	IRQ_USB0 = 24

	// 12-Bit Digital-to-Analog Converter
	IRQ_DAC0 = 25

	// Touch sense input
	IRQ_TSI0 = 26

	// Multipurpose Clock Generator module
	IRQ_MCG = 27

	// Low Power Timer
	IRQ_LPTMR0 = 28

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTA = 30

	// Pin Control and Interrupts // General Purpose Input/Output
	IRQ_PORTC_PORTD = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export DMA0_IRQHandler
func interruptDMA0() {
	callHandlers(IRQ_DMA0)
}

//export DMA1_IRQHandler
func interruptDMA1() {
	callHandlers(IRQ_DMA1)
}

//export DMA2_IRQHandler
func interruptDMA2() {
	callHandlers(IRQ_DMA2)
}

//export DMA3_IRQHandler
func interruptDMA3() {
	callHandlers(IRQ_DMA3)
}

//export FTFA_IRQHandler
func interruptFTFA() {
	callHandlers(IRQ_FTFA)
}

//export LVD_LVW_IRQHandler
func interruptLVD_LVW() {
	callHandlers(IRQ_LVD_LVW)
}

//export LLWU_IRQHandler
func interruptLLWU() {
	callHandlers(IRQ_LLWU)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export ADC0_IRQHandler
func interruptADC0() {
	callHandlers(IRQ_ADC0)
}

//export CMP0_IRQHandler
func interruptCMP0() {
	callHandlers(IRQ_CMP0)
}

//export TPM0_IRQHandler
func interruptTPM0() {
	callHandlers(IRQ_TPM0)
}

//export TPM1_IRQHandler
func interruptTPM1() {
	callHandlers(IRQ_TPM1)
}

//export TPM2_IRQHandler
func interruptTPM2() {
	callHandlers(IRQ_TPM2)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTC_Seconds_IRQHandler
func interruptRTC_Seconds() {
	callHandlers(IRQ_RTC_Seconds)
}

//export PIT_IRQHandler
func interruptPIT() {
	callHandlers(IRQ_PIT)
}

//export I2S0_IRQHandler
func interruptI2S0() {
	callHandlers(IRQ_I2S0)
}

//export USB0_IRQHandler
func interruptUSB0() {
	callHandlers(IRQ_USB0)
}

//export DAC0_IRQHandler
func interruptDAC0() {
	callHandlers(IRQ_DAC0)
}

//export TSI0_IRQHandler
func interruptTSI0() {
	callHandlers(IRQ_TSI0)
}

//export MCG_IRQHandler
func interruptMCG() {
	callHandlers(IRQ_MCG)
}

//export LPTMR0_IRQHandler
func interruptLPTMR0() {
	callHandlers(IRQ_LPTMR0)
}

//export PORTA_IRQHandler
func interruptPORTA() {
	callHandlers(IRQ_PORTA)
}

//export PORTC_PORTD_IRQHandler
func interruptPORTC_PORTD() {
	callHandlers(IRQ_PORTC_PORTD)
}

// Peripherals.
var (
	// Flash configuration field
	FTFA_FlashConfig = (*FTFA_FlashConfig_Type)(unsafe.Pointer(uintptr(0x400)))

	// DMA Controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Flash Memory Interface
	FTFA = (*FTFA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// DMA channel multiplexor
	DMAMUX0 = (*DMAMUX0_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Inter-IC Sound / Synchronous Audio Interface
	I2S0 = (*I2S0_Type)(unsafe.Pointer(uintptr(0x4002f000)))

	// Periodic Interrupt Timer
	PIT = (*PIT_Type)(unsafe.Pointer(uintptr(0x40037000)))

	// Timer/PWM Module
	TPM0 = (*TPM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Timer/PWM Module
	TPM1 = (*TPM_Type)(unsafe.Pointer(uintptr(0x40039000)))

	// Timer/PWM Module
	TPM2 = (*TPM_Type)(unsafe.Pointer(uintptr(0x4003a000)))

	// Analog-to-Digital Converter
	ADC0 = (*ADC0_Type)(unsafe.Pointer(uintptr(0x4003b000)))

	// Secure Real Time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4003d000)))

	// 12-Bit Digital-to-Analog Converter
	DAC0 = (*DAC0_Type)(unsafe.Pointer(uintptr(0x4003f000)))

	// Low Power Timer
	LPTMR0 = (*LPTMR0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Touch sense input
	TSI0 = (*TSI0_Type)(unsafe.Pointer(uintptr(0x40045000)))

	// System Integration Module
	SIM = (*SIM_Type)(unsafe.Pointer(uintptr(0x40047000)))

	// Pin Control and Interrupts
	PORTA = (*PORT_Type)(unsafe.Pointer(uintptr(0x40049000)))

	// Pin Control and Interrupts
	PORTB = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004a000)))

	// Pin Control and Interrupts
	PORTC = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004b000)))

	// Pin Control and Interrupts
	PORTD = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// Pin Control and Interrupts
	PORTE = (*PORT_Type)(unsafe.Pointer(uintptr(0x4004d000)))

	// Multipurpose Clock Generator module
	MCG = (*MCG_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Oscillator
	OSC0 = (*OSC0_Type)(unsafe.Pointer(uintptr(0x40065000)))

	// Inter-Integrated Circuit
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40066000)))

	// Inter-Integrated Circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40067000)))

	// Universal Asynchronous Receiver/Transmitter
	UART0 = (*UART0_Type)(unsafe.Pointer(uintptr(0x4006a000)))

	// Universal Asynchronous Receiver/Transmitter (UART)
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006b000)))

	// Universal Asynchronous Receiver/Transmitter (UART)
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// Universal Serial Bus, OTG Capable Controller
	USB0 = (*USB0_Type)(unsafe.Pointer(uintptr(0x40072000)))

	// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
	CMP0 = (*CMP0_Type)(unsafe.Pointer(uintptr(0x40073000)))

	// Serial Peripheral Interface
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40076000)))

	// Serial Peripheral Interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40077000)))

	// Low leakage wakeup unit
	LLWU = (*LLWU_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x4007d000)))

	// System Mode Controller
	SMC = (*SMC_Type)(unsafe.Pointer(uintptr(0x4007e000)))

	// Reset Control Module
	RCM = (*RCM_Type)(unsafe.Pointer(uintptr(0x4007f000)))

	// General Purpose Input/Output
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff000)))

	// General Purpose Input/Output
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff040)))

	// General Purpose Input/Output
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff080)))

	// General Purpose Input/Output
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff0c0)))

	// General Purpose Input/Output
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x400ff100)))

	// System Control Block
	SystemControl = (*SystemControl_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Micro Trace Buffer
	MTB = (*MTB_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// MTB data watchpoint and trace
	MTBDWT = (*MTBDWT_Type)(unsafe.Pointer(uintptr(0xf0001000)))

	// System ROM
	ROM = (*ROM_Type)(unsafe.Pointer(uintptr(0xf0002000)))

	// Core Platform Miscellaneous Control Module
	MCM = (*MCM_Type)(unsafe.Pointer(uintptr(0xf0003000)))

	// General Purpose Input/Output
	FGPIOA = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000000)))

	// General Purpose Input/Output
	FGPIOB = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000040)))

	// General Purpose Input/Output
	FGPIOC = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000080)))

	// General Purpose Input/Output
	FGPIOD = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf80000c0)))

	// General Purpose Input/Output
	FGPIOE = (*FGPIO_Type)(unsafe.Pointer(uintptr(0xf8000100)))
)

// Flash configuration field
type FTFA_FlashConfig_Type struct {
	BACKKEY3 volatile.Register8 // 0x0
	BACKKEY2 volatile.Register8 // 0x1
	BACKKEY1 volatile.Register8 // 0x2
	BACKKEY0 volatile.Register8 // 0x3
	BACKKEY7 volatile.Register8 // 0x4
	BACKKEY6 volatile.Register8 // 0x5
	BACKKEY5 volatile.Register8 // 0x6
	BACKKEY4 volatile.Register8 // 0x7
	FPROT3   volatile.Register8 // 0x8
	FPROT2   volatile.Register8 // 0x9
	FPROT1   volatile.Register8 // 0xA
	FPROT0   volatile.Register8 // 0xB
	FSEC     volatile.Register8 // 0xC
	FOPT     volatile.Register8 // 0xD
}

// FTFA_FlashConfig.BACKKEY3: Backdoor Comparison Key 3.
func (o *FTFA_FlashConfig_Type) SetBACKKEY3(value uint8) {
	volatile.StoreUint8(&o.BACKKEY3.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY3() uint8 {
	return volatile.LoadUint8(&o.BACKKEY3.Reg)
}

// FTFA_FlashConfig.BACKKEY2: Backdoor Comparison Key 2.
func (o *FTFA_FlashConfig_Type) SetBACKKEY2(value uint8) {
	volatile.StoreUint8(&o.BACKKEY2.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY2() uint8 {
	return volatile.LoadUint8(&o.BACKKEY2.Reg)
}

// FTFA_FlashConfig.BACKKEY1: Backdoor Comparison Key 1.
func (o *FTFA_FlashConfig_Type) SetBACKKEY1(value uint8) {
	volatile.StoreUint8(&o.BACKKEY1.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY1() uint8 {
	return volatile.LoadUint8(&o.BACKKEY1.Reg)
}

// FTFA_FlashConfig.BACKKEY0: Backdoor Comparison Key 0.
func (o *FTFA_FlashConfig_Type) SetBACKKEY0(value uint8) {
	volatile.StoreUint8(&o.BACKKEY0.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY0() uint8 {
	return volatile.LoadUint8(&o.BACKKEY0.Reg)
}

// FTFA_FlashConfig.BACKKEY7: Backdoor Comparison Key 7.
func (o *FTFA_FlashConfig_Type) SetBACKKEY7(value uint8) {
	volatile.StoreUint8(&o.BACKKEY7.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY7() uint8 {
	return volatile.LoadUint8(&o.BACKKEY7.Reg)
}

// FTFA_FlashConfig.BACKKEY6: Backdoor Comparison Key 6.
func (o *FTFA_FlashConfig_Type) SetBACKKEY6(value uint8) {
	volatile.StoreUint8(&o.BACKKEY6.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY6() uint8 {
	return volatile.LoadUint8(&o.BACKKEY6.Reg)
}

// FTFA_FlashConfig.BACKKEY5: Backdoor Comparison Key 5.
func (o *FTFA_FlashConfig_Type) SetBACKKEY5(value uint8) {
	volatile.StoreUint8(&o.BACKKEY5.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY5() uint8 {
	return volatile.LoadUint8(&o.BACKKEY5.Reg)
}

// FTFA_FlashConfig.BACKKEY4: Backdoor Comparison Key 4.
func (o *FTFA_FlashConfig_Type) SetBACKKEY4(value uint8) {
	volatile.StoreUint8(&o.BACKKEY4.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetBACKKEY4() uint8 {
	return volatile.LoadUint8(&o.BACKKEY4.Reg)
}

// FTFA_FlashConfig.FPROT3: Non-volatile P-Flash Protection 1 - Low Register
func (o *FTFA_FlashConfig_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFA_FlashConfig.FPROT2: Non-volatile P-Flash Protection 1 - High Register
func (o *FTFA_FlashConfig_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFA_FlashConfig.FPROT1: Non-volatile P-Flash Protection 0 - Low Register
func (o *FTFA_FlashConfig_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFA_FlashConfig.FPROT0: Non-volatile P-Flash Protection 0 - High Register
func (o *FTFA_FlashConfig_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFA_FlashConfig_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// FTFA_FlashConfig.FSEC: Non-volatile Flash Security Register
func (o *FTFA_FlashConfig_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFA_FlashConfig_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFA_FlashConfig_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFA_FlashConfig_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFA_FlashConfig_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFA_FlashConfig.FOPT: Non-volatile Flash Option Register
func (o *FTFA_FlashConfig_Type) SetFOPT_LPBOOT0(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x1)|value)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_LPBOOT0() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg) & 0x1
}
func (o *FTFA_FlashConfig_Type) SetFOPT_NMI_DIS(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x4)|value<<2)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_NMI_DIS() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x4) >> 2
}
func (o *FTFA_FlashConfig_Type) SetFOPT_RESET_PIN_CFG(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x8)|value<<3)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_RESET_PIN_CFG() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x8) >> 3
}
func (o *FTFA_FlashConfig_Type) SetFOPT_LPBOOT1(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_LPBOOT1() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x10) >> 4
}
func (o *FTFA_FlashConfig_Type) SetFOPT_FAST_INIT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, volatile.LoadUint8(&o.FOPT.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_FlashConfig_Type) GetFOPT_FAST_INIT() uint8 {
	return (volatile.LoadUint8(&o.FOPT.Reg) & 0x20) >> 5
}

// DMA Controller
type DMA_Type struct {
	_        [256]byte
	SAR0     volatile.Register32 // 0x100
	DAR0     volatile.Register32 // 0x104
	DSR_BCR0 volatile.Register32 // 0x108
	DCR0     volatile.Register32 // 0x10C
	SAR1     volatile.Register32 // 0x110
	DAR1     volatile.Register32 // 0x114
	DSR_BCR1 volatile.Register32 // 0x118
	DCR1     volatile.Register32 // 0x11C
	SAR2     volatile.Register32 // 0x120
	DAR2     volatile.Register32 // 0x124
	DSR_BCR2 volatile.Register32 // 0x128
	DCR2     volatile.Register32 // 0x12C
	SAR3     volatile.Register32 // 0x130
	DAR3     volatile.Register32 // 0x134
	DSR_BCR3 volatile.Register32 // 0x138
	DCR3     volatile.Register32 // 0x13C
}

// DMA.SAR0: Source Address Register
func (o *DMA_Type) SetSAR0(value uint32) {
	volatile.StoreUint32(&o.SAR0.Reg, value)
}
func (o *DMA_Type) GetSAR0() uint32 {
	return volatile.LoadUint32(&o.SAR0.Reg)
}

// DMA.DAR0: Destination Address Register
func (o *DMA_Type) SetDAR0(value uint32) {
	volatile.StoreUint32(&o.DAR0.Reg, value)
}
func (o *DMA_Type) GetDAR0() uint32 {
	return volatile.LoadUint32(&o.DAR0.Reg)
}

// DMA.DSR_BCR0: DMA Status Register / Byte Count Register
func (o *DMA_Type) SetDSR_BCR0_BCR(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR0.Reg, volatile.LoadUint32(&o.DSR_BCR0.Reg)&^(0xffffff)|value)
}
func (o *DMA_Type) GetDSR_BCR0_BCR() uint32 {
	return volatile.LoadUint32(&o.DSR_BCR0.Reg) & 0xffffff
}
func (o *DMA_Type) SetDSR_BCR0_DONE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR0.Reg, volatile.LoadUint32(&o.DSR_BCR0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetDSR_BCR0_DONE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetDSR_BCR0_BSY(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR0.Reg, volatile.LoadUint32(&o.DSR_BCR0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetDSR_BCR0_BSY() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetDSR_BCR0_REQ(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR0.Reg, volatile.LoadUint32(&o.DSR_BCR0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetDSR_BCR0_REQ() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR0.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetDSR_BCR0_BED(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR0.Reg, volatile.LoadUint32(&o.DSR_BCR0.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDSR_BCR0_BED() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR0.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDSR_BCR0_BES(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR0.Reg, volatile.LoadUint32(&o.DSR_BCR0.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDSR_BCR0_BES() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR0.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDSR_BCR0_CE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR0.Reg, volatile.LoadUint32(&o.DSR_BCR0.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDSR_BCR0_CE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR0.Reg) & 0x40000000) >> 30
}

// DMA.DCR0: DMA Control Register
func (o *DMA_Type) SetDCR0_LCH2(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCR0_LCH2() uint32 {
	return volatile.LoadUint32(&o.DCR0.Reg) & 0x3
}
func (o *DMA_Type) SetDCR0_LCH1(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetDCR0_LCH1() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetDCR0_LINKCC(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetDCR0_LINKCC() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x30) >> 4
}
func (o *DMA_Type) SetDCR0_D_REQ(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCR0_D_REQ() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetDCR0_DMOD(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetDCR0_DMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetDCR0_SMOD(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0xf000)|value<<12)
}
func (o *DMA_Type) GetDCR0_SMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0xf000) >> 12
}
func (o *DMA_Type) SetDCR0_START(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetDCR0_START() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetDCR0_DSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x60000)|value<<17)
}
func (o *DMA_Type) GetDCR0_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x60000) >> 17
}
func (o *DMA_Type) SetDCR0_DINC(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetDCR0_DINC() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetDCR0_SSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x300000)|value<<20)
}
func (o *DMA_Type) GetDCR0_SSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x300000) >> 20
}
func (o *DMA_Type) SetDCR0_SINC(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetDCR0_SINC() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetDCR0_EADREQ(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetDCR0_EADREQ() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetDCR0_AA(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDCR0_AA() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDCR0_CS(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDCR0_CS() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDCR0_ERQ(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDCR0_ERQ() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x40000000) >> 30
}
func (o *DMA_Type) SetDCR0_EINT(value uint32) {
	volatile.StoreUint32(&o.DCR0.Reg, volatile.LoadUint32(&o.DCR0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetDCR0_EINT() uint32 {
	return (volatile.LoadUint32(&o.DCR0.Reg) & 0x80000000) >> 31
}

// DMA.SAR1: Source Address Register
func (o *DMA_Type) SetSAR1(value uint32) {
	volatile.StoreUint32(&o.SAR1.Reg, value)
}
func (o *DMA_Type) GetSAR1() uint32 {
	return volatile.LoadUint32(&o.SAR1.Reg)
}

// DMA.DAR1: Destination Address Register
func (o *DMA_Type) SetDAR1(value uint32) {
	volatile.StoreUint32(&o.DAR1.Reg, value)
}
func (o *DMA_Type) GetDAR1() uint32 {
	return volatile.LoadUint32(&o.DAR1.Reg)
}

// DMA.DSR_BCR1: DMA Status Register / Byte Count Register
func (o *DMA_Type) SetDSR_BCR1_BCR(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR1.Reg, volatile.LoadUint32(&o.DSR_BCR1.Reg)&^(0xffffff)|value)
}
func (o *DMA_Type) GetDSR_BCR1_BCR() uint32 {
	return volatile.LoadUint32(&o.DSR_BCR1.Reg) & 0xffffff
}
func (o *DMA_Type) SetDSR_BCR1_DONE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR1.Reg, volatile.LoadUint32(&o.DSR_BCR1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetDSR_BCR1_DONE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR1.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetDSR_BCR1_BSY(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR1.Reg, volatile.LoadUint32(&o.DSR_BCR1.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetDSR_BCR1_BSY() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR1.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetDSR_BCR1_REQ(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR1.Reg, volatile.LoadUint32(&o.DSR_BCR1.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetDSR_BCR1_REQ() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR1.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetDSR_BCR1_BED(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR1.Reg, volatile.LoadUint32(&o.DSR_BCR1.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDSR_BCR1_BED() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR1.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDSR_BCR1_BES(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR1.Reg, volatile.LoadUint32(&o.DSR_BCR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDSR_BCR1_BES() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR1.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDSR_BCR1_CE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR1.Reg, volatile.LoadUint32(&o.DSR_BCR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDSR_BCR1_CE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR1.Reg) & 0x40000000) >> 30
}

// DMA.DCR1: DMA Control Register
func (o *DMA_Type) SetDCR1_LCH2(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCR1_LCH2() uint32 {
	return volatile.LoadUint32(&o.DCR1.Reg) & 0x3
}
func (o *DMA_Type) SetDCR1_LCH1(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetDCR1_LCH1() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetDCR1_LINKCC(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetDCR1_LINKCC() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x30) >> 4
}
func (o *DMA_Type) SetDCR1_D_REQ(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCR1_D_REQ() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetDCR1_DMOD(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetDCR1_DMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetDCR1_SMOD(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0xf000)|value<<12)
}
func (o *DMA_Type) GetDCR1_SMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0xf000) >> 12
}
func (o *DMA_Type) SetDCR1_START(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetDCR1_START() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetDCR1_DSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x60000)|value<<17)
}
func (o *DMA_Type) GetDCR1_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x60000) >> 17
}
func (o *DMA_Type) SetDCR1_DINC(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetDCR1_DINC() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetDCR1_SSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x300000)|value<<20)
}
func (o *DMA_Type) GetDCR1_SSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x300000) >> 20
}
func (o *DMA_Type) SetDCR1_SINC(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetDCR1_SINC() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetDCR1_EADREQ(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetDCR1_EADREQ() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetDCR1_AA(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDCR1_AA() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDCR1_CS(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDCR1_CS() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDCR1_ERQ(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDCR1_ERQ() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x40000000) >> 30
}
func (o *DMA_Type) SetDCR1_EINT(value uint32) {
	volatile.StoreUint32(&o.DCR1.Reg, volatile.LoadUint32(&o.DCR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetDCR1_EINT() uint32 {
	return (volatile.LoadUint32(&o.DCR1.Reg) & 0x80000000) >> 31
}

// DMA.SAR2: Source Address Register
func (o *DMA_Type) SetSAR2(value uint32) {
	volatile.StoreUint32(&o.SAR2.Reg, value)
}
func (o *DMA_Type) GetSAR2() uint32 {
	return volatile.LoadUint32(&o.SAR2.Reg)
}

// DMA.DAR2: Destination Address Register
func (o *DMA_Type) SetDAR2(value uint32) {
	volatile.StoreUint32(&o.DAR2.Reg, value)
}
func (o *DMA_Type) GetDAR2() uint32 {
	return volatile.LoadUint32(&o.DAR2.Reg)
}

// DMA.DSR_BCR2: DMA Status Register / Byte Count Register
func (o *DMA_Type) SetDSR_BCR2_BCR(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR2.Reg, volatile.LoadUint32(&o.DSR_BCR2.Reg)&^(0xffffff)|value)
}
func (o *DMA_Type) GetDSR_BCR2_BCR() uint32 {
	return volatile.LoadUint32(&o.DSR_BCR2.Reg) & 0xffffff
}
func (o *DMA_Type) SetDSR_BCR2_DONE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR2.Reg, volatile.LoadUint32(&o.DSR_BCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetDSR_BCR2_DONE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR2.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetDSR_BCR2_BSY(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR2.Reg, volatile.LoadUint32(&o.DSR_BCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetDSR_BCR2_BSY() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR2.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetDSR_BCR2_REQ(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR2.Reg, volatile.LoadUint32(&o.DSR_BCR2.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetDSR_BCR2_REQ() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR2.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetDSR_BCR2_BED(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR2.Reg, volatile.LoadUint32(&o.DSR_BCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDSR_BCR2_BED() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR2.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDSR_BCR2_BES(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR2.Reg, volatile.LoadUint32(&o.DSR_BCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDSR_BCR2_BES() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR2.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDSR_BCR2_CE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR2.Reg, volatile.LoadUint32(&o.DSR_BCR2.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDSR_BCR2_CE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR2.Reg) & 0x40000000) >> 30
}

// DMA.DCR2: DMA Control Register
func (o *DMA_Type) SetDCR2_LCH2(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCR2_LCH2() uint32 {
	return volatile.LoadUint32(&o.DCR2.Reg) & 0x3
}
func (o *DMA_Type) SetDCR2_LCH1(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetDCR2_LCH1() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetDCR2_LINKCC(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetDCR2_LINKCC() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x30) >> 4
}
func (o *DMA_Type) SetDCR2_D_REQ(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCR2_D_REQ() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetDCR2_DMOD(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetDCR2_DMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetDCR2_SMOD(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0xf000)|value<<12)
}
func (o *DMA_Type) GetDCR2_SMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0xf000) >> 12
}
func (o *DMA_Type) SetDCR2_START(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetDCR2_START() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetDCR2_DSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x60000)|value<<17)
}
func (o *DMA_Type) GetDCR2_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x60000) >> 17
}
func (o *DMA_Type) SetDCR2_DINC(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetDCR2_DINC() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetDCR2_SSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x300000)|value<<20)
}
func (o *DMA_Type) GetDCR2_SSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x300000) >> 20
}
func (o *DMA_Type) SetDCR2_SINC(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetDCR2_SINC() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetDCR2_EADREQ(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetDCR2_EADREQ() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetDCR2_AA(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDCR2_AA() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDCR2_CS(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDCR2_CS() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDCR2_ERQ(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDCR2_ERQ() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x40000000) >> 30
}
func (o *DMA_Type) SetDCR2_EINT(value uint32) {
	volatile.StoreUint32(&o.DCR2.Reg, volatile.LoadUint32(&o.DCR2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetDCR2_EINT() uint32 {
	return (volatile.LoadUint32(&o.DCR2.Reg) & 0x80000000) >> 31
}

// DMA.SAR3: Source Address Register
func (o *DMA_Type) SetSAR3(value uint32) {
	volatile.StoreUint32(&o.SAR3.Reg, value)
}
func (o *DMA_Type) GetSAR3() uint32 {
	return volatile.LoadUint32(&o.SAR3.Reg)
}

// DMA.DAR3: Destination Address Register
func (o *DMA_Type) SetDAR3(value uint32) {
	volatile.StoreUint32(&o.DAR3.Reg, value)
}
func (o *DMA_Type) GetDAR3() uint32 {
	return volatile.LoadUint32(&o.DAR3.Reg)
}

// DMA.DSR_BCR3: DMA Status Register / Byte Count Register
func (o *DMA_Type) SetDSR_BCR3_BCR(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR3.Reg, volatile.LoadUint32(&o.DSR_BCR3.Reg)&^(0xffffff)|value)
}
func (o *DMA_Type) GetDSR_BCR3_BCR() uint32 {
	return volatile.LoadUint32(&o.DSR_BCR3.Reg) & 0xffffff
}
func (o *DMA_Type) SetDSR_BCR3_DONE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR3.Reg, volatile.LoadUint32(&o.DSR_BCR3.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetDSR_BCR3_DONE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR3.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetDSR_BCR3_BSY(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR3.Reg, volatile.LoadUint32(&o.DSR_BCR3.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetDSR_BCR3_BSY() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR3.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetDSR_BCR3_REQ(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR3.Reg, volatile.LoadUint32(&o.DSR_BCR3.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetDSR_BCR3_REQ() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR3.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetDSR_BCR3_BED(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR3.Reg, volatile.LoadUint32(&o.DSR_BCR3.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDSR_BCR3_BED() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR3.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDSR_BCR3_BES(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR3.Reg, volatile.LoadUint32(&o.DSR_BCR3.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDSR_BCR3_BES() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR3.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDSR_BCR3_CE(value uint32) {
	volatile.StoreUint32(&o.DSR_BCR3.Reg, volatile.LoadUint32(&o.DSR_BCR3.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDSR_BCR3_CE() uint32 {
	return (volatile.LoadUint32(&o.DSR_BCR3.Reg) & 0x40000000) >> 30
}

// DMA.DCR3: DMA Control Register
func (o *DMA_Type) SetDCR3_LCH2(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x3)|value)
}
func (o *DMA_Type) GetDCR3_LCH2() uint32 {
	return volatile.LoadUint32(&o.DCR3.Reg) & 0x3
}
func (o *DMA_Type) SetDCR3_LCH1(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0xc)|value<<2)
}
func (o *DMA_Type) GetDCR3_LCH1() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0xc) >> 2
}
func (o *DMA_Type) SetDCR3_LINKCC(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetDCR3_LINKCC() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x30) >> 4
}
func (o *DMA_Type) SetDCR3_D_REQ(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetDCR3_D_REQ() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetDCR3_DMOD(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0xf00)|value<<8)
}
func (o *DMA_Type) GetDCR3_DMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0xf00) >> 8
}
func (o *DMA_Type) SetDCR3_SMOD(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0xf000)|value<<12)
}
func (o *DMA_Type) GetDCR3_SMOD() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0xf000) >> 12
}
func (o *DMA_Type) SetDCR3_START(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetDCR3_START() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetDCR3_DSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x60000)|value<<17)
}
func (o *DMA_Type) GetDCR3_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x60000) >> 17
}
func (o *DMA_Type) SetDCR3_DINC(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetDCR3_DINC() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetDCR3_SSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x300000)|value<<20)
}
func (o *DMA_Type) GetDCR3_SSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x300000) >> 20
}
func (o *DMA_Type) SetDCR3_SINC(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetDCR3_SINC() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetDCR3_EADREQ(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetDCR3_EADREQ() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetDCR3_AA(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x10000000)|value<<28)
}
func (o *DMA_Type) GetDCR3_AA() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x10000000) >> 28
}
func (o *DMA_Type) SetDCR3_CS(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x20000000)|value<<29)
}
func (o *DMA_Type) GetDCR3_CS() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x20000000) >> 29
}
func (o *DMA_Type) SetDCR3_ERQ(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x40000000)|value<<30)
}
func (o *DMA_Type) GetDCR3_ERQ() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x40000000) >> 30
}
func (o *DMA_Type) SetDCR3_EINT(value uint32) {
	volatile.StoreUint32(&o.DCR3.Reg, volatile.LoadUint32(&o.DCR3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMA_Type) GetDCR3_EINT() uint32 {
	return (volatile.LoadUint32(&o.DCR3.Reg) & 0x80000000) >> 31
}

// Flash Memory Interface
type FTFA_Type struct {
	FSTAT  volatile.Register8 // 0x0
	FCNFG  volatile.Register8 // 0x1
	FSEC   volatile.Register8 // 0x2
	FOPT   volatile.Register8 // 0x3
	FCCOB3 volatile.Register8 // 0x4
	FCCOB2 volatile.Register8 // 0x5
	FCCOB1 volatile.Register8 // 0x6
	FCCOB0 volatile.Register8 // 0x7
	FCCOB7 volatile.Register8 // 0x8
	FCCOB6 volatile.Register8 // 0x9
	FCCOB5 volatile.Register8 // 0xA
	FCCOB4 volatile.Register8 // 0xB
	FCCOBB volatile.Register8 // 0xC
	FCCOBA volatile.Register8 // 0xD
	FCCOB9 volatile.Register8 // 0xE
	FCCOB8 volatile.Register8 // 0xF
	FPROT3 volatile.Register8 // 0x10
	FPROT2 volatile.Register8 // 0x11
	FPROT1 volatile.Register8 // 0x12
	FPROT0 volatile.Register8 // 0x13
}

// FTFA.FSTAT: Flash Status Register
func (o *FTFA_Type) SetFSTAT_MGSTAT0(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x1)|value)
}
func (o *FTFA_Type) GetFSTAT_MGSTAT0() uint8 {
	return volatile.LoadUint8(&o.FSTAT.Reg) & 0x1
}
func (o *FTFA_Type) SetFSTAT_FPVIOL(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_Type) GetFSTAT_FPVIOL() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x10) >> 4
}
func (o *FTFA_Type) SetFSTAT_ACCERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_Type) GetFSTAT_ACCERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x20) >> 5
}
func (o *FTFA_Type) SetFSTAT_RDCOLERR(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x40)|value<<6)
}
func (o *FTFA_Type) GetFSTAT_RDCOLERR() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x40) >> 6
}
func (o *FTFA_Type) SetFSTAT_CCIF(value uint8) {
	volatile.StoreUint8(&o.FSTAT.Reg, volatile.LoadUint8(&o.FSTAT.Reg)&^(0x80)|value<<7)
}
func (o *FTFA_Type) GetFSTAT_CCIF() uint8 {
	return (volatile.LoadUint8(&o.FSTAT.Reg) & 0x80) >> 7
}

// FTFA.FCNFG: Flash Configuration Register
func (o *FTFA_Type) SetFCNFG_ERSSUSP(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x10)|value<<4)
}
func (o *FTFA_Type) GetFCNFG_ERSSUSP() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x10) >> 4
}
func (o *FTFA_Type) SetFCNFG_ERSAREQ(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x20)|value<<5)
}
func (o *FTFA_Type) GetFCNFG_ERSAREQ() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x20) >> 5
}
func (o *FTFA_Type) SetFCNFG_RDCOLLIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x40)|value<<6)
}
func (o *FTFA_Type) GetFCNFG_RDCOLLIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x40) >> 6
}
func (o *FTFA_Type) SetFCNFG_CCIE(value uint8) {
	volatile.StoreUint8(&o.FCNFG.Reg, volatile.LoadUint8(&o.FCNFG.Reg)&^(0x80)|value<<7)
}
func (o *FTFA_Type) GetFCNFG_CCIE() uint8 {
	return (volatile.LoadUint8(&o.FCNFG.Reg) & 0x80) >> 7
}

// FTFA.FSEC: Flash Security Register
func (o *FTFA_Type) SetFSEC_SEC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x3)|value)
}
func (o *FTFA_Type) GetFSEC_SEC() uint8 {
	return volatile.LoadUint8(&o.FSEC.Reg) & 0x3
}
func (o *FTFA_Type) SetFSEC_FSLACC(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc)|value<<2)
}
func (o *FTFA_Type) GetFSEC_FSLACC() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc) >> 2
}
func (o *FTFA_Type) SetFSEC_MEEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0x30)|value<<4)
}
func (o *FTFA_Type) GetFSEC_MEEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0x30) >> 4
}
func (o *FTFA_Type) SetFSEC_KEYEN(value uint8) {
	volatile.StoreUint8(&o.FSEC.Reg, volatile.LoadUint8(&o.FSEC.Reg)&^(0xc0)|value<<6)
}
func (o *FTFA_Type) GetFSEC_KEYEN() uint8 {
	return (volatile.LoadUint8(&o.FSEC.Reg) & 0xc0) >> 6
}

// FTFA.FOPT: Flash Option Register
func (o *FTFA_Type) SetFOPT(value uint8) {
	volatile.StoreUint8(&o.FOPT.Reg, value)
}
func (o *FTFA_Type) GetFOPT() uint8 {
	return volatile.LoadUint8(&o.FOPT.Reg)
}

// FTFA.FCCOB3: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB3(value uint8) {
	volatile.StoreUint8(&o.FCCOB3.Reg, value)
}
func (o *FTFA_Type) GetFCCOB3() uint8 {
	return volatile.LoadUint8(&o.FCCOB3.Reg)
}

// FTFA.FCCOB2: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB2(value uint8) {
	volatile.StoreUint8(&o.FCCOB2.Reg, value)
}
func (o *FTFA_Type) GetFCCOB2() uint8 {
	return volatile.LoadUint8(&o.FCCOB2.Reg)
}

// FTFA.FCCOB1: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB1(value uint8) {
	volatile.StoreUint8(&o.FCCOB1.Reg, value)
}
func (o *FTFA_Type) GetFCCOB1() uint8 {
	return volatile.LoadUint8(&o.FCCOB1.Reg)
}

// FTFA.FCCOB0: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB0(value uint8) {
	volatile.StoreUint8(&o.FCCOB0.Reg, value)
}
func (o *FTFA_Type) GetFCCOB0() uint8 {
	return volatile.LoadUint8(&o.FCCOB0.Reg)
}

// FTFA.FCCOB7: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB7(value uint8) {
	volatile.StoreUint8(&o.FCCOB7.Reg, value)
}
func (o *FTFA_Type) GetFCCOB7() uint8 {
	return volatile.LoadUint8(&o.FCCOB7.Reg)
}

// FTFA.FCCOB6: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB6(value uint8) {
	volatile.StoreUint8(&o.FCCOB6.Reg, value)
}
func (o *FTFA_Type) GetFCCOB6() uint8 {
	return volatile.LoadUint8(&o.FCCOB6.Reg)
}

// FTFA.FCCOB5: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB5(value uint8) {
	volatile.StoreUint8(&o.FCCOB5.Reg, value)
}
func (o *FTFA_Type) GetFCCOB5() uint8 {
	return volatile.LoadUint8(&o.FCCOB5.Reg)
}

// FTFA.FCCOB4: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB4(value uint8) {
	volatile.StoreUint8(&o.FCCOB4.Reg, value)
}
func (o *FTFA_Type) GetFCCOB4() uint8 {
	return volatile.LoadUint8(&o.FCCOB4.Reg)
}

// FTFA.FCCOBB: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOBB(value uint8) {
	volatile.StoreUint8(&o.FCCOBB.Reg, value)
}
func (o *FTFA_Type) GetFCCOBB() uint8 {
	return volatile.LoadUint8(&o.FCCOBB.Reg)
}

// FTFA.FCCOBA: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOBA(value uint8) {
	volatile.StoreUint8(&o.FCCOBA.Reg, value)
}
func (o *FTFA_Type) GetFCCOBA() uint8 {
	return volatile.LoadUint8(&o.FCCOBA.Reg)
}

// FTFA.FCCOB9: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB9(value uint8) {
	volatile.StoreUint8(&o.FCCOB9.Reg, value)
}
func (o *FTFA_Type) GetFCCOB9() uint8 {
	return volatile.LoadUint8(&o.FCCOB9.Reg)
}

// FTFA.FCCOB8: Flash Common Command Object Registers
func (o *FTFA_Type) SetFCCOB8(value uint8) {
	volatile.StoreUint8(&o.FCCOB8.Reg, value)
}
func (o *FTFA_Type) GetFCCOB8() uint8 {
	return volatile.LoadUint8(&o.FCCOB8.Reg)
}

// FTFA.FPROT3: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT3(value uint8) {
	volatile.StoreUint8(&o.FPROT3.Reg, value)
}
func (o *FTFA_Type) GetFPROT3() uint8 {
	return volatile.LoadUint8(&o.FPROT3.Reg)
}

// FTFA.FPROT2: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT2(value uint8) {
	volatile.StoreUint8(&o.FPROT2.Reg, value)
}
func (o *FTFA_Type) GetFPROT2() uint8 {
	return volatile.LoadUint8(&o.FPROT2.Reg)
}

// FTFA.FPROT1: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT1(value uint8) {
	volatile.StoreUint8(&o.FPROT1.Reg, value)
}
func (o *FTFA_Type) GetFPROT1() uint8 {
	return volatile.LoadUint8(&o.FPROT1.Reg)
}

// FTFA.FPROT0: Program Flash Protection Registers
func (o *FTFA_Type) SetFPROT0(value uint8) {
	volatile.StoreUint8(&o.FPROT0.Reg, value)
}
func (o *FTFA_Type) GetFPROT0() uint8 {
	return volatile.LoadUint8(&o.FPROT0.Reg)
}

// DMA channel multiplexor
type DMAMUX0_Type struct {
	CHCFG0 volatile.Register8 // 0x0
	CHCFG1 volatile.Register8 // 0x1
	CHCFG2 volatile.Register8 // 0x2
	CHCFG3 volatile.Register8 // 0x3
}

// DMAMUX0.CHCFG0: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG0_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG0_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG0.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG0_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG0_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG0_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG0.Reg, volatile.LoadUint8(&o.CHCFG0.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG0_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG0.Reg) & 0x80) >> 7
}

// DMAMUX0.CHCFG1: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG1_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG1_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG1.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG1_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG1_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG1_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG1.Reg, volatile.LoadUint8(&o.CHCFG1.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG1_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG1.Reg) & 0x80) >> 7
}

// DMAMUX0.CHCFG2: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG2_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG2_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG2.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG2_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG2_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG2_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG2.Reg, volatile.LoadUint8(&o.CHCFG2.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG2_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG2.Reg) & 0x80) >> 7
}

// DMAMUX0.CHCFG3: Channel Configuration register
func (o *DMAMUX0_Type) SetCHCFG3_SOURCE(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x3f)|value)
}
func (o *DMAMUX0_Type) GetCHCFG3_SOURCE() uint8 {
	return volatile.LoadUint8(&o.CHCFG3.Reg) & 0x3f
}
func (o *DMAMUX0_Type) SetCHCFG3_TRIG(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX0_Type) GetCHCFG3_TRIG() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x40) >> 6
}
func (o *DMAMUX0_Type) SetCHCFG3_ENBL(value uint8) {
	volatile.StoreUint8(&o.CHCFG3.Reg, volatile.LoadUint8(&o.CHCFG3.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX0_Type) GetCHCFG3_ENBL() uint8 {
	return (volatile.LoadUint8(&o.CHCFG3.Reg) & 0x80) >> 7
}

// Inter-IC Sound / Synchronous Audio Interface
type I2S0_Type struct {
	TCSR volatile.Register32 // 0x0
	_    [4]byte
	TCR2 volatile.Register32 // 0x8
	TCR3 volatile.Register32 // 0xC
	TCR4 volatile.Register32 // 0x10
	TCR5 volatile.Register32 // 0x14
	_    [8]byte
	TDR  volatile.Register32 // 0x20
	_    [60]byte
	TMR  volatile.Register32 // 0x60
	_    [28]byte
	RCSR volatile.Register32 // 0x80
	_    [4]byte
	RCR2 volatile.Register32 // 0x88
	RCR3 volatile.Register32 // 0x8C
	RCR4 volatile.Register32 // 0x90
	RCR5 volatile.Register32 // 0x94
	_    [8]byte
	RDR  volatile.Register32 // 0xA0
	_    [60]byte
	RMR  volatile.Register32 // 0xE0
	_    [28]byte
	MCR  volatile.Register32 // 0x100
	MDR  volatile.Register32 // 0x104
}

// I2S0.TCSR: SAI Transmit Control Register
func (o *I2S0_Type) SetTCSR_FWDE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetTCSR_FWDE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetTCSR_FWIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetTCSR_FWIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetTCSR_FEIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetTCSR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetTCSR_SEIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetTCSR_SEIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetTCSR_WSIE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetTCSR_WSIE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetTCSR_FWF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetTCSR_FWF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetTCSR_FEF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetTCSR_FEF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetTCSR_SEF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetTCSR_SEF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetTCSR_WSF(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetTCSR_WSF() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetTCSR_SR(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetTCSR_SR() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetTCSR_FR(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetTCSR_FR() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetTCSR_BCE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTCSR_BCE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetTCSR_DBGE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetTCSR_DBGE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetTCSR_STOPE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetTCSR_STOPE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetTCSR_TE(value uint32) {
	volatile.StoreUint32(&o.TCSR.Reg, volatile.LoadUint32(&o.TCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetTCSR_TE() uint32 {
	return (volatile.LoadUint32(&o.TCSR.Reg) & 0x80000000) >> 31
}

// I2S0.TCR2: SAI Transmit Configuration 2 Register
func (o *I2S0_Type) SetTCR2_DIV(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xff)|value)
}
func (o *I2S0_Type) GetTCR2_DIV() uint32 {
	return volatile.LoadUint32(&o.TCR2.Reg) & 0xff
}
func (o *I2S0_Type) SetTCR2_BCD(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetTCR2_BCD() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetTCR2_BCP(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetTCR2_BCP() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetTCR2_MSEL(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xc000000)|value<<26)
}
func (o *I2S0_Type) GetTCR2_MSEL() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0xc000000) >> 26
}
func (o *I2S0_Type) SetTCR2_BCI(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetTCR2_BCI() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetTCR2_BCS(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetTCR2_BCS() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetTCR2_SYNC(value uint32) {
	volatile.StoreUint32(&o.TCR2.Reg, volatile.LoadUint32(&o.TCR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *I2S0_Type) GetTCR2_SYNC() uint32 {
	return (volatile.LoadUint32(&o.TCR2.Reg) & 0xc0000000) >> 30
}

// I2S0.TCR3: SAI Transmit Configuration 3 Register
func (o *I2S0_Type) SetTCR3_WDFL(value uint32) {
	volatile.StoreUint32(&o.TCR3.Reg, volatile.LoadUint32(&o.TCR3.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetTCR3_WDFL() uint32 {
	return volatile.LoadUint32(&o.TCR3.Reg) & 0x1
}
func (o *I2S0_Type) SetTCR3_TCE(value uint32) {
	volatile.StoreUint32(&o.TCR3.Reg, volatile.LoadUint32(&o.TCR3.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetTCR3_TCE() uint32 {
	return (volatile.LoadUint32(&o.TCR3.Reg) & 0x10000) >> 16
}

// I2S0.TCR4: SAI Transmit Configuration 4 Register
func (o *I2S0_Type) SetTCR4_FSD(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetTCR4_FSD() uint32 {
	return volatile.LoadUint32(&o.TCR4.Reg) & 0x1
}
func (o *I2S0_Type) SetTCR4_FSP(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetTCR4_FSP() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetTCR4_FSE(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetTCR4_FSE() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetTCR4_MF(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetTCR4_MF() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetTCR4_SYWD(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetTCR4_SYWD() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetTCR4_FRSZ(value uint32) {
	volatile.StoreUint32(&o.TCR4.Reg, volatile.LoadUint32(&o.TCR4.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetTCR4_FRSZ() uint32 {
	return (volatile.LoadUint32(&o.TCR4.Reg) & 0x10000) >> 16
}

// I2S0.TCR5: SAI Transmit Configuration 5 Register
func (o *I2S0_Type) SetTCR5_FBT(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetTCR5_FBT() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetTCR5_W0W(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetTCR5_W0W() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f0000) >> 16
}
func (o *I2S0_Type) SetTCR5_WNW(value uint32) {
	volatile.StoreUint32(&o.TCR5.Reg, volatile.LoadUint32(&o.TCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S0_Type) GetTCR5_WNW() uint32 {
	return (volatile.LoadUint32(&o.TCR5.Reg) & 0x1f000000) >> 24
}

// I2S0.TDR: SAI Transmit Data Register
func (o *I2S0_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *I2S0_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// I2S0.TMR: SAI Transmit Mask Register
func (o *I2S0_Type) SetTMR_TWM(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0x3)|value)
}
func (o *I2S0_Type) GetTMR_TWM() uint32 {
	return volatile.LoadUint32(&o.TMR.Reg) & 0x3
}

// I2S0.RCSR: SAI Receive Control Register
func (o *I2S0_Type) SetRCSR_FWDE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetRCSR_FWDE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetRCSR_FWIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x200)|value<<9)
}
func (o *I2S0_Type) GetRCSR_FWIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x200) >> 9
}
func (o *I2S0_Type) SetRCSR_FEIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x400)|value<<10)
}
func (o *I2S0_Type) GetRCSR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x400) >> 10
}
func (o *I2S0_Type) SetRCSR_SEIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x800)|value<<11)
}
func (o *I2S0_Type) GetRCSR_SEIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x800) >> 11
}
func (o *I2S0_Type) SetRCSR_WSIE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S0_Type) GetRCSR_WSIE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x1000) >> 12
}
func (o *I2S0_Type) SetRCSR_FWF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S0_Type) GetRCSR_FWF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x20000) >> 17
}
func (o *I2S0_Type) SetRCSR_FEF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x40000)|value<<18)
}
func (o *I2S0_Type) GetRCSR_FEF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x40000) >> 18
}
func (o *I2S0_Type) SetRCSR_SEF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x80000)|value<<19)
}
func (o *I2S0_Type) GetRCSR_SEF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x80000) >> 19
}
func (o *I2S0_Type) SetRCSR_WSF(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x100000)|value<<20)
}
func (o *I2S0_Type) GetRCSR_WSF() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x100000) >> 20
}
func (o *I2S0_Type) SetRCSR_SR(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetRCSR_SR() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetRCSR_FR(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetRCSR_FR() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetRCSR_BCE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRCSR_BCE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetRCSR_DBGE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetRCSR_DBGE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetRCSR_STOPE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetRCSR_STOPE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetRCSR_RE(value uint32) {
	volatile.StoreUint32(&o.RCSR.Reg, volatile.LoadUint32(&o.RCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetRCSR_RE() uint32 {
	return (volatile.LoadUint32(&o.RCSR.Reg) & 0x80000000) >> 31
}

// I2S0.RCR2: SAI Receive Configuration 2 Register
func (o *I2S0_Type) SetRCR2_DIV(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xff)|value)
}
func (o *I2S0_Type) GetRCR2_DIV() uint32 {
	return volatile.LoadUint32(&o.RCR2.Reg) & 0xff
}
func (o *I2S0_Type) SetRCR2_BCD(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S0_Type) GetRCR2_BCD() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x1000000) >> 24
}
func (o *I2S0_Type) SetRCR2_BCP(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S0_Type) GetRCR2_BCP() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x2000000) >> 25
}
func (o *I2S0_Type) SetRCR2_MSEL(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xc000000)|value<<26)
}
func (o *I2S0_Type) GetRCR2_MSEL() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0xc000000) >> 26
}
func (o *I2S0_Type) SetRCR2_BCI(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S0_Type) GetRCR2_BCI() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x10000000) >> 28
}
func (o *I2S0_Type) SetRCR2_BCS(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S0_Type) GetRCR2_BCS() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0x20000000) >> 29
}
func (o *I2S0_Type) SetRCR2_SYNC(value uint32) {
	volatile.StoreUint32(&o.RCR2.Reg, volatile.LoadUint32(&o.RCR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *I2S0_Type) GetRCR2_SYNC() uint32 {
	return (volatile.LoadUint32(&o.RCR2.Reg) & 0xc0000000) >> 30
}

// I2S0.RCR3: SAI Receive Configuration 3 Register
func (o *I2S0_Type) SetRCR3_WDFL(value uint32) {
	volatile.StoreUint32(&o.RCR3.Reg, volatile.LoadUint32(&o.RCR3.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetRCR3_WDFL() uint32 {
	return volatile.LoadUint32(&o.RCR3.Reg) & 0x1
}
func (o *I2S0_Type) SetRCR3_RCE(value uint32) {
	volatile.StoreUint32(&o.RCR3.Reg, volatile.LoadUint32(&o.RCR3.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetRCR3_RCE() uint32 {
	return (volatile.LoadUint32(&o.RCR3.Reg) & 0x10000) >> 16
}

// I2S0.RCR4: SAI Receive Configuration 4 Register
func (o *I2S0_Type) SetRCR4_FSD(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x1)|value)
}
func (o *I2S0_Type) GetRCR4_FSD() uint32 {
	return volatile.LoadUint32(&o.RCR4.Reg) & 0x1
}
func (o *I2S0_Type) SetRCR4_FSP(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x2)|value<<1)
}
func (o *I2S0_Type) GetRCR4_FSP() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x2) >> 1
}
func (o *I2S0_Type) SetRCR4_FSE(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x8)|value<<3)
}
func (o *I2S0_Type) GetRCR4_FSE() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x8) >> 3
}
func (o *I2S0_Type) SetRCR4_MF(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x10)|value<<4)
}
func (o *I2S0_Type) GetRCR4_MF() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x10) >> 4
}
func (o *I2S0_Type) SetRCR4_SYWD(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetRCR4_SYWD() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetRCR4_FRSZ(value uint32) {
	volatile.StoreUint32(&o.RCR4.Reg, volatile.LoadUint32(&o.RCR4.Reg)&^(0x10000)|value<<16)
}
func (o *I2S0_Type) GetRCR4_FRSZ() uint32 {
	return (volatile.LoadUint32(&o.RCR4.Reg) & 0x10000) >> 16
}

// I2S0.RCR5: SAI Receive Configuration 5 Register
func (o *I2S0_Type) SetRCR5_FBT(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f00)|value<<8)
}
func (o *I2S0_Type) GetRCR5_FBT() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f00) >> 8
}
func (o *I2S0_Type) SetRCR5_W0W(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f0000)|value<<16)
}
func (o *I2S0_Type) GetRCR5_W0W() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f0000) >> 16
}
func (o *I2S0_Type) SetRCR5_WNW(value uint32) {
	volatile.StoreUint32(&o.RCR5.Reg, volatile.LoadUint32(&o.RCR5.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S0_Type) GetRCR5_WNW() uint32 {
	return (volatile.LoadUint32(&o.RCR5.Reg) & 0x1f000000) >> 24
}

// I2S0.RDR: SAI Receive Data Register
func (o *I2S0_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *I2S0_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// I2S0.RMR: SAI Receive Mask Register
func (o *I2S0_Type) SetRMR_RWM(value uint32) {
	volatile.StoreUint32(&o.RMR.Reg, volatile.LoadUint32(&o.RMR.Reg)&^(0x3)|value)
}
func (o *I2S0_Type) GetRMR_RWM() uint32 {
	return volatile.LoadUint32(&o.RMR.Reg) & 0x3
}

// I2S0.MCR: SAI MCLK Control Register
func (o *I2S0_Type) SetMCR_MICS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x3000000)|value<<24)
}
func (o *I2S0_Type) GetMCR_MICS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x3000000) >> 24
}
func (o *I2S0_Type) SetMCR_MOE(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S0_Type) GetMCR_MOE() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000000) >> 30
}
func (o *I2S0_Type) SetMCR_DUF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S0_Type) GetMCR_DUF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000000) >> 31
}

// I2S0.MDR: SAI MCLK Divide Register
func (o *I2S0_Type) SetMDR_DIVIDE(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, volatile.LoadUint32(&o.MDR.Reg)&^(0xfff)|value)
}
func (o *I2S0_Type) GetMDR_DIVIDE() uint32 {
	return volatile.LoadUint32(&o.MDR.Reg) & 0xfff
}
func (o *I2S0_Type) SetMDR_FRACT(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, volatile.LoadUint32(&o.MDR.Reg)&^(0xff000)|value<<12)
}
func (o *I2S0_Type) GetMDR_FRACT() uint32 {
	return (volatile.LoadUint32(&o.MDR.Reg) & 0xff000) >> 12
}

// Periodic Interrupt Timer
type PIT_Type struct {
	MCR     volatile.Register32 // 0x0
	_       [220]byte
	LTMR64H volatile.Register32 // 0xE0
	LTMR64L volatile.Register32 // 0xE4
	_       [24]byte
	LDVAL0  volatile.Register32 // 0x100
	CVAL0   volatile.Register32 // 0x104
	TCTRL0  volatile.Register32 // 0x108
	TFLG0   volatile.Register32 // 0x10C
	LDVAL1  volatile.Register32 // 0x110
	CVAL1   volatile.Register32 // 0x114
	TCTRL1  volatile.Register32 // 0x118
	TFLG1   volatile.Register32 // 0x11C
}

// PIT.MCR: PIT Module Control Register
func (o *PIT_Type) SetMCR_FRZ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetMCR_FRZ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *PIT_Type) SetMCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetMCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}

// PIT.LTMR64H: PIT Upper Lifetime Timer Register
func (o *PIT_Type) SetLTMR64H(value uint32) {
	volatile.StoreUint32(&o.LTMR64H.Reg, value)
}
func (o *PIT_Type) GetLTMR64H() uint32 {
	return volatile.LoadUint32(&o.LTMR64H.Reg)
}

// PIT.LTMR64L: PIT Lower Lifetime Timer Register
func (o *PIT_Type) SetLTMR64L(value uint32) {
	volatile.StoreUint32(&o.LTMR64L.Reg, value)
}
func (o *PIT_Type) GetLTMR64L() uint32 {
	return volatile.LoadUint32(&o.LTMR64L.Reg)
}

// PIT.LDVAL0: Timer Load Value Register
func (o *PIT_Type) SetLDVAL0(value uint32) {
	volatile.StoreUint32(&o.LDVAL0.Reg, value)
}
func (o *PIT_Type) GetLDVAL0() uint32 {
	return volatile.LoadUint32(&o.LDVAL0.Reg)
}

// PIT.CVAL0: Current Timer Value Register
func (o *PIT_Type) SetCVAL0(value uint32) {
	volatile.StoreUint32(&o.CVAL0.Reg, value)
}
func (o *PIT_Type) GetCVAL0() uint32 {
	return volatile.LoadUint32(&o.CVAL0.Reg)
}

// PIT.TCTRL0: Timer Control Register
func (o *PIT_Type) SetTCTRL0_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL0_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL0.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL0_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL0_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL0_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL0.Reg, volatile.LoadUint32(&o.TCTRL0.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL0_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL0.Reg) & 0x4) >> 2
}

// PIT.TFLG0: Timer Flag Register
func (o *PIT_Type) SetTFLG0_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG0.Reg, volatile.LoadUint32(&o.TFLG0.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG0_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG0.Reg) & 0x1
}

// PIT.LDVAL1: Timer Load Value Register
func (o *PIT_Type) SetLDVAL1(value uint32) {
	volatile.StoreUint32(&o.LDVAL1.Reg, value)
}
func (o *PIT_Type) GetLDVAL1() uint32 {
	return volatile.LoadUint32(&o.LDVAL1.Reg)
}

// PIT.CVAL1: Current Timer Value Register
func (o *PIT_Type) SetCVAL1(value uint32) {
	volatile.StoreUint32(&o.CVAL1.Reg, value)
}
func (o *PIT_Type) GetCVAL1() uint32 {
	return volatile.LoadUint32(&o.CVAL1.Reg)
}

// PIT.TCTRL1: Timer Control Register
func (o *PIT_Type) SetTCTRL1_TEN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTCTRL1_TEN() uint32 {
	return volatile.LoadUint32(&o.TCTRL1.Reg) & 0x1
}
func (o *PIT_Type) SetTCTRL1_TIE(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *PIT_Type) GetTCTRL1_TIE() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x2) >> 1
}
func (o *PIT_Type) SetTCTRL1_CHN(value uint32) {
	volatile.StoreUint32(&o.TCTRL1.Reg, volatile.LoadUint32(&o.TCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *PIT_Type) GetTCTRL1_CHN() uint32 {
	return (volatile.LoadUint32(&o.TCTRL1.Reg) & 0x4) >> 2
}

// PIT.TFLG1: Timer Flag Register
func (o *PIT_Type) SetTFLG1_TIF(value uint32) {
	volatile.StoreUint32(&o.TFLG1.Reg, volatile.LoadUint32(&o.TFLG1.Reg)&^(0x1)|value)
}
func (o *PIT_Type) GetTFLG1_TIF() uint32 {
	return volatile.LoadUint32(&o.TFLG1.Reg) & 0x1
}

// Timer/PWM Module
type TPM_Type struct {
	SC     volatile.Register32 // 0x0
	CNT    volatile.Register32 // 0x4
	MOD    volatile.Register32 // 0x8
	C0SC   volatile.Register32 // 0xC
	C0V    volatile.Register32 // 0x10
	C1SC   volatile.Register32 // 0x14
	C1V    volatile.Register32 // 0x18
	C2SC   volatile.Register32 // 0x1C
	C2V    volatile.Register32 // 0x20
	C3SC   volatile.Register32 // 0x24
	C3V    volatile.Register32 // 0x28
	C4SC   volatile.Register32 // 0x2C
	C4V    volatile.Register32 // 0x30
	C5SC   volatile.Register32 // 0x34
	C5V    volatile.Register32 // 0x38
	_      [20]byte
	STATUS volatile.Register32 // 0x50
	_      [48]byte
	CONF   volatile.Register32 // 0x84
}

// TPM.SC: Status and Control
func (o *TPM_Type) SetSC_PS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x7)|value)
}
func (o *TPM_Type) GetSC_PS() uint32 {
	return volatile.LoadUint32(&o.SC.Reg) & 0x7
}
func (o *TPM_Type) SetSC_CMOD(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x18)|value<<3)
}
func (o *TPM_Type) GetSC_CMOD() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x18) >> 3
}
func (o *TPM_Type) SetSC_CPWMS(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetSC_CPWMS() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetSC_TOIE(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetSC_TOIE() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetSC_TOF(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetSC_TOF() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x80) >> 7
}
func (o *TPM_Type) SetSC_DMA(value uint32) {
	volatile.StoreUint32(&o.SC.Reg, volatile.LoadUint32(&o.SC.Reg)&^(0x100)|value<<8)
}
func (o *TPM_Type) GetSC_DMA() uint32 {
	return (volatile.LoadUint32(&o.SC.Reg) & 0x100) >> 8
}

// TPM.CNT: Counter
func (o *TPM_Type) SetCNT_COUNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetCNT_COUNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// TPM.MOD: Modulo
func (o *TPM_Type) SetMOD(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetMOD() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0xffff
}

// TPM.C0SC: Channel (n) Status and Control
func (o *TPM_Type) SetC0SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC0SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C0SC.Reg) & 0x1
}
func (o *TPM_Type) SetC0SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC0SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC0SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC0SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC0SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC0SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC0SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC0SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC0SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC0SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC0SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C0SC.Reg, volatile.LoadUint32(&o.C0SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC0SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C0SC.Reg) & 0x80) >> 7
}

// TPM.C0V: Channel (n) Value
func (o *TPM_Type) SetC0V_VAL(value uint32) {
	volatile.StoreUint32(&o.C0V.Reg, volatile.LoadUint32(&o.C0V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC0V_VAL() uint32 {
	return volatile.LoadUint32(&o.C0V.Reg) & 0xffff
}

// TPM.C1SC: Channel (n) Status and Control
func (o *TPM_Type) SetC1SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC1SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C1SC.Reg) & 0x1
}
func (o *TPM_Type) SetC1SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC1SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC1SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC1SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC1SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC1SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC1SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC1SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC1SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC1SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC1SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C1SC.Reg, volatile.LoadUint32(&o.C1SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC1SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C1SC.Reg) & 0x80) >> 7
}

// TPM.C1V: Channel (n) Value
func (o *TPM_Type) SetC1V_VAL(value uint32) {
	volatile.StoreUint32(&o.C1V.Reg, volatile.LoadUint32(&o.C1V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC1V_VAL() uint32 {
	return volatile.LoadUint32(&o.C1V.Reg) & 0xffff
}

// TPM.C2SC: Channel (n) Status and Control
func (o *TPM_Type) SetC2SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC2SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C2SC.Reg) & 0x1
}
func (o *TPM_Type) SetC2SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC2SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC2SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC2SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC2SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC2SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC2SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC2SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC2SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC2SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC2SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C2SC.Reg, volatile.LoadUint32(&o.C2SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC2SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C2SC.Reg) & 0x80) >> 7
}

// TPM.C2V: Channel (n) Value
func (o *TPM_Type) SetC2V_VAL(value uint32) {
	volatile.StoreUint32(&o.C2V.Reg, volatile.LoadUint32(&o.C2V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC2V_VAL() uint32 {
	return volatile.LoadUint32(&o.C2V.Reg) & 0xffff
}

// TPM.C3SC: Channel (n) Status and Control
func (o *TPM_Type) SetC3SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC3SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C3SC.Reg) & 0x1
}
func (o *TPM_Type) SetC3SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC3SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC3SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC3SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC3SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC3SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC3SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC3SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC3SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC3SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC3SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C3SC.Reg, volatile.LoadUint32(&o.C3SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC3SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C3SC.Reg) & 0x80) >> 7
}

// TPM.C3V: Channel (n) Value
func (o *TPM_Type) SetC3V_VAL(value uint32) {
	volatile.StoreUint32(&o.C3V.Reg, volatile.LoadUint32(&o.C3V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC3V_VAL() uint32 {
	return volatile.LoadUint32(&o.C3V.Reg) & 0xffff
}

// TPM.C4SC: Channel (n) Status and Control
func (o *TPM_Type) SetC4SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC4SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C4SC.Reg) & 0x1
}
func (o *TPM_Type) SetC4SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC4SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC4SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC4SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC4SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC4SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC4SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC4SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC4SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC4SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC4SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C4SC.Reg, volatile.LoadUint32(&o.C4SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC4SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C4SC.Reg) & 0x80) >> 7
}

// TPM.C4V: Channel (n) Value
func (o *TPM_Type) SetC4V_VAL(value uint32) {
	volatile.StoreUint32(&o.C4V.Reg, volatile.LoadUint32(&o.C4V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC4V_VAL() uint32 {
	return volatile.LoadUint32(&o.C4V.Reg) & 0xffff
}

// TPM.C5SC: Channel (n) Status and Control
func (o *TPM_Type) SetC5SC_DMA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetC5SC_DMA() uint32 {
	return volatile.LoadUint32(&o.C5SC.Reg) & 0x1
}
func (o *TPM_Type) SetC5SC_ELSA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetC5SC_ELSA() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetC5SC_ELSB(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetC5SC_ELSB() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetC5SC_MSA(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetC5SC_MSA() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetC5SC_MSB(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetC5SC_MSB() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetC5SC_CHIE(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x40)|value<<6)
}
func (o *TPM_Type) GetC5SC_CHIE() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x40) >> 6
}
func (o *TPM_Type) SetC5SC_CHF(value uint32) {
	volatile.StoreUint32(&o.C5SC.Reg, volatile.LoadUint32(&o.C5SC.Reg)&^(0x80)|value<<7)
}
func (o *TPM_Type) GetC5SC_CHF() uint32 {
	return (volatile.LoadUint32(&o.C5SC.Reg) & 0x80) >> 7
}

// TPM.C5V: Channel (n) Value
func (o *TPM_Type) SetC5V_VAL(value uint32) {
	volatile.StoreUint32(&o.C5V.Reg, volatile.LoadUint32(&o.C5V.Reg)&^(0xffff)|value)
}
func (o *TPM_Type) GetC5V_VAL() uint32 {
	return volatile.LoadUint32(&o.C5V.Reg) & 0xffff
}

// TPM.STATUS: Capture and Compare Status
func (o *TPM_Type) SetSTATUS_CH0F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TPM_Type) GetSTATUS_CH0F() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *TPM_Type) SetSTATUS_CH1F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TPM_Type) GetSTATUS_CH1F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TPM_Type) SetSTATUS_CH2F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *TPM_Type) GetSTATUS_CH2F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *TPM_Type) SetSTATUS_CH3F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TPM_Type) GetSTATUS_CH3F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TPM_Type) SetSTATUS_CH4F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TPM_Type) GetSTATUS_CH4F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TPM_Type) SetSTATUS_CH5F(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetSTATUS_CH5F() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetSTATUS_TOF(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *TPM_Type) GetSTATUS_TOF() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}

// TPM.CONF: Configuration
func (o *TPM_Type) SetCONF_DOZEEN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20)|value<<5)
}
func (o *TPM_Type) GetCONF_DOZEEN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20) >> 5
}
func (o *TPM_Type) SetCONF_DBGMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xc0)|value<<6)
}
func (o *TPM_Type) GetCONF_DBGMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xc0) >> 6
}
func (o *TPM_Type) SetCONF_GTBEEN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x200)|value<<9)
}
func (o *TPM_Type) GetCONF_GTBEEN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x200) >> 9
}
func (o *TPM_Type) SetCONF_CSOT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10000)|value<<16)
}
func (o *TPM_Type) GetCONF_CSOT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10000) >> 16
}
func (o *TPM_Type) SetCONF_CSOO(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20000)|value<<17)
}
func (o *TPM_Type) GetCONF_CSOO() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20000) >> 17
}
func (o *TPM_Type) SetCONF_CROT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x40000)|value<<18)
}
func (o *TPM_Type) GetCONF_CROT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x40000) >> 18
}
func (o *TPM_Type) SetCONF_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xf000000)|value<<24)
}
func (o *TPM_Type) GetCONF_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xf000000) >> 24
}

// Analog-to-Digital Converter
type ADC0_Type struct {
	SC1A volatile.Register32 // 0x0
	SC1B volatile.Register32 // 0x4
	CFG1 volatile.Register32 // 0x8
	CFG2 volatile.Register32 // 0xC
	RA   volatile.Register32 // 0x10
	RB   volatile.Register32 // 0x14
	CV1  volatile.Register32 // 0x18
	CV2  volatile.Register32 // 0x1C
	SC2  volatile.Register32 // 0x20
	SC3  volatile.Register32 // 0x24
	OFS  volatile.Register32 // 0x28
	PG   volatile.Register32 // 0x2C
	MG   volatile.Register32 // 0x30
	CLPD volatile.Register32 // 0x34
	CLPS volatile.Register32 // 0x38
	CLP4 volatile.Register32 // 0x3C
	CLP3 volatile.Register32 // 0x40
	CLP2 volatile.Register32 // 0x44
	CLP1 volatile.Register32 // 0x48
	CLP0 volatile.Register32 // 0x4C
	_    [4]byte
	CLMD volatile.Register32 // 0x54
	CLMS volatile.Register32 // 0x58
	CLM4 volatile.Register32 // 0x5C
	CLM3 volatile.Register32 // 0x60
	CLM2 volatile.Register32 // 0x64
	CLM1 volatile.Register32 // 0x68
	CLM0 volatile.Register32 // 0x6C
}

// ADC0.SC1A: ADC Status and Control Registers 1
func (o *ADC0_Type) SetSC1A_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x1f)|value)
}
func (o *ADC0_Type) GetSC1A_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1A.Reg) & 0x1f
}
func (o *ADC0_Type) SetSC1A_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x20)|value<<5)
}
func (o *ADC0_Type) GetSC1A_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x20) >> 5
}
func (o *ADC0_Type) SetSC1A_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC1A_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC1A_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1A.Reg, volatile.LoadUint32(&o.SC1A.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC1A_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1A.Reg) & 0x80) >> 7
}

// ADC0.SC1B: ADC Status and Control Registers 1
func (o *ADC0_Type) SetSC1B_ADCH(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x1f)|value)
}
func (o *ADC0_Type) GetSC1B_ADCH() uint32 {
	return volatile.LoadUint32(&o.SC1B.Reg) & 0x1f
}
func (o *ADC0_Type) SetSC1B_DIFF(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x20)|value<<5)
}
func (o *ADC0_Type) GetSC1B_DIFF() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x20) >> 5
}
func (o *ADC0_Type) SetSC1B_AIEN(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC1B_AIEN() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC1B_COCO(value uint32) {
	volatile.StoreUint32(&o.SC1B.Reg, volatile.LoadUint32(&o.SC1B.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC1B_COCO() uint32 {
	return (volatile.LoadUint32(&o.SC1B.Reg) & 0x80) >> 7
}

// ADC0.CFG1: ADC Configuration Register 1
func (o *ADC0_Type) SetCFG1_ADICLK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetCFG1_ADICLK() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0x3
}
func (o *ADC0_Type) SetCFG1_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xc)|value<<2)
}
func (o *ADC0_Type) GetCFG1_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xc) >> 2
}
func (o *ADC0_Type) SetCFG1_ADLSMP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ADC0_Type) GetCFG1_ADLSMP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *ADC0_Type) SetCFG1_ADIV(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x60)|value<<5)
}
func (o *ADC0_Type) GetCFG1_ADIV() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x60) >> 5
}
func (o *ADC0_Type) SetCFG1_ADLPC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetCFG1_ADLPC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}

// ADC0.CFG2: ADC Configuration Register 2
func (o *ADC0_Type) SetCFG2_ADLSTS(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetCFG2_ADLSTS() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x3
}
func (o *ADC0_Type) SetCFG2_ADHSC(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4)|value<<2)
}
func (o *ADC0_Type) GetCFG2_ADHSC() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4) >> 2
}
func (o *ADC0_Type) SetCFG2_ADACKEN(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8)|value<<3)
}
func (o *ADC0_Type) GetCFG2_ADACKEN() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8) >> 3
}
func (o *ADC0_Type) SetCFG2_MUXSEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10)|value<<4)
}
func (o *ADC0_Type) GetCFG2_MUXSEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10) >> 4
}

// ADC0.RA: ADC Data Result Register
func (o *ADC0_Type) SetRA_D(value uint32) {
	volatile.StoreUint32(&o.RA.Reg, volatile.LoadUint32(&o.RA.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetRA_D() uint32 {
	return volatile.LoadUint32(&o.RA.Reg) & 0xffff
}

// ADC0.RB: ADC Data Result Register
func (o *ADC0_Type) SetRB_D(value uint32) {
	volatile.StoreUint32(&o.RB.Reg, volatile.LoadUint32(&o.RB.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetRB_D() uint32 {
	return volatile.LoadUint32(&o.RB.Reg) & 0xffff
}

// ADC0.CV1: Compare Value Registers
func (o *ADC0_Type) SetCV1_CV(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, volatile.LoadUint32(&o.CV1.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetCV1_CV() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg) & 0xffff
}

// ADC0.CV2: Compare Value Registers
func (o *ADC0_Type) SetCV2_CV(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, volatile.LoadUint32(&o.CV2.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetCV2_CV() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg) & 0xffff
}

// ADC0.SC2: Status and Control Register 2
func (o *ADC0_Type) SetSC2_REFSEL(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetSC2_REFSEL() uint32 {
	return volatile.LoadUint32(&o.SC2.Reg) & 0x3
}
func (o *ADC0_Type) SetSC2_DMAEN(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x4)|value<<2)
}
func (o *ADC0_Type) GetSC2_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x4) >> 2
}
func (o *ADC0_Type) SetSC2_ACREN(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x8)|value<<3)
}
func (o *ADC0_Type) GetSC2_ACREN() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x8) >> 3
}
func (o *ADC0_Type) SetSC2_ACFGT(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x10)|value<<4)
}
func (o *ADC0_Type) GetSC2_ACFGT() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x10) >> 4
}
func (o *ADC0_Type) SetSC2_ACFE(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x20)|value<<5)
}
func (o *ADC0_Type) GetSC2_ACFE() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x20) >> 5
}
func (o *ADC0_Type) SetSC2_ADTRG(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC2_ADTRG() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC2_ADACT(value uint32) {
	volatile.StoreUint32(&o.SC2.Reg, volatile.LoadUint32(&o.SC2.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC2_ADACT() uint32 {
	return (volatile.LoadUint32(&o.SC2.Reg) & 0x80) >> 7
}

// ADC0.SC3: Status and Control Register 3
func (o *ADC0_Type) SetSC3_AVGS(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x3)|value)
}
func (o *ADC0_Type) GetSC3_AVGS() uint32 {
	return volatile.LoadUint32(&o.SC3.Reg) & 0x3
}
func (o *ADC0_Type) SetSC3_AVGE(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x4)|value<<2)
}
func (o *ADC0_Type) GetSC3_AVGE() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x4) >> 2
}
func (o *ADC0_Type) SetSC3_ADCO(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x8)|value<<3)
}
func (o *ADC0_Type) GetSC3_ADCO() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x8) >> 3
}
func (o *ADC0_Type) SetSC3_CALF(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x40)|value<<6)
}
func (o *ADC0_Type) GetSC3_CALF() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x40) >> 6
}
func (o *ADC0_Type) SetSC3_CAL(value uint32) {
	volatile.StoreUint32(&o.SC3.Reg, volatile.LoadUint32(&o.SC3.Reg)&^(0x80)|value<<7)
}
func (o *ADC0_Type) GetSC3_CAL() uint32 {
	return (volatile.LoadUint32(&o.SC3.Reg) & 0x80) >> 7
}

// ADC0.OFS: ADC Offset Correction Register
func (o *ADC0_Type) SetOFS(value uint32) {
	volatile.StoreUint32(&o.OFS.Reg, volatile.LoadUint32(&o.OFS.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetOFS() uint32 {
	return volatile.LoadUint32(&o.OFS.Reg) & 0xffff
}

// ADC0.PG: ADC Plus-Side Gain Register
func (o *ADC0_Type) SetPG(value uint32) {
	volatile.StoreUint32(&o.PG.Reg, volatile.LoadUint32(&o.PG.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetPG() uint32 {
	return volatile.LoadUint32(&o.PG.Reg) & 0xffff
}

// ADC0.MG: ADC Minus-Side Gain Register
func (o *ADC0_Type) SetMG(value uint32) {
	volatile.StoreUint32(&o.MG.Reg, volatile.LoadUint32(&o.MG.Reg)&^(0xffff)|value)
}
func (o *ADC0_Type) GetMG() uint32 {
	return volatile.LoadUint32(&o.MG.Reg) & 0xffff
}

// ADC0.CLPD: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLPD(value uint32) {
	volatile.StoreUint32(&o.CLPD.Reg, volatile.LoadUint32(&o.CLPD.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLPD() uint32 {
	return volatile.LoadUint32(&o.CLPD.Reg) & 0x3f
}

// ADC0.CLPS: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLPS(value uint32) {
	volatile.StoreUint32(&o.CLPS.Reg, volatile.LoadUint32(&o.CLPS.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLPS() uint32 {
	return volatile.LoadUint32(&o.CLPS.Reg) & 0x3f
}

// ADC0.CLP4: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP4(value uint32) {
	volatile.StoreUint32(&o.CLP4.Reg, volatile.LoadUint32(&o.CLP4.Reg)&^(0x3ff)|value)
}
func (o *ADC0_Type) GetCLP4() uint32 {
	return volatile.LoadUint32(&o.CLP4.Reg) & 0x3ff
}

// ADC0.CLP3: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP3(value uint32) {
	volatile.StoreUint32(&o.CLP3.Reg, volatile.LoadUint32(&o.CLP3.Reg)&^(0x1ff)|value)
}
func (o *ADC0_Type) GetCLP3() uint32 {
	return volatile.LoadUint32(&o.CLP3.Reg) & 0x1ff
}

// ADC0.CLP2: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP2(value uint32) {
	volatile.StoreUint32(&o.CLP2.Reg, volatile.LoadUint32(&o.CLP2.Reg)&^(0xff)|value)
}
func (o *ADC0_Type) GetCLP2() uint32 {
	return volatile.LoadUint32(&o.CLP2.Reg) & 0xff
}

// ADC0.CLP1: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP1(value uint32) {
	volatile.StoreUint32(&o.CLP1.Reg, volatile.LoadUint32(&o.CLP1.Reg)&^(0x7f)|value)
}
func (o *ADC0_Type) GetCLP1() uint32 {
	return volatile.LoadUint32(&o.CLP1.Reg) & 0x7f
}

// ADC0.CLP0: ADC Plus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLP0(value uint32) {
	volatile.StoreUint32(&o.CLP0.Reg, volatile.LoadUint32(&o.CLP0.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLP0() uint32 {
	return volatile.LoadUint32(&o.CLP0.Reg) & 0x3f
}

// ADC0.CLMD: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLMD(value uint32) {
	volatile.StoreUint32(&o.CLMD.Reg, volatile.LoadUint32(&o.CLMD.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLMD() uint32 {
	return volatile.LoadUint32(&o.CLMD.Reg) & 0x3f
}

// ADC0.CLMS: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLMS(value uint32) {
	volatile.StoreUint32(&o.CLMS.Reg, volatile.LoadUint32(&o.CLMS.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLMS() uint32 {
	return volatile.LoadUint32(&o.CLMS.Reg) & 0x3f
}

// ADC0.CLM4: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM4(value uint32) {
	volatile.StoreUint32(&o.CLM4.Reg, volatile.LoadUint32(&o.CLM4.Reg)&^(0x3ff)|value)
}
func (o *ADC0_Type) GetCLM4() uint32 {
	return volatile.LoadUint32(&o.CLM4.Reg) & 0x3ff
}

// ADC0.CLM3: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM3(value uint32) {
	volatile.StoreUint32(&o.CLM3.Reg, volatile.LoadUint32(&o.CLM3.Reg)&^(0x1ff)|value)
}
func (o *ADC0_Type) GetCLM3() uint32 {
	return volatile.LoadUint32(&o.CLM3.Reg) & 0x1ff
}

// ADC0.CLM2: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM2(value uint32) {
	volatile.StoreUint32(&o.CLM2.Reg, volatile.LoadUint32(&o.CLM2.Reg)&^(0xff)|value)
}
func (o *ADC0_Type) GetCLM2() uint32 {
	return volatile.LoadUint32(&o.CLM2.Reg) & 0xff
}

// ADC0.CLM1: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM1(value uint32) {
	volatile.StoreUint32(&o.CLM1.Reg, volatile.LoadUint32(&o.CLM1.Reg)&^(0x7f)|value)
}
func (o *ADC0_Type) GetCLM1() uint32 {
	return volatile.LoadUint32(&o.CLM1.Reg) & 0x7f
}

// ADC0.CLM0: ADC Minus-Side General Calibration Value Register
func (o *ADC0_Type) SetCLM0(value uint32) {
	volatile.StoreUint32(&o.CLM0.Reg, volatile.LoadUint32(&o.CLM0.Reg)&^(0x3f)|value)
}
func (o *ADC0_Type) GetCLM0() uint32 {
	return volatile.LoadUint32(&o.CLM0.Reg) & 0x3f
}

// Secure Real Time Clock
type RTC_Type struct {
	TSR volatile.Register32 // 0x0
	TPR volatile.Register32 // 0x4
	TAR volatile.Register32 // 0x8
	TCR volatile.Register32 // 0xC
	CR  volatile.Register32 // 0x10
	SR  volatile.Register32 // 0x14
	LR  volatile.Register32 // 0x18
	IER volatile.Register32 // 0x1C
}

// RTC.TSR: RTC Time Seconds Register
func (o *RTC_Type) SetTSR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, value)
}
func (o *RTC_Type) GetTSR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg)
}

// RTC.TPR: RTC Time Prescaler Register
func (o *RTC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, volatile.LoadUint32(&o.TPR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg) & 0xffff
}

// RTC.TAR: RTC Time Alarm Register
func (o *RTC_Type) SetTAR(value uint32) {
	volatile.StoreUint32(&o.TAR.Reg, value)
}
func (o *RTC_Type) GetTAR() uint32 {
	return volatile.LoadUint32(&o.TAR.Reg)
}

// RTC.TCR: RTC Time Compensation Register
func (o *RTC_Type) SetTCR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetTCR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xff
}
func (o *RTC_Type) SetTCR_CIR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_Type) GetTCR_CIR() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff00) >> 8
}
func (o *RTC_Type) SetTCR_TCV(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RTC_Type) GetTCR_TCV() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff0000) >> 16
}
func (o *RTC_Type) SetTCR_CIC(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xff000000)|value<<24)
}
func (o *RTC_Type) GetTCR_CIC() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xff000000) >> 24
}

// RTC.CR: RTC Control Register
func (o *RTC_Type) SetCR_SWR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCR_SWR() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RTC_Type) SetCR_WPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCR_WPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCR_SUP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetCR_SUP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetCR_UM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_UM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WPS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_WPS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_OSCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_OSCE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_CLKO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_SC16P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_SC16P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_SC8P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_SC8P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_SC4P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_SC4P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_SC2P(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_SC2P() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}

// RTC.SR: RTC Status Register
func (o *RTC_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_TIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTC_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_TAF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_TAF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_TCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_TCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}

// RTC.LR: RTC Lock Register
func (o *RTC_Type) SetLR_TCL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetLR_TCL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetLR_CRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetLR_CRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetLR_SRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetLR_SRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetLR_LRL(value uint32) {
	volatile.StoreUint32(&o.LR.Reg, volatile.LoadUint32(&o.LR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetLR_LRL() uint32 {
	return (volatile.LoadUint32(&o.LR.Reg) & 0x40) >> 6
}

// RTC.IER: RTC Interrupt Enable Register
func (o *RTC_Type) SetIER_TIIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIER_TIIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *RTC_Type) SetIER_TOIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIER_TOIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIER_TAIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIER_TAIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIER_TSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIER_TSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIER_WPON(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetIER_WPON() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}

// 12-Bit Digital-to-Analog Converter
type DAC0_Type struct {
	DAT0L volatile.Register8 // 0x0
	DAT0H volatile.Register8 // 0x1
	DAT1L volatile.Register8 // 0x2
	DAT1H volatile.Register8 // 0x3
	_     [28]byte
	SR    volatile.Register8 // 0x20
	C0    volatile.Register8 // 0x21
	C1    volatile.Register8 // 0x22
	C2    volatile.Register8 // 0x23
}

// DAC0.DAT0L: DAC Data Low Register
func (o *DAC0_Type) SetDAT0L(value uint8) {
	volatile.StoreUint8(&o.DAT0L.Reg, value)
}
func (o *DAC0_Type) GetDAT0L() uint8 {
	return volatile.LoadUint8(&o.DAT0L.Reg)
}

// DAC0.DAT0H: DAC Data High Register
func (o *DAC0_Type) SetDAT0H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT0H.Reg, volatile.LoadUint8(&o.DAT0H.Reg)&^(0xf)|value)
}
func (o *DAC0_Type) GetDAT0H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT0H.Reg) & 0xf
}

// DAC0.DAT1L: DAC Data Low Register
func (o *DAC0_Type) SetDAT1L(value uint8) {
	volatile.StoreUint8(&o.DAT1L.Reg, value)
}
func (o *DAC0_Type) GetDAT1L() uint8 {
	return volatile.LoadUint8(&o.DAT1L.Reg)
}

// DAC0.DAT1H: DAC Data High Register
func (o *DAC0_Type) SetDAT1H_DATA1(value uint8) {
	volatile.StoreUint8(&o.DAT1H.Reg, volatile.LoadUint8(&o.DAT1H.Reg)&^(0xf)|value)
}
func (o *DAC0_Type) GetDAT1H_DATA1() uint8 {
	return volatile.LoadUint8(&o.DAT1H.Reg) & 0xf
}

// DAC0.SR: DAC Status Register
func (o *DAC0_Type) SetSR_DACBFRPBF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetSR_DACBFRPBF() uint8 {
	return volatile.LoadUint8(&o.SR.Reg) & 0x1
}
func (o *DAC0_Type) SetSR_DACBFRPTF(value uint8) {
	volatile.StoreUint8(&o.SR.Reg, volatile.LoadUint8(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DAC0_Type) GetSR_DACBFRPTF() uint8 {
	return (volatile.LoadUint8(&o.SR.Reg) & 0x2) >> 1
}

// DAC0.C0: DAC Control Register
func (o *DAC0_Type) SetC0_DACBBIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetC0_DACBBIEN() uint8 {
	return volatile.LoadUint8(&o.C0.Reg) & 0x1
}
func (o *DAC0_Type) SetC0_DACBTIEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x2)|value<<1)
}
func (o *DAC0_Type) GetC0_DACBTIEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x2) >> 1
}
func (o *DAC0_Type) SetC0_LPEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x8)|value<<3)
}
func (o *DAC0_Type) GetC0_LPEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x8) >> 3
}
func (o *DAC0_Type) SetC0_DACSWTRG(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x10)|value<<4)
}
func (o *DAC0_Type) GetC0_DACSWTRG() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x10) >> 4
}
func (o *DAC0_Type) SetC0_DACTRGSEL(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x20)|value<<5)
}
func (o *DAC0_Type) GetC0_DACTRGSEL() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x20) >> 5
}
func (o *DAC0_Type) SetC0_DACRFS(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x40)|value<<6)
}
func (o *DAC0_Type) GetC0_DACRFS() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x40) >> 6
}
func (o *DAC0_Type) SetC0_DACEN(value uint8) {
	volatile.StoreUint8(&o.C0.Reg, volatile.LoadUint8(&o.C0.Reg)&^(0x80)|value<<7)
}
func (o *DAC0_Type) GetC0_DACEN() uint8 {
	return (volatile.LoadUint8(&o.C0.Reg) & 0x80) >> 7
}

// DAC0.C1: DAC Control Register 1
func (o *DAC0_Type) SetC1_DACBFEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetC1_DACBFEN() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *DAC0_Type) SetC1_DACBFMD(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *DAC0_Type) GetC1_DACBFMD() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *DAC0_Type) SetC1_DMAEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *DAC0_Type) GetC1_DMAEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// DAC0.C2: DAC Control Register 2
func (o *DAC0_Type) SetC2_DACBFUP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *DAC0_Type) GetC2_DACBFUP() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *DAC0_Type) SetC2_DACBFRP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *DAC0_Type) GetC2_DACBFRP() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}

// Low Power Timer
type LPTMR0_Type struct {
	CSR volatile.Register32 // 0x0
	PSR volatile.Register32 // 0x4
	CMR volatile.Register32 // 0x8
	CNR volatile.Register32 // 0xC
}

// LPTMR0.CSR: Low Power Timer Control Status Register
func (o *LPTMR0_Type) SetCSR_TEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *LPTMR0_Type) GetCSR_TEN() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *LPTMR0_Type) SetCSR_TMS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *LPTMR0_Type) GetCSR_TMS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *LPTMR0_Type) SetCSR_TFC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *LPTMR0_Type) GetCSR_TFC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *LPTMR0_Type) SetCSR_TPP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *LPTMR0_Type) GetCSR_TPP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *LPTMR0_Type) SetCSR_TPS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x30)|value<<4)
}
func (o *LPTMR0_Type) GetCSR_TPS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x30) >> 4
}
func (o *LPTMR0_Type) SetCSR_TIE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *LPTMR0_Type) GetCSR_TIE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *LPTMR0_Type) SetCSR_TCF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *LPTMR0_Type) GetCSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}

// LPTMR0.PSR: Low Power Timer Prescale Register
func (o *LPTMR0_Type) SetPSR_PCS(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x3)|value)
}
func (o *LPTMR0_Type) GetPSR_PCS() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x3
}
func (o *LPTMR0_Type) SetPSR_PBYP(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *LPTMR0_Type) GetPSR_PBYP() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *LPTMR0_Type) SetPSR_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x78)|value<<3)
}
func (o *LPTMR0_Type) GetPSR_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x78) >> 3
}

// LPTMR0.CMR: Low Power Timer Compare Register
func (o *LPTMR0_Type) SetCMR_COMPARE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xffff)|value)
}
func (o *LPTMR0_Type) GetCMR_COMPARE() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xffff
}

// LPTMR0.CNR: Low Power Timer Counter Register
func (o *LPTMR0_Type) SetCNR_COUNTER(value uint32) {
	volatile.StoreUint32(&o.CNR.Reg, volatile.LoadUint32(&o.CNR.Reg)&^(0xffff)|value)
}
func (o *LPTMR0_Type) GetCNR_COUNTER() uint32 {
	return volatile.LoadUint32(&o.CNR.Reg) & 0xffff
}

// Touch sense input
type TSI0_Type struct {
	GENCS volatile.Register32 // 0x0
	DATA  volatile.Register32 // 0x4
	TSHD  volatile.Register32 // 0x8
}

// TSI0.GENCS: TSI General Control and Status Register
func (o *TSI0_Type) SetGENCS_CURSW(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x2)|value<<1)
}
func (o *TSI0_Type) GetGENCS_CURSW() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x2) >> 1
}
func (o *TSI0_Type) SetGENCS_EOSF(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x4)|value<<2)
}
func (o *TSI0_Type) GetGENCS_EOSF() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x4) >> 2
}
func (o *TSI0_Type) SetGENCS_SCNIP(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x8)|value<<3)
}
func (o *TSI0_Type) GetGENCS_SCNIP() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x8) >> 3
}
func (o *TSI0_Type) SetGENCS_STM(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x10)|value<<4)
}
func (o *TSI0_Type) GetGENCS_STM() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x10) >> 4
}
func (o *TSI0_Type) SetGENCS_STPE(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x20)|value<<5)
}
func (o *TSI0_Type) GetGENCS_STPE() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x20) >> 5
}
func (o *TSI0_Type) SetGENCS_TSIIEN(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x40)|value<<6)
}
func (o *TSI0_Type) GetGENCS_TSIIEN() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x40) >> 6
}
func (o *TSI0_Type) SetGENCS_TSIEN(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x80)|value<<7)
}
func (o *TSI0_Type) GetGENCS_TSIEN() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x80) >> 7
}
func (o *TSI0_Type) SetGENCS_NSCN(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x1f00)|value<<8)
}
func (o *TSI0_Type) GetGENCS_NSCN() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x1f00) >> 8
}
func (o *TSI0_Type) SetGENCS_PS(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0xe000)|value<<13)
}
func (o *TSI0_Type) GetGENCS_PS() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0xe000) >> 13
}
func (o *TSI0_Type) SetGENCS_EXTCHRG(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x70000)|value<<16)
}
func (o *TSI0_Type) GetGENCS_EXTCHRG() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x70000) >> 16
}
func (o *TSI0_Type) SetGENCS_DVOLT(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x180000)|value<<19)
}
func (o *TSI0_Type) GetGENCS_DVOLT() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x180000) >> 19
}
func (o *TSI0_Type) SetGENCS_REFCHRG(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0xe00000)|value<<21)
}
func (o *TSI0_Type) GetGENCS_REFCHRG() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0xe00000) >> 21
}
func (o *TSI0_Type) SetGENCS_MODE(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0xf000000)|value<<24)
}
func (o *TSI0_Type) GetGENCS_MODE() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0xf000000) >> 24
}
func (o *TSI0_Type) SetGENCS_ESOR(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x10000000)|value<<28)
}
func (o *TSI0_Type) GetGENCS_ESOR() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x10000000) >> 28
}
func (o *TSI0_Type) SetGENCS_OUTRGF(value uint32) {
	volatile.StoreUint32(&o.GENCS.Reg, volatile.LoadUint32(&o.GENCS.Reg)&^(0x80000000)|value<<31)
}
func (o *TSI0_Type) GetGENCS_OUTRGF() uint32 {
	return (volatile.LoadUint32(&o.GENCS.Reg) & 0x80000000) >> 31
}

// TSI0.DATA: TSI DATA Register
func (o *TSI0_Type) SetDATA_TSICNT(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xffff)|value)
}
func (o *TSI0_Type) GetDATA_TSICNT() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xffff
}
func (o *TSI0_Type) SetDATA_SWTS(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x400000)|value<<22)
}
func (o *TSI0_Type) GetDATA_SWTS() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x400000) >> 22
}
func (o *TSI0_Type) SetDATA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x800000)|value<<23)
}
func (o *TSI0_Type) GetDATA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x800000) >> 23
}
func (o *TSI0_Type) SetDATA_TSICH(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xf0000000)|value<<28)
}
func (o *TSI0_Type) GetDATA_TSICH() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xf0000000) >> 28
}

// TSI0.TSHD: TSI Threshold Register
func (o *TSI0_Type) SetTSHD_THRESL(value uint32) {
	volatile.StoreUint32(&o.TSHD.Reg, volatile.LoadUint32(&o.TSHD.Reg)&^(0xffff)|value)
}
func (o *TSI0_Type) GetTSHD_THRESL() uint32 {
	return volatile.LoadUint32(&o.TSHD.Reg) & 0xffff
}
func (o *TSI0_Type) SetTSHD_THRESH(value uint32) {
	volatile.StoreUint32(&o.TSHD.Reg, volatile.LoadUint32(&o.TSHD.Reg)&^(0xffff0000)|value<<16)
}
func (o *TSI0_Type) GetTSHD_THRESH() uint32 {
	return (volatile.LoadUint32(&o.TSHD.Reg) & 0xffff0000) >> 16
}

// System Integration Module
type SIM_Type struct {
	SOPT1    volatile.Register32 // 0x0
	SOPT1CFG volatile.Register32 // 0x4
	_        [4092]byte
	SOPT2    volatile.Register32 // 0x1004
	_        [4]byte
	SOPT4    volatile.Register32 // 0x100C
	SOPT5    volatile.Register32 // 0x1010
	_        [4]byte
	SOPT7    volatile.Register32 // 0x1018
	_        [8]byte
	SDID     volatile.Register32 // 0x1024
	_        [12]byte
	SCGC4    volatile.Register32 // 0x1034
	SCGC5    volatile.Register32 // 0x1038
	SCGC6    volatile.Register32 // 0x103C
	SCGC7    volatile.Register32 // 0x1040
	CLKDIV1  volatile.Register32 // 0x1044
	_        [4]byte
	FCFG1    volatile.Register32 // 0x104C
	FCFG2    volatile.Register32 // 0x1050
	_        [4]byte
	UIDMH    volatile.Register32 // 0x1058
	UIDML    volatile.Register32 // 0x105C
	UIDL     volatile.Register32 // 0x1060
	_        [156]byte
	COPC     volatile.Register32 // 0x1100
	SRVCOP   volatile.Register32 // 0x1104
}

// SIM.SOPT1: System Options Register 1
func (o *SIM_Type) SetSOPT1_OSC32KSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0xc0000)|value<<18)
}
func (o *SIM_Type) GetSOPT1_OSC32KSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0xc0000) >> 18
}
func (o *SIM_Type) SetSOPT1_USBVSTBY(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSOPT1_USBVSTBY() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSOPT1_USBSSTBY(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x40000000)|value<<30)
}
func (o *SIM_Type) GetSOPT1_USBSSTBY() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x40000000) >> 30
}
func (o *SIM_Type) SetSOPT1_USBREGEN(value uint32) {
	volatile.StoreUint32(&o.SOPT1.Reg, volatile.LoadUint32(&o.SOPT1.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSOPT1_USBREGEN() uint32 {
	return (volatile.LoadUint32(&o.SOPT1.Reg) & 0x80000000) >> 31
}

// SIM.SOPT1CFG: SOPT1 Configuration Register
func (o *SIM_Type) SetSOPT1CFG_URWE(value uint32) {
	volatile.StoreUint32(&o.SOPT1CFG.Reg, volatile.LoadUint32(&o.SOPT1CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSOPT1CFG_URWE() uint32 {
	return (volatile.LoadUint32(&o.SOPT1CFG.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSOPT1CFG_UVSWE(value uint32) {
	volatile.StoreUint32(&o.SOPT1CFG.Reg, volatile.LoadUint32(&o.SOPT1CFG.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSOPT1CFG_UVSWE() uint32 {
	return (volatile.LoadUint32(&o.SOPT1CFG.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSOPT1CFG_USSWE(value uint32) {
	volatile.StoreUint32(&o.SOPT1CFG.Reg, volatile.LoadUint32(&o.SOPT1CFG.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSOPT1CFG_USSWE() uint32 {
	return (volatile.LoadUint32(&o.SOPT1CFG.Reg) & 0x4000000) >> 26
}

// SIM.SOPT2: System Options Register 2
func (o *SIM_Type) SetSOPT2_RTCCLKOUTSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x10)|value<<4)
}
func (o *SIM_Type) GetSOPT2_RTCCLKOUTSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x10) >> 4
}
func (o *SIM_Type) SetSOPT2_CLKOUTSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0xe0)|value<<5)
}
func (o *SIM_Type) GetSOPT2_CLKOUTSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0xe0) >> 5
}
func (o *SIM_Type) SetSOPT2_PLLFLLSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x10000)|value<<16)
}
func (o *SIM_Type) GetSOPT2_PLLFLLSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x10000) >> 16
}
func (o *SIM_Type) SetSOPT2_USBSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSOPT2_USBSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x40000) >> 18
}
func (o *SIM_Type) SetSOPT2_TPMSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0x3000000)|value<<24)
}
func (o *SIM_Type) GetSOPT2_TPMSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0x3000000) >> 24
}
func (o *SIM_Type) SetSOPT2_UART0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT2.Reg, volatile.LoadUint32(&o.SOPT2.Reg)&^(0xc000000)|value<<26)
}
func (o *SIM_Type) GetSOPT2_UART0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT2.Reg) & 0xc000000) >> 26
}

// SIM.SOPT4: System Options Register 4
func (o *SIM_Type) SetSOPT4_TPM1CH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0xc0000)|value<<18)
}
func (o *SIM_Type) GetSOPT4_TPM1CH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0xc0000) >> 18
}
func (o *SIM_Type) SetSOPT4_TPM2CH0SRC(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x100000)|value<<20)
}
func (o *SIM_Type) GetSOPT4_TPM2CH0SRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x100000) >> 20
}
func (o *SIM_Type) SetSOPT4_TPM0CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSOPT4_TPM0CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSOPT4_TPM1CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSOPT4_TPM1CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSOPT4_TPM2CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT4.Reg, volatile.LoadUint32(&o.SOPT4.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSOPT4_TPM2CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT4.Reg) & 0x4000000) >> 26
}

// SIM.SOPT5: System Options Register 5
func (o *SIM_Type) SetSOPT5_UART0TXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x3)|value)
}
func (o *SIM_Type) GetSOPT5_UART0TXSRC() uint32 {
	return volatile.LoadUint32(&o.SOPT5.Reg) & 0x3
}
func (o *SIM_Type) SetSOPT5_UART0RXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x4)|value<<2)
}
func (o *SIM_Type) GetSOPT5_UART0RXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x4) >> 2
}
func (o *SIM_Type) SetSOPT5_UART1TXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x30)|value<<4)
}
func (o *SIM_Type) GetSOPT5_UART1TXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x30) >> 4
}
func (o *SIM_Type) SetSOPT5_UART1RXSRC(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x40)|value<<6)
}
func (o *SIM_Type) GetSOPT5_UART1RXSRC() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x40) >> 6
}
func (o *SIM_Type) SetSOPT5_UART0ODE(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x10000)|value<<16)
}
func (o *SIM_Type) GetSOPT5_UART0ODE() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x10000) >> 16
}
func (o *SIM_Type) SetSOPT5_UART1ODE(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x20000)|value<<17)
}
func (o *SIM_Type) GetSOPT5_UART1ODE() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x20000) >> 17
}
func (o *SIM_Type) SetSOPT5_UART2ODE(value uint32) {
	volatile.StoreUint32(&o.SOPT5.Reg, volatile.LoadUint32(&o.SOPT5.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSOPT5_UART2ODE() uint32 {
	return (volatile.LoadUint32(&o.SOPT5.Reg) & 0x40000) >> 18
}

// SIM.SOPT7: System Options Register 7
func (o *SIM_Type) SetSOPT7_ADC0TRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0xf)|value)
}
func (o *SIM_Type) GetSOPT7_ADC0TRGSEL() uint32 {
	return volatile.LoadUint32(&o.SOPT7.Reg) & 0xf
}
func (o *SIM_Type) SetSOPT7_ADC0PRETRGSEL(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x10)|value<<4)
}
func (o *SIM_Type) GetSOPT7_ADC0PRETRGSEL() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x10) >> 4
}
func (o *SIM_Type) SetSOPT7_ADC0ALTTRGEN(value uint32) {
	volatile.StoreUint32(&o.SOPT7.Reg, volatile.LoadUint32(&o.SOPT7.Reg)&^(0x80)|value<<7)
}
func (o *SIM_Type) GetSOPT7_ADC0ALTTRGEN() uint32 {
	return (volatile.LoadUint32(&o.SOPT7.Reg) & 0x80) >> 7
}

// SIM.SDID: System Device Identification Register
func (o *SIM_Type) SetSDID_PINID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf)|value)
}
func (o *SIM_Type) GetSDID_PINID() uint32 {
	return volatile.LoadUint32(&o.SDID.Reg) & 0xf
}
func (o *SIM_Type) SetSDID_DIEID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf80)|value<<7)
}
func (o *SIM_Type) GetSDID_DIEID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf80) >> 7
}
func (o *SIM_Type) SetSDID_REVID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf000)|value<<12)
}
func (o *SIM_Type) GetSDID_REVID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf000) >> 12
}
func (o *SIM_Type) SetSDID_SRAMSIZE(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf0000)|value<<16)
}
func (o *SIM_Type) GetSDID_SRAMSIZE() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf0000) >> 16
}
func (o *SIM_Type) SetSDID_SERIESID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf00000)|value<<20)
}
func (o *SIM_Type) GetSDID_SERIESID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf00000) >> 20
}
func (o *SIM_Type) SetSDID_SUBFAMID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf000000)|value<<24)
}
func (o *SIM_Type) GetSDID_SUBFAMID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf000000) >> 24
}
func (o *SIM_Type) SetSDID_FAMID(value uint32) {
	volatile.StoreUint32(&o.SDID.Reg, volatile.LoadUint32(&o.SDID.Reg)&^(0xf0000000)|value<<28)
}
func (o *SIM_Type) GetSDID_FAMID() uint32 {
	return (volatile.LoadUint32(&o.SDID.Reg) & 0xf0000000) >> 28
}

// SIM.SCGC4: System Clock Gating Control Register 4
func (o *SIM_Type) SetSCGC4_I2C0(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x40)|value<<6)
}
func (o *SIM_Type) GetSCGC4_I2C0() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x40) >> 6
}
func (o *SIM_Type) SetSCGC4_I2C1(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x80)|value<<7)
}
func (o *SIM_Type) GetSCGC4_I2C1() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x80) >> 7
}
func (o *SIM_Type) SetSCGC4_UART0(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x400)|value<<10)
}
func (o *SIM_Type) GetSCGC4_UART0() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x400) >> 10
}
func (o *SIM_Type) SetSCGC4_UART1(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x800)|value<<11)
}
func (o *SIM_Type) GetSCGC4_UART1() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x800) >> 11
}
func (o *SIM_Type) SetSCGC4_UART2(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSCGC4_UART2() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSCGC4_USBOTG(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x40000)|value<<18)
}
func (o *SIM_Type) GetSCGC4_USBOTG() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x40000) >> 18
}
func (o *SIM_Type) SetSCGC4_CMP(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x80000)|value<<19)
}
func (o *SIM_Type) GetSCGC4_CMP() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x80000) >> 19
}
func (o *SIM_Type) SetSCGC4_SPI0(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x400000)|value<<22)
}
func (o *SIM_Type) GetSCGC4_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x400000) >> 22
}
func (o *SIM_Type) SetSCGC4_SPI1(value uint32) {
	volatile.StoreUint32(&o.SCGC4.Reg, volatile.LoadUint32(&o.SCGC4.Reg)&^(0x800000)|value<<23)
}
func (o *SIM_Type) GetSCGC4_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SCGC4.Reg) & 0x800000) >> 23
}

// SIM.SCGC5: System Clock Gating Control Register 5
func (o *SIM_Type) SetSCGC5_LPTMR(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSCGC5_LPTMR() uint32 {
	return volatile.LoadUint32(&o.SCGC5.Reg) & 0x1
}
func (o *SIM_Type) SetSCGC5_TSI(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x20)|value<<5)
}
func (o *SIM_Type) GetSCGC5_TSI() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x20) >> 5
}
func (o *SIM_Type) SetSCGC5_PORTA(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x200)|value<<9)
}
func (o *SIM_Type) GetSCGC5_PORTA() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x200) >> 9
}
func (o *SIM_Type) SetSCGC5_PORTB(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x400)|value<<10)
}
func (o *SIM_Type) GetSCGC5_PORTB() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x400) >> 10
}
func (o *SIM_Type) SetSCGC5_PORTC(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x800)|value<<11)
}
func (o *SIM_Type) GetSCGC5_PORTC() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x800) >> 11
}
func (o *SIM_Type) SetSCGC5_PORTD(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x1000)|value<<12)
}
func (o *SIM_Type) GetSCGC5_PORTD() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x1000) >> 12
}
func (o *SIM_Type) SetSCGC5_PORTE(value uint32) {
	volatile.StoreUint32(&o.SCGC5.Reg, volatile.LoadUint32(&o.SCGC5.Reg)&^(0x2000)|value<<13)
}
func (o *SIM_Type) GetSCGC5_PORTE() uint32 {
	return (volatile.LoadUint32(&o.SCGC5.Reg) & 0x2000) >> 13
}

// SIM.SCGC6: System Clock Gating Control Register 6
func (o *SIM_Type) SetSCGC6_FTF(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetSCGC6_FTF() uint32 {
	return volatile.LoadUint32(&o.SCGC6.Reg) & 0x1
}
func (o *SIM_Type) SetSCGC6_DMAMUX(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetSCGC6_DMAMUX() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetSCGC6_I2S(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x8000)|value<<15)
}
func (o *SIM_Type) GetSCGC6_I2S() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x8000) >> 15
}
func (o *SIM_Type) SetSCGC6_PIT(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x800000)|value<<23)
}
func (o *SIM_Type) GetSCGC6_PIT() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x800000) >> 23
}
func (o *SIM_Type) SetSCGC6_TPM0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x1000000)|value<<24)
}
func (o *SIM_Type) GetSCGC6_TPM0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x1000000) >> 24
}
func (o *SIM_Type) SetSCGC6_TPM1(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x2000000)|value<<25)
}
func (o *SIM_Type) GetSCGC6_TPM1() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x2000000) >> 25
}
func (o *SIM_Type) SetSCGC6_TPM2(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x4000000)|value<<26)
}
func (o *SIM_Type) GetSCGC6_TPM2() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x4000000) >> 26
}
func (o *SIM_Type) SetSCGC6_ADC0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x8000000)|value<<27)
}
func (o *SIM_Type) GetSCGC6_ADC0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x8000000) >> 27
}
func (o *SIM_Type) SetSCGC6_RTC(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x20000000)|value<<29)
}
func (o *SIM_Type) GetSCGC6_RTC() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x20000000) >> 29
}
func (o *SIM_Type) SetSCGC6_DAC0(value uint32) {
	volatile.StoreUint32(&o.SCGC6.Reg, volatile.LoadUint32(&o.SCGC6.Reg)&^(0x80000000)|value<<31)
}
func (o *SIM_Type) GetSCGC6_DAC0() uint32 {
	return (volatile.LoadUint32(&o.SCGC6.Reg) & 0x80000000) >> 31
}

// SIM.SCGC7: System Clock Gating Control Register 7
func (o *SIM_Type) SetSCGC7_DMA(value uint32) {
	volatile.StoreUint32(&o.SCGC7.Reg, volatile.LoadUint32(&o.SCGC7.Reg)&^(0x100)|value<<8)
}
func (o *SIM_Type) GetSCGC7_DMA() uint32 {
	return (volatile.LoadUint32(&o.SCGC7.Reg) & 0x100) >> 8
}

// SIM.CLKDIV1: System Clock Divider Register 1
func (o *SIM_Type) SetCLKDIV1_OUTDIV4(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0x70000)|value<<16)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV4() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0x70000) >> 16
}
func (o *SIM_Type) SetCLKDIV1_OUTDIV1(value uint32) {
	volatile.StoreUint32(&o.CLKDIV1.Reg, volatile.LoadUint32(&o.CLKDIV1.Reg)&^(0xf0000000)|value<<28)
}
func (o *SIM_Type) GetCLKDIV1_OUTDIV1() uint32 {
	return (volatile.LoadUint32(&o.CLKDIV1.Reg) & 0xf0000000) >> 28
}

// SIM.FCFG1: Flash Configuration Register 1
func (o *SIM_Type) SetFCFG1_FLASHDIS(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetFCFG1_FLASHDIS() uint32 {
	return volatile.LoadUint32(&o.FCFG1.Reg) & 0x1
}
func (o *SIM_Type) SetFCFG1_FLASHDOZE(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetFCFG1_FLASHDOZE() uint32 {
	return (volatile.LoadUint32(&o.FCFG1.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetFCFG1_PFSIZE(value uint32) {
	volatile.StoreUint32(&o.FCFG1.Reg, volatile.LoadUint32(&o.FCFG1.Reg)&^(0xf000000)|value<<24)
}
func (o *SIM_Type) GetFCFG1_PFSIZE() uint32 {
	return (volatile.LoadUint32(&o.FCFG1.Reg) & 0xf000000) >> 24
}

// SIM.FCFG2: Flash Configuration Register 2
func (o *SIM_Type) SetFCFG2_MAXADDR1(value uint32) {
	volatile.StoreUint32(&o.FCFG2.Reg, volatile.LoadUint32(&o.FCFG2.Reg)&^(0x7f0000)|value<<16)
}
func (o *SIM_Type) GetFCFG2_MAXADDR1() uint32 {
	return (volatile.LoadUint32(&o.FCFG2.Reg) & 0x7f0000) >> 16
}
func (o *SIM_Type) SetFCFG2_MAXADDR0(value uint32) {
	volatile.StoreUint32(&o.FCFG2.Reg, volatile.LoadUint32(&o.FCFG2.Reg)&^(0x7f000000)|value<<24)
}
func (o *SIM_Type) GetFCFG2_MAXADDR0() uint32 {
	return (volatile.LoadUint32(&o.FCFG2.Reg) & 0x7f000000) >> 24
}

// SIM.UIDMH: Unique Identification Register Mid-High
func (o *SIM_Type) SetUIDMH_UID(value uint32) {
	volatile.StoreUint32(&o.UIDMH.Reg, volatile.LoadUint32(&o.UIDMH.Reg)&^(0xffff)|value)
}
func (o *SIM_Type) GetUIDMH_UID() uint32 {
	return volatile.LoadUint32(&o.UIDMH.Reg) & 0xffff
}

// SIM.UIDML: Unique Identification Register Mid Low
func (o *SIM_Type) SetUIDML(value uint32) {
	volatile.StoreUint32(&o.UIDML.Reg, value)
}
func (o *SIM_Type) GetUIDML() uint32 {
	return volatile.LoadUint32(&o.UIDML.Reg)
}

// SIM.UIDL: Unique Identification Register Low
func (o *SIM_Type) SetUIDL(value uint32) {
	volatile.StoreUint32(&o.UIDL.Reg, value)
}
func (o *SIM_Type) GetUIDL() uint32 {
	return volatile.LoadUint32(&o.UIDL.Reg)
}

// SIM.COPC: COP Control Register
func (o *SIM_Type) SetCOPC_COPW(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0x1)|value)
}
func (o *SIM_Type) GetCOPC_COPW() uint32 {
	return volatile.LoadUint32(&o.COPC.Reg) & 0x1
}
func (o *SIM_Type) SetCOPC_COPCLKS(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0x2)|value<<1)
}
func (o *SIM_Type) GetCOPC_COPCLKS() uint32 {
	return (volatile.LoadUint32(&o.COPC.Reg) & 0x2) >> 1
}
func (o *SIM_Type) SetCOPC_COPT(value uint32) {
	volatile.StoreUint32(&o.COPC.Reg, volatile.LoadUint32(&o.COPC.Reg)&^(0xc)|value<<2)
}
func (o *SIM_Type) GetCOPC_COPT() uint32 {
	return (volatile.LoadUint32(&o.COPC.Reg) & 0xc) >> 2
}

// SIM.SRVCOP: Service COP
func (o *SIM_Type) SetSRVCOP(value uint32) {
	volatile.StoreUint32(&o.SRVCOP.Reg, volatile.LoadUint32(&o.SRVCOP.Reg)&^(0xff)|value)
}
func (o *SIM_Type) GetSRVCOP() uint32 {
	return volatile.LoadUint32(&o.SRVCOP.Reg) & 0xff
}

// Pin Control and Interrupts
type PORT_Type struct {
	PCR0  volatile.Register32 // 0x0
	PCR1  volatile.Register32 // 0x4
	PCR2  volatile.Register32 // 0x8
	PCR3  volatile.Register32 // 0xC
	PCR4  volatile.Register32 // 0x10
	PCR5  volatile.Register32 // 0x14
	PCR6  volatile.Register32 // 0x18
	PCR7  volatile.Register32 // 0x1C
	PCR8  volatile.Register32 // 0x20
	PCR9  volatile.Register32 // 0x24
	PCR10 volatile.Register32 // 0x28
	PCR11 volatile.Register32 // 0x2C
	PCR12 volatile.Register32 // 0x30
	PCR13 volatile.Register32 // 0x34
	PCR14 volatile.Register32 // 0x38
	PCR15 volatile.Register32 // 0x3C
	PCR16 volatile.Register32 // 0x40
	PCR17 volatile.Register32 // 0x44
	PCR18 volatile.Register32 // 0x48
	PCR19 volatile.Register32 // 0x4C
	PCR20 volatile.Register32 // 0x50
	PCR21 volatile.Register32 // 0x54
	PCR22 volatile.Register32 // 0x58
	PCR23 volatile.Register32 // 0x5C
	PCR24 volatile.Register32 // 0x60
	PCR25 volatile.Register32 // 0x64
	PCR26 volatile.Register32 // 0x68
	PCR27 volatile.Register32 // 0x6C
	PCR28 volatile.Register32 // 0x70
	PCR29 volatile.Register32 // 0x74
	PCR30 volatile.Register32 // 0x78
	PCR31 volatile.Register32 // 0x7C
	GPCLR volatile.Register32 // 0x80
	GPCHR volatile.Register32 // 0x84
	_     [24]byte
	ISFR  volatile.Register32 // 0xA0
}

// PORT.PCR0: Pin Control Register n
func (o *PORT_Type) SetPCR0_PS(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR0_PS() uint32 {
	return volatile.LoadUint32(&o.PCR0.Reg) & 0x1
}
func (o *PORT_Type) SetPCR0_PE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR0_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR0_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR0_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR0_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR0_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR0_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR0_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR0_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR0_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR0_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR0_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR0_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR0.Reg, volatile.LoadUint32(&o.PCR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR0_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR0.Reg) & 0x1000000) >> 24
}

// PORT.PCR1: Pin Control Register n
func (o *PORT_Type) SetPCR1_PS(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR1_PS() uint32 {
	return volatile.LoadUint32(&o.PCR1.Reg) & 0x1
}
func (o *PORT_Type) SetPCR1_PE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR1_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR1_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR1_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR1_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR1_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR1_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR1_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR1_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR1_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR1_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR1_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR1_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR1.Reg, volatile.LoadUint32(&o.PCR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR1_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR1.Reg) & 0x1000000) >> 24
}

// PORT.PCR2: Pin Control Register n
func (o *PORT_Type) SetPCR2_PS(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR2_PS() uint32 {
	return volatile.LoadUint32(&o.PCR2.Reg) & 0x1
}
func (o *PORT_Type) SetPCR2_PE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR2_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR2_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR2_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR2_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR2_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR2_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR2_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR2_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR2_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR2_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR2_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR2_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR2.Reg, volatile.LoadUint32(&o.PCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR2_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR2.Reg) & 0x1000000) >> 24
}

// PORT.PCR3: Pin Control Register n
func (o *PORT_Type) SetPCR3_PS(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR3_PS() uint32 {
	return volatile.LoadUint32(&o.PCR3.Reg) & 0x1
}
func (o *PORT_Type) SetPCR3_PE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR3_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR3_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR3_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR3_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR3_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR3_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR3_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR3_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR3_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR3_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR3_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR3_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR3.Reg, volatile.LoadUint32(&o.PCR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR3_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR3.Reg) & 0x1000000) >> 24
}

// PORT.PCR4: Pin Control Register n
func (o *PORT_Type) SetPCR4_PS(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR4_PS() uint32 {
	return volatile.LoadUint32(&o.PCR4.Reg) & 0x1
}
func (o *PORT_Type) SetPCR4_PE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR4_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR4_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR4_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR4_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR4_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR4_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR4_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR4_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR4_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR4_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR4_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR4_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR4.Reg, volatile.LoadUint32(&o.PCR4.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR4_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR4.Reg) & 0x1000000) >> 24
}

// PORT.PCR5: Pin Control Register n
func (o *PORT_Type) SetPCR5_PS(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR5_PS() uint32 {
	return volatile.LoadUint32(&o.PCR5.Reg) & 0x1
}
func (o *PORT_Type) SetPCR5_PE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR5_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR5_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR5_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR5_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR5_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR5_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR5_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR5_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR5_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR5_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR5_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR5_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR5.Reg, volatile.LoadUint32(&o.PCR5.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR5_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR5.Reg) & 0x1000000) >> 24
}

// PORT.PCR6: Pin Control Register n
func (o *PORT_Type) SetPCR6_PS(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR6_PS() uint32 {
	return volatile.LoadUint32(&o.PCR6.Reg) & 0x1
}
func (o *PORT_Type) SetPCR6_PE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR6_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR6_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR6_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR6_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR6_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR6_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR6_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR6_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR6_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR6_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR6_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR6_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR6.Reg, volatile.LoadUint32(&o.PCR6.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR6_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR6.Reg) & 0x1000000) >> 24
}

// PORT.PCR7: Pin Control Register n
func (o *PORT_Type) SetPCR7_PS(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR7_PS() uint32 {
	return volatile.LoadUint32(&o.PCR7.Reg) & 0x1
}
func (o *PORT_Type) SetPCR7_PE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR7_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR7_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR7_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR7_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR7_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR7_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR7_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR7_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR7_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR7_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR7_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR7_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR7.Reg, volatile.LoadUint32(&o.PCR7.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR7_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR7.Reg) & 0x1000000) >> 24
}

// PORT.PCR8: Pin Control Register n
func (o *PORT_Type) SetPCR8_PS(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR8_PS() uint32 {
	return volatile.LoadUint32(&o.PCR8.Reg) & 0x1
}
func (o *PORT_Type) SetPCR8_PE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR8_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR8_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR8_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR8_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR8_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR8_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR8_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR8_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR8_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR8_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR8_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR8_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR8.Reg, volatile.LoadUint32(&o.PCR8.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR8_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR8.Reg) & 0x1000000) >> 24
}

// PORT.PCR9: Pin Control Register n
func (o *PORT_Type) SetPCR9_PS(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR9_PS() uint32 {
	return volatile.LoadUint32(&o.PCR9.Reg) & 0x1
}
func (o *PORT_Type) SetPCR9_PE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR9_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR9_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR9_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR9_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR9_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR9_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR9_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR9_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR9_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR9_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR9_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR9_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR9.Reg, volatile.LoadUint32(&o.PCR9.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR9_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR9.Reg) & 0x1000000) >> 24
}

// PORT.PCR10: Pin Control Register n
func (o *PORT_Type) SetPCR10_PS(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR10_PS() uint32 {
	return volatile.LoadUint32(&o.PCR10.Reg) & 0x1
}
func (o *PORT_Type) SetPCR10_PE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR10_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR10_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR10_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR10_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR10_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR10_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR10_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR10_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR10_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR10_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR10_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR10_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR10.Reg, volatile.LoadUint32(&o.PCR10.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR10_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR10.Reg) & 0x1000000) >> 24
}

// PORT.PCR11: Pin Control Register n
func (o *PORT_Type) SetPCR11_PS(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR11_PS() uint32 {
	return volatile.LoadUint32(&o.PCR11.Reg) & 0x1
}
func (o *PORT_Type) SetPCR11_PE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR11_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR11_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR11_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR11_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR11_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR11_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR11_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR11_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR11_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR11_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR11_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR11_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR11.Reg, volatile.LoadUint32(&o.PCR11.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR11_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR11.Reg) & 0x1000000) >> 24
}

// PORT.PCR12: Pin Control Register n
func (o *PORT_Type) SetPCR12_PS(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR12_PS() uint32 {
	return volatile.LoadUint32(&o.PCR12.Reg) & 0x1
}
func (o *PORT_Type) SetPCR12_PE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR12_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR12_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR12_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR12_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR12_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR12_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR12_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR12_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR12_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR12_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR12_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR12_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR12.Reg, volatile.LoadUint32(&o.PCR12.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR12_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR12.Reg) & 0x1000000) >> 24
}

// PORT.PCR13: Pin Control Register n
func (o *PORT_Type) SetPCR13_PS(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR13_PS() uint32 {
	return volatile.LoadUint32(&o.PCR13.Reg) & 0x1
}
func (o *PORT_Type) SetPCR13_PE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR13_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR13_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR13_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR13_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR13_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR13_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR13_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR13_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR13_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR13_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR13_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR13_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR13.Reg, volatile.LoadUint32(&o.PCR13.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR13_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR13.Reg) & 0x1000000) >> 24
}

// PORT.PCR14: Pin Control Register n
func (o *PORT_Type) SetPCR14_PS(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR14_PS() uint32 {
	return volatile.LoadUint32(&o.PCR14.Reg) & 0x1
}
func (o *PORT_Type) SetPCR14_PE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR14_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR14_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR14_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR14_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR14_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR14_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR14_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR14_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR14_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR14_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR14_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR14_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR14.Reg, volatile.LoadUint32(&o.PCR14.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR14_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR14.Reg) & 0x1000000) >> 24
}

// PORT.PCR15: Pin Control Register n
func (o *PORT_Type) SetPCR15_PS(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR15_PS() uint32 {
	return volatile.LoadUint32(&o.PCR15.Reg) & 0x1
}
func (o *PORT_Type) SetPCR15_PE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR15_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR15_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR15_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR15_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR15_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR15_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR15_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR15_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR15_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR15_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR15_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR15_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR15.Reg, volatile.LoadUint32(&o.PCR15.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR15_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR15.Reg) & 0x1000000) >> 24
}

// PORT.PCR16: Pin Control Register n
func (o *PORT_Type) SetPCR16_PS(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR16_PS() uint32 {
	return volatile.LoadUint32(&o.PCR16.Reg) & 0x1
}
func (o *PORT_Type) SetPCR16_PE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR16_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR16_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR16_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR16_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR16_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR16_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR16_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR16_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR16_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR16_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR16_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR16_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR16.Reg, volatile.LoadUint32(&o.PCR16.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR16_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR16.Reg) & 0x1000000) >> 24
}

// PORT.PCR17: Pin Control Register n
func (o *PORT_Type) SetPCR17_PS(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR17_PS() uint32 {
	return volatile.LoadUint32(&o.PCR17.Reg) & 0x1
}
func (o *PORT_Type) SetPCR17_PE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR17_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR17_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR17_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR17_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR17_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR17_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR17_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR17_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR17_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR17_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR17_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR17_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR17.Reg, volatile.LoadUint32(&o.PCR17.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR17_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR17.Reg) & 0x1000000) >> 24
}

// PORT.PCR18: Pin Control Register n
func (o *PORT_Type) SetPCR18_PS(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR18_PS() uint32 {
	return volatile.LoadUint32(&o.PCR18.Reg) & 0x1
}
func (o *PORT_Type) SetPCR18_PE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR18_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR18_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR18_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR18_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR18_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR18_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR18_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR18_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR18_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR18_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR18_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR18_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR18.Reg, volatile.LoadUint32(&o.PCR18.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR18_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR18.Reg) & 0x1000000) >> 24
}

// PORT.PCR19: Pin Control Register n
func (o *PORT_Type) SetPCR19_PS(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR19_PS() uint32 {
	return volatile.LoadUint32(&o.PCR19.Reg) & 0x1
}
func (o *PORT_Type) SetPCR19_PE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR19_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR19_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR19_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR19_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR19_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR19_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR19_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR19_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR19_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR19_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR19_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR19_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR19.Reg, volatile.LoadUint32(&o.PCR19.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR19_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR19.Reg) & 0x1000000) >> 24
}

// PORT.PCR20: Pin Control Register n
func (o *PORT_Type) SetPCR20_PS(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR20_PS() uint32 {
	return volatile.LoadUint32(&o.PCR20.Reg) & 0x1
}
func (o *PORT_Type) SetPCR20_PE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR20_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR20_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR20_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR20_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR20_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR20_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR20_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR20_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR20_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR20_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR20_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR20_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR20.Reg, volatile.LoadUint32(&o.PCR20.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR20_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR20.Reg) & 0x1000000) >> 24
}

// PORT.PCR21: Pin Control Register n
func (o *PORT_Type) SetPCR21_PS(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR21_PS() uint32 {
	return volatile.LoadUint32(&o.PCR21.Reg) & 0x1
}
func (o *PORT_Type) SetPCR21_PE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR21_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR21_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR21_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR21_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR21_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR21_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR21_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR21_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR21_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR21_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR21_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR21_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR21.Reg, volatile.LoadUint32(&o.PCR21.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR21_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR21.Reg) & 0x1000000) >> 24
}

// PORT.PCR22: Pin Control Register n
func (o *PORT_Type) SetPCR22_PS(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR22_PS() uint32 {
	return volatile.LoadUint32(&o.PCR22.Reg) & 0x1
}
func (o *PORT_Type) SetPCR22_PE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR22_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR22_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR22_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR22_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR22_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR22_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR22_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR22_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR22_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR22_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR22_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR22_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR22.Reg, volatile.LoadUint32(&o.PCR22.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR22_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR22.Reg) & 0x1000000) >> 24
}

// PORT.PCR23: Pin Control Register n
func (o *PORT_Type) SetPCR23_PS(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR23_PS() uint32 {
	return volatile.LoadUint32(&o.PCR23.Reg) & 0x1
}
func (o *PORT_Type) SetPCR23_PE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR23_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR23_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR23_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR23_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR23_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR23_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR23_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR23_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR23_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR23_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR23_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR23_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR23.Reg, volatile.LoadUint32(&o.PCR23.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR23_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR23.Reg) & 0x1000000) >> 24
}

// PORT.PCR24: Pin Control Register n
func (o *PORT_Type) SetPCR24_PS(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR24_PS() uint32 {
	return volatile.LoadUint32(&o.PCR24.Reg) & 0x1
}
func (o *PORT_Type) SetPCR24_PE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR24_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR24_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR24_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR24_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR24_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR24_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR24_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR24_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR24_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR24_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR24_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR24_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR24.Reg, volatile.LoadUint32(&o.PCR24.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR24_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR24.Reg) & 0x1000000) >> 24
}

// PORT.PCR25: Pin Control Register n
func (o *PORT_Type) SetPCR25_PS(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR25_PS() uint32 {
	return volatile.LoadUint32(&o.PCR25.Reg) & 0x1
}
func (o *PORT_Type) SetPCR25_PE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR25_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR25_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR25_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR25_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR25_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR25_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR25_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR25_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR25_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR25_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR25_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR25_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR25.Reg, volatile.LoadUint32(&o.PCR25.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR25_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR25.Reg) & 0x1000000) >> 24
}

// PORT.PCR26: Pin Control Register n
func (o *PORT_Type) SetPCR26_PS(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR26_PS() uint32 {
	return volatile.LoadUint32(&o.PCR26.Reg) & 0x1
}
func (o *PORT_Type) SetPCR26_PE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR26_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR26_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR26_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR26_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR26_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR26_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR26_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR26_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR26_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR26_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR26_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR26_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR26.Reg, volatile.LoadUint32(&o.PCR26.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR26_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR26.Reg) & 0x1000000) >> 24
}

// PORT.PCR27: Pin Control Register n
func (o *PORT_Type) SetPCR27_PS(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR27_PS() uint32 {
	return volatile.LoadUint32(&o.PCR27.Reg) & 0x1
}
func (o *PORT_Type) SetPCR27_PE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR27_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR27_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR27_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR27_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR27_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR27_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR27_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR27_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR27_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR27_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR27_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR27_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR27.Reg, volatile.LoadUint32(&o.PCR27.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR27_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR27.Reg) & 0x1000000) >> 24
}

// PORT.PCR28: Pin Control Register n
func (o *PORT_Type) SetPCR28_PS(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR28_PS() uint32 {
	return volatile.LoadUint32(&o.PCR28.Reg) & 0x1
}
func (o *PORT_Type) SetPCR28_PE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR28_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR28_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR28_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR28_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR28_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR28_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR28_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR28_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR28_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR28_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR28_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR28_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR28.Reg, volatile.LoadUint32(&o.PCR28.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR28_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR28.Reg) & 0x1000000) >> 24
}

// PORT.PCR29: Pin Control Register n
func (o *PORT_Type) SetPCR29_PS(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR29_PS() uint32 {
	return volatile.LoadUint32(&o.PCR29.Reg) & 0x1
}
func (o *PORT_Type) SetPCR29_PE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR29_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR29_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR29_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR29_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR29_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR29_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR29_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR29_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR29_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR29_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR29_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR29_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR29.Reg, volatile.LoadUint32(&o.PCR29.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR29_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR29.Reg) & 0x1000000) >> 24
}

// PORT.PCR30: Pin Control Register n
func (o *PORT_Type) SetPCR30_PS(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR30_PS() uint32 {
	return volatile.LoadUint32(&o.PCR30.Reg) & 0x1
}
func (o *PORT_Type) SetPCR30_PE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR30_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR30_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR30_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR30_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR30_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR30_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR30_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR30_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR30_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR30_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR30_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR30_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR30.Reg, volatile.LoadUint32(&o.PCR30.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR30_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR30.Reg) & 0x1000000) >> 24
}

// PORT.PCR31: Pin Control Register n
func (o *PORT_Type) SetPCR31_PS(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPCR31_PS() uint32 {
	return volatile.LoadUint32(&o.PCR31.Reg) & 0x1
}
func (o *PORT_Type) SetPCR31_PE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPCR31_PE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPCR31_SRE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPCR31_SRE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPCR31_PFE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x10)|value<<4)
}
func (o *PORT_Type) GetPCR31_PFE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x10) >> 4
}
func (o *PORT_Type) SetPCR31_DSE(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPCR31_DSE() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x40) >> 6
}
func (o *PORT_Type) SetPCR31_MUX(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x700)|value<<8)
}
func (o *PORT_Type) GetPCR31_MUX() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x700) >> 8
}
func (o *PORT_Type) SetPCR31_IRQC(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0xf0000)|value<<16)
}
func (o *PORT_Type) GetPCR31_IRQC() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0xf0000) >> 16
}
func (o *PORT_Type) SetPCR31_ISF(value uint32) {
	volatile.StoreUint32(&o.PCR31.Reg, volatile.LoadUint32(&o.PCR31.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT_Type) GetPCR31_ISF() uint32 {
	return (volatile.LoadUint32(&o.PCR31.Reg) & 0x1000000) >> 24
}

// PORT.GPCLR: Global Pin Control Low Register
func (o *PORT_Type) SetGPCLR_GPWD(value uint32) {
	volatile.StoreUint32(&o.GPCLR.Reg, volatile.LoadUint32(&o.GPCLR.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetGPCLR_GPWD() uint32 {
	return volatile.LoadUint32(&o.GPCLR.Reg) & 0xffff
}
func (o *PORT_Type) SetGPCLR_GPWE(value uint32) {
	volatile.StoreUint32(&o.GPCLR.Reg, volatile.LoadUint32(&o.GPCLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PORT_Type) GetGPCLR_GPWE() uint32 {
	return (volatile.LoadUint32(&o.GPCLR.Reg) & 0xffff0000) >> 16
}

// PORT.GPCHR: Global Pin Control High Register
func (o *PORT_Type) SetGPCHR_GPWD(value uint32) {
	volatile.StoreUint32(&o.GPCHR.Reg, volatile.LoadUint32(&o.GPCHR.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetGPCHR_GPWD() uint32 {
	return volatile.LoadUint32(&o.GPCHR.Reg) & 0xffff
}
func (o *PORT_Type) SetGPCHR_GPWE(value uint32) {
	volatile.StoreUint32(&o.GPCHR.Reg, volatile.LoadUint32(&o.GPCHR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PORT_Type) GetGPCHR_GPWE() uint32 {
	return (volatile.LoadUint32(&o.GPCHR.Reg) & 0xffff0000) >> 16
}

// PORT.ISFR: Interrupt Status Flag Register
func (o *PORT_Type) SetISFR(value uint32) {
	volatile.StoreUint32(&o.ISFR.Reg, value)
}
func (o *PORT_Type) GetISFR() uint32 {
	return volatile.LoadUint32(&o.ISFR.Reg)
}

// Multipurpose Clock Generator module
type MCG_Type struct {
	C1    volatile.Register8 // 0x0
	C2    volatile.Register8 // 0x1
	C3    volatile.Register8 // 0x2
	C4    volatile.Register8 // 0x3
	C5    volatile.Register8 // 0x4
	C6    volatile.Register8 // 0x5
	S     volatile.Register8 // 0x6
	_     byte
	SC    volatile.Register8 // 0x8
	_     byte
	ATCVH volatile.Register8 // 0xA
	ATCVL volatile.Register8 // 0xB
	C7    volatile.Register8 // 0xC
	C8    volatile.Register8 // 0xD
	C9    volatile.Register8 // 0xE
	C10   volatile.Register8 // 0xF
}

// MCG.C1: MCG Control 1 Register
func (o *MCG_Type) SetC1_IREFSTEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC1_IREFSTEN() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *MCG_Type) SetC1_IRCLKEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *MCG_Type) GetC1_IRCLKEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *MCG_Type) SetC1_IREFS(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *MCG_Type) GetC1_IREFS() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *MCG_Type) SetC1_FRDIV(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x38)|value<<3)
}
func (o *MCG_Type) GetC1_FRDIV() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x38) >> 3
}
func (o *MCG_Type) SetC1_CLKS(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0xc0)|value<<6)
}
func (o *MCG_Type) GetC1_CLKS() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0xc0) >> 6
}

// MCG.C2: MCG Control 2 Register
func (o *MCG_Type) SetC2_IRCS(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC2_IRCS() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *MCG_Type) SetC2_LP(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x2)|value<<1)
}
func (o *MCG_Type) GetC2_LP() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x2) >> 1
}
func (o *MCG_Type) SetC2_EREFS0(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x4)|value<<2)
}
func (o *MCG_Type) GetC2_EREFS0() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x4) >> 2
}
func (o *MCG_Type) SetC2_HGO0(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *MCG_Type) GetC2_HGO0() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *MCG_Type) SetC2_RANGE0(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x30)|value<<4)
}
func (o *MCG_Type) GetC2_RANGE0() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x30) >> 4
}
func (o *MCG_Type) SetC2_FCFTRIM(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC2_FCFTRIM() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetC2_LOCRE0(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetC2_LOCRE0() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// MCG.C3: MCG Control 3 Register
func (o *MCG_Type) SetC3(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, value)
}
func (o *MCG_Type) GetC3() uint8 {
	return volatile.LoadUint8(&o.C3.Reg)
}

// MCG.C4: MCG Control 4 Register
func (o *MCG_Type) SetC4_SCFTRIM(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC4_SCFTRIM() uint8 {
	return volatile.LoadUint8(&o.C4.Reg) & 0x1
}
func (o *MCG_Type) SetC4_FCTRIM(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x1e)|value<<1)
}
func (o *MCG_Type) GetC4_FCTRIM() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x1e) >> 1
}
func (o *MCG_Type) SetC4_DRST_DRS(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x60)|value<<5)
}
func (o *MCG_Type) GetC4_DRST_DRS() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x60) >> 5
}
func (o *MCG_Type) SetC4_DMX32(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetC4_DMX32() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x80) >> 7
}

// MCG.C5: MCG Control 5 Register
func (o *MCG_Type) SetC5_PRDIV0(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x1f)|value)
}
func (o *MCG_Type) GetC5_PRDIV0() uint8 {
	return volatile.LoadUint8(&o.C5.Reg) & 0x1f
}
func (o *MCG_Type) SetC5_PLLSTEN0(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetC5_PLLSTEN0() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetC5_PLLCLKEN0(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC5_PLLCLKEN0() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x40) >> 6
}

// MCG.C6: MCG Control 6 Register
func (o *MCG_Type) SetC6_VDIV0(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x1f)|value)
}
func (o *MCG_Type) GetC6_VDIV0() uint8 {
	return volatile.LoadUint8(&o.C6.Reg) & 0x1f
}
func (o *MCG_Type) SetC6_CME0(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetC6_CME0() uint8 {
	return (volatile.LoadUint8(&o.C6.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetC6_PLLS(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC6_PLLS() uint8 {
	return (volatile.LoadUint8(&o.C6.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetC6_LOLIE0(value uint8) {
	volatile.StoreUint8(&o.C6.Reg, volatile.LoadUint8(&o.C6.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetC6_LOLIE0() uint8 {
	return (volatile.LoadUint8(&o.C6.Reg) & 0x80) >> 7
}

// MCG.S: MCG Status Register
func (o *MCG_Type) SetS_IRCST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetS_IRCST() uint8 {
	return volatile.LoadUint8(&o.S.Reg) & 0x1
}
func (o *MCG_Type) SetS_OSCINIT0(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x2)|value<<1)
}
func (o *MCG_Type) GetS_OSCINIT0() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x2) >> 1
}
func (o *MCG_Type) SetS_CLKST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0xc)|value<<2)
}
func (o *MCG_Type) GetS_CLKST() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0xc) >> 2
}
func (o *MCG_Type) SetS_IREFST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x10)|value<<4)
}
func (o *MCG_Type) GetS_IREFST() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x10) >> 4
}
func (o *MCG_Type) SetS_PLLST(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetS_PLLST() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetS_LOCK0(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetS_LOCK0() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetS_LOLS0(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetS_LOLS0() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x80) >> 7
}

// MCG.SC: MCG Status and Control Register
func (o *MCG_Type) SetSC_LOCS0(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetSC_LOCS0() uint8 {
	return volatile.LoadUint8(&o.SC.Reg) & 0x1
}
func (o *MCG_Type) SetSC_FCRDIV(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0xe)|value<<1)
}
func (o *MCG_Type) GetSC_FCRDIV() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0xe) >> 1
}
func (o *MCG_Type) SetSC_FLTPRSRV(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x10)|value<<4)
}
func (o *MCG_Type) GetSC_FLTPRSRV() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x10) >> 4
}
func (o *MCG_Type) SetSC_ATMF(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x20)|value<<5)
}
func (o *MCG_Type) GetSC_ATMF() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x20) >> 5
}
func (o *MCG_Type) SetSC_ATMS(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetSC_ATMS() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x40) >> 6
}
func (o *MCG_Type) SetSC_ATME(value uint8) {
	volatile.StoreUint8(&o.SC.Reg, volatile.LoadUint8(&o.SC.Reg)&^(0x80)|value<<7)
}
func (o *MCG_Type) GetSC_ATME() uint8 {
	return (volatile.LoadUint8(&o.SC.Reg) & 0x80) >> 7
}

// MCG.ATCVH: MCG Auto Trim Compare Value High Register
func (o *MCG_Type) SetATCVH(value uint8) {
	volatile.StoreUint8(&o.ATCVH.Reg, value)
}
func (o *MCG_Type) GetATCVH() uint8 {
	return volatile.LoadUint8(&o.ATCVH.Reg)
}

// MCG.ATCVL: MCG Auto Trim Compare Value Low Register
func (o *MCG_Type) SetATCVL(value uint8) {
	volatile.StoreUint8(&o.ATCVL.Reg, value)
}
func (o *MCG_Type) GetATCVL() uint8 {
	return volatile.LoadUint8(&o.ATCVL.Reg)
}

// MCG.C7: MCG Control 7 Register
func (o *MCG_Type) SetC7_OSCSEL(value uint8) {
	volatile.StoreUint8(&o.C7.Reg, volatile.LoadUint8(&o.C7.Reg)&^(0x1)|value)
}
func (o *MCG_Type) GetC7_OSCSEL() uint8 {
	return volatile.LoadUint8(&o.C7.Reg) & 0x1
}

// MCG.C8: MCG Control 8 Register
func (o *MCG_Type) SetC8_LOLRE(value uint8) {
	volatile.StoreUint8(&o.C8.Reg, volatile.LoadUint8(&o.C8.Reg)&^(0x40)|value<<6)
}
func (o *MCG_Type) GetC8_LOLRE() uint8 {
	return (volatile.LoadUint8(&o.C8.Reg) & 0x40) >> 6
}

// Oscillator
type OSC0_Type struct {
	CR volatile.Register8 // 0x0
}

// OSC0.CR: OSC Control Register
func (o *OSC0_Type) SetCR_SC16P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x1)|value)
}
func (o *OSC0_Type) GetCR_SC16P() uint8 {
	return volatile.LoadUint8(&o.CR.Reg) & 0x1
}
func (o *OSC0_Type) SetCR_SC8P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *OSC0_Type) GetCR_SC8P() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x2) >> 1
}
func (o *OSC0_Type) SetCR_SC4P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *OSC0_Type) GetCR_SC4P() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x4) >> 2
}
func (o *OSC0_Type) SetCR_SC2P(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *OSC0_Type) GetCR_SC2P() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x8) >> 3
}
func (o *OSC0_Type) SetCR_EREFSTEN(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *OSC0_Type) GetCR_EREFSTEN() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x20) >> 5
}
func (o *OSC0_Type) SetCR_ERCLKEN(value uint8) {
	volatile.StoreUint8(&o.CR.Reg, volatile.LoadUint8(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *OSC0_Type) GetCR_ERCLKEN() uint8 {
	return (volatile.LoadUint8(&o.CR.Reg) & 0x80) >> 7
}

// Inter-Integrated Circuit
type I2C_Type struct {
	A1   volatile.Register8 // 0x0
	F    volatile.Register8 // 0x1
	C1   volatile.Register8 // 0x2
	S    volatile.Register8 // 0x3
	D    volatile.Register8 // 0x4
	C2   volatile.Register8 // 0x5
	FLT  volatile.Register8 // 0x6
	RA   volatile.Register8 // 0x7
	SMB  volatile.Register8 // 0x8
	A2   volatile.Register8 // 0x9
	SLTH volatile.Register8 // 0xA
	SLTL volatile.Register8 // 0xB
}

// I2C.A1: I2C Address Register 1
func (o *I2C_Type) SetA1_AD(value uint8) {
	volatile.StoreUint8(&o.A1.Reg, volatile.LoadUint8(&o.A1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetA1_AD() uint8 {
	return (volatile.LoadUint8(&o.A1.Reg) & 0xfe) >> 1
}

// I2C.F: I2C Frequency Divider register
func (o *I2C_Type) SetF_ICR(value uint8) {
	volatile.StoreUint8(&o.F.Reg, volatile.LoadUint8(&o.F.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetF_ICR() uint8 {
	return volatile.LoadUint8(&o.F.Reg) & 0x3f
}
func (o *I2C_Type) SetF_MULT(value uint8) {
	volatile.StoreUint8(&o.F.Reg, volatile.LoadUint8(&o.F.Reg)&^(0xc0)|value<<6)
}
func (o *I2C_Type) GetF_MULT() uint8 {
	return (volatile.LoadUint8(&o.F.Reg) & 0xc0) >> 6
}

// I2C.C1: I2C Control Register 1
func (o *I2C_Type) SetC1_DMAEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetC1_DMAEN() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *I2C_Type) SetC1_WUEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetC1_WUEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetC1_RSTA(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetC1_RSTA() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetC1_TXAK(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetC1_TXAK() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetC1_TX(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetC1_TX() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetC1_MST(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetC1_MST() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetC1_IICIE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetC1_IICIE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetC1_IICEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetC1_IICEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// I2C.S: I2C Status register
func (o *I2C_Type) SetS_RXAK(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetS_RXAK() uint8 {
	return volatile.LoadUint8(&o.S.Reg) & 0x1
}
func (o *I2C_Type) SetS_IICIF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetS_IICIF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetS_SRW(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetS_SRW() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetS_RAM(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetS_RAM() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetS_ARBL(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetS_ARBL() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetS_BUSY(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetS_BUSY() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetS_IAAS(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetS_IAAS() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetS_TCF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetS_TCF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x80) >> 7
}

// I2C.D: I2C Data I/O register
func (o *I2C_Type) SetD(value uint8) {
	volatile.StoreUint8(&o.D.Reg, value)
}
func (o *I2C_Type) GetD() uint8 {
	return volatile.LoadUint8(&o.D.Reg)
}

// I2C.C2: I2C Control Register 2
func (o *I2C_Type) SetC2_AD(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetC2_AD() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x7
}
func (o *I2C_Type) SetC2_RMEN(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetC2_RMEN() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetC2_SBRC(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetC2_SBRC() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetC2_HDRS(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetC2_HDRS() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetC2_ADEXT(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetC2_ADEXT() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetC2_GCAEN(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetC2_GCAEN() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// I2C.FLT: I2C Programmable Input Glitch Filter register
func (o *I2C_Type) SetFLT(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFLT() uint8 {
	return volatile.LoadUint8(&o.FLT.Reg) & 0xf
}
func (o *I2C_Type) SetFLT_STARTF(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetFLT_STARTF() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetFLT_SSIE(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetFLT_SSIE() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetFLT_STOPF(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetFLT_STOPF() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetFLT_SHEN(value uint8) {
	volatile.StoreUint8(&o.FLT.Reg, volatile.LoadUint8(&o.FLT.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetFLT_SHEN() uint8 {
	return (volatile.LoadUint8(&o.FLT.Reg) & 0x80) >> 7
}

// I2C.RA: I2C Range Address register
func (o *I2C_Type) SetRA_RAD(value uint8) {
	volatile.StoreUint8(&o.RA.Reg, volatile.LoadUint8(&o.RA.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetRA_RAD() uint8 {
	return (volatile.LoadUint8(&o.RA.Reg) & 0xfe) >> 1
}

// I2C.SMB: I2C SMBus Control and Status register
func (o *I2C_Type) SetSMB_SHTF2IE(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSMB_SHTF2IE() uint8 {
	return volatile.LoadUint8(&o.SMB.Reg) & 0x1
}
func (o *I2C_Type) SetSMB_SHTF2(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSMB_SHTF2() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSMB_SHTF1(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSMB_SHTF1() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSMB_SLTF(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSMB_SLTF() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSMB_TCKSEL(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSMB_TCKSEL() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSMB_SIICAEN(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSMB_SIICAEN() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSMB_ALERTEN(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSMB_ALERTEN() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSMB_FACK(value uint8) {
	volatile.StoreUint8(&o.SMB.Reg, volatile.LoadUint8(&o.SMB.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSMB_FACK() uint8 {
	return (volatile.LoadUint8(&o.SMB.Reg) & 0x80) >> 7
}

// I2C.A2: I2C Address Register 2
func (o *I2C_Type) SetA2_SAD(value uint8) {
	volatile.StoreUint8(&o.A2.Reg, volatile.LoadUint8(&o.A2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetA2_SAD() uint8 {
	return (volatile.LoadUint8(&o.A2.Reg) & 0xfe) >> 1
}

// I2C.SLTH: I2C SCL Low Timeout Register High
func (o *I2C_Type) SetSLTH(value uint8) {
	volatile.StoreUint8(&o.SLTH.Reg, value)
}
func (o *I2C_Type) GetSLTH() uint8 {
	return volatile.LoadUint8(&o.SLTH.Reg)
}

// I2C.SLTL: I2C SCL Low Timeout Register Low
func (o *I2C_Type) SetSLTL(value uint8) {
	volatile.StoreUint8(&o.SLTL.Reg, value)
}
func (o *I2C_Type) GetSLTL() uint8 {
	return volatile.LoadUint8(&o.SLTL.Reg)
}

// Universal Asynchronous Receiver/Transmitter
type UART0_Type struct {
	BDH volatile.Register8 // 0x0
	BDL volatile.Register8 // 0x1
	C1  volatile.Register8 // 0x2
	C2  volatile.Register8 // 0x3
	S1  volatile.Register8 // 0x4
	S2  volatile.Register8 // 0x5
	C3  volatile.Register8 // 0x6
	D   volatile.Register8 // 0x7
	MA1 volatile.Register8 // 0x8
	MA2 volatile.Register8 // 0x9
	C4  volatile.Register8 // 0xA
	C5  volatile.Register8 // 0xB
}

// UART0.BDH: UART Baud Rate Register High
func (o *UART0_Type) SetBDH_SBR(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x1f)|value)
}
func (o *UART0_Type) GetBDH_SBR() uint8 {
	return volatile.LoadUint8(&o.BDH.Reg) & 0x1f
}
func (o *UART0_Type) SetBDH_SBNS(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetBDH_SBNS() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetBDH_RXEDGIE(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetBDH_RXEDGIE() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetBDH_LBKDIE(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetBDH_LBKDIE() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x80) >> 7
}

// UART0.BDL: UART Baud Rate Register Low
func (o *UART0_Type) SetBDL(value uint8) {
	volatile.StoreUint8(&o.BDL.Reg, value)
}
func (o *UART0_Type) GetBDL() uint8 {
	return volatile.LoadUint8(&o.BDL.Reg)
}

// UART0.C1: UART Control Register 1
func (o *UART0_Type) SetC1_PT(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetC1_PT() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *UART0_Type) SetC1_PE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetC1_PE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetC1_ILT(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetC1_ILT() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetC1_WAKE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetC1_WAKE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetC1_M(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetC1_M() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetC1_RSRC(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetC1_RSRC() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetC1_DOZEEN(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetC1_DOZEEN() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetC1_LOOPS(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetC1_LOOPS() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// UART0.C2: UART Control Register 2
func (o *UART0_Type) SetC2_SBK(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetC2_SBK() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *UART0_Type) SetC2_RWU(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetC2_RWU() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetC2_RE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetC2_RE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetC2_TE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetC2_TE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetC2_ILIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetC2_ILIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetC2_RIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetC2_RIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetC2_TCIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetC2_TCIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetC2_TIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetC2_TIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// UART0.S1: UART Status Register 1
func (o *UART0_Type) SetS1_PF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetS1_PF() uint8 {
	return volatile.LoadUint8(&o.S1.Reg) & 0x1
}
func (o *UART0_Type) SetS1_FE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetS1_FE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetS1_NF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetS1_NF() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetS1_OR(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetS1_OR() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetS1_IDLE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetS1_IDLE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetS1_RDRF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetS1_RDRF() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetS1_TC(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetS1_TC() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetS1_TDRE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetS1_TDRE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x80) >> 7
}

// UART0.S2: UART Status Register 2
func (o *UART0_Type) SetS2_RAF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetS2_RAF() uint8 {
	return volatile.LoadUint8(&o.S2.Reg) & 0x1
}
func (o *UART0_Type) SetS2_LBKDE(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetS2_LBKDE() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetS2_BRK13(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetS2_BRK13() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetS2_RWUID(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetS2_RWUID() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetS2_RXINV(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetS2_RXINV() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetS2_MSBF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetS2_MSBF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetS2_RXEDGIF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetS2_RXEDGIF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetS2_LBKDIF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetS2_LBKDIF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x80) >> 7
}

// UART0.C3: UART Control Register 3
func (o *UART0_Type) SetC3_PEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetC3_PEIE() uint8 {
	return volatile.LoadUint8(&o.C3.Reg) & 0x1
}
func (o *UART0_Type) SetC3_FEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetC3_FEIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetC3_NEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetC3_NEIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetC3_ORIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetC3_ORIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetC3_TXINV(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetC3_TXINV() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetC3_TXDIR(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetC3_TXDIR() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetC3_R9T8(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetC3_R9T8() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetC3_R8T9(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetC3_R8T9() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x80) >> 7
}

// UART0.D: UART Data Register
func (o *UART0_Type) SetD_R0T0(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetD_R0T0() uint8 {
	return volatile.LoadUint8(&o.D.Reg) & 0x1
}
func (o *UART0_Type) SetD_R1T1(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetD_R1T1() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetD_R2T2(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetD_R2T2() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetD_R3T3(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetD_R3T3() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetD_R4T4(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetD_R4T4() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetD_R5T5(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetD_R5T5() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetD_R6T6(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetD_R6T6() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetD_R7T7(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetD_R7T7() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x80) >> 7
}

// UART0.MA1: UART Match Address Registers 1
func (o *UART0_Type) SetMA1(value uint8) {
	volatile.StoreUint8(&o.MA1.Reg, value)
}
func (o *UART0_Type) GetMA1() uint8 {
	return volatile.LoadUint8(&o.MA1.Reg)
}

// UART0.MA2: UART Match Address Registers 2
func (o *UART0_Type) SetMA2(value uint8) {
	volatile.StoreUint8(&o.MA2.Reg, value)
}
func (o *UART0_Type) GetMA2() uint8 {
	return volatile.LoadUint8(&o.MA2.Reg)
}

// UART0.C4: UART Control Register 4
func (o *UART0_Type) SetC4_OSR(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x1f)|value)
}
func (o *UART0_Type) GetC4_OSR() uint8 {
	return volatile.LoadUint8(&o.C4.Reg) & 0x1f
}
func (o *UART0_Type) SetC4_M10(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetC4_M10() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetC4_MAEN2(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetC4_MAEN2() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetC4_MAEN1(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetC4_MAEN1() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x80) >> 7
}

// UART0.C5: UART Control Register 5
func (o *UART0_Type) SetC5_RESYNCDIS(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetC5_RESYNCDIS() uint8 {
	return volatile.LoadUint8(&o.C5.Reg) & 0x1
}
func (o *UART0_Type) SetC5_BOTHEDGE(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetC5_BOTHEDGE() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetC5_RDMAE(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetC5_RDMAE() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetC5_TDMAE(value uint8) {
	volatile.StoreUint8(&o.C5.Reg, volatile.LoadUint8(&o.C5.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetC5_TDMAE() uint8 {
	return (volatile.LoadUint8(&o.C5.Reg) & 0x80) >> 7
}

// Universal Asynchronous Receiver/Transmitter (UART)
type UART_Type struct {
	BDH volatile.Register8 // 0x0
	BDL volatile.Register8 // 0x1
	C1  volatile.Register8 // 0x2
	C2  volatile.Register8 // 0x3
	S1  volatile.Register8 // 0x4
	S2  volatile.Register8 // 0x5
	C3  volatile.Register8 // 0x6
	D   volatile.Register8 // 0x7
	C4  volatile.Register8 // 0x8
}

// UART.BDH: UART Baud Rate Register: High
func (o *UART_Type) SetBDH_SBR(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x1f)|value)
}
func (o *UART_Type) GetBDH_SBR() uint8 {
	return volatile.LoadUint8(&o.BDH.Reg) & 0x1f
}
func (o *UART_Type) SetBDH_SBNS(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetBDH_SBNS() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetBDH_RXEDGIE(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetBDH_RXEDGIE() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetBDH_LBKDIE(value uint8) {
	volatile.StoreUint8(&o.BDH.Reg, volatile.LoadUint8(&o.BDH.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetBDH_LBKDIE() uint8 {
	return (volatile.LoadUint8(&o.BDH.Reg) & 0x80) >> 7
}

// UART.BDL: UART Baud Rate Register: Low
func (o *UART_Type) SetBDL(value uint8) {
	volatile.StoreUint8(&o.BDL.Reg, value)
}
func (o *UART_Type) GetBDL() uint8 {
	return volatile.LoadUint8(&o.BDL.Reg)
}

// UART.C1: UART Control Register 1
func (o *UART_Type) SetC1_PT(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetC1_PT() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *UART_Type) SetC1_PE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetC1_PE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetC1_ILT(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetC1_ILT() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetC1_WAKE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetC1_WAKE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetC1_M(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetC1_M() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetC1_RSRC(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC1_RSRC() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC1_UARTSWAI(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetC1_UARTSWAI() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetC1_LOOPS(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC1_LOOPS() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// UART.C2: UART Control Register 2
func (o *UART_Type) SetC2_SBK(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetC2_SBK() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *UART_Type) SetC2_RWU(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetC2_RWU() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetC2_RE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetC2_RE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetC2_TE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetC2_TE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetC2_ILIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetC2_ILIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetC2_RIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC2_RIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC2_TCIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetC2_TCIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetC2_TIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC2_TIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// UART.S1: UART Status Register 1
func (o *UART_Type) SetS1_PF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetS1_PF() uint8 {
	return volatile.LoadUint8(&o.S1.Reg) & 0x1
}
func (o *UART_Type) SetS1_FE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetS1_FE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetS1_NF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetS1_NF() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetS1_OR(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetS1_OR() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetS1_IDLE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetS1_IDLE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetS1_RDRF(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetS1_RDRF() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetS1_TC(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetS1_TC() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetS1_TDRE(value uint8) {
	volatile.StoreUint8(&o.S1.Reg, volatile.LoadUint8(&o.S1.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetS1_TDRE() uint8 {
	return (volatile.LoadUint8(&o.S1.Reg) & 0x80) >> 7
}

// UART.S2: UART Status Register 2
func (o *UART_Type) SetS2_RAF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetS2_RAF() uint8 {
	return volatile.LoadUint8(&o.S2.Reg) & 0x1
}
func (o *UART_Type) SetS2_LBKDE(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetS2_LBKDE() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetS2_BRK13(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetS2_BRK13() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetS2_RWUID(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetS2_RWUID() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetS2_RXINV(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetS2_RXINV() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetS2_RXEDGIF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetS2_RXEDGIF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetS2_LBKDIF(value uint8) {
	volatile.StoreUint8(&o.S2.Reg, volatile.LoadUint8(&o.S2.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetS2_LBKDIF() uint8 {
	return (volatile.LoadUint8(&o.S2.Reg) & 0x80) >> 7
}

// UART.C3: UART Control Register 3
func (o *UART_Type) SetC3_PEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetC3_PEIE() uint8 {
	return volatile.LoadUint8(&o.C3.Reg) & 0x1
}
func (o *UART_Type) SetC3_FEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetC3_FEIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetC3_NEIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetC3_NEIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetC3_ORIE(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetC3_ORIE() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetC3_TXINV(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetC3_TXINV() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetC3_TXDIR(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC3_TXDIR() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC3_T8(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetC3_T8() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetC3_R8(value uint8) {
	volatile.StoreUint8(&o.C3.Reg, volatile.LoadUint8(&o.C3.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC3_R8() uint8 {
	return (volatile.LoadUint8(&o.C3.Reg) & 0x80) >> 7
}

// UART.D: UART Data Register
func (o *UART_Type) SetD_R0T0(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetD_R0T0() uint8 {
	return volatile.LoadUint8(&o.D.Reg) & 0x1
}
func (o *UART_Type) SetD_R1T1(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetD_R1T1() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetD_R2T2(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetD_R2T2() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetD_R3T3(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetD_R3T3() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetD_R4T4(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetD_R4T4() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetD_R5T5(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetD_R5T5() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetD_R6T6(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetD_R6T6() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetD_R7T7(value uint8) {
	volatile.StoreUint8(&o.D.Reg, volatile.LoadUint8(&o.D.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetD_R7T7() uint8 {
	return (volatile.LoadUint8(&o.D.Reg) & 0x80) >> 7
}

// UART.C4: UART Control Register 4
func (o *UART_Type) SetC4_RDMAS(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetC4_RDMAS() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetC4_TDMAS(value uint8) {
	volatile.StoreUint8(&o.C4.Reg, volatile.LoadUint8(&o.C4.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetC4_TDMAS() uint8 {
	return (volatile.LoadUint8(&o.C4.Reg) & 0x80) >> 7
}

// Universal Serial Bus, OTG Capable Controller
type USB0_Type struct {
	PERID        volatile.Register8 // 0x0
	_            [3]byte
	IDCOMP       volatile.Register8 // 0x4
	_            [3]byte
	REV          volatile.Register8 // 0x8
	_            [3]byte
	ADDINFO      volatile.Register8 // 0xC
	_            [3]byte
	OTGISTAT     volatile.Register8 // 0x10
	_            [3]byte
	OTGICR       volatile.Register8 // 0x14
	_            [3]byte
	OTGSTAT      volatile.Register8 // 0x18
	_            [3]byte
	OTGCTL       volatile.Register8 // 0x1C
	_            [99]byte
	ISTAT        volatile.Register8 // 0x80
	_            [3]byte
	INTEN        volatile.Register8 // 0x84
	_            [3]byte
	ERRSTAT      volatile.Register8 // 0x88
	_            [3]byte
	ERREN        volatile.Register8 // 0x8C
	_            [3]byte
	STAT         volatile.Register8 // 0x90
	_            [3]byte
	CTL          volatile.Register8 // 0x94
	_            [3]byte
	ADDR         volatile.Register8 // 0x98
	_            [3]byte
	BDTPAGE1     volatile.Register8 // 0x9C
	_            [3]byte
	FRMNUML      volatile.Register8 // 0xA0
	_            [3]byte
	FRMNUMH      volatile.Register8 // 0xA4
	_            [3]byte
	TOKEN        volatile.Register8 // 0xA8
	_            [3]byte
	SOFTHLD      volatile.Register8 // 0xAC
	_            [3]byte
	BDTPAGE2     volatile.Register8 // 0xB0
	_            [3]byte
	BDTPAGE3     volatile.Register8 // 0xB4
	_            [11]byte
	ENDPT0       volatile.Register8 // 0xC0
	_            [3]byte
	ENDPT1       volatile.Register8 // 0xC4
	_            [3]byte
	ENDPT2       volatile.Register8 // 0xC8
	_            [3]byte
	ENDPT3       volatile.Register8 // 0xCC
	_            [3]byte
	ENDPT4       volatile.Register8 // 0xD0
	_            [3]byte
	ENDPT5       volatile.Register8 // 0xD4
	_            [3]byte
	ENDPT6       volatile.Register8 // 0xD8
	_            [3]byte
	ENDPT7       volatile.Register8 // 0xDC
	_            [3]byte
	ENDPT8       volatile.Register8 // 0xE0
	_            [3]byte
	ENDPT9       volatile.Register8 // 0xE4
	_            [3]byte
	ENDPT10      volatile.Register8 // 0xE8
	_            [3]byte
	ENDPT11      volatile.Register8 // 0xEC
	_            [3]byte
	ENDPT12      volatile.Register8 // 0xF0
	_            [3]byte
	ENDPT13      volatile.Register8 // 0xF4
	_            [3]byte
	ENDPT14      volatile.Register8 // 0xF8
	_            [3]byte
	ENDPT15      volatile.Register8 // 0xFC
	_            [3]byte
	USBCTRL      volatile.Register8 // 0x100
	_            [3]byte
	OBSERVE      volatile.Register8 // 0x104
	_            [3]byte
	CONTROL      volatile.Register8 // 0x108
	_            [3]byte
	USBTRC0      volatile.Register8 // 0x10C
	_            [7]byte
	USBFRMADJUST volatile.Register8 // 0x114
}

// USB0.PERID: Peripheral ID register
func (o *USB0_Type) SetPERID_ID(value uint8) {
	volatile.StoreUint8(&o.PERID.Reg, volatile.LoadUint8(&o.PERID.Reg)&^(0x3f)|value)
}
func (o *USB0_Type) GetPERID_ID() uint8 {
	return volatile.LoadUint8(&o.PERID.Reg) & 0x3f
}

// USB0.IDCOMP: Peripheral ID Complement register
func (o *USB0_Type) SetIDCOMP_NID(value uint8) {
	volatile.StoreUint8(&o.IDCOMP.Reg, volatile.LoadUint8(&o.IDCOMP.Reg)&^(0x3f)|value)
}
func (o *USB0_Type) GetIDCOMP_NID() uint8 {
	return volatile.LoadUint8(&o.IDCOMP.Reg) & 0x3f
}

// USB0.REV: Peripheral Revision register
func (o *USB0_Type) SetREV(value uint8) {
	volatile.StoreUint8(&o.REV.Reg, value)
}
func (o *USB0_Type) GetREV() uint8 {
	return volatile.LoadUint8(&o.REV.Reg)
}

// USB0.ADDINFO: Peripheral Additional Info register
func (o *USB0_Type) SetADDINFO_IEHOST(value uint8) {
	volatile.StoreUint8(&o.ADDINFO.Reg, volatile.LoadUint8(&o.ADDINFO.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetADDINFO_IEHOST() uint8 {
	return volatile.LoadUint8(&o.ADDINFO.Reg) & 0x1
}
func (o *USB0_Type) SetADDINFO_IRQNUM(value uint8) {
	volatile.StoreUint8(&o.ADDINFO.Reg, volatile.LoadUint8(&o.ADDINFO.Reg)&^(0xf8)|value<<3)
}
func (o *USB0_Type) GetADDINFO_IRQNUM() uint8 {
	return (volatile.LoadUint8(&o.ADDINFO.Reg) & 0xf8) >> 3
}

// USB0.OTGISTAT: OTG Interrupt Status register
func (o *USB0_Type) SetOTGISTAT_AVBUSCHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetOTGISTAT_AVBUSCHG() uint8 {
	return volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x1
}
func (o *USB0_Type) SetOTGISTAT_B_SESS_CHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGISTAT_B_SESS_CHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGISTAT_SESSVLDCHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetOTGISTAT_SESSVLDCHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetOTGISTAT_LINE_STATE_CHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGISTAT_LINE_STATE_CHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGISTAT_ONEMSEC(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOTGISTAT_ONEMSEC() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOTGISTAT_IDCHG(value uint8) {
	volatile.StoreUint8(&o.OTGISTAT.Reg, volatile.LoadUint8(&o.OTGISTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGISTAT_IDCHG() uint8 {
	return (volatile.LoadUint8(&o.OTGISTAT.Reg) & 0x80) >> 7
}

// USB0.OTGICR: OTG Interrupt Control register
func (o *USB0_Type) SetOTGICR_AVBUSEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetOTGICR_AVBUSEN() uint8 {
	return volatile.LoadUint8(&o.OTGICR.Reg) & 0x1
}
func (o *USB0_Type) SetOTGICR_BSESSEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGICR_BSESSEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGICR_SESSVLDEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetOTGICR_SESSVLDEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetOTGICR_LINESTATEEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGICR_LINESTATEEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGICR_ONEMSECEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOTGICR_ONEMSECEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOTGICR_IDEN(value uint8) {
	volatile.StoreUint8(&o.OTGICR.Reg, volatile.LoadUint8(&o.OTGICR.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGICR_IDEN() uint8 {
	return (volatile.LoadUint8(&o.OTGICR.Reg) & 0x80) >> 7
}

// USB0.OTGSTAT: OTG Status register
func (o *USB0_Type) SetOTGSTAT_AVBUSVLD(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetOTGSTAT_AVBUSVLD() uint8 {
	return volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x1
}
func (o *USB0_Type) SetOTGSTAT_BSESSEND(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGSTAT_BSESSEND() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGSTAT_SESS_VLD(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetOTGSTAT_SESS_VLD() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetOTGSTAT_LINESTATESTABLE(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGSTAT_LINESTATESTABLE() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGSTAT_ONEMSECEN(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOTGSTAT_ONEMSECEN() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOTGSTAT_ID(value uint8) {
	volatile.StoreUint8(&o.OTGSTAT.Reg, volatile.LoadUint8(&o.OTGSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGSTAT_ID() uint8 {
	return (volatile.LoadUint8(&o.OTGSTAT.Reg) & 0x80) >> 7
}

// USB0.OTGCTL: OTG Control register
func (o *USB0_Type) SetOTGCTL_OTGEN(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetOTGCTL_OTGEN() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetOTGCTL_DMLOW(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetOTGCTL_DMLOW() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetOTGCTL_DPLOW(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetOTGCTL_DPLOW() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetOTGCTL_DPHIGH(value uint8) {
	volatile.StoreUint8(&o.OTGCTL.Reg, volatile.LoadUint8(&o.OTGCTL.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOTGCTL_DPHIGH() uint8 {
	return (volatile.LoadUint8(&o.OTGCTL.Reg) & 0x80) >> 7
}

// USB0.ISTAT: Interrupt Status register
func (o *USB0_Type) SetISTAT_USBRST(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetISTAT_USBRST() uint8 {
	return volatile.LoadUint8(&o.ISTAT.Reg) & 0x1
}
func (o *USB0_Type) SetISTAT_ERROR(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetISTAT_ERROR() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetISTAT_SOFTOK(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetISTAT_SOFTOK() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetISTAT_TOKDNE(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetISTAT_TOKDNE() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetISTAT_SLEEP(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetISTAT_SLEEP() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetISTAT_RESUME(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetISTAT_RESUME() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetISTAT_ATTACH(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetISTAT_ATTACH() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetISTAT_STALL(value uint8) {
	volatile.StoreUint8(&o.ISTAT.Reg, volatile.LoadUint8(&o.ISTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetISTAT_STALL() uint8 {
	return (volatile.LoadUint8(&o.ISTAT.Reg) & 0x80) >> 7
}

// USB0.INTEN: Interrupt Enable register
func (o *USB0_Type) SetINTEN_USBRSTEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetINTEN_USBRSTEN() uint8 {
	return volatile.LoadUint8(&o.INTEN.Reg) & 0x1
}
func (o *USB0_Type) SetINTEN_ERROREN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetINTEN_ERROREN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetINTEN_SOFTOKEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetINTEN_SOFTOKEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetINTEN_TOKDNEEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetINTEN_TOKDNEEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetINTEN_SLEEPEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetINTEN_SLEEPEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetINTEN_RESUMEEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetINTEN_RESUMEEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetINTEN_ATTACHEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetINTEN_ATTACHEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetINTEN_STALLEN(value uint8) {
	volatile.StoreUint8(&o.INTEN.Reg, volatile.LoadUint8(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetINTEN_STALLEN() uint8 {
	return (volatile.LoadUint8(&o.INTEN.Reg) & 0x80) >> 7
}

// USB0.ERRSTAT: Error Interrupt Status register
func (o *USB0_Type) SetERRSTAT_PIDERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetERRSTAT_PIDERR() uint8 {
	return volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x1
}
func (o *USB0_Type) SetERRSTAT_CRC5EOF(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetERRSTAT_CRC5EOF() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetERRSTAT_CRC16(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetERRSTAT_CRC16() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetERRSTAT_DFN8(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetERRSTAT_DFN8() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetERRSTAT_BTOERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetERRSTAT_BTOERR() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetERRSTAT_DMAERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetERRSTAT_DMAERR() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetERRSTAT_BTSERR(value uint8) {
	volatile.StoreUint8(&o.ERRSTAT.Reg, volatile.LoadUint8(&o.ERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetERRSTAT_BTSERR() uint8 {
	return (volatile.LoadUint8(&o.ERRSTAT.Reg) & 0x80) >> 7
}

// USB0.ERREN: Error Interrupt Enable register
func (o *USB0_Type) SetERREN_PIDERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetERREN_PIDERREN() uint8 {
	return volatile.LoadUint8(&o.ERREN.Reg) & 0x1
}
func (o *USB0_Type) SetERREN_CRC5EOFEN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetERREN_CRC5EOFEN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetERREN_CRC16EN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetERREN_CRC16EN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetERREN_DFN8EN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetERREN_DFN8EN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetERREN_BTOERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetERREN_BTOERREN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetERREN_DMAERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetERREN_DMAERREN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetERREN_BTSERREN(value uint8) {
	volatile.StoreUint8(&o.ERREN.Reg, volatile.LoadUint8(&o.ERREN.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetERREN_BTSERREN() uint8 {
	return (volatile.LoadUint8(&o.ERREN.Reg) & 0x80) >> 7
}

// USB0.STAT: Status register
func (o *USB0_Type) SetSTAT_ODD(value uint8) {
	volatile.StoreUint8(&o.STAT.Reg, volatile.LoadUint8(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetSTAT_ODD() uint8 {
	return (volatile.LoadUint8(&o.STAT.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetSTAT_TX(value uint8) {
	volatile.StoreUint8(&o.STAT.Reg, volatile.LoadUint8(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetSTAT_TX() uint8 {
	return (volatile.LoadUint8(&o.STAT.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetSTAT_ENDP(value uint8) {
	volatile.StoreUint8(&o.STAT.Reg, volatile.LoadUint8(&o.STAT.Reg)&^(0xf0)|value<<4)
}
func (o *USB0_Type) GetSTAT_ENDP() uint8 {
	return (volatile.LoadUint8(&o.STAT.Reg) & 0xf0) >> 4
}

// USB0.CTL: Control register
func (o *USB0_Type) SetCTL_USBENSOFEN(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetCTL_USBENSOFEN() uint8 {
	return volatile.LoadUint8(&o.CTL.Reg) & 0x1
}
func (o *USB0_Type) SetCTL_ODDRST(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetCTL_ODDRST() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetCTL_RESUME(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetCTL_RESUME() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetCTL_HOSTMODEEN(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetCTL_HOSTMODEEN() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetCTL_RESET(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetCTL_RESET() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetCTL_TXSUSPENDTOKENBUSY(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetCTL_TXSUSPENDTOKENBUSY() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetCTL_SE0(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetCTL_SE0() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetCTL_JSTATE(value uint8) {
	volatile.StoreUint8(&o.CTL.Reg, volatile.LoadUint8(&o.CTL.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetCTL_JSTATE() uint8 {
	return (volatile.LoadUint8(&o.CTL.Reg) & 0x80) >> 7
}

// USB0.ADDR: Address register
func (o *USB0_Type) SetADDR(value uint8) {
	volatile.StoreUint8(&o.ADDR.Reg, volatile.LoadUint8(&o.ADDR.Reg)&^(0x7f)|value)
}
func (o *USB0_Type) GetADDR() uint8 {
	return volatile.LoadUint8(&o.ADDR.Reg) & 0x7f
}
func (o *USB0_Type) SetADDR_LSEN(value uint8) {
	volatile.StoreUint8(&o.ADDR.Reg, volatile.LoadUint8(&o.ADDR.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetADDR_LSEN() uint8 {
	return (volatile.LoadUint8(&o.ADDR.Reg) & 0x80) >> 7
}

// USB0.BDTPAGE1: BDT Page register 1
func (o *USB0_Type) SetBDTPAGE1_BDTBA(value uint8) {
	volatile.StoreUint8(&o.BDTPAGE1.Reg, volatile.LoadUint8(&o.BDTPAGE1.Reg)&^(0xfe)|value<<1)
}
func (o *USB0_Type) GetBDTPAGE1_BDTBA() uint8 {
	return (volatile.LoadUint8(&o.BDTPAGE1.Reg) & 0xfe) >> 1
}

// USB0.FRMNUML: Frame Number register Low
func (o *USB0_Type) SetFRMNUML(value uint8) {
	volatile.StoreUint8(&o.FRMNUML.Reg, value)
}
func (o *USB0_Type) GetFRMNUML() uint8 {
	return volatile.LoadUint8(&o.FRMNUML.Reg)
}

// USB0.FRMNUMH: Frame Number register High
func (o *USB0_Type) SetFRMNUMH_FRM(value uint8) {
	volatile.StoreUint8(&o.FRMNUMH.Reg, volatile.LoadUint8(&o.FRMNUMH.Reg)&^(0x7)|value)
}
func (o *USB0_Type) GetFRMNUMH_FRM() uint8 {
	return volatile.LoadUint8(&o.FRMNUMH.Reg) & 0x7
}

// USB0.TOKEN: Token register
func (o *USB0_Type) SetTOKEN_TOKENENDPT(value uint8) {
	volatile.StoreUint8(&o.TOKEN.Reg, volatile.LoadUint8(&o.TOKEN.Reg)&^(0xf)|value)
}
func (o *USB0_Type) GetTOKEN_TOKENENDPT() uint8 {
	return volatile.LoadUint8(&o.TOKEN.Reg) & 0xf
}
func (o *USB0_Type) SetTOKEN_TOKENPID(value uint8) {
	volatile.StoreUint8(&o.TOKEN.Reg, volatile.LoadUint8(&o.TOKEN.Reg)&^(0xf0)|value<<4)
}
func (o *USB0_Type) GetTOKEN_TOKENPID() uint8 {
	return (volatile.LoadUint8(&o.TOKEN.Reg) & 0xf0) >> 4
}

// USB0.SOFTHLD: SOF Threshold register
func (o *USB0_Type) SetSOFTHLD(value uint8) {
	volatile.StoreUint8(&o.SOFTHLD.Reg, value)
}
func (o *USB0_Type) GetSOFTHLD() uint8 {
	return volatile.LoadUint8(&o.SOFTHLD.Reg)
}

// USB0.BDTPAGE2: BDT Page Register 2
func (o *USB0_Type) SetBDTPAGE2(value uint8) {
	volatile.StoreUint8(&o.BDTPAGE2.Reg, value)
}
func (o *USB0_Type) GetBDTPAGE2() uint8 {
	return volatile.LoadUint8(&o.BDTPAGE2.Reg)
}

// USB0.BDTPAGE3: BDT Page Register 3
func (o *USB0_Type) SetBDTPAGE3(value uint8) {
	volatile.StoreUint8(&o.BDTPAGE3.Reg, value)
}
func (o *USB0_Type) GetBDTPAGE3() uint8 {
	return volatile.LoadUint8(&o.BDTPAGE3.Reg)
}

// USB0.ENDPT0: Endpoint Control register
func (o *USB0_Type) SetENDPT0_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT0_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT0.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT0_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT0_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT0_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT0_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT0_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT0_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT0_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT0_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT0_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT0_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT0_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT0.Reg, volatile.LoadUint8(&o.ENDPT0.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT0_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT0.Reg) & 0x80) >> 7
}

// USB0.ENDPT1: Endpoint Control register
func (o *USB0_Type) SetENDPT1_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT1_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT1.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT1_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT1_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT1_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT1_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT1_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT1_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT1_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT1_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT1_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT1_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT1_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT1.Reg, volatile.LoadUint8(&o.ENDPT1.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT1_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT1.Reg) & 0x80) >> 7
}

// USB0.ENDPT2: Endpoint Control register
func (o *USB0_Type) SetENDPT2_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT2_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT2.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT2_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT2_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT2_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT2_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT2_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT2_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT2_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT2_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT2_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT2_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT2_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT2.Reg, volatile.LoadUint8(&o.ENDPT2.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT2_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT2.Reg) & 0x80) >> 7
}

// USB0.ENDPT3: Endpoint Control register
func (o *USB0_Type) SetENDPT3_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT3_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT3.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT3_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT3_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT3_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT3_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT3_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT3_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT3_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT3_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT3_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT3_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT3_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT3.Reg, volatile.LoadUint8(&o.ENDPT3.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT3_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT3.Reg) & 0x80) >> 7
}

// USB0.ENDPT4: Endpoint Control register
func (o *USB0_Type) SetENDPT4_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT4_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT4.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT4_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT4_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT4_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT4_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT4_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT4_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT4_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT4_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT4_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT4_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT4_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT4.Reg, volatile.LoadUint8(&o.ENDPT4.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT4_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT4.Reg) & 0x80) >> 7
}

// USB0.ENDPT5: Endpoint Control register
func (o *USB0_Type) SetENDPT5_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT5_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT5.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT5_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT5_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT5_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT5_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT5_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT5_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT5_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT5_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT5_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT5_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT5_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT5.Reg, volatile.LoadUint8(&o.ENDPT5.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT5_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT5.Reg) & 0x80) >> 7
}

// USB0.ENDPT6: Endpoint Control register
func (o *USB0_Type) SetENDPT6_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT6_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT6.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT6_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT6_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT6_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT6_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT6_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT6_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT6_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT6_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT6_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT6_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT6_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT6.Reg, volatile.LoadUint8(&o.ENDPT6.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT6_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT6.Reg) & 0x80) >> 7
}

// USB0.ENDPT7: Endpoint Control register
func (o *USB0_Type) SetENDPT7_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT7_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT7.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT7_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT7_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT7_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT7_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT7_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT7_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT7_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT7_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT7_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT7_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT7_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT7.Reg, volatile.LoadUint8(&o.ENDPT7.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT7_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT7.Reg) & 0x80) >> 7
}

// USB0.ENDPT8: Endpoint Control register
func (o *USB0_Type) SetENDPT8_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT8_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT8.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT8_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT8_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT8_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT8_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT8_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT8_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT8_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT8_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT8_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT8_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT8_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT8.Reg, volatile.LoadUint8(&o.ENDPT8.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT8_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT8.Reg) & 0x80) >> 7
}

// USB0.ENDPT9: Endpoint Control register
func (o *USB0_Type) SetENDPT9_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT9_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT9.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT9_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT9_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT9_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT9_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT9_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT9_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT9_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT9_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT9_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT9_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT9_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT9.Reg, volatile.LoadUint8(&o.ENDPT9.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT9_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT9.Reg) & 0x80) >> 7
}

// USB0.ENDPT10: Endpoint Control register
func (o *USB0_Type) SetENDPT10_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT10_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT10.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT10_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT10_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT10_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT10_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT10_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT10_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT10_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT10_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT10_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT10_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT10_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT10.Reg, volatile.LoadUint8(&o.ENDPT10.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT10_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT10.Reg) & 0x80) >> 7
}

// USB0.ENDPT11: Endpoint Control register
func (o *USB0_Type) SetENDPT11_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT11_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT11.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT11_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT11_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT11_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT11_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT11_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT11_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT11_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT11_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT11_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT11_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT11_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT11.Reg, volatile.LoadUint8(&o.ENDPT11.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT11_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT11.Reg) & 0x80) >> 7
}

// USB0.ENDPT12: Endpoint Control register
func (o *USB0_Type) SetENDPT12_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT12_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT12.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT12_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT12_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT12_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT12_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT12_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT12_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT12_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT12_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT12_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT12_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT12_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT12.Reg, volatile.LoadUint8(&o.ENDPT12.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT12_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT12.Reg) & 0x80) >> 7
}

// USB0.ENDPT13: Endpoint Control register
func (o *USB0_Type) SetENDPT13_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT13_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT13.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT13_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT13_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT13_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT13_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT13_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT13_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT13_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT13_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT13_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT13_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT13_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT13.Reg, volatile.LoadUint8(&o.ENDPT13.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT13_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT13.Reg) & 0x80) >> 7
}

// USB0.ENDPT14: Endpoint Control register
func (o *USB0_Type) SetENDPT14_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT14_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT14.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT14_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT14_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT14_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT14_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT14_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT14_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT14_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT14_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT14_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT14_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT14_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT14.Reg, volatile.LoadUint8(&o.ENDPT14.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT14_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT14.Reg) & 0x80) >> 7
}

// USB0.ENDPT15: Endpoint Control register
func (o *USB0_Type) SetENDPT15_EPHSHK(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetENDPT15_EPHSHK() uint8 {
	return volatile.LoadUint8(&o.ENDPT15.Reg) & 0x1
}
func (o *USB0_Type) SetENDPT15_EPSTALL(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetENDPT15_EPSTALL() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetENDPT15_EPTXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x4)|value<<2)
}
func (o *USB0_Type) GetENDPT15_EPTXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x4) >> 2
}
func (o *USB0_Type) SetENDPT15_EPRXEN(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x8)|value<<3)
}
func (o *USB0_Type) GetENDPT15_EPRXEN() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x8) >> 3
}
func (o *USB0_Type) SetENDPT15_EPCTLDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetENDPT15_EPCTLDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetENDPT15_RETRYDIS(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetENDPT15_RETRYDIS() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetENDPT15_HOSTWOHUB(value uint8) {
	volatile.StoreUint8(&o.ENDPT15.Reg, volatile.LoadUint8(&o.ENDPT15.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetENDPT15_HOSTWOHUB() uint8 {
	return (volatile.LoadUint8(&o.ENDPT15.Reg) & 0x80) >> 7
}

// USB0.USBCTRL: USB Control register
func (o *USB0_Type) SetUSBCTRL_PDE(value uint8) {
	volatile.StoreUint8(&o.USBCTRL.Reg, volatile.LoadUint8(&o.USBCTRL.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetUSBCTRL_PDE() uint8 {
	return (volatile.LoadUint8(&o.USBCTRL.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetUSBCTRL_SUSP(value uint8) {
	volatile.StoreUint8(&o.USBCTRL.Reg, volatile.LoadUint8(&o.USBCTRL.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetUSBCTRL_SUSP() uint8 {
	return (volatile.LoadUint8(&o.USBCTRL.Reg) & 0x80) >> 7
}

// USB0.OBSERVE: USB OTG Observe register
func (o *USB0_Type) SetOBSERVE_DMPD(value uint8) {
	volatile.StoreUint8(&o.OBSERVE.Reg, volatile.LoadUint8(&o.OBSERVE.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetOBSERVE_DMPD() uint8 {
	return (volatile.LoadUint8(&o.OBSERVE.Reg) & 0x10) >> 4
}
func (o *USB0_Type) SetOBSERVE_DPPD(value uint8) {
	volatile.StoreUint8(&o.OBSERVE.Reg, volatile.LoadUint8(&o.OBSERVE.Reg)&^(0x40)|value<<6)
}
func (o *USB0_Type) GetOBSERVE_DPPD() uint8 {
	return (volatile.LoadUint8(&o.OBSERVE.Reg) & 0x40) >> 6
}
func (o *USB0_Type) SetOBSERVE_DPPU(value uint8) {
	volatile.StoreUint8(&o.OBSERVE.Reg, volatile.LoadUint8(&o.OBSERVE.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetOBSERVE_DPPU() uint8 {
	return (volatile.LoadUint8(&o.OBSERVE.Reg) & 0x80) >> 7
}

// USB0.CONTROL: USB OTG Control register
func (o *USB0_Type) SetCONTROL_DPPULLUPNONOTG(value uint8) {
	volatile.StoreUint8(&o.CONTROL.Reg, volatile.LoadUint8(&o.CONTROL.Reg)&^(0x10)|value<<4)
}
func (o *USB0_Type) GetCONTROL_DPPULLUPNONOTG() uint8 {
	return (volatile.LoadUint8(&o.CONTROL.Reg) & 0x10) >> 4
}

// USB0.USBTRC0: USB Transceiver Control register 0
func (o *USB0_Type) SetUSBTRC0_USB_RESUME_INT(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x1)|value)
}
func (o *USB0_Type) GetUSBTRC0_USB_RESUME_INT() uint8 {
	return volatile.LoadUint8(&o.USBTRC0.Reg) & 0x1
}
func (o *USB0_Type) SetUSBTRC0_SYNC_DET(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x2)|value<<1)
}
func (o *USB0_Type) GetUSBTRC0_SYNC_DET() uint8 {
	return (volatile.LoadUint8(&o.USBTRC0.Reg) & 0x2) >> 1
}
func (o *USB0_Type) SetUSBTRC0_USBRESMEN(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x20)|value<<5)
}
func (o *USB0_Type) GetUSBTRC0_USBRESMEN() uint8 {
	return (volatile.LoadUint8(&o.USBTRC0.Reg) & 0x20) >> 5
}
func (o *USB0_Type) SetUSBTRC0_USBRESET(value uint8) {
	volatile.StoreUint8(&o.USBTRC0.Reg, volatile.LoadUint8(&o.USBTRC0.Reg)&^(0x80)|value<<7)
}
func (o *USB0_Type) GetUSBTRC0_USBRESET() uint8 {
	return (volatile.LoadUint8(&o.USBTRC0.Reg) & 0x80) >> 7
}

// USB0.USBFRMADJUST: Frame Adjust Register
func (o *USB0_Type) SetUSBFRMADJUST(value uint8) {
	volatile.StoreUint8(&o.USBFRMADJUST.Reg, value)
}
func (o *USB0_Type) GetUSBFRMADJUST() uint8 {
	return volatile.LoadUint8(&o.USBFRMADJUST.Reg)
}

// High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
type CMP0_Type struct {
	CR0   volatile.Register8 // 0x0
	CR1   volatile.Register8 // 0x1
	FPR   volatile.Register8 // 0x2
	SCR   volatile.Register8 // 0x3
	DACCR volatile.Register8 // 0x4
	MUXCR volatile.Register8 // 0x5
}

// CMP0.CR0: CMP Control Register 0
func (o *CMP0_Type) SetCR0_HYSTCTR(value uint8) {
	volatile.StoreUint8(&o.CR0.Reg, volatile.LoadUint8(&o.CR0.Reg)&^(0x3)|value)
}
func (o *CMP0_Type) GetCR0_HYSTCTR() uint8 {
	return volatile.LoadUint8(&o.CR0.Reg) & 0x3
}
func (o *CMP0_Type) SetCR0_FILTER_CNT(value uint8) {
	volatile.StoreUint8(&o.CR0.Reg, volatile.LoadUint8(&o.CR0.Reg)&^(0x70)|value<<4)
}
func (o *CMP0_Type) GetCR0_FILTER_CNT() uint8 {
	return (volatile.LoadUint8(&o.CR0.Reg) & 0x70) >> 4
}

// CMP0.CR1: CMP Control Register 1
func (o *CMP0_Type) SetCR1_EN(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x1)|value)
}
func (o *CMP0_Type) GetCR1_EN() uint8 {
	return volatile.LoadUint8(&o.CR1.Reg) & 0x1
}
func (o *CMP0_Type) SetCR1_OPE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *CMP0_Type) GetCR1_OPE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x2) >> 1
}
func (o *CMP0_Type) SetCR1_COS(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *CMP0_Type) GetCR1_COS() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x4) >> 2
}
func (o *CMP0_Type) SetCR1_INV(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *CMP0_Type) GetCR1_INV() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x8) >> 3
}
func (o *CMP0_Type) SetCR1_PMODE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *CMP0_Type) GetCR1_PMODE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x10) >> 4
}
func (o *CMP0_Type) SetCR1_TRIGM(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *CMP0_Type) GetCR1_TRIGM() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x20) >> 5
}
func (o *CMP0_Type) SetCR1_WE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *CMP0_Type) GetCR1_WE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x40) >> 6
}
func (o *CMP0_Type) SetCR1_SE(value uint8) {
	volatile.StoreUint8(&o.CR1.Reg, volatile.LoadUint8(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *CMP0_Type) GetCR1_SE() uint8 {
	return (volatile.LoadUint8(&o.CR1.Reg) & 0x80) >> 7
}

// CMP0.FPR: CMP Filter Period Register
func (o *CMP0_Type) SetFPR(value uint8) {
	volatile.StoreUint8(&o.FPR.Reg, value)
}
func (o *CMP0_Type) GetFPR() uint8 {
	return volatile.LoadUint8(&o.FPR.Reg)
}

// CMP0.SCR: CMP Status and Control Register
func (o *CMP0_Type) SetSCR_COUT(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x1)|value)
}
func (o *CMP0_Type) GetSCR_COUT() uint8 {
	return volatile.LoadUint8(&o.SCR.Reg) & 0x1
}
func (o *CMP0_Type) SetSCR_CFF(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *CMP0_Type) GetSCR_CFF() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x2) >> 1
}
func (o *CMP0_Type) SetSCR_CFR(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *CMP0_Type) GetSCR_CFR() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x4) >> 2
}
func (o *CMP0_Type) SetSCR_IEF(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *CMP0_Type) GetSCR_IEF() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x8) >> 3
}
func (o *CMP0_Type) SetSCR_IER(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *CMP0_Type) GetSCR_IER() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x10) >> 4
}
func (o *CMP0_Type) SetSCR_DMAEN(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *CMP0_Type) GetSCR_DMAEN() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x40) >> 6
}

// CMP0.DACCR: DAC Control Register
func (o *CMP0_Type) SetDACCR_VOSEL(value uint8) {
	volatile.StoreUint8(&o.DACCR.Reg, volatile.LoadUint8(&o.DACCR.Reg)&^(0x3f)|value)
}
func (o *CMP0_Type) GetDACCR_VOSEL() uint8 {
	return volatile.LoadUint8(&o.DACCR.Reg) & 0x3f
}
func (o *CMP0_Type) SetDACCR_VRSEL(value uint8) {
	volatile.StoreUint8(&o.DACCR.Reg, volatile.LoadUint8(&o.DACCR.Reg)&^(0x40)|value<<6)
}
func (o *CMP0_Type) GetDACCR_VRSEL() uint8 {
	return (volatile.LoadUint8(&o.DACCR.Reg) & 0x40) >> 6
}
func (o *CMP0_Type) SetDACCR_DACEN(value uint8) {
	volatile.StoreUint8(&o.DACCR.Reg, volatile.LoadUint8(&o.DACCR.Reg)&^(0x80)|value<<7)
}
func (o *CMP0_Type) GetDACCR_DACEN() uint8 {
	return (volatile.LoadUint8(&o.DACCR.Reg) & 0x80) >> 7
}

// CMP0.MUXCR: MUX Control Register
func (o *CMP0_Type) SetMUXCR_MSEL(value uint8) {
	volatile.StoreUint8(&o.MUXCR.Reg, volatile.LoadUint8(&o.MUXCR.Reg)&^(0x7)|value)
}
func (o *CMP0_Type) GetMUXCR_MSEL() uint8 {
	return volatile.LoadUint8(&o.MUXCR.Reg) & 0x7
}
func (o *CMP0_Type) SetMUXCR_PSEL(value uint8) {
	volatile.StoreUint8(&o.MUXCR.Reg, volatile.LoadUint8(&o.MUXCR.Reg)&^(0x38)|value<<3)
}
func (o *CMP0_Type) GetMUXCR_PSEL() uint8 {
	return (volatile.LoadUint8(&o.MUXCR.Reg) & 0x38) >> 3
}
func (o *CMP0_Type) SetMUXCR_PSTM(value uint8) {
	volatile.StoreUint8(&o.MUXCR.Reg, volatile.LoadUint8(&o.MUXCR.Reg)&^(0x80)|value<<7)
}
func (o *CMP0_Type) GetMUXCR_PSTM() uint8 {
	return (volatile.LoadUint8(&o.MUXCR.Reg) & 0x80) >> 7
}

// Serial Peripheral Interface
type SPI_Type struct {
	S  volatile.Register8 // 0x0
	BR volatile.Register8 // 0x1
	C2 volatile.Register8 // 0x2
	C1 volatile.Register8 // 0x3
	ML volatile.Register8 // 0x4
	MH volatile.Register8 // 0x5
	DL volatile.Register8 // 0x6
	DH volatile.Register8 // 0x7
}

// SPI.S: SPI Status Register
func (o *SPI_Type) SetS_MODF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetS_MODF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetS_SPTEF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetS_SPTEF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetS_SPMF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetS_SPMF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetS_SPRF(value uint8) {
	volatile.StoreUint8(&o.S.Reg, volatile.LoadUint8(&o.S.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetS_SPRF() uint8 {
	return (volatile.LoadUint8(&o.S.Reg) & 0x80) >> 7
}

// SPI.BR: SPI Baud Rate Register
func (o *SPI_Type) SetBR_SPR(value uint8) {
	volatile.StoreUint8(&o.BR.Reg, volatile.LoadUint8(&o.BR.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetBR_SPR() uint8 {
	return volatile.LoadUint8(&o.BR.Reg) & 0xf
}
func (o *SPI_Type) SetBR_SPPR(value uint8) {
	volatile.StoreUint8(&o.BR.Reg, volatile.LoadUint8(&o.BR.Reg)&^(0x70)|value<<4)
}
func (o *SPI_Type) GetBR_SPPR() uint8 {
	return (volatile.LoadUint8(&o.BR.Reg) & 0x70) >> 4
}

// SPI.C2: SPI Control Register 2
func (o *SPI_Type) SetC2_SPC0(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetC2_SPC0() uint8 {
	return volatile.LoadUint8(&o.C2.Reg) & 0x1
}
func (o *SPI_Type) SetC2_SPISWAI(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetC2_SPISWAI() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetC2_RXDMAE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetC2_RXDMAE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetC2_BIDIROE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetC2_BIDIROE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetC2_MODFEN(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetC2_MODFEN() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetC2_TXDMAE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetC2_TXDMAE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetC2_SPIMODE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetC2_SPIMODE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetC2_SPMIE(value uint8) {
	volatile.StoreUint8(&o.C2.Reg, volatile.LoadUint8(&o.C2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetC2_SPMIE() uint8 {
	return (volatile.LoadUint8(&o.C2.Reg) & 0x80) >> 7
}

// SPI.C1: SPI Control Register 1
func (o *SPI_Type) SetC1_LSBFE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetC1_LSBFE() uint8 {
	return volatile.LoadUint8(&o.C1.Reg) & 0x1
}
func (o *SPI_Type) SetC1_SSOE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetC1_SSOE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetC1_CPHA(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetC1_CPHA() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetC1_CPOL(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetC1_CPOL() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetC1_MSTR(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetC1_MSTR() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetC1_SPTIE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetC1_SPTIE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetC1_SPE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetC1_SPE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetC1_SPIE(value uint8) {
	volatile.StoreUint8(&o.C1.Reg, volatile.LoadUint8(&o.C1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetC1_SPIE() uint8 {
	return (volatile.LoadUint8(&o.C1.Reg) & 0x80) >> 7
}

// SPI.ML: SPI Match Register low
func (o *SPI_Type) SetML(value uint8) {
	volatile.StoreUint8(&o.ML.Reg, value)
}
func (o *SPI_Type) GetML() uint8 {
	return volatile.LoadUint8(&o.ML.Reg)
}

// SPI.MH: SPI match register high
func (o *SPI_Type) SetMH(value uint8) {
	volatile.StoreUint8(&o.MH.Reg, value)
}
func (o *SPI_Type) GetMH() uint8 {
	return volatile.LoadUint8(&o.MH.Reg)
}

// SPI.DL: SPI Data Register low
func (o *SPI_Type) SetDL(value uint8) {
	volatile.StoreUint8(&o.DL.Reg, value)
}
func (o *SPI_Type) GetDL() uint8 {
	return volatile.LoadUint8(&o.DL.Reg)
}

// SPI.DH: SPI data register high
func (o *SPI_Type) SetDH(value uint8) {
	volatile.StoreUint8(&o.DH.Reg, value)
}
func (o *SPI_Type) GetDH() uint8 {
	return volatile.LoadUint8(&o.DH.Reg)
}

// Low leakage wakeup unit
type LLWU_Type struct {
	PE1   volatile.Register8 // 0x0
	PE2   volatile.Register8 // 0x1
	PE3   volatile.Register8 // 0x2
	PE4   volatile.Register8 // 0x3
	ME    volatile.Register8 // 0x4
	F1    volatile.Register8 // 0x5
	F2    volatile.Register8 // 0x6
	F3    volatile.Register8 // 0x7
	FILT1 volatile.Register8 // 0x8
	FILT2 volatile.Register8 // 0x9
}

// LLWU.PE1: LLWU Pin Enable 1 register
func (o *LLWU_Type) SetPE1_WUPE0(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE1_WUPE0() uint8 {
	return volatile.LoadUint8(&o.PE1.Reg) & 0x3
}
func (o *LLWU_Type) SetPE1_WUPE1(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE1_WUPE1() uint8 {
	return (volatile.LoadUint8(&o.PE1.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE1_WUPE2(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE1_WUPE2() uint8 {
	return (volatile.LoadUint8(&o.PE1.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE1_WUPE3(value uint8) {
	volatile.StoreUint8(&o.PE1.Reg, volatile.LoadUint8(&o.PE1.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE1_WUPE3() uint8 {
	return (volatile.LoadUint8(&o.PE1.Reg) & 0xc0) >> 6
}

// LLWU.PE2: LLWU Pin Enable 2 register
func (o *LLWU_Type) SetPE2_WUPE4(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE2_WUPE4() uint8 {
	return volatile.LoadUint8(&o.PE2.Reg) & 0x3
}
func (o *LLWU_Type) SetPE2_WUPE5(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE2_WUPE5() uint8 {
	return (volatile.LoadUint8(&o.PE2.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE2_WUPE6(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE2_WUPE6() uint8 {
	return (volatile.LoadUint8(&o.PE2.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE2_WUPE7(value uint8) {
	volatile.StoreUint8(&o.PE2.Reg, volatile.LoadUint8(&o.PE2.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE2_WUPE7() uint8 {
	return (volatile.LoadUint8(&o.PE2.Reg) & 0xc0) >> 6
}

// LLWU.PE3: LLWU Pin Enable 3 register
func (o *LLWU_Type) SetPE3_WUPE8(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE3_WUPE8() uint8 {
	return volatile.LoadUint8(&o.PE3.Reg) & 0x3
}
func (o *LLWU_Type) SetPE3_WUPE9(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE3_WUPE9() uint8 {
	return (volatile.LoadUint8(&o.PE3.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE3_WUPE10(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE3_WUPE10() uint8 {
	return (volatile.LoadUint8(&o.PE3.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE3_WUPE11(value uint8) {
	volatile.StoreUint8(&o.PE3.Reg, volatile.LoadUint8(&o.PE3.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE3_WUPE11() uint8 {
	return (volatile.LoadUint8(&o.PE3.Reg) & 0xc0) >> 6
}

// LLWU.PE4: LLWU Pin Enable 4 register
func (o *LLWU_Type) SetPE4_WUPE12(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0x3)|value)
}
func (o *LLWU_Type) GetPE4_WUPE12() uint8 {
	return volatile.LoadUint8(&o.PE4.Reg) & 0x3
}
func (o *LLWU_Type) SetPE4_WUPE13(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0xc)|value<<2)
}
func (o *LLWU_Type) GetPE4_WUPE13() uint8 {
	return (volatile.LoadUint8(&o.PE4.Reg) & 0xc) >> 2
}
func (o *LLWU_Type) SetPE4_WUPE14(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0x30)|value<<4)
}
func (o *LLWU_Type) GetPE4_WUPE14() uint8 {
	return (volatile.LoadUint8(&o.PE4.Reg) & 0x30) >> 4
}
func (o *LLWU_Type) SetPE4_WUPE15(value uint8) {
	volatile.StoreUint8(&o.PE4.Reg, volatile.LoadUint8(&o.PE4.Reg)&^(0xc0)|value<<6)
}
func (o *LLWU_Type) GetPE4_WUPE15() uint8 {
	return (volatile.LoadUint8(&o.PE4.Reg) & 0xc0) >> 6
}

// LLWU.ME: LLWU Module Enable register
func (o *LLWU_Type) SetME_WUME0(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetME_WUME0() uint8 {
	return volatile.LoadUint8(&o.ME.Reg) & 0x1
}
func (o *LLWU_Type) SetME_WUME1(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetME_WUME1() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetME_WUME2(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetME_WUME2() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetME_WUME3(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetME_WUME3() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetME_WUME4(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetME_WUME4() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetME_WUME5(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetME_WUME5() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetME_WUME6(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetME_WUME6() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetME_WUME7(value uint8) {
	volatile.StoreUint8(&o.ME.Reg, volatile.LoadUint8(&o.ME.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetME_WUME7() uint8 {
	return (volatile.LoadUint8(&o.ME.Reg) & 0x80) >> 7
}

// LLWU.F1: LLWU Flag 1 register
func (o *LLWU_Type) SetF1_WUF0(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetF1_WUF0() uint8 {
	return volatile.LoadUint8(&o.F1.Reg) & 0x1
}
func (o *LLWU_Type) SetF1_WUF1(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetF1_WUF1() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetF1_WUF2(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetF1_WUF2() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetF1_WUF3(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetF1_WUF3() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetF1_WUF4(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetF1_WUF4() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetF1_WUF5(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetF1_WUF5() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetF1_WUF6(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetF1_WUF6() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetF1_WUF7(value uint8) {
	volatile.StoreUint8(&o.F1.Reg, volatile.LoadUint8(&o.F1.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetF1_WUF7() uint8 {
	return (volatile.LoadUint8(&o.F1.Reg) & 0x80) >> 7
}

// LLWU.F2: LLWU Flag 2 register
func (o *LLWU_Type) SetF2_WUF8(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetF2_WUF8() uint8 {
	return volatile.LoadUint8(&o.F2.Reg) & 0x1
}
func (o *LLWU_Type) SetF2_WUF9(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetF2_WUF9() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetF2_WUF10(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetF2_WUF10() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetF2_WUF11(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetF2_WUF11() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetF2_WUF12(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetF2_WUF12() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetF2_WUF13(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetF2_WUF13() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetF2_WUF14(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetF2_WUF14() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetF2_WUF15(value uint8) {
	volatile.StoreUint8(&o.F2.Reg, volatile.LoadUint8(&o.F2.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetF2_WUF15() uint8 {
	return (volatile.LoadUint8(&o.F2.Reg) & 0x80) >> 7
}

// LLWU.F3: LLWU Flag 3 register
func (o *LLWU_Type) SetF3_MWUF0(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x1)|value)
}
func (o *LLWU_Type) GetF3_MWUF0() uint8 {
	return volatile.LoadUint8(&o.F3.Reg) & 0x1
}
func (o *LLWU_Type) SetF3_MWUF1(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x2)|value<<1)
}
func (o *LLWU_Type) GetF3_MWUF1() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x2) >> 1
}
func (o *LLWU_Type) SetF3_MWUF2(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x4)|value<<2)
}
func (o *LLWU_Type) GetF3_MWUF2() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x4) >> 2
}
func (o *LLWU_Type) SetF3_MWUF3(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x8)|value<<3)
}
func (o *LLWU_Type) GetF3_MWUF3() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x8) >> 3
}
func (o *LLWU_Type) SetF3_MWUF4(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x10)|value<<4)
}
func (o *LLWU_Type) GetF3_MWUF4() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x10) >> 4
}
func (o *LLWU_Type) SetF3_MWUF5(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x20)|value<<5)
}
func (o *LLWU_Type) GetF3_MWUF5() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x20) >> 5
}
func (o *LLWU_Type) SetF3_MWUF6(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x40)|value<<6)
}
func (o *LLWU_Type) GetF3_MWUF6() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x40) >> 6
}
func (o *LLWU_Type) SetF3_MWUF7(value uint8) {
	volatile.StoreUint8(&o.F3.Reg, volatile.LoadUint8(&o.F3.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetF3_MWUF7() uint8 {
	return (volatile.LoadUint8(&o.F3.Reg) & 0x80) >> 7
}

// LLWU.FILT1: LLWU Pin Filter 1 register
func (o *LLWU_Type) SetFILT1_FILTSEL(value uint8) {
	volatile.StoreUint8(&o.FILT1.Reg, volatile.LoadUint8(&o.FILT1.Reg)&^(0xf)|value)
}
func (o *LLWU_Type) GetFILT1_FILTSEL() uint8 {
	return volatile.LoadUint8(&o.FILT1.Reg) & 0xf
}
func (o *LLWU_Type) SetFILT1_FILTE(value uint8) {
	volatile.StoreUint8(&o.FILT1.Reg, volatile.LoadUint8(&o.FILT1.Reg)&^(0x60)|value<<5)
}
func (o *LLWU_Type) GetFILT1_FILTE() uint8 {
	return (volatile.LoadUint8(&o.FILT1.Reg) & 0x60) >> 5
}
func (o *LLWU_Type) SetFILT1_FILTF(value uint8) {
	volatile.StoreUint8(&o.FILT1.Reg, volatile.LoadUint8(&o.FILT1.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetFILT1_FILTF() uint8 {
	return (volatile.LoadUint8(&o.FILT1.Reg) & 0x80) >> 7
}

// LLWU.FILT2: LLWU Pin Filter 2 register
func (o *LLWU_Type) SetFILT2_FILTSEL(value uint8) {
	volatile.StoreUint8(&o.FILT2.Reg, volatile.LoadUint8(&o.FILT2.Reg)&^(0xf)|value)
}
func (o *LLWU_Type) GetFILT2_FILTSEL() uint8 {
	return volatile.LoadUint8(&o.FILT2.Reg) & 0xf
}
func (o *LLWU_Type) SetFILT2_FILTE(value uint8) {
	volatile.StoreUint8(&o.FILT2.Reg, volatile.LoadUint8(&o.FILT2.Reg)&^(0x60)|value<<5)
}
func (o *LLWU_Type) GetFILT2_FILTE() uint8 {
	return (volatile.LoadUint8(&o.FILT2.Reg) & 0x60) >> 5
}
func (o *LLWU_Type) SetFILT2_FILTF(value uint8) {
	volatile.StoreUint8(&o.FILT2.Reg, volatile.LoadUint8(&o.FILT2.Reg)&^(0x80)|value<<7)
}
func (o *LLWU_Type) GetFILT2_FILTF() uint8 {
	return (volatile.LoadUint8(&o.FILT2.Reg) & 0x80) >> 7
}

// Power Management Controller
type PMC_Type struct {
	LVDSC1 volatile.Register8 // 0x0
	LVDSC2 volatile.Register8 // 0x1
	REGSC  volatile.Register8 // 0x2
}

// PMC.LVDSC1: Low Voltage Detect Status And Control 1 register
func (o *PMC_Type) SetLVDSC1_LVDV(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetLVDSC1_LVDV() uint8 {
	return volatile.LoadUint8(&o.LVDSC1.Reg) & 0x3
}
func (o *PMC_Type) SetLVDSC1_LVDRE(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetLVDSC1_LVDRE() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetLVDSC1_LVDIE(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetLVDSC1_LVDIE() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetLVDSC1_LVDACK(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetLVDSC1_LVDACK() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetLVDSC1_LVDF(value uint8) {
	volatile.StoreUint8(&o.LVDSC1.Reg, volatile.LoadUint8(&o.LVDSC1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetLVDSC1_LVDF() uint8 {
	return (volatile.LoadUint8(&o.LVDSC1.Reg) & 0x80) >> 7
}

// PMC.LVDSC2: Low Voltage Detect Status And Control 2 register
func (o *PMC_Type) SetLVDSC2_LVWV(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetLVDSC2_LVWV() uint8 {
	return volatile.LoadUint8(&o.LVDSC2.Reg) & 0x3
}
func (o *PMC_Type) SetLVDSC2_LVWIE(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetLVDSC2_LVWIE() uint8 {
	return (volatile.LoadUint8(&o.LVDSC2.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetLVDSC2_LVWACK(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetLVDSC2_LVWACK() uint8 {
	return (volatile.LoadUint8(&o.LVDSC2.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetLVDSC2_LVWF(value uint8) {
	volatile.StoreUint8(&o.LVDSC2.Reg, volatile.LoadUint8(&o.LVDSC2.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetLVDSC2_LVWF() uint8 {
	return (volatile.LoadUint8(&o.LVDSC2.Reg) & 0x80) >> 7
}

// PMC.REGSC: Regulator Status And Control register
func (o *PMC_Type) SetREGSC_BGBE(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetREGSC_BGBE() uint8 {
	return volatile.LoadUint8(&o.REGSC.Reg) & 0x1
}
func (o *PMC_Type) SetREGSC_REGONS(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetREGSC_REGONS() uint8 {
	return (volatile.LoadUint8(&o.REGSC.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetREGSC_ACKISO(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetREGSC_ACKISO() uint8 {
	return (volatile.LoadUint8(&o.REGSC.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetREGSC_BGEN(value uint8) {
	volatile.StoreUint8(&o.REGSC.Reg, volatile.LoadUint8(&o.REGSC.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetREGSC_BGEN() uint8 {
	return (volatile.LoadUint8(&o.REGSC.Reg) & 0x10) >> 4
}

// System Mode Controller
type SMC_Type struct {
	PMPROT   volatile.Register8 // 0x0
	PMCTRL   volatile.Register8 // 0x1
	STOPCTRL volatile.Register8 // 0x2
	PMSTAT   volatile.Register8 // 0x3
}

// SMC.PMPROT: Power Mode Protection register
func (o *SMC_Type) SetPMPROT_AVLLS(value uint8) {
	volatile.StoreUint8(&o.PMPROT.Reg, volatile.LoadUint8(&o.PMPROT.Reg)&^(0x2)|value<<1)
}
func (o *SMC_Type) GetPMPROT_AVLLS() uint8 {
	return (volatile.LoadUint8(&o.PMPROT.Reg) & 0x2) >> 1
}
func (o *SMC_Type) SetPMPROT_ALLS(value uint8) {
	volatile.StoreUint8(&o.PMPROT.Reg, volatile.LoadUint8(&o.PMPROT.Reg)&^(0x8)|value<<3)
}
func (o *SMC_Type) GetPMPROT_ALLS() uint8 {
	return (volatile.LoadUint8(&o.PMPROT.Reg) & 0x8) >> 3
}
func (o *SMC_Type) SetPMPROT_AVLP(value uint8) {
	volatile.StoreUint8(&o.PMPROT.Reg, volatile.LoadUint8(&o.PMPROT.Reg)&^(0x20)|value<<5)
}
func (o *SMC_Type) GetPMPROT_AVLP() uint8 {
	return (volatile.LoadUint8(&o.PMPROT.Reg) & 0x20) >> 5
}

// SMC.PMCTRL: Power Mode Control register
func (o *SMC_Type) SetPMCTRL_STOPM(value uint8) {
	volatile.StoreUint8(&o.PMCTRL.Reg, volatile.LoadUint8(&o.PMCTRL.Reg)&^(0x7)|value)
}
func (o *SMC_Type) GetPMCTRL_STOPM() uint8 {
	return volatile.LoadUint8(&o.PMCTRL.Reg) & 0x7
}
func (o *SMC_Type) SetPMCTRL_STOPA(value uint8) {
	volatile.StoreUint8(&o.PMCTRL.Reg, volatile.LoadUint8(&o.PMCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SMC_Type) GetPMCTRL_STOPA() uint8 {
	return (volatile.LoadUint8(&o.PMCTRL.Reg) & 0x8) >> 3
}
func (o *SMC_Type) SetPMCTRL_RUNM(value uint8) {
	volatile.StoreUint8(&o.PMCTRL.Reg, volatile.LoadUint8(&o.PMCTRL.Reg)&^(0x60)|value<<5)
}
func (o *SMC_Type) GetPMCTRL_RUNM() uint8 {
	return (volatile.LoadUint8(&o.PMCTRL.Reg) & 0x60) >> 5
}

// SMC.STOPCTRL: Stop Control Register
func (o *SMC_Type) SetSTOPCTRL_VLLSM(value uint8) {
	volatile.StoreUint8(&o.STOPCTRL.Reg, volatile.LoadUint8(&o.STOPCTRL.Reg)&^(0x7)|value)
}
func (o *SMC_Type) GetSTOPCTRL_VLLSM() uint8 {
	return volatile.LoadUint8(&o.STOPCTRL.Reg) & 0x7
}
func (o *SMC_Type) SetSTOPCTRL_PORPO(value uint8) {
	volatile.StoreUint8(&o.STOPCTRL.Reg, volatile.LoadUint8(&o.STOPCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SMC_Type) GetSTOPCTRL_PORPO() uint8 {
	return (volatile.LoadUint8(&o.STOPCTRL.Reg) & 0x20) >> 5
}
func (o *SMC_Type) SetSTOPCTRL_PSTOPO(value uint8) {
	volatile.StoreUint8(&o.STOPCTRL.Reg, volatile.LoadUint8(&o.STOPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *SMC_Type) GetSTOPCTRL_PSTOPO() uint8 {
	return (volatile.LoadUint8(&o.STOPCTRL.Reg) & 0xc0) >> 6
}

// SMC.PMSTAT: Power Mode Status register
func (o *SMC_Type) SetPMSTAT(value uint8) {
	volatile.StoreUint8(&o.PMSTAT.Reg, volatile.LoadUint8(&o.PMSTAT.Reg)&^(0x7f)|value)
}
func (o *SMC_Type) GetPMSTAT() uint8 {
	return volatile.LoadUint8(&o.PMSTAT.Reg) & 0x7f
}

// Reset Control Module
type RCM_Type struct {
	SRS0 volatile.Register8 // 0x0
	SRS1 volatile.Register8 // 0x1
	_    [2]byte
	RPFC volatile.Register8 // 0x4
	RPFW volatile.Register8 // 0x5
}

// RCM.SRS0: System Reset Status Register 0
func (o *RCM_Type) SetSRS0_WAKEUP(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x1)|value)
}
func (o *RCM_Type) GetSRS0_WAKEUP() uint8 {
	return volatile.LoadUint8(&o.SRS0.Reg) & 0x1
}
func (o *RCM_Type) SetSRS0_LVD(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x2)|value<<1)
}
func (o *RCM_Type) GetSRS0_LVD() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x2) >> 1
}
func (o *RCM_Type) SetSRS0_LOC(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetSRS0_LOC() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x4) >> 2
}
func (o *RCM_Type) SetSRS0_LOL(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x8)|value<<3)
}
func (o *RCM_Type) GetSRS0_LOL() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x8) >> 3
}
func (o *RCM_Type) SetSRS0_WDOG(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x20)|value<<5)
}
func (o *RCM_Type) GetSRS0_WDOG() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x20) >> 5
}
func (o *RCM_Type) SetSRS0_PIN(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x40)|value<<6)
}
func (o *RCM_Type) GetSRS0_PIN() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x40) >> 6
}
func (o *RCM_Type) SetSRS0_POR(value uint8) {
	volatile.StoreUint8(&o.SRS0.Reg, volatile.LoadUint8(&o.SRS0.Reg)&^(0x80)|value<<7)
}
func (o *RCM_Type) GetSRS0_POR() uint8 {
	return (volatile.LoadUint8(&o.SRS0.Reg) & 0x80) >> 7
}

// RCM.SRS1: System Reset Status Register 1
func (o *RCM_Type) SetSRS1_LOCKUP(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x2)|value<<1)
}
func (o *RCM_Type) GetSRS1_LOCKUP() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x2) >> 1
}
func (o *RCM_Type) SetSRS1_SW(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetSRS1_SW() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x4) >> 2
}
func (o *RCM_Type) SetSRS1_MDM_AP(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x8)|value<<3)
}
func (o *RCM_Type) GetSRS1_MDM_AP() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x8) >> 3
}
func (o *RCM_Type) SetSRS1_SACKERR(value uint8) {
	volatile.StoreUint8(&o.SRS1.Reg, volatile.LoadUint8(&o.SRS1.Reg)&^(0x20)|value<<5)
}
func (o *RCM_Type) GetSRS1_SACKERR() uint8 {
	return (volatile.LoadUint8(&o.SRS1.Reg) & 0x20) >> 5
}

// RCM.RPFC: Reset Pin Filter Control register
func (o *RCM_Type) SetRPFC_RSTFLTSRW(value uint8) {
	volatile.StoreUint8(&o.RPFC.Reg, volatile.LoadUint8(&o.RPFC.Reg)&^(0x3)|value)
}
func (o *RCM_Type) GetRPFC_RSTFLTSRW() uint8 {
	return volatile.LoadUint8(&o.RPFC.Reg) & 0x3
}
func (o *RCM_Type) SetRPFC_RSTFLTSS(value uint8) {
	volatile.StoreUint8(&o.RPFC.Reg, volatile.LoadUint8(&o.RPFC.Reg)&^(0x4)|value<<2)
}
func (o *RCM_Type) GetRPFC_RSTFLTSS() uint8 {
	return (volatile.LoadUint8(&o.RPFC.Reg) & 0x4) >> 2
}

// RCM.RPFW: Reset Pin Filter Width register
func (o *RCM_Type) SetRPFW_RSTFLTSEL(value uint8) {
	volatile.StoreUint8(&o.RPFW.Reg, volatile.LoadUint8(&o.RPFW.Reg)&^(0x1f)|value)
}
func (o *RCM_Type) GetRPFW_RSTFLTSEL() uint8 {
	return volatile.LoadUint8(&o.RPFW.Reg) & 0x1f
}

// General Purpose Input/Output
type GPIO_Type struct {
	PDOR volatile.Register32 // 0x0
	PSOR volatile.Register32 // 0x4
	PCOR volatile.Register32 // 0x8
	PTOR volatile.Register32 // 0xC
	PDIR volatile.Register32 // 0x10
	PDDR volatile.Register32 // 0x14
}

// GPIO.PDOR: Port Data Output Register
func (o *GPIO_Type) SetPDOR(value uint32) {
	volatile.StoreUint32(&o.PDOR.Reg, value)
}
func (o *GPIO_Type) GetPDOR() uint32 {
	return volatile.LoadUint32(&o.PDOR.Reg)
}

// GPIO.PSOR: Port Set Output Register
func (o *GPIO_Type) SetPSOR(value uint32) {
	volatile.StoreUint32(&o.PSOR.Reg, value)
}
func (o *GPIO_Type) GetPSOR() uint32 {
	return volatile.LoadUint32(&o.PSOR.Reg)
}

// GPIO.PCOR: Port Clear Output Register
func (o *GPIO_Type) SetPCOR(value uint32) {
	volatile.StoreUint32(&o.PCOR.Reg, value)
}
func (o *GPIO_Type) GetPCOR() uint32 {
	return volatile.LoadUint32(&o.PCOR.Reg)
}

// GPIO.PTOR: Port Toggle Output Register
func (o *GPIO_Type) SetPTOR(value uint32) {
	volatile.StoreUint32(&o.PTOR.Reg, value)
}
func (o *GPIO_Type) GetPTOR() uint32 {
	return volatile.LoadUint32(&o.PTOR.Reg)
}

// GPIO.PDIR: Port Data Input Register
func (o *GPIO_Type) SetPDIR(value uint32) {
	volatile.StoreUint32(&o.PDIR.Reg, value)
}
func (o *GPIO_Type) GetPDIR() uint32 {
	return volatile.LoadUint32(&o.PDIR.Reg)
}

// GPIO.PDDR: Port Data Direction Register
func (o *GPIO_Type) SetPDDR(value uint32) {
	volatile.StoreUint32(&o.PDDR.Reg, value)
}
func (o *GPIO_Type) GetPDDR() uint32 {
	return volatile.LoadUint32(&o.PDDR.Reg)
}

// System Control Block
type SystemControl_Type struct {
	_     [8]byte
	ACTLR volatile.Register32 // 0x8
	_     [3316]byte
	CPUID volatile.Register32 // 0xD00
	ICSR  volatile.Register32 // 0xD04
	VTOR  volatile.Register32 // 0xD08
	AIRCR volatile.Register32 // 0xD0C
	SCR   volatile.Register32 // 0xD10
	CCR   volatile.Register32 // 0xD14
	_     [4]byte
	SHPR2 volatile.Register32 // 0xD1C
	SHPR3 volatile.Register32 // 0xD20
	SHCSR volatile.Register32 // 0xD24
	_     [8]byte
	DFSR  volatile.Register32 // 0xD30
}

// SystemControl.CPUID: CPUID Base Register
func (o *SystemControl_Type) SetCPUID_REVISION(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SystemControl_Type) GetCPUID_REVISION() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SystemControl_Type) SetCPUID_PARTNO(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SystemControl_Type) GetCPUID_PARTNO() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SystemControl_Type) SetCPUID_ARCHITECTURE(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SystemControl_Type) GetCPUID_ARCHITECTURE() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SystemControl_Type) SetCPUID_VARIANT(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SystemControl_Type) GetCPUID_VARIANT() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SystemControl_Type) SetCPUID_IMPLEMENTER(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SystemControl_Type) GetCPUID_IMPLEMENTER() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SystemControl.ICSR: Interrupt Control and State Register
func (o *SystemControl_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x3f000)|value<<12)
}
func (o *SystemControl_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x3f000) >> 12
}
func (o *SystemControl_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SystemControl_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SystemControl_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SystemControl_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SystemControl_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SystemControl_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SystemControl_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SystemControl_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SystemControl_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SystemControl_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SystemControl.VTOR: Vector Table Offset Register
func (o *SystemControl_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0xffffff80)|value<<7)
}
func (o *SystemControl_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0xffffff80) >> 7
}

// SystemControl.AIRCR: Application Interrupt and Reset Control Register
func (o *SystemControl_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SystemControl_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SystemControl_Type) SetAIRCR_ENDIANNESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SystemControl_Type) GetAIRCR_ENDIANNESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SystemControl_Type) SetAIRCR_VECTKEY(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SystemControl_Type) GetAIRCR_VECTKEY() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SystemControl.SCR: System Control Register
func (o *SystemControl_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SystemControl_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SystemControl_Type) SetSCR_SEVONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SystemControl_Type) GetSCR_SEVONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SystemControl.CCR: Configuration and Control Register
func (o *SystemControl_Type) SetCCR_UNALIGN_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SystemControl_Type) GetCCR_UNALIGN_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SystemControl_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SystemControl_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SystemControl.SHPR2: System Handler Priority Register 2
func (o *SystemControl_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SystemControl_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SystemControl.SHPR3: System Handler Priority Register 3
func (o *SystemControl_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SystemControl_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SystemControl_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SystemControl_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SystemControl.SHCSR: System Handler Control and State Register
func (o *SystemControl_Type) SetSHCSR_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCSR.Reg, volatile.LoadUint32(&o.SHCSR.Reg)&^(0x8000)|value<<15)
}
func (o *SystemControl_Type) GetSHCSR_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCSR.Reg) & 0x8000) >> 15
}

// SystemControl.DFSR: Debug Fault Status Register
func (o *SystemControl_Type) SetDFSR_HALTED(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x1)|value)
}
func (o *SystemControl_Type) GetDFSR_HALTED() uint32 {
	return volatile.LoadUint32(&o.DFSR.Reg) & 0x1
}
func (o *SystemControl_Type) SetDFSR_BKPT(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x2)|value<<1)
}
func (o *SystemControl_Type) GetDFSR_BKPT() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x2) >> 1
}
func (o *SystemControl_Type) SetDFSR_DWTTRAP(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x4)|value<<2)
}
func (o *SystemControl_Type) GetDFSR_DWTTRAP() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x4) >> 2
}
func (o *SystemControl_Type) SetDFSR_VCATCH(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x8)|value<<3)
}
func (o *SystemControl_Type) GetDFSR_VCATCH() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x8) >> 3
}
func (o *SystemControl_Type) SetDFSR_EXTERNAL(value uint32) {
	volatile.StoreUint32(&o.DFSR.Reg, volatile.LoadUint32(&o.DFSR.Reg)&^(0x10)|value<<4)
}
func (o *SystemControl_Type) GetDFSR_EXTERNAL() uint32 {
	return (volatile.LoadUint32(&o.DFSR.Reg) & 0x10) >> 4
}

// System timer
type SysTick_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// SysTick.CSR: SysTick Control and Status Register
func (o *SysTick_Type) SetCSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *SysTick_Type) GetCSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *SysTick_Type) SetCSR_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *SysTick_Type) GetCSR_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *SysTick_Type) SetCSR_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *SysTick_Type) GetCSR_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *SysTick_Type) SetCSR_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *SysTick_Type) GetCSR_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}

// SysTick.RVR: SysTick Reload Value Register
func (o *SysTick_Type) SetRVR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.RVR.Reg, volatile.LoadUint32(&o.RVR.Reg)&^(0xffffff)|value)
}
func (o *SysTick_Type) GetRVR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.RVR.Reg) & 0xffffff
}

// SysTick.CVR: SysTick Current Value Register
func (o *SysTick_Type) SetCVR_CURRENT(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffffff)|value)
}
func (o *SysTick_Type) GetCVR_CURRENT() uint32 {
	return volatile.LoadUint32(&o.CVR.Reg) & 0xffffff
}

// SysTick.CALIB: SysTick Calibration Value Register
func (o *SysTick_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *SysTick_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *SysTick_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *SysTick_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *SysTick_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *SysTick_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	NVIC_ISER volatile.Register32 // 0x0
	_         [124]byte
	NVIC_ICER volatile.Register32 // 0x80
	_         [124]byte
	NVIC_ISPR volatile.Register32 // 0x100
	_         [124]byte
	NVIC_ICPR volatile.Register32 // 0x180
	_         [380]byte
	NVIC_IPR0 volatile.Register32 // 0x300
	NVIC_IPR1 volatile.Register32 // 0x304
	NVIC_IPR2 volatile.Register32 // 0x308
	NVIC_IPR3 volatile.Register32 // 0x30C
	NVIC_IPR4 volatile.Register32 // 0x310
	NVIC_IPR5 volatile.Register32 // 0x314
	NVIC_IPR6 volatile.Register32 // 0x318
	NVIC_IPR7 volatile.Register32 // 0x31C
}

// NVIC.NVIC_ISER: Interrupt Set Enable Register
func (o *NVIC_Type) SetNVIC_ISER_SETENA0(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x1)|value)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA0() uint32 {
	return volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x1
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA1(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x2)|value<<1)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA1() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x2) >> 1
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA2(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x4)|value<<2)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA2() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x4) >> 2
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA3(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x8)|value<<3)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA3() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x8) >> 3
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA4(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x10)|value<<4)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA4() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x10) >> 4
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA5(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x20)|value<<5)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA5() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x20) >> 5
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA6(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x40)|value<<6)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA6() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x40) >> 6
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA7(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x80)|value<<7)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA7() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x80) >> 7
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA8(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x100)|value<<8)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA8() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x100) >> 8
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA9(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x200)|value<<9)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA9() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x200) >> 9
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA10(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x400)|value<<10)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA10() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x400) >> 10
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA11(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x800)|value<<11)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA11() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x800) >> 11
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA12(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x1000)|value<<12)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA12() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x1000) >> 12
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA13(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x2000)|value<<13)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA13() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x2000) >> 13
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA14(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x4000)|value<<14)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA14() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x4000) >> 14
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA15(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x8000)|value<<15)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA15() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x8000) >> 15
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA16(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x10000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA16() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x10000) >> 16
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA17(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x20000)|value<<17)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA17() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x20000) >> 17
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA18(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x40000)|value<<18)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA18() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x40000) >> 18
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA19(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x80000)|value<<19)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA19() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x80000) >> 19
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA20(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x100000)|value<<20)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA20() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x100000) >> 20
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA21(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x200000)|value<<21)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA21() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x200000) >> 21
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA22(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x400000)|value<<22)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA22() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x400000) >> 22
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA23(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x800000)|value<<23)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA23() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x800000) >> 23
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA24(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x1000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA24() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x1000000) >> 24
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA25(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x2000000)|value<<25)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA25() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x2000000) >> 25
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA26(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x4000000)|value<<26)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA26() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x4000000) >> 26
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA27(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x8000000)|value<<27)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA27() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x8000000) >> 27
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA28(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x10000000)|value<<28)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA28() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x10000000) >> 28
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA29(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x20000000)|value<<29)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA29() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x20000000) >> 29
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA30(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x40000000)|value<<30)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA30() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x40000000) >> 30
}
func (o *NVIC_Type) SetNVIC_ISER_SETENA31(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISER.Reg, volatile.LoadUint32(&o.NVIC_ISER.Reg)&^(0x80000000)|value<<31)
}
func (o *NVIC_Type) GetNVIC_ISER_SETENA31() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISER.Reg) & 0x80000000) >> 31
}

// NVIC.NVIC_ICER: Interrupt Clear Enable Register
func (o *NVIC_Type) SetNVIC_ICER_CLRENA0(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x1)|value)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA0() uint32 {
	return volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x1
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA1(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x2)|value<<1)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA1() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x2) >> 1
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA2(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x4)|value<<2)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA2() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x4) >> 2
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA3(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x8)|value<<3)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA3() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x8) >> 3
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA4(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x10)|value<<4)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA4() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x10) >> 4
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA5(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x20)|value<<5)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA5() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x20) >> 5
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA6(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x40)|value<<6)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA6() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x40) >> 6
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA7(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x80)|value<<7)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA7() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x80) >> 7
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA8(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x100)|value<<8)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA8() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x100) >> 8
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA9(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x200)|value<<9)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA9() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x200) >> 9
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA10(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x400)|value<<10)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA10() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x400) >> 10
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA11(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x800)|value<<11)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA11() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x800) >> 11
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA12(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x1000)|value<<12)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA12() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x1000) >> 12
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA13(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x2000)|value<<13)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA13() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x2000) >> 13
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA14(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x4000)|value<<14)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA14() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x4000) >> 14
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA15(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x8000)|value<<15)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA15() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x8000) >> 15
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA16(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x10000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA16() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x10000) >> 16
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA17(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x20000)|value<<17)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA17() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x20000) >> 17
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA18(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x40000)|value<<18)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA18() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x40000) >> 18
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA19(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x80000)|value<<19)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA19() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x80000) >> 19
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA20(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x100000)|value<<20)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA20() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x100000) >> 20
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA21(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x200000)|value<<21)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA21() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x200000) >> 21
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA22(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x400000)|value<<22)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA22() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x400000) >> 22
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA23(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x800000)|value<<23)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA23() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x800000) >> 23
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA24(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x1000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA24() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x1000000) >> 24
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA25(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x2000000)|value<<25)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA25() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x2000000) >> 25
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA26(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x4000000)|value<<26)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA26() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x4000000) >> 26
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA27(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x8000000)|value<<27)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA27() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x8000000) >> 27
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA28(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x10000000)|value<<28)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA28() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x10000000) >> 28
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA29(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x20000000)|value<<29)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA29() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x20000000) >> 29
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA30(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x40000000)|value<<30)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA30() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x40000000) >> 30
}
func (o *NVIC_Type) SetNVIC_ICER_CLRENA31(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICER.Reg, volatile.LoadUint32(&o.NVIC_ICER.Reg)&^(0x80000000)|value<<31)
}
func (o *NVIC_Type) GetNVIC_ICER_CLRENA31() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICER.Reg) & 0x80000000) >> 31
}

// NVIC.NVIC_ISPR: Interrupt Set Pending Register
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND0(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x1)|value)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND0() uint32 {
	return volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x1
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND1(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x2)|value<<1)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND1() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x2) >> 1
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND2(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x4)|value<<2)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND2() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x4) >> 2
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND3(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x8)|value<<3)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND3() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x8) >> 3
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND4(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x10)|value<<4)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND4() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x10) >> 4
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND5(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x20)|value<<5)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND5() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x20) >> 5
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND6(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x40)|value<<6)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND6() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x40) >> 6
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND7(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x80)|value<<7)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND7() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x80) >> 7
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND8(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x100)|value<<8)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND8() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x100) >> 8
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND9(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x200)|value<<9)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND9() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x200) >> 9
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND10(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x400)|value<<10)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND10() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x400) >> 10
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND11(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x800)|value<<11)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND11() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x800) >> 11
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND12(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x1000)|value<<12)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND12() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x1000) >> 12
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND13(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x2000)|value<<13)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND13() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x2000) >> 13
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND14(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x4000)|value<<14)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND14() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x4000) >> 14
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND15(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x8000)|value<<15)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND15() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x8000) >> 15
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND16(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x10000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND16() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x10000) >> 16
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND17(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x20000)|value<<17)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND17() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x20000) >> 17
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND18(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x40000)|value<<18)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND18() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x40000) >> 18
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND19(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x80000)|value<<19)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND19() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x80000) >> 19
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND20(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x100000)|value<<20)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND20() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x100000) >> 20
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND21(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x200000)|value<<21)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND21() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x200000) >> 21
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND22(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x400000)|value<<22)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND22() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x400000) >> 22
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND23(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x800000)|value<<23)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND23() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x800000) >> 23
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND24(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x1000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND24() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x1000000) >> 24
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND25(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x2000000)|value<<25)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND25() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x2000000) >> 25
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND26(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x4000000)|value<<26)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND26() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x4000000) >> 26
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND27(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x8000000)|value<<27)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND27() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x8000000) >> 27
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND28(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x10000000)|value<<28)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND28() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x10000000) >> 28
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND29(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x20000000)|value<<29)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND29() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x20000000) >> 29
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND30(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x40000000)|value<<30)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND30() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x40000000) >> 30
}
func (o *NVIC_Type) SetNVIC_ISPR_SETPEND31(value uint32) {
	volatile.StoreUint32(&o.NVIC_ISPR.Reg, volatile.LoadUint32(&o.NVIC_ISPR.Reg)&^(0x80000000)|value<<31)
}
func (o *NVIC_Type) GetNVIC_ISPR_SETPEND31() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ISPR.Reg) & 0x80000000) >> 31
}

// NVIC.NVIC_ICPR: Interrupt Clear Pending Register
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND0(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x1)|value)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND0() uint32 {
	return volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x1
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND1(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x2)|value<<1)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND1() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x2) >> 1
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND2(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x4)|value<<2)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND2() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x4) >> 2
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND3(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x8)|value<<3)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND3() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x8) >> 3
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND4(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x10)|value<<4)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND4() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x10) >> 4
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND5(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x20)|value<<5)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND5() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x20) >> 5
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND6(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x40)|value<<6)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND6() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x40) >> 6
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND7(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x80)|value<<7)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND7() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x80) >> 7
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND8(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x100)|value<<8)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND8() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x100) >> 8
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND9(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x200)|value<<9)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND9() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x200) >> 9
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND10(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x400)|value<<10)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND10() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x400) >> 10
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND11(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x800)|value<<11)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND11() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x800) >> 11
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND12(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x1000)|value<<12)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND12() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x1000) >> 12
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND13(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x2000)|value<<13)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND13() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x2000) >> 13
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND14(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x4000)|value<<14)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND14() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x4000) >> 14
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND15(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x8000)|value<<15)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND15() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x8000) >> 15
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND16(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x10000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND16() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x10000) >> 16
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND17(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x20000)|value<<17)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND17() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x20000) >> 17
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND18(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x40000)|value<<18)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND18() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x40000) >> 18
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND19(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x80000)|value<<19)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND19() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x80000) >> 19
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND20(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x100000)|value<<20)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND20() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x100000) >> 20
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND21(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x200000)|value<<21)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND21() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x200000) >> 21
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND22(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x400000)|value<<22)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND22() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x400000) >> 22
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND23(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x800000)|value<<23)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND23() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x800000) >> 23
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND24(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x1000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND24() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x1000000) >> 24
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND25(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x2000000)|value<<25)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND25() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x2000000) >> 25
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND26(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x4000000)|value<<26)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND26() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x4000000) >> 26
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND27(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x8000000)|value<<27)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND27() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x8000000) >> 27
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND28(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x10000000)|value<<28)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND28() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x10000000) >> 28
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND29(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x20000000)|value<<29)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND29() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x20000000) >> 29
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND30(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x40000000)|value<<30)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND30() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x40000000) >> 30
}
func (o *NVIC_Type) SetNVIC_ICPR_CLRPEND31(value uint32) {
	volatile.StoreUint32(&o.NVIC_ICPR.Reg, volatile.LoadUint32(&o.NVIC_ICPR.Reg)&^(0x80000000)|value<<31)
}
func (o *NVIC_Type) GetNVIC_ICPR_CLRPEND31() uint32 {
	return (volatile.LoadUint32(&o.NVIC_ICPR.Reg) & 0x80000000) >> 31
}

// NVIC.NVIC_IPR0: Interrupt Priority Register 0
func (o *NVIC_Type) SetNVIC_IPR0_PRI_0(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR0.Reg, volatile.LoadUint32(&o.NVIC_IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR0_PRI_0() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR0_PRI_1(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR0.Reg, volatile.LoadUint32(&o.NVIC_IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR0_PRI_1() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR0_PRI_2(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR0.Reg, volatile.LoadUint32(&o.NVIC_IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR0_PRI_2() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR0_PRI_3(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR0.Reg, volatile.LoadUint32(&o.NVIC_IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR0_PRI_3() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.NVIC_IPR1: Interrupt Priority Register 1
func (o *NVIC_Type) SetNVIC_IPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR1.Reg, volatile.LoadUint32(&o.NVIC_IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR1.Reg, volatile.LoadUint32(&o.NVIC_IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR1.Reg, volatile.LoadUint32(&o.NVIC_IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR1_PRI_7(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR1.Reg, volatile.LoadUint32(&o.NVIC_IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR1_PRI_7() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.NVIC_IPR2: Interrupt Priority Register 2
func (o *NVIC_Type) SetNVIC_IPR2_PRI_8(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR2.Reg, volatile.LoadUint32(&o.NVIC_IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR2_PRI_8() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR2_PRI_9(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR2.Reg, volatile.LoadUint32(&o.NVIC_IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR2_PRI_9() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR2_PRI_10(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR2.Reg, volatile.LoadUint32(&o.NVIC_IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR2_PRI_10() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR2.Reg, volatile.LoadUint32(&o.NVIC_IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.NVIC_IPR3: Interrupt Priority Register 3
func (o *NVIC_Type) SetNVIC_IPR3_PRI_12(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR3.Reg, volatile.LoadUint32(&o.NVIC_IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR3_PRI_12() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR3_PRI_13(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR3.Reg, volatile.LoadUint32(&o.NVIC_IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR3_PRI_13() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR3.Reg, volatile.LoadUint32(&o.NVIC_IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR3.Reg, volatile.LoadUint32(&o.NVIC_IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.NVIC_IPR4: Interrupt Priority Register 4
func (o *NVIC_Type) SetNVIC_IPR4_PRI_16(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR4.Reg, volatile.LoadUint32(&o.NVIC_IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR4_PRI_16() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR4_PRI_17(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR4.Reg, volatile.LoadUint32(&o.NVIC_IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR4_PRI_17() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR4_PRI_18(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR4.Reg, volatile.LoadUint32(&o.NVIC_IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR4_PRI_18() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR4_PRI_19(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR4.Reg, volatile.LoadUint32(&o.NVIC_IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR4_PRI_19() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.NVIC_IPR5: Interrupt Priority Register 5
func (o *NVIC_Type) SetNVIC_IPR5_PRI_20(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR5.Reg, volatile.LoadUint32(&o.NVIC_IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR5_PRI_20() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR5_PRI_21(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR5.Reg, volatile.LoadUint32(&o.NVIC_IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR5_PRI_21() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR5_PRI_22(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR5.Reg, volatile.LoadUint32(&o.NVIC_IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR5_PRI_22() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR5_PRI_23(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR5.Reg, volatile.LoadUint32(&o.NVIC_IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR5_PRI_23() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.NVIC_IPR6: Interrupt Priority Register 6
func (o *NVIC_Type) SetNVIC_IPR6_PRI_24(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR6.Reg, volatile.LoadUint32(&o.NVIC_IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR6_PRI_24() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR6_PRI_25(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR6.Reg, volatile.LoadUint32(&o.NVIC_IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR6_PRI_25() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR6_PRI_26(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR6.Reg, volatile.LoadUint32(&o.NVIC_IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR6_PRI_26() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR6_PRI_27(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR6.Reg, volatile.LoadUint32(&o.NVIC_IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR6_PRI_27() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.NVIC_IPR7: Interrupt Priority Register 7
func (o *NVIC_Type) SetNVIC_IPR7_PRI_28(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR7.Reg, volatile.LoadUint32(&o.NVIC_IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetNVIC_IPR7_PRI_28() uint32 {
	return volatile.LoadUint32(&o.NVIC_IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetNVIC_IPR7_PRI_29(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR7.Reg, volatile.LoadUint32(&o.NVIC_IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetNVIC_IPR7_PRI_29() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetNVIC_IPR7_PRI_30(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR7.Reg, volatile.LoadUint32(&o.NVIC_IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetNVIC_IPR7_PRI_30() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetNVIC_IPR7_PRI_31(value uint32) {
	volatile.StoreUint32(&o.NVIC_IPR7.Reg, volatile.LoadUint32(&o.NVIC_IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetNVIC_IPR7_PRI_31() uint32 {
	return (volatile.LoadUint32(&o.NVIC_IPR7.Reg) & 0xff000000) >> 24
}

// Micro Trace Buffer
type MTB_Type struct {
	POSITION    volatile.Register32 // 0x0
	MASTER      volatile.Register32 // 0x4
	FLOW        volatile.Register32 // 0x8
	BASE        volatile.Register32 // 0xC
	_           [3824]byte
	MODECTRL    volatile.Register32 // 0xF00
	_           [156]byte
	TAGSET      volatile.Register32 // 0xFA0
	TAGCLEAR    volatile.Register32 // 0xFA4
	_           [8]byte
	LOCKACCESS  volatile.Register32 // 0xFB0
	LOCKSTAT    volatile.Register32 // 0xFB4
	AUTHSTAT    volatile.Register32 // 0xFB8
	DEVICEARCH  volatile.Register32 // 0xFBC
	_           [8]byte
	DEVICECFG   volatile.Register32 // 0xFC8
	DEVICETYPID volatile.Register32 // 0xFCC
	PERIPHID4   volatile.Register32 // 0xFD0
	PERIPHID5   volatile.Register32 // 0xFD4
	PERIPHID6   volatile.Register32 // 0xFD8
	PERIPHID7   volatile.Register32 // 0xFDC
	PERIPHID0   volatile.Register32 // 0xFE0
	PERIPHID1   volatile.Register32 // 0xFE4
	PERIPHID2   volatile.Register32 // 0xFE8
	PERIPHID3   volatile.Register32 // 0xFEC
	COMPID0     volatile.Register32 // 0xFF0
	COMPID1     volatile.Register32 // 0xFF4
	COMPID2     volatile.Register32 // 0xFF8
	COMPID3     volatile.Register32 // 0xFFC
}

// MTB.POSITION: MTB Position Register
func (o *MTB_Type) SetPOSITION_WRAP(value uint32) {
	volatile.StoreUint32(&o.POSITION.Reg, volatile.LoadUint32(&o.POSITION.Reg)&^(0x4)|value<<2)
}
func (o *MTB_Type) GetPOSITION_WRAP() uint32 {
	return (volatile.LoadUint32(&o.POSITION.Reg) & 0x4) >> 2
}
func (o *MTB_Type) SetPOSITION_POINTER(value uint32) {
	volatile.StoreUint32(&o.POSITION.Reg, volatile.LoadUint32(&o.POSITION.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MTB_Type) GetPOSITION_POINTER() uint32 {
	return (volatile.LoadUint32(&o.POSITION.Reg) & 0xfffffff8) >> 3
}

// MTB.MASTER: MTB Master Register
func (o *MTB_Type) SetMASTER_MASK(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x1f)|value)
}
func (o *MTB_Type) GetMASTER_MASK() uint32 {
	return volatile.LoadUint32(&o.MASTER.Reg) & 0x1f
}
func (o *MTB_Type) SetMASTER_TSTARTEN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x20)|value<<5)
}
func (o *MTB_Type) GetMASTER_TSTARTEN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x20) >> 5
}
func (o *MTB_Type) SetMASTER_TSTOPEN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x40)|value<<6)
}
func (o *MTB_Type) GetMASTER_TSTOPEN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x40) >> 6
}
func (o *MTB_Type) SetMASTER_SFRWPRIV(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x80)|value<<7)
}
func (o *MTB_Type) GetMASTER_SFRWPRIV() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x80) >> 7
}
func (o *MTB_Type) SetMASTER_RAMPRIV(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x100)|value<<8)
}
func (o *MTB_Type) GetMASTER_RAMPRIV() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x100) >> 8
}
func (o *MTB_Type) SetMASTER_HALTREQ(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x200)|value<<9)
}
func (o *MTB_Type) GetMASTER_HALTREQ() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x200) >> 9
}
func (o *MTB_Type) SetMASTER_EN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x80000000)|value<<31)
}
func (o *MTB_Type) GetMASTER_EN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x80000000) >> 31
}

// MTB.FLOW: MTB Flow Register
func (o *MTB_Type) SetFLOW_AUTOSTOP(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0x1)|value)
}
func (o *MTB_Type) GetFLOW_AUTOSTOP() uint32 {
	return volatile.LoadUint32(&o.FLOW.Reg) & 0x1
}
func (o *MTB_Type) SetFLOW_AUTOHALT(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0x2)|value<<1)
}
func (o *MTB_Type) GetFLOW_AUTOHALT() uint32 {
	return (volatile.LoadUint32(&o.FLOW.Reg) & 0x2) >> 1
}
func (o *MTB_Type) SetFLOW_WATERMARK(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MTB_Type) GetFLOW_WATERMARK() uint32 {
	return (volatile.LoadUint32(&o.FLOW.Reg) & 0xfffffff8) >> 3
}

// MTB.BASE: MTB Base Register
func (o *MTB_Type) SetBASE(value uint32) {
	volatile.StoreUint32(&o.BASE.Reg, value)
}
func (o *MTB_Type) GetBASE() uint32 {
	return volatile.LoadUint32(&o.BASE.Reg)
}

// MTB.MODECTRL: Integration Mode Control Register
func (o *MTB_Type) SetMODECTRL(value uint32) {
	volatile.StoreUint32(&o.MODECTRL.Reg, value)
}
func (o *MTB_Type) GetMODECTRL() uint32 {
	return volatile.LoadUint32(&o.MODECTRL.Reg)
}

// MTB.TAGSET: Claim TAG Set Register
func (o *MTB_Type) SetTAGSET(value uint32) {
	volatile.StoreUint32(&o.TAGSET.Reg, value)
}
func (o *MTB_Type) GetTAGSET() uint32 {
	return volatile.LoadUint32(&o.TAGSET.Reg)
}

// MTB.TAGCLEAR: Claim TAG Clear Register
func (o *MTB_Type) SetTAGCLEAR(value uint32) {
	volatile.StoreUint32(&o.TAGCLEAR.Reg, value)
}
func (o *MTB_Type) GetTAGCLEAR() uint32 {
	return volatile.LoadUint32(&o.TAGCLEAR.Reg)
}

// MTB.LOCKACCESS: Lock Access Register
func (o *MTB_Type) SetLOCKACCESS(value uint32) {
	volatile.StoreUint32(&o.LOCKACCESS.Reg, value)
}
func (o *MTB_Type) GetLOCKACCESS() uint32 {
	return volatile.LoadUint32(&o.LOCKACCESS.Reg)
}

// MTB.LOCKSTAT: Lock Status Register
func (o *MTB_Type) SetLOCKSTAT(value uint32) {
	volatile.StoreUint32(&o.LOCKSTAT.Reg, value)
}
func (o *MTB_Type) GetLOCKSTAT() uint32 {
	return volatile.LoadUint32(&o.LOCKSTAT.Reg)
}

// MTB.AUTHSTAT: Authentication Status Register
func (o *MTB_Type) SetAUTHSTAT_BIT0(value uint32) {
	volatile.StoreUint32(&o.AUTHSTAT.Reg, volatile.LoadUint32(&o.AUTHSTAT.Reg)&^(0x1)|value)
}
func (o *MTB_Type) GetAUTHSTAT_BIT0() uint32 {
	return volatile.LoadUint32(&o.AUTHSTAT.Reg) & 0x1
}
func (o *MTB_Type) SetAUTHSTAT_BIT1(value uint32) {
	volatile.StoreUint32(&o.AUTHSTAT.Reg, volatile.LoadUint32(&o.AUTHSTAT.Reg)&^(0x2)|value<<1)
}
func (o *MTB_Type) GetAUTHSTAT_BIT1() uint32 {
	return (volatile.LoadUint32(&o.AUTHSTAT.Reg) & 0x2) >> 1
}
func (o *MTB_Type) SetAUTHSTAT_BIT2(value uint32) {
	volatile.StoreUint32(&o.AUTHSTAT.Reg, volatile.LoadUint32(&o.AUTHSTAT.Reg)&^(0x4)|value<<2)
}
func (o *MTB_Type) GetAUTHSTAT_BIT2() uint32 {
	return (volatile.LoadUint32(&o.AUTHSTAT.Reg) & 0x4) >> 2
}
func (o *MTB_Type) SetAUTHSTAT_BIT3(value uint32) {
	volatile.StoreUint32(&o.AUTHSTAT.Reg, volatile.LoadUint32(&o.AUTHSTAT.Reg)&^(0x8)|value<<3)
}
func (o *MTB_Type) GetAUTHSTAT_BIT3() uint32 {
	return (volatile.LoadUint32(&o.AUTHSTAT.Reg) & 0x8) >> 3
}

// MTB.DEVICEARCH: Device Architecture Register
func (o *MTB_Type) SetDEVICEARCH(value uint32) {
	volatile.StoreUint32(&o.DEVICEARCH.Reg, value)
}
func (o *MTB_Type) GetDEVICEARCH() uint32 {
	return volatile.LoadUint32(&o.DEVICEARCH.Reg)
}

// MTB.DEVICECFG: Device Configuration Register
func (o *MTB_Type) SetDEVICECFG(value uint32) {
	volatile.StoreUint32(&o.DEVICECFG.Reg, value)
}
func (o *MTB_Type) GetDEVICECFG() uint32 {
	return volatile.LoadUint32(&o.DEVICECFG.Reg)
}

// MTB.DEVICETYPID: Device Type Identifier Register
func (o *MTB_Type) SetDEVICETYPID(value uint32) {
	volatile.StoreUint32(&o.DEVICETYPID.Reg, value)
}
func (o *MTB_Type) GetDEVICETYPID() uint32 {
	return volatile.LoadUint32(&o.DEVICETYPID.Reg)
}

// MTB.PERIPHID4: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID4(value uint32) {
	volatile.StoreUint32(&o.PERIPHID4.Reg, value)
}
func (o *MTB_Type) GetPERIPHID4() uint32 {
	return volatile.LoadUint32(&o.PERIPHID4.Reg)
}

// MTB.PERIPHID5: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID5(value uint32) {
	volatile.StoreUint32(&o.PERIPHID5.Reg, value)
}
func (o *MTB_Type) GetPERIPHID5() uint32 {
	return volatile.LoadUint32(&o.PERIPHID5.Reg)
}

// MTB.PERIPHID6: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID6(value uint32) {
	volatile.StoreUint32(&o.PERIPHID6.Reg, value)
}
func (o *MTB_Type) GetPERIPHID6() uint32 {
	return volatile.LoadUint32(&o.PERIPHID6.Reg)
}

// MTB.PERIPHID7: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID7(value uint32) {
	volatile.StoreUint32(&o.PERIPHID7.Reg, value)
}
func (o *MTB_Type) GetPERIPHID7() uint32 {
	return volatile.LoadUint32(&o.PERIPHID7.Reg)
}

// MTB.PERIPHID0: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID0(value uint32) {
	volatile.StoreUint32(&o.PERIPHID0.Reg, value)
}
func (o *MTB_Type) GetPERIPHID0() uint32 {
	return volatile.LoadUint32(&o.PERIPHID0.Reg)
}

// MTB.PERIPHID1: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID1(value uint32) {
	volatile.StoreUint32(&o.PERIPHID1.Reg, value)
}
func (o *MTB_Type) GetPERIPHID1() uint32 {
	return volatile.LoadUint32(&o.PERIPHID1.Reg)
}

// MTB.PERIPHID2: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID2(value uint32) {
	volatile.StoreUint32(&o.PERIPHID2.Reg, value)
}
func (o *MTB_Type) GetPERIPHID2() uint32 {
	return volatile.LoadUint32(&o.PERIPHID2.Reg)
}

// MTB.PERIPHID3: Peripheral ID Register
func (o *MTB_Type) SetPERIPHID3(value uint32) {
	volatile.StoreUint32(&o.PERIPHID3.Reg, value)
}
func (o *MTB_Type) GetPERIPHID3() uint32 {
	return volatile.LoadUint32(&o.PERIPHID3.Reg)
}

// MTB.COMPID0: Component ID Register
func (o *MTB_Type) SetCOMPID0(value uint32) {
	volatile.StoreUint32(&o.COMPID0.Reg, value)
}
func (o *MTB_Type) GetCOMPID0() uint32 {
	return volatile.LoadUint32(&o.COMPID0.Reg)
}

// MTB.COMPID1: Component ID Register
func (o *MTB_Type) SetCOMPID1(value uint32) {
	volatile.StoreUint32(&o.COMPID1.Reg, value)
}
func (o *MTB_Type) GetCOMPID1() uint32 {
	return volatile.LoadUint32(&o.COMPID1.Reg)
}

// MTB.COMPID2: Component ID Register
func (o *MTB_Type) SetCOMPID2(value uint32) {
	volatile.StoreUint32(&o.COMPID2.Reg, value)
}
func (o *MTB_Type) GetCOMPID2() uint32 {
	return volatile.LoadUint32(&o.COMPID2.Reg)
}

// MTB.COMPID3: Component ID Register
func (o *MTB_Type) SetCOMPID3(value uint32) {
	volatile.StoreUint32(&o.COMPID3.Reg, value)
}
func (o *MTB_Type) GetCOMPID3() uint32 {
	return volatile.LoadUint32(&o.COMPID3.Reg)
}

// MTB data watchpoint and trace
type MTBDWT_Type struct {
	CTRL        volatile.Register32 // 0x0
	_           [28]byte
	COMP0       volatile.Register32 // 0x20
	MASK0       volatile.Register32 // 0x24
	FCT0        volatile.Register32 // 0x28
	_           [4]byte
	COMP1       volatile.Register32 // 0x30
	MASK1       volatile.Register32 // 0x34
	FCT1        volatile.Register32 // 0x38
	_           [452]byte
	TBCTRL      volatile.Register32 // 0x200
	_           [3524]byte
	DEVICECFG   volatile.Register32 // 0xFC8
	DEVICETYPID volatile.Register32 // 0xFCC
	PERIPHID4   volatile.Register32 // 0xFD0
	PERIPHID5   volatile.Register32 // 0xFD4
	PERIPHID6   volatile.Register32 // 0xFD8
	PERIPHID7   volatile.Register32 // 0xFDC
	PERIPHID0   volatile.Register32 // 0xFE0
	PERIPHID1   volatile.Register32 // 0xFE4
	PERIPHID2   volatile.Register32 // 0xFE8
	PERIPHID3   volatile.Register32 // 0xFEC
	COMPID0     volatile.Register32 // 0xFF0
	COMPID1     volatile.Register32 // 0xFF4
	COMPID2     volatile.Register32 // 0xFF8
	COMPID3     volatile.Register32 // 0xFFC
}

// MTBDWT.CTRL: MTB DWT Control Register
func (o *MTBDWT_Type) SetCTRL_DWTCFGCTRL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff)|value)
}
func (o *MTBDWT_Type) GetCTRL_DWTCFGCTRL() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff
}
func (o *MTBDWT_Type) SetCTRL_NUMCMP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *MTBDWT_Type) GetCTRL_NUMCMP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf0000000) >> 28
}

// MTBDWT.COMP0: MTB_DWT Comparator Register
func (o *MTBDWT_Type) SetCOMP0(value uint32) {
	volatile.StoreUint32(&o.COMP0.Reg, value)
}
func (o *MTBDWT_Type) GetCOMP0() uint32 {
	return volatile.LoadUint32(&o.COMP0.Reg)
}

// MTBDWT.MASK0: MTB_DWT Comparator Mask Register
func (o *MTBDWT_Type) SetMASK0_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1f)|value)
}
func (o *MTBDWT_Type) GetMASK0_MASK() uint32 {
	return volatile.LoadUint32(&o.MASK0.Reg) & 0x1f
}

// MTBDWT.FCT0: MTB_DWT Comparator Function Register 0
func (o *MTBDWT_Type) SetFCT0_FUNCTION(value uint32) {
	volatile.StoreUint32(&o.FCT0.Reg, volatile.LoadUint32(&o.FCT0.Reg)&^(0xf)|value)
}
func (o *MTBDWT_Type) GetFCT0_FUNCTION() uint32 {
	return volatile.LoadUint32(&o.FCT0.Reg) & 0xf
}
func (o *MTBDWT_Type) SetFCT0_DATAVMATCH(value uint32) {
	volatile.StoreUint32(&o.FCT0.Reg, volatile.LoadUint32(&o.FCT0.Reg)&^(0x100)|value<<8)
}
func (o *MTBDWT_Type) GetFCT0_DATAVMATCH() uint32 {
	return (volatile.LoadUint32(&o.FCT0.Reg) & 0x100) >> 8
}
func (o *MTBDWT_Type) SetFCT0_DATAVSIZE(value uint32) {
	volatile.StoreUint32(&o.FCT0.Reg, volatile.LoadUint32(&o.FCT0.Reg)&^(0xc00)|value<<10)
}
func (o *MTBDWT_Type) GetFCT0_DATAVSIZE() uint32 {
	return (volatile.LoadUint32(&o.FCT0.Reg) & 0xc00) >> 10
}
func (o *MTBDWT_Type) SetFCT0_DATAVADDR0(value uint32) {
	volatile.StoreUint32(&o.FCT0.Reg, volatile.LoadUint32(&o.FCT0.Reg)&^(0xf000)|value<<12)
}
func (o *MTBDWT_Type) GetFCT0_DATAVADDR0() uint32 {
	return (volatile.LoadUint32(&o.FCT0.Reg) & 0xf000) >> 12
}
func (o *MTBDWT_Type) SetFCT0_MATCHED(value uint32) {
	volatile.StoreUint32(&o.FCT0.Reg, volatile.LoadUint32(&o.FCT0.Reg)&^(0x1000000)|value<<24)
}
func (o *MTBDWT_Type) GetFCT0_MATCHED() uint32 {
	return (volatile.LoadUint32(&o.FCT0.Reg) & 0x1000000) >> 24
}

// MTBDWT.COMP1: MTB_DWT Comparator Register
func (o *MTBDWT_Type) SetCOMP1(value uint32) {
	volatile.StoreUint32(&o.COMP1.Reg, value)
}
func (o *MTBDWT_Type) GetCOMP1() uint32 {
	return volatile.LoadUint32(&o.COMP1.Reg)
}

// MTBDWT.MASK1: MTB_DWT Comparator Mask Register
func (o *MTBDWT_Type) SetMASK1_MASK(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1f)|value)
}
func (o *MTBDWT_Type) GetMASK1_MASK() uint32 {
	return volatile.LoadUint32(&o.MASK1.Reg) & 0x1f
}

// MTBDWT.FCT1: MTB_DWT Comparator Function Register 1
func (o *MTBDWT_Type) SetFCT1_FUNCTION(value uint32) {
	volatile.StoreUint32(&o.FCT1.Reg, volatile.LoadUint32(&o.FCT1.Reg)&^(0xf)|value)
}
func (o *MTBDWT_Type) GetFCT1_FUNCTION() uint32 {
	return volatile.LoadUint32(&o.FCT1.Reg) & 0xf
}
func (o *MTBDWT_Type) SetFCT1_MATCHED(value uint32) {
	volatile.StoreUint32(&o.FCT1.Reg, volatile.LoadUint32(&o.FCT1.Reg)&^(0x1000000)|value<<24)
}
func (o *MTBDWT_Type) GetFCT1_MATCHED() uint32 {
	return (volatile.LoadUint32(&o.FCT1.Reg) & 0x1000000) >> 24
}

// MTBDWT.TBCTRL: MTB_DWT Trace Buffer Control Register
func (o *MTBDWT_Type) SetTBCTRL_ACOMP0(value uint32) {
	volatile.StoreUint32(&o.TBCTRL.Reg, volatile.LoadUint32(&o.TBCTRL.Reg)&^(0x1)|value)
}
func (o *MTBDWT_Type) GetTBCTRL_ACOMP0() uint32 {
	return volatile.LoadUint32(&o.TBCTRL.Reg) & 0x1
}
func (o *MTBDWT_Type) SetTBCTRL_ACOMP1(value uint32) {
	volatile.StoreUint32(&o.TBCTRL.Reg, volatile.LoadUint32(&o.TBCTRL.Reg)&^(0x2)|value<<1)
}
func (o *MTBDWT_Type) GetTBCTRL_ACOMP1() uint32 {
	return (volatile.LoadUint32(&o.TBCTRL.Reg) & 0x2) >> 1
}
func (o *MTBDWT_Type) SetTBCTRL_NUMCOMP(value uint32) {
	volatile.StoreUint32(&o.TBCTRL.Reg, volatile.LoadUint32(&o.TBCTRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *MTBDWT_Type) GetTBCTRL_NUMCOMP() uint32 {
	return (volatile.LoadUint32(&o.TBCTRL.Reg) & 0xf0000000) >> 28
}

// MTBDWT.DEVICECFG: Device Configuration Register
func (o *MTBDWT_Type) SetDEVICECFG(value uint32) {
	volatile.StoreUint32(&o.DEVICECFG.Reg, value)
}
func (o *MTBDWT_Type) GetDEVICECFG() uint32 {
	return volatile.LoadUint32(&o.DEVICECFG.Reg)
}

// MTBDWT.DEVICETYPID: Device Type Identifier Register
func (o *MTBDWT_Type) SetDEVICETYPID(value uint32) {
	volatile.StoreUint32(&o.DEVICETYPID.Reg, value)
}
func (o *MTBDWT_Type) GetDEVICETYPID() uint32 {
	return volatile.LoadUint32(&o.DEVICETYPID.Reg)
}

// MTBDWT.PERIPHID4: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID4(value uint32) {
	volatile.StoreUint32(&o.PERIPHID4.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID4() uint32 {
	return volatile.LoadUint32(&o.PERIPHID4.Reg)
}

// MTBDWT.PERIPHID5: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID5(value uint32) {
	volatile.StoreUint32(&o.PERIPHID5.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID5() uint32 {
	return volatile.LoadUint32(&o.PERIPHID5.Reg)
}

// MTBDWT.PERIPHID6: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID6(value uint32) {
	volatile.StoreUint32(&o.PERIPHID6.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID6() uint32 {
	return volatile.LoadUint32(&o.PERIPHID6.Reg)
}

// MTBDWT.PERIPHID7: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID7(value uint32) {
	volatile.StoreUint32(&o.PERIPHID7.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID7() uint32 {
	return volatile.LoadUint32(&o.PERIPHID7.Reg)
}

// MTBDWT.PERIPHID0: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID0(value uint32) {
	volatile.StoreUint32(&o.PERIPHID0.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID0() uint32 {
	return volatile.LoadUint32(&o.PERIPHID0.Reg)
}

// MTBDWT.PERIPHID1: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID1(value uint32) {
	volatile.StoreUint32(&o.PERIPHID1.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID1() uint32 {
	return volatile.LoadUint32(&o.PERIPHID1.Reg)
}

// MTBDWT.PERIPHID2: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID2(value uint32) {
	volatile.StoreUint32(&o.PERIPHID2.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID2() uint32 {
	return volatile.LoadUint32(&o.PERIPHID2.Reg)
}

// MTBDWT.PERIPHID3: Peripheral ID Register
func (o *MTBDWT_Type) SetPERIPHID3(value uint32) {
	volatile.StoreUint32(&o.PERIPHID3.Reg, value)
}
func (o *MTBDWT_Type) GetPERIPHID3() uint32 {
	return volatile.LoadUint32(&o.PERIPHID3.Reg)
}

// MTBDWT.COMPID0: Component ID Register
func (o *MTBDWT_Type) SetCOMPID0(value uint32) {
	volatile.StoreUint32(&o.COMPID0.Reg, value)
}
func (o *MTBDWT_Type) GetCOMPID0() uint32 {
	return volatile.LoadUint32(&o.COMPID0.Reg)
}

// MTBDWT.COMPID1: Component ID Register
func (o *MTBDWT_Type) SetCOMPID1(value uint32) {
	volatile.StoreUint32(&o.COMPID1.Reg, value)
}
func (o *MTBDWT_Type) GetCOMPID1() uint32 {
	return volatile.LoadUint32(&o.COMPID1.Reg)
}

// MTBDWT.COMPID2: Component ID Register
func (o *MTBDWT_Type) SetCOMPID2(value uint32) {
	volatile.StoreUint32(&o.COMPID2.Reg, value)
}
func (o *MTBDWT_Type) GetCOMPID2() uint32 {
	return volatile.LoadUint32(&o.COMPID2.Reg)
}

// MTBDWT.COMPID3: Component ID Register
func (o *MTBDWT_Type) SetCOMPID3(value uint32) {
	volatile.StoreUint32(&o.COMPID3.Reg, value)
}
func (o *MTBDWT_Type) GetCOMPID3() uint32 {
	return volatile.LoadUint32(&o.COMPID3.Reg)
}

// System ROM
type ROM_Type struct {
	ENTRY0    volatile.Register32 // 0x0
	ENTRY1    volatile.Register32 // 0x4
	ENTRY2    volatile.Register32 // 0x8
	TABLEMARK volatile.Register32 // 0xC
	_         [4028]byte
	SYSACCESS volatile.Register32 // 0xFCC
	PERIPHID4 volatile.Register32 // 0xFD0
	PERIPHID5 volatile.Register32 // 0xFD4
	PERIPHID6 volatile.Register32 // 0xFD8
	PERIPHID7 volatile.Register32 // 0xFDC
	PERIPHID0 volatile.Register32 // 0xFE0
	PERIPHID1 volatile.Register32 // 0xFE4
	PERIPHID2 volatile.Register32 // 0xFE8
	PERIPHID3 volatile.Register32 // 0xFEC
	COMPID0   volatile.Register32 // 0xFF0
	COMPID1   volatile.Register32 // 0xFF4
	COMPID2   volatile.Register32 // 0xFF8
	COMPID3   volatile.Register32 // 0xFFC
}

// ROM.ENTRY0: Entry
func (o *ROM_Type) SetENTRY0(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, value)
}
func (o *ROM_Type) GetENTRY0() uint32 {
	return volatile.LoadUint32(&o.ENTRY0.Reg)
}

// ROM.ENTRY1: Entry
func (o *ROM_Type) SetENTRY1(value uint32) {
	volatile.StoreUint32(&o.ENTRY1.Reg, value)
}
func (o *ROM_Type) GetENTRY1() uint32 {
	return volatile.LoadUint32(&o.ENTRY1.Reg)
}

// ROM.ENTRY2: Entry
func (o *ROM_Type) SetENTRY2(value uint32) {
	volatile.StoreUint32(&o.ENTRY2.Reg, value)
}
func (o *ROM_Type) GetENTRY2() uint32 {
	return volatile.LoadUint32(&o.ENTRY2.Reg)
}

// ROM.TABLEMARK: End of Table Marker Register
func (o *ROM_Type) SetTABLEMARK(value uint32) {
	volatile.StoreUint32(&o.TABLEMARK.Reg, value)
}
func (o *ROM_Type) GetTABLEMARK() uint32 {
	return volatile.LoadUint32(&o.TABLEMARK.Reg)
}

// ROM.SYSACCESS: System Access Register
func (o *ROM_Type) SetSYSACCESS(value uint32) {
	volatile.StoreUint32(&o.SYSACCESS.Reg, value)
}
func (o *ROM_Type) GetSYSACCESS() uint32 {
	return volatile.LoadUint32(&o.SYSACCESS.Reg)
}

// ROM.PERIPHID4: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID4(value uint32) {
	volatile.StoreUint32(&o.PERIPHID4.Reg, value)
}
func (o *ROM_Type) GetPERIPHID4() uint32 {
	return volatile.LoadUint32(&o.PERIPHID4.Reg)
}

// ROM.PERIPHID5: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID5(value uint32) {
	volatile.StoreUint32(&o.PERIPHID5.Reg, value)
}
func (o *ROM_Type) GetPERIPHID5() uint32 {
	return volatile.LoadUint32(&o.PERIPHID5.Reg)
}

// ROM.PERIPHID6: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID6(value uint32) {
	volatile.StoreUint32(&o.PERIPHID6.Reg, value)
}
func (o *ROM_Type) GetPERIPHID6() uint32 {
	return volatile.LoadUint32(&o.PERIPHID6.Reg)
}

// ROM.PERIPHID7: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID7(value uint32) {
	volatile.StoreUint32(&o.PERIPHID7.Reg, value)
}
func (o *ROM_Type) GetPERIPHID7() uint32 {
	return volatile.LoadUint32(&o.PERIPHID7.Reg)
}

// ROM.PERIPHID0: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID0(value uint32) {
	volatile.StoreUint32(&o.PERIPHID0.Reg, value)
}
func (o *ROM_Type) GetPERIPHID0() uint32 {
	return volatile.LoadUint32(&o.PERIPHID0.Reg)
}

// ROM.PERIPHID1: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID1(value uint32) {
	volatile.StoreUint32(&o.PERIPHID1.Reg, value)
}
func (o *ROM_Type) GetPERIPHID1() uint32 {
	return volatile.LoadUint32(&o.PERIPHID1.Reg)
}

// ROM.PERIPHID2: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID2(value uint32) {
	volatile.StoreUint32(&o.PERIPHID2.Reg, value)
}
func (o *ROM_Type) GetPERIPHID2() uint32 {
	return volatile.LoadUint32(&o.PERIPHID2.Reg)
}

// ROM.PERIPHID3: Peripheral ID Register
func (o *ROM_Type) SetPERIPHID3(value uint32) {
	volatile.StoreUint32(&o.PERIPHID3.Reg, value)
}
func (o *ROM_Type) GetPERIPHID3() uint32 {
	return volatile.LoadUint32(&o.PERIPHID3.Reg)
}

// ROM.COMPID0: Component ID Register
func (o *ROM_Type) SetCOMPID0(value uint32) {
	volatile.StoreUint32(&o.COMPID0.Reg, value)
}
func (o *ROM_Type) GetCOMPID0() uint32 {
	return volatile.LoadUint32(&o.COMPID0.Reg)
}

// ROM.COMPID1: Component ID Register
func (o *ROM_Type) SetCOMPID1(value uint32) {
	volatile.StoreUint32(&o.COMPID1.Reg, value)
}
func (o *ROM_Type) GetCOMPID1() uint32 {
	return volatile.LoadUint32(&o.COMPID1.Reg)
}

// ROM.COMPID2: Component ID Register
func (o *ROM_Type) SetCOMPID2(value uint32) {
	volatile.StoreUint32(&o.COMPID2.Reg, value)
}
func (o *ROM_Type) GetCOMPID2() uint32 {
	return volatile.LoadUint32(&o.COMPID2.Reg)
}

// ROM.COMPID3: Component ID Register
func (o *ROM_Type) SetCOMPID3(value uint32) {
	volatile.StoreUint32(&o.COMPID3.Reg, value)
}
func (o *ROM_Type) GetCOMPID3() uint32 {
	return volatile.LoadUint32(&o.COMPID3.Reg)
}

// Core Platform Miscellaneous Control Module
type MCM_Type struct {
	_     [8]byte
	PLASC volatile.Register16 // 0x8
	PLAMC volatile.Register16 // 0xA
	PLACR volatile.Register32 // 0xC
	_     [48]byte
	CPO   volatile.Register32 // 0x40
}

// MCM.PLASC: Crossbar Switch (AXBS) Slave Configuration
func (o *MCM_Type) SetPLASC_ASC(value uint16) {
	volatile.StoreUint16(&o.PLASC.Reg, volatile.LoadUint16(&o.PLASC.Reg)&^(0xff)|value)
}
func (o *MCM_Type) GetPLASC_ASC() uint16 {
	return volatile.LoadUint16(&o.PLASC.Reg) & 0xff
}

// MCM.PLAMC: Crossbar Switch (AXBS) Master Configuration
func (o *MCM_Type) SetPLAMC_AMC(value uint16) {
	volatile.StoreUint16(&o.PLAMC.Reg, volatile.LoadUint16(&o.PLAMC.Reg)&^(0xff)|value)
}
func (o *MCM_Type) GetPLAMC_AMC() uint16 {
	return volatile.LoadUint16(&o.PLAMC.Reg) & 0xff
}

// MCM.PLACR: Platform Control Register
func (o *MCM_Type) SetPLACR_ARB(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x200)|value<<9)
}
func (o *MCM_Type) GetPLACR_ARB() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x200) >> 9
}
func (o *MCM_Type) SetPLACR_CFCC(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x400)|value<<10)
}
func (o *MCM_Type) GetPLACR_CFCC() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x400) >> 10
}
func (o *MCM_Type) SetPLACR_DFCDA(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x800)|value<<11)
}
func (o *MCM_Type) GetPLACR_DFCDA() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x800) >> 11
}
func (o *MCM_Type) SetPLACR_DFCIC(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x1000)|value<<12)
}
func (o *MCM_Type) GetPLACR_DFCIC() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x1000) >> 12
}
func (o *MCM_Type) SetPLACR_DFCC(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x2000)|value<<13)
}
func (o *MCM_Type) GetPLACR_DFCC() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x2000) >> 13
}
func (o *MCM_Type) SetPLACR_EFDS(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x4000)|value<<14)
}
func (o *MCM_Type) GetPLACR_EFDS() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x4000) >> 14
}
func (o *MCM_Type) SetPLACR_DFCS(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x8000)|value<<15)
}
func (o *MCM_Type) GetPLACR_DFCS() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x8000) >> 15
}
func (o *MCM_Type) SetPLACR_ESFC(value uint32) {
	volatile.StoreUint32(&o.PLACR.Reg, volatile.LoadUint32(&o.PLACR.Reg)&^(0x10000)|value<<16)
}
func (o *MCM_Type) GetPLACR_ESFC() uint32 {
	return (volatile.LoadUint32(&o.PLACR.Reg) & 0x10000) >> 16
}

// MCM.CPO: Compute Operation Control Register
func (o *MCM_Type) SetCPO_CPOREQ(value uint32) {
	volatile.StoreUint32(&o.CPO.Reg, volatile.LoadUint32(&o.CPO.Reg)&^(0x1)|value)
}
func (o *MCM_Type) GetCPO_CPOREQ() uint32 {
	return volatile.LoadUint32(&o.CPO.Reg) & 0x1
}
func (o *MCM_Type) SetCPO_CPOACK(value uint32) {
	volatile.StoreUint32(&o.CPO.Reg, volatile.LoadUint32(&o.CPO.Reg)&^(0x2)|value<<1)
}
func (o *MCM_Type) GetCPO_CPOACK() uint32 {
	return (volatile.LoadUint32(&o.CPO.Reg) & 0x2) >> 1
}
func (o *MCM_Type) SetCPO_CPOWOI(value uint32) {
	volatile.StoreUint32(&o.CPO.Reg, volatile.LoadUint32(&o.CPO.Reg)&^(0x4)|value<<2)
}
func (o *MCM_Type) GetCPO_CPOWOI() uint32 {
	return (volatile.LoadUint32(&o.CPO.Reg) & 0x4) >> 2
}

// General Purpose Input/Output
type FGPIO_Type struct {
	PDOR volatile.Register32 // 0x0
	PSOR volatile.Register32 // 0x4
	PCOR volatile.Register32 // 0x8
	PTOR volatile.Register32 // 0xC
	PDIR volatile.Register32 // 0x10
	PDDR volatile.Register32 // 0x14
}

// FGPIO.PDOR: Port Data Output Register
func (o *FGPIO_Type) SetPDOR(value uint32) {
	volatile.StoreUint32(&o.PDOR.Reg, value)
}
func (o *FGPIO_Type) GetPDOR() uint32 {
	return volatile.LoadUint32(&o.PDOR.Reg)
}

// FGPIO.PSOR: Port Set Output Register
func (o *FGPIO_Type) SetPSOR(value uint32) {
	volatile.StoreUint32(&o.PSOR.Reg, value)
}
func (o *FGPIO_Type) GetPSOR() uint32 {
	return volatile.LoadUint32(&o.PSOR.Reg)
}

// FGPIO.PCOR: Port Clear Output Register
func (o *FGPIO_Type) SetPCOR(value uint32) {
	volatile.StoreUint32(&o.PCOR.Reg, value)
}
func (o *FGPIO_Type) GetPCOR() uint32 {
	return volatile.LoadUint32(&o.PCOR.Reg)
}

// FGPIO.PTOR: Port Toggle Output Register
func (o *FGPIO_Type) SetPTOR(value uint32) {
	volatile.StoreUint32(&o.PTOR.Reg, value)
}
func (o *FGPIO_Type) GetPTOR() uint32 {
	return volatile.LoadUint32(&o.PTOR.Reg)
}

// FGPIO.PDIR: Port Data Input Register
func (o *FGPIO_Type) SetPDIR(value uint32) {
	volatile.StoreUint32(&o.PDIR.Reg, value)
}
func (o *FGPIO_Type) GetPDIR() uint32 {
	return volatile.LoadUint32(&o.PDIR.Reg)
}

// FGPIO.PDDR: Port Data Direction Register
func (o *FGPIO_Type) SetPDDR(value uint32) {
	volatile.StoreUint32(&o.PDDR.Reg, value)
}
func (o *FGPIO_Type) GetPDDR() uint32 {
	return volatile.LoadUint32(&o.PDDR.Reg)
}

// Constants for FTFA_FlashConfig: Flash configuration field
const (
	// BACKKEY3: Backdoor Comparison Key 3.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY3_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY3_KEY_Msk = 0xff

	// BACKKEY2: Backdoor Comparison Key 2.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY2_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY2_KEY_Msk = 0xff

	// BACKKEY1: Backdoor Comparison Key 1.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY1_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY1_KEY_Msk = 0xff

	// BACKKEY0: Backdoor Comparison Key 0.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY0_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY0_KEY_Msk = 0xff

	// BACKKEY7: Backdoor Comparison Key 7.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY7_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY7_KEY_Msk = 0xff

	// BACKKEY6: Backdoor Comparison Key 6.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY6_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY6_KEY_Msk = 0xff

	// BACKKEY5: Backdoor Comparison Key 5.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY5_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY5_KEY_Msk = 0xff

	// BACKKEY4: Backdoor Comparison Key 4.
	// Position of KEY field.
	FTFA_FlashConfig_BACKKEY4_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FTFA_FlashConfig_BACKKEY4_KEY_Msk = 0xff

	// FPROT3: Non-volatile P-Flash Protection 1 - Low Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT3_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT3_PROT_Msk = 0xff

	// FPROT2: Non-volatile P-Flash Protection 1 - High Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT2_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT2_PROT_Msk = 0xff

	// FPROT1: Non-volatile P-Flash Protection 0 - Low Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT1_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT1_PROT_Msk = 0xff

	// FPROT0: Non-volatile P-Flash Protection 0 - High Register
	// Position of PROT field.
	FTFA_FlashConfig_FPROT0_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FlashConfig_FPROT0_PROT_Msk = 0xff

	// FSEC: Non-volatile Flash Security Register
	// Position of SEC field.
	FTFA_FlashConfig_FSEC_SEC_Pos = 0x0
	// Bit mask of SEC field.
	FTFA_FlashConfig_FSEC_SEC_Msk = 0x3
	// MCU security status is unsecure
	FTFA_FlashConfig_FSEC_SEC_10 = 0x2
	// MCU security status is secure
	FTFA_FlashConfig_FSEC_SEC_11 = 0x3
	// Position of FSLACC field.
	FTFA_FlashConfig_FSEC_FSLACC_Pos = 0x2
	// Bit mask of FSLACC field.
	FTFA_FlashConfig_FSEC_FSLACC_Msk = 0xc
	// Freescale factory access denied
	FTFA_FlashConfig_FSEC_FSLACC_10 = 0x2
	// Freescale factory access granted
	FTFA_FlashConfig_FSEC_FSLACC_11 = 0x3
	// Position of MEEN field.
	FTFA_FlashConfig_FSEC_MEEN_Pos = 0x4
	// Bit mask of MEEN field.
	FTFA_FlashConfig_FSEC_MEEN_Msk = 0x30
	// Mass erase is disabled
	FTFA_FlashConfig_FSEC_MEEN_10 = 0x2
	// Mass erase is enabled
	FTFA_FlashConfig_FSEC_MEEN_11 = 0x3
	// Position of KEYEN field.
	FTFA_FlashConfig_FSEC_KEYEN_Pos = 0x6
	// Bit mask of KEYEN field.
	FTFA_FlashConfig_FSEC_KEYEN_Msk = 0xc0
	// Backdoor key access enabled
	FTFA_FlashConfig_FSEC_KEYEN_10 = 0x2
	// Backdoor key access disabled
	FTFA_FlashConfig_FSEC_KEYEN_11 = 0x3

	// FOPT: Non-volatile Flash Option Register
	// Position of LPBOOT0 field.
	FTFA_FlashConfig_FOPT_LPBOOT0_Pos = 0x0
	// Bit mask of LPBOOT0 field.
	FTFA_FlashConfig_FOPT_LPBOOT0_Msk = 0x1
	// Bit LPBOOT0.
	FTFA_FlashConfig_FOPT_LPBOOT0 = 0x1
	// Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when LPBOOT1=0 or 0x1 (divide by 2) when LPBOOT1=1.
	FTFA_FlashConfig_FOPT_LPBOOT0_00 = 0x0
	// Core and system clock divider (OUTDIV1) is 0x3 (divide by 4) when LPBOOT1=0 or 0x0 (divide by 1) when LPBOOT1=1.
	FTFA_FlashConfig_FOPT_LPBOOT0_01 = 0x1
	// Position of NMI_DIS field.
	FTFA_FlashConfig_FOPT_NMI_DIS_Pos = 0x2
	// Bit mask of NMI_DIS field.
	FTFA_FlashConfig_FOPT_NMI_DIS_Msk = 0x4
	// Bit NMI_DIS.
	FTFA_FlashConfig_FOPT_NMI_DIS = 0x4
	// NMI interrupts are always blocked
	FTFA_FlashConfig_FOPT_NMI_DIS_00 = 0x0
	// NMI_b pin/interrupts reset default to enabled
	FTFA_FlashConfig_FOPT_NMI_DIS_01 = 0x1
	// Position of RESET_PIN_CFG field.
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_Pos = 0x3
	// Bit mask of RESET_PIN_CFG field.
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_Msk = 0x8
	// Bit RESET_PIN_CFG.
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG = 0x8
	// RESET pin is disabled following a POR and cannot be enabled as reset function
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_00 = 0x0
	// RESET_b pin is dedicated
	FTFA_FlashConfig_FOPT_RESET_PIN_CFG_01 = 0x1
	// Position of LPBOOT1 field.
	FTFA_FlashConfig_FOPT_LPBOOT1_Pos = 0x4
	// Bit mask of LPBOOT1 field.
	FTFA_FlashConfig_FOPT_LPBOOT1_Msk = 0x10
	// Bit LPBOOT1.
	FTFA_FlashConfig_FOPT_LPBOOT1 = 0x10
	// Core and system clock divider (OUTDIV1) is 0x7 (divide by 8) when LPBOOT0=0 or 0x3 (divide by 4) when LPBOOT0=1.
	FTFA_FlashConfig_FOPT_LPBOOT1_00 = 0x0
	// Core and system clock divider (OUTDIV1) is 0x1 (divide by 2) when LPBOOT0=0 or 0x0 (divide by 1) when LPBOOT0=1.
	FTFA_FlashConfig_FOPT_LPBOOT1_01 = 0x1
	// Position of FAST_INIT field.
	FTFA_FlashConfig_FOPT_FAST_INIT_Pos = 0x5
	// Bit mask of FAST_INIT field.
	FTFA_FlashConfig_FOPT_FAST_INIT_Msk = 0x20
	// Bit FAST_INIT.
	FTFA_FlashConfig_FOPT_FAST_INIT = 0x20
	// Slower initialization
	FTFA_FlashConfig_FOPT_FAST_INIT_00 = 0x0
	// Fast Initialization
	FTFA_FlashConfig_FOPT_FAST_INIT_01 = 0x1
)

// Constants for DMA: DMA Controller
const (
	// SAR0: Source Address Register
	// Position of SAR field.
	DMA_SAR0_SAR_Pos = 0x0
	// Bit mask of SAR field.
	DMA_SAR0_SAR_Msk = 0xffffffff

	// DAR0: Destination Address Register
	// Position of DAR field.
	DMA_DAR0_DAR_Pos = 0x0
	// Bit mask of DAR field.
	DMA_DAR0_DAR_Msk = 0xffffffff

	// DSR_BCR0: DMA Status Register / Byte Count Register
	// Position of BCR field.
	DMA_DSR_BCR0_BCR_Pos = 0x0
	// Bit mask of BCR field.
	DMA_DSR_BCR0_BCR_Msk = 0xffffff
	// Position of DONE field.
	DMA_DSR_BCR0_DONE_Pos = 0x18
	// Bit mask of DONE field.
	DMA_DSR_BCR0_DONE_Msk = 0x1000000
	// Bit DONE.
	DMA_DSR_BCR0_DONE = 0x1000000
	// DMA transfer is not yet complete. Writing a 0 has no effect.
	DMA_DSR_BCR0_DONE_0 = 0x0
	// DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.
	DMA_DSR_BCR0_DONE_1 = 0x1
	// Position of BSY field.
	DMA_DSR_BCR0_BSY_Pos = 0x19
	// Bit mask of BSY field.
	DMA_DSR_BCR0_BSY_Msk = 0x2000000
	// Bit BSY.
	DMA_DSR_BCR0_BSY = 0x2000000
	// DMA channel is inactive. Cleared when the DMA has finished the last transaction.
	DMA_DSR_BCR0_BSY_0 = 0x0
	// BSY is set the first time the channel is enabled after a transfer is initiated.
	DMA_DSR_BCR0_BSY_1 = 0x1
	// Position of REQ field.
	DMA_DSR_BCR0_REQ_Pos = 0x1a
	// Bit mask of REQ field.
	DMA_DSR_BCR0_REQ_Msk = 0x4000000
	// Bit REQ.
	DMA_DSR_BCR0_REQ = 0x4000000
	// No request is pending or the channel is currently active. Cleared when the channel is selected.
	DMA_DSR_BCR0_REQ_0 = 0x0
	// The DMA channel has a transfer remaining and the channel is not selected.
	DMA_DSR_BCR0_REQ_1 = 0x1
	// Position of BED field.
	DMA_DSR_BCR0_BED_Pos = 0x1c
	// Bit mask of BED field.
	DMA_DSR_BCR0_BED_Msk = 0x10000000
	// Bit BED.
	DMA_DSR_BCR0_BED = 0x10000000
	// No bus error occurred.
	DMA_DSR_BCR0_BED_0 = 0x0
	// The DMA channel terminated with a bus error during the write portion of a transfer.
	DMA_DSR_BCR0_BED_1 = 0x1
	// Position of BES field.
	DMA_DSR_BCR0_BES_Pos = 0x1d
	// Bit mask of BES field.
	DMA_DSR_BCR0_BES_Msk = 0x20000000
	// Bit BES.
	DMA_DSR_BCR0_BES = 0x20000000
	// No bus error occurred.
	DMA_DSR_BCR0_BES_0 = 0x0
	// The DMA channel terminated with a bus error during the read portion of a transfer.
	DMA_DSR_BCR0_BES_1 = 0x1
	// Position of CE field.
	DMA_DSR_BCR0_CE_Pos = 0x1e
	// Bit mask of CE field.
	DMA_DSR_BCR0_CE_Msk = 0x40000000
	// Bit CE.
	DMA_DSR_BCR0_CE = 0x40000000
	// No configuration error exists.
	DMA_DSR_BCR0_CE_0 = 0x0
	// A configuration error has occurred.
	DMA_DSR_BCR0_CE_1 = 0x1

	// DCR0: DMA Control Register
	// Position of LCH2 field.
	DMA_DCR0_LCH2_Pos = 0x0
	// Bit mask of LCH2 field.
	DMA_DCR0_LCH2_Msk = 0x3
	// DMA Channel 0
	DMA_DCR0_LCH2_00 = 0x0
	// DMA Channel 1
	DMA_DCR0_LCH2_01 = 0x1
	// DMA Channel 2
	DMA_DCR0_LCH2_10 = 0x2
	// DMA Channel 3
	DMA_DCR0_LCH2_11 = 0x3
	// Position of LCH1 field.
	DMA_DCR0_LCH1_Pos = 0x2
	// Bit mask of LCH1 field.
	DMA_DCR0_LCH1_Msk = 0xc
	// DMA Channel 0
	DMA_DCR0_LCH1_00 = 0x0
	// DMA Channel 1
	DMA_DCR0_LCH1_01 = 0x1
	// DMA Channel 2
	DMA_DCR0_LCH1_10 = 0x2
	// DMA Channel 3
	DMA_DCR0_LCH1_11 = 0x3
	// Position of LINKCC field.
	DMA_DCR0_LINKCC_Pos = 0x4
	// Bit mask of LINKCC field.
	DMA_DCR0_LINKCC_Msk = 0x30
	// No channel-to-channel linking
	DMA_DCR0_LINKCC_00 = 0x0
	// Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to 0.
	DMA_DCR0_LINKCC_01 = 0x1
	// Perform a link to channel LCH1 after each cycle-steal transfer
	DMA_DCR0_LINKCC_10 = 0x2
	// Perform a link to channel LCH1 after the BCR decrements to 0.
	DMA_DCR0_LINKCC_11 = 0x3
	// Position of D_REQ field.
	DMA_DCR0_D_REQ_Pos = 0x7
	// Bit mask of D_REQ field.
	DMA_DCR0_D_REQ_Msk = 0x80
	// Bit D_REQ.
	DMA_DCR0_D_REQ = 0x80
	// ERQ bit is not affected.
	DMA_DCR0_D_REQ_0 = 0x0
	// ERQ bit is cleared when the BCR is exhausted.
	DMA_DCR0_D_REQ_1 = 0x1
	// Position of DMOD field.
	DMA_DCR0_DMOD_Pos = 0x8
	// Bit mask of DMOD field.
	DMA_DCR0_DMOD_Msk = 0xf00
	// Buffer disabled
	DMA_DCR0_DMOD_0000 = 0x0
	// Circular buffer size is 16 bytes
	DMA_DCR0_DMOD_0001 = 0x1
	// Circular buffer size is 32 bytes
	DMA_DCR0_DMOD_0010 = 0x2
	// Circular buffer size is 64 bytes
	DMA_DCR0_DMOD_0011 = 0x3
	// Circular buffer size is 128 bytes
	DMA_DCR0_DMOD_0100 = 0x4
	// Circular buffer size is 256 bytes
	DMA_DCR0_DMOD_0101 = 0x5
	// Circular buffer size is 512 bytes
	DMA_DCR0_DMOD_0110 = 0x6
	// Circular buffer size is 1 KB
	DMA_DCR0_DMOD_0111 = 0x7
	// Circular buffer size is 2 KB
	DMA_DCR0_DMOD_1000 = 0x8
	// Circular buffer size is 4 KB
	DMA_DCR0_DMOD_1001 = 0x9
	// Circular buffer size is 8 KB
	DMA_DCR0_DMOD_1010 = 0xa
	// Circular buffer size is 16 KB
	DMA_DCR0_DMOD_1011 = 0xb
	// Circular buffer size is 32 KB
	DMA_DCR0_DMOD_1100 = 0xc
	// Circular buffer size is 64 KB
	DMA_DCR0_DMOD_1101 = 0xd
	// Circular buffer size is 128 KB
	DMA_DCR0_DMOD_1110 = 0xe
	// Circular buffer size is 256 KB
	DMA_DCR0_DMOD_1111 = 0xf
	// Position of SMOD field.
	DMA_DCR0_SMOD_Pos = 0xc
	// Bit mask of SMOD field.
	DMA_DCR0_SMOD_Msk = 0xf000
	// Buffer disabled
	DMA_DCR0_SMOD_0000 = 0x0
	// Circular buffer size is 16 bytes.
	DMA_DCR0_SMOD_0001 = 0x1
	// Circular buffer size is 32 bytes.
	DMA_DCR0_SMOD_0010 = 0x2
	// Circular buffer size is 64 bytes.
	DMA_DCR0_SMOD_0011 = 0x3
	// Circular buffer size is 128 bytes.
	DMA_DCR0_SMOD_0100 = 0x4
	// Circular buffer size is 256 bytes.
	DMA_DCR0_SMOD_0101 = 0x5
	// Circular buffer size is 512 bytes.
	DMA_DCR0_SMOD_0110 = 0x6
	// Circular buffer size is 1 KB.
	DMA_DCR0_SMOD_0111 = 0x7
	// Circular buffer size is 2 KB.
	DMA_DCR0_SMOD_1000 = 0x8
	// Circular buffer size is 4 KB.
	DMA_DCR0_SMOD_1001 = 0x9
	// Circular buffer size is 8 KB.
	DMA_DCR0_SMOD_1010 = 0xa
	// Circular buffer size is 16 KB.
	DMA_DCR0_SMOD_1011 = 0xb
	// Circular buffer size is 32 KB.
	DMA_DCR0_SMOD_1100 = 0xc
	// Circular buffer size is 64 KB.
	DMA_DCR0_SMOD_1101 = 0xd
	// Circular buffer size is 128 KB.
	DMA_DCR0_SMOD_1110 = 0xe
	// Circular buffer size is 256 KB.
	DMA_DCR0_SMOD_1111 = 0xf
	// Position of START field.
	DMA_DCR0_START_Pos = 0x10
	// Bit mask of START field.
	DMA_DCR0_START_Msk = 0x10000
	// Bit START.
	DMA_DCR0_START = 0x10000
	// DMA inactive
	DMA_DCR0_START_0 = 0x0
	// The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.
	DMA_DCR0_START_1 = 0x1
	// Position of DSIZE field.
	DMA_DCR0_DSIZE_Pos = 0x11
	// Bit mask of DSIZE field.
	DMA_DCR0_DSIZE_Msk = 0x60000
	// 32-bit
	DMA_DCR0_DSIZE_00 = 0x0
	// 8-bit
	DMA_DCR0_DSIZE_01 = 0x1
	// 16-bit
	DMA_DCR0_DSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR0_DSIZE_11 = 0x3
	// Position of DINC field.
	DMA_DCR0_DINC_Pos = 0x13
	// Bit mask of DINC field.
	DMA_DCR0_DINC_Msk = 0x80000
	// Bit DINC.
	DMA_DCR0_DINC = 0x80000
	// No change to the DAR after a successful transfer.
	DMA_DCR0_DINC_0 = 0x0
	// The DAR increments by 1, 2, 4 depending upon the size of the transfer.
	DMA_DCR0_DINC_1 = 0x1
	// Position of SSIZE field.
	DMA_DCR0_SSIZE_Pos = 0x14
	// Bit mask of SSIZE field.
	DMA_DCR0_SSIZE_Msk = 0x300000
	// 32-bit
	DMA_DCR0_SSIZE_00 = 0x0
	// 8-bit
	DMA_DCR0_SSIZE_01 = 0x1
	// 16-bit
	DMA_DCR0_SSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR0_SSIZE_11 = 0x3
	// Position of SINC field.
	DMA_DCR0_SINC_Pos = 0x16
	// Bit mask of SINC field.
	DMA_DCR0_SINC_Msk = 0x400000
	// Bit SINC.
	DMA_DCR0_SINC = 0x400000
	// No change to SAR after a successful transfer.
	DMA_DCR0_SINC_0 = 0x0
	// The SAR increments by 1, 2, 4 as determined by the transfer size.
	DMA_DCR0_SINC_1 = 0x1
	// Position of EADREQ field.
	DMA_DCR0_EADREQ_Pos = 0x17
	// Bit mask of EADREQ field.
	DMA_DCR0_EADREQ_Msk = 0x800000
	// Bit EADREQ.
	DMA_DCR0_EADREQ = 0x800000
	// Disabled
	DMA_DCR0_EADREQ_0 = 0x0
	// Enabled
	DMA_DCR0_EADREQ_1 = 0x1
	// Position of AA field.
	DMA_DCR0_AA_Pos = 0x1c
	// Bit mask of AA field.
	DMA_DCR0_AA_Msk = 0x10000000
	// Bit AA.
	DMA_DCR0_AA = 0x10000000
	// Auto-align disabled
	DMA_DCR0_AA_0 = 0x0
	// If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.
	DMA_DCR0_AA_1 = 0x1
	// Position of CS field.
	DMA_DCR0_CS_Pos = 0x1d
	// Bit mask of CS field.
	DMA_DCR0_CS_Msk = 0x20000000
	// Bit CS.
	DMA_DCR0_CS = 0x20000000
	// DMA continuously makes read/write transfers until the BCR decrements to 0.
	DMA_DCR0_CS_0 = 0x0
	// Forces a single read/write transfer per request.
	DMA_DCR0_CS_1 = 0x1
	// Position of ERQ field.
	DMA_DCR0_ERQ_Pos = 0x1e
	// Bit mask of ERQ field.
	DMA_DCR0_ERQ_Msk = 0x40000000
	// Bit ERQ.
	DMA_DCR0_ERQ = 0x40000000
	// Peripheral request is ignored.
	DMA_DCR0_ERQ_0 = 0x0
	// Enables peripheral request to initiate transfer. A software-initiated request (setting START) is always enabled.
	DMA_DCR0_ERQ_1 = 0x1
	// Position of EINT field.
	DMA_DCR0_EINT_Pos = 0x1f
	// Bit mask of EINT field.
	DMA_DCR0_EINT_Msk = 0x80000000
	// Bit EINT.
	DMA_DCR0_EINT = 0x80000000
	// No interrupt is generated.
	DMA_DCR0_EINT_0 = 0x0
	// Interrupt signal is enabled.
	DMA_DCR0_EINT_1 = 0x1

	// SAR1: Source Address Register
	// Position of SAR field.
	DMA_SAR1_SAR_Pos = 0x0
	// Bit mask of SAR field.
	DMA_SAR1_SAR_Msk = 0xffffffff

	// DAR1: Destination Address Register
	// Position of DAR field.
	DMA_DAR1_DAR_Pos = 0x0
	// Bit mask of DAR field.
	DMA_DAR1_DAR_Msk = 0xffffffff

	// DSR_BCR1: DMA Status Register / Byte Count Register
	// Position of BCR field.
	DMA_DSR_BCR1_BCR_Pos = 0x0
	// Bit mask of BCR field.
	DMA_DSR_BCR1_BCR_Msk = 0xffffff
	// Position of DONE field.
	DMA_DSR_BCR1_DONE_Pos = 0x18
	// Bit mask of DONE field.
	DMA_DSR_BCR1_DONE_Msk = 0x1000000
	// Bit DONE.
	DMA_DSR_BCR1_DONE = 0x1000000
	// DMA transfer is not yet complete. Writing a 0 has no effect.
	DMA_DSR_BCR1_DONE_0 = 0x0
	// DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.
	DMA_DSR_BCR1_DONE_1 = 0x1
	// Position of BSY field.
	DMA_DSR_BCR1_BSY_Pos = 0x19
	// Bit mask of BSY field.
	DMA_DSR_BCR1_BSY_Msk = 0x2000000
	// Bit BSY.
	DMA_DSR_BCR1_BSY = 0x2000000
	// DMA channel is inactive. Cleared when the DMA has finished the last transaction.
	DMA_DSR_BCR1_BSY_0 = 0x0
	// BSY is set the first time the channel is enabled after a transfer is initiated.
	DMA_DSR_BCR1_BSY_1 = 0x1
	// Position of REQ field.
	DMA_DSR_BCR1_REQ_Pos = 0x1a
	// Bit mask of REQ field.
	DMA_DSR_BCR1_REQ_Msk = 0x4000000
	// Bit REQ.
	DMA_DSR_BCR1_REQ = 0x4000000
	// No request is pending or the channel is currently active. Cleared when the channel is selected.
	DMA_DSR_BCR1_REQ_0 = 0x0
	// The DMA channel has a transfer remaining and the channel is not selected.
	DMA_DSR_BCR1_REQ_1 = 0x1
	// Position of BED field.
	DMA_DSR_BCR1_BED_Pos = 0x1c
	// Bit mask of BED field.
	DMA_DSR_BCR1_BED_Msk = 0x10000000
	// Bit BED.
	DMA_DSR_BCR1_BED = 0x10000000
	// No bus error occurred.
	DMA_DSR_BCR1_BED_0 = 0x0
	// The DMA channel terminated with a bus error during the write portion of a transfer.
	DMA_DSR_BCR1_BED_1 = 0x1
	// Position of BES field.
	DMA_DSR_BCR1_BES_Pos = 0x1d
	// Bit mask of BES field.
	DMA_DSR_BCR1_BES_Msk = 0x20000000
	// Bit BES.
	DMA_DSR_BCR1_BES = 0x20000000
	// No bus error occurred.
	DMA_DSR_BCR1_BES_0 = 0x0
	// The DMA channel terminated with a bus error during the read portion of a transfer.
	DMA_DSR_BCR1_BES_1 = 0x1
	// Position of CE field.
	DMA_DSR_BCR1_CE_Pos = 0x1e
	// Bit mask of CE field.
	DMA_DSR_BCR1_CE_Msk = 0x40000000
	// Bit CE.
	DMA_DSR_BCR1_CE = 0x40000000
	// No configuration error exists.
	DMA_DSR_BCR1_CE_0 = 0x0
	// A configuration error has occurred.
	DMA_DSR_BCR1_CE_1 = 0x1

	// DCR1: DMA Control Register
	// Position of LCH2 field.
	DMA_DCR1_LCH2_Pos = 0x0
	// Bit mask of LCH2 field.
	DMA_DCR1_LCH2_Msk = 0x3
	// DMA Channel 0
	DMA_DCR1_LCH2_00 = 0x0
	// DMA Channel 1
	DMA_DCR1_LCH2_01 = 0x1
	// DMA Channel 2
	DMA_DCR1_LCH2_10 = 0x2
	// DMA Channel 3
	DMA_DCR1_LCH2_11 = 0x3
	// Position of LCH1 field.
	DMA_DCR1_LCH1_Pos = 0x2
	// Bit mask of LCH1 field.
	DMA_DCR1_LCH1_Msk = 0xc
	// DMA Channel 0
	DMA_DCR1_LCH1_00 = 0x0
	// DMA Channel 1
	DMA_DCR1_LCH1_01 = 0x1
	// DMA Channel 2
	DMA_DCR1_LCH1_10 = 0x2
	// DMA Channel 3
	DMA_DCR1_LCH1_11 = 0x3
	// Position of LINKCC field.
	DMA_DCR1_LINKCC_Pos = 0x4
	// Bit mask of LINKCC field.
	DMA_DCR1_LINKCC_Msk = 0x30
	// No channel-to-channel linking
	DMA_DCR1_LINKCC_00 = 0x0
	// Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to 0.
	DMA_DCR1_LINKCC_01 = 0x1
	// Perform a link to channel LCH1 after each cycle-steal transfer
	DMA_DCR1_LINKCC_10 = 0x2
	// Perform a link to channel LCH1 after the BCR decrements to 0.
	DMA_DCR1_LINKCC_11 = 0x3
	// Position of D_REQ field.
	DMA_DCR1_D_REQ_Pos = 0x7
	// Bit mask of D_REQ field.
	DMA_DCR1_D_REQ_Msk = 0x80
	// Bit D_REQ.
	DMA_DCR1_D_REQ = 0x80
	// ERQ bit is not affected.
	DMA_DCR1_D_REQ_0 = 0x0
	// ERQ bit is cleared when the BCR is exhausted.
	DMA_DCR1_D_REQ_1 = 0x1
	// Position of DMOD field.
	DMA_DCR1_DMOD_Pos = 0x8
	// Bit mask of DMOD field.
	DMA_DCR1_DMOD_Msk = 0xf00
	// Buffer disabled
	DMA_DCR1_DMOD_0000 = 0x0
	// Circular buffer size is 16 bytes
	DMA_DCR1_DMOD_0001 = 0x1
	// Circular buffer size is 32 bytes
	DMA_DCR1_DMOD_0010 = 0x2
	// Circular buffer size is 64 bytes
	DMA_DCR1_DMOD_0011 = 0x3
	// Circular buffer size is 128 bytes
	DMA_DCR1_DMOD_0100 = 0x4
	// Circular buffer size is 256 bytes
	DMA_DCR1_DMOD_0101 = 0x5
	// Circular buffer size is 512 bytes
	DMA_DCR1_DMOD_0110 = 0x6
	// Circular buffer size is 1 KB
	DMA_DCR1_DMOD_0111 = 0x7
	// Circular buffer size is 2 KB
	DMA_DCR1_DMOD_1000 = 0x8
	// Circular buffer size is 4 KB
	DMA_DCR1_DMOD_1001 = 0x9
	// Circular buffer size is 8 KB
	DMA_DCR1_DMOD_1010 = 0xa
	// Circular buffer size is 16 KB
	DMA_DCR1_DMOD_1011 = 0xb
	// Circular buffer size is 32 KB
	DMA_DCR1_DMOD_1100 = 0xc
	// Circular buffer size is 64 KB
	DMA_DCR1_DMOD_1101 = 0xd
	// Circular buffer size is 128 KB
	DMA_DCR1_DMOD_1110 = 0xe
	// Circular buffer size is 256 KB
	DMA_DCR1_DMOD_1111 = 0xf
	// Position of SMOD field.
	DMA_DCR1_SMOD_Pos = 0xc
	// Bit mask of SMOD field.
	DMA_DCR1_SMOD_Msk = 0xf000
	// Buffer disabled
	DMA_DCR1_SMOD_0000 = 0x0
	// Circular buffer size is 16 bytes.
	DMA_DCR1_SMOD_0001 = 0x1
	// Circular buffer size is 32 bytes.
	DMA_DCR1_SMOD_0010 = 0x2
	// Circular buffer size is 64 bytes.
	DMA_DCR1_SMOD_0011 = 0x3
	// Circular buffer size is 128 bytes.
	DMA_DCR1_SMOD_0100 = 0x4
	// Circular buffer size is 256 bytes.
	DMA_DCR1_SMOD_0101 = 0x5
	// Circular buffer size is 512 bytes.
	DMA_DCR1_SMOD_0110 = 0x6
	// Circular buffer size is 1 KB.
	DMA_DCR1_SMOD_0111 = 0x7
	// Circular buffer size is 2 KB.
	DMA_DCR1_SMOD_1000 = 0x8
	// Circular buffer size is 4 KB.
	DMA_DCR1_SMOD_1001 = 0x9
	// Circular buffer size is 8 KB.
	DMA_DCR1_SMOD_1010 = 0xa
	// Circular buffer size is 16 KB.
	DMA_DCR1_SMOD_1011 = 0xb
	// Circular buffer size is 32 KB.
	DMA_DCR1_SMOD_1100 = 0xc
	// Circular buffer size is 64 KB.
	DMA_DCR1_SMOD_1101 = 0xd
	// Circular buffer size is 128 KB.
	DMA_DCR1_SMOD_1110 = 0xe
	// Circular buffer size is 256 KB.
	DMA_DCR1_SMOD_1111 = 0xf
	// Position of START field.
	DMA_DCR1_START_Pos = 0x10
	// Bit mask of START field.
	DMA_DCR1_START_Msk = 0x10000
	// Bit START.
	DMA_DCR1_START = 0x10000
	// DMA inactive
	DMA_DCR1_START_0 = 0x0
	// The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.
	DMA_DCR1_START_1 = 0x1
	// Position of DSIZE field.
	DMA_DCR1_DSIZE_Pos = 0x11
	// Bit mask of DSIZE field.
	DMA_DCR1_DSIZE_Msk = 0x60000
	// 32-bit
	DMA_DCR1_DSIZE_00 = 0x0
	// 8-bit
	DMA_DCR1_DSIZE_01 = 0x1
	// 16-bit
	DMA_DCR1_DSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR1_DSIZE_11 = 0x3
	// Position of DINC field.
	DMA_DCR1_DINC_Pos = 0x13
	// Bit mask of DINC field.
	DMA_DCR1_DINC_Msk = 0x80000
	// Bit DINC.
	DMA_DCR1_DINC = 0x80000
	// No change to the DAR after a successful transfer.
	DMA_DCR1_DINC_0 = 0x0
	// The DAR increments by 1, 2, 4 depending upon the size of the transfer.
	DMA_DCR1_DINC_1 = 0x1
	// Position of SSIZE field.
	DMA_DCR1_SSIZE_Pos = 0x14
	// Bit mask of SSIZE field.
	DMA_DCR1_SSIZE_Msk = 0x300000
	// 32-bit
	DMA_DCR1_SSIZE_00 = 0x0
	// 8-bit
	DMA_DCR1_SSIZE_01 = 0x1
	// 16-bit
	DMA_DCR1_SSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR1_SSIZE_11 = 0x3
	// Position of SINC field.
	DMA_DCR1_SINC_Pos = 0x16
	// Bit mask of SINC field.
	DMA_DCR1_SINC_Msk = 0x400000
	// Bit SINC.
	DMA_DCR1_SINC = 0x400000
	// No change to SAR after a successful transfer.
	DMA_DCR1_SINC_0 = 0x0
	// The SAR increments by 1, 2, 4 as determined by the transfer size.
	DMA_DCR1_SINC_1 = 0x1
	// Position of EADREQ field.
	DMA_DCR1_EADREQ_Pos = 0x17
	// Bit mask of EADREQ field.
	DMA_DCR1_EADREQ_Msk = 0x800000
	// Bit EADREQ.
	DMA_DCR1_EADREQ = 0x800000
	// Disabled
	DMA_DCR1_EADREQ_0 = 0x0
	// Enabled
	DMA_DCR1_EADREQ_1 = 0x1
	// Position of AA field.
	DMA_DCR1_AA_Pos = 0x1c
	// Bit mask of AA field.
	DMA_DCR1_AA_Msk = 0x10000000
	// Bit AA.
	DMA_DCR1_AA = 0x10000000
	// Auto-align disabled
	DMA_DCR1_AA_0 = 0x0
	// If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.
	DMA_DCR1_AA_1 = 0x1
	// Position of CS field.
	DMA_DCR1_CS_Pos = 0x1d
	// Bit mask of CS field.
	DMA_DCR1_CS_Msk = 0x20000000
	// Bit CS.
	DMA_DCR1_CS = 0x20000000
	// DMA continuously makes read/write transfers until the BCR decrements to 0.
	DMA_DCR1_CS_0 = 0x0
	// Forces a single read/write transfer per request.
	DMA_DCR1_CS_1 = 0x1
	// Position of ERQ field.
	DMA_DCR1_ERQ_Pos = 0x1e
	// Bit mask of ERQ field.
	DMA_DCR1_ERQ_Msk = 0x40000000
	// Bit ERQ.
	DMA_DCR1_ERQ = 0x40000000
	// Peripheral request is ignored.
	DMA_DCR1_ERQ_0 = 0x0
	// Enables peripheral request to initiate transfer. A software-initiated request (setting START) is always enabled.
	DMA_DCR1_ERQ_1 = 0x1
	// Position of EINT field.
	DMA_DCR1_EINT_Pos = 0x1f
	// Bit mask of EINT field.
	DMA_DCR1_EINT_Msk = 0x80000000
	// Bit EINT.
	DMA_DCR1_EINT = 0x80000000
	// No interrupt is generated.
	DMA_DCR1_EINT_0 = 0x0
	// Interrupt signal is enabled.
	DMA_DCR1_EINT_1 = 0x1

	// SAR2: Source Address Register
	// Position of SAR field.
	DMA_SAR2_SAR_Pos = 0x0
	// Bit mask of SAR field.
	DMA_SAR2_SAR_Msk = 0xffffffff

	// DAR2: Destination Address Register
	// Position of DAR field.
	DMA_DAR2_DAR_Pos = 0x0
	// Bit mask of DAR field.
	DMA_DAR2_DAR_Msk = 0xffffffff

	// DSR_BCR2: DMA Status Register / Byte Count Register
	// Position of BCR field.
	DMA_DSR_BCR2_BCR_Pos = 0x0
	// Bit mask of BCR field.
	DMA_DSR_BCR2_BCR_Msk = 0xffffff
	// Position of DONE field.
	DMA_DSR_BCR2_DONE_Pos = 0x18
	// Bit mask of DONE field.
	DMA_DSR_BCR2_DONE_Msk = 0x1000000
	// Bit DONE.
	DMA_DSR_BCR2_DONE = 0x1000000
	// DMA transfer is not yet complete. Writing a 0 has no effect.
	DMA_DSR_BCR2_DONE_0 = 0x0
	// DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.
	DMA_DSR_BCR2_DONE_1 = 0x1
	// Position of BSY field.
	DMA_DSR_BCR2_BSY_Pos = 0x19
	// Bit mask of BSY field.
	DMA_DSR_BCR2_BSY_Msk = 0x2000000
	// Bit BSY.
	DMA_DSR_BCR2_BSY = 0x2000000
	// DMA channel is inactive. Cleared when the DMA has finished the last transaction.
	DMA_DSR_BCR2_BSY_0 = 0x0
	// BSY is set the first time the channel is enabled after a transfer is initiated.
	DMA_DSR_BCR2_BSY_1 = 0x1
	// Position of REQ field.
	DMA_DSR_BCR2_REQ_Pos = 0x1a
	// Bit mask of REQ field.
	DMA_DSR_BCR2_REQ_Msk = 0x4000000
	// Bit REQ.
	DMA_DSR_BCR2_REQ = 0x4000000
	// No request is pending or the channel is currently active. Cleared when the channel is selected.
	DMA_DSR_BCR2_REQ_0 = 0x0
	// The DMA channel has a transfer remaining and the channel is not selected.
	DMA_DSR_BCR2_REQ_1 = 0x1
	// Position of BED field.
	DMA_DSR_BCR2_BED_Pos = 0x1c
	// Bit mask of BED field.
	DMA_DSR_BCR2_BED_Msk = 0x10000000
	// Bit BED.
	DMA_DSR_BCR2_BED = 0x10000000
	// No bus error occurred.
	DMA_DSR_BCR2_BED_0 = 0x0
	// The DMA channel terminated with a bus error during the write portion of a transfer.
	DMA_DSR_BCR2_BED_1 = 0x1
	// Position of BES field.
	DMA_DSR_BCR2_BES_Pos = 0x1d
	// Bit mask of BES field.
	DMA_DSR_BCR2_BES_Msk = 0x20000000
	// Bit BES.
	DMA_DSR_BCR2_BES = 0x20000000
	// No bus error occurred.
	DMA_DSR_BCR2_BES_0 = 0x0
	// The DMA channel terminated with a bus error during the read portion of a transfer.
	DMA_DSR_BCR2_BES_1 = 0x1
	// Position of CE field.
	DMA_DSR_BCR2_CE_Pos = 0x1e
	// Bit mask of CE field.
	DMA_DSR_BCR2_CE_Msk = 0x40000000
	// Bit CE.
	DMA_DSR_BCR2_CE = 0x40000000
	// No configuration error exists.
	DMA_DSR_BCR2_CE_0 = 0x0
	// A configuration error has occurred.
	DMA_DSR_BCR2_CE_1 = 0x1

	// DCR2: DMA Control Register
	// Position of LCH2 field.
	DMA_DCR2_LCH2_Pos = 0x0
	// Bit mask of LCH2 field.
	DMA_DCR2_LCH2_Msk = 0x3
	// DMA Channel 0
	DMA_DCR2_LCH2_00 = 0x0
	// DMA Channel 1
	DMA_DCR2_LCH2_01 = 0x1
	// DMA Channel 2
	DMA_DCR2_LCH2_10 = 0x2
	// DMA Channel 3
	DMA_DCR2_LCH2_11 = 0x3
	// Position of LCH1 field.
	DMA_DCR2_LCH1_Pos = 0x2
	// Bit mask of LCH1 field.
	DMA_DCR2_LCH1_Msk = 0xc
	// DMA Channel 0
	DMA_DCR2_LCH1_00 = 0x0
	// DMA Channel 1
	DMA_DCR2_LCH1_01 = 0x1
	// DMA Channel 2
	DMA_DCR2_LCH1_10 = 0x2
	// DMA Channel 3
	DMA_DCR2_LCH1_11 = 0x3
	// Position of LINKCC field.
	DMA_DCR2_LINKCC_Pos = 0x4
	// Bit mask of LINKCC field.
	DMA_DCR2_LINKCC_Msk = 0x30
	// No channel-to-channel linking
	DMA_DCR2_LINKCC_00 = 0x0
	// Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to 0.
	DMA_DCR2_LINKCC_01 = 0x1
	// Perform a link to channel LCH1 after each cycle-steal transfer
	DMA_DCR2_LINKCC_10 = 0x2
	// Perform a link to channel LCH1 after the BCR decrements to 0.
	DMA_DCR2_LINKCC_11 = 0x3
	// Position of D_REQ field.
	DMA_DCR2_D_REQ_Pos = 0x7
	// Bit mask of D_REQ field.
	DMA_DCR2_D_REQ_Msk = 0x80
	// Bit D_REQ.
	DMA_DCR2_D_REQ = 0x80
	// ERQ bit is not affected.
	DMA_DCR2_D_REQ_0 = 0x0
	// ERQ bit is cleared when the BCR is exhausted.
	DMA_DCR2_D_REQ_1 = 0x1
	// Position of DMOD field.
	DMA_DCR2_DMOD_Pos = 0x8
	// Bit mask of DMOD field.
	DMA_DCR2_DMOD_Msk = 0xf00
	// Buffer disabled
	DMA_DCR2_DMOD_0000 = 0x0
	// Circular buffer size is 16 bytes
	DMA_DCR2_DMOD_0001 = 0x1
	// Circular buffer size is 32 bytes
	DMA_DCR2_DMOD_0010 = 0x2
	// Circular buffer size is 64 bytes
	DMA_DCR2_DMOD_0011 = 0x3
	// Circular buffer size is 128 bytes
	DMA_DCR2_DMOD_0100 = 0x4
	// Circular buffer size is 256 bytes
	DMA_DCR2_DMOD_0101 = 0x5
	// Circular buffer size is 512 bytes
	DMA_DCR2_DMOD_0110 = 0x6
	// Circular buffer size is 1 KB
	DMA_DCR2_DMOD_0111 = 0x7
	// Circular buffer size is 2 KB
	DMA_DCR2_DMOD_1000 = 0x8
	// Circular buffer size is 4 KB
	DMA_DCR2_DMOD_1001 = 0x9
	// Circular buffer size is 8 KB
	DMA_DCR2_DMOD_1010 = 0xa
	// Circular buffer size is 16 KB
	DMA_DCR2_DMOD_1011 = 0xb
	// Circular buffer size is 32 KB
	DMA_DCR2_DMOD_1100 = 0xc
	// Circular buffer size is 64 KB
	DMA_DCR2_DMOD_1101 = 0xd
	// Circular buffer size is 128 KB
	DMA_DCR2_DMOD_1110 = 0xe
	// Circular buffer size is 256 KB
	DMA_DCR2_DMOD_1111 = 0xf
	// Position of SMOD field.
	DMA_DCR2_SMOD_Pos = 0xc
	// Bit mask of SMOD field.
	DMA_DCR2_SMOD_Msk = 0xf000
	// Buffer disabled
	DMA_DCR2_SMOD_0000 = 0x0
	// Circular buffer size is 16 bytes.
	DMA_DCR2_SMOD_0001 = 0x1
	// Circular buffer size is 32 bytes.
	DMA_DCR2_SMOD_0010 = 0x2
	// Circular buffer size is 64 bytes.
	DMA_DCR2_SMOD_0011 = 0x3
	// Circular buffer size is 128 bytes.
	DMA_DCR2_SMOD_0100 = 0x4
	// Circular buffer size is 256 bytes.
	DMA_DCR2_SMOD_0101 = 0x5
	// Circular buffer size is 512 bytes.
	DMA_DCR2_SMOD_0110 = 0x6
	// Circular buffer size is 1 KB.
	DMA_DCR2_SMOD_0111 = 0x7
	// Circular buffer size is 2 KB.
	DMA_DCR2_SMOD_1000 = 0x8
	// Circular buffer size is 4 KB.
	DMA_DCR2_SMOD_1001 = 0x9
	// Circular buffer size is 8 KB.
	DMA_DCR2_SMOD_1010 = 0xa
	// Circular buffer size is 16 KB.
	DMA_DCR2_SMOD_1011 = 0xb
	// Circular buffer size is 32 KB.
	DMA_DCR2_SMOD_1100 = 0xc
	// Circular buffer size is 64 KB.
	DMA_DCR2_SMOD_1101 = 0xd
	// Circular buffer size is 128 KB.
	DMA_DCR2_SMOD_1110 = 0xe
	// Circular buffer size is 256 KB.
	DMA_DCR2_SMOD_1111 = 0xf
	// Position of START field.
	DMA_DCR2_START_Pos = 0x10
	// Bit mask of START field.
	DMA_DCR2_START_Msk = 0x10000
	// Bit START.
	DMA_DCR2_START = 0x10000
	// DMA inactive
	DMA_DCR2_START_0 = 0x0
	// The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.
	DMA_DCR2_START_1 = 0x1
	// Position of DSIZE field.
	DMA_DCR2_DSIZE_Pos = 0x11
	// Bit mask of DSIZE field.
	DMA_DCR2_DSIZE_Msk = 0x60000
	// 32-bit
	DMA_DCR2_DSIZE_00 = 0x0
	// 8-bit
	DMA_DCR2_DSIZE_01 = 0x1
	// 16-bit
	DMA_DCR2_DSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR2_DSIZE_11 = 0x3
	// Position of DINC field.
	DMA_DCR2_DINC_Pos = 0x13
	// Bit mask of DINC field.
	DMA_DCR2_DINC_Msk = 0x80000
	// Bit DINC.
	DMA_DCR2_DINC = 0x80000
	// No change to the DAR after a successful transfer.
	DMA_DCR2_DINC_0 = 0x0
	// The DAR increments by 1, 2, 4 depending upon the size of the transfer.
	DMA_DCR2_DINC_1 = 0x1
	// Position of SSIZE field.
	DMA_DCR2_SSIZE_Pos = 0x14
	// Bit mask of SSIZE field.
	DMA_DCR2_SSIZE_Msk = 0x300000
	// 32-bit
	DMA_DCR2_SSIZE_00 = 0x0
	// 8-bit
	DMA_DCR2_SSIZE_01 = 0x1
	// 16-bit
	DMA_DCR2_SSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR2_SSIZE_11 = 0x3
	// Position of SINC field.
	DMA_DCR2_SINC_Pos = 0x16
	// Bit mask of SINC field.
	DMA_DCR2_SINC_Msk = 0x400000
	// Bit SINC.
	DMA_DCR2_SINC = 0x400000
	// No change to SAR after a successful transfer.
	DMA_DCR2_SINC_0 = 0x0
	// The SAR increments by 1, 2, 4 as determined by the transfer size.
	DMA_DCR2_SINC_1 = 0x1
	// Position of EADREQ field.
	DMA_DCR2_EADREQ_Pos = 0x17
	// Bit mask of EADREQ field.
	DMA_DCR2_EADREQ_Msk = 0x800000
	// Bit EADREQ.
	DMA_DCR2_EADREQ = 0x800000
	// Disabled
	DMA_DCR2_EADREQ_0 = 0x0
	// Enabled
	DMA_DCR2_EADREQ_1 = 0x1
	// Position of AA field.
	DMA_DCR2_AA_Pos = 0x1c
	// Bit mask of AA field.
	DMA_DCR2_AA_Msk = 0x10000000
	// Bit AA.
	DMA_DCR2_AA = 0x10000000
	// Auto-align disabled
	DMA_DCR2_AA_0 = 0x0
	// If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.
	DMA_DCR2_AA_1 = 0x1
	// Position of CS field.
	DMA_DCR2_CS_Pos = 0x1d
	// Bit mask of CS field.
	DMA_DCR2_CS_Msk = 0x20000000
	// Bit CS.
	DMA_DCR2_CS = 0x20000000
	// DMA continuously makes read/write transfers until the BCR decrements to 0.
	DMA_DCR2_CS_0 = 0x0
	// Forces a single read/write transfer per request.
	DMA_DCR2_CS_1 = 0x1
	// Position of ERQ field.
	DMA_DCR2_ERQ_Pos = 0x1e
	// Bit mask of ERQ field.
	DMA_DCR2_ERQ_Msk = 0x40000000
	// Bit ERQ.
	DMA_DCR2_ERQ = 0x40000000
	// Peripheral request is ignored.
	DMA_DCR2_ERQ_0 = 0x0
	// Enables peripheral request to initiate transfer. A software-initiated request (setting START) is always enabled.
	DMA_DCR2_ERQ_1 = 0x1
	// Position of EINT field.
	DMA_DCR2_EINT_Pos = 0x1f
	// Bit mask of EINT field.
	DMA_DCR2_EINT_Msk = 0x80000000
	// Bit EINT.
	DMA_DCR2_EINT = 0x80000000
	// No interrupt is generated.
	DMA_DCR2_EINT_0 = 0x0
	// Interrupt signal is enabled.
	DMA_DCR2_EINT_1 = 0x1

	// SAR3: Source Address Register
	// Position of SAR field.
	DMA_SAR3_SAR_Pos = 0x0
	// Bit mask of SAR field.
	DMA_SAR3_SAR_Msk = 0xffffffff

	// DAR3: Destination Address Register
	// Position of DAR field.
	DMA_DAR3_DAR_Pos = 0x0
	// Bit mask of DAR field.
	DMA_DAR3_DAR_Msk = 0xffffffff

	// DSR_BCR3: DMA Status Register / Byte Count Register
	// Position of BCR field.
	DMA_DSR_BCR3_BCR_Pos = 0x0
	// Bit mask of BCR field.
	DMA_DSR_BCR3_BCR_Msk = 0xffffff
	// Position of DONE field.
	DMA_DSR_BCR3_DONE_Pos = 0x18
	// Bit mask of DONE field.
	DMA_DSR_BCR3_DONE_Msk = 0x1000000
	// Bit DONE.
	DMA_DSR_BCR3_DONE = 0x1000000
	// DMA transfer is not yet complete. Writing a 0 has no effect.
	DMA_DSR_BCR3_DONE_0 = 0x0
	// DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.
	DMA_DSR_BCR3_DONE_1 = 0x1
	// Position of BSY field.
	DMA_DSR_BCR3_BSY_Pos = 0x19
	// Bit mask of BSY field.
	DMA_DSR_BCR3_BSY_Msk = 0x2000000
	// Bit BSY.
	DMA_DSR_BCR3_BSY = 0x2000000
	// DMA channel is inactive. Cleared when the DMA has finished the last transaction.
	DMA_DSR_BCR3_BSY_0 = 0x0
	// BSY is set the first time the channel is enabled after a transfer is initiated.
	DMA_DSR_BCR3_BSY_1 = 0x1
	// Position of REQ field.
	DMA_DSR_BCR3_REQ_Pos = 0x1a
	// Bit mask of REQ field.
	DMA_DSR_BCR3_REQ_Msk = 0x4000000
	// Bit REQ.
	DMA_DSR_BCR3_REQ = 0x4000000
	// No request is pending or the channel is currently active. Cleared when the channel is selected.
	DMA_DSR_BCR3_REQ_0 = 0x0
	// The DMA channel has a transfer remaining and the channel is not selected.
	DMA_DSR_BCR3_REQ_1 = 0x1
	// Position of BED field.
	DMA_DSR_BCR3_BED_Pos = 0x1c
	// Bit mask of BED field.
	DMA_DSR_BCR3_BED_Msk = 0x10000000
	// Bit BED.
	DMA_DSR_BCR3_BED = 0x10000000
	// No bus error occurred.
	DMA_DSR_BCR3_BED_0 = 0x0
	// The DMA channel terminated with a bus error during the write portion of a transfer.
	DMA_DSR_BCR3_BED_1 = 0x1
	// Position of BES field.
	DMA_DSR_BCR3_BES_Pos = 0x1d
	// Bit mask of BES field.
	DMA_DSR_BCR3_BES_Msk = 0x20000000
	// Bit BES.
	DMA_DSR_BCR3_BES = 0x20000000
	// No bus error occurred.
	DMA_DSR_BCR3_BES_0 = 0x0
	// The DMA channel terminated with a bus error during the read portion of a transfer.
	DMA_DSR_BCR3_BES_1 = 0x1
	// Position of CE field.
	DMA_DSR_BCR3_CE_Pos = 0x1e
	// Bit mask of CE field.
	DMA_DSR_BCR3_CE_Msk = 0x40000000
	// Bit CE.
	DMA_DSR_BCR3_CE = 0x40000000
	// No configuration error exists.
	DMA_DSR_BCR3_CE_0 = 0x0
	// A configuration error has occurred.
	DMA_DSR_BCR3_CE_1 = 0x1

	// DCR3: DMA Control Register
	// Position of LCH2 field.
	DMA_DCR3_LCH2_Pos = 0x0
	// Bit mask of LCH2 field.
	DMA_DCR3_LCH2_Msk = 0x3
	// DMA Channel 0
	DMA_DCR3_LCH2_00 = 0x0
	// DMA Channel 1
	DMA_DCR3_LCH2_01 = 0x1
	// DMA Channel 2
	DMA_DCR3_LCH2_10 = 0x2
	// DMA Channel 3
	DMA_DCR3_LCH2_11 = 0x3
	// Position of LCH1 field.
	DMA_DCR3_LCH1_Pos = 0x2
	// Bit mask of LCH1 field.
	DMA_DCR3_LCH1_Msk = 0xc
	// DMA Channel 0
	DMA_DCR3_LCH1_00 = 0x0
	// DMA Channel 1
	DMA_DCR3_LCH1_01 = 0x1
	// DMA Channel 2
	DMA_DCR3_LCH1_10 = 0x2
	// DMA Channel 3
	DMA_DCR3_LCH1_11 = 0x3
	// Position of LINKCC field.
	DMA_DCR3_LINKCC_Pos = 0x4
	// Bit mask of LINKCC field.
	DMA_DCR3_LINKCC_Msk = 0x30
	// No channel-to-channel linking
	DMA_DCR3_LINKCC_00 = 0x0
	// Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to 0.
	DMA_DCR3_LINKCC_01 = 0x1
	// Perform a link to channel LCH1 after each cycle-steal transfer
	DMA_DCR3_LINKCC_10 = 0x2
	// Perform a link to channel LCH1 after the BCR decrements to 0.
	DMA_DCR3_LINKCC_11 = 0x3
	// Position of D_REQ field.
	DMA_DCR3_D_REQ_Pos = 0x7
	// Bit mask of D_REQ field.
	DMA_DCR3_D_REQ_Msk = 0x80
	// Bit D_REQ.
	DMA_DCR3_D_REQ = 0x80
	// ERQ bit is not affected.
	DMA_DCR3_D_REQ_0 = 0x0
	// ERQ bit is cleared when the BCR is exhausted.
	DMA_DCR3_D_REQ_1 = 0x1
	// Position of DMOD field.
	DMA_DCR3_DMOD_Pos = 0x8
	// Bit mask of DMOD field.
	DMA_DCR3_DMOD_Msk = 0xf00
	// Buffer disabled
	DMA_DCR3_DMOD_0000 = 0x0
	// Circular buffer size is 16 bytes
	DMA_DCR3_DMOD_0001 = 0x1
	// Circular buffer size is 32 bytes
	DMA_DCR3_DMOD_0010 = 0x2
	// Circular buffer size is 64 bytes
	DMA_DCR3_DMOD_0011 = 0x3
	// Circular buffer size is 128 bytes
	DMA_DCR3_DMOD_0100 = 0x4
	// Circular buffer size is 256 bytes
	DMA_DCR3_DMOD_0101 = 0x5
	// Circular buffer size is 512 bytes
	DMA_DCR3_DMOD_0110 = 0x6
	// Circular buffer size is 1 KB
	DMA_DCR3_DMOD_0111 = 0x7
	// Circular buffer size is 2 KB
	DMA_DCR3_DMOD_1000 = 0x8
	// Circular buffer size is 4 KB
	DMA_DCR3_DMOD_1001 = 0x9
	// Circular buffer size is 8 KB
	DMA_DCR3_DMOD_1010 = 0xa
	// Circular buffer size is 16 KB
	DMA_DCR3_DMOD_1011 = 0xb
	// Circular buffer size is 32 KB
	DMA_DCR3_DMOD_1100 = 0xc
	// Circular buffer size is 64 KB
	DMA_DCR3_DMOD_1101 = 0xd
	// Circular buffer size is 128 KB
	DMA_DCR3_DMOD_1110 = 0xe
	// Circular buffer size is 256 KB
	DMA_DCR3_DMOD_1111 = 0xf
	// Position of SMOD field.
	DMA_DCR3_SMOD_Pos = 0xc
	// Bit mask of SMOD field.
	DMA_DCR3_SMOD_Msk = 0xf000
	// Buffer disabled
	DMA_DCR3_SMOD_0000 = 0x0
	// Circular buffer size is 16 bytes.
	DMA_DCR3_SMOD_0001 = 0x1
	// Circular buffer size is 32 bytes.
	DMA_DCR3_SMOD_0010 = 0x2
	// Circular buffer size is 64 bytes.
	DMA_DCR3_SMOD_0011 = 0x3
	// Circular buffer size is 128 bytes.
	DMA_DCR3_SMOD_0100 = 0x4
	// Circular buffer size is 256 bytes.
	DMA_DCR3_SMOD_0101 = 0x5
	// Circular buffer size is 512 bytes.
	DMA_DCR3_SMOD_0110 = 0x6
	// Circular buffer size is 1 KB.
	DMA_DCR3_SMOD_0111 = 0x7
	// Circular buffer size is 2 KB.
	DMA_DCR3_SMOD_1000 = 0x8
	// Circular buffer size is 4 KB.
	DMA_DCR3_SMOD_1001 = 0x9
	// Circular buffer size is 8 KB.
	DMA_DCR3_SMOD_1010 = 0xa
	// Circular buffer size is 16 KB.
	DMA_DCR3_SMOD_1011 = 0xb
	// Circular buffer size is 32 KB.
	DMA_DCR3_SMOD_1100 = 0xc
	// Circular buffer size is 64 KB.
	DMA_DCR3_SMOD_1101 = 0xd
	// Circular buffer size is 128 KB.
	DMA_DCR3_SMOD_1110 = 0xe
	// Circular buffer size is 256 KB.
	DMA_DCR3_SMOD_1111 = 0xf
	// Position of START field.
	DMA_DCR3_START_Pos = 0x10
	// Bit mask of START field.
	DMA_DCR3_START_Msk = 0x10000
	// Bit START.
	DMA_DCR3_START = 0x10000
	// DMA inactive
	DMA_DCR3_START_0 = 0x0
	// The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.
	DMA_DCR3_START_1 = 0x1
	// Position of DSIZE field.
	DMA_DCR3_DSIZE_Pos = 0x11
	// Bit mask of DSIZE field.
	DMA_DCR3_DSIZE_Msk = 0x60000
	// 32-bit
	DMA_DCR3_DSIZE_00 = 0x0
	// 8-bit
	DMA_DCR3_DSIZE_01 = 0x1
	// 16-bit
	DMA_DCR3_DSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR3_DSIZE_11 = 0x3
	// Position of DINC field.
	DMA_DCR3_DINC_Pos = 0x13
	// Bit mask of DINC field.
	DMA_DCR3_DINC_Msk = 0x80000
	// Bit DINC.
	DMA_DCR3_DINC = 0x80000
	// No change to the DAR after a successful transfer.
	DMA_DCR3_DINC_0 = 0x0
	// The DAR increments by 1, 2, 4 depending upon the size of the transfer.
	DMA_DCR3_DINC_1 = 0x1
	// Position of SSIZE field.
	DMA_DCR3_SSIZE_Pos = 0x14
	// Bit mask of SSIZE field.
	DMA_DCR3_SSIZE_Msk = 0x300000
	// 32-bit
	DMA_DCR3_SSIZE_00 = 0x0
	// 8-bit
	DMA_DCR3_SSIZE_01 = 0x1
	// 16-bit
	DMA_DCR3_SSIZE_10 = 0x2
	// Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
	DMA_DCR3_SSIZE_11 = 0x3
	// Position of SINC field.
	DMA_DCR3_SINC_Pos = 0x16
	// Bit mask of SINC field.
	DMA_DCR3_SINC_Msk = 0x400000
	// Bit SINC.
	DMA_DCR3_SINC = 0x400000
	// No change to SAR after a successful transfer.
	DMA_DCR3_SINC_0 = 0x0
	// The SAR increments by 1, 2, 4 as determined by the transfer size.
	DMA_DCR3_SINC_1 = 0x1
	// Position of EADREQ field.
	DMA_DCR3_EADREQ_Pos = 0x17
	// Bit mask of EADREQ field.
	DMA_DCR3_EADREQ_Msk = 0x800000
	// Bit EADREQ.
	DMA_DCR3_EADREQ = 0x800000
	// Disabled
	DMA_DCR3_EADREQ_0 = 0x0
	// Enabled
	DMA_DCR3_EADREQ_1 = 0x1
	// Position of AA field.
	DMA_DCR3_AA_Pos = 0x1c
	// Bit mask of AA field.
	DMA_DCR3_AA_Msk = 0x10000000
	// Bit AA.
	DMA_DCR3_AA = 0x10000000
	// Auto-align disabled
	DMA_DCR3_AA_0 = 0x0
	// If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.
	DMA_DCR3_AA_1 = 0x1
	// Position of CS field.
	DMA_DCR3_CS_Pos = 0x1d
	// Bit mask of CS field.
	DMA_DCR3_CS_Msk = 0x20000000
	// Bit CS.
	DMA_DCR3_CS = 0x20000000
	// DMA continuously makes read/write transfers until the BCR decrements to 0.
	DMA_DCR3_CS_0 = 0x0
	// Forces a single read/write transfer per request.
	DMA_DCR3_CS_1 = 0x1
	// Position of ERQ field.
	DMA_DCR3_ERQ_Pos = 0x1e
	// Bit mask of ERQ field.
	DMA_DCR3_ERQ_Msk = 0x40000000
	// Bit ERQ.
	DMA_DCR3_ERQ = 0x40000000
	// Peripheral request is ignored.
	DMA_DCR3_ERQ_0 = 0x0
	// Enables peripheral request to initiate transfer. A software-initiated request (setting START) is always enabled.
	DMA_DCR3_ERQ_1 = 0x1
	// Position of EINT field.
	DMA_DCR3_EINT_Pos = 0x1f
	// Bit mask of EINT field.
	DMA_DCR3_EINT_Msk = 0x80000000
	// Bit EINT.
	DMA_DCR3_EINT = 0x80000000
	// No interrupt is generated.
	DMA_DCR3_EINT_0 = 0x0
	// Interrupt signal is enabled.
	DMA_DCR3_EINT_1 = 0x1
)

// Constants for FTFA: Flash Memory Interface
const (
	// FSTAT: Flash Status Register
	// Position of MGSTAT0 field.
	FTFA_FSTAT_MGSTAT0_Pos = 0x0
	// Bit mask of MGSTAT0 field.
	FTFA_FSTAT_MGSTAT0_Msk = 0x1
	// Bit MGSTAT0.
	FTFA_FSTAT_MGSTAT0 = 0x1
	// Position of FPVIOL field.
	FTFA_FSTAT_FPVIOL_Pos = 0x4
	// Bit mask of FPVIOL field.
	FTFA_FSTAT_FPVIOL_Msk = 0x10
	// Bit FPVIOL.
	FTFA_FSTAT_FPVIOL = 0x10
	// No protection violation detected
	FTFA_FSTAT_FPVIOL_0 = 0x0
	// Protection violation detected
	FTFA_FSTAT_FPVIOL_1 = 0x1
	// Position of ACCERR field.
	FTFA_FSTAT_ACCERR_Pos = 0x5
	// Bit mask of ACCERR field.
	FTFA_FSTAT_ACCERR_Msk = 0x20
	// Bit ACCERR.
	FTFA_FSTAT_ACCERR = 0x20
	// No access error detected
	FTFA_FSTAT_ACCERR_0 = 0x0
	// Access error detected
	FTFA_FSTAT_ACCERR_1 = 0x1
	// Position of RDCOLERR field.
	FTFA_FSTAT_RDCOLERR_Pos = 0x6
	// Bit mask of RDCOLERR field.
	FTFA_FSTAT_RDCOLERR_Msk = 0x40
	// Bit RDCOLERR.
	FTFA_FSTAT_RDCOLERR = 0x40
	// No collision error detected
	FTFA_FSTAT_RDCOLERR_0 = 0x0
	// Collision error detected
	FTFA_FSTAT_RDCOLERR_1 = 0x1
	// Position of CCIF field.
	FTFA_FSTAT_CCIF_Pos = 0x7
	// Bit mask of CCIF field.
	FTFA_FSTAT_CCIF_Msk = 0x80
	// Bit CCIF.
	FTFA_FSTAT_CCIF = 0x80
	// Flash command in progress
	FTFA_FSTAT_CCIF_0 = 0x0
	// Flash command has completed
	FTFA_FSTAT_CCIF_1 = 0x1

	// FCNFG: Flash Configuration Register
	// Position of ERSSUSP field.
	FTFA_FCNFG_ERSSUSP_Pos = 0x4
	// Bit mask of ERSSUSP field.
	FTFA_FCNFG_ERSSUSP_Msk = 0x10
	// Bit ERSSUSP.
	FTFA_FCNFG_ERSSUSP = 0x10
	// No suspend requested
	FTFA_FCNFG_ERSSUSP_0 = 0x0
	// Suspend the current Erase Flash Sector command execution.
	FTFA_FCNFG_ERSSUSP_1 = 0x1
	// Position of ERSAREQ field.
	FTFA_FCNFG_ERSAREQ_Pos = 0x5
	// Bit mask of ERSAREQ field.
	FTFA_FCNFG_ERSAREQ_Msk = 0x20
	// Bit ERSAREQ.
	FTFA_FCNFG_ERSAREQ = 0x20
	// No request or request complete
	FTFA_FCNFG_ERSAREQ_0 = 0x0
	// Request to: run the Erase All Blocks command, verify the erased state, program the security byte in the Flash Configuration Field to the unsecure state, and release MCU security by setting the FSEC[SEC] field to the unsecure state.
	FTFA_FCNFG_ERSAREQ_1 = 0x1
	// Position of RDCOLLIE field.
	FTFA_FCNFG_RDCOLLIE_Pos = 0x6
	// Bit mask of RDCOLLIE field.
	FTFA_FCNFG_RDCOLLIE_Msk = 0x40
	// Bit RDCOLLIE.
	FTFA_FCNFG_RDCOLLIE = 0x40
	// Read collision error interrupt disabled
	FTFA_FCNFG_RDCOLLIE_0 = 0x0
	// Read collision error interrupt enabled. An interrupt request is generated whenever a flash memory read collision error is detected (see the description of FSTAT[RDCOLERR]).
	FTFA_FCNFG_RDCOLLIE_1 = 0x1
	// Position of CCIE field.
	FTFA_FCNFG_CCIE_Pos = 0x7
	// Bit mask of CCIE field.
	FTFA_FCNFG_CCIE_Msk = 0x80
	// Bit CCIE.
	FTFA_FCNFG_CCIE = 0x80
	// Command complete interrupt disabled
	FTFA_FCNFG_CCIE_0 = 0x0
	// Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.
	FTFA_FCNFG_CCIE_1 = 0x1

	// FSEC: Flash Security Register
	// Position of SEC field.
	FTFA_FSEC_SEC_Pos = 0x0
	// Bit mask of SEC field.
	FTFA_FSEC_SEC_Msk = 0x3
	// MCU security status is secure.
	FTFA_FSEC_SEC_00 = 0x0
	// MCU security status is secure.
	FTFA_FSEC_SEC_01 = 0x1
	// MCU security status is unsecure. (The standard shipping condition of the flash memory module is unsecure.)
	FTFA_FSEC_SEC_10 = 0x2
	// MCU security status is secure.
	FTFA_FSEC_SEC_11 = 0x3
	// Position of FSLACC field.
	FTFA_FSEC_FSLACC_Pos = 0x2
	// Bit mask of FSLACC field.
	FTFA_FSEC_FSLACC_Msk = 0xc
	// Freescale factory access granted
	FTFA_FSEC_FSLACC_00 = 0x0
	// Freescale factory access denied
	FTFA_FSEC_FSLACC_01 = 0x1
	// Freescale factory access denied
	FTFA_FSEC_FSLACC_10 = 0x2
	// Freescale factory access granted
	FTFA_FSEC_FSLACC_11 = 0x3
	// Position of MEEN field.
	FTFA_FSEC_MEEN_Pos = 0x4
	// Bit mask of MEEN field.
	FTFA_FSEC_MEEN_Msk = 0x30
	// Mass erase is enabled
	FTFA_FSEC_MEEN_00 = 0x0
	// Mass erase is enabled
	FTFA_FSEC_MEEN_01 = 0x1
	// Mass erase is disabled
	FTFA_FSEC_MEEN_10 = 0x2
	// Mass erase is enabled
	FTFA_FSEC_MEEN_11 = 0x3
	// Position of KEYEN field.
	FTFA_FSEC_KEYEN_Pos = 0x6
	// Bit mask of KEYEN field.
	FTFA_FSEC_KEYEN_Msk = 0xc0
	// Backdoor key access disabled
	FTFA_FSEC_KEYEN_00 = 0x0
	// Backdoor key access disabled (preferred KEYEN state to disable backdoor key access)
	FTFA_FSEC_KEYEN_01 = 0x1
	// Backdoor key access enabled
	FTFA_FSEC_KEYEN_10 = 0x2
	// Backdoor key access disabled
	FTFA_FSEC_KEYEN_11 = 0x3

	// FOPT: Flash Option Register
	// Position of OPT field.
	FTFA_FOPT_OPT_Pos = 0x0
	// Bit mask of OPT field.
	FTFA_FOPT_OPT_Msk = 0xff

	// FCCOB3: Flash Common Command Object Registers
	// Position of CCOBn field.
	FTFA_FCCOB_CCOBn_Pos = 0x0
	// Bit mask of CCOBn field.
	FTFA_FCCOB_CCOBn_Msk = 0xff

	// FPROT3: Program Flash Protection Registers
	// Position of PROT field.
	FTFA_FPROT_PROT_Pos = 0x0
	// Bit mask of PROT field.
	FTFA_FPROT_PROT_Msk = 0xff
	// Program flash region is protected.
	FTFA_FPROT_PROT_0 = 0x0
	// Program flash region is not protected
	FTFA_FPROT_PROT_1 = 0x1
)

// Constants for DMAMUX0: DMA channel multiplexor
const (
	// CHCFG0: Channel Configuration register
	// Position of SOURCE field.
	DMAMUX0_CHCFG_SOURCE_Pos = 0x0
	// Bit mask of SOURCE field.
	DMAMUX0_CHCFG_SOURCE_Msk = 0x3f
	// Disable_Signal
	DMAMUX0_CHCFG_SOURCE_0 = 0x0
	// UART0_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_2 = 0x2
	// UART0_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_3 = 0x3
	// UART1_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_4 = 0x4
	// UART1_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_5 = 0x5
	// UART2_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_6 = 0x6
	// UART2_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_7 = 0x7
	// I2S0_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_14 = 0xe
	// I2S0_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_15 = 0xf
	// SPI0_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_16 = 0x10
	// SPI0_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_17 = 0x11
	// SPI1_Rx_Signal
	DMAMUX0_CHCFG_SOURCE_18 = 0x12
	// SPI1_Tx_Signal
	DMAMUX0_CHCFG_SOURCE_19 = 0x13
	// I2C0_Signal
	DMAMUX0_CHCFG_SOURCE_22 = 0x16
	// I2C1_Signal
	DMAMUX0_CHCFG_SOURCE_23 = 0x17
	// TPM0_Channel0_Signal
	DMAMUX0_CHCFG_SOURCE_24 = 0x18
	// TPM0_Channel1_Signal
	DMAMUX0_CHCFG_SOURCE_25 = 0x19
	// TPM0_Channel2_Signal
	DMAMUX0_CHCFG_SOURCE_26 = 0x1a
	// TPM0_Channel3_Signal
	DMAMUX0_CHCFG_SOURCE_27 = 0x1b
	// TPM0_Channel4_Signal
	DMAMUX0_CHCFG_SOURCE_28 = 0x1c
	// TPM0_Channel5_Signal
	DMAMUX0_CHCFG_SOURCE_29 = 0x1d
	// TPM1_Channel0_Signal
	DMAMUX0_CHCFG_SOURCE_32 = 0x20
	// TPM1_Channel1_Signal
	DMAMUX0_CHCFG_SOURCE_33 = 0x21
	// TPM2_Channel0_Signal
	DMAMUX0_CHCFG_SOURCE_34 = 0x22
	// TPM2_Channel1_Signal
	DMAMUX0_CHCFG_SOURCE_35 = 0x23
	// ADC0_Signal
	DMAMUX0_CHCFG_SOURCE_40 = 0x28
	// CMP0_Signal
	DMAMUX0_CHCFG_SOURCE_42 = 0x2a
	// DAC0_Signal
	DMAMUX0_CHCFG_SOURCE_45 = 0x2d
	// PortA_Signal
	DMAMUX0_CHCFG_SOURCE_49 = 0x31
	// PortC_Signal
	DMAMUX0_CHCFG_SOURCE_51 = 0x33
	// PortD_Signal
	DMAMUX0_CHCFG_SOURCE_52 = 0x34
	// TPM0_Overflow_Signal
	DMAMUX0_CHCFG_SOURCE_54 = 0x36
	// TPM1_Overflow_Signal
	DMAMUX0_CHCFG_SOURCE_55 = 0x37
	// TPM2_Overflow_Signal
	DMAMUX0_CHCFG_SOURCE_56 = 0x38
	// AlwaysOn60_Signal
	DMAMUX0_CHCFG_SOURCE_60 = 0x3c
	// AlwaysOn61_Signal
	DMAMUX0_CHCFG_SOURCE_61 = 0x3d
	// AlwaysOn62_Signal
	DMAMUX0_CHCFG_SOURCE_62 = 0x3e
	// AlwaysOn63_Signal
	DMAMUX0_CHCFG_SOURCE_63 = 0x3f
	// Position of TRIG field.
	DMAMUX0_CHCFG_TRIG_Pos = 0x6
	// Bit mask of TRIG field.
	DMAMUX0_CHCFG_TRIG_Msk = 0x40
	// Bit TRIG.
	DMAMUX0_CHCFG_TRIG = 0x40
	// Triggering is disabled. If triggering is disabled and ENBL is set, the DMA Channel will simply route the specified source to the DMA channel. (Normal mode)
	DMAMUX0_CHCFG_TRIG_0 = 0x0
	// Triggering is enabled. If triggering is enabled and ENBL is set, the DMAMUX is in Periodic Trigger mode.
	DMAMUX0_CHCFG_TRIG_1 = 0x1
	// Position of ENBL field.
	DMAMUX0_CHCFG_ENBL_Pos = 0x7
	// Bit mask of ENBL field.
	DMAMUX0_CHCFG_ENBL_Msk = 0x80
	// Bit ENBL.
	DMAMUX0_CHCFG_ENBL = 0x80
	// DMA channel is disabled. This mode is primarily used during configuration of the DMAMux. The DMA has separate channel enables/disables, which should be used to disable or reconfigure a DMA channel.
	DMAMUX0_CHCFG_ENBL_0 = 0x0
	// DMA channel is enabled
	DMAMUX0_CHCFG_ENBL_1 = 0x1
)

// Constants for I2S0: Inter-IC Sound / Synchronous Audio Interface
const (
	// TCSR: SAI Transmit Control Register
	// Position of FWDE field.
	I2S0_TCSR_FWDE_Pos = 0x1
	// Bit mask of FWDE field.
	I2S0_TCSR_FWDE_Msk = 0x2
	// Bit FWDE.
	I2S0_TCSR_FWDE = 0x2
	// Disables the DMA request.
	I2S0_TCSR_FWDE_0 = 0x0
	// Enables the DMA request.
	I2S0_TCSR_FWDE_1 = 0x1
	// Position of FWIE field.
	I2S0_TCSR_FWIE_Pos = 0x9
	// Bit mask of FWIE field.
	I2S0_TCSR_FWIE_Msk = 0x200
	// Bit FWIE.
	I2S0_TCSR_FWIE = 0x200
	// Disables the interrupt.
	I2S0_TCSR_FWIE_0 = 0x0
	// Enables the interrupt.
	I2S0_TCSR_FWIE_1 = 0x1
	// Position of FEIE field.
	I2S0_TCSR_FEIE_Pos = 0xa
	// Bit mask of FEIE field.
	I2S0_TCSR_FEIE_Msk = 0x400
	// Bit FEIE.
	I2S0_TCSR_FEIE = 0x400
	// Disables the interrupt.
	I2S0_TCSR_FEIE_0 = 0x0
	// Enables the interrupt.
	I2S0_TCSR_FEIE_1 = 0x1
	// Position of SEIE field.
	I2S0_TCSR_SEIE_Pos = 0xb
	// Bit mask of SEIE field.
	I2S0_TCSR_SEIE_Msk = 0x800
	// Bit SEIE.
	I2S0_TCSR_SEIE = 0x800
	// Disables interrupt.
	I2S0_TCSR_SEIE_0 = 0x0
	// Enables interrupt.
	I2S0_TCSR_SEIE_1 = 0x1
	// Position of WSIE field.
	I2S0_TCSR_WSIE_Pos = 0xc
	// Bit mask of WSIE field.
	I2S0_TCSR_WSIE_Msk = 0x1000
	// Bit WSIE.
	I2S0_TCSR_WSIE = 0x1000
	// Disables interrupt.
	I2S0_TCSR_WSIE_0 = 0x0
	// Enables interrupt.
	I2S0_TCSR_WSIE_1 = 0x1
	// Position of FWF field.
	I2S0_TCSR_FWF_Pos = 0x11
	// Bit mask of FWF field.
	I2S0_TCSR_FWF_Msk = 0x20000
	// Bit FWF.
	I2S0_TCSR_FWF = 0x20000
	// No enabled transmit FIFO is empty.
	I2S0_TCSR_FWF_0 = 0x0
	// Enabled transmit FIFO is empty.
	I2S0_TCSR_FWF_1 = 0x1
	// Position of FEF field.
	I2S0_TCSR_FEF_Pos = 0x12
	// Bit mask of FEF field.
	I2S0_TCSR_FEF_Msk = 0x40000
	// Bit FEF.
	I2S0_TCSR_FEF = 0x40000
	// Transmit underrun not detected.
	I2S0_TCSR_FEF_0 = 0x0
	// Transmit underrun detected.
	I2S0_TCSR_FEF_1 = 0x1
	// Position of SEF field.
	I2S0_TCSR_SEF_Pos = 0x13
	// Bit mask of SEF field.
	I2S0_TCSR_SEF_Msk = 0x80000
	// Bit SEF.
	I2S0_TCSR_SEF = 0x80000
	// Sync error not detected.
	I2S0_TCSR_SEF_0 = 0x0
	// Frame sync error detected.
	I2S0_TCSR_SEF_1 = 0x1
	// Position of WSF field.
	I2S0_TCSR_WSF_Pos = 0x14
	// Bit mask of WSF field.
	I2S0_TCSR_WSF_Msk = 0x100000
	// Bit WSF.
	I2S0_TCSR_WSF = 0x100000
	// Start of word not detected.
	I2S0_TCSR_WSF_0 = 0x0
	// Start of word detected.
	I2S0_TCSR_WSF_1 = 0x1
	// Position of SR field.
	I2S0_TCSR_SR_Pos = 0x18
	// Bit mask of SR field.
	I2S0_TCSR_SR_Msk = 0x1000000
	// Bit SR.
	I2S0_TCSR_SR = 0x1000000
	// No effect.
	I2S0_TCSR_SR_0 = 0x0
	// Software reset.
	I2S0_TCSR_SR_1 = 0x1
	// Position of FR field.
	I2S0_TCSR_FR_Pos = 0x19
	// Bit mask of FR field.
	I2S0_TCSR_FR_Msk = 0x2000000
	// Bit FR.
	I2S0_TCSR_FR = 0x2000000
	// No effect.
	I2S0_TCSR_FR_0 = 0x0
	// FIFO reset.
	I2S0_TCSR_FR_1 = 0x1
	// Position of BCE field.
	I2S0_TCSR_BCE_Pos = 0x1c
	// Bit mask of BCE field.
	I2S0_TCSR_BCE_Msk = 0x10000000
	// Bit BCE.
	I2S0_TCSR_BCE = 0x10000000
	// Transmit bit clock is disabled.
	I2S0_TCSR_BCE_0 = 0x0
	// Transmit bit clock is enabled.
	I2S0_TCSR_BCE_1 = 0x1
	// Position of DBGE field.
	I2S0_TCSR_DBGE_Pos = 0x1d
	// Bit mask of DBGE field.
	I2S0_TCSR_DBGE_Msk = 0x20000000
	// Bit DBGE.
	I2S0_TCSR_DBGE = 0x20000000
	// Transmitter is disabled in Debug mode, after completing the current frame.
	I2S0_TCSR_DBGE_0 = 0x0
	// Transmitter is enabled in Debug mode.
	I2S0_TCSR_DBGE_1 = 0x1
	// Position of STOPE field.
	I2S0_TCSR_STOPE_Pos = 0x1e
	// Bit mask of STOPE field.
	I2S0_TCSR_STOPE_Msk = 0x40000000
	// Bit STOPE.
	I2S0_TCSR_STOPE = 0x40000000
	// Transmitter disabled in Stop mode.
	I2S0_TCSR_STOPE_0 = 0x0
	// Transmitter enabled in Stop mode.
	I2S0_TCSR_STOPE_1 = 0x1
	// Position of TE field.
	I2S0_TCSR_TE_Pos = 0x1f
	// Bit mask of TE field.
	I2S0_TCSR_TE_Msk = 0x80000000
	// Bit TE.
	I2S0_TCSR_TE = 0x80000000
	// Transmitter is disabled.
	I2S0_TCSR_TE_0 = 0x0
	// Transmitter is enabled, or transmitter has been disabled and has not yet reached end of frame.
	I2S0_TCSR_TE_1 = 0x1

	// TCR2: SAI Transmit Configuration 2 Register
	// Position of DIV field.
	I2S0_TCR2_DIV_Pos = 0x0
	// Bit mask of DIV field.
	I2S0_TCR2_DIV_Msk = 0xff
	// Position of BCD field.
	I2S0_TCR2_BCD_Pos = 0x18
	// Bit mask of BCD field.
	I2S0_TCR2_BCD_Msk = 0x1000000
	// Bit BCD.
	I2S0_TCR2_BCD = 0x1000000
	// Bit clock is generated externally in Slave mode.
	I2S0_TCR2_BCD_0 = 0x0
	// Bit clock is generated internally in Master mode.
	I2S0_TCR2_BCD_1 = 0x1
	// Position of BCP field.
	I2S0_TCR2_BCP_Pos = 0x19
	// Bit mask of BCP field.
	I2S0_TCR2_BCP_Msk = 0x2000000
	// Bit BCP.
	I2S0_TCR2_BCP = 0x2000000
	// Bit clock is active high with drive outputs on rising edge and sample inputs on falling edge.
	I2S0_TCR2_BCP_0 = 0x0
	// Bit clock is active low with drive outputs on falling edge and sample inputs on rising edge.
	I2S0_TCR2_BCP_1 = 0x1
	// Position of MSEL field.
	I2S0_TCR2_MSEL_Pos = 0x1a
	// Bit mask of MSEL field.
	I2S0_TCR2_MSEL_Msk = 0xc000000
	// Bus Clock selected.
	I2S0_TCR2_MSEL_00 = 0x0
	// Master Clock (MCLK) 1 option selected.
	I2S0_TCR2_MSEL_01 = 0x1
	// Master Clock (MCLK) 2 option selected.
	I2S0_TCR2_MSEL_10 = 0x2
	// Master Clock (MCLK) 3 option selected.
	I2S0_TCR2_MSEL_11 = 0x3
	// Position of BCI field.
	I2S0_TCR2_BCI_Pos = 0x1c
	// Bit mask of BCI field.
	I2S0_TCR2_BCI_Msk = 0x10000000
	// Bit BCI.
	I2S0_TCR2_BCI = 0x10000000
	// No effect.
	I2S0_TCR2_BCI_0 = 0x0
	// Internal logic is clocked as if bit clock was externally generated.
	I2S0_TCR2_BCI_1 = 0x1
	// Position of BCS field.
	I2S0_TCR2_BCS_Pos = 0x1d
	// Bit mask of BCS field.
	I2S0_TCR2_BCS_Msk = 0x20000000
	// Bit BCS.
	I2S0_TCR2_BCS = 0x20000000
	// Use the normal bit clock source.
	I2S0_TCR2_BCS_0 = 0x0
	// Swap the bit clock source.
	I2S0_TCR2_BCS_1 = 0x1
	// Position of SYNC field.
	I2S0_TCR2_SYNC_Pos = 0x1e
	// Bit mask of SYNC field.
	I2S0_TCR2_SYNC_Msk = 0xc0000000
	// Asynchronous mode.
	I2S0_TCR2_SYNC_00 = 0x0
	// Synchronous with receiver.
	I2S0_TCR2_SYNC_01 = 0x1
	// Synchronous with another SAI transmitter.
	I2S0_TCR2_SYNC_10 = 0x2
	// Synchronous with another SAI receiver.
	I2S0_TCR2_SYNC_11 = 0x3

	// TCR3: SAI Transmit Configuration 3 Register
	// Position of WDFL field.
	I2S0_TCR3_WDFL_Pos = 0x0
	// Bit mask of WDFL field.
	I2S0_TCR3_WDFL_Msk = 0x1
	// Bit WDFL.
	I2S0_TCR3_WDFL = 0x1
	// Position of TCE field.
	I2S0_TCR3_TCE_Pos = 0x10
	// Bit mask of TCE field.
	I2S0_TCR3_TCE_Msk = 0x10000
	// Bit TCE.
	I2S0_TCR3_TCE = 0x10000
	// Transmit data channel N is disabled.
	I2S0_TCR3_TCE_0 = 0x0
	// Transmit data channel N is enabled.
	I2S0_TCR3_TCE_1 = 0x1

	// TCR4: SAI Transmit Configuration 4 Register
	// Position of FSD field.
	I2S0_TCR4_FSD_Pos = 0x0
	// Bit mask of FSD field.
	I2S0_TCR4_FSD_Msk = 0x1
	// Bit FSD.
	I2S0_TCR4_FSD = 0x1
	// Frame sync is generated externally in Slave mode.
	I2S0_TCR4_FSD_0 = 0x0
	// Frame sync is generated internally in Master mode.
	I2S0_TCR4_FSD_1 = 0x1
	// Position of FSP field.
	I2S0_TCR4_FSP_Pos = 0x1
	// Bit mask of FSP field.
	I2S0_TCR4_FSP_Msk = 0x2
	// Bit FSP.
	I2S0_TCR4_FSP = 0x2
	// Frame sync is active high.
	I2S0_TCR4_FSP_0 = 0x0
	// Frame sync is active low.
	I2S0_TCR4_FSP_1 = 0x1
	// Position of FSE field.
	I2S0_TCR4_FSE_Pos = 0x3
	// Bit mask of FSE field.
	I2S0_TCR4_FSE_Msk = 0x8
	// Bit FSE.
	I2S0_TCR4_FSE = 0x8
	// Frame sync asserts with the first bit of the frame.
	I2S0_TCR4_FSE_0 = 0x0
	// Frame sync asserts one bit before the first bit of the frame.
	I2S0_TCR4_FSE_1 = 0x1
	// Position of MF field.
	I2S0_TCR4_MF_Pos = 0x4
	// Bit mask of MF field.
	I2S0_TCR4_MF_Msk = 0x10
	// Bit MF.
	I2S0_TCR4_MF = 0x10
	// LSB is transmitted first.
	I2S0_TCR4_MF_0 = 0x0
	// MSB is transmitted first.
	I2S0_TCR4_MF_1 = 0x1
	// Position of SYWD field.
	I2S0_TCR4_SYWD_Pos = 0x8
	// Bit mask of SYWD field.
	I2S0_TCR4_SYWD_Msk = 0x1f00
	// Position of FRSZ field.
	I2S0_TCR4_FRSZ_Pos = 0x10
	// Bit mask of FRSZ field.
	I2S0_TCR4_FRSZ_Msk = 0x10000
	// Bit FRSZ.
	I2S0_TCR4_FRSZ = 0x10000

	// TCR5: SAI Transmit Configuration 5 Register
	// Position of FBT field.
	I2S0_TCR5_FBT_Pos = 0x8
	// Bit mask of FBT field.
	I2S0_TCR5_FBT_Msk = 0x1f00
	// Position of W0W field.
	I2S0_TCR5_W0W_Pos = 0x10
	// Bit mask of W0W field.
	I2S0_TCR5_W0W_Msk = 0x1f0000
	// Position of WNW field.
	I2S0_TCR5_WNW_Pos = 0x18
	// Bit mask of WNW field.
	I2S0_TCR5_WNW_Msk = 0x1f000000

	// TDR: SAI Transmit Data Register
	// Position of TDR field.
	I2S0_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	I2S0_TDR_TDR_Msk = 0xffffffff

	// TMR: SAI Transmit Mask Register
	// Position of TWM field.
	I2S0_TMR_TWM_Pos = 0x0
	// Bit mask of TWM field.
	I2S0_TMR_TWM_Msk = 0x3
	// Word N is enabled.
	I2S0_TMR_TWM_0 = 0x0
	// Word N is masked. The transmit data pins are tri-stated when masked.
	I2S0_TMR_TWM_1 = 0x1

	// RCSR: SAI Receive Control Register
	// Position of FWDE field.
	I2S0_RCSR_FWDE_Pos = 0x1
	// Bit mask of FWDE field.
	I2S0_RCSR_FWDE_Msk = 0x2
	// Bit FWDE.
	I2S0_RCSR_FWDE = 0x2
	// Disables the DMA request.
	I2S0_RCSR_FWDE_0 = 0x0
	// Enables the DMA request.
	I2S0_RCSR_FWDE_1 = 0x1
	// Position of FWIE field.
	I2S0_RCSR_FWIE_Pos = 0x9
	// Bit mask of FWIE field.
	I2S0_RCSR_FWIE_Msk = 0x200
	// Bit FWIE.
	I2S0_RCSR_FWIE = 0x200
	// Disables the interrupt.
	I2S0_RCSR_FWIE_0 = 0x0
	// Enables the interrupt.
	I2S0_RCSR_FWIE_1 = 0x1
	// Position of FEIE field.
	I2S0_RCSR_FEIE_Pos = 0xa
	// Bit mask of FEIE field.
	I2S0_RCSR_FEIE_Msk = 0x400
	// Bit FEIE.
	I2S0_RCSR_FEIE = 0x400
	// Disables the interrupt.
	I2S0_RCSR_FEIE_0 = 0x0
	// Enables the interrupt.
	I2S0_RCSR_FEIE_1 = 0x1
	// Position of SEIE field.
	I2S0_RCSR_SEIE_Pos = 0xb
	// Bit mask of SEIE field.
	I2S0_RCSR_SEIE_Msk = 0x800
	// Bit SEIE.
	I2S0_RCSR_SEIE = 0x800
	// Disables interrupt.
	I2S0_RCSR_SEIE_0 = 0x0
	// Enables interrupt.
	I2S0_RCSR_SEIE_1 = 0x1
	// Position of WSIE field.
	I2S0_RCSR_WSIE_Pos = 0xc
	// Bit mask of WSIE field.
	I2S0_RCSR_WSIE_Msk = 0x1000
	// Bit WSIE.
	I2S0_RCSR_WSIE = 0x1000
	// Disables interrupt.
	I2S0_RCSR_WSIE_0 = 0x0
	// Enables interrupt.
	I2S0_RCSR_WSIE_1 = 0x1
	// Position of FWF field.
	I2S0_RCSR_FWF_Pos = 0x11
	// Bit mask of FWF field.
	I2S0_RCSR_FWF_Msk = 0x20000
	// Bit FWF.
	I2S0_RCSR_FWF = 0x20000
	// No enabled receive FIFO is full.
	I2S0_RCSR_FWF_0 = 0x0
	// Enabled receive FIFO is full.
	I2S0_RCSR_FWF_1 = 0x1
	// Position of FEF field.
	I2S0_RCSR_FEF_Pos = 0x12
	// Bit mask of FEF field.
	I2S0_RCSR_FEF_Msk = 0x40000
	// Bit FEF.
	I2S0_RCSR_FEF = 0x40000
	// Receive overflow not detected.
	I2S0_RCSR_FEF_0 = 0x0
	// Receive overflow detected.
	I2S0_RCSR_FEF_1 = 0x1
	// Position of SEF field.
	I2S0_RCSR_SEF_Pos = 0x13
	// Bit mask of SEF field.
	I2S0_RCSR_SEF_Msk = 0x80000
	// Bit SEF.
	I2S0_RCSR_SEF = 0x80000
	// Sync error not detected.
	I2S0_RCSR_SEF_0 = 0x0
	// Frame sync error detected.
	I2S0_RCSR_SEF_1 = 0x1
	// Position of WSF field.
	I2S0_RCSR_WSF_Pos = 0x14
	// Bit mask of WSF field.
	I2S0_RCSR_WSF_Msk = 0x100000
	// Bit WSF.
	I2S0_RCSR_WSF = 0x100000
	// Start of word not detected.
	I2S0_RCSR_WSF_0 = 0x0
	// Start of word detected.
	I2S0_RCSR_WSF_1 = 0x1
	// Position of SR field.
	I2S0_RCSR_SR_Pos = 0x18
	// Bit mask of SR field.
	I2S0_RCSR_SR_Msk = 0x1000000
	// Bit SR.
	I2S0_RCSR_SR = 0x1000000
	// No effect.
	I2S0_RCSR_SR_0 = 0x0
	// Software reset.
	I2S0_RCSR_SR_1 = 0x1
	// Position of FR field.
	I2S0_RCSR_FR_Pos = 0x19
	// Bit mask of FR field.
	I2S0_RCSR_FR_Msk = 0x2000000
	// Bit FR.
	I2S0_RCSR_FR = 0x2000000
	// No effect.
	I2S0_RCSR_FR_0 = 0x0
	// FIFO reset.
	I2S0_RCSR_FR_1 = 0x1
	// Position of BCE field.
	I2S0_RCSR_BCE_Pos = 0x1c
	// Bit mask of BCE field.
	I2S0_RCSR_BCE_Msk = 0x10000000
	// Bit BCE.
	I2S0_RCSR_BCE = 0x10000000
	// Receive bit clock is disabled.
	I2S0_RCSR_BCE_0 = 0x0
	// Receive bit clock is enabled.
	I2S0_RCSR_BCE_1 = 0x1
	// Position of DBGE field.
	I2S0_RCSR_DBGE_Pos = 0x1d
	// Bit mask of DBGE field.
	I2S0_RCSR_DBGE_Msk = 0x20000000
	// Bit DBGE.
	I2S0_RCSR_DBGE = 0x20000000
	// Receiver is disabled in Debug mode, after completing the current frame.
	I2S0_RCSR_DBGE_0 = 0x0
	// Receiver is enabled in Debug mode.
	I2S0_RCSR_DBGE_1 = 0x1
	// Position of STOPE field.
	I2S0_RCSR_STOPE_Pos = 0x1e
	// Bit mask of STOPE field.
	I2S0_RCSR_STOPE_Msk = 0x40000000
	// Bit STOPE.
	I2S0_RCSR_STOPE = 0x40000000
	// Receiver disabled in Stop mode.
	I2S0_RCSR_STOPE_0 = 0x0
	// Receiver enabled in Stop mode.
	I2S0_RCSR_STOPE_1 = 0x1
	// Position of RE field.
	I2S0_RCSR_RE_Pos = 0x1f
	// Bit mask of RE field.
	I2S0_RCSR_RE_Msk = 0x80000000
	// Bit RE.
	I2S0_RCSR_RE = 0x80000000
	// Receiver is disabled.
	I2S0_RCSR_RE_0 = 0x0
	// Receiver is enabled, or receiver has been disabled and has not yet reached end of frame.
	I2S0_RCSR_RE_1 = 0x1

	// RCR2: SAI Receive Configuration 2 Register
	// Position of DIV field.
	I2S0_RCR2_DIV_Pos = 0x0
	// Bit mask of DIV field.
	I2S0_RCR2_DIV_Msk = 0xff
	// Position of BCD field.
	I2S0_RCR2_BCD_Pos = 0x18
	// Bit mask of BCD field.
	I2S0_RCR2_BCD_Msk = 0x1000000
	// Bit BCD.
	I2S0_RCR2_BCD = 0x1000000
	// Bit clock is generated externally in Slave mode.
	I2S0_RCR2_BCD_0 = 0x0
	// Bit clock is generated internally in Master mode.
	I2S0_RCR2_BCD_1 = 0x1
	// Position of BCP field.
	I2S0_RCR2_BCP_Pos = 0x19
	// Bit mask of BCP field.
	I2S0_RCR2_BCP_Msk = 0x2000000
	// Bit BCP.
	I2S0_RCR2_BCP = 0x2000000
	// Bit Clock is active high with drive outputs on rising edge and sample inputs on falling edge.
	I2S0_RCR2_BCP_0 = 0x0
	// Bit Clock is active low with drive outputs on falling edge and sample inputs on rising edge.
	I2S0_RCR2_BCP_1 = 0x1
	// Position of MSEL field.
	I2S0_RCR2_MSEL_Pos = 0x1a
	// Bit mask of MSEL field.
	I2S0_RCR2_MSEL_Msk = 0xc000000
	// Bus Clock selected.
	I2S0_RCR2_MSEL_00 = 0x0
	// Master Clock (MCLK) 1 option selected.
	I2S0_RCR2_MSEL_01 = 0x1
	// Master Clock (MCLK) 2 option selected.
	I2S0_RCR2_MSEL_10 = 0x2
	// Master Clock (MCLK) 3 option selected.
	I2S0_RCR2_MSEL_11 = 0x3
	// Position of BCI field.
	I2S0_RCR2_BCI_Pos = 0x1c
	// Bit mask of BCI field.
	I2S0_RCR2_BCI_Msk = 0x10000000
	// Bit BCI.
	I2S0_RCR2_BCI = 0x10000000
	// No effect.
	I2S0_RCR2_BCI_0 = 0x0
	// Internal logic is clocked as if bit clock was externally generated.
	I2S0_RCR2_BCI_1 = 0x1
	// Position of BCS field.
	I2S0_RCR2_BCS_Pos = 0x1d
	// Bit mask of BCS field.
	I2S0_RCR2_BCS_Msk = 0x20000000
	// Bit BCS.
	I2S0_RCR2_BCS = 0x20000000
	// Use the normal bit clock source.
	I2S0_RCR2_BCS_0 = 0x0
	// Swap the bit clock source.
	I2S0_RCR2_BCS_1 = 0x1
	// Position of SYNC field.
	I2S0_RCR2_SYNC_Pos = 0x1e
	// Bit mask of SYNC field.
	I2S0_RCR2_SYNC_Msk = 0xc0000000
	// Asynchronous mode.
	I2S0_RCR2_SYNC_00 = 0x0
	// Synchronous with transmitter.
	I2S0_RCR2_SYNC_01 = 0x1
	// Synchronous with another SAI receiver.
	I2S0_RCR2_SYNC_10 = 0x2
	// Synchronous with another SAI transmitter.
	I2S0_RCR2_SYNC_11 = 0x3

	// RCR3: SAI Receive Configuration 3 Register
	// Position of WDFL field.
	I2S0_RCR3_WDFL_Pos = 0x0
	// Bit mask of WDFL field.
	I2S0_RCR3_WDFL_Msk = 0x1
	// Bit WDFL.
	I2S0_RCR3_WDFL = 0x1
	// Position of RCE field.
	I2S0_RCR3_RCE_Pos = 0x10
	// Bit mask of RCE field.
	I2S0_RCR3_RCE_Msk = 0x10000
	// Bit RCE.
	I2S0_RCR3_RCE = 0x10000
	// Receive data channel N is disabled.
	I2S0_RCR3_RCE_0 = 0x0
	// Receive data channel N is enabled.
	I2S0_RCR3_RCE_1 = 0x1

	// RCR4: SAI Receive Configuration 4 Register
	// Position of FSD field.
	I2S0_RCR4_FSD_Pos = 0x0
	// Bit mask of FSD field.
	I2S0_RCR4_FSD_Msk = 0x1
	// Bit FSD.
	I2S0_RCR4_FSD = 0x1
	// Frame Sync is generated externally in Slave mode.
	I2S0_RCR4_FSD_0 = 0x0
	// Frame Sync is generated internally in Master mode.
	I2S0_RCR4_FSD_1 = 0x1
	// Position of FSP field.
	I2S0_RCR4_FSP_Pos = 0x1
	// Bit mask of FSP field.
	I2S0_RCR4_FSP_Msk = 0x2
	// Bit FSP.
	I2S0_RCR4_FSP = 0x2
	// Frame sync is active high.
	I2S0_RCR4_FSP_0 = 0x0
	// Frame sync is active low.
	I2S0_RCR4_FSP_1 = 0x1
	// Position of FSE field.
	I2S0_RCR4_FSE_Pos = 0x3
	// Bit mask of FSE field.
	I2S0_RCR4_FSE_Msk = 0x8
	// Bit FSE.
	I2S0_RCR4_FSE = 0x8
	// Frame sync asserts with the first bit of the frame.
	I2S0_RCR4_FSE_0 = 0x0
	// Frame sync asserts one bit before the first bit of the frame.
	I2S0_RCR4_FSE_1 = 0x1
	// Position of MF field.
	I2S0_RCR4_MF_Pos = 0x4
	// Bit mask of MF field.
	I2S0_RCR4_MF_Msk = 0x10
	// Bit MF.
	I2S0_RCR4_MF = 0x10
	// LSB is received first.
	I2S0_RCR4_MF_0 = 0x0
	// MSB is received first.
	I2S0_RCR4_MF_1 = 0x1
	// Position of SYWD field.
	I2S0_RCR4_SYWD_Pos = 0x8
	// Bit mask of SYWD field.
	I2S0_RCR4_SYWD_Msk = 0x1f00
	// Position of FRSZ field.
	I2S0_RCR4_FRSZ_Pos = 0x10
	// Bit mask of FRSZ field.
	I2S0_RCR4_FRSZ_Msk = 0x10000
	// Bit FRSZ.
	I2S0_RCR4_FRSZ = 0x10000

	// RCR5: SAI Receive Configuration 5 Register
	// Position of FBT field.
	I2S0_RCR5_FBT_Pos = 0x8
	// Bit mask of FBT field.
	I2S0_RCR5_FBT_Msk = 0x1f00
	// Position of W0W field.
	I2S0_RCR5_W0W_Pos = 0x10
	// Bit mask of W0W field.
	I2S0_RCR5_W0W_Msk = 0x1f0000
	// Position of WNW field.
	I2S0_RCR5_WNW_Pos = 0x18
	// Bit mask of WNW field.
	I2S0_RCR5_WNW_Msk = 0x1f000000

	// RDR: SAI Receive Data Register
	// Position of RDR field.
	I2S0_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	I2S0_RDR_RDR_Msk = 0xffffffff

	// RMR: SAI Receive Mask Register
	// Position of RWM field.
	I2S0_RMR_RWM_Pos = 0x0
	// Bit mask of RWM field.
	I2S0_RMR_RWM_Msk = 0x3
	// Word N is enabled.
	I2S0_RMR_RWM_0 = 0x0
	// Word N is masked.
	I2S0_RMR_RWM_1 = 0x1

	// MCR: SAI MCLK Control Register
	// Position of MICS field.
	I2S0_MCR_MICS_Pos = 0x18
	// Bit mask of MICS field.
	I2S0_MCR_MICS_Msk = 0x3000000
	// MCLK divider input clock 0 selected.
	I2S0_MCR_MICS_00 = 0x0
	// MCLK divider input clock 1 selected.
	I2S0_MCR_MICS_01 = 0x1
	// MCLK divider input clock 2 selected.
	I2S0_MCR_MICS_10 = 0x2
	// MCLK divider input clock 3 selected.
	I2S0_MCR_MICS_11 = 0x3
	// Position of MOE field.
	I2S0_MCR_MOE_Pos = 0x1e
	// Bit mask of MOE field.
	I2S0_MCR_MOE_Msk = 0x40000000
	// Bit MOE.
	I2S0_MCR_MOE = 0x40000000
	// MCLK signal pin is configured as an input that bypasses the MCLK divider.
	I2S0_MCR_MOE_0 = 0x0
	// MCLK signal pin is configured as an output from the MCLK divider and the MCLK divider is enabled.
	I2S0_MCR_MOE_1 = 0x1
	// Position of DUF field.
	I2S0_MCR_DUF_Pos = 0x1f
	// Bit mask of DUF field.
	I2S0_MCR_DUF_Msk = 0x80000000
	// Bit DUF.
	I2S0_MCR_DUF = 0x80000000
	// MCLK divider ratio is not being updated currently.
	I2S0_MCR_DUF_0 = 0x0
	// MCLK divider ratio is updating on-the-fly. Further updates to the MCLK divider ratio are blocked while this flag remains set.
	I2S0_MCR_DUF_1 = 0x1

	// MDR: SAI MCLK Divide Register
	// Position of DIVIDE field.
	I2S0_MDR_DIVIDE_Pos = 0x0
	// Bit mask of DIVIDE field.
	I2S0_MDR_DIVIDE_Msk = 0xfff
	// Position of FRACT field.
	I2S0_MDR_FRACT_Pos = 0xc
	// Bit mask of FRACT field.
	I2S0_MDR_FRACT_Msk = 0xff000
)

// Constants for PIT: Periodic Interrupt Timer
const (
	// MCR: PIT Module Control Register
	// Position of FRZ field.
	PIT_MCR_FRZ_Pos = 0x0
	// Bit mask of FRZ field.
	PIT_MCR_FRZ_Msk = 0x1
	// Bit FRZ.
	PIT_MCR_FRZ = 0x1
	// Timers continue to run in Debug mode.
	PIT_MCR_FRZ_0 = 0x0
	// Timers are stopped in Debug mode.
	PIT_MCR_FRZ_1 = 0x1
	// Position of MDIS field.
	PIT_MCR_MDIS_Pos = 0x1
	// Bit mask of MDIS field.
	PIT_MCR_MDIS_Msk = 0x2
	// Bit MDIS.
	PIT_MCR_MDIS = 0x2
	// Clock for standard PIT timers is enabled.
	PIT_MCR_MDIS_0 = 0x0
	// Clock for standard PIT timers is disabled.
	PIT_MCR_MDIS_1 = 0x1

	// LTMR64H: PIT Upper Lifetime Timer Register
	// Position of LTH field.
	PIT_LTMR64H_LTH_Pos = 0x0
	// Bit mask of LTH field.
	PIT_LTMR64H_LTH_Msk = 0xffffffff

	// LTMR64L: PIT Lower Lifetime Timer Register
	// Position of LTL field.
	PIT_LTMR64L_LTL_Pos = 0x0
	// Bit mask of LTL field.
	PIT_LTMR64L_LTL_Msk = 0xffffffff

	// LDVAL0: Timer Load Value Register
	// Position of TSV field.
	PIT_LDVAL_TSV_Pos = 0x0
	// Bit mask of TSV field.
	PIT_LDVAL_TSV_Msk = 0xffffffff

	// CVAL0: Current Timer Value Register
	// Position of TVL field.
	PIT_CVAL_TVL_Pos = 0x0
	// Bit mask of TVL field.
	PIT_CVAL_TVL_Msk = 0xffffffff

	// TCTRL0: Timer Control Register
	// Position of TEN field.
	PIT_TCTRL_TEN_Pos = 0x0
	// Bit mask of TEN field.
	PIT_TCTRL_TEN_Msk = 0x1
	// Bit TEN.
	PIT_TCTRL_TEN = 0x1
	// Timer n is disabled.
	PIT_TCTRL_TEN_0 = 0x0
	// Timer n is enabled.
	PIT_TCTRL_TEN_1 = 0x1
	// Position of TIE field.
	PIT_TCTRL_TIE_Pos = 0x1
	// Bit mask of TIE field.
	PIT_TCTRL_TIE_Msk = 0x2
	// Bit TIE.
	PIT_TCTRL_TIE = 0x2
	// Interrupt requests from Timer n are disabled.
	PIT_TCTRL_TIE_0 = 0x0
	// Interrupt will be requested whenever TIF is set.
	PIT_TCTRL_TIE_1 = 0x1
	// Position of CHN field.
	PIT_TCTRL_CHN_Pos = 0x2
	// Bit mask of CHN field.
	PIT_TCTRL_CHN_Msk = 0x4
	// Bit CHN.
	PIT_TCTRL_CHN = 0x4
	// Timer is not chained.
	PIT_TCTRL_CHN_0 = 0x0
	// Timer is chained to previous timer. For example, for Channel 2, if this field is set, Timer 2 is chained to Timer 1.
	PIT_TCTRL_CHN_1 = 0x1

	// TFLG0: Timer Flag Register
	// Position of TIF field.
	PIT_TFLG_TIF_Pos = 0x0
	// Bit mask of TIF field.
	PIT_TFLG_TIF_Msk = 0x1
	// Bit TIF.
	PIT_TFLG_TIF = 0x1
	// Timeout has not yet occurred.
	PIT_TFLG_TIF_0 = 0x0
	// Timeout has occurred.
	PIT_TFLG_TIF_1 = 0x1
)

// Constants for TPM0: Timer/PWM Module
const (
	// SC: Status and Control
	// Position of PS field.
	TPM_SC_PS_Pos = 0x0
	// Bit mask of PS field.
	TPM_SC_PS_Msk = 0x7
	// Divide by 1
	TPM_SC_PS_000 = 0x0
	// Divide by 2
	TPM_SC_PS_001 = 0x1
	// Divide by 4
	TPM_SC_PS_010 = 0x2
	// Divide by 8
	TPM_SC_PS_011 = 0x3
	// Divide by 16
	TPM_SC_PS_100 = 0x4
	// Divide by 32
	TPM_SC_PS_101 = 0x5
	// Divide by 64
	TPM_SC_PS_110 = 0x6
	// Divide by 128
	TPM_SC_PS_111 = 0x7
	// Position of CMOD field.
	TPM_SC_CMOD_Pos = 0x3
	// Bit mask of CMOD field.
	TPM_SC_CMOD_Msk = 0x18
	// TPM counter is disabled
	TPM_SC_CMOD_00 = 0x0
	// TPM counter increments on every TPM counter clock
	TPM_SC_CMOD_01 = 0x1
	// TPM counter increments on rising edge of TPM_EXTCLK synchronized to the TPM counter clock
	TPM_SC_CMOD_10 = 0x2
	// Position of CPWMS field.
	TPM_SC_CPWMS_Pos = 0x5
	// Bit mask of CPWMS field.
	TPM_SC_CPWMS_Msk = 0x20
	// Bit CPWMS.
	TPM_SC_CPWMS = 0x20
	// TPM counter operates in up counting mode.
	TPM_SC_CPWMS_0 = 0x0
	// TPM counter operates in up-down counting mode.
	TPM_SC_CPWMS_1 = 0x1
	// Position of TOIE field.
	TPM_SC_TOIE_Pos = 0x6
	// Bit mask of TOIE field.
	TPM_SC_TOIE_Msk = 0x40
	// Bit TOIE.
	TPM_SC_TOIE = 0x40
	// Disable TOF interrupts. Use software polling or DMA request.
	TPM_SC_TOIE_0 = 0x0
	// Enable TOF interrupts. An interrupt is generated when TOF equals one.
	TPM_SC_TOIE_1 = 0x1
	// Position of TOF field.
	TPM_SC_TOF_Pos = 0x7
	// Bit mask of TOF field.
	TPM_SC_TOF_Msk = 0x80
	// Bit TOF.
	TPM_SC_TOF = 0x80
	// TPM counter has not overflowed.
	TPM_SC_TOF_0 = 0x0
	// TPM counter has overflowed.
	TPM_SC_TOF_1 = 0x1
	// Position of DMA field.
	TPM_SC_DMA_Pos = 0x8
	// Bit mask of DMA field.
	TPM_SC_DMA_Msk = 0x100
	// Bit DMA.
	TPM_SC_DMA = 0x100
	// Disables DMA transfers.
	TPM_SC_DMA_0 = 0x0
	// Enables DMA transfers.
	TPM_SC_DMA_1 = 0x1

	// CNT: Counter
	// Position of COUNT field.
	TPM_CNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TPM_CNT_COUNT_Msk = 0xffff

	// MOD: Modulo
	// Position of MOD field.
	TPM_MOD_MOD_Pos = 0x0
	// Bit mask of MOD field.
	TPM_MOD_MOD_Msk = 0xffff

	// C0SC: Channel (n) Status and Control
	// Position of DMA field.
	TPM_CSC_DMA_Pos = 0x0
	// Bit mask of DMA field.
	TPM_CSC_DMA_Msk = 0x1
	// Bit DMA.
	TPM_CSC_DMA = 0x1
	// Disable DMA transfers.
	TPM_CSC_DMA_0 = 0x0
	// Enable DMA transfers.
	TPM_CSC_DMA_1 = 0x1
	// Position of ELSA field.
	TPM_CSC_ELSA_Pos = 0x2
	// Bit mask of ELSA field.
	TPM_CSC_ELSA_Msk = 0x4
	// Bit ELSA.
	TPM_CSC_ELSA = 0x4
	// Position of ELSB field.
	TPM_CSC_ELSB_Pos = 0x3
	// Bit mask of ELSB field.
	TPM_CSC_ELSB_Msk = 0x8
	// Bit ELSB.
	TPM_CSC_ELSB = 0x8
	// Position of MSA field.
	TPM_CSC_MSA_Pos = 0x4
	// Bit mask of MSA field.
	TPM_CSC_MSA_Msk = 0x10
	// Bit MSA.
	TPM_CSC_MSA = 0x10
	// Position of MSB field.
	TPM_CSC_MSB_Pos = 0x5
	// Bit mask of MSB field.
	TPM_CSC_MSB_Msk = 0x20
	// Bit MSB.
	TPM_CSC_MSB = 0x20
	// Position of CHIE field.
	TPM_CSC_CHIE_Pos = 0x6
	// Bit mask of CHIE field.
	TPM_CSC_CHIE_Msk = 0x40
	// Bit CHIE.
	TPM_CSC_CHIE = 0x40
	// Disable channel interrupts.
	TPM_CSC_CHIE_0 = 0x0
	// Enable channel interrupts.
	TPM_CSC_CHIE_1 = 0x1
	// Position of CHF field.
	TPM_CSC_CHF_Pos = 0x7
	// Bit mask of CHF field.
	TPM_CSC_CHF_Msk = 0x80
	// Bit CHF.
	TPM_CSC_CHF = 0x80
	// No channel event has occurred.
	TPM_CSC_CHF_0 = 0x0
	// A channel event has occurred.
	TPM_CSC_CHF_1 = 0x1

	// C0V: Channel (n) Value
	// Position of VAL field.
	TPM_CV_VAL_Pos = 0x0
	// Bit mask of VAL field.
	TPM_CV_VAL_Msk = 0xffff

	// STATUS: Capture and Compare Status
	// Position of CH0F field.
	TPM_STATUS_CH0F_Pos = 0x0
	// Bit mask of CH0F field.
	TPM_STATUS_CH0F_Msk = 0x1
	// Bit CH0F.
	TPM_STATUS_CH0F = 0x1
	// No channel event has occurred.
	TPM_STATUS_CH0F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH0F_1 = 0x1
	// Position of CH1F field.
	TPM_STATUS_CH1F_Pos = 0x1
	// Bit mask of CH1F field.
	TPM_STATUS_CH1F_Msk = 0x2
	// Bit CH1F.
	TPM_STATUS_CH1F = 0x2
	// No channel event has occurred.
	TPM_STATUS_CH1F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH1F_1 = 0x1
	// Position of CH2F field.
	TPM_STATUS_CH2F_Pos = 0x2
	// Bit mask of CH2F field.
	TPM_STATUS_CH2F_Msk = 0x4
	// Bit CH2F.
	TPM_STATUS_CH2F = 0x4
	// No channel event has occurred.
	TPM_STATUS_CH2F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH2F_1 = 0x1
	// Position of CH3F field.
	TPM_STATUS_CH3F_Pos = 0x3
	// Bit mask of CH3F field.
	TPM_STATUS_CH3F_Msk = 0x8
	// Bit CH3F.
	TPM_STATUS_CH3F = 0x8
	// No channel event has occurred.
	TPM_STATUS_CH3F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH3F_1 = 0x1
	// Position of CH4F field.
	TPM_STATUS_CH4F_Pos = 0x4
	// Bit mask of CH4F field.
	TPM_STATUS_CH4F_Msk = 0x10
	// Bit CH4F.
	TPM_STATUS_CH4F = 0x10
	// No channel event has occurred.
	TPM_STATUS_CH4F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH4F_1 = 0x1
	// Position of CH5F field.
	TPM_STATUS_CH5F_Pos = 0x5
	// Bit mask of CH5F field.
	TPM_STATUS_CH5F_Msk = 0x20
	// Bit CH5F.
	TPM_STATUS_CH5F = 0x20
	// No channel event has occurred.
	TPM_STATUS_CH5F_0 = 0x0
	// A channel event has occurred.
	TPM_STATUS_CH5F_1 = 0x1
	// Position of TOF field.
	TPM_STATUS_TOF_Pos = 0x8
	// Bit mask of TOF field.
	TPM_STATUS_TOF_Msk = 0x100
	// Bit TOF.
	TPM_STATUS_TOF = 0x100
	// TPM counter has not overflowed.
	TPM_STATUS_TOF_0 = 0x0
	// TPM counter has overflowed.
	TPM_STATUS_TOF_1 = 0x1

	// CONF: Configuration
	// Position of DOZEEN field.
	TPM_CONF_DOZEEN_Pos = 0x5
	// Bit mask of DOZEEN field.
	TPM_CONF_DOZEEN_Msk = 0x20
	// Bit DOZEEN.
	TPM_CONF_DOZEEN = 0x20
	// Internal TPM counter continues in Doze mode.
	TPM_CONF_DOZEEN_0 = 0x0
	// Internal TPM counter is paused and does not increment during Doze mode. Trigger inputs and input capture events are also ignored.
	TPM_CONF_DOZEEN_1 = 0x1
	// Position of DBGMODE field.
	TPM_CONF_DBGMODE_Pos = 0x6
	// Bit mask of DBGMODE field.
	TPM_CONF_DBGMODE_Msk = 0xc0
	// TPM counter is paused and does not increment during debug mode. Trigger inputs and input capture events are also ignored.
	TPM_CONF_DBGMODE_00 = 0x0
	// TPM counter continues in debug mode.
	TPM_CONF_DBGMODE_11 = 0x3
	// Position of GTBEEN field.
	TPM_CONF_GTBEEN_Pos = 0x9
	// Bit mask of GTBEEN field.
	TPM_CONF_GTBEEN_Msk = 0x200
	// Bit GTBEEN.
	TPM_CONF_GTBEEN = 0x200
	// All channels use the internally generated TPM counter as their timebase
	TPM_CONF_GTBEEN_0 = 0x0
	// All channels use an externally generated global timebase as their timebase
	TPM_CONF_GTBEEN_1 = 0x1
	// Position of CSOT field.
	TPM_CONF_CSOT_Pos = 0x10
	// Bit mask of CSOT field.
	TPM_CONF_CSOT_Msk = 0x10000
	// Bit CSOT.
	TPM_CONF_CSOT = 0x10000
	// TPM counter starts to increment immediately, once it is enabled.
	TPM_CONF_CSOT_0 = 0x0
	// TPM counter only starts to increment when it a rising edge on the selected input trigger is detected, after it has been enabled or after it has stopped due to overflow.
	TPM_CONF_CSOT_1 = 0x1
	// Position of CSOO field.
	TPM_CONF_CSOO_Pos = 0x11
	// Bit mask of CSOO field.
	TPM_CONF_CSOO_Msk = 0x20000
	// Bit CSOO.
	TPM_CONF_CSOO = 0x20000
	// TPM counter continues incrementing or decrementing after overflow
	TPM_CONF_CSOO_0 = 0x0
	// TPM counter stops incrementing or decrementing after overflow.
	TPM_CONF_CSOO_1 = 0x1
	// Position of CROT field.
	TPM_CONF_CROT_Pos = 0x12
	// Bit mask of CROT field.
	TPM_CONF_CROT_Msk = 0x40000
	// Bit CROT.
	TPM_CONF_CROT = 0x40000
	// Counter is not reloaded due to a rising edge on the selected input trigger
	TPM_CONF_CROT_0 = 0x0
	// Counter is reloaded when a rising edge is detected on the selected input trigger
	TPM_CONF_CROT_1 = 0x1
	// Position of TRGSEL field.
	TPM_CONF_TRGSEL_Pos = 0x18
	// Bit mask of TRGSEL field.
	TPM_CONF_TRGSEL_Msk = 0xf000000
)

// Constants for ADC0: Analog-to-Digital Converter
const (
	// SC1A: ADC Status and Control Registers 1
	// Position of ADCH field.
	ADC0_SC1_ADCH_Pos = 0x0
	// Bit mask of ADCH field.
	ADC0_SC1_ADCH_Msk = 0x1f
	// When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is selected as input.
	ADC0_SC1_ADCH_00000 = 0x0
	// When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is selected as input.
	ADC0_SC1_ADCH_00001 = 0x1
	// When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is selected as input.
	ADC0_SC1_ADCH_00010 = 0x2
	// When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is selected as input.
	ADC0_SC1_ADCH_00011 = 0x3
	// When DIFF=0, AD4 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00100 = 0x4
	// When DIFF=0, AD5 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00101 = 0x5
	// When DIFF=0, AD6 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00110 = 0x6
	// When DIFF=0, AD7 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_00111 = 0x7
	// When DIFF=0, AD8 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01000 = 0x8
	// When DIFF=0, AD9 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01001 = 0x9
	// When DIFF=0, AD10 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01010 = 0xa
	// When DIFF=0, AD11 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01011 = 0xb
	// When DIFF=0, AD12 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01100 = 0xc
	// When DIFF=0, AD13 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01101 = 0xd
	// When DIFF=0, AD14 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01110 = 0xe
	// When DIFF=0, AD15 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_01111 = 0xf
	// When DIFF=0, AD16 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10000 = 0x10
	// When DIFF=0, AD17 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10001 = 0x11
	// When DIFF=0, AD18 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10010 = 0x12
	// When DIFF=0, AD19 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10011 = 0x13
	// When DIFF=0, AD20 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10100 = 0x14
	// When DIFF=0, AD21 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10101 = 0x15
	// When DIFF=0, AD22 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10110 = 0x16
	// When DIFF=0, AD23 is selected as input; when DIFF=1, it is reserved.
	ADC0_SC1_ADCH_10111 = 0x17
	// When DIFF=0, Temp Sensor (single-ended) is selected as input; when DIFF=1, Temp Sensor (differential) is selected as input.
	ADC0_SC1_ADCH_11010 = 0x1a
	// When DIFF=0, Bandgap (single-ended) is selected as input; when DIFF=1, Bandgap (differential) is selected as input.
	ADC0_SC1_ADCH_11011 = 0x1b
	// When DIFF=0,VREFSH is selected as input; when DIFF=1, -VREFSH (differential) is selected as input. Voltage reference selected is determined by SC2[REFSEL].
	ADC0_SC1_ADCH_11101 = 0x1d
	// When DIFF=0,VREFSL is selected as input; when DIFF=1, it is reserved. Voltage reference selected is determined by SC2[REFSEL].
	ADC0_SC1_ADCH_11110 = 0x1e
	// Module is disabled.
	ADC0_SC1_ADCH_11111 = 0x1f
	// Position of DIFF field.
	ADC0_SC1_DIFF_Pos = 0x5
	// Bit mask of DIFF field.
	ADC0_SC1_DIFF_Msk = 0x20
	// Bit DIFF.
	ADC0_SC1_DIFF = 0x20
	// Single-ended conversions and input channels are selected.
	ADC0_SC1_DIFF_0 = 0x0
	// Differential conversions and input channels are selected.
	ADC0_SC1_DIFF_1 = 0x1
	// Position of AIEN field.
	ADC0_SC1_AIEN_Pos = 0x6
	// Bit mask of AIEN field.
	ADC0_SC1_AIEN_Msk = 0x40
	// Bit AIEN.
	ADC0_SC1_AIEN = 0x40
	// Conversion complete interrupt is disabled.
	ADC0_SC1_AIEN_0 = 0x0
	// Conversion complete interrupt is enabled.
	ADC0_SC1_AIEN_1 = 0x1
	// Position of COCO field.
	ADC0_SC1_COCO_Pos = 0x7
	// Bit mask of COCO field.
	ADC0_SC1_COCO_Msk = 0x80
	// Bit COCO.
	ADC0_SC1_COCO = 0x80
	// Conversion is not completed.
	ADC0_SC1_COCO_0 = 0x0
	// Conversion is completed.
	ADC0_SC1_COCO_1 = 0x1

	// CFG1: ADC Configuration Register 1
	// Position of ADICLK field.
	ADC0_CFG1_ADICLK_Pos = 0x0
	// Bit mask of ADICLK field.
	ADC0_CFG1_ADICLK_Msk = 0x3
	// Bus clock
	ADC0_CFG1_ADICLK_00 = 0x0
	// Alternate clock 2 (ALTCLK2)
	ADC0_CFG1_ADICLK_01 = 0x1
	// Alternate clock (ALTCLK)
	ADC0_CFG1_ADICLK_10 = 0x2
	// Asynchronous clock (ADACK)
	ADC0_CFG1_ADICLK_11 = 0x3
	// Position of MODE field.
	ADC0_CFG1_MODE_Pos = 0x2
	// Bit mask of MODE field.
	ADC0_CFG1_MODE_Msk = 0xc
	// When DIFF=0:It is single-ended 8-bit conversion; when DIFF=1, it is differential 9-bit conversion with 2's complement output.
	ADC0_CFG1_MODE_00 = 0x0
	// When DIFF=0:It is single-ended 12-bit conversion ; when DIFF=1, it is differential 13-bit conversion with 2's complement output.
	ADC0_CFG1_MODE_01 = 0x1
	// When DIFF=0:It is single-ended 10-bit conversion. ; when DIFF=1, it is differential 11-bit conversion with 2's complement output
	ADC0_CFG1_MODE_10 = 0x2
	// When DIFF=0:It is single-ended 16-bit conversion..; when DIFF=1, it is differential 16-bit conversion with 2's complement output
	ADC0_CFG1_MODE_11 = 0x3
	// Position of ADLSMP field.
	ADC0_CFG1_ADLSMP_Pos = 0x4
	// Bit mask of ADLSMP field.
	ADC0_CFG1_ADLSMP_Msk = 0x10
	// Bit ADLSMP.
	ADC0_CFG1_ADLSMP = 0x10
	// Short sample time.
	ADC0_CFG1_ADLSMP_0 = 0x0
	// Long sample time.
	ADC0_CFG1_ADLSMP_1 = 0x1
	// Position of ADIV field.
	ADC0_CFG1_ADIV_Pos = 0x5
	// Bit mask of ADIV field.
	ADC0_CFG1_ADIV_Msk = 0x60
	// The divide ratio is 1 and the clock rate is input clock.
	ADC0_CFG1_ADIV_00 = 0x0
	// The divide ratio is 2 and the clock rate is (input clock)/2.
	ADC0_CFG1_ADIV_01 = 0x1
	// The divide ratio is 4 and the clock rate is (input clock)/4.
	ADC0_CFG1_ADIV_10 = 0x2
	// The divide ratio is 8 and the clock rate is (input clock)/8.
	ADC0_CFG1_ADIV_11 = 0x3
	// Position of ADLPC field.
	ADC0_CFG1_ADLPC_Pos = 0x7
	// Bit mask of ADLPC field.
	ADC0_CFG1_ADLPC_Msk = 0x80
	// Bit ADLPC.
	ADC0_CFG1_ADLPC = 0x80
	// Normal power configuration.
	ADC0_CFG1_ADLPC_0 = 0x0
	// Low-power configuration. The power is reduced at the expense of maximum clock speed.
	ADC0_CFG1_ADLPC_1 = 0x1

	// CFG2: ADC Configuration Register 2
	// Position of ADLSTS field.
	ADC0_CFG2_ADLSTS_Pos = 0x0
	// Bit mask of ADLSTS field.
	ADC0_CFG2_ADLSTS_Msk = 0x3
	// Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles total.
	ADC0_CFG2_ADLSTS_00 = 0x0
	// 12 extra ADCK cycles; 16 ADCK cycles total sample time.
	ADC0_CFG2_ADLSTS_01 = 0x1
	// 6 extra ADCK cycles; 10 ADCK cycles total sample time.
	ADC0_CFG2_ADLSTS_10 = 0x2
	// 2 extra ADCK cycles; 6 ADCK cycles total sample time.
	ADC0_CFG2_ADLSTS_11 = 0x3
	// Position of ADHSC field.
	ADC0_CFG2_ADHSC_Pos = 0x2
	// Bit mask of ADHSC field.
	ADC0_CFG2_ADHSC_Msk = 0x4
	// Bit ADHSC.
	ADC0_CFG2_ADHSC = 0x4
	// Normal conversion sequence selected.
	ADC0_CFG2_ADHSC_0 = 0x0
	// High-speed conversion sequence selected with 2 additional ADCK cycles to total conversion time.
	ADC0_CFG2_ADHSC_1 = 0x1
	// Position of ADACKEN field.
	ADC0_CFG2_ADACKEN_Pos = 0x3
	// Bit mask of ADACKEN field.
	ADC0_CFG2_ADACKEN_Msk = 0x8
	// Bit ADACKEN.
	ADC0_CFG2_ADACKEN = 0x8
	// Asynchronous clock output disabled; Asynchronous clock is enabled only if selected by ADICLK and a conversion is active.
	ADC0_CFG2_ADACKEN_0 = 0x0
	// Asynchronous clock and clock output is enabled regardless of the state of the ADC.
	ADC0_CFG2_ADACKEN_1 = 0x1
	// Position of MUXSEL field.
	ADC0_CFG2_MUXSEL_Pos = 0x4
	// Bit mask of MUXSEL field.
	ADC0_CFG2_MUXSEL_Msk = 0x10
	// Bit MUXSEL.
	ADC0_CFG2_MUXSEL = 0x10
	// ADxxa channels are selected.
	ADC0_CFG2_MUXSEL_0 = 0x0
	// ADxxb channels are selected.
	ADC0_CFG2_MUXSEL_1 = 0x1

	// RA: ADC Data Result Register
	// Position of D field.
	ADC0_R_D_Pos = 0x0
	// Bit mask of D field.
	ADC0_R_D_Msk = 0xffff

	// CV1: Compare Value Registers
	// Position of CV field.
	ADC0_CV_CV_Pos = 0x0
	// Bit mask of CV field.
	ADC0_CV_CV_Msk = 0xffff

	// SC2: Status and Control Register 2
	// Position of REFSEL field.
	ADC0_SC2_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	ADC0_SC2_REFSEL_Msk = 0x3
	// Default voltage reference pin pair, that is, external pins VREFH and VREFL
	ADC0_SC2_REFSEL_00 = 0x0
	// Alternate reference pair, that is, VALTH and VALTL . This pair may be additional external pins or internal sources depending on the MCU configuration. See the chip configuration information for details specific to this MCU
	ADC0_SC2_REFSEL_01 = 0x1
	// Position of DMAEN field.
	ADC0_SC2_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	ADC0_SC2_DMAEN_Msk = 0x4
	// Bit DMAEN.
	ADC0_SC2_DMAEN = 0x4
	// DMA is disabled.
	ADC0_SC2_DMAEN_0 = 0x0
	// DMA is enabled and will assert the ADC DMA request during an ADC conversion complete event noted when any of the SC1n[COCO] flags is asserted.
	ADC0_SC2_DMAEN_1 = 0x1
	// Position of ACREN field.
	ADC0_SC2_ACREN_Pos = 0x3
	// Bit mask of ACREN field.
	ADC0_SC2_ACREN_Msk = 0x8
	// Bit ACREN.
	ADC0_SC2_ACREN = 0x8
	// Range function disabled. Only CV1 is compared.
	ADC0_SC2_ACREN_0 = 0x0
	// Range function enabled. Both CV1 and CV2 are compared.
	ADC0_SC2_ACREN_1 = 0x1
	// Position of ACFGT field.
	ADC0_SC2_ACFGT_Pos = 0x4
	// Bit mask of ACFGT field.
	ADC0_SC2_ACFGT_Msk = 0x10
	// Bit ACFGT.
	ADC0_SC2_ACFGT = 0x10
	// Configures less than threshold, outside range not inclusive and inside range not inclusive; functionality based on the values placed in CV1 and CV2.
	ADC0_SC2_ACFGT_0 = 0x0
	// Configures greater than or equal to threshold, outside and inside ranges inclusive; functionality based on the values placed in CV1 and CV2.
	ADC0_SC2_ACFGT_1 = 0x1
	// Position of ACFE field.
	ADC0_SC2_ACFE_Pos = 0x5
	// Bit mask of ACFE field.
	ADC0_SC2_ACFE_Msk = 0x20
	// Bit ACFE.
	ADC0_SC2_ACFE = 0x20
	// Compare function disabled.
	ADC0_SC2_ACFE_0 = 0x0
	// Compare function enabled.
	ADC0_SC2_ACFE_1 = 0x1
	// Position of ADTRG field.
	ADC0_SC2_ADTRG_Pos = 0x6
	// Bit mask of ADTRG field.
	ADC0_SC2_ADTRG_Msk = 0x40
	// Bit ADTRG.
	ADC0_SC2_ADTRG = 0x40
	// Software trigger selected.
	ADC0_SC2_ADTRG_0 = 0x0
	// Hardware trigger selected.
	ADC0_SC2_ADTRG_1 = 0x1
	// Position of ADACT field.
	ADC0_SC2_ADACT_Pos = 0x7
	// Bit mask of ADACT field.
	ADC0_SC2_ADACT_Msk = 0x80
	// Bit ADACT.
	ADC0_SC2_ADACT = 0x80
	// Conversion not in progress.
	ADC0_SC2_ADACT_0 = 0x0
	// Conversion in progress.
	ADC0_SC2_ADACT_1 = 0x1

	// SC3: Status and Control Register 3
	// Position of AVGS field.
	ADC0_SC3_AVGS_Pos = 0x0
	// Bit mask of AVGS field.
	ADC0_SC3_AVGS_Msk = 0x3
	// 4 samples averaged.
	ADC0_SC3_AVGS_00 = 0x0
	// 8 samples averaged.
	ADC0_SC3_AVGS_01 = 0x1
	// 16 samples averaged.
	ADC0_SC3_AVGS_10 = 0x2
	// 32 samples averaged.
	ADC0_SC3_AVGS_11 = 0x3
	// Position of AVGE field.
	ADC0_SC3_AVGE_Pos = 0x2
	// Bit mask of AVGE field.
	ADC0_SC3_AVGE_Msk = 0x4
	// Bit AVGE.
	ADC0_SC3_AVGE = 0x4
	// Hardware average function disabled.
	ADC0_SC3_AVGE_0 = 0x0
	// Hardware average function enabled.
	ADC0_SC3_AVGE_1 = 0x1
	// Position of ADCO field.
	ADC0_SC3_ADCO_Pos = 0x3
	// Bit mask of ADCO field.
	ADC0_SC3_ADCO_Msk = 0x8
	// Bit ADCO.
	ADC0_SC3_ADCO = 0x8
	// One conversion or one set of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
	ADC0_SC3_ADCO_0 = 0x0
	// Continuous conversions or sets of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
	ADC0_SC3_ADCO_1 = 0x1
	// Position of CALF field.
	ADC0_SC3_CALF_Pos = 0x6
	// Bit mask of CALF field.
	ADC0_SC3_CALF_Msk = 0x40
	// Bit CALF.
	ADC0_SC3_CALF = 0x40
	// Calibration completed normally.
	ADC0_SC3_CALF_0 = 0x0
	// Calibration failed. ADC accuracy specifications are not guaranteed.
	ADC0_SC3_CALF_1 = 0x1
	// Position of CAL field.
	ADC0_SC3_CAL_Pos = 0x7
	// Bit mask of CAL field.
	ADC0_SC3_CAL_Msk = 0x80
	// Bit CAL.
	ADC0_SC3_CAL = 0x80

	// OFS: ADC Offset Correction Register
	// Position of OFS field.
	ADC0_OFS_OFS_Pos = 0x0
	// Bit mask of OFS field.
	ADC0_OFS_OFS_Msk = 0xffff

	// PG: ADC Plus-Side Gain Register
	// Position of PG field.
	ADC0_PG_PG_Pos = 0x0
	// Bit mask of PG field.
	ADC0_PG_PG_Msk = 0xffff

	// MG: ADC Minus-Side Gain Register
	// Position of MG field.
	ADC0_MG_MG_Pos = 0x0
	// Bit mask of MG field.
	ADC0_MG_MG_Msk = 0xffff

	// CLPD: ADC Plus-Side General Calibration Value Register
	// Position of CLPD field.
	ADC0_CLPD_CLPD_Pos = 0x0
	// Bit mask of CLPD field.
	ADC0_CLPD_CLPD_Msk = 0x3f

	// CLPS: ADC Plus-Side General Calibration Value Register
	// Position of CLPS field.
	ADC0_CLPS_CLPS_Pos = 0x0
	// Bit mask of CLPS field.
	ADC0_CLPS_CLPS_Msk = 0x3f

	// CLP4: ADC Plus-Side General Calibration Value Register
	// Position of CLP4 field.
	ADC0_CLP4_CLP4_Pos = 0x0
	// Bit mask of CLP4 field.
	ADC0_CLP4_CLP4_Msk = 0x3ff

	// CLP3: ADC Plus-Side General Calibration Value Register
	// Position of CLP3 field.
	ADC0_CLP3_CLP3_Pos = 0x0
	// Bit mask of CLP3 field.
	ADC0_CLP3_CLP3_Msk = 0x1ff

	// CLP2: ADC Plus-Side General Calibration Value Register
	// Position of CLP2 field.
	ADC0_CLP2_CLP2_Pos = 0x0
	// Bit mask of CLP2 field.
	ADC0_CLP2_CLP2_Msk = 0xff

	// CLP1: ADC Plus-Side General Calibration Value Register
	// Position of CLP1 field.
	ADC0_CLP1_CLP1_Pos = 0x0
	// Bit mask of CLP1 field.
	ADC0_CLP1_CLP1_Msk = 0x7f

	// CLP0: ADC Plus-Side General Calibration Value Register
	// Position of CLP0 field.
	ADC0_CLP0_CLP0_Pos = 0x0
	// Bit mask of CLP0 field.
	ADC0_CLP0_CLP0_Msk = 0x3f

	// CLMD: ADC Minus-Side General Calibration Value Register
	// Position of CLMD field.
	ADC0_CLMD_CLMD_Pos = 0x0
	// Bit mask of CLMD field.
	ADC0_CLMD_CLMD_Msk = 0x3f

	// CLMS: ADC Minus-Side General Calibration Value Register
	// Position of CLMS field.
	ADC0_CLMS_CLMS_Pos = 0x0
	// Bit mask of CLMS field.
	ADC0_CLMS_CLMS_Msk = 0x3f

	// CLM4: ADC Minus-Side General Calibration Value Register
	// Position of CLM4 field.
	ADC0_CLM4_CLM4_Pos = 0x0
	// Bit mask of CLM4 field.
	ADC0_CLM4_CLM4_Msk = 0x3ff

	// CLM3: ADC Minus-Side General Calibration Value Register
	// Position of CLM3 field.
	ADC0_CLM3_CLM3_Pos = 0x0
	// Bit mask of CLM3 field.
	ADC0_CLM3_CLM3_Msk = 0x1ff

	// CLM2: ADC Minus-Side General Calibration Value Register
	// Position of CLM2 field.
	ADC0_CLM2_CLM2_Pos = 0x0
	// Bit mask of CLM2 field.
	ADC0_CLM2_CLM2_Msk = 0xff

	// CLM1: ADC Minus-Side General Calibration Value Register
	// Position of CLM1 field.
	ADC0_CLM1_CLM1_Pos = 0x0
	// Bit mask of CLM1 field.
	ADC0_CLM1_CLM1_Msk = 0x7f

	// CLM0: ADC Minus-Side General Calibration Value Register
	// Position of CLM0 field.
	ADC0_CLM0_CLM0_Pos = 0x0
	// Bit mask of CLM0 field.
	ADC0_CLM0_CLM0_Msk = 0x3f
)

// Constants for RTC: Secure Real Time Clock
const (
	// TSR: RTC Time Seconds Register
	// Position of TSR field.
	RTC_TSR_TSR_Pos = 0x0
	// Bit mask of TSR field.
	RTC_TSR_TSR_Msk = 0xffffffff

	// TPR: RTC Time Prescaler Register
	// Position of TPR field.
	RTC_TPR_TPR_Pos = 0x0
	// Bit mask of TPR field.
	RTC_TPR_TPR_Msk = 0xffff

	// TAR: RTC Time Alarm Register
	// Position of TAR field.
	RTC_TAR_TAR_Pos = 0x0
	// Bit mask of TAR field.
	RTC_TAR_TAR_Msk = 0xffffffff

	// TCR: RTC Time Compensation Register
	// Position of TCR field.
	RTC_TCR_TCR_Pos = 0x0
	// Bit mask of TCR field.
	RTC_TCR_TCR_Msk = 0xff
	// Time Prescaler Register overflows every 32896 clock cycles.
	RTC_TCR_TCR_10000000 = 0x80
	// Time Prescaler Register overflows every 32769 clock cycles.
	RTC_TCR_TCR_11111111 = 0xff
	// Time Prescaler Register overflows every 32768 clock cycles.
	RTC_TCR_TCR_0 = 0x0
	// Time Prescaler Register overflows every 32767 clock cycles.
	RTC_TCR_TCR_1 = 0x1
	// Time Prescaler Register overflows every 32641 clock cycles.
	RTC_TCR_TCR_1111111 = 0x7f
	// Position of CIR field.
	RTC_TCR_CIR_Pos = 0x8
	// Bit mask of CIR field.
	RTC_TCR_CIR_Msk = 0xff00
	// Position of TCV field.
	RTC_TCR_TCV_Pos = 0x10
	// Bit mask of TCV field.
	RTC_TCR_TCV_Msk = 0xff0000
	// Position of CIC field.
	RTC_TCR_CIC_Pos = 0x18
	// Bit mask of CIC field.
	RTC_TCR_CIC_Msk = 0xff000000

	// CR: RTC Control Register
	// Position of SWR field.
	RTC_CR_SWR_Pos = 0x0
	// Bit mask of SWR field.
	RTC_CR_SWR_Msk = 0x1
	// Bit SWR.
	RTC_CR_SWR = 0x1
	// No effect.
	RTC_CR_SWR_0 = 0x0
	// Resets all RTC registers except for the SWR bit . The SWR bit is cleared by POR and by software explicitly clearing it.
	RTC_CR_SWR_1 = 0x1
	// Position of WPE field.
	RTC_CR_WPE_Pos = 0x1
	// Bit mask of WPE field.
	RTC_CR_WPE_Msk = 0x2
	// Bit WPE.
	RTC_CR_WPE = 0x2
	// Wakeup pin is disabled.
	RTC_CR_WPE_0 = 0x0
	// Wakeup pin is enabled and wakeup pin asserts if the RTC interrupt asserts or the wakeup pin is turned on.
	RTC_CR_WPE_1 = 0x1
	// Position of SUP field.
	RTC_CR_SUP_Pos = 0x2
	// Bit mask of SUP field.
	RTC_CR_SUP_Msk = 0x4
	// Bit SUP.
	RTC_CR_SUP = 0x4
	// Non-supervisor mode write accesses are not supported and generate a bus error.
	RTC_CR_SUP_0 = 0x0
	// Non-supervisor mode write accesses are supported.
	RTC_CR_SUP_1 = 0x1
	// Position of UM field.
	RTC_CR_UM_Pos = 0x3
	// Bit mask of UM field.
	RTC_CR_UM_Msk = 0x8
	// Bit UM.
	RTC_CR_UM = 0x8
	// Registers cannot be written when locked.
	RTC_CR_UM_0 = 0x0
	// Registers can be written when locked under limited conditions.
	RTC_CR_UM_1 = 0x1
	// Position of WPS field.
	RTC_CR_WPS_Pos = 0x4
	// Bit mask of WPS field.
	RTC_CR_WPS_Msk = 0x10
	// Bit WPS.
	RTC_CR_WPS = 0x10
	// Wakeup pin asserts (active low, open drain) if the RTC interrupt asserts or the wakeup pin is turned on.
	RTC_CR_WPS_0 = 0x0
	// Wakeup pin instead outputs the RTC 32kHz clock, provided the wakeup pin is turned on and the 32kHz clock is output to other peripherals.
	RTC_CR_WPS_1 = 0x1
	// Position of OSCE field.
	RTC_CR_OSCE_Pos = 0x8
	// Bit mask of OSCE field.
	RTC_CR_OSCE_Msk = 0x100
	// Bit OSCE.
	RTC_CR_OSCE = 0x100
	// 32.768 kHz oscillator is disabled.
	RTC_CR_OSCE_0 = 0x0
	// 32.768 kHz oscillator is enabled. After setting this bit, wait the oscillator startup time before enabling the time counter to allow the 32.768 kHz clock time to stabilize.
	RTC_CR_OSCE_1 = 0x1
	// Position of CLKO field.
	RTC_CR_CLKO_Pos = 0x9
	// Bit mask of CLKO field.
	RTC_CR_CLKO_Msk = 0x200
	// Bit CLKO.
	RTC_CR_CLKO = 0x200
	// The 32 kHz clock is output to other peripherals.
	RTC_CR_CLKO_0 = 0x0
	// The 32 kHz clock is not output to other peripherals.
	RTC_CR_CLKO_1 = 0x1
	// Position of SC16P field.
	RTC_CR_SC16P_Pos = 0xa
	// Bit mask of SC16P field.
	RTC_CR_SC16P_Msk = 0x400
	// Bit SC16P.
	RTC_CR_SC16P = 0x400
	// Disable the load.
	RTC_CR_SC16P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC16P_1 = 0x1
	// Position of SC8P field.
	RTC_CR_SC8P_Pos = 0xb
	// Bit mask of SC8P field.
	RTC_CR_SC8P_Msk = 0x800
	// Bit SC8P.
	RTC_CR_SC8P = 0x800
	// Disable the load.
	RTC_CR_SC8P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC8P_1 = 0x1
	// Position of SC4P field.
	RTC_CR_SC4P_Pos = 0xc
	// Bit mask of SC4P field.
	RTC_CR_SC4P_Msk = 0x1000
	// Bit SC4P.
	RTC_CR_SC4P = 0x1000
	// Disable the load.
	RTC_CR_SC4P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC4P_1 = 0x1
	// Position of SC2P field.
	RTC_CR_SC2P_Pos = 0xd
	// Bit mask of SC2P field.
	RTC_CR_SC2P_Msk = 0x2000
	// Bit SC2P.
	RTC_CR_SC2P = 0x2000
	// Disable the load.
	RTC_CR_SC2P_0 = 0x0
	// Enable the additional load.
	RTC_CR_SC2P_1 = 0x1

	// SR: RTC Status Register
	// Position of TIF field.
	RTC_SR_TIF_Pos = 0x0
	// Bit mask of TIF field.
	RTC_SR_TIF_Msk = 0x1
	// Bit TIF.
	RTC_SR_TIF = 0x1
	// Time is valid.
	RTC_SR_TIF_0 = 0x0
	// Time is invalid and time counter is read as zero.
	RTC_SR_TIF_1 = 0x1
	// Position of TOF field.
	RTC_SR_TOF_Pos = 0x1
	// Bit mask of TOF field.
	RTC_SR_TOF_Msk = 0x2
	// Bit TOF.
	RTC_SR_TOF = 0x2
	// Time overflow has not occurred.
	RTC_SR_TOF_0 = 0x0
	// Time overflow has occurred and time counter is read as zero.
	RTC_SR_TOF_1 = 0x1
	// Position of TAF field.
	RTC_SR_TAF_Pos = 0x2
	// Bit mask of TAF field.
	RTC_SR_TAF_Msk = 0x4
	// Bit TAF.
	RTC_SR_TAF = 0x4
	// Time alarm has not occurred.
	RTC_SR_TAF_0 = 0x0
	// Time alarm has occurred.
	RTC_SR_TAF_1 = 0x1
	// Position of TCE field.
	RTC_SR_TCE_Pos = 0x4
	// Bit mask of TCE field.
	RTC_SR_TCE_Msk = 0x10
	// Bit TCE.
	RTC_SR_TCE = 0x10
	// Time counter is disabled.
	RTC_SR_TCE_0 = 0x0
	// Time counter is enabled.
	RTC_SR_TCE_1 = 0x1

	// LR: RTC Lock Register
	// Position of TCL field.
	RTC_LR_TCL_Pos = 0x3
	// Bit mask of TCL field.
	RTC_LR_TCL_Msk = 0x8
	// Bit TCL.
	RTC_LR_TCL = 0x8
	// Time Compensation Register is locked and writes are ignored.
	RTC_LR_TCL_0 = 0x0
	// Time Compensation Register is not locked and writes complete as normal.
	RTC_LR_TCL_1 = 0x1
	// Position of CRL field.
	RTC_LR_CRL_Pos = 0x4
	// Bit mask of CRL field.
	RTC_LR_CRL_Msk = 0x10
	// Bit CRL.
	RTC_LR_CRL = 0x10
	// Control Register is locked and writes are ignored.
	RTC_LR_CRL_0 = 0x0
	// Control Register is not locked and writes complete as normal.
	RTC_LR_CRL_1 = 0x1
	// Position of SRL field.
	RTC_LR_SRL_Pos = 0x5
	// Bit mask of SRL field.
	RTC_LR_SRL_Msk = 0x20
	// Bit SRL.
	RTC_LR_SRL = 0x20
	// Status Register is locked and writes are ignored.
	RTC_LR_SRL_0 = 0x0
	// Status Register is not locked and writes complete as normal.
	RTC_LR_SRL_1 = 0x1
	// Position of LRL field.
	RTC_LR_LRL_Pos = 0x6
	// Bit mask of LRL field.
	RTC_LR_LRL_Msk = 0x40
	// Bit LRL.
	RTC_LR_LRL = 0x40
	// Lock Register is locked and writes are ignored.
	RTC_LR_LRL_0 = 0x0
	// Lock Register is not locked and writes complete as normal.
	RTC_LR_LRL_1 = 0x1

	// IER: RTC Interrupt Enable Register
	// Position of TIIE field.
	RTC_IER_TIIE_Pos = 0x0
	// Bit mask of TIIE field.
	RTC_IER_TIIE_Msk = 0x1
	// Bit TIIE.
	RTC_IER_TIIE = 0x1
	// Time invalid flag does not generate an interrupt.
	RTC_IER_TIIE_0 = 0x0
	// Time invalid flag does generate an interrupt.
	RTC_IER_TIIE_1 = 0x1
	// Position of TOIE field.
	RTC_IER_TOIE_Pos = 0x1
	// Bit mask of TOIE field.
	RTC_IER_TOIE_Msk = 0x2
	// Bit TOIE.
	RTC_IER_TOIE = 0x2
	// Time overflow flag does not generate an interrupt.
	RTC_IER_TOIE_0 = 0x0
	// Time overflow flag does generate an interrupt.
	RTC_IER_TOIE_1 = 0x1
	// Position of TAIE field.
	RTC_IER_TAIE_Pos = 0x2
	// Bit mask of TAIE field.
	RTC_IER_TAIE_Msk = 0x4
	// Bit TAIE.
	RTC_IER_TAIE = 0x4
	// Time alarm flag does not generate an interrupt.
	RTC_IER_TAIE_0 = 0x0
	// Time alarm flag does generate an interrupt.
	RTC_IER_TAIE_1 = 0x1
	// Position of TSIE field.
	RTC_IER_TSIE_Pos = 0x4
	// Bit mask of TSIE field.
	RTC_IER_TSIE_Msk = 0x10
	// Bit TSIE.
	RTC_IER_TSIE = 0x10
	// Seconds interrupt is disabled.
	RTC_IER_TSIE_0 = 0x0
	// Seconds interrupt is enabled.
	RTC_IER_TSIE_1 = 0x1
	// Position of WPON field.
	RTC_IER_WPON_Pos = 0x7
	// Bit mask of WPON field.
	RTC_IER_WPON_Msk = 0x80
	// Bit WPON.
	RTC_IER_WPON = 0x80
	// No effect.
	RTC_IER_WPON_0 = 0x0
	// If the wakeup pin is enabled, then the wakeup pin will assert.
	RTC_IER_WPON_1 = 0x1
)

// Constants for DAC0: 12-Bit Digital-to-Analog Converter
const (
	// DAT0L: DAC Data Low Register
	// Position of DATA0 field.
	DAC0_DATL_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	DAC0_DATL_DATA0_Msk = 0xff

	// DAT0H: DAC Data High Register
	// Position of DATA1 field.
	DAC0_DATH_DATA1_Pos = 0x0
	// Bit mask of DATA1 field.
	DAC0_DATH_DATA1_Msk = 0xf

	// SR: DAC Status Register
	// Position of DACBFRPBF field.
	DAC0_SR_DACBFRPBF_Pos = 0x0
	// Bit mask of DACBFRPBF field.
	DAC0_SR_DACBFRPBF_Msk = 0x1
	// Bit DACBFRPBF.
	DAC0_SR_DACBFRPBF = 0x1
	// The DAC buffer read pointer is not equal to C2[DACBFUP].
	DAC0_SR_DACBFRPBF_0 = 0x0
	// The DAC buffer read pointer is equal to C2[DACBFUP].
	DAC0_SR_DACBFRPBF_1 = 0x1
	// Position of DACBFRPTF field.
	DAC0_SR_DACBFRPTF_Pos = 0x1
	// Bit mask of DACBFRPTF field.
	DAC0_SR_DACBFRPTF_Msk = 0x2
	// Bit DACBFRPTF.
	DAC0_SR_DACBFRPTF = 0x2
	// The DAC buffer read pointer is not zero.
	DAC0_SR_DACBFRPTF_0 = 0x0
	// The DAC buffer read pointer is zero.
	DAC0_SR_DACBFRPTF_1 = 0x1

	// C0: DAC Control Register
	// Position of DACBBIEN field.
	DAC0_C0_DACBBIEN_Pos = 0x0
	// Bit mask of DACBBIEN field.
	DAC0_C0_DACBBIEN_Msk = 0x1
	// Bit DACBBIEN.
	DAC0_C0_DACBBIEN = 0x1
	// The DAC buffer read pointer bottom flag interrupt is disabled.
	DAC0_C0_DACBBIEN_0 = 0x0
	// The DAC buffer read pointer bottom flag interrupt is enabled.
	DAC0_C0_DACBBIEN_1 = 0x1
	// Position of DACBTIEN field.
	DAC0_C0_DACBTIEN_Pos = 0x1
	// Bit mask of DACBTIEN field.
	DAC0_C0_DACBTIEN_Msk = 0x2
	// Bit DACBTIEN.
	DAC0_C0_DACBTIEN = 0x2
	// The DAC buffer read pointer top flag interrupt is disabled.
	DAC0_C0_DACBTIEN_0 = 0x0
	// The DAC buffer read pointer top flag interrupt is enabled.
	DAC0_C0_DACBTIEN_1 = 0x1
	// Position of LPEN field.
	DAC0_C0_LPEN_Pos = 0x3
	// Bit mask of LPEN field.
	DAC0_C0_LPEN_Msk = 0x8
	// Bit LPEN.
	DAC0_C0_LPEN = 0x8
	// High-Power mode
	DAC0_C0_LPEN_0 = 0x0
	// Low-Power mode
	DAC0_C0_LPEN_1 = 0x1
	// Position of DACSWTRG field.
	DAC0_C0_DACSWTRG_Pos = 0x4
	// Bit mask of DACSWTRG field.
	DAC0_C0_DACSWTRG_Msk = 0x10
	// Bit DACSWTRG.
	DAC0_C0_DACSWTRG = 0x10
	// The DAC soft trigger is not valid.
	DAC0_C0_DACSWTRG_0 = 0x0
	// The DAC soft trigger is valid.
	DAC0_C0_DACSWTRG_1 = 0x1
	// Position of DACTRGSEL field.
	DAC0_C0_DACTRGSEL_Pos = 0x5
	// Bit mask of DACTRGSEL field.
	DAC0_C0_DACTRGSEL_Msk = 0x20
	// Bit DACTRGSEL.
	DAC0_C0_DACTRGSEL = 0x20
	// The DAC hardware trigger is selected.
	DAC0_C0_DACTRGSEL_0 = 0x0
	// The DAC software trigger is selected.
	DAC0_C0_DACTRGSEL_1 = 0x1
	// Position of DACRFS field.
	DAC0_C0_DACRFS_Pos = 0x6
	// Bit mask of DACRFS field.
	DAC0_C0_DACRFS_Msk = 0x40
	// Bit DACRFS.
	DAC0_C0_DACRFS = 0x40
	// The DAC selects DACREF_1 as the reference voltage.
	DAC0_C0_DACRFS_0 = 0x0
	// The DAC selects DACREF_2 as the reference voltage.
	DAC0_C0_DACRFS_1 = 0x1
	// Position of DACEN field.
	DAC0_C0_DACEN_Pos = 0x7
	// Bit mask of DACEN field.
	DAC0_C0_DACEN_Msk = 0x80
	// Bit DACEN.
	DAC0_C0_DACEN = 0x80
	// The DAC system is disabled.
	DAC0_C0_DACEN_0 = 0x0
	// The DAC system is enabled.
	DAC0_C0_DACEN_1 = 0x1

	// C1: DAC Control Register 1
	// Position of DACBFEN field.
	DAC0_C1_DACBFEN_Pos = 0x0
	// Bit mask of DACBFEN field.
	DAC0_C1_DACBFEN_Msk = 0x1
	// Bit DACBFEN.
	DAC0_C1_DACBFEN = 0x1
	// Buffer read pointer is disabled. The converted data is always the first word of the buffer.
	DAC0_C1_DACBFEN_0 = 0x0
	// Buffer read pointer is enabled. The converted data is the word that the read pointer points to. It means converted data can be from any word of the buffer.
	DAC0_C1_DACBFEN_1 = 0x1
	// Position of DACBFMD field.
	DAC0_C1_DACBFMD_Pos = 0x2
	// Bit mask of DACBFMD field.
	DAC0_C1_DACBFMD_Msk = 0x4
	// Bit DACBFMD.
	DAC0_C1_DACBFMD = 0x4
	// Normal mode
	DAC0_C1_DACBFMD_0 = 0x0
	// One-Time Scan mode
	DAC0_C1_DACBFMD_1 = 0x1
	// Position of DMAEN field.
	DAC0_C1_DMAEN_Pos = 0x7
	// Bit mask of DMAEN field.
	DAC0_C1_DMAEN_Msk = 0x80
	// Bit DMAEN.
	DAC0_C1_DMAEN = 0x80
	// DMA is disabled.
	DAC0_C1_DMAEN_0 = 0x0
	// DMA is enabled. When DMA is enabled, the DMA request will be generated by original interrupts. The interrupts will not be presented on this module at the same time.
	DAC0_C1_DMAEN_1 = 0x1

	// C2: DAC Control Register 2
	// Position of DACBFUP field.
	DAC0_C2_DACBFUP_Pos = 0x0
	// Bit mask of DACBFUP field.
	DAC0_C2_DACBFUP_Msk = 0x1
	// Bit DACBFUP.
	DAC0_C2_DACBFUP = 0x1
	// Position of DACBFRP field.
	DAC0_C2_DACBFRP_Pos = 0x4
	// Bit mask of DACBFRP field.
	DAC0_C2_DACBFRP_Msk = 0x10
	// Bit DACBFRP.
	DAC0_C2_DACBFRP = 0x10
)

// Constants for LPTMR0: Low Power Timer
const (
	// CSR: Low Power Timer Control Status Register
	// Position of TEN field.
	LPTMR0_CSR_TEN_Pos = 0x0
	// Bit mask of TEN field.
	LPTMR0_CSR_TEN_Msk = 0x1
	// Bit TEN.
	LPTMR0_CSR_TEN = 0x1
	// LPTMR is disabled and internal logic is reset.
	LPTMR0_CSR_TEN_0 = 0x0
	// LPTMR is enabled.
	LPTMR0_CSR_TEN_1 = 0x1
	// Position of TMS field.
	LPTMR0_CSR_TMS_Pos = 0x1
	// Bit mask of TMS field.
	LPTMR0_CSR_TMS_Msk = 0x2
	// Bit TMS.
	LPTMR0_CSR_TMS = 0x2
	// Time Counter mode.
	LPTMR0_CSR_TMS_0 = 0x0
	// Pulse Counter mode.
	LPTMR0_CSR_TMS_1 = 0x1
	// Position of TFC field.
	LPTMR0_CSR_TFC_Pos = 0x2
	// Bit mask of TFC field.
	LPTMR0_CSR_TFC_Msk = 0x4
	// Bit TFC.
	LPTMR0_CSR_TFC = 0x4
	// CNR is reset whenever TCF is set.
	LPTMR0_CSR_TFC_0 = 0x0
	// CNR is reset on overflow.
	LPTMR0_CSR_TFC_1 = 0x1
	// Position of TPP field.
	LPTMR0_CSR_TPP_Pos = 0x3
	// Bit mask of TPP field.
	LPTMR0_CSR_TPP_Msk = 0x8
	// Bit TPP.
	LPTMR0_CSR_TPP = 0x8
	// Pulse Counter input source is active-high, and the CNR will increment on the rising-edge.
	LPTMR0_CSR_TPP_0 = 0x0
	// Pulse Counter input source is active-low, and the CNR will increment on the falling-edge.
	LPTMR0_CSR_TPP_1 = 0x1
	// Position of TPS field.
	LPTMR0_CSR_TPS_Pos = 0x4
	// Bit mask of TPS field.
	LPTMR0_CSR_TPS_Msk = 0x30
	// Pulse counter input 0 is selected.
	LPTMR0_CSR_TPS_00 = 0x0
	// Pulse counter input 1 is selected.
	LPTMR0_CSR_TPS_01 = 0x1
	// Pulse counter input 2 is selected.
	LPTMR0_CSR_TPS_10 = 0x2
	// Pulse counter input 3 is selected.
	LPTMR0_CSR_TPS_11 = 0x3
	// Position of TIE field.
	LPTMR0_CSR_TIE_Pos = 0x6
	// Bit mask of TIE field.
	LPTMR0_CSR_TIE_Msk = 0x40
	// Bit TIE.
	LPTMR0_CSR_TIE = 0x40
	// Timer interrupt disabled.
	LPTMR0_CSR_TIE_0 = 0x0
	// Timer interrupt enabled.
	LPTMR0_CSR_TIE_1 = 0x1
	// Position of TCF field.
	LPTMR0_CSR_TCF_Pos = 0x7
	// Bit mask of TCF field.
	LPTMR0_CSR_TCF_Msk = 0x80
	// Bit TCF.
	LPTMR0_CSR_TCF = 0x80
	// The value of CNR is not equal to CMR and increments.
	LPTMR0_CSR_TCF_0 = 0x0
	// The value of CNR is equal to CMR and increments.
	LPTMR0_CSR_TCF_1 = 0x1

	// PSR: Low Power Timer Prescale Register
	// Position of PCS field.
	LPTMR0_PSR_PCS_Pos = 0x0
	// Bit mask of PCS field.
	LPTMR0_PSR_PCS_Msk = 0x3
	// Prescaler/glitch filter clock 0 selected.
	LPTMR0_PSR_PCS_00 = 0x0
	// Prescaler/glitch filter clock 1 selected.
	LPTMR0_PSR_PCS_01 = 0x1
	// Prescaler/glitch filter clock 2 selected.
	LPTMR0_PSR_PCS_10 = 0x2
	// Prescaler/glitch filter clock 3 selected.
	LPTMR0_PSR_PCS_11 = 0x3
	// Position of PBYP field.
	LPTMR0_PSR_PBYP_Pos = 0x2
	// Bit mask of PBYP field.
	LPTMR0_PSR_PBYP_Msk = 0x4
	// Bit PBYP.
	LPTMR0_PSR_PBYP = 0x4
	// Prescaler/glitch filter is enabled.
	LPTMR0_PSR_PBYP_0 = 0x0
	// Prescaler/glitch filter is bypassed.
	LPTMR0_PSR_PBYP_1 = 0x1
	// Position of PRESCALE field.
	LPTMR0_PSR_PRESCALE_Pos = 0x3
	// Bit mask of PRESCALE field.
	LPTMR0_PSR_PRESCALE_Msk = 0x78
	// Prescaler divides the prescaler clock by 2; glitch filter does not support this configuration.
	LPTMR0_PSR_PRESCALE_0000 = 0x0
	// Prescaler divides the prescaler clock by 4; glitch filter recognizes change on input pin after 2 rising clock edges.
	LPTMR0_PSR_PRESCALE_0001 = 0x1
	// Prescaler divides the prescaler clock by 8; glitch filter recognizes change on input pin after 4 rising clock edges.
	LPTMR0_PSR_PRESCALE_0010 = 0x2
	// Prescaler divides the prescaler clock by 16; glitch filter recognizes change on input pin after 8 rising clock edges.
	LPTMR0_PSR_PRESCALE_0011 = 0x3
	// Prescaler divides the prescaler clock by 32; glitch filter recognizes change on input pin after 16 rising clock edges.
	LPTMR0_PSR_PRESCALE_0100 = 0x4
	// Prescaler divides the prescaler clock by 64; glitch filter recognizes change on input pin after 32 rising clock edges.
	LPTMR0_PSR_PRESCALE_0101 = 0x5
	// Prescaler divides the prescaler clock by 128; glitch filter recognizes change on input pin after 64 rising clock edges.
	LPTMR0_PSR_PRESCALE_0110 = 0x6
	// Prescaler divides the prescaler clock by 256; glitch filter recognizes change on input pin after 128 rising clock edges.
	LPTMR0_PSR_PRESCALE_0111 = 0x7
	// Prescaler divides the prescaler clock by 512; glitch filter recognizes change on input pin after 256 rising clock edges.
	LPTMR0_PSR_PRESCALE_1000 = 0x8
	// Prescaler divides the prescaler clock by 1024; glitch filter recognizes change on input pin after 512 rising clock edges.
	LPTMR0_PSR_PRESCALE_1001 = 0x9
	// Prescaler divides the prescaler clock by 2048; glitch filter recognizes change on input pin after 1024 rising clock edges.
	LPTMR0_PSR_PRESCALE_1010 = 0xa
	// Prescaler divides the prescaler clock by 4096; glitch filter recognizes change on input pin after 2048 rising clock edges.
	LPTMR0_PSR_PRESCALE_1011 = 0xb
	// Prescaler divides the prescaler clock by 8192; glitch filter recognizes change on input pin after 4096 rising clock edges.
	LPTMR0_PSR_PRESCALE_1100 = 0xc
	// Prescaler divides the prescaler clock by 16,384; glitch filter recognizes change on input pin after 8192 rising clock edges.
	LPTMR0_PSR_PRESCALE_1101 = 0xd
	// Prescaler divides the prescaler clock by 32,768; glitch filter recognizes change on input pin after 16,384 rising clock edges.
	LPTMR0_PSR_PRESCALE_1110 = 0xe
	// Prescaler divides the prescaler clock by 65,536; glitch filter recognizes change on input pin after 32,768 rising clock edges.
	LPTMR0_PSR_PRESCALE_1111 = 0xf

	// CMR: Low Power Timer Compare Register
	// Position of COMPARE field.
	LPTMR0_CMR_COMPARE_Pos = 0x0
	// Bit mask of COMPARE field.
	LPTMR0_CMR_COMPARE_Msk = 0xffff

	// CNR: Low Power Timer Counter Register
	// Position of COUNTER field.
	LPTMR0_CNR_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	LPTMR0_CNR_COUNTER_Msk = 0xffff
)

// Constants for TSI0: Touch sense input
const (
	// GENCS: TSI General Control and Status Register
	// Position of CURSW field.
	TSI0_GENCS_CURSW_Pos = 0x1
	// Bit mask of CURSW field.
	TSI0_GENCS_CURSW_Msk = 0x2
	// Bit CURSW.
	TSI0_GENCS_CURSW = 0x2
	// The current source pair are not swapped.
	TSI0_GENCS_CURSW_0 = 0x0
	// The current source pair are swapped.
	TSI0_GENCS_CURSW_1 = 0x1
	// Position of EOSF field.
	TSI0_GENCS_EOSF_Pos = 0x2
	// Bit mask of EOSF field.
	TSI0_GENCS_EOSF_Msk = 0x4
	// Bit EOSF.
	TSI0_GENCS_EOSF = 0x4
	// Scan not complete.
	TSI0_GENCS_EOSF_0 = 0x0
	// Scan complete.
	TSI0_GENCS_EOSF_1 = 0x1
	// Position of SCNIP field.
	TSI0_GENCS_SCNIP_Pos = 0x3
	// Bit mask of SCNIP field.
	TSI0_GENCS_SCNIP_Msk = 0x8
	// Bit SCNIP.
	TSI0_GENCS_SCNIP = 0x8
	// No scan in progress.
	TSI0_GENCS_SCNIP_0 = 0x0
	// Scan in progress.
	TSI0_GENCS_SCNIP_1 = 0x1
	// Position of STM field.
	TSI0_GENCS_STM_Pos = 0x4
	// Bit mask of STM field.
	TSI0_GENCS_STM_Msk = 0x10
	// Bit STM.
	TSI0_GENCS_STM = 0x10
	// Software trigger scan.
	TSI0_GENCS_STM_0 = 0x0
	// Hardware trigger scan.
	TSI0_GENCS_STM_1 = 0x1
	// Position of STPE field.
	TSI0_GENCS_STPE_Pos = 0x5
	// Bit mask of STPE field.
	TSI0_GENCS_STPE_Msk = 0x20
	// Bit STPE.
	TSI0_GENCS_STPE = 0x20
	// TSI is disabled when MCU goes into low power mode.
	TSI0_GENCS_STPE_0 = 0x0
	// Allows TSI to continue running in all low power modes.
	TSI0_GENCS_STPE_1 = 0x1
	// Position of TSIIEN field.
	TSI0_GENCS_TSIIEN_Pos = 0x6
	// Bit mask of TSIIEN field.
	TSI0_GENCS_TSIIEN_Msk = 0x40
	// Bit TSIIEN.
	TSI0_GENCS_TSIIEN = 0x40
	// TSI interrupt is disabled.
	TSI0_GENCS_TSIIEN_0 = 0x0
	// TSI interrupt is enabled.
	TSI0_GENCS_TSIIEN_1 = 0x1
	// Position of TSIEN field.
	TSI0_GENCS_TSIEN_Pos = 0x7
	// Bit mask of TSIEN field.
	TSI0_GENCS_TSIEN_Msk = 0x80
	// Bit TSIEN.
	TSI0_GENCS_TSIEN = 0x80
	// TSI module disabled.
	TSI0_GENCS_TSIEN_0 = 0x0
	// TSI module enabled.
	TSI0_GENCS_TSIEN_1 = 0x1
	// Position of NSCN field.
	TSI0_GENCS_NSCN_Pos = 0x8
	// Bit mask of NSCN field.
	TSI0_GENCS_NSCN_Msk = 0x1f00
	// Once per electrode
	TSI0_GENCS_NSCN_00000 = 0x0
	// Twice per electrode
	TSI0_GENCS_NSCN_00001 = 0x1
	// 3 times per electrode
	TSI0_GENCS_NSCN_00010 = 0x2
	// 4 times per electrode
	TSI0_GENCS_NSCN_00011 = 0x3
	// 5 times per electrode
	TSI0_GENCS_NSCN_00100 = 0x4
	// 6 times per electrode
	TSI0_GENCS_NSCN_00101 = 0x5
	// 7 times per electrode
	TSI0_GENCS_NSCN_00110 = 0x6
	// 8 times per electrode
	TSI0_GENCS_NSCN_00111 = 0x7
	// 9 times per electrode
	TSI0_GENCS_NSCN_01000 = 0x8
	// 10 times per electrode
	TSI0_GENCS_NSCN_01001 = 0x9
	// 11 times per electrode
	TSI0_GENCS_NSCN_01010 = 0xa
	// 12 times per electrode
	TSI0_GENCS_NSCN_01011 = 0xb
	// 13 times per electrode
	TSI0_GENCS_NSCN_01100 = 0xc
	// 14 times per electrode
	TSI0_GENCS_NSCN_01101 = 0xd
	// 15 times per electrode
	TSI0_GENCS_NSCN_01110 = 0xe
	// 16 times per electrode
	TSI0_GENCS_NSCN_01111 = 0xf
	// 17 times per electrode
	TSI0_GENCS_NSCN_10000 = 0x10
	// 18 times per electrode
	TSI0_GENCS_NSCN_10001 = 0x11
	// 19 times per electrode
	TSI0_GENCS_NSCN_10010 = 0x12
	// 20 times per electrode
	TSI0_GENCS_NSCN_10011 = 0x13
	// 21 times per electrode
	TSI0_GENCS_NSCN_10100 = 0x14
	// 22 times per electrode
	TSI0_GENCS_NSCN_10101 = 0x15
	// 23 times per electrode
	TSI0_GENCS_NSCN_10110 = 0x16
	// 24 times per electrode
	TSI0_GENCS_NSCN_10111 = 0x17
	// 25 times per electrode
	TSI0_GENCS_NSCN_11000 = 0x18
	// 26 times per electrode
	TSI0_GENCS_NSCN_11001 = 0x19
	// 27 times per electrode
	TSI0_GENCS_NSCN_11010 = 0x1a
	// 28 times per electrode
	TSI0_GENCS_NSCN_11011 = 0x1b
	// 29 times per electrode
	TSI0_GENCS_NSCN_11100 = 0x1c
	// 30 times per electrode
	TSI0_GENCS_NSCN_11101 = 0x1d
	// 31 times per electrode
	TSI0_GENCS_NSCN_11110 = 0x1e
	// 32 times per electrode
	TSI0_GENCS_NSCN_11111 = 0x1f
	// Position of PS field.
	TSI0_GENCS_PS_Pos = 0xd
	// Bit mask of PS field.
	TSI0_GENCS_PS_Msk = 0xe000
	// Electrode Oscillator Frequency divided by 1
	TSI0_GENCS_PS_000 = 0x0
	// Electrode Oscillator Frequency divided by 2
	TSI0_GENCS_PS_001 = 0x1
	// Electrode Oscillator Frequency divided by 4
	TSI0_GENCS_PS_010 = 0x2
	// Electrode Oscillator Frequency divided by 8
	TSI0_GENCS_PS_011 = 0x3
	// Electrode Oscillator Frequency divided by 16
	TSI0_GENCS_PS_100 = 0x4
	// Electrode Oscillator Frequency divided by 32
	TSI0_GENCS_PS_101 = 0x5
	// Electrode Oscillator Frequency divided by 64
	TSI0_GENCS_PS_110 = 0x6
	// Electrode Oscillator Frequency divided by 128
	TSI0_GENCS_PS_111 = 0x7
	// Position of EXTCHRG field.
	TSI0_GENCS_EXTCHRG_Pos = 0x10
	// Bit mask of EXTCHRG field.
	TSI0_GENCS_EXTCHRG_Msk = 0x70000
	// 500 nA.
	TSI0_GENCS_EXTCHRG_000 = 0x0
	// 1 uA.
	TSI0_GENCS_EXTCHRG_001 = 0x1
	// 2 uA.
	TSI0_GENCS_EXTCHRG_010 = 0x2
	// 4 uA.
	TSI0_GENCS_EXTCHRG_011 = 0x3
	// 8 uA.
	TSI0_GENCS_EXTCHRG_100 = 0x4
	// 16 uA.
	TSI0_GENCS_EXTCHRG_101 = 0x5
	// 32 uA.
	TSI0_GENCS_EXTCHRG_110 = 0x6
	// 64 uA.
	TSI0_GENCS_EXTCHRG_111 = 0x7
	// Position of DVOLT field.
	TSI0_GENCS_DVOLT_Pos = 0x13
	// Bit mask of DVOLT field.
	TSI0_GENCS_DVOLT_Msk = 0x180000
	// DV = 1.03 V; VP = 1.33 V; Vm = 0.30 V.
	TSI0_GENCS_DVOLT_00 = 0x0
	// DV = 0.73 V; VP = 1.18 V; Vm = 0.45 V.
	TSI0_GENCS_DVOLT_01 = 0x1
	// DV = 0.43 V; VP = 1.03 V; Vm = 0.60 V.
	TSI0_GENCS_DVOLT_10 = 0x2
	// DV = 0.29 V; VP = 0.95 V; Vm = 0.67 V.
	TSI0_GENCS_DVOLT_11 = 0x3
	// Position of REFCHRG field.
	TSI0_GENCS_REFCHRG_Pos = 0x15
	// Bit mask of REFCHRG field.
	TSI0_GENCS_REFCHRG_Msk = 0xe00000
	// 500 nA.
	TSI0_GENCS_REFCHRG_000 = 0x0
	// 1 uA.
	TSI0_GENCS_REFCHRG_001 = 0x1
	// 2 uA.
	TSI0_GENCS_REFCHRG_010 = 0x2
	// 4 uA.
	TSI0_GENCS_REFCHRG_011 = 0x3
	// 8 uA.
	TSI0_GENCS_REFCHRG_100 = 0x4
	// 16 uA.
	TSI0_GENCS_REFCHRG_101 = 0x5
	// 32 uA.
	TSI0_GENCS_REFCHRG_110 = 0x6
	// 64 uA.
	TSI0_GENCS_REFCHRG_111 = 0x7
	// Position of MODE field.
	TSI0_GENCS_MODE_Pos = 0x18
	// Bit mask of MODE field.
	TSI0_GENCS_MODE_Msk = 0xf000000
	// Set TSI in capacitive sensing(non-noise detection) mode.
	TSI0_GENCS_MODE_0000 = 0x0
	// Set TSI analog to work in single threshold noise detection mode and the frequency limitation circuit is disabled.
	TSI0_GENCS_MODE_0100 = 0x4
	// Set TSI analog to work in single threshold noise detection mode and the frequency limitation circuit is enabled to work in higher frequencies operations.
	TSI0_GENCS_MODE_1000 = 0x8
	// Set TSI analog to work in automatic noise detection mode.
	TSI0_GENCS_MODE_1100 = 0xc
	// Position of ESOR field.
	TSI0_GENCS_ESOR_Pos = 0x1c
	// Bit mask of ESOR field.
	TSI0_GENCS_ESOR_Msk = 0x10000000
	// Bit ESOR.
	TSI0_GENCS_ESOR = 0x10000000
	// Out-of-range interrupt is allowed.
	TSI0_GENCS_ESOR_0 = 0x0
	// End-of-scan interrupt is allowed.
	TSI0_GENCS_ESOR_1 = 0x1
	// Position of OUTRGF field.
	TSI0_GENCS_OUTRGF_Pos = 0x1f
	// Bit mask of OUTRGF field.
	TSI0_GENCS_OUTRGF_Msk = 0x80000000
	// Bit OUTRGF.
	TSI0_GENCS_OUTRGF = 0x80000000

	// DATA: TSI DATA Register
	// Position of TSICNT field.
	TSI0_DATA_TSICNT_Pos = 0x0
	// Bit mask of TSICNT field.
	TSI0_DATA_TSICNT_Msk = 0xffff
	// Position of SWTS field.
	TSI0_DATA_SWTS_Pos = 0x16
	// Bit mask of SWTS field.
	TSI0_DATA_SWTS_Msk = 0x400000
	// Bit SWTS.
	TSI0_DATA_SWTS = 0x400000
	// No effect.
	TSI0_DATA_SWTS_0 = 0x0
	// Start a scan to determine which channel is specified by TSI_DATA[TSICH].
	TSI0_DATA_SWTS_1 = 0x1
	// Position of DMAEN field.
	TSI0_DATA_DMAEN_Pos = 0x17
	// Bit mask of DMAEN field.
	TSI0_DATA_DMAEN_Msk = 0x800000
	// Bit DMAEN.
	TSI0_DATA_DMAEN = 0x800000
	// Interrupt is selected when the interrupt enable bit is set and the corresponding TSI events assert.
	TSI0_DATA_DMAEN_0 = 0x0
	// DMA transfer request is selected when the interrupt enable bit is set and the corresponding TSI events assert.
	TSI0_DATA_DMAEN_1 = 0x1
	// Position of TSICH field.
	TSI0_DATA_TSICH_Pos = 0x1c
	// Bit mask of TSICH field.
	TSI0_DATA_TSICH_Msk = 0xf0000000
	// Channel 0.
	TSI0_DATA_TSICH_0000 = 0x0
	// Channel 1.
	TSI0_DATA_TSICH_0001 = 0x1
	// Channel 2.
	TSI0_DATA_TSICH_0010 = 0x2
	// Channel 3.
	TSI0_DATA_TSICH_0011 = 0x3
	// Channel 4.
	TSI0_DATA_TSICH_0100 = 0x4
	// Channel 5.
	TSI0_DATA_TSICH_0101 = 0x5
	// Channel 6.
	TSI0_DATA_TSICH_0110 = 0x6
	// Channel 7.
	TSI0_DATA_TSICH_0111 = 0x7
	// Channel 8.
	TSI0_DATA_TSICH_1000 = 0x8
	// Channel 9.
	TSI0_DATA_TSICH_1001 = 0x9
	// Channel 10.
	TSI0_DATA_TSICH_1010 = 0xa
	// Channel 11.
	TSI0_DATA_TSICH_1011 = 0xb
	// Channel 12.
	TSI0_DATA_TSICH_1100 = 0xc
	// Channel 13.
	TSI0_DATA_TSICH_1101 = 0xd
	// Channel 14.
	TSI0_DATA_TSICH_1110 = 0xe
	// Channel 15.
	TSI0_DATA_TSICH_1111 = 0xf

	// TSHD: TSI Threshold Register
	// Position of THRESL field.
	TSI0_TSHD_THRESL_Pos = 0x0
	// Bit mask of THRESL field.
	TSI0_TSHD_THRESL_Msk = 0xffff
	// Position of THRESH field.
	TSI0_TSHD_THRESH_Pos = 0x10
	// Bit mask of THRESH field.
	TSI0_TSHD_THRESH_Msk = 0xffff0000
)

// Constants for SIM: System Integration Module
const (
	// SOPT1: System Options Register 1
	// Position of OSC32KSEL field.
	SIM_SOPT1_OSC32KSEL_Pos = 0x12
	// Bit mask of OSC32KSEL field.
	SIM_SOPT1_OSC32KSEL_Msk = 0xc0000
	// System oscillator (OSC32KCLK)
	SIM_SOPT1_OSC32KSEL_00 = 0x0
	// RTC_CLKIN
	SIM_SOPT1_OSC32KSEL_10 = 0x2
	// LPO 1kHz
	SIM_SOPT1_OSC32KSEL_11 = 0x3
	// Position of USBVSTBY field.
	SIM_SOPT1_USBVSTBY_Pos = 0x1d
	// Bit mask of USBVSTBY field.
	SIM_SOPT1_USBVSTBY_Msk = 0x20000000
	// Bit USBVSTBY.
	SIM_SOPT1_USBVSTBY = 0x20000000
	// USB voltage regulator not in standby during VLPR and VLPW modes.
	SIM_SOPT1_USBVSTBY_0 = 0x0
	// USB voltage regulator in standby during VLPR and VLPW modes.
	SIM_SOPT1_USBVSTBY_1 = 0x1
	// Position of USBSSTBY field.
	SIM_SOPT1_USBSSTBY_Pos = 0x1e
	// Bit mask of USBSSTBY field.
	SIM_SOPT1_USBSSTBY_Msk = 0x40000000
	// Bit USBSSTBY.
	SIM_SOPT1_USBSSTBY = 0x40000000
	// USB voltage regulator not in standby during Stop, VLPS, LLS and VLLS modes.
	SIM_SOPT1_USBSSTBY_0 = 0x0
	// USB voltage regulator in standby during Stop, VLPS, LLS and VLLS modes.
	SIM_SOPT1_USBSSTBY_1 = 0x1
	// Position of USBREGEN field.
	SIM_SOPT1_USBREGEN_Pos = 0x1f
	// Bit mask of USBREGEN field.
	SIM_SOPT1_USBREGEN_Msk = 0x80000000
	// Bit USBREGEN.
	SIM_SOPT1_USBREGEN = 0x80000000
	// USB voltage regulator is disabled.
	SIM_SOPT1_USBREGEN_0 = 0x0
	// USB voltage regulator is enabled.
	SIM_SOPT1_USBREGEN_1 = 0x1

	// SOPT1CFG: SOPT1 Configuration Register
	// Position of URWE field.
	SIM_SOPT1CFG_URWE_Pos = 0x18
	// Bit mask of URWE field.
	SIM_SOPT1CFG_URWE_Msk = 0x1000000
	// Bit URWE.
	SIM_SOPT1CFG_URWE = 0x1000000
	// SOPT1 USBREGEN cannot be written.
	SIM_SOPT1CFG_URWE_0 = 0x0
	// SOPT1 USBREGEN can be written.
	SIM_SOPT1CFG_URWE_1 = 0x1
	// Position of UVSWE field.
	SIM_SOPT1CFG_UVSWE_Pos = 0x19
	// Bit mask of UVSWE field.
	SIM_SOPT1CFG_UVSWE_Msk = 0x2000000
	// Bit UVSWE.
	SIM_SOPT1CFG_UVSWE = 0x2000000
	// SOPT1 USBVSTB cannot be written.
	SIM_SOPT1CFG_UVSWE_0 = 0x0
	// SOPT1 USBVSTB can be written.
	SIM_SOPT1CFG_UVSWE_1 = 0x1
	// Position of USSWE field.
	SIM_SOPT1CFG_USSWE_Pos = 0x1a
	// Bit mask of USSWE field.
	SIM_SOPT1CFG_USSWE_Msk = 0x4000000
	// Bit USSWE.
	SIM_SOPT1CFG_USSWE = 0x4000000
	// SOPT1 USBSSTB cannot be written.
	SIM_SOPT1CFG_USSWE_0 = 0x0
	// SOPT1 USBSSTB can be written.
	SIM_SOPT1CFG_USSWE_1 = 0x1

	// SOPT2: System Options Register 2
	// Position of RTCCLKOUTSEL field.
	SIM_SOPT2_RTCCLKOUTSEL_Pos = 0x4
	// Bit mask of RTCCLKOUTSEL field.
	SIM_SOPT2_RTCCLKOUTSEL_Msk = 0x10
	// Bit RTCCLKOUTSEL.
	SIM_SOPT2_RTCCLKOUTSEL = 0x10
	// RTC 1 Hz clock is output on the RTC_CLKOUT pin.
	SIM_SOPT2_RTCCLKOUTSEL_0 = 0x0
	// OSCERCLK clock is output on the RTC_CLKOUT pin.
	SIM_SOPT2_RTCCLKOUTSEL_1 = 0x1
	// Position of CLKOUTSEL field.
	SIM_SOPT2_CLKOUTSEL_Pos = 0x5
	// Bit mask of CLKOUTSEL field.
	SIM_SOPT2_CLKOUTSEL_Msk = 0xe0
	// Bus clock
	SIM_SOPT2_CLKOUTSEL_010 = 0x2
	// LPO clock (1 kHz)
	SIM_SOPT2_CLKOUTSEL_011 = 0x3
	// MCGIRCLK
	SIM_SOPT2_CLKOUTSEL_100 = 0x4
	// OSCERCLK
	SIM_SOPT2_CLKOUTSEL_110 = 0x6
	// Position of PLLFLLSEL field.
	SIM_SOPT2_PLLFLLSEL_Pos = 0x10
	// Bit mask of PLLFLLSEL field.
	SIM_SOPT2_PLLFLLSEL_Msk = 0x10000
	// Bit PLLFLLSEL.
	SIM_SOPT2_PLLFLLSEL = 0x10000
	// MCGFLLCLK clock
	SIM_SOPT2_PLLFLLSEL_0 = 0x0
	// MCGPLLCLK clock with fixed divide by 2
	SIM_SOPT2_PLLFLLSEL_1 = 0x1
	// Position of USBSRC field.
	SIM_SOPT2_USBSRC_Pos = 0x12
	// Bit mask of USBSRC field.
	SIM_SOPT2_USBSRC_Msk = 0x40000
	// Bit USBSRC.
	SIM_SOPT2_USBSRC = 0x40000
	// External bypass clock (USB_CLKIN).
	SIM_SOPT2_USBSRC_0 = 0x0
	// MCGFLLCLK clock , or MCGPLLCLK/2 clock
	SIM_SOPT2_USBSRC_1 = 0x1
	// Position of TPMSRC field.
	SIM_SOPT2_TPMSRC_Pos = 0x18
	// Bit mask of TPMSRC field.
	SIM_SOPT2_TPMSRC_Msk = 0x3000000
	// Clock disabled
	SIM_SOPT2_TPMSRC_00 = 0x0
	// MCGFLLCLK clock , or MCGPLLCLK/2
	SIM_SOPT2_TPMSRC_01 = 0x1
	// OSCERCLK clock
	SIM_SOPT2_TPMSRC_10 = 0x2
	// MCGIRCLK clock
	SIM_SOPT2_TPMSRC_11 = 0x3
	// Position of UART0SRC field.
	SIM_SOPT2_UART0SRC_Pos = 0x1a
	// Bit mask of UART0SRC field.
	SIM_SOPT2_UART0SRC_Msk = 0xc000000
	// Clock disabled
	SIM_SOPT2_UART0SRC_00 = 0x0
	// MCGFLLCLK clock , or MCGPLLCLK/2
	SIM_SOPT2_UART0SRC_01 = 0x1
	// OSCERCLK clock
	SIM_SOPT2_UART0SRC_10 = 0x2
	// MCGIRCLK clock
	SIM_SOPT2_UART0SRC_11 = 0x3

	// SOPT4: System Options Register 4
	// Position of TPM1CH0SRC field.
	SIM_SOPT4_TPM1CH0SRC_Pos = 0x12
	// Bit mask of TPM1CH0SRC field.
	SIM_SOPT4_TPM1CH0SRC_Msk = 0xc0000
	// TPM1_CH0 signal
	SIM_SOPT4_TPM1CH0SRC_00 = 0x0
	// CMP0 output
	SIM_SOPT4_TPM1CH0SRC_01 = 0x1
	// USB start of frame pulse
	SIM_SOPT4_TPM1CH0SRC_11 = 0x3
	// Position of TPM2CH0SRC field.
	SIM_SOPT4_TPM2CH0SRC_Pos = 0x14
	// Bit mask of TPM2CH0SRC field.
	SIM_SOPT4_TPM2CH0SRC_Msk = 0x100000
	// Bit TPM2CH0SRC.
	SIM_SOPT4_TPM2CH0SRC = 0x100000
	// TPM2_CH0 signal
	SIM_SOPT4_TPM2CH0SRC_0 = 0x0
	// CMP0 output
	SIM_SOPT4_TPM2CH0SRC_1 = 0x1
	// Position of TPM0CLKSEL field.
	SIM_SOPT4_TPM0CLKSEL_Pos = 0x18
	// Bit mask of TPM0CLKSEL field.
	SIM_SOPT4_TPM0CLKSEL_Msk = 0x1000000
	// Bit TPM0CLKSEL.
	SIM_SOPT4_TPM0CLKSEL = 0x1000000
	// TPM0 external clock driven by TPM_CLKIN0 pin.
	SIM_SOPT4_TPM0CLKSEL_0 = 0x0
	// TPM0 external clock driven by TPM_CLKIN1 pin.
	SIM_SOPT4_TPM0CLKSEL_1 = 0x1
	// Position of TPM1CLKSEL field.
	SIM_SOPT4_TPM1CLKSEL_Pos = 0x19
	// Bit mask of TPM1CLKSEL field.
	SIM_SOPT4_TPM1CLKSEL_Msk = 0x2000000
	// Bit TPM1CLKSEL.
	SIM_SOPT4_TPM1CLKSEL = 0x2000000
	// TPM1 external clock driven by TPM_CLKIN0 pin.
	SIM_SOPT4_TPM1CLKSEL_0 = 0x0
	// TPM1 external clock driven by TPM_CLKIN1 pin.
	SIM_SOPT4_TPM1CLKSEL_1 = 0x1
	// Position of TPM2CLKSEL field.
	SIM_SOPT4_TPM2CLKSEL_Pos = 0x1a
	// Bit mask of TPM2CLKSEL field.
	SIM_SOPT4_TPM2CLKSEL_Msk = 0x4000000
	// Bit TPM2CLKSEL.
	SIM_SOPT4_TPM2CLKSEL = 0x4000000
	// TPM2 external clock driven by TPM_CLKIN0 pin.
	SIM_SOPT4_TPM2CLKSEL_0 = 0x0
	// TPM2 external clock driven by TPM_CLKIN1 pin.
	SIM_SOPT4_TPM2CLKSEL_1 = 0x1

	// SOPT5: System Options Register 5
	// Position of UART0TXSRC field.
	SIM_SOPT5_UART0TXSRC_Pos = 0x0
	// Bit mask of UART0TXSRC field.
	SIM_SOPT5_UART0TXSRC_Msk = 0x3
	// UART0_TX pin
	SIM_SOPT5_UART0TXSRC_00 = 0x0
	// UART0_TX pin modulated with TPM1 channel 0 output
	SIM_SOPT5_UART0TXSRC_01 = 0x1
	// UART0_TX pin modulated with TPM2 channel 0 output
	SIM_SOPT5_UART0TXSRC_10 = 0x2
	// Position of UART0RXSRC field.
	SIM_SOPT5_UART0RXSRC_Pos = 0x2
	// Bit mask of UART0RXSRC field.
	SIM_SOPT5_UART0RXSRC_Msk = 0x4
	// Bit UART0RXSRC.
	SIM_SOPT5_UART0RXSRC = 0x4
	// UART_RX pin
	SIM_SOPT5_UART0RXSRC_0 = 0x0
	// CMP0 output
	SIM_SOPT5_UART0RXSRC_1 = 0x1
	// Position of UART1TXSRC field.
	SIM_SOPT5_UART1TXSRC_Pos = 0x4
	// Bit mask of UART1TXSRC field.
	SIM_SOPT5_UART1TXSRC_Msk = 0x30
	// UART1_TX pin
	SIM_SOPT5_UART1TXSRC_00 = 0x0
	// UART1_TX pin modulated with TPM1 channel 0 output
	SIM_SOPT5_UART1TXSRC_01 = 0x1
	// UART1_TX pin modulated with TPM2 channel 0 output
	SIM_SOPT5_UART1TXSRC_10 = 0x2
	// Position of UART1RXSRC field.
	SIM_SOPT5_UART1RXSRC_Pos = 0x6
	// Bit mask of UART1RXSRC field.
	SIM_SOPT5_UART1RXSRC_Msk = 0x40
	// Bit UART1RXSRC.
	SIM_SOPT5_UART1RXSRC = 0x40
	// UART1_RX pin
	SIM_SOPT5_UART1RXSRC_0 = 0x0
	// CMP0 output
	SIM_SOPT5_UART1RXSRC_1 = 0x1
	// Position of UART0ODE field.
	SIM_SOPT5_UART0ODE_Pos = 0x10
	// Bit mask of UART0ODE field.
	SIM_SOPT5_UART0ODE_Msk = 0x10000
	// Bit UART0ODE.
	SIM_SOPT5_UART0ODE = 0x10000
	// Open drain is disabled on UART0.
	SIM_SOPT5_UART0ODE_0 = 0x0
	// Open drain is enabled on UART0.
	SIM_SOPT5_UART0ODE_1 = 0x1
	// Position of UART1ODE field.
	SIM_SOPT5_UART1ODE_Pos = 0x11
	// Bit mask of UART1ODE field.
	SIM_SOPT5_UART1ODE_Msk = 0x20000
	// Bit UART1ODE.
	SIM_SOPT5_UART1ODE = 0x20000
	// Open drain is disabled on UART1.
	SIM_SOPT5_UART1ODE_0 = 0x0
	// Open drain is enabled on UART1
	SIM_SOPT5_UART1ODE_1 = 0x1
	// Position of UART2ODE field.
	SIM_SOPT5_UART2ODE_Pos = 0x12
	// Bit mask of UART2ODE field.
	SIM_SOPT5_UART2ODE_Msk = 0x40000
	// Bit UART2ODE.
	SIM_SOPT5_UART2ODE = 0x40000
	// Open drain is disabled on UART2
	SIM_SOPT5_UART2ODE_0 = 0x0
	// Open drain is enabled on UART2
	SIM_SOPT5_UART2ODE_1 = 0x1

	// SOPT7: System Options Register 7
	// Position of ADC0TRGSEL field.
	SIM_SOPT7_ADC0TRGSEL_Pos = 0x0
	// Bit mask of ADC0TRGSEL field.
	SIM_SOPT7_ADC0TRGSEL_Msk = 0xf
	// External trigger pin input (EXTRG_IN)
	SIM_SOPT7_ADC0TRGSEL_0000 = 0x0
	// CMP0 output
	SIM_SOPT7_ADC0TRGSEL_0001 = 0x1
	// PIT trigger 0
	SIM_SOPT7_ADC0TRGSEL_0100 = 0x4
	// PIT trigger 1
	SIM_SOPT7_ADC0TRGSEL_0101 = 0x5
	// TPM0 overflow
	SIM_SOPT7_ADC0TRGSEL_1000 = 0x8
	// TPM1 overflow
	SIM_SOPT7_ADC0TRGSEL_1001 = 0x9
	// TPM2 overflow
	SIM_SOPT7_ADC0TRGSEL_1010 = 0xa
	// RTC alarm
	SIM_SOPT7_ADC0TRGSEL_1100 = 0xc
	// RTC seconds
	SIM_SOPT7_ADC0TRGSEL_1101 = 0xd
	// LPTMR0 trigger
	SIM_SOPT7_ADC0TRGSEL_1110 = 0xe
	// Position of ADC0PRETRGSEL field.
	SIM_SOPT7_ADC0PRETRGSEL_Pos = 0x4
	// Bit mask of ADC0PRETRGSEL field.
	SIM_SOPT7_ADC0PRETRGSEL_Msk = 0x10
	// Bit ADC0PRETRGSEL.
	SIM_SOPT7_ADC0PRETRGSEL = 0x10
	// Pre-trigger A
	SIM_SOPT7_ADC0PRETRGSEL_0 = 0x0
	// Pre-trigger B
	SIM_SOPT7_ADC0PRETRGSEL_1 = 0x1
	// Position of ADC0ALTTRGEN field.
	SIM_SOPT7_ADC0ALTTRGEN_Pos = 0x7
	// Bit mask of ADC0ALTTRGEN field.
	SIM_SOPT7_ADC0ALTTRGEN_Msk = 0x80
	// Bit ADC0ALTTRGEN.
	SIM_SOPT7_ADC0ALTTRGEN = 0x80
	// TPM1 channel 0 (A) and channel 1 (B) triggers selected for ADC0.
	SIM_SOPT7_ADC0ALTTRGEN_0 = 0x0
	// Alternate trigger selected for ADC0.
	SIM_SOPT7_ADC0ALTTRGEN_1 = 0x1

	// SDID: System Device Identification Register
	// Position of PINID field.
	SIM_SDID_PINID_Pos = 0x0
	// Bit mask of PINID field.
	SIM_SDID_PINID_Msk = 0xf
	// 16-pin
	SIM_SDID_PINID_0000 = 0x0
	// 24-pin
	SIM_SDID_PINID_0001 = 0x1
	// 32-pin
	SIM_SDID_PINID_0010 = 0x2
	// 36-pin
	SIM_SDID_PINID_0011 = 0x3
	// 48-pin
	SIM_SDID_PINID_0100 = 0x4
	// 64-pin
	SIM_SDID_PINID_0101 = 0x5
	// 80-pin
	SIM_SDID_PINID_0110 = 0x6
	// 100-pin
	SIM_SDID_PINID_1000 = 0x8
	// Custom pinout (WLCSP)
	SIM_SDID_PINID_1011 = 0xb
	// Position of DIEID field.
	SIM_SDID_DIEID_Pos = 0x7
	// Bit mask of DIEID field.
	SIM_SDID_DIEID_Msk = 0xf80
	// Position of REVID field.
	SIM_SDID_REVID_Pos = 0xc
	// Bit mask of REVID field.
	SIM_SDID_REVID_Msk = 0xf000
	// Position of SRAMSIZE field.
	SIM_SDID_SRAMSIZE_Pos = 0x10
	// Bit mask of SRAMSIZE field.
	SIM_SDID_SRAMSIZE_Msk = 0xf0000
	// 0.5 KB
	SIM_SDID_SRAMSIZE_0000 = 0x0
	// 1 KB
	SIM_SDID_SRAMSIZE_0001 = 0x1
	// 2 KB
	SIM_SDID_SRAMSIZE_0010 = 0x2
	// 4 KB
	SIM_SDID_SRAMSIZE_0011 = 0x3
	// 8 KB
	SIM_SDID_SRAMSIZE_0100 = 0x4
	// 16 KB
	SIM_SDID_SRAMSIZE_0101 = 0x5
	// 32 KB
	SIM_SDID_SRAMSIZE_0110 = 0x6
	// 64 KB
	SIM_SDID_SRAMSIZE_0111 = 0x7
	// Position of SERIESID field.
	SIM_SDID_SERIESID_Pos = 0x14
	// Bit mask of SERIESID field.
	SIM_SDID_SERIESID_Msk = 0xf00000
	// KL family
	SIM_SDID_SERIESID_0001 = 0x1
	// Position of SUBFAMID field.
	SIM_SDID_SUBFAMID_Pos = 0x18
	// Bit mask of SUBFAMID field.
	SIM_SDID_SUBFAMID_Msk = 0xf000000
	// KLx2 Subfamily
	SIM_SDID_SUBFAMID_0010 = 0x2
	// KLx3 Subfamily
	SIM_SDID_SUBFAMID_0011 = 0x3
	// KLx4 Subfamily
	SIM_SDID_SUBFAMID_0100 = 0x4
	// KLx5 Subfamily
	SIM_SDID_SUBFAMID_0101 = 0x5
	// KLx6 Subfamily
	SIM_SDID_SUBFAMID_0110 = 0x6
	// KLx7 Subfamily
	SIM_SDID_SUBFAMID_0111 = 0x7
	// Position of FAMID field.
	SIM_SDID_FAMID_Pos = 0x1c
	// Bit mask of FAMID field.
	SIM_SDID_FAMID_Msk = 0xf0000000
	// KL0x Family (low end)
	SIM_SDID_FAMID_0000 = 0x0
	// KL1x Family (basic)
	SIM_SDID_FAMID_0001 = 0x1
	// KL2x Family (USB)
	SIM_SDID_FAMID_0010 = 0x2
	// KL3x Family (Segment LCD)
	SIM_SDID_FAMID_0011 = 0x3
	// KL4x Family (USB and Segment LCD)
	SIM_SDID_FAMID_0100 = 0x4

	// SCGC4: System Clock Gating Control Register 4
	// Position of I2C0 field.
	SIM_SCGC4_I2C0_Pos = 0x6
	// Bit mask of I2C0 field.
	SIM_SCGC4_I2C0_Msk = 0x40
	// Bit I2C0.
	SIM_SCGC4_I2C0 = 0x40
	// Clock disabled
	SIM_SCGC4_I2C0_0 = 0x0
	// Clock enabled
	SIM_SCGC4_I2C0_1 = 0x1
	// Position of I2C1 field.
	SIM_SCGC4_I2C1_Pos = 0x7
	// Bit mask of I2C1 field.
	SIM_SCGC4_I2C1_Msk = 0x80
	// Bit I2C1.
	SIM_SCGC4_I2C1 = 0x80
	// Clock disabled
	SIM_SCGC4_I2C1_0 = 0x0
	// Clock enabled
	SIM_SCGC4_I2C1_1 = 0x1
	// Position of UART0 field.
	SIM_SCGC4_UART0_Pos = 0xa
	// Bit mask of UART0 field.
	SIM_SCGC4_UART0_Msk = 0x400
	// Bit UART0.
	SIM_SCGC4_UART0 = 0x400
	// Clock disabled
	SIM_SCGC4_UART0_0 = 0x0
	// Clock enabled
	SIM_SCGC4_UART0_1 = 0x1
	// Position of UART1 field.
	SIM_SCGC4_UART1_Pos = 0xb
	// Bit mask of UART1 field.
	SIM_SCGC4_UART1_Msk = 0x800
	// Bit UART1.
	SIM_SCGC4_UART1 = 0x800
	// Clock disabled
	SIM_SCGC4_UART1_0 = 0x0
	// Clock enabled
	SIM_SCGC4_UART1_1 = 0x1
	// Position of UART2 field.
	SIM_SCGC4_UART2_Pos = 0xc
	// Bit mask of UART2 field.
	SIM_SCGC4_UART2_Msk = 0x1000
	// Bit UART2.
	SIM_SCGC4_UART2 = 0x1000
	// Clock disabled
	SIM_SCGC4_UART2_0 = 0x0
	// Clock enabled
	SIM_SCGC4_UART2_1 = 0x1
	// Position of USBOTG field.
	SIM_SCGC4_USBOTG_Pos = 0x12
	// Bit mask of USBOTG field.
	SIM_SCGC4_USBOTG_Msk = 0x40000
	// Bit USBOTG.
	SIM_SCGC4_USBOTG = 0x40000
	// Clock disabled
	SIM_SCGC4_USBOTG_0 = 0x0
	// Clock enabled
	SIM_SCGC4_USBOTG_1 = 0x1
	// Position of CMP field.
	SIM_SCGC4_CMP_Pos = 0x13
	// Bit mask of CMP field.
	SIM_SCGC4_CMP_Msk = 0x80000
	// Bit CMP.
	SIM_SCGC4_CMP = 0x80000
	// Clock disabled
	SIM_SCGC4_CMP_0 = 0x0
	// Clock enabled
	SIM_SCGC4_CMP_1 = 0x1
	// Position of SPI0 field.
	SIM_SCGC4_SPI0_Pos = 0x16
	// Bit mask of SPI0 field.
	SIM_SCGC4_SPI0_Msk = 0x400000
	// Bit SPI0.
	SIM_SCGC4_SPI0 = 0x400000
	// Clock disabled
	SIM_SCGC4_SPI0_0 = 0x0
	// Clock enabled
	SIM_SCGC4_SPI0_1 = 0x1
	// Position of SPI1 field.
	SIM_SCGC4_SPI1_Pos = 0x17
	// Bit mask of SPI1 field.
	SIM_SCGC4_SPI1_Msk = 0x800000
	// Bit SPI1.
	SIM_SCGC4_SPI1 = 0x800000
	// Clock disabled
	SIM_SCGC4_SPI1_0 = 0x0
	// Clock enabled
	SIM_SCGC4_SPI1_1 = 0x1

	// SCGC5: System Clock Gating Control Register 5
	// Position of LPTMR field.
	SIM_SCGC5_LPTMR_Pos = 0x0
	// Bit mask of LPTMR field.
	SIM_SCGC5_LPTMR_Msk = 0x1
	// Bit LPTMR.
	SIM_SCGC5_LPTMR = 0x1
	// Access disabled
	SIM_SCGC5_LPTMR_0 = 0x0
	// Access enabled
	SIM_SCGC5_LPTMR_1 = 0x1
	// Position of TSI field.
	SIM_SCGC5_TSI_Pos = 0x5
	// Bit mask of TSI field.
	SIM_SCGC5_TSI_Msk = 0x20
	// Bit TSI.
	SIM_SCGC5_TSI = 0x20
	// Access disabled
	SIM_SCGC5_TSI_0 = 0x0
	// Access enabled
	SIM_SCGC5_TSI_1 = 0x1
	// Position of PORTA field.
	SIM_SCGC5_PORTA_Pos = 0x9
	// Bit mask of PORTA field.
	SIM_SCGC5_PORTA_Msk = 0x200
	// Bit PORTA.
	SIM_SCGC5_PORTA = 0x200
	// Clock disabled
	SIM_SCGC5_PORTA_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTA_1 = 0x1
	// Position of PORTB field.
	SIM_SCGC5_PORTB_Pos = 0xa
	// Bit mask of PORTB field.
	SIM_SCGC5_PORTB_Msk = 0x400
	// Bit PORTB.
	SIM_SCGC5_PORTB = 0x400
	// Clock disabled
	SIM_SCGC5_PORTB_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTB_1 = 0x1
	// Position of PORTC field.
	SIM_SCGC5_PORTC_Pos = 0xb
	// Bit mask of PORTC field.
	SIM_SCGC5_PORTC_Msk = 0x800
	// Bit PORTC.
	SIM_SCGC5_PORTC = 0x800
	// Clock disabled
	SIM_SCGC5_PORTC_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTC_1 = 0x1
	// Position of PORTD field.
	SIM_SCGC5_PORTD_Pos = 0xc
	// Bit mask of PORTD field.
	SIM_SCGC5_PORTD_Msk = 0x1000
	// Bit PORTD.
	SIM_SCGC5_PORTD = 0x1000
	// Clock disabled
	SIM_SCGC5_PORTD_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTD_1 = 0x1
	// Position of PORTE field.
	SIM_SCGC5_PORTE_Pos = 0xd
	// Bit mask of PORTE field.
	SIM_SCGC5_PORTE_Msk = 0x2000
	// Bit PORTE.
	SIM_SCGC5_PORTE = 0x2000
	// Clock disabled
	SIM_SCGC5_PORTE_0 = 0x0
	// Clock enabled
	SIM_SCGC5_PORTE_1 = 0x1

	// SCGC6: System Clock Gating Control Register 6
	// Position of FTF field.
	SIM_SCGC6_FTF_Pos = 0x0
	// Bit mask of FTF field.
	SIM_SCGC6_FTF_Msk = 0x1
	// Bit FTF.
	SIM_SCGC6_FTF = 0x1
	// Clock disabled
	SIM_SCGC6_FTF_0 = 0x0
	// Clock enabled
	SIM_SCGC6_FTF_1 = 0x1
	// Position of DMAMUX field.
	SIM_SCGC6_DMAMUX_Pos = 0x1
	// Bit mask of DMAMUX field.
	SIM_SCGC6_DMAMUX_Msk = 0x2
	// Bit DMAMUX.
	SIM_SCGC6_DMAMUX = 0x2
	// Clock disabled
	SIM_SCGC6_DMAMUX_0 = 0x0
	// Clock enabled
	SIM_SCGC6_DMAMUX_1 = 0x1
	// Position of I2S field.
	SIM_SCGC6_I2S_Pos = 0xf
	// Bit mask of I2S field.
	SIM_SCGC6_I2S_Msk = 0x8000
	// Bit I2S.
	SIM_SCGC6_I2S = 0x8000
	// Clock disabled
	SIM_SCGC6_I2S_0 = 0x0
	// Clock enabled
	SIM_SCGC6_I2S_1 = 0x1
	// Position of PIT field.
	SIM_SCGC6_PIT_Pos = 0x17
	// Bit mask of PIT field.
	SIM_SCGC6_PIT_Msk = 0x800000
	// Bit PIT.
	SIM_SCGC6_PIT = 0x800000
	// Clock disabled
	SIM_SCGC6_PIT_0 = 0x0
	// Clock enabled
	SIM_SCGC6_PIT_1 = 0x1
	// Position of TPM0 field.
	SIM_SCGC6_TPM0_Pos = 0x18
	// Bit mask of TPM0 field.
	SIM_SCGC6_TPM0_Msk = 0x1000000
	// Bit TPM0.
	SIM_SCGC6_TPM0 = 0x1000000
	// Clock disabled
	SIM_SCGC6_TPM0_0 = 0x0
	// Clock enabled
	SIM_SCGC6_TPM0_1 = 0x1
	// Position of TPM1 field.
	SIM_SCGC6_TPM1_Pos = 0x19
	// Bit mask of TPM1 field.
	SIM_SCGC6_TPM1_Msk = 0x2000000
	// Bit TPM1.
	SIM_SCGC6_TPM1 = 0x2000000
	// Clock disabled
	SIM_SCGC6_TPM1_0 = 0x0
	// Clock enabled
	SIM_SCGC6_TPM1_1 = 0x1
	// Position of TPM2 field.
	SIM_SCGC6_TPM2_Pos = 0x1a
	// Bit mask of TPM2 field.
	SIM_SCGC6_TPM2_Msk = 0x4000000
	// Bit TPM2.
	SIM_SCGC6_TPM2 = 0x4000000
	// Clock disabled
	SIM_SCGC6_TPM2_0 = 0x0
	// Clock enabled
	SIM_SCGC6_TPM2_1 = 0x1
	// Position of ADC0 field.
	SIM_SCGC6_ADC0_Pos = 0x1b
	// Bit mask of ADC0 field.
	SIM_SCGC6_ADC0_Msk = 0x8000000
	// Bit ADC0.
	SIM_SCGC6_ADC0 = 0x8000000
	// Clock disabled
	SIM_SCGC6_ADC0_0 = 0x0
	// Clock enabled
	SIM_SCGC6_ADC0_1 = 0x1
	// Position of RTC field.
	SIM_SCGC6_RTC_Pos = 0x1d
	// Bit mask of RTC field.
	SIM_SCGC6_RTC_Msk = 0x20000000
	// Bit RTC.
	SIM_SCGC6_RTC = 0x20000000
	// Access and interrupts disabled
	SIM_SCGC6_RTC_0 = 0x0
	// Access and interrupts enabled
	SIM_SCGC6_RTC_1 = 0x1
	// Position of DAC0 field.
	SIM_SCGC6_DAC0_Pos = 0x1f
	// Bit mask of DAC0 field.
	SIM_SCGC6_DAC0_Msk = 0x80000000
	// Bit DAC0.
	SIM_SCGC6_DAC0 = 0x80000000
	// Clock disabled
	SIM_SCGC6_DAC0_0 = 0x0
	// Clock enabled
	SIM_SCGC6_DAC0_1 = 0x1

	// SCGC7: System Clock Gating Control Register 7
	// Position of DMA field.
	SIM_SCGC7_DMA_Pos = 0x8
	// Bit mask of DMA field.
	SIM_SCGC7_DMA_Msk = 0x100
	// Bit DMA.
	SIM_SCGC7_DMA = 0x100
	// Clock disabled
	SIM_SCGC7_DMA_0 = 0x0
	// Clock enabled
	SIM_SCGC7_DMA_1 = 0x1

	// CLKDIV1: System Clock Divider Register 1
	// Position of OUTDIV4 field.
	SIM_CLKDIV1_OUTDIV4_Pos = 0x10
	// Bit mask of OUTDIV4 field.
	SIM_CLKDIV1_OUTDIV4_Msk = 0x70000
	// Divide-by-1.
	SIM_CLKDIV1_OUTDIV4_000 = 0x0
	// Divide-by-2.
	SIM_CLKDIV1_OUTDIV4_001 = 0x1
	// Divide-by-3.
	SIM_CLKDIV1_OUTDIV4_010 = 0x2
	// Divide-by-4.
	SIM_CLKDIV1_OUTDIV4_011 = 0x3
	// Divide-by-5.
	SIM_CLKDIV1_OUTDIV4_100 = 0x4
	// Divide-by-6.
	SIM_CLKDIV1_OUTDIV4_101 = 0x5
	// Divide-by-7.
	SIM_CLKDIV1_OUTDIV4_110 = 0x6
	// Divide-by-8.
	SIM_CLKDIV1_OUTDIV4_111 = 0x7
	// Position of OUTDIV1 field.
	SIM_CLKDIV1_OUTDIV1_Pos = 0x1c
	// Bit mask of OUTDIV1 field.
	SIM_CLKDIV1_OUTDIV1_Msk = 0xf0000000
	// Divide-by-1.
	SIM_CLKDIV1_OUTDIV1_0000 = 0x0
	// Divide-by-2.
	SIM_CLKDIV1_OUTDIV1_0001 = 0x1
	// Divide-by-3.
	SIM_CLKDIV1_OUTDIV1_0010 = 0x2
	// Divide-by-4.
	SIM_CLKDIV1_OUTDIV1_0011 = 0x3
	// Divide-by-5.
	SIM_CLKDIV1_OUTDIV1_0100 = 0x4
	// Divide-by-6.
	SIM_CLKDIV1_OUTDIV1_0101 = 0x5
	// Divide-by-7.
	SIM_CLKDIV1_OUTDIV1_0110 = 0x6
	// Divide-by-8.
	SIM_CLKDIV1_OUTDIV1_0111 = 0x7
	// Divide-by-9.
	SIM_CLKDIV1_OUTDIV1_1000 = 0x8
	// Divide-by-10.
	SIM_CLKDIV1_OUTDIV1_1001 = 0x9
	// Divide-by-11.
	SIM_CLKDIV1_OUTDIV1_1010 = 0xa
	// Divide-by-12.
	SIM_CLKDIV1_OUTDIV1_1011 = 0xb
	// Divide-by-13.
	SIM_CLKDIV1_OUTDIV1_1100 = 0xc
	// Divide-by-14.
	SIM_CLKDIV1_OUTDIV1_1101 = 0xd
	// Divide-by-15.
	SIM_CLKDIV1_OUTDIV1_1110 = 0xe
	// Divide-by-16.
	SIM_CLKDIV1_OUTDIV1_1111 = 0xf

	// FCFG1: Flash Configuration Register 1
	// Position of FLASHDIS field.
	SIM_FCFG1_FLASHDIS_Pos = 0x0
	// Bit mask of FLASHDIS field.
	SIM_FCFG1_FLASHDIS_Msk = 0x1
	// Bit FLASHDIS.
	SIM_FCFG1_FLASHDIS = 0x1
	// Flash is enabled.
	SIM_FCFG1_FLASHDIS_0 = 0x0
	// Flash is disabled.
	SIM_FCFG1_FLASHDIS_1 = 0x1
	// Position of FLASHDOZE field.
	SIM_FCFG1_FLASHDOZE_Pos = 0x1
	// Bit mask of FLASHDOZE field.
	SIM_FCFG1_FLASHDOZE_Msk = 0x2
	// Bit FLASHDOZE.
	SIM_FCFG1_FLASHDOZE = 0x2
	// Flash remains enabled during Doze mode.
	SIM_FCFG1_FLASHDOZE_0 = 0x0
	// Flash is disabled for the duration of Doze mode.
	SIM_FCFG1_FLASHDOZE_1 = 0x1
	// Position of PFSIZE field.
	SIM_FCFG1_PFSIZE_Pos = 0x18
	// Bit mask of PFSIZE field.
	SIM_FCFG1_PFSIZE_Msk = 0xf000000
	// 8 KB of program flash memory, 0.25 KB protection region
	SIM_FCFG1_PFSIZE_0000 = 0x0
	// 16 KB of program flash memory, 0.5 KB protection region
	SIM_FCFG1_PFSIZE_0001 = 0x1
	// 32 KB of program flash memory, 1 KB protection region
	SIM_FCFG1_PFSIZE_0011 = 0x3
	// 64 KB of program flash memory, 2 KB protection region
	SIM_FCFG1_PFSIZE_0101 = 0x5
	// 128 KB of program flash memory, 4 KB protection region
	SIM_FCFG1_PFSIZE_0111 = 0x7
	// 256 KB of program flash memory, 8 KB protection region
	SIM_FCFG1_PFSIZE_1001 = 0x9
	// 128 KB of program flash memory, 4 KB protection region 256 KB of program flash memory, 8 KB protection region
	SIM_FCFG1_PFSIZE_1111 = 0xf

	// FCFG2: Flash Configuration Register 2
	// Position of MAXADDR1 field.
	SIM_FCFG2_MAXADDR1_Pos = 0x10
	// Bit mask of MAXADDR1 field.
	SIM_FCFG2_MAXADDR1_Msk = 0x7f0000
	// Position of MAXADDR0 field.
	SIM_FCFG2_MAXADDR0_Pos = 0x18
	// Bit mask of MAXADDR0 field.
	SIM_FCFG2_MAXADDR0_Msk = 0x7f000000

	// UIDMH: Unique Identification Register Mid-High
	// Position of UID field.
	SIM_UIDMH_UID_Pos = 0x0
	// Bit mask of UID field.
	SIM_UIDMH_UID_Msk = 0xffff

	// UIDML: Unique Identification Register Mid Low
	// Position of UID field.
	SIM_UIDML_UID_Pos = 0x0
	// Bit mask of UID field.
	SIM_UIDML_UID_Msk = 0xffffffff

	// UIDL: Unique Identification Register Low
	// Position of UID field.
	SIM_UIDL_UID_Pos = 0x0
	// Bit mask of UID field.
	SIM_UIDL_UID_Msk = 0xffffffff

	// COPC: COP Control Register
	// Position of COPW field.
	SIM_COPC_COPW_Pos = 0x0
	// Bit mask of COPW field.
	SIM_COPC_COPW_Msk = 0x1
	// Bit COPW.
	SIM_COPC_COPW = 0x1
	// Normal mode
	SIM_COPC_COPW_0 = 0x0
	// Windowed mode
	SIM_COPC_COPW_1 = 0x1
	// Position of COPCLKS field.
	SIM_COPC_COPCLKS_Pos = 0x1
	// Bit mask of COPCLKS field.
	SIM_COPC_COPCLKS_Msk = 0x2
	// Bit COPCLKS.
	SIM_COPC_COPCLKS = 0x2
	// Internal 1 kHz clock is source to COP.
	SIM_COPC_COPCLKS_0 = 0x0
	// Bus clock is source to COP.
	SIM_COPC_COPCLKS_1 = 0x1
	// Position of COPT field.
	SIM_COPC_COPT_Pos = 0x2
	// Bit mask of COPT field.
	SIM_COPC_COPT_Msk = 0xc
	// COP disabled
	SIM_COPC_COPT_00 = 0x0
	// COP timeout after 25 LPO cycles or 213 bus clock cycles
	SIM_COPC_COPT_01 = 0x1
	// COP timeout after 28 LPO cycles or 216 bus clock cycles
	SIM_COPC_COPT_10 = 0x2
	// COP timeout after 210 LPO cycles or 218 bus clock cycles
	SIM_COPC_COPT_11 = 0x3

	// SRVCOP: Service COP
	// Position of SRVCOP field.
	SIM_SRVCOP_SRVCOP_Pos = 0x0
	// Bit mask of SRVCOP field.
	SIM_SRVCOP_SRVCOP_Msk = 0xff
)

// Constants for PORTA: Pin Control and Interrupts
const (
	// PCR0: Pin Control Register n
	// Position of PS field.
	PORT_PCR0_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR0_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR0_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR0_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR0_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR0_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR0_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR0_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR0_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR0_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR0_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR0_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR0_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR0_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR0_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR0_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR0_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR0_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR0_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR0_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR0_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR0_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR0_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR0_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR0_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR0_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR0_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR0_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR0_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR0_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR0_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR0_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR0_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR0_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR0_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR0_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR0_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR0_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR0_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR0_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR0_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR0_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR0_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR0_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR0_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR0_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR0_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR0_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR0_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR0_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR0_ISF_1 = 0x1

	// PCR1: Pin Control Register n
	// Position of PS field.
	PORT_PCR1_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR1_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR1_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR1_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR1_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR1_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR1_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR1_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR1_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR1_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR1_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR1_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR1_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR1_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR1_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR1_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR1_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR1_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR1_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR1_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR1_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR1_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR1_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR1_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR1_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR1_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR1_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR1_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR1_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR1_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR1_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR1_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR1_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR1_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR1_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR1_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR1_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR1_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR1_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR1_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR1_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR1_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR1_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR1_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR1_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR1_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR1_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR1_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR1_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR1_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR1_ISF_1 = 0x1

	// PCR2: Pin Control Register n
	// Position of PS field.
	PORT_PCR2_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR2_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR2_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR2_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR2_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR2_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR2_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR2_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR2_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR2_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR2_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR2_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR2_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR2_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR2_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR2_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR2_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR2_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR2_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR2_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR2_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR2_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR2_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR2_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR2_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR2_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR2_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR2_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR2_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR2_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR2_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR2_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR2_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR2_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR2_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR2_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR2_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR2_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR2_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR2_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR2_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR2_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR2_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR2_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR2_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR2_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR2_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR2_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR2_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR2_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR2_ISF_1 = 0x1

	// PCR3: Pin Control Register n
	// Position of PS field.
	PORT_PCR3_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR3_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR3_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR3_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR3_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR3_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR3_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR3_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR3_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR3_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR3_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR3_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR3_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR3_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR3_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR3_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR3_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR3_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR3_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR3_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR3_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR3_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR3_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR3_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR3_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR3_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR3_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR3_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR3_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR3_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR3_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR3_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR3_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR3_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR3_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR3_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR3_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR3_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR3_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR3_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR3_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR3_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR3_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR3_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR3_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR3_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR3_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR3_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR3_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR3_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR3_ISF_1 = 0x1

	// PCR4: Pin Control Register n
	// Position of PS field.
	PORT_PCR4_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR4_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR4_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR4_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR4_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR4_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR4_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR4_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR4_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR4_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR4_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR4_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR4_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR4_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR4_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR4_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR4_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR4_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR4_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR4_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR4_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR4_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR4_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR4_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR4_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR4_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR4_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR4_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR4_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR4_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR4_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR4_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR4_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR4_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR4_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR4_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR4_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR4_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR4_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR4_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR4_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR4_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR4_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR4_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR4_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR4_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR4_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR4_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR4_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR4_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR4_ISF_1 = 0x1

	// PCR5: Pin Control Register n
	// Position of PS field.
	PORT_PCR5_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR5_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR5_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR5_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR5_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR5_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR5_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR5_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR5_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR5_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR5_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR5_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR5_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR5_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR5_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR5_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR5_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR5_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR5_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR5_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR5_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR5_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR5_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR5_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR5_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR5_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR5_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR5_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR5_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR5_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR5_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR5_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR5_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR5_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR5_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR5_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR5_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR5_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR5_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR5_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR5_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR5_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR5_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR5_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR5_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR5_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR5_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR5_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR5_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR5_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR5_ISF_1 = 0x1

	// PCR6: Pin Control Register n
	// Position of PS field.
	PORT_PCR6_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR6_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR6_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR6_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR6_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR6_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR6_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR6_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR6_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR6_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR6_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR6_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR6_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR6_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR6_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR6_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR6_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR6_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR6_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR6_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR6_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR6_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR6_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR6_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR6_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR6_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR6_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR6_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR6_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR6_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR6_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR6_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR6_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR6_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR6_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR6_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR6_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR6_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR6_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR6_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR6_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR6_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR6_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR6_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR6_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR6_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR6_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR6_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR6_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR6_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR6_ISF_1 = 0x1

	// PCR7: Pin Control Register n
	// Position of PS field.
	PORT_PCR7_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR7_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR7_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR7_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR7_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR7_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR7_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR7_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR7_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR7_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR7_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR7_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR7_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR7_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR7_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR7_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR7_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR7_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR7_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR7_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR7_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR7_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR7_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR7_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR7_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR7_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR7_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR7_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR7_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR7_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR7_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR7_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR7_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR7_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR7_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR7_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR7_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR7_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR7_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR7_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR7_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR7_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR7_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR7_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR7_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR7_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR7_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR7_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR7_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR7_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR7_ISF_1 = 0x1

	// PCR8: Pin Control Register n
	// Position of PS field.
	PORT_PCR8_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR8_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR8_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR8_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR8_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR8_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR8_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR8_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR8_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR8_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR8_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR8_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR8_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR8_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR8_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR8_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR8_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR8_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR8_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR8_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR8_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR8_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR8_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR8_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR8_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR8_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR8_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR8_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR8_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR8_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR8_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR8_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR8_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR8_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR8_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR8_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR8_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR8_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR8_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR8_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR8_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR8_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR8_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR8_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR8_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR8_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR8_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR8_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR8_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR8_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR8_ISF_1 = 0x1

	// PCR9: Pin Control Register n
	// Position of PS field.
	PORT_PCR9_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR9_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR9_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR9_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR9_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR9_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR9_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR9_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR9_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR9_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR9_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR9_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR9_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR9_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR9_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR9_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR9_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR9_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR9_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR9_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR9_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR9_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR9_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR9_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR9_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR9_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR9_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR9_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR9_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR9_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR9_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR9_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR9_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR9_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR9_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR9_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR9_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR9_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR9_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR9_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR9_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR9_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR9_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR9_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR9_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR9_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR9_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR9_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR9_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR9_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR9_ISF_1 = 0x1

	// PCR10: Pin Control Register n
	// Position of PS field.
	PORT_PCR10_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR10_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR10_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR10_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR10_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR10_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR10_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR10_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR10_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR10_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR10_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR10_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR10_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR10_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR10_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR10_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR10_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR10_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR10_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR10_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR10_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR10_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR10_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR10_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR10_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR10_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR10_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR10_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR10_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR10_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR10_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR10_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR10_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR10_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR10_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR10_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR10_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR10_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR10_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR10_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR10_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR10_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR10_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR10_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR10_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR10_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR10_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR10_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR10_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR10_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR10_ISF_1 = 0x1

	// PCR11: Pin Control Register n
	// Position of PS field.
	PORT_PCR11_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR11_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR11_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR11_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR11_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR11_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR11_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR11_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR11_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR11_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR11_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR11_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR11_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR11_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR11_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR11_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR11_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR11_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR11_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR11_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR11_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR11_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR11_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR11_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR11_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR11_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR11_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR11_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR11_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR11_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR11_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR11_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR11_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR11_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR11_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR11_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR11_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR11_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR11_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR11_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR11_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR11_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR11_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR11_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR11_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR11_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR11_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR11_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR11_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR11_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR11_ISF_1 = 0x1

	// PCR12: Pin Control Register n
	// Position of PS field.
	PORT_PCR12_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR12_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR12_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR12_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR12_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR12_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR12_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR12_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR12_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR12_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR12_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR12_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR12_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR12_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR12_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR12_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR12_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR12_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR12_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR12_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR12_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR12_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR12_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR12_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR12_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR12_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR12_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR12_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR12_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR12_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR12_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR12_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR12_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR12_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR12_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR12_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR12_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR12_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR12_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR12_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR12_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR12_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR12_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR12_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR12_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR12_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR12_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR12_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR12_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR12_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR12_ISF_1 = 0x1

	// PCR13: Pin Control Register n
	// Position of PS field.
	PORT_PCR13_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR13_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR13_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR13_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR13_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR13_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR13_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR13_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR13_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR13_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR13_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR13_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR13_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR13_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR13_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR13_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR13_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR13_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR13_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR13_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR13_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR13_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR13_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR13_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR13_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR13_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR13_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR13_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR13_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR13_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR13_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR13_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR13_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR13_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR13_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR13_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR13_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR13_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR13_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR13_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR13_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR13_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR13_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR13_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR13_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR13_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR13_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR13_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR13_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR13_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR13_ISF_1 = 0x1

	// PCR14: Pin Control Register n
	// Position of PS field.
	PORT_PCR14_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR14_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR14_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR14_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR14_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR14_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR14_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR14_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR14_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR14_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR14_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR14_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR14_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR14_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR14_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR14_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR14_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR14_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR14_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR14_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR14_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR14_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR14_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR14_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR14_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR14_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR14_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR14_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR14_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR14_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR14_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR14_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR14_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR14_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR14_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR14_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR14_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR14_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR14_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR14_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR14_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR14_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR14_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR14_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR14_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR14_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR14_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR14_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR14_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR14_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR14_ISF_1 = 0x1

	// PCR15: Pin Control Register n
	// Position of PS field.
	PORT_PCR15_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR15_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR15_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR15_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR15_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR15_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR15_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR15_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR15_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR15_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR15_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR15_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR15_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR15_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR15_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR15_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR15_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR15_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR15_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR15_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR15_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR15_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR15_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR15_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR15_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR15_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR15_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR15_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR15_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR15_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR15_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR15_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR15_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR15_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR15_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR15_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR15_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR15_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR15_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR15_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR15_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR15_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR15_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR15_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR15_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR15_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR15_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR15_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR15_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR15_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR15_ISF_1 = 0x1

	// PCR16: Pin Control Register n
	// Position of PS field.
	PORT_PCR16_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR16_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR16_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR16_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR16_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR16_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR16_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR16_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR16_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR16_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR16_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR16_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR16_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR16_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR16_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR16_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR16_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR16_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR16_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR16_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR16_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR16_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR16_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR16_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR16_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR16_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR16_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR16_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR16_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR16_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR16_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR16_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR16_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR16_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR16_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR16_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR16_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR16_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR16_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR16_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR16_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR16_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR16_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR16_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR16_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR16_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR16_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR16_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR16_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR16_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR16_ISF_1 = 0x1

	// PCR17: Pin Control Register n
	// Position of PS field.
	PORT_PCR17_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR17_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR17_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR17_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR17_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR17_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR17_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR17_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR17_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR17_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR17_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR17_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR17_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR17_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR17_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR17_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR17_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR17_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR17_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR17_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR17_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR17_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR17_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR17_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR17_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR17_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR17_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR17_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR17_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR17_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR17_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR17_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR17_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR17_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR17_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR17_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR17_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR17_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR17_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR17_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR17_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR17_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR17_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR17_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR17_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR17_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR17_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR17_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR17_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR17_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR17_ISF_1 = 0x1

	// PCR18: Pin Control Register n
	// Position of PS field.
	PORT_PCR18_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR18_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR18_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR18_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR18_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR18_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR18_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR18_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR18_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR18_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR18_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR18_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR18_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR18_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR18_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR18_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR18_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR18_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR18_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR18_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR18_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR18_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR18_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR18_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR18_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR18_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR18_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR18_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR18_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR18_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR18_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR18_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR18_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR18_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR18_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR18_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR18_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR18_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR18_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR18_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR18_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR18_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR18_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR18_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR18_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR18_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR18_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR18_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR18_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR18_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR18_ISF_1 = 0x1

	// PCR19: Pin Control Register n
	// Position of PS field.
	PORT_PCR19_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR19_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR19_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR19_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR19_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR19_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR19_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR19_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR19_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR19_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR19_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR19_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR19_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR19_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR19_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR19_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR19_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR19_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR19_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR19_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR19_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR19_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR19_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR19_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR19_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR19_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR19_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR19_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR19_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR19_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR19_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR19_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR19_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR19_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR19_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR19_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR19_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR19_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR19_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR19_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR19_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR19_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR19_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR19_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR19_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR19_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR19_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR19_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR19_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR19_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR19_ISF_1 = 0x1

	// PCR20: Pin Control Register n
	// Position of PS field.
	PORT_PCR20_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR20_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR20_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR20_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR20_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR20_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR20_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR20_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR20_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR20_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR20_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR20_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR20_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR20_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR20_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR20_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR20_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR20_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR20_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR20_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR20_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR20_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR20_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR20_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR20_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR20_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR20_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR20_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR20_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR20_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR20_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR20_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR20_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR20_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR20_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR20_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR20_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR20_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR20_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR20_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR20_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR20_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR20_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR20_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR20_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR20_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR20_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR20_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR20_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR20_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR20_ISF_1 = 0x1

	// PCR21: Pin Control Register n
	// Position of PS field.
	PORT_PCR21_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR21_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR21_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR21_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR21_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR21_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR21_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR21_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR21_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR21_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR21_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR21_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR21_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR21_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR21_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR21_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR21_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR21_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR21_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR21_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR21_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR21_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR21_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR21_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR21_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR21_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR21_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR21_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR21_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR21_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR21_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR21_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR21_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR21_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR21_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR21_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR21_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR21_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR21_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR21_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR21_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR21_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR21_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR21_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR21_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR21_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR21_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR21_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR21_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR21_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR21_ISF_1 = 0x1

	// PCR22: Pin Control Register n
	// Position of PS field.
	PORT_PCR22_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR22_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR22_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR22_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR22_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR22_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR22_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR22_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR22_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR22_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR22_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR22_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR22_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR22_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR22_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR22_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR22_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR22_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR22_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR22_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR22_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR22_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR22_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR22_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR22_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR22_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR22_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR22_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR22_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR22_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR22_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR22_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR22_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR22_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR22_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR22_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR22_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR22_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR22_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR22_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR22_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR22_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR22_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR22_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR22_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR22_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR22_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR22_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR22_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR22_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR22_ISF_1 = 0x1

	// PCR23: Pin Control Register n
	// Position of PS field.
	PORT_PCR23_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR23_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR23_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR23_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR23_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR23_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR23_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR23_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR23_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR23_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR23_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR23_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR23_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR23_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR23_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR23_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR23_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR23_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR23_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR23_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR23_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR23_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR23_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR23_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR23_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR23_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR23_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR23_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR23_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR23_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR23_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR23_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR23_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR23_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR23_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR23_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR23_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR23_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR23_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR23_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR23_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR23_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR23_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR23_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR23_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR23_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR23_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR23_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR23_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR23_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR23_ISF_1 = 0x1

	// PCR24: Pin Control Register n
	// Position of PS field.
	PORT_PCR24_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR24_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR24_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR24_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR24_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR24_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR24_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR24_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR24_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR24_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR24_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR24_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR24_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR24_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR24_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR24_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR24_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR24_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR24_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR24_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR24_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR24_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR24_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR24_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR24_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR24_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR24_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR24_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR24_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR24_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR24_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR24_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR24_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR24_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR24_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR24_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR24_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR24_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR24_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR24_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR24_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR24_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR24_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR24_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR24_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR24_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR24_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR24_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR24_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR24_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR24_ISF_1 = 0x1

	// PCR25: Pin Control Register n
	// Position of PS field.
	PORT_PCR25_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR25_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR25_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR25_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR25_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR25_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR25_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR25_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR25_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR25_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR25_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR25_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR25_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR25_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR25_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR25_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR25_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR25_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR25_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR25_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR25_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR25_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR25_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR25_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR25_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR25_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR25_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR25_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR25_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR25_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR25_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR25_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR25_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR25_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR25_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR25_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR25_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR25_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR25_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR25_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR25_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR25_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR25_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR25_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR25_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR25_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR25_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR25_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR25_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR25_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR25_ISF_1 = 0x1

	// PCR26: Pin Control Register n
	// Position of PS field.
	PORT_PCR26_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR26_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR26_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR26_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR26_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR26_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR26_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR26_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR26_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR26_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR26_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR26_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR26_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR26_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR26_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR26_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR26_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR26_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR26_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR26_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR26_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR26_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR26_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR26_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR26_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR26_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR26_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR26_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR26_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR26_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR26_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR26_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR26_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR26_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR26_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR26_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR26_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR26_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR26_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR26_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR26_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR26_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR26_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR26_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR26_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR26_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR26_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR26_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR26_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR26_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR26_ISF_1 = 0x1

	// PCR27: Pin Control Register n
	// Position of PS field.
	PORT_PCR27_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR27_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR27_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR27_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR27_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR27_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR27_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR27_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR27_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR27_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR27_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR27_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR27_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR27_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR27_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR27_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR27_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR27_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR27_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR27_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR27_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR27_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR27_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR27_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR27_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR27_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR27_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR27_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR27_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR27_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR27_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR27_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR27_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR27_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR27_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR27_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR27_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR27_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR27_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR27_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR27_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR27_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR27_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR27_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR27_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR27_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR27_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR27_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR27_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR27_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR27_ISF_1 = 0x1

	// PCR28: Pin Control Register n
	// Position of PS field.
	PORT_PCR28_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR28_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR28_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR28_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR28_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR28_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR28_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR28_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR28_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR28_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR28_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR28_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR28_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR28_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR28_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR28_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR28_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR28_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR28_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR28_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR28_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR28_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR28_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR28_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR28_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR28_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR28_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR28_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR28_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR28_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR28_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR28_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR28_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR28_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR28_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR28_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR28_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR28_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR28_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR28_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR28_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR28_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR28_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR28_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR28_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR28_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR28_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR28_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR28_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR28_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR28_ISF_1 = 0x1

	// PCR29: Pin Control Register n
	// Position of PS field.
	PORT_PCR29_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR29_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR29_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR29_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR29_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR29_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR29_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR29_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR29_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR29_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR29_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR29_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR29_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR29_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR29_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR29_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR29_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR29_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR29_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR29_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR29_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR29_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR29_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR29_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR29_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR29_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR29_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR29_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR29_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR29_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR29_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR29_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR29_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR29_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR29_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR29_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR29_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR29_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR29_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR29_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR29_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR29_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR29_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR29_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR29_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR29_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR29_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR29_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR29_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR29_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR29_ISF_1 = 0x1

	// PCR30: Pin Control Register n
	// Position of PS field.
	PORT_PCR30_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR30_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR30_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR30_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR30_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR30_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR30_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR30_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR30_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR30_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR30_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR30_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR30_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR30_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR30_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR30_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR30_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR30_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR30_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR30_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR30_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR30_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR30_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR30_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR30_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR30_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR30_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR30_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR30_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR30_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR30_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR30_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR30_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR30_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR30_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR30_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR30_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR30_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR30_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR30_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR30_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR30_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR30_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR30_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR30_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR30_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR30_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR30_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR30_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR30_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR30_ISF_1 = 0x1

	// PCR31: Pin Control Register n
	// Position of PS field.
	PORT_PCR31_PS_Pos = 0x0
	// Bit mask of PS field.
	PORT_PCR31_PS_Msk = 0x1
	// Bit PS.
	PORT_PCR31_PS = 0x1
	// Internal pulldown resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR31_PS_0 = 0x0
	// Internal pullup resistor is enabled on the corresponding pin, if the corresponding PE field is set.
	PORT_PCR31_PS_1 = 0x1
	// Position of PE field.
	PORT_PCR31_PE_Pos = 0x1
	// Bit mask of PE field.
	PORT_PCR31_PE_Msk = 0x2
	// Bit PE.
	PORT_PCR31_PE = 0x2
	// Internal pullup or pulldown resistor is not enabled on the corresponding pin.
	PORT_PCR31_PE_0 = 0x0
	// Internal pullup or pulldown resistor is enabled on the corresponding pin, if the pin is configured as a digital input.
	PORT_PCR31_PE_1 = 0x1
	// Position of SRE field.
	PORT_PCR31_SRE_Pos = 0x2
	// Bit mask of SRE field.
	PORT_PCR31_SRE_Msk = 0x4
	// Bit SRE.
	PORT_PCR31_SRE = 0x4
	// Fast slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR31_SRE_0 = 0x0
	// Slow slew rate is configured on the corresponding pin, if the pin is configured as a digital output.
	PORT_PCR31_SRE_1 = 0x1
	// Position of PFE field.
	PORT_PCR31_PFE_Pos = 0x4
	// Bit mask of PFE field.
	PORT_PCR31_PFE_Msk = 0x10
	// Bit PFE.
	PORT_PCR31_PFE = 0x10
	// Passive input filter is disabled on the corresponding pin.
	PORT_PCR31_PFE_0 = 0x0
	// Passive input filter is enabled on the corresponding pin, if the pin is configured as a digital input. Refer to the device data sheet for filter characteristics.
	PORT_PCR31_PFE_1 = 0x1
	// Position of DSE field.
	PORT_PCR31_DSE_Pos = 0x6
	// Bit mask of DSE field.
	PORT_PCR31_DSE_Msk = 0x40
	// Bit DSE.
	PORT_PCR31_DSE = 0x40
	// Low drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR31_DSE_0 = 0x0
	// High drive strength is configured on the corresponding pin, if pin is configured as a digital output.
	PORT_PCR31_DSE_1 = 0x1
	// Position of MUX field.
	PORT_PCR31_MUX_Pos = 0x8
	// Bit mask of MUX field.
	PORT_PCR31_MUX_Msk = 0x700
	// Pin disabled (analog).
	PORT_PCR31_MUX_000 = 0x0
	// Alternative 1 (GPIO).
	PORT_PCR31_MUX_001 = 0x1
	// Alternative 2 (chip-specific).
	PORT_PCR31_MUX_010 = 0x2
	// Alternative 3 (chip-specific).
	PORT_PCR31_MUX_011 = 0x3
	// Alternative 4 (chip-specific).
	PORT_PCR31_MUX_100 = 0x4
	// Alternative 5 (chip-specific).
	PORT_PCR31_MUX_101 = 0x5
	// Alternative 6 (chip-specific).
	PORT_PCR31_MUX_110 = 0x6
	// Alternative 7 (chip-specific).
	PORT_PCR31_MUX_111 = 0x7
	// Position of IRQC field.
	PORT_PCR31_IRQC_Pos = 0x10
	// Bit mask of IRQC field.
	PORT_PCR31_IRQC_Msk = 0xf0000
	// Interrupt/DMA request disabled.
	PORT_PCR31_IRQC_0000 = 0x0
	// DMA request on rising edge.
	PORT_PCR31_IRQC_0001 = 0x1
	// DMA request on falling edge.
	PORT_PCR31_IRQC_0010 = 0x2
	// DMA request on either edge.
	PORT_PCR31_IRQC_0011 = 0x3
	// Interrupt when logic 0.
	PORT_PCR31_IRQC_1000 = 0x8
	// Interrupt on rising-edge.
	PORT_PCR31_IRQC_1001 = 0x9
	// Interrupt on falling-edge.
	PORT_PCR31_IRQC_1010 = 0xa
	// Interrupt on either edge.
	PORT_PCR31_IRQC_1011 = 0xb
	// Interrupt when logic 1.
	PORT_PCR31_IRQC_1100 = 0xc
	// Position of ISF field.
	PORT_PCR31_ISF_Pos = 0x18
	// Bit mask of ISF field.
	PORT_PCR31_ISF_Msk = 0x1000000
	// Bit ISF.
	PORT_PCR31_ISF = 0x1000000
	// Configured interrupt is not detected.
	PORT_PCR31_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_PCR31_ISF_1 = 0x1

	// GPCLR: Global Pin Control Low Register
	// Position of GPWD field.
	PORT_GPCLR_GPWD_Pos = 0x0
	// Bit mask of GPWD field.
	PORT_GPCLR_GPWD_Msk = 0xffff
	// Position of GPWE field.
	PORT_GPCLR_GPWE_Pos = 0x10
	// Bit mask of GPWE field.
	PORT_GPCLR_GPWE_Msk = 0xffff0000
	// Corresponding Pin Control Register is not updated with the value in GPWD.
	PORT_GPCLR_GPWE_0 = 0x0
	// Corresponding Pin Control Register is updated with the value in GPWD.
	PORT_GPCLR_GPWE_1 = 0x1

	// GPCHR: Global Pin Control High Register
	// Position of GPWD field.
	PORT_GPCHR_GPWD_Pos = 0x0
	// Bit mask of GPWD field.
	PORT_GPCHR_GPWD_Msk = 0xffff
	// Position of GPWE field.
	PORT_GPCHR_GPWE_Pos = 0x10
	// Bit mask of GPWE field.
	PORT_GPCHR_GPWE_Msk = 0xffff0000
	// Corresponding Pin Control Register is not updated with the value in GPWD.
	PORT_GPCHR_GPWE_0 = 0x0
	// Corresponding Pin Control Register is updated with the value in GPWD.
	PORT_GPCHR_GPWE_1 = 0x1

	// ISFR: Interrupt Status Flag Register
	// Position of ISF field.
	PORT_ISFR_ISF_Pos = 0x0
	// Bit mask of ISF field.
	PORT_ISFR_ISF_Msk = 0xffffffff
	// Configured interrupt is not detected.
	PORT_ISFR_ISF_0 = 0x0
	// Configured interrupt is detected. If the pin is configured to generate a DMA request, then the corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
	PORT_ISFR_ISF_1 = 0x1
)

// Constants for MCG: Multipurpose Clock Generator module
const (
	// C1: MCG Control 1 Register
	// Position of IREFSTEN field.
	MCG_C1_IREFSTEN_Pos = 0x0
	// Bit mask of IREFSTEN field.
	MCG_C1_IREFSTEN_Msk = 0x1
	// Bit IREFSTEN.
	MCG_C1_IREFSTEN = 0x1
	// Internal reference clock is disabled in Stop mode.
	MCG_C1_IREFSTEN_0 = 0x0
	// Internal reference clock is enabled in Stop mode if IRCLKEN is set or if MCG is in FEI, FBI, or BLPI modes before entering Stop mode.
	MCG_C1_IREFSTEN_1 = 0x1
	// Position of IRCLKEN field.
	MCG_C1_IRCLKEN_Pos = 0x1
	// Bit mask of IRCLKEN field.
	MCG_C1_IRCLKEN_Msk = 0x2
	// Bit IRCLKEN.
	MCG_C1_IRCLKEN = 0x2
	// MCGIRCLK inactive.
	MCG_C1_IRCLKEN_0 = 0x0
	// MCGIRCLK active.
	MCG_C1_IRCLKEN_1 = 0x1
	// Position of IREFS field.
	MCG_C1_IREFS_Pos = 0x2
	// Bit mask of IREFS field.
	MCG_C1_IREFS_Msk = 0x4
	// Bit IREFS.
	MCG_C1_IREFS = 0x4
	// External reference clock is selected.
	MCG_C1_IREFS_0 = 0x0
	// The slow internal reference clock is selected.
	MCG_C1_IREFS_1 = 0x1
	// Position of FRDIV field.
	MCG_C1_FRDIV_Pos = 0x3
	// Bit mask of FRDIV field.
	MCG_C1_FRDIV_Msk = 0x38
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 1; for all other RANGE 0 values, Divide Factor is 32.
	MCG_C1_FRDIV_000 = 0x0
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 2; for all other RANGE 0 values, Divide Factor is 64.
	MCG_C1_FRDIV_001 = 0x1
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 4; for all other RANGE 0 values, Divide Factor is 128.
	MCG_C1_FRDIV_010 = 0x2
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 8; for all other RANGE 0 values, Divide Factor is 256.
	MCG_C1_FRDIV_011 = 0x3
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 16; for all other RANGE 0 values, Divide Factor is 512.
	MCG_C1_FRDIV_100 = 0x4
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 32; for all other RANGE 0 values, Divide Factor is 1024.
	MCG_C1_FRDIV_101 = 0x5
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 64; for all other RANGE 0 values, Divide Factor is 1280 .
	MCG_C1_FRDIV_110 = 0x6
	// If RANGE 0 = 0 or OSCSEL=1 , Divide Factor is 128; for all other RANGE 0 values, Divide Factor is 1536 .
	MCG_C1_FRDIV_111 = 0x7
	// Position of CLKS field.
	MCG_C1_CLKS_Pos = 0x6
	// Bit mask of CLKS field.
	MCG_C1_CLKS_Msk = 0xc0
	// Encoding 0 - Output of FLL or PLL is selected (depends on PLLS control bit).
	MCG_C1_CLKS_00 = 0x0
	// Encoding 1 - Internal reference clock is selected.
	MCG_C1_CLKS_01 = 0x1
	// Encoding 2 - External reference clock is selected.
	MCG_C1_CLKS_10 = 0x2
	// Encoding 3 - Reserved.
	MCG_C1_CLKS_11 = 0x3

	// C2: MCG Control 2 Register
	// Position of IRCS field.
	MCG_C2_IRCS_Pos = 0x0
	// Bit mask of IRCS field.
	MCG_C2_IRCS_Msk = 0x1
	// Bit IRCS.
	MCG_C2_IRCS = 0x1
	// Slow internal reference clock selected.
	MCG_C2_IRCS_0 = 0x0
	// Fast internal reference clock selected.
	MCG_C2_IRCS_1 = 0x1
	// Position of LP field.
	MCG_C2_LP_Pos = 0x1
	// Bit mask of LP field.
	MCG_C2_LP_Msk = 0x2
	// Bit LP.
	MCG_C2_LP = 0x2
	// FLL or PLL is not disabled in bypass modes.
	MCG_C2_LP_0 = 0x0
	// FLL or PLL is disabled in bypass modes (lower power)
	MCG_C2_LP_1 = 0x1
	// Position of EREFS0 field.
	MCG_C2_EREFS0_Pos = 0x2
	// Bit mask of EREFS0 field.
	MCG_C2_EREFS0_Msk = 0x4
	// Bit EREFS0.
	MCG_C2_EREFS0 = 0x4
	// External reference clock requested.
	MCG_C2_EREFS0_0 = 0x0
	// Oscillator requested.
	MCG_C2_EREFS0_1 = 0x1
	// Position of HGO0 field.
	MCG_C2_HGO0_Pos = 0x3
	// Bit mask of HGO0 field.
	MCG_C2_HGO0_Msk = 0x8
	// Bit HGO0.
	MCG_C2_HGO0 = 0x8
	// Configure crystal oscillator for low-power operation.
	MCG_C2_HGO0_0 = 0x0
	// Configure crystal oscillator for high-gain operation.
	MCG_C2_HGO0_1 = 0x1
	// Position of RANGE0 field.
	MCG_C2_RANGE0_Pos = 0x4
	// Bit mask of RANGE0 field.
	MCG_C2_RANGE0_Msk = 0x30
	// Encoding 0 - Low frequency range selected for the crystal oscillator .
	MCG_C2_RANGE0_00 = 0x0
	// Encoding 1 - High frequency range selected for the crystal oscillator .
	MCG_C2_RANGE0_01 = 0x1
	// Position of FCFTRIM field.
	MCG_C2_FCFTRIM_Pos = 0x6
	// Bit mask of FCFTRIM field.
	MCG_C2_FCFTRIM_Msk = 0x40
	// Bit FCFTRIM.
	MCG_C2_FCFTRIM = 0x40
	// Position of LOCRE0 field.
	MCG_C2_LOCRE0_Pos = 0x7
	// Bit mask of LOCRE0 field.
	MCG_C2_LOCRE0_Msk = 0x80
	// Bit LOCRE0.
	MCG_C2_LOCRE0 = 0x80
	// Interrupt request is generated on a loss of OSC0 external reference clock.
	MCG_C2_LOCRE0_0 = 0x0
	// Generate a reset request on a loss of OSC0 external reference clock.
	MCG_C2_LOCRE0_1 = 0x1

	// C3: MCG Control 3 Register
	// Position of SCTRIM field.
	MCG_C3_SCTRIM_Pos = 0x0
	// Bit mask of SCTRIM field.
	MCG_C3_SCTRIM_Msk = 0xff

	// C4: MCG Control 4 Register
	// Position of SCFTRIM field.
	MCG_C4_SCFTRIM_Pos = 0x0
	// Bit mask of SCFTRIM field.
	MCG_C4_SCFTRIM_Msk = 0x1
	// Bit SCFTRIM.
	MCG_C4_SCFTRIM = 0x1
	// Position of FCTRIM field.
	MCG_C4_FCTRIM_Pos = 0x1
	// Bit mask of FCTRIM field.
	MCG_C4_FCTRIM_Msk = 0x1e
	// Position of DRST_DRS field.
	MCG_C4_DRST_DRS_Pos = 0x5
	// Bit mask of DRST_DRS field.
	MCG_C4_DRST_DRS_Msk = 0x60
	// Encoding 0 - Low range (reset default).
	MCG_C4_DRST_DRS_00 = 0x0
	// Encoding 1 - Mid range.
	MCG_C4_DRST_DRS_01 = 0x1
	// Encoding 2 - Mid-high range.
	MCG_C4_DRST_DRS_10 = 0x2
	// Encoding 3 - High range.
	MCG_C4_DRST_DRS_11 = 0x3
	// Position of DMX32 field.
	MCG_C4_DMX32_Pos = 0x7
	// Bit mask of DMX32 field.
	MCG_C4_DMX32_Msk = 0x80
	// Bit DMX32.
	MCG_C4_DMX32 = 0x80
	// DCO has a default range of 25%.
	MCG_C4_DMX32_0 = 0x0
	// DCO is fine-tuned for maximum frequency with 32.768 kHz reference.
	MCG_C4_DMX32_1 = 0x1

	// C5: MCG Control 5 Register
	// Position of PRDIV0 field.
	MCG_C5_PRDIV0_Pos = 0x0
	// Bit mask of PRDIV0 field.
	MCG_C5_PRDIV0_Msk = 0x1f
	// Divide Factor is 1
	MCG_C5_PRDIV0_0 = 0x0
	// Divide Factor is 2
	MCG_C5_PRDIV0_1 = 0x1
	// Divide Factor is 3
	MCG_C5_PRDIV0_2 = 0x2
	// Divide Factor is 4
	MCG_C5_PRDIV0_3 = 0x3
	// Divide Factor is 5
	MCG_C5_PRDIV0_4 = 0x4
	// Divide Factor is 6
	MCG_C5_PRDIV0_5 = 0x5
	// Divide Factor is 7
	MCG_C5_PRDIV0_6 = 0x6
	// Divide Factor is 8
	MCG_C5_PRDIV0_7 = 0x7
	// Divide Factor is 9
	MCG_C5_PRDIV0_8 = 0x8
	// Divide Factor is 10
	MCG_C5_PRDIV0_9 = 0x9
	// Divide Factor is 11
	MCG_C5_PRDIV0_10 = 0xa
	// Divide Factor is 12
	MCG_C5_PRDIV0_11 = 0xb
	// Divide Factor is 13
	MCG_C5_PRDIV0_12 = 0xc
	// Divide Factor is 14
	MCG_C5_PRDIV0_13 = 0xd
	// Divide Factor is 15
	MCG_C5_PRDIV0_14 = 0xe
	// Divide Factor is 16
	MCG_C5_PRDIV0_15 = 0xf
	// Divide Factor is 17
	MCG_C5_PRDIV0_16 = 0x10
	// Divide Factor is 18
	MCG_C5_PRDIV0_17 = 0x11
	// Divide Factor is 19
	MCG_C5_PRDIV0_18 = 0x12
	// Divide Factor is 20
	MCG_C5_PRDIV0_19 = 0x13
	// Divide Factor is 21
	MCG_C5_PRDIV0_20 = 0x14
	// Divide Factor is 22
	MCG_C5_PRDIV0_21 = 0x15
	// Divide Factor is 23
	MCG_C5_PRDIV0_22 = 0x16
	// Divide Factor is 24
	MCG_C5_PRDIV0_23 = 0x17
	// Divide Factor is 25
	MCG_C5_PRDIV0_24 = 0x18
	// Divide Factor is 26
	MCG_C5_PRDIV0_25 = 0x19
	// Divide Factor is 27
	MCG_C5_PRDIV0_26 = 0x1a
	// Divide Factor is 28
	MCG_C5_PRDIV0_27 = 0x1b
	// Divide Factor is 29
	MCG_C5_PRDIV0_28 = 0x1c
	// Divide Factor is 30
	MCG_C5_PRDIV0_29 = 0x1d
	// Divide Factor is 31
	MCG_C5_PRDIV0_30 = 0x1e
	// Divide Factor is 32
	MCG_C5_PRDIV0_31 = 0x1f
	// Position of PLLSTEN0 field.
	MCG_C5_PLLSTEN0_Pos = 0x5
	// Bit mask of PLLSTEN0 field.
	MCG_C5_PLLSTEN0_Msk = 0x20
	// Bit PLLSTEN0.
	MCG_C5_PLLSTEN0 = 0x20
	// MCGPLLCLK is disabled in any of the Stop modes.
	MCG_C5_PLLSTEN0_0 = 0x0
	// MCGPLLCLK is enabled if system is in Normal Stop mode.
	MCG_C5_PLLSTEN0_1 = 0x1
	// Position of PLLCLKEN0 field.
	MCG_C5_PLLCLKEN0_Pos = 0x6
	// Bit mask of PLLCLKEN0 field.
	MCG_C5_PLLCLKEN0_Msk = 0x40
	// Bit PLLCLKEN0.
	MCG_C5_PLLCLKEN0 = 0x40
	// MCGPLLCLK is inactive.
	MCG_C5_PLLCLKEN0_0 = 0x0
	// MCGPLLCLK is active.
	MCG_C5_PLLCLKEN0_1 = 0x1

	// C6: MCG Control 6 Register
	// Position of VDIV0 field.
	MCG_C6_VDIV0_Pos = 0x0
	// Bit mask of VDIV0 field.
	MCG_C6_VDIV0_Msk = 0x1f
	// Multiply Factor is 24
	MCG_C6_VDIV0_0 = 0x0
	// Multiply Factor is 25
	MCG_C6_VDIV0_1 = 0x1
	// Multiply Factor is 26
	MCG_C6_VDIV0_2 = 0x2
	// Multiply Factor is 27
	MCG_C6_VDIV0_3 = 0x3
	// Multiply Factor is 28
	MCG_C6_VDIV0_4 = 0x4
	// Multiply Factor is 29
	MCG_C6_VDIV0_5 = 0x5
	// Multiply Factor is 30
	MCG_C6_VDIV0_6 = 0x6
	// Multiply Factor is 31
	MCG_C6_VDIV0_7 = 0x7
	// Multiply Factor is 32
	MCG_C6_VDIV0_8 = 0x8
	// Multiply Factor is 33
	MCG_C6_VDIV0_9 = 0x9
	// Multiply Factor is 34
	MCG_C6_VDIV0_10 = 0xa
	// Multiply Factor is 35
	MCG_C6_VDIV0_11 = 0xb
	// Multiply Factor is 36
	MCG_C6_VDIV0_12 = 0xc
	// Multiply Factor is 37
	MCG_C6_VDIV0_13 = 0xd
	// Multiply Factor is 38
	MCG_C6_VDIV0_14 = 0xe
	// Multiply Factor is 39
	MCG_C6_VDIV0_15 = 0xf
	// Multiply Factor is 40
	MCG_C6_VDIV0_16 = 0x10
	// Multiply Factor is 41
	MCG_C6_VDIV0_17 = 0x11
	// Multiply Factor is 42
	MCG_C6_VDIV0_18 = 0x12
	// Multiply Factor is 43
	MCG_C6_VDIV0_19 = 0x13
	// Multiply Factor is 44
	MCG_C6_VDIV0_20 = 0x14
	// Multiply Factor is 45
	MCG_C6_VDIV0_21 = 0x15
	// Multiply Factor is 46
	MCG_C6_VDIV0_22 = 0x16
	// Multiply Factor is 47
	MCG_C6_VDIV0_23 = 0x17
	// Multiply Factor is 48
	MCG_C6_VDIV0_24 = 0x18
	// Multiply Factor is 49
	MCG_C6_VDIV0_25 = 0x19
	// Multiply Factor is 50
	MCG_C6_VDIV0_26 = 0x1a
	// Multiply Factor is 51
	MCG_C6_VDIV0_27 = 0x1b
	// Multiply Factor is 52
	MCG_C6_VDIV0_28 = 0x1c
	// Multiply Factor is 53
	MCG_C6_VDIV0_29 = 0x1d
	// Multiply Factor is 54
	MCG_C6_VDIV0_30 = 0x1e
	// Multiply Factor is 55
	MCG_C6_VDIV0_31 = 0x1f
	// Position of CME0 field.
	MCG_C6_CME0_Pos = 0x5
	// Bit mask of CME0 field.
	MCG_C6_CME0_Msk = 0x20
	// Bit CME0.
	MCG_C6_CME0 = 0x20
	// External clock monitor is disabled for OSC0.
	MCG_C6_CME0_0 = 0x0
	// External clock monitor is enabled for OSC0.
	MCG_C6_CME0_1 = 0x1
	// Position of PLLS field.
	MCG_C6_PLLS_Pos = 0x6
	// Bit mask of PLLS field.
	MCG_C6_PLLS_Msk = 0x40
	// Bit PLLS.
	MCG_C6_PLLS = 0x40
	// FLL is selected.
	MCG_C6_PLLS_0 = 0x0
	// PLL is selected (PRDIV 0 need to be programmed to the correct divider to generate a PLL reference clock in the range of 2-4 MHz prior to setting the PLLS bit).
	MCG_C6_PLLS_1 = 0x1
	// Position of LOLIE0 field.
	MCG_C6_LOLIE0_Pos = 0x7
	// Bit mask of LOLIE0 field.
	MCG_C6_LOLIE0_Msk = 0x80
	// Bit LOLIE0.
	MCG_C6_LOLIE0 = 0x80
	// No interrupt request is generated on loss of lock.
	MCG_C6_LOLIE0_0 = 0x0
	// Generate an interrupt request on loss of lock.
	MCG_C6_LOLIE0_1 = 0x1

	// S: MCG Status Register
	// Position of IRCST field.
	MCG_S_IRCST_Pos = 0x0
	// Bit mask of IRCST field.
	MCG_S_IRCST_Msk = 0x1
	// Bit IRCST.
	MCG_S_IRCST = 0x1
	// Source of internal reference clock is the slow clock (32 kHz IRC).
	MCG_S_IRCST_0 = 0x0
	// Source of internal reference clock is the fast clock (4 MHz IRC).
	MCG_S_IRCST_1 = 0x1
	// Position of OSCINIT0 field.
	MCG_S_OSCINIT0_Pos = 0x1
	// Bit mask of OSCINIT0 field.
	MCG_S_OSCINIT0_Msk = 0x2
	// Bit OSCINIT0.
	MCG_S_OSCINIT0 = 0x2
	// Position of CLKST field.
	MCG_S_CLKST_Pos = 0x2
	// Bit mask of CLKST field.
	MCG_S_CLKST_Msk = 0xc
	// Encoding 0 - Output of the FLL is selected (reset default).
	MCG_S_CLKST_00 = 0x0
	// Encoding 1 - Internal reference clock is selected.
	MCG_S_CLKST_01 = 0x1
	// Encoding 2 - External reference clock is selected.
	MCG_S_CLKST_10 = 0x2
	// Encoding 3 - Output of the PLL is selected.
	MCG_S_CLKST_11 = 0x3
	// Position of IREFST field.
	MCG_S_IREFST_Pos = 0x4
	// Bit mask of IREFST field.
	MCG_S_IREFST_Msk = 0x10
	// Bit IREFST.
	MCG_S_IREFST = 0x10
	// Source of FLL reference clock is the external reference clock.
	MCG_S_IREFST_0 = 0x0
	// Source of FLL reference clock is the internal reference clock.
	MCG_S_IREFST_1 = 0x1
	// Position of PLLST field.
	MCG_S_PLLST_Pos = 0x5
	// Bit mask of PLLST field.
	MCG_S_PLLST_Msk = 0x20
	// Bit PLLST.
	MCG_S_PLLST = 0x20
	// Source of PLLS clock is FLL clock.
	MCG_S_PLLST_0 = 0x0
	// Source of PLLS clock is PLL output clock.
	MCG_S_PLLST_1 = 0x1
	// Position of LOCK0 field.
	MCG_S_LOCK0_Pos = 0x6
	// Bit mask of LOCK0 field.
	MCG_S_LOCK0_Msk = 0x40
	// Bit LOCK0.
	MCG_S_LOCK0 = 0x40
	// PLL is currently unlocked.
	MCG_S_LOCK0_0 = 0x0
	// PLL is currently locked.
	MCG_S_LOCK0_1 = 0x1
	// Position of LOLS0 field.
	MCG_S_LOLS0_Pos = 0x7
	// Bit mask of LOLS0 field.
	MCG_S_LOLS0_Msk = 0x80
	// Bit LOLS0.
	MCG_S_LOLS0 = 0x80
	// PLL has not lost lock since LOLS 0 was last cleared.
	MCG_S_LOLS0_0 = 0x0
	// PLL has lost lock since LOLS 0 was last cleared.
	MCG_S_LOLS0_1 = 0x1

	// SC: MCG Status and Control Register
	// Position of LOCS0 field.
	MCG_SC_LOCS0_Pos = 0x0
	// Bit mask of LOCS0 field.
	MCG_SC_LOCS0_Msk = 0x1
	// Bit LOCS0.
	MCG_SC_LOCS0 = 0x1
	// Loss of OSC0 has not occurred.
	MCG_SC_LOCS0_0 = 0x0
	// Loss of OSC0 has occurred.
	MCG_SC_LOCS0_1 = 0x1
	// Position of FCRDIV field.
	MCG_SC_FCRDIV_Pos = 0x1
	// Bit mask of FCRDIV field.
	MCG_SC_FCRDIV_Msk = 0xe
	// Divide Factor is 1
	MCG_SC_FCRDIV_000 = 0x0
	// Divide Factor is 2.
	MCG_SC_FCRDIV_001 = 0x1
	// Divide Factor is 4.
	MCG_SC_FCRDIV_010 = 0x2
	// Divide Factor is 8.
	MCG_SC_FCRDIV_011 = 0x3
	// Divide Factor is 16
	MCG_SC_FCRDIV_100 = 0x4
	// Divide Factor is 32
	MCG_SC_FCRDIV_101 = 0x5
	// Divide Factor is 64
	MCG_SC_FCRDIV_110 = 0x6
	// Divide Factor is 128.
	MCG_SC_FCRDIV_111 = 0x7
	// Position of FLTPRSRV field.
	MCG_SC_FLTPRSRV_Pos = 0x4
	// Bit mask of FLTPRSRV field.
	MCG_SC_FLTPRSRV_Msk = 0x10
	// Bit FLTPRSRV.
	MCG_SC_FLTPRSRV = 0x10
	// FLL filter and FLL frequency will reset on changes to currect clock mode.
	MCG_SC_FLTPRSRV_0 = 0x0
	// Fll filter and FLL frequency retain their previous values during new clock mode change.
	MCG_SC_FLTPRSRV_1 = 0x1
	// Position of ATMF field.
	MCG_SC_ATMF_Pos = 0x5
	// Bit mask of ATMF field.
	MCG_SC_ATMF_Msk = 0x20
	// Bit ATMF.
	MCG_SC_ATMF = 0x20
	// Automatic Trim Machine completed normally.
	MCG_SC_ATMF_0 = 0x0
	// Automatic Trim Machine failed.
	MCG_SC_ATMF_1 = 0x1
	// Position of ATMS field.
	MCG_SC_ATMS_Pos = 0x6
	// Bit mask of ATMS field.
	MCG_SC_ATMS_Msk = 0x40
	// Bit ATMS.
	MCG_SC_ATMS = 0x40
	// 32 kHz Internal Reference Clock selected.
	MCG_SC_ATMS_0 = 0x0
	// 4 MHz Internal Reference Clock selected.
	MCG_SC_ATMS_1 = 0x1
	// Position of ATME field.
	MCG_SC_ATME_Pos = 0x7
	// Bit mask of ATME field.
	MCG_SC_ATME_Msk = 0x80
	// Bit ATME.
	MCG_SC_ATME = 0x80
	// Auto Trim Machine disabled.
	MCG_SC_ATME_0 = 0x0
	// Auto Trim Machine enabled.
	MCG_SC_ATME_1 = 0x1

	// ATCVH: MCG Auto Trim Compare Value High Register
	// Position of ATCVH field.
	MCG_ATCVH_ATCVH_Pos = 0x0
	// Bit mask of ATCVH field.
	MCG_ATCVH_ATCVH_Msk = 0xff

	// ATCVL: MCG Auto Trim Compare Value Low Register
	// Position of ATCVL field.
	MCG_ATCVL_ATCVL_Pos = 0x0
	// Bit mask of ATCVL field.
	MCG_ATCVL_ATCVL_Msk = 0xff

	// C7: MCG Control 7 Register
	// Position of OSCSEL field.
	MCG_C7_OSCSEL_Pos = 0x0
	// Bit mask of OSCSEL field.
	MCG_C7_OSCSEL_Msk = 0x1
	// Bit OSCSEL.
	MCG_C7_OSCSEL = 0x1
	// Selects System Oscillator (OSCCLK).
	MCG_C7_OSCSEL_0 = 0x0
	// Selects 32 kHz RTC Oscillator.
	MCG_C7_OSCSEL_1 = 0x1

	// C8: MCG Control 8 Register
	// Position of LOLRE field.
	MCG_C8_LOLRE_Pos = 0x6
	// Bit mask of LOLRE field.
	MCG_C8_LOLRE_Msk = 0x40
	// Bit LOLRE.
	MCG_C8_LOLRE = 0x40
	// Interrupt request is generated on a PLL loss of lock indication. The PLL loss of lock interrupt enable bit must also be set to generate the interrupt request.
	MCG_C8_LOLRE_0 = 0x0
	// Generate a reset request on a PLL loss of lock indication.
	MCG_C8_LOLRE_1 = 0x1
)

// Constants for OSC0: Oscillator
const (
	// CR: OSC Control Register
	// Position of SC16P field.
	OSC0_CR_SC16P_Pos = 0x0
	// Bit mask of SC16P field.
	OSC0_CR_SC16P_Msk = 0x1
	// Bit SC16P.
	OSC0_CR_SC16P = 0x1
	// Disable the selection.
	OSC0_CR_SC16P_0 = 0x0
	// Add 16 pF capacitor to the oscillator load.
	OSC0_CR_SC16P_1 = 0x1
	// Position of SC8P field.
	OSC0_CR_SC8P_Pos = 0x1
	// Bit mask of SC8P field.
	OSC0_CR_SC8P_Msk = 0x2
	// Bit SC8P.
	OSC0_CR_SC8P = 0x2
	// Disable the selection.
	OSC0_CR_SC8P_0 = 0x0
	// Add 8 pF capacitor to the oscillator load.
	OSC0_CR_SC8P_1 = 0x1
	// Position of SC4P field.
	OSC0_CR_SC4P_Pos = 0x2
	// Bit mask of SC4P field.
	OSC0_CR_SC4P_Msk = 0x4
	// Bit SC4P.
	OSC0_CR_SC4P = 0x4
	// Disable the selection.
	OSC0_CR_SC4P_0 = 0x0
	// Add 4 pF capacitor to the oscillator load.
	OSC0_CR_SC4P_1 = 0x1
	// Position of SC2P field.
	OSC0_CR_SC2P_Pos = 0x3
	// Bit mask of SC2P field.
	OSC0_CR_SC2P_Msk = 0x8
	// Bit SC2P.
	OSC0_CR_SC2P = 0x8
	// Disable the selection.
	OSC0_CR_SC2P_0 = 0x0
	// Add 2 pF capacitor to the oscillator load.
	OSC0_CR_SC2P_1 = 0x1
	// Position of EREFSTEN field.
	OSC0_CR_EREFSTEN_Pos = 0x5
	// Bit mask of EREFSTEN field.
	OSC0_CR_EREFSTEN_Msk = 0x20
	// Bit EREFSTEN.
	OSC0_CR_EREFSTEN = 0x20
	// External reference clock is disabled in Stop mode.
	OSC0_CR_EREFSTEN_0 = 0x0
	// External reference clock stays enabled in Stop mode if ERCLKEN is set before entering Stop mode.
	OSC0_CR_EREFSTEN_1 = 0x1
	// Position of ERCLKEN field.
	OSC0_CR_ERCLKEN_Pos = 0x7
	// Bit mask of ERCLKEN field.
	OSC0_CR_ERCLKEN_Msk = 0x80
	// Bit ERCLKEN.
	OSC0_CR_ERCLKEN = 0x80
	// External reference clock is inactive.
	OSC0_CR_ERCLKEN_0 = 0x0
	// External reference clock is enabled.
	OSC0_CR_ERCLKEN_1 = 0x1
)

// Constants for I2C0: Inter-Integrated Circuit
const (
	// A1: I2C Address Register 1
	// Position of AD field.
	I2C_A1_AD_Pos = 0x1
	// Bit mask of AD field.
	I2C_A1_AD_Msk = 0xfe

	// F: I2C Frequency Divider register
	// Position of ICR field.
	I2C_F_ICR_Pos = 0x0
	// Bit mask of ICR field.
	I2C_F_ICR_Msk = 0x3f
	// Position of MULT field.
	I2C_F_MULT_Pos = 0x6
	// Bit mask of MULT field.
	I2C_F_MULT_Msk = 0xc0
	// mul = 1
	I2C_F_MULT_00 = 0x0
	// mul = 2
	I2C_F_MULT_01 = 0x1
	// mul = 4
	I2C_F_MULT_10 = 0x2

	// C1: I2C Control Register 1
	// Position of DMAEN field.
	I2C_C1_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	I2C_C1_DMAEN_Msk = 0x1
	// Bit DMAEN.
	I2C_C1_DMAEN = 0x1
	// All DMA signalling disabled.
	I2C_C1_DMAEN_0 = 0x0
	// DMA transfer is enabled. While SMB[FACK] = 0, the following conditions trigger the DMA request: a data byte is received, and either address or data is transmitted. (ACK/NACK is automatic) the first byte received matches the A1 register or is a general call address. If any address matching occurs, S[IAAS] and S[TCF] are set. If the direction of transfer is known from master to slave, then it is not required to check S[SRW]. With this assumption, DMA can also be used in this case. In other cases, if the master reads data from the slave, then it is required to rewrite the C1 register operation. With this assumption, DMA cannot be used. When FACK = 1, an address or a data byte is transmitted.
	I2C_C1_DMAEN_1 = 0x1
	// Position of WUEN field.
	I2C_C1_WUEN_Pos = 0x1
	// Bit mask of WUEN field.
	I2C_C1_WUEN_Msk = 0x2
	// Bit WUEN.
	I2C_C1_WUEN = 0x2
	// Normal operation. No interrupt generated when address matching in low power mode.
	I2C_C1_WUEN_0 = 0x0
	// Enables the wakeup function in low power mode.
	I2C_C1_WUEN_1 = 0x1
	// Position of RSTA field.
	I2C_C1_RSTA_Pos = 0x2
	// Bit mask of RSTA field.
	I2C_C1_RSTA_Msk = 0x4
	// Bit RSTA.
	I2C_C1_RSTA = 0x4
	// Position of TXAK field.
	I2C_C1_TXAK_Pos = 0x3
	// Bit mask of TXAK field.
	I2C_C1_TXAK_Msk = 0x8
	// Bit TXAK.
	I2C_C1_TXAK = 0x8
	// An acknowledge signal is sent to the bus on the following receiving byte (if FACK is cleared) or the current receiving byte (if FACK is set).
	I2C_C1_TXAK_0 = 0x0
	// No acknowledge signal is sent to the bus on the following receiving data byte (if FACK is cleared) or the current receiving data byte (if FACK is set).
	I2C_C1_TXAK_1 = 0x1
	// Position of TX field.
	I2C_C1_TX_Pos = 0x4
	// Bit mask of TX field.
	I2C_C1_TX_Msk = 0x10
	// Bit TX.
	I2C_C1_TX = 0x10
	// Receive
	I2C_C1_TX_0 = 0x0
	// Transmit
	I2C_C1_TX_1 = 0x1
	// Position of MST field.
	I2C_C1_MST_Pos = 0x5
	// Bit mask of MST field.
	I2C_C1_MST_Msk = 0x20
	// Bit MST.
	I2C_C1_MST = 0x20
	// Slave mode
	I2C_C1_MST_0 = 0x0
	// Master mode
	I2C_C1_MST_1 = 0x1
	// Position of IICIE field.
	I2C_C1_IICIE_Pos = 0x6
	// Bit mask of IICIE field.
	I2C_C1_IICIE_Msk = 0x40
	// Bit IICIE.
	I2C_C1_IICIE = 0x40
	// Disabled
	I2C_C1_IICIE_0 = 0x0
	// Enabled
	I2C_C1_IICIE_1 = 0x1
	// Position of IICEN field.
	I2C_C1_IICEN_Pos = 0x7
	// Bit mask of IICEN field.
	I2C_C1_IICEN_Msk = 0x80
	// Bit IICEN.
	I2C_C1_IICEN = 0x80
	// Disabled
	I2C_C1_IICEN_0 = 0x0
	// Enabled
	I2C_C1_IICEN_1 = 0x1

	// S: I2C Status register
	// Position of RXAK field.
	I2C_S_RXAK_Pos = 0x0
	// Bit mask of RXAK field.
	I2C_S_RXAK_Msk = 0x1
	// Bit RXAK.
	I2C_S_RXAK = 0x1
	// Acknowledge signal was received after the completion of one byte of data transmission on the bus
	I2C_S_RXAK_0 = 0x0
	// No acknowledge signal detected
	I2C_S_RXAK_1 = 0x1
	// Position of IICIF field.
	I2C_S_IICIF_Pos = 0x1
	// Bit mask of IICIF field.
	I2C_S_IICIF_Msk = 0x2
	// Bit IICIF.
	I2C_S_IICIF = 0x2
	// No interrupt pending
	I2C_S_IICIF_0 = 0x0
	// Interrupt pending
	I2C_S_IICIF_1 = 0x1
	// Position of SRW field.
	I2C_S_SRW_Pos = 0x2
	// Bit mask of SRW field.
	I2C_S_SRW_Msk = 0x4
	// Bit SRW.
	I2C_S_SRW = 0x4
	// Slave receive, master writing to slave
	I2C_S_SRW_0 = 0x0
	// Slave transmit, master reading from slave
	I2C_S_SRW_1 = 0x1
	// Position of RAM field.
	I2C_S_RAM_Pos = 0x3
	// Bit mask of RAM field.
	I2C_S_RAM_Msk = 0x8
	// Bit RAM.
	I2C_S_RAM = 0x8
	// Not addressed
	I2C_S_RAM_0 = 0x0
	// Addressed as a slave
	I2C_S_RAM_1 = 0x1
	// Position of ARBL field.
	I2C_S_ARBL_Pos = 0x4
	// Bit mask of ARBL field.
	I2C_S_ARBL_Msk = 0x10
	// Bit ARBL.
	I2C_S_ARBL = 0x10
	// Standard bus operation.
	I2C_S_ARBL_0 = 0x0
	// Loss of arbitration.
	I2C_S_ARBL_1 = 0x1
	// Position of BUSY field.
	I2C_S_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	I2C_S_BUSY_Msk = 0x20
	// Bit BUSY.
	I2C_S_BUSY = 0x20
	// Bus is idle
	I2C_S_BUSY_0 = 0x0
	// Bus is busy
	I2C_S_BUSY_1 = 0x1
	// Position of IAAS field.
	I2C_S_IAAS_Pos = 0x6
	// Bit mask of IAAS field.
	I2C_S_IAAS_Msk = 0x40
	// Bit IAAS.
	I2C_S_IAAS = 0x40
	// Not addressed
	I2C_S_IAAS_0 = 0x0
	// Addressed as a slave
	I2C_S_IAAS_1 = 0x1
	// Position of TCF field.
	I2C_S_TCF_Pos = 0x7
	// Bit mask of TCF field.
	I2C_S_TCF_Msk = 0x80
	// Bit TCF.
	I2C_S_TCF = 0x80
	// Transfer in progress
	I2C_S_TCF_0 = 0x0
	// Transfer complete
	I2C_S_TCF_1 = 0x1

	// D: I2C Data I/O register
	// Position of DATA field.
	I2C_D_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2C_D_DATA_Msk = 0xff

	// C2: I2C Control Register 2
	// Position of AD field.
	I2C_C2_AD_Pos = 0x0
	// Bit mask of AD field.
	I2C_C2_AD_Msk = 0x7
	// Position of RMEN field.
	I2C_C2_RMEN_Pos = 0x3
	// Bit mask of RMEN field.
	I2C_C2_RMEN_Msk = 0x8
	// Bit RMEN.
	I2C_C2_RMEN = 0x8
	// Range mode disabled. No address match occurs for an address within the range of values of the A1 and RA registers.
	I2C_C2_RMEN_0 = 0x0
	// Range mode enabled. Address matching occurs when a slave receives an address within the range of values of the A1 and RA registers.
	I2C_C2_RMEN_1 = 0x1
	// Position of SBRC field.
	I2C_C2_SBRC_Pos = 0x4
	// Bit mask of SBRC field.
	I2C_C2_SBRC_Msk = 0x10
	// Bit SBRC.
	I2C_C2_SBRC = 0x10
	// The slave baud rate follows the master baud rate and clock stretching may occur
	I2C_C2_SBRC_0 = 0x0
	// Slave baud rate is independent of the master baud rate
	I2C_C2_SBRC_1 = 0x1
	// Position of HDRS field.
	I2C_C2_HDRS_Pos = 0x5
	// Bit mask of HDRS field.
	I2C_C2_HDRS_Msk = 0x20
	// Bit HDRS.
	I2C_C2_HDRS = 0x20
	// Normal drive mode
	I2C_C2_HDRS_0 = 0x0
	// High drive mode
	I2C_C2_HDRS_1 = 0x1
	// Position of ADEXT field.
	I2C_C2_ADEXT_Pos = 0x6
	// Bit mask of ADEXT field.
	I2C_C2_ADEXT_Msk = 0x40
	// Bit ADEXT.
	I2C_C2_ADEXT = 0x40
	// 7-bit address scheme
	I2C_C2_ADEXT_0 = 0x0
	// 10-bit address scheme
	I2C_C2_ADEXT_1 = 0x1
	// Position of GCAEN field.
	I2C_C2_GCAEN_Pos = 0x7
	// Bit mask of GCAEN field.
	I2C_C2_GCAEN_Msk = 0x80
	// Bit GCAEN.
	I2C_C2_GCAEN = 0x80
	// Disabled
	I2C_C2_GCAEN_0 = 0x0
	// Enabled
	I2C_C2_GCAEN_1 = 0x1

	// FLT: I2C Programmable Input Glitch Filter register
	// Position of FLT field.
	I2C_FLT_FLT_Pos = 0x0
	// Bit mask of FLT field.
	I2C_FLT_FLT_Msk = 0xf
	// No filter/bypass
	I2C_FLT_FLT_0 = 0x0
	// Position of STARTF field.
	I2C_FLT_STARTF_Pos = 0x4
	// Bit mask of STARTF field.
	I2C_FLT_STARTF_Msk = 0x10
	// Bit STARTF.
	I2C_FLT_STARTF = 0x10
	// No start happens on I2C bus
	I2C_FLT_STARTF_0 = 0x0
	// Start detected on I2C bus
	I2C_FLT_STARTF_1 = 0x1
	// Position of SSIE field.
	I2C_FLT_SSIE_Pos = 0x5
	// Bit mask of SSIE field.
	I2C_FLT_SSIE_Msk = 0x20
	// Bit SSIE.
	I2C_FLT_SSIE = 0x20
	// Stop or start detection interrupt is disabled
	I2C_FLT_SSIE_0 = 0x0
	// Stop or start detection interrupt is enabled
	I2C_FLT_SSIE_1 = 0x1
	// Position of STOPF field.
	I2C_FLT_STOPF_Pos = 0x6
	// Bit mask of STOPF field.
	I2C_FLT_STOPF_Msk = 0x40
	// Bit STOPF.
	I2C_FLT_STOPF = 0x40
	// No stop happens on I2C bus
	I2C_FLT_STOPF_0 = 0x0
	// Stop detected on I2C bus
	I2C_FLT_STOPF_1 = 0x1
	// Position of SHEN field.
	I2C_FLT_SHEN_Pos = 0x7
	// Bit mask of SHEN field.
	I2C_FLT_SHEN_Msk = 0x80
	// Bit SHEN.
	I2C_FLT_SHEN = 0x80
	// Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
	I2C_FLT_SHEN_0 = 0x0
	// Stop holdoff is enabled.
	I2C_FLT_SHEN_1 = 0x1

	// RA: I2C Range Address register
	// Position of RAD field.
	I2C_RA_RAD_Pos = 0x1
	// Bit mask of RAD field.
	I2C_RA_RAD_Msk = 0xfe

	// SMB: I2C SMBus Control and Status register
	// Position of SHTF2IE field.
	I2C_SMB_SHTF2IE_Pos = 0x0
	// Bit mask of SHTF2IE field.
	I2C_SMB_SHTF2IE_Msk = 0x1
	// Bit SHTF2IE.
	I2C_SMB_SHTF2IE = 0x1
	// SHTF2 interrupt is disabled
	I2C_SMB_SHTF2IE_0 = 0x0
	// SHTF2 interrupt is enabled
	I2C_SMB_SHTF2IE_1 = 0x1
	// Position of SHTF2 field.
	I2C_SMB_SHTF2_Pos = 0x1
	// Bit mask of SHTF2 field.
	I2C_SMB_SHTF2_Msk = 0x2
	// Bit SHTF2.
	I2C_SMB_SHTF2 = 0x2
	// No SCL high and SDA low timeout occurs
	I2C_SMB_SHTF2_0 = 0x0
	// SCL high and SDA low timeout occurs
	I2C_SMB_SHTF2_1 = 0x1
	// Position of SHTF1 field.
	I2C_SMB_SHTF1_Pos = 0x2
	// Bit mask of SHTF1 field.
	I2C_SMB_SHTF1_Msk = 0x4
	// Bit SHTF1.
	I2C_SMB_SHTF1 = 0x4
	// No SCL high and SDA high timeout occurs
	I2C_SMB_SHTF1_0 = 0x0
	// SCL high and SDA high timeout occurs
	I2C_SMB_SHTF1_1 = 0x1
	// Position of SLTF field.
	I2C_SMB_SLTF_Pos = 0x3
	// Bit mask of SLTF field.
	I2C_SMB_SLTF_Msk = 0x8
	// Bit SLTF.
	I2C_SMB_SLTF = 0x8
	// No low timeout occurs
	I2C_SMB_SLTF_0 = 0x0
	// Low timeout occurs
	I2C_SMB_SLTF_1 = 0x1
	// Position of TCKSEL field.
	I2C_SMB_TCKSEL_Pos = 0x4
	// Bit mask of TCKSEL field.
	I2C_SMB_TCKSEL_Msk = 0x10
	// Bit TCKSEL.
	I2C_SMB_TCKSEL = 0x10
	// Timeout counter counts at the frequency of the I2C module clock / 64
	I2C_SMB_TCKSEL_0 = 0x0
	// Timeout counter counts at the frequency of the I2C module clock
	I2C_SMB_TCKSEL_1 = 0x1
	// Position of SIICAEN field.
	I2C_SMB_SIICAEN_Pos = 0x5
	// Bit mask of SIICAEN field.
	I2C_SMB_SIICAEN_Msk = 0x20
	// Bit SIICAEN.
	I2C_SMB_SIICAEN = 0x20
	// I2C address register 2 matching is disabled
	I2C_SMB_SIICAEN_0 = 0x0
	// I2C address register 2 matching is enabled
	I2C_SMB_SIICAEN_1 = 0x1
	// Position of ALERTEN field.
	I2C_SMB_ALERTEN_Pos = 0x6
	// Bit mask of ALERTEN field.
	I2C_SMB_ALERTEN_Msk = 0x40
	// Bit ALERTEN.
	I2C_SMB_ALERTEN = 0x40
	// SMBus alert response address matching is disabled
	I2C_SMB_ALERTEN_0 = 0x0
	// SMBus alert response address matching is enabled
	I2C_SMB_ALERTEN_1 = 0x1
	// Position of FACK field.
	I2C_SMB_FACK_Pos = 0x7
	// Bit mask of FACK field.
	I2C_SMB_FACK_Msk = 0x80
	// Bit FACK.
	I2C_SMB_FACK = 0x80
	// An ACK or NACK is sent on the following receiving data byte
	I2C_SMB_FACK_0 = 0x0
	// Writing 0 to TXAK after receiving a data byte generates an ACK. Writing 1 to TXAK after receiving a data byte generates a NACK.
	I2C_SMB_FACK_1 = 0x1

	// A2: I2C Address Register 2
	// Position of SAD field.
	I2C_A2_SAD_Pos = 0x1
	// Bit mask of SAD field.
	I2C_A2_SAD_Msk = 0xfe

	// SLTH: I2C SCL Low Timeout Register High
	// Position of SSLT field.
	I2C_SLTH_SSLT_Pos = 0x0
	// Bit mask of SSLT field.
	I2C_SLTH_SSLT_Msk = 0xff

	// SLTL: I2C SCL Low Timeout Register Low
	// Position of SSLT field.
	I2C_SLTL_SSLT_Pos = 0x0
	// Bit mask of SSLT field.
	I2C_SLTL_SSLT_Msk = 0xff
)

// Constants for UART0: Universal Asynchronous Receiver/Transmitter
const (
	// BDH: UART Baud Rate Register High
	// Position of SBR field.
	UART0_BDH_SBR_Pos = 0x0
	// Bit mask of SBR field.
	UART0_BDH_SBR_Msk = 0x1f
	// Position of SBNS field.
	UART0_BDH_SBNS_Pos = 0x5
	// Bit mask of SBNS field.
	UART0_BDH_SBNS_Msk = 0x20
	// Bit SBNS.
	UART0_BDH_SBNS = 0x20
	// One stop bit.
	UART0_BDH_SBNS_0 = 0x0
	// Two stop bit.
	UART0_BDH_SBNS_1 = 0x1
	// Position of RXEDGIE field.
	UART0_BDH_RXEDGIE_Pos = 0x6
	// Bit mask of RXEDGIE field.
	UART0_BDH_RXEDGIE_Msk = 0x40
	// Bit RXEDGIE.
	UART0_BDH_RXEDGIE = 0x40
	// Hardware interrupts from UART_S2[RXEDGIF] disabled (use polling).
	UART0_BDH_RXEDGIE_0 = 0x0
	// Hardware interrupt requested when UART_S2[RXEDGIF] flag is 1.
	UART0_BDH_RXEDGIE_1 = 0x1
	// Position of LBKDIE field.
	UART0_BDH_LBKDIE_Pos = 0x7
	// Bit mask of LBKDIE field.
	UART0_BDH_LBKDIE_Msk = 0x80
	// Bit LBKDIE.
	UART0_BDH_LBKDIE = 0x80
	// Hardware interrupts from UART_S2[LBKDIF] disabled (use polling).
	UART0_BDH_LBKDIE_0 = 0x0
	// Hardware interrupt requested when UART_S2[LBKDIF] flag is 1.
	UART0_BDH_LBKDIE_1 = 0x1

	// BDL: UART Baud Rate Register Low
	// Position of SBR field.
	UART0_BDL_SBR_Pos = 0x0
	// Bit mask of SBR field.
	UART0_BDL_SBR_Msk = 0xff

	// C1: UART Control Register 1
	// Position of PT field.
	UART0_C1_PT_Pos = 0x0
	// Bit mask of PT field.
	UART0_C1_PT_Msk = 0x1
	// Bit PT.
	UART0_C1_PT = 0x1
	// Even parity.
	UART0_C1_PT_0 = 0x0
	// Odd parity.
	UART0_C1_PT_1 = 0x1
	// Position of PE field.
	UART0_C1_PE_Pos = 0x1
	// Bit mask of PE field.
	UART0_C1_PE_Msk = 0x2
	// Bit PE.
	UART0_C1_PE = 0x2
	// No hardware parity generation or checking.
	UART0_C1_PE_0 = 0x0
	// Parity enabled.
	UART0_C1_PE_1 = 0x1
	// Position of ILT field.
	UART0_C1_ILT_Pos = 0x2
	// Bit mask of ILT field.
	UART0_C1_ILT_Msk = 0x4
	// Bit ILT.
	UART0_C1_ILT = 0x4
	// Idle character bit count starts after start bit.
	UART0_C1_ILT_0 = 0x0
	// Idle character bit count starts after stop bit.
	UART0_C1_ILT_1 = 0x1
	// Position of WAKE field.
	UART0_C1_WAKE_Pos = 0x3
	// Bit mask of WAKE field.
	UART0_C1_WAKE_Msk = 0x8
	// Bit WAKE.
	UART0_C1_WAKE = 0x8
	// Idle-line wakeup.
	UART0_C1_WAKE_0 = 0x0
	// Address-mark wakeup.
	UART0_C1_WAKE_1 = 0x1
	// Position of M field.
	UART0_C1_M_Pos = 0x4
	// Bit mask of M field.
	UART0_C1_M_Msk = 0x10
	// Bit M.
	UART0_C1_M = 0x10
	// Receiver and transmitter use 8-bit data characters.
	UART0_C1_M_0 = 0x0
	// Receiver and transmitter use 9-bit data characters.
	UART0_C1_M_1 = 0x1
	// Position of RSRC field.
	UART0_C1_RSRC_Pos = 0x5
	// Bit mask of RSRC field.
	UART0_C1_RSRC_Msk = 0x20
	// Bit RSRC.
	UART0_C1_RSRC = 0x20
	// Provided LOOPS is set, RSRC is cleared, selects internal loop back mode and the UART does not use the UART_RX pins.
	UART0_C1_RSRC_0 = 0x0
	// Single-wire UART mode where the UART_TX pin is connected to the transmitter output and receiver input.
	UART0_C1_RSRC_1 = 0x1
	// Position of DOZEEN field.
	UART0_C1_DOZEEN_Pos = 0x6
	// Bit mask of DOZEEN field.
	UART0_C1_DOZEEN_Msk = 0x40
	// Bit DOZEEN.
	UART0_C1_DOZEEN = 0x40
	// UART is enabled in Wait mode.
	UART0_C1_DOZEEN_0 = 0x0
	// UART is disabled in Wait mode.
	UART0_C1_DOZEEN_1 = 0x1
	// Position of LOOPS field.
	UART0_C1_LOOPS_Pos = 0x7
	// Bit mask of LOOPS field.
	UART0_C1_LOOPS_Msk = 0x80
	// Bit LOOPS.
	UART0_C1_LOOPS = 0x80
	// Normal operation - UART_RX and UART_TX use separate pins.
	UART0_C1_LOOPS_0 = 0x0
	// Loop mode or single-wire mode where transmitter outputs are internally connected to receiver input. (See RSRC bit.) UART_RX pin is not used by UART.
	UART0_C1_LOOPS_1 = 0x1

	// C2: UART Control Register 2
	// Position of SBK field.
	UART0_C2_SBK_Pos = 0x0
	// Bit mask of SBK field.
	UART0_C2_SBK_Msk = 0x1
	// Bit SBK.
	UART0_C2_SBK = 0x1
	// Normal transmitter operation.
	UART0_C2_SBK_0 = 0x0
	// Queue break character(s) to be sent.
	UART0_C2_SBK_1 = 0x1
	// Position of RWU field.
	UART0_C2_RWU_Pos = 0x1
	// Bit mask of RWU field.
	UART0_C2_RWU_Msk = 0x2
	// Bit RWU.
	UART0_C2_RWU = 0x2
	// Normal UART receiver operation.
	UART0_C2_RWU_0 = 0x0
	// UART receiver in standby waiting for wakeup condition.
	UART0_C2_RWU_1 = 0x1
	// Position of RE field.
	UART0_C2_RE_Pos = 0x2
	// Bit mask of RE field.
	UART0_C2_RE_Msk = 0x4
	// Bit RE.
	UART0_C2_RE = 0x4
	// Receiver disabled.
	UART0_C2_RE_0 = 0x0
	// Receiver enabled.
	UART0_C2_RE_1 = 0x1
	// Position of TE field.
	UART0_C2_TE_Pos = 0x3
	// Bit mask of TE field.
	UART0_C2_TE_Msk = 0x8
	// Bit TE.
	UART0_C2_TE = 0x8
	// Transmitter disabled.
	UART0_C2_TE_0 = 0x0
	// Transmitter enabled.
	UART0_C2_TE_1 = 0x1
	// Position of ILIE field.
	UART0_C2_ILIE_Pos = 0x4
	// Bit mask of ILIE field.
	UART0_C2_ILIE_Msk = 0x10
	// Bit ILIE.
	UART0_C2_ILIE = 0x10
	// Hardware interrupts from IDLE disabled; use polling.
	UART0_C2_ILIE_0 = 0x0
	// Hardware interrupt requested when IDLE flag is 1.
	UART0_C2_ILIE_1 = 0x1
	// Position of RIE field.
	UART0_C2_RIE_Pos = 0x5
	// Bit mask of RIE field.
	UART0_C2_RIE_Msk = 0x20
	// Bit RIE.
	UART0_C2_RIE = 0x20
	// Hardware interrupts from RDRF disabled; use polling.
	UART0_C2_RIE_0 = 0x0
	// Hardware interrupt requested when RDRF flag is 1.
	UART0_C2_RIE_1 = 0x1
	// Position of TCIE field.
	UART0_C2_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	UART0_C2_TCIE_Msk = 0x40
	// Bit TCIE.
	UART0_C2_TCIE = 0x40
	// Hardware interrupts from TC disabled; use polling.
	UART0_C2_TCIE_0 = 0x0
	// Hardware interrupt requested when TC flag is 1.
	UART0_C2_TCIE_1 = 0x1
	// Position of TIE field.
	UART0_C2_TIE_Pos = 0x7
	// Bit mask of TIE field.
	UART0_C2_TIE_Msk = 0x80
	// Bit TIE.
	UART0_C2_TIE = 0x80
	// Hardware interrupts from TDRE disabled; use polling.
	UART0_C2_TIE_0 = 0x0
	// Hardware interrupt requested when TDRE flag is 1.
	UART0_C2_TIE_1 = 0x1

	// S1: UART Status Register 1
	// Position of PF field.
	UART0_S1_PF_Pos = 0x0
	// Bit mask of PF field.
	UART0_S1_PF_Msk = 0x1
	// Bit PF.
	UART0_S1_PF = 0x1
	// No parity error.
	UART0_S1_PF_0 = 0x0
	// Parity error.
	UART0_S1_PF_1 = 0x1
	// Position of FE field.
	UART0_S1_FE_Pos = 0x1
	// Bit mask of FE field.
	UART0_S1_FE_Msk = 0x2
	// Bit FE.
	UART0_S1_FE = 0x2
	// No framing error detected. This does not guarantee the framing is correct.
	UART0_S1_FE_0 = 0x0
	// Framing error.
	UART0_S1_FE_1 = 0x1
	// Position of NF field.
	UART0_S1_NF_Pos = 0x2
	// Bit mask of NF field.
	UART0_S1_NF_Msk = 0x4
	// Bit NF.
	UART0_S1_NF = 0x4
	// No noise detected.
	UART0_S1_NF_0 = 0x0
	// Noise detected in the received character in UART_D.
	UART0_S1_NF_1 = 0x1
	// Position of OR field.
	UART0_S1_OR_Pos = 0x3
	// Bit mask of OR field.
	UART0_S1_OR_Msk = 0x8
	// Bit OR.
	UART0_S1_OR = 0x8
	// No overrun.
	UART0_S1_OR_0 = 0x0
	// Receive overrun (new UART data lost).
	UART0_S1_OR_1 = 0x1
	// Position of IDLE field.
	UART0_S1_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	UART0_S1_IDLE_Msk = 0x10
	// Bit IDLE.
	UART0_S1_IDLE = 0x10
	// No idle line detected.
	UART0_S1_IDLE_0 = 0x0
	// Idle line was detected.
	UART0_S1_IDLE_1 = 0x1
	// Position of RDRF field.
	UART0_S1_RDRF_Pos = 0x5
	// Bit mask of RDRF field.
	UART0_S1_RDRF_Msk = 0x20
	// Bit RDRF.
	UART0_S1_RDRF = 0x20
	// Receive data buffer empty.
	UART0_S1_RDRF_0 = 0x0
	// Receive data buffer full.
	UART0_S1_RDRF_1 = 0x1
	// Position of TC field.
	UART0_S1_TC_Pos = 0x6
	// Bit mask of TC field.
	UART0_S1_TC_Msk = 0x40
	// Bit TC.
	UART0_S1_TC = 0x40
	// Transmitter active (sending data, a preamble, or a break).
	UART0_S1_TC_0 = 0x0
	// Transmitter idle (transmission activity complete).
	UART0_S1_TC_1 = 0x1
	// Position of TDRE field.
	UART0_S1_TDRE_Pos = 0x7
	// Bit mask of TDRE field.
	UART0_S1_TDRE_Msk = 0x80
	// Bit TDRE.
	UART0_S1_TDRE = 0x80
	// Transmit data buffer full.
	UART0_S1_TDRE_0 = 0x0
	// Transmit data buffer empty.
	UART0_S1_TDRE_1 = 0x1

	// S2: UART Status Register 2
	// Position of RAF field.
	UART0_S2_RAF_Pos = 0x0
	// Bit mask of RAF field.
	UART0_S2_RAF_Msk = 0x1
	// Bit RAF.
	UART0_S2_RAF = 0x1
	// UART receiver idle waiting for a start bit.
	UART0_S2_RAF_0 = 0x0
	// UART receiver active ( UART_RXD input not idle).
	UART0_S2_RAF_1 = 0x1
	// Position of LBKDE field.
	UART0_S2_LBKDE_Pos = 0x1
	// Bit mask of LBKDE field.
	UART0_S2_LBKDE_Msk = 0x2
	// Bit LBKDE.
	UART0_S2_LBKDE = 0x2
	// Break character is detected at length 10 bit times (if M = 0, SBNS = 0) or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
	UART0_S2_LBKDE_0 = 0x0
	// Break character is detected at length of 11 bit times (if M = 0, SBNS = 0) or 12 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 14 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 15 (if M10 = 1, SNBS = 1).
	UART0_S2_LBKDE_1 = 0x1
	// Position of BRK13 field.
	UART0_S2_BRK13_Pos = 0x2
	// Bit mask of BRK13 field.
	UART0_S2_BRK13_Msk = 0x4
	// Bit BRK13.
	UART0_S2_BRK13 = 0x4
	// Break character is transmitted with length of 10 bit times (if M = 0, SBNS = 0) or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 13 (if M10 = 1, SNBS = 1).
	UART0_S2_BRK13_0 = 0x0
	// Break character is transmitted with length of 13 bit times (if M = 0, SBNS = 0) or 14 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 15 (if M = 1, SBNS = 1 or M10 = 1, SNBS = 0) or 16 (if M10 = 1, SNBS = 1).
	UART0_S2_BRK13_1 = 0x1
	// Position of RWUID field.
	UART0_S2_RWUID_Pos = 0x3
	// Bit mask of RWUID field.
	UART0_S2_RWUID_Msk = 0x8
	// Bit RWUID.
	UART0_S2_RWUID = 0x8
	// During receive standby state (RWU = 1), the IDLE bit does not get set upon detection of an idle character.
	UART0_S2_RWUID_0 = 0x0
	// During receive standby state (RWU = 1), the IDLE bit gets set upon detection of an idle character.
	UART0_S2_RWUID_1 = 0x1
	// Position of RXINV field.
	UART0_S2_RXINV_Pos = 0x4
	// Bit mask of RXINV field.
	UART0_S2_RXINV_Msk = 0x10
	// Bit RXINV.
	UART0_S2_RXINV = 0x10
	// Receive data not inverted.
	UART0_S2_RXINV_0 = 0x0
	// Receive data inverted.
	UART0_S2_RXINV_1 = 0x1
	// Position of MSBF field.
	UART0_S2_MSBF_Pos = 0x5
	// Bit mask of MSBF field.
	UART0_S2_MSBF_Msk = 0x20
	// Bit MSBF.
	UART0_S2_MSBF = 0x20
	// LSB (bit0) is the first bit that is transmitted following the start bit. Further, the first bit received after the start bit is identified as bit0.
	UART0_S2_MSBF_0 = 0x0
	// MSB (bit9, bit8, bit7 or bit6) is the first bit that is transmitted following the start bit depending on the setting of C1[M], C1[PE] and C4[M10]. Further, the first bit received after the start bit is identified as bit9, bit8, bit7 or bit6 depending on the setting of C1[M] and C1[PE].
	UART0_S2_MSBF_1 = 0x1
	// Position of RXEDGIF field.
	UART0_S2_RXEDGIF_Pos = 0x6
	// Bit mask of RXEDGIF field.
	UART0_S2_RXEDGIF_Msk = 0x40
	// Bit RXEDGIF.
	UART0_S2_RXEDGIF = 0x40
	// No active edge on the receive pin has occurred.
	UART0_S2_RXEDGIF_0 = 0x0
	// An active edge on the receive pin has occurred.
	UART0_S2_RXEDGIF_1 = 0x1
	// Position of LBKDIF field.
	UART0_S2_LBKDIF_Pos = 0x7
	// Bit mask of LBKDIF field.
	UART0_S2_LBKDIF_Msk = 0x80
	// Bit LBKDIF.
	UART0_S2_LBKDIF = 0x80
	// No LIN break character has been detected.
	UART0_S2_LBKDIF_0 = 0x0
	// LIN break character has been detected.
	UART0_S2_LBKDIF_1 = 0x1

	// C3: UART Control Register 3
	// Position of PEIE field.
	UART0_C3_PEIE_Pos = 0x0
	// Bit mask of PEIE field.
	UART0_C3_PEIE_Msk = 0x1
	// Bit PEIE.
	UART0_C3_PEIE = 0x1
	// PF interrupts disabled; use polling).
	UART0_C3_PEIE_0 = 0x0
	// Hardware interrupt requested when PF is set.
	UART0_C3_PEIE_1 = 0x1
	// Position of FEIE field.
	UART0_C3_FEIE_Pos = 0x1
	// Bit mask of FEIE field.
	UART0_C3_FEIE_Msk = 0x2
	// Bit FEIE.
	UART0_C3_FEIE = 0x2
	// FE interrupts disabled; use polling.
	UART0_C3_FEIE_0 = 0x0
	// Hardware interrupt requested when FE is set.
	UART0_C3_FEIE_1 = 0x1
	// Position of NEIE field.
	UART0_C3_NEIE_Pos = 0x2
	// Bit mask of NEIE field.
	UART0_C3_NEIE_Msk = 0x4
	// Bit NEIE.
	UART0_C3_NEIE = 0x4
	// NF interrupts disabled; use polling.
	UART0_C3_NEIE_0 = 0x0
	// Hardware interrupt requested when NF is set.
	UART0_C3_NEIE_1 = 0x1
	// Position of ORIE field.
	UART0_C3_ORIE_Pos = 0x3
	// Bit mask of ORIE field.
	UART0_C3_ORIE_Msk = 0x8
	// Bit ORIE.
	UART0_C3_ORIE = 0x8
	// OR interrupts disabled; use polling.
	UART0_C3_ORIE_0 = 0x0
	// Hardware interrupt requested when OR is set.
	UART0_C3_ORIE_1 = 0x1
	// Position of TXINV field.
	UART0_C3_TXINV_Pos = 0x4
	// Bit mask of TXINV field.
	UART0_C3_TXINV_Msk = 0x10
	// Bit TXINV.
	UART0_C3_TXINV = 0x10
	// Transmit data not inverted.
	UART0_C3_TXINV_0 = 0x0
	// Transmit data inverted.
	UART0_C3_TXINV_1 = 0x1
	// Position of TXDIR field.
	UART0_C3_TXDIR_Pos = 0x5
	// Bit mask of TXDIR field.
	UART0_C3_TXDIR_Msk = 0x20
	// Bit TXDIR.
	UART0_C3_TXDIR = 0x20
	// UART_TXD pin is an input in single-wire mode.
	UART0_C3_TXDIR_0 = 0x0
	// UART_TXD pin is an output in single-wire mode.
	UART0_C3_TXDIR_1 = 0x1
	// Position of R9T8 field.
	UART0_C3_R9T8_Pos = 0x6
	// Bit mask of R9T8 field.
	UART0_C3_R9T8_Msk = 0x40
	// Bit R9T8.
	UART0_C3_R9T8 = 0x40
	// Position of R8T9 field.
	UART0_C3_R8T9_Pos = 0x7
	// Bit mask of R8T9 field.
	UART0_C3_R8T9_Msk = 0x80
	// Bit R8T9.
	UART0_C3_R8T9 = 0x80

	// D: UART Data Register
	// Position of R0T0 field.
	UART0_D_R0T0_Pos = 0x0
	// Bit mask of R0T0 field.
	UART0_D_R0T0_Msk = 0x1
	// Bit R0T0.
	UART0_D_R0T0 = 0x1
	// Position of R1T1 field.
	UART0_D_R1T1_Pos = 0x1
	// Bit mask of R1T1 field.
	UART0_D_R1T1_Msk = 0x2
	// Bit R1T1.
	UART0_D_R1T1 = 0x2
	// Position of R2T2 field.
	UART0_D_R2T2_Pos = 0x2
	// Bit mask of R2T2 field.
	UART0_D_R2T2_Msk = 0x4
	// Bit R2T2.
	UART0_D_R2T2 = 0x4
	// Position of R3T3 field.
	UART0_D_R3T3_Pos = 0x3
	// Bit mask of R3T3 field.
	UART0_D_R3T3_Msk = 0x8
	// Bit R3T3.
	UART0_D_R3T3 = 0x8
	// Position of R4T4 field.
	UART0_D_R4T4_Pos = 0x4
	// Bit mask of R4T4 field.
	UART0_D_R4T4_Msk = 0x10
	// Bit R4T4.
	UART0_D_R4T4 = 0x10
	// Position of R5T5 field.
	UART0_D_R5T5_Pos = 0x5
	// Bit mask of R5T5 field.
	UART0_D_R5T5_Msk = 0x20
	// Bit R5T5.
	UART0_D_R5T5 = 0x20
	// Position of R6T6 field.
	UART0_D_R6T6_Pos = 0x6
	// Bit mask of R6T6 field.
	UART0_D_R6T6_Msk = 0x40
	// Bit R6T6.
	UART0_D_R6T6 = 0x40
	// Position of R7T7 field.
	UART0_D_R7T7_Pos = 0x7
	// Bit mask of R7T7 field.
	UART0_D_R7T7_Msk = 0x80
	// Bit R7T7.
	UART0_D_R7T7 = 0x80

	// MA1: UART Match Address Registers 1
	// Position of MA field.
	UART0_MA1_MA_Pos = 0x0
	// Bit mask of MA field.
	UART0_MA1_MA_Msk = 0xff

	// MA2: UART Match Address Registers 2
	// Position of MA field.
	UART0_MA2_MA_Pos = 0x0
	// Bit mask of MA field.
	UART0_MA2_MA_Msk = 0xff

	// C4: UART Control Register 4
	// Position of OSR field.
	UART0_C4_OSR_Pos = 0x0
	// Bit mask of OSR field.
	UART0_C4_OSR_Msk = 0x1f
	// Position of M10 field.
	UART0_C4_M10_Pos = 0x5
	// Bit mask of M10 field.
	UART0_C4_M10_Msk = 0x20
	// Bit M10.
	UART0_C4_M10 = 0x20
	// Receiver and transmitter use 8-bit or 9-bit data characters.
	UART0_C4_M10_0 = 0x0
	// Receiver and transmitter use 10-bit data characters.
	UART0_C4_M10_1 = 0x1
	// Position of MAEN2 field.
	UART0_C4_MAEN2_Pos = 0x6
	// Bit mask of MAEN2 field.
	UART0_C4_MAEN2_Msk = 0x40
	// Bit MAEN2.
	UART0_C4_MAEN2 = 0x40
	// All data received is transferred to the data buffer if MAEN1 is cleared.
	UART0_C4_MAEN2_0 = 0x0
	// All data received with the most significant bit cleared, is discarded. All data received with the most significant bit set, is compared with contents of MA2 register. If no match occurs, the data is discarded. If match occurs, data is transferred to the data buffer.
	UART0_C4_MAEN2_1 = 0x1
	// Position of MAEN1 field.
	UART0_C4_MAEN1_Pos = 0x7
	// Bit mask of MAEN1 field.
	UART0_C4_MAEN1_Msk = 0x80
	// Bit MAEN1.
	UART0_C4_MAEN1 = 0x80
	// All data received is transferred to the data buffer if MAEN2 is cleared.
	UART0_C4_MAEN1_0 = 0x0
	// All data received with the most significant bit cleared, is discarded. All data received with the most significant bit set, is compared with contents of MA1 register. If no match occurs, the data is discarded. If match occurs, data is transferred to the data buffer.
	UART0_C4_MAEN1_1 = 0x1

	// C5: UART Control Register 5
	// Position of RESYNCDIS field.
	UART0_C5_RESYNCDIS_Pos = 0x0
	// Bit mask of RESYNCDIS field.
	UART0_C5_RESYNCDIS_Msk = 0x1
	// Bit RESYNCDIS.
	UART0_C5_RESYNCDIS = 0x1
	// Resynchronization during received data word is supported
	UART0_C5_RESYNCDIS_0 = 0x0
	// Resynchronization during received data word is disabled
	UART0_C5_RESYNCDIS_1 = 0x1
	// Position of BOTHEDGE field.
	UART0_C5_BOTHEDGE_Pos = 0x1
	// Bit mask of BOTHEDGE field.
	UART0_C5_BOTHEDGE_Msk = 0x2
	// Bit BOTHEDGE.
	UART0_C5_BOTHEDGE = 0x2
	// Receiver samples input data using the rising edge of the baud rate clock.
	UART0_C5_BOTHEDGE_0 = 0x0
	// Receiver samples input data using the rising and falling edge of the baud rate clock.
	UART0_C5_BOTHEDGE_1 = 0x1
	// Position of RDMAE field.
	UART0_C5_RDMAE_Pos = 0x5
	// Bit mask of RDMAE field.
	UART0_C5_RDMAE_Msk = 0x20
	// Bit RDMAE.
	UART0_C5_RDMAE = 0x20
	// DMA request disabled.
	UART0_C5_RDMAE_0 = 0x0
	// DMA request enabled.
	UART0_C5_RDMAE_1 = 0x1
	// Position of TDMAE field.
	UART0_C5_TDMAE_Pos = 0x7
	// Bit mask of TDMAE field.
	UART0_C5_TDMAE_Msk = 0x80
	// Bit TDMAE.
	UART0_C5_TDMAE = 0x80
	// DMA request disabled.
	UART0_C5_TDMAE_0 = 0x0
	// DMA request enabled.
	UART0_C5_TDMAE_1 = 0x1
)

// Constants for UART1: Universal Asynchronous Receiver/Transmitter (UART)
const (
	// BDH: UART Baud Rate Register: High
	// Position of SBR field.
	UART_BDH_SBR_Pos = 0x0
	// Bit mask of SBR field.
	UART_BDH_SBR_Msk = 0x1f
	// Position of SBNS field.
	UART_BDH_SBNS_Pos = 0x5
	// Bit mask of SBNS field.
	UART_BDH_SBNS_Msk = 0x20
	// Bit SBNS.
	UART_BDH_SBNS = 0x20
	// One stop bit.
	UART_BDH_SBNS_0 = 0x0
	// Two stop bit.
	UART_BDH_SBNS_1 = 0x1
	// Position of RXEDGIE field.
	UART_BDH_RXEDGIE_Pos = 0x6
	// Bit mask of RXEDGIE field.
	UART_BDH_RXEDGIE_Msk = 0x40
	// Bit RXEDGIE.
	UART_BDH_RXEDGIE = 0x40
	// Hardware interrupts from UART_S2[RXEDGIF] disabled (use polling).
	UART_BDH_RXEDGIE_0 = 0x0
	// Hardware interrupt requested when UART_S2[RXEDGIF] flag is 1.
	UART_BDH_RXEDGIE_1 = 0x1
	// Position of LBKDIE field.
	UART_BDH_LBKDIE_Pos = 0x7
	// Bit mask of LBKDIE field.
	UART_BDH_LBKDIE_Msk = 0x80
	// Bit LBKDIE.
	UART_BDH_LBKDIE = 0x80
	// Hardware interrupts from UART_S2[LBKDIF] disabled (use polling).
	UART_BDH_LBKDIE_0 = 0x0
	// Hardware interrupt requested when UART_S2[LBKDIF] flag is 1.
	UART_BDH_LBKDIE_1 = 0x1

	// BDL: UART Baud Rate Register: Low
	// Position of SBR field.
	UART_BDL_SBR_Pos = 0x0
	// Bit mask of SBR field.
	UART_BDL_SBR_Msk = 0xff

	// C1: UART Control Register 1
	// Position of PT field.
	UART_C1_PT_Pos = 0x0
	// Bit mask of PT field.
	UART_C1_PT_Msk = 0x1
	// Bit PT.
	UART_C1_PT = 0x1
	// Even parity.
	UART_C1_PT_0 = 0x0
	// Odd parity.
	UART_C1_PT_1 = 0x1
	// Position of PE field.
	UART_C1_PE_Pos = 0x1
	// Bit mask of PE field.
	UART_C1_PE_Msk = 0x2
	// Bit PE.
	UART_C1_PE = 0x2
	// No hardware parity generation or checking.
	UART_C1_PE_0 = 0x0
	// Parity enabled.
	UART_C1_PE_1 = 0x1
	// Position of ILT field.
	UART_C1_ILT_Pos = 0x2
	// Bit mask of ILT field.
	UART_C1_ILT_Msk = 0x4
	// Bit ILT.
	UART_C1_ILT = 0x4
	// Idle character bit count starts after start bit.
	UART_C1_ILT_0 = 0x0
	// Idle character bit count starts after stop bit.
	UART_C1_ILT_1 = 0x1
	// Position of WAKE field.
	UART_C1_WAKE_Pos = 0x3
	// Bit mask of WAKE field.
	UART_C1_WAKE_Msk = 0x8
	// Bit WAKE.
	UART_C1_WAKE = 0x8
	// Idle-line wake-up.
	UART_C1_WAKE_0 = 0x0
	// Address-mark wake-up.
	UART_C1_WAKE_1 = 0x1
	// Position of M field.
	UART_C1_M_Pos = 0x4
	// Bit mask of M field.
	UART_C1_M_Msk = 0x10
	// Bit M.
	UART_C1_M = 0x10
	// Normal - start + 8 data bits (lsb first) + stop.
	UART_C1_M_0 = 0x0
	// Receiver and transmitter use 9-bit data characters start + 8 data bits (lsb first) + 9th data bit + stop.
	UART_C1_M_1 = 0x1
	// Position of RSRC field.
	UART_C1_RSRC_Pos = 0x5
	// Bit mask of RSRC field.
	UART_C1_RSRC_Msk = 0x20
	// Bit RSRC.
	UART_C1_RSRC = 0x20
	// Provided LOOPS is set, RSRC is cleared, selects internal loop back mode and the UART does not use the RxD pins.
	UART_C1_RSRC_0 = 0x0
	// Single-wire UART mode where the TxD pin is connected to the transmitter output and receiver input.
	UART_C1_RSRC_1 = 0x1
	// Position of UARTSWAI field.
	UART_C1_UARTSWAI_Pos = 0x6
	// Bit mask of UARTSWAI field.
	UART_C1_UARTSWAI_Msk = 0x40
	// Bit UARTSWAI.
	UART_C1_UARTSWAI = 0x40
	// UART clocks continue to run in Wait mode so the UART can be the source of an interrupt that wakes up the CPU.
	UART_C1_UARTSWAI_0 = 0x0
	// UART clocks freeze while CPU is in Wait mode.
	UART_C1_UARTSWAI_1 = 0x1
	// Position of LOOPS field.
	UART_C1_LOOPS_Pos = 0x7
	// Bit mask of LOOPS field.
	UART_C1_LOOPS_Msk = 0x80
	// Bit LOOPS.
	UART_C1_LOOPS = 0x80
	// Normal operation - RxD and TxD use separate pins.
	UART_C1_LOOPS_0 = 0x0
	// Loop mode or single-wire mode where transmitter outputs are internally connected to receiver input. (See RSRC bit.) RxD pin is not used by UART.
	UART_C1_LOOPS_1 = 0x1

	// C2: UART Control Register 2
	// Position of SBK field.
	UART_C2_SBK_Pos = 0x0
	// Bit mask of SBK field.
	UART_C2_SBK_Msk = 0x1
	// Bit SBK.
	UART_C2_SBK = 0x1
	// Normal transmitter operation.
	UART_C2_SBK_0 = 0x0
	// Queue break character(s) to be sent.
	UART_C2_SBK_1 = 0x1
	// Position of RWU field.
	UART_C2_RWU_Pos = 0x1
	// Bit mask of RWU field.
	UART_C2_RWU_Msk = 0x2
	// Bit RWU.
	UART_C2_RWU = 0x2
	// Normal UART receiver operation.
	UART_C2_RWU_0 = 0x0
	// UART receiver in standby waiting for wake-up condition.
	UART_C2_RWU_1 = 0x1
	// Position of RE field.
	UART_C2_RE_Pos = 0x2
	// Bit mask of RE field.
	UART_C2_RE_Msk = 0x4
	// Bit RE.
	UART_C2_RE = 0x4
	// Receiver off.
	UART_C2_RE_0 = 0x0
	// Receiver on.
	UART_C2_RE_1 = 0x1
	// Position of TE field.
	UART_C2_TE_Pos = 0x3
	// Bit mask of TE field.
	UART_C2_TE_Msk = 0x8
	// Bit TE.
	UART_C2_TE = 0x8
	// Transmitter off.
	UART_C2_TE_0 = 0x0
	// Transmitter on.
	UART_C2_TE_1 = 0x1
	// Position of ILIE field.
	UART_C2_ILIE_Pos = 0x4
	// Bit mask of ILIE field.
	UART_C2_ILIE_Msk = 0x10
	// Bit ILIE.
	UART_C2_ILIE = 0x10
	// Hardware interrupts from S1[IDLE] disabled; use polling.
	UART_C2_ILIE_0 = 0x0
	// Hardware interrupt requested when S1[IDLE] flag is 1.
	UART_C2_ILIE_1 = 0x1
	// Position of RIE field.
	UART_C2_RIE_Pos = 0x5
	// Bit mask of RIE field.
	UART_C2_RIE_Msk = 0x20
	// Bit RIE.
	UART_C2_RIE = 0x20
	// Hardware interrupts from S1[RDRF] disabled; use polling.
	UART_C2_RIE_0 = 0x0
	// Hardware interrupt requested when S1[RDRF] flag is 1.
	UART_C2_RIE_1 = 0x1
	// Position of TCIE field.
	UART_C2_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	UART_C2_TCIE_Msk = 0x40
	// Bit TCIE.
	UART_C2_TCIE = 0x40
	// Hardware interrupts from TC disabled; use polling.
	UART_C2_TCIE_0 = 0x0
	// Hardware interrupt requested when TC flag is 1.
	UART_C2_TCIE_1 = 0x1
	// Position of TIE field.
	UART_C2_TIE_Pos = 0x7
	// Bit mask of TIE field.
	UART_C2_TIE_Msk = 0x80
	// Bit TIE.
	UART_C2_TIE = 0x80
	// Hardware interrupts from TDRE disabled; use polling.
	UART_C2_TIE_0 = 0x0
	// Hardware interrupt requested when TDRE flag is 1.
	UART_C2_TIE_1 = 0x1

	// S1: UART Status Register 1
	// Position of PF field.
	UART_S1_PF_Pos = 0x0
	// Bit mask of PF field.
	UART_S1_PF_Msk = 0x1
	// Bit PF.
	UART_S1_PF = 0x1
	// No parity error.
	UART_S1_PF_0 = 0x0
	// Parity error.
	UART_S1_PF_1 = 0x1
	// Position of FE field.
	UART_S1_FE_Pos = 0x1
	// Bit mask of FE field.
	UART_S1_FE_Msk = 0x2
	// Bit FE.
	UART_S1_FE = 0x2
	// No framing error detected. This does not guarantee the framing is correct.
	UART_S1_FE_0 = 0x0
	// Framing error.
	UART_S1_FE_1 = 0x1
	// Position of NF field.
	UART_S1_NF_Pos = 0x2
	// Bit mask of NF field.
	UART_S1_NF_Msk = 0x4
	// Bit NF.
	UART_S1_NF = 0x4
	// No noise detected.
	UART_S1_NF_0 = 0x0
	// Noise detected in the received character in UART_D.
	UART_S1_NF_1 = 0x1
	// Position of OR field.
	UART_S1_OR_Pos = 0x3
	// Bit mask of OR field.
	UART_S1_OR_Msk = 0x8
	// Bit OR.
	UART_S1_OR = 0x8
	// No overrun.
	UART_S1_OR_0 = 0x0
	// Receive overrun (new UART data lost).
	UART_S1_OR_1 = 0x1
	// Position of IDLE field.
	UART_S1_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	UART_S1_IDLE_Msk = 0x10
	// Bit IDLE.
	UART_S1_IDLE = 0x10
	// No idle line detected.
	UART_S1_IDLE_0 = 0x0
	// Idle line was detected.
	UART_S1_IDLE_1 = 0x1
	// Position of RDRF field.
	UART_S1_RDRF_Pos = 0x5
	// Bit mask of RDRF field.
	UART_S1_RDRF_Msk = 0x20
	// Bit RDRF.
	UART_S1_RDRF = 0x20
	// Receive data register empty.
	UART_S1_RDRF_0 = 0x0
	// Receive data register full.
	UART_S1_RDRF_1 = 0x1
	// Position of TC field.
	UART_S1_TC_Pos = 0x6
	// Bit mask of TC field.
	UART_S1_TC_Msk = 0x40
	// Bit TC.
	UART_S1_TC = 0x40
	// Transmitter active (sending data, a preamble, or a break).
	UART_S1_TC_0 = 0x0
	// Transmitter idle (transmission activity complete).
	UART_S1_TC_1 = 0x1
	// Position of TDRE field.
	UART_S1_TDRE_Pos = 0x7
	// Bit mask of TDRE field.
	UART_S1_TDRE_Msk = 0x80
	// Bit TDRE.
	UART_S1_TDRE = 0x80
	// Transmit data register (buffer) full.
	UART_S1_TDRE_0 = 0x0
	// Transmit data register (buffer) empty.
	UART_S1_TDRE_1 = 0x1

	// S2: UART Status Register 2
	// Position of RAF field.
	UART_S2_RAF_Pos = 0x0
	// Bit mask of RAF field.
	UART_S2_RAF_Msk = 0x1
	// Bit RAF.
	UART_S2_RAF = 0x1
	// UART receiver idle waiting for a start bit.
	UART_S2_RAF_0 = 0x0
	// UART receiver active (RxD input not idle).
	UART_S2_RAF_1 = 0x1
	// Position of LBKDE field.
	UART_S2_LBKDE_Pos = 0x1
	// Bit mask of LBKDE field.
	UART_S2_LBKDE_Msk = 0x2
	// Bit LBKDE.
	UART_S2_LBKDE = 0x2
	// Break detection is disabled.
	UART_S2_LBKDE_0 = 0x0
	// Break detection is enabled (Break character is detected at length 11 bit times (if C1[M] = 0, BDH[SBNS] = 0) or 12 (if C1[M] = 1, BDH[SBNS] = 0 or C1[M] = 0, BDH[SBNS] = 1) or 13 (if C1[M] = 1, BDH[SBNS] = 1)).
	UART_S2_LBKDE_1 = 0x1
	// Position of BRK13 field.
	UART_S2_BRK13_Pos = 0x2
	// Bit mask of BRK13 field.
	UART_S2_BRK13_Msk = 0x4
	// Bit BRK13.
	UART_S2_BRK13 = 0x4
	// Break character is transmitted with length of 10 bit times (if M = 0, SBNS = 0) or 11 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 12 (if M = 1, SBNS = 1).
	UART_S2_BRK13_0 = 0x0
	// Break character is transmitted with length of 13 bit times (if M = 0, SBNS = 0) or 14 (if M = 1, SBNS = 0 or M = 0, SBNS = 1) or 15 (if M = 1, SBNS = 1).
	UART_S2_BRK13_1 = 0x1
	// Position of RWUID field.
	UART_S2_RWUID_Pos = 0x3
	// Bit mask of RWUID field.
	UART_S2_RWUID_Msk = 0x8
	// Bit RWUID.
	UART_S2_RWUID = 0x8
	// During receive standby state (RWU = 1), S1[IDLE] does not get set upon detection of an idle character.
	UART_S2_RWUID_0 = 0x0
	// During receive standby state (RWU = 1), S1[IDLE] gets set upon detection of an idle character.
	UART_S2_RWUID_1 = 0x1
	// Position of RXINV field.
	UART_S2_RXINV_Pos = 0x4
	// Bit mask of RXINV field.
	UART_S2_RXINV_Msk = 0x10
	// Bit RXINV.
	UART_S2_RXINV = 0x10
	// Receive data not inverted.
	UART_S2_RXINV_0 = 0x0
	// Receive data inverted.
	UART_S2_RXINV_1 = 0x1
	// Position of RXEDGIF field.
	UART_S2_RXEDGIF_Pos = 0x6
	// Bit mask of RXEDGIF field.
	UART_S2_RXEDGIF_Msk = 0x40
	// Bit RXEDGIF.
	UART_S2_RXEDGIF = 0x40
	// No active edge on the receive pin has occurred.
	UART_S2_RXEDGIF_0 = 0x0
	// An active edge on the receive pin has occurred.
	UART_S2_RXEDGIF_1 = 0x1
	// Position of LBKDIF field.
	UART_S2_LBKDIF_Pos = 0x7
	// Bit mask of LBKDIF field.
	UART_S2_LBKDIF_Msk = 0x80
	// Bit LBKDIF.
	UART_S2_LBKDIF = 0x80
	// No LIN break character has been detected.
	UART_S2_LBKDIF_0 = 0x0
	// LIN break character has been detected.
	UART_S2_LBKDIF_1 = 0x1

	// C3: UART Control Register 3
	// Position of PEIE field.
	UART_C3_PEIE_Pos = 0x0
	// Bit mask of PEIE field.
	UART_C3_PEIE_Msk = 0x1
	// Bit PEIE.
	UART_C3_PEIE = 0x1
	// PF interrupts disabled; use polling).
	UART_C3_PEIE_0 = 0x0
	// Hardware interrupt requested when PF is set.
	UART_C3_PEIE_1 = 0x1
	// Position of FEIE field.
	UART_C3_FEIE_Pos = 0x1
	// Bit mask of FEIE field.
	UART_C3_FEIE_Msk = 0x2
	// Bit FEIE.
	UART_C3_FEIE = 0x2
	// FE interrupts disabled; use polling).
	UART_C3_FEIE_0 = 0x0
	// Hardware interrupt requested when FE is set.
	UART_C3_FEIE_1 = 0x1
	// Position of NEIE field.
	UART_C3_NEIE_Pos = 0x2
	// Bit mask of NEIE field.
	UART_C3_NEIE_Msk = 0x4
	// Bit NEIE.
	UART_C3_NEIE = 0x4
	// NF interrupts disabled; use polling).
	UART_C3_NEIE_0 = 0x0
	// Hardware interrupt requested when NF is set.
	UART_C3_NEIE_1 = 0x1
	// Position of ORIE field.
	UART_C3_ORIE_Pos = 0x3
	// Bit mask of ORIE field.
	UART_C3_ORIE_Msk = 0x8
	// Bit ORIE.
	UART_C3_ORIE = 0x8
	// OR interrupts disabled; use polling.
	UART_C3_ORIE_0 = 0x0
	// Hardware interrupt requested when OR is set.
	UART_C3_ORIE_1 = 0x1
	// Position of TXINV field.
	UART_C3_TXINV_Pos = 0x4
	// Bit mask of TXINV field.
	UART_C3_TXINV_Msk = 0x10
	// Bit TXINV.
	UART_C3_TXINV = 0x10
	// Transmit data not inverted.
	UART_C3_TXINV_0 = 0x0
	// Transmit data inverted.
	UART_C3_TXINV_1 = 0x1
	// Position of TXDIR field.
	UART_C3_TXDIR_Pos = 0x5
	// Bit mask of TXDIR field.
	UART_C3_TXDIR_Msk = 0x20
	// Bit TXDIR.
	UART_C3_TXDIR = 0x20
	// TxD pin is an input in single-wire mode.
	UART_C3_TXDIR_0 = 0x0
	// TxD pin is an output in single-wire mode.
	UART_C3_TXDIR_1 = 0x1
	// Position of T8 field.
	UART_C3_T8_Pos = 0x6
	// Bit mask of T8 field.
	UART_C3_T8_Msk = 0x40
	// Bit T8.
	UART_C3_T8 = 0x40
	// Position of R8 field.
	UART_C3_R8_Pos = 0x7
	// Bit mask of R8 field.
	UART_C3_R8_Msk = 0x80
	// Bit R8.
	UART_C3_R8 = 0x80

	// D: UART Data Register
	// Position of R0T0 field.
	UART_D_R0T0_Pos = 0x0
	// Bit mask of R0T0 field.
	UART_D_R0T0_Msk = 0x1
	// Bit R0T0.
	UART_D_R0T0 = 0x1
	// Position of R1T1 field.
	UART_D_R1T1_Pos = 0x1
	// Bit mask of R1T1 field.
	UART_D_R1T1_Msk = 0x2
	// Bit R1T1.
	UART_D_R1T1 = 0x2
	// Position of R2T2 field.
	UART_D_R2T2_Pos = 0x2
	// Bit mask of R2T2 field.
	UART_D_R2T2_Msk = 0x4
	// Bit R2T2.
	UART_D_R2T2 = 0x4
	// Position of R3T3 field.
	UART_D_R3T3_Pos = 0x3
	// Bit mask of R3T3 field.
	UART_D_R3T3_Msk = 0x8
	// Bit R3T3.
	UART_D_R3T3 = 0x8
	// Position of R4T4 field.
	UART_D_R4T4_Pos = 0x4
	// Bit mask of R4T4 field.
	UART_D_R4T4_Msk = 0x10
	// Bit R4T4.
	UART_D_R4T4 = 0x10
	// Position of R5T5 field.
	UART_D_R5T5_Pos = 0x5
	// Bit mask of R5T5 field.
	UART_D_R5T5_Msk = 0x20
	// Bit R5T5.
	UART_D_R5T5 = 0x20
	// Position of R6T6 field.
	UART_D_R6T6_Pos = 0x6
	// Bit mask of R6T6 field.
	UART_D_R6T6_Msk = 0x40
	// Bit R6T6.
	UART_D_R6T6 = 0x40
	// Position of R7T7 field.
	UART_D_R7T7_Pos = 0x7
	// Bit mask of R7T7 field.
	UART_D_R7T7_Msk = 0x80
	// Bit R7T7.
	UART_D_R7T7 = 0x80

	// C4: UART Control Register 4
	// Position of RDMAS field.
	UART_C4_RDMAS_Pos = 0x5
	// Bit mask of RDMAS field.
	UART_C4_RDMAS_Msk = 0x20
	// Bit RDMAS.
	UART_C4_RDMAS = 0x20
	// If RIE is set and the RDRF flag is set, the RDRF interrupt request signal is asserted to request interrupt service.
	UART_C4_RDMAS_0 = 0x0
	// If RIE is set and the RDRF flag is set, the RDRF DMA request signal is asserted to request a DMA transfer.
	UART_C4_RDMAS_1 = 0x1
	// Position of TDMAS field.
	UART_C4_TDMAS_Pos = 0x7
	// Bit mask of TDMAS field.
	UART_C4_TDMAS_Msk = 0x80
	// Bit TDMAS.
	UART_C4_TDMAS = 0x80
	// If TIE is set and the TDRE flag is set, the TDRE interrupt request signal is asserted to request interrupt service.
	UART_C4_TDMAS_0 = 0x0
	// If TIE is set and the TDRE flag is set, the TDRE DMA request signal is asserted to request a DMA transfer.
	UART_C4_TDMAS_1 = 0x1
)

// Constants for USB0: Universal Serial Bus, OTG Capable Controller
const (
	// PERID: Peripheral ID register
	// Position of ID field.
	USB0_PERID_ID_Pos = 0x0
	// Bit mask of ID field.
	USB0_PERID_ID_Msk = 0x3f

	// IDCOMP: Peripheral ID Complement register
	// Position of NID field.
	USB0_IDCOMP_NID_Pos = 0x0
	// Bit mask of NID field.
	USB0_IDCOMP_NID_Msk = 0x3f

	// REV: Peripheral Revision register
	// Position of REV field.
	USB0_REV_REV_Pos = 0x0
	// Bit mask of REV field.
	USB0_REV_REV_Msk = 0xff

	// ADDINFO: Peripheral Additional Info register
	// Position of IEHOST field.
	USB0_ADDINFO_IEHOST_Pos = 0x0
	// Bit mask of IEHOST field.
	USB0_ADDINFO_IEHOST_Msk = 0x1
	// Bit IEHOST.
	USB0_ADDINFO_IEHOST = 0x1
	// Position of IRQNUM field.
	USB0_ADDINFO_IRQNUM_Pos = 0x3
	// Bit mask of IRQNUM field.
	USB0_ADDINFO_IRQNUM_Msk = 0xf8

	// OTGISTAT: OTG Interrupt Status register
	// Position of AVBUSCHG field.
	USB0_OTGISTAT_AVBUSCHG_Pos = 0x0
	// Bit mask of AVBUSCHG field.
	USB0_OTGISTAT_AVBUSCHG_Msk = 0x1
	// Bit AVBUSCHG.
	USB0_OTGISTAT_AVBUSCHG = 0x1
	// Position of B_SESS_CHG field.
	USB0_OTGISTAT_B_SESS_CHG_Pos = 0x2
	// Bit mask of B_SESS_CHG field.
	USB0_OTGISTAT_B_SESS_CHG_Msk = 0x4
	// Bit B_SESS_CHG.
	USB0_OTGISTAT_B_SESS_CHG = 0x4
	// Position of SESSVLDCHG field.
	USB0_OTGISTAT_SESSVLDCHG_Pos = 0x3
	// Bit mask of SESSVLDCHG field.
	USB0_OTGISTAT_SESSVLDCHG_Msk = 0x8
	// Bit SESSVLDCHG.
	USB0_OTGISTAT_SESSVLDCHG = 0x8
	// Position of LINE_STATE_CHG field.
	USB0_OTGISTAT_LINE_STATE_CHG_Pos = 0x5
	// Bit mask of LINE_STATE_CHG field.
	USB0_OTGISTAT_LINE_STATE_CHG_Msk = 0x20
	// Bit LINE_STATE_CHG.
	USB0_OTGISTAT_LINE_STATE_CHG = 0x20
	// Position of ONEMSEC field.
	USB0_OTGISTAT_ONEMSEC_Pos = 0x6
	// Bit mask of ONEMSEC field.
	USB0_OTGISTAT_ONEMSEC_Msk = 0x40
	// Bit ONEMSEC.
	USB0_OTGISTAT_ONEMSEC = 0x40
	// Position of IDCHG field.
	USB0_OTGISTAT_IDCHG_Pos = 0x7
	// Bit mask of IDCHG field.
	USB0_OTGISTAT_IDCHG_Msk = 0x80
	// Bit IDCHG.
	USB0_OTGISTAT_IDCHG = 0x80

	// OTGICR: OTG Interrupt Control register
	// Position of AVBUSEN field.
	USB0_OTGICR_AVBUSEN_Pos = 0x0
	// Bit mask of AVBUSEN field.
	USB0_OTGICR_AVBUSEN_Msk = 0x1
	// Bit AVBUSEN.
	USB0_OTGICR_AVBUSEN = 0x1
	// Disables the AVBUSCHG interrupt.
	USB0_OTGICR_AVBUSEN_0 = 0x0
	// Enables the AVBUSCHG interrupt.
	USB0_OTGICR_AVBUSEN_1 = 0x1
	// Position of BSESSEN field.
	USB0_OTGICR_BSESSEN_Pos = 0x2
	// Bit mask of BSESSEN field.
	USB0_OTGICR_BSESSEN_Msk = 0x4
	// Bit BSESSEN.
	USB0_OTGICR_BSESSEN = 0x4
	// Disables the B_SESS_CHG interrupt.
	USB0_OTGICR_BSESSEN_0 = 0x0
	// Enables the B_SESS_CHG interrupt.
	USB0_OTGICR_BSESSEN_1 = 0x1
	// Position of SESSVLDEN field.
	USB0_OTGICR_SESSVLDEN_Pos = 0x3
	// Bit mask of SESSVLDEN field.
	USB0_OTGICR_SESSVLDEN_Msk = 0x8
	// Bit SESSVLDEN.
	USB0_OTGICR_SESSVLDEN = 0x8
	// Disables the SESSVLDCHG interrupt.
	USB0_OTGICR_SESSVLDEN_0 = 0x0
	// Enables the SESSVLDCHG interrupt.
	USB0_OTGICR_SESSVLDEN_1 = 0x1
	// Position of LINESTATEEN field.
	USB0_OTGICR_LINESTATEEN_Pos = 0x5
	// Bit mask of LINESTATEEN field.
	USB0_OTGICR_LINESTATEEN_Msk = 0x20
	// Bit LINESTATEEN.
	USB0_OTGICR_LINESTATEEN = 0x20
	// Disables the LINE_STAT_CHG interrupt.
	USB0_OTGICR_LINESTATEEN_0 = 0x0
	// Enables the LINE_STAT_CHG interrupt.
	USB0_OTGICR_LINESTATEEN_1 = 0x1
	// Position of ONEMSECEN field.
	USB0_OTGICR_ONEMSECEN_Pos = 0x6
	// Bit mask of ONEMSECEN field.
	USB0_OTGICR_ONEMSECEN_Msk = 0x40
	// Bit ONEMSECEN.
	USB0_OTGICR_ONEMSECEN = 0x40
	// Diables the 1ms timer interrupt.
	USB0_OTGICR_ONEMSECEN_0 = 0x0
	// Enables the 1ms timer interrupt.
	USB0_OTGICR_ONEMSECEN_1 = 0x1
	// Position of IDEN field.
	USB0_OTGICR_IDEN_Pos = 0x7
	// Bit mask of IDEN field.
	USB0_OTGICR_IDEN_Msk = 0x80
	// Bit IDEN.
	USB0_OTGICR_IDEN = 0x80
	// The ID interrupt is disabled
	USB0_OTGICR_IDEN_0 = 0x0
	// The ID interrupt is enabled
	USB0_OTGICR_IDEN_1 = 0x1

	// OTGSTAT: OTG Status register
	// Position of AVBUSVLD field.
	USB0_OTGSTAT_AVBUSVLD_Pos = 0x0
	// Bit mask of AVBUSVLD field.
	USB0_OTGSTAT_AVBUSVLD_Msk = 0x1
	// Bit AVBUSVLD.
	USB0_OTGSTAT_AVBUSVLD = 0x1
	// The VBUS voltage is below the A VBUS Valid threshold.
	USB0_OTGSTAT_AVBUSVLD_0 = 0x0
	// The VBUS voltage is above the A VBUS Valid threshold.
	USB0_OTGSTAT_AVBUSVLD_1 = 0x1
	// Position of BSESSEND field.
	USB0_OTGSTAT_BSESSEND_Pos = 0x2
	// Bit mask of BSESSEND field.
	USB0_OTGSTAT_BSESSEND_Msk = 0x4
	// Bit BSESSEND.
	USB0_OTGSTAT_BSESSEND = 0x4
	// The VBUS voltage is above the B session end threshold.
	USB0_OTGSTAT_BSESSEND_0 = 0x0
	// The VBUS voltage is below the B session end threshold.
	USB0_OTGSTAT_BSESSEND_1 = 0x1
	// Position of SESS_VLD field.
	USB0_OTGSTAT_SESS_VLD_Pos = 0x3
	// Bit mask of SESS_VLD field.
	USB0_OTGSTAT_SESS_VLD_Msk = 0x8
	// Bit SESS_VLD.
	USB0_OTGSTAT_SESS_VLD = 0x8
	// The VBUS voltage is below the B session valid threshold
	USB0_OTGSTAT_SESS_VLD_0 = 0x0
	// The VBUS voltage is above the B session valid threshold.
	USB0_OTGSTAT_SESS_VLD_1 = 0x1
	// Position of LINESTATESTABLE field.
	USB0_OTGSTAT_LINESTATESTABLE_Pos = 0x5
	// Bit mask of LINESTATESTABLE field.
	USB0_OTGSTAT_LINESTATESTABLE_Msk = 0x20
	// Bit LINESTATESTABLE.
	USB0_OTGSTAT_LINESTATESTABLE = 0x20
	// The LINE_STAT_CHG bit is not yet stable.
	USB0_OTGSTAT_LINESTATESTABLE_0 = 0x0
	// The LINE_STAT_CHG bit has been debounced and is stable.
	USB0_OTGSTAT_LINESTATESTABLE_1 = 0x1
	// Position of ONEMSECEN field.
	USB0_OTGSTAT_ONEMSECEN_Pos = 0x6
	// Bit mask of ONEMSECEN field.
	USB0_OTGSTAT_ONEMSECEN_Msk = 0x40
	// Bit ONEMSECEN.
	USB0_OTGSTAT_ONEMSECEN = 0x40
	// Position of ID field.
	USB0_OTGSTAT_ID_Pos = 0x7
	// Bit mask of ID field.
	USB0_OTGSTAT_ID_Msk = 0x80
	// Bit ID.
	USB0_OTGSTAT_ID = 0x80
	// Indicates a Type A cable is plugged into the USB connector.
	USB0_OTGSTAT_ID_0 = 0x0
	// Indicates no cable is attached or a Type B cable is plugged into the USB connector.
	USB0_OTGSTAT_ID_1 = 0x1

	// OTGCTL: OTG Control register
	// Position of OTGEN field.
	USB0_OTGCTL_OTGEN_Pos = 0x2
	// Bit mask of OTGEN field.
	USB0_OTGCTL_OTGEN_Msk = 0x4
	// Bit OTGEN.
	USB0_OTGCTL_OTGEN = 0x4
	// If USB_EN is 1 and HOST_MODE is 0 in the Control Register (CTL), then the D+ Data Line pull-up resistors are enabled. If HOST_MODE is 1 the D+ and D- Data Line pull-down resistors are engaged.
	USB0_OTGCTL_OTGEN_0 = 0x0
	// The pull-up and pull-down controls in this register are used.
	USB0_OTGCTL_OTGEN_1 = 0x1
	// Position of DMLOW field.
	USB0_OTGCTL_DMLOW_Pos = 0x4
	// Bit mask of DMLOW field.
	USB0_OTGCTL_DMLOW_Msk = 0x10
	// Bit DMLOW.
	USB0_OTGCTL_DMLOW = 0x10
	// D- pulldown resistor is not enabled.
	USB0_OTGCTL_DMLOW_0 = 0x0
	// D- pulldown resistor is enabled.
	USB0_OTGCTL_DMLOW_1 = 0x1
	// Position of DPLOW field.
	USB0_OTGCTL_DPLOW_Pos = 0x5
	// Bit mask of DPLOW field.
	USB0_OTGCTL_DPLOW_Msk = 0x20
	// Bit DPLOW.
	USB0_OTGCTL_DPLOW = 0x20
	// D+ pulldown resistor is not enabled.
	USB0_OTGCTL_DPLOW_0 = 0x0
	// D+ pulldown resistor is enabled.
	USB0_OTGCTL_DPLOW_1 = 0x1
	// Position of DPHIGH field.
	USB0_OTGCTL_DPHIGH_Pos = 0x7
	// Bit mask of DPHIGH field.
	USB0_OTGCTL_DPHIGH_Msk = 0x80
	// Bit DPHIGH.
	USB0_OTGCTL_DPHIGH = 0x80
	// D+ pullup resistor is not enabled
	USB0_OTGCTL_DPHIGH_0 = 0x0
	// D+ pullup resistor is enabled
	USB0_OTGCTL_DPHIGH_1 = 0x1

	// ISTAT: Interrupt Status register
	// Position of USBRST field.
	USB0_ISTAT_USBRST_Pos = 0x0
	// Bit mask of USBRST field.
	USB0_ISTAT_USBRST_Msk = 0x1
	// Bit USBRST.
	USB0_ISTAT_USBRST = 0x1
	// Position of ERROR field.
	USB0_ISTAT_ERROR_Pos = 0x1
	// Bit mask of ERROR field.
	USB0_ISTAT_ERROR_Msk = 0x2
	// Bit ERROR.
	USB0_ISTAT_ERROR = 0x2
	// Position of SOFTOK field.
	USB0_ISTAT_SOFTOK_Pos = 0x2
	// Bit mask of SOFTOK field.
	USB0_ISTAT_SOFTOK_Msk = 0x4
	// Bit SOFTOK.
	USB0_ISTAT_SOFTOK = 0x4
	// Position of TOKDNE field.
	USB0_ISTAT_TOKDNE_Pos = 0x3
	// Bit mask of TOKDNE field.
	USB0_ISTAT_TOKDNE_Msk = 0x8
	// Bit TOKDNE.
	USB0_ISTAT_TOKDNE = 0x8
	// Position of SLEEP field.
	USB0_ISTAT_SLEEP_Pos = 0x4
	// Bit mask of SLEEP field.
	USB0_ISTAT_SLEEP_Msk = 0x10
	// Bit SLEEP.
	USB0_ISTAT_SLEEP = 0x10
	// Position of RESUME field.
	USB0_ISTAT_RESUME_Pos = 0x5
	// Bit mask of RESUME field.
	USB0_ISTAT_RESUME_Msk = 0x20
	// Bit RESUME.
	USB0_ISTAT_RESUME = 0x20
	// Position of ATTACH field.
	USB0_ISTAT_ATTACH_Pos = 0x6
	// Bit mask of ATTACH field.
	USB0_ISTAT_ATTACH_Msk = 0x40
	// Bit ATTACH.
	USB0_ISTAT_ATTACH = 0x40
	// Position of STALL field.
	USB0_ISTAT_STALL_Pos = 0x7
	// Bit mask of STALL field.
	USB0_ISTAT_STALL_Msk = 0x80
	// Bit STALL.
	USB0_ISTAT_STALL = 0x80

	// INTEN: Interrupt Enable register
	// Position of USBRSTEN field.
	USB0_INTEN_USBRSTEN_Pos = 0x0
	// Bit mask of USBRSTEN field.
	USB0_INTEN_USBRSTEN_Msk = 0x1
	// Bit USBRSTEN.
	USB0_INTEN_USBRSTEN = 0x1
	// Disables the USBRST interrupt.
	USB0_INTEN_USBRSTEN_0 = 0x0
	// Enables the USBRST interrupt.
	USB0_INTEN_USBRSTEN_1 = 0x1
	// Position of ERROREN field.
	USB0_INTEN_ERROREN_Pos = 0x1
	// Bit mask of ERROREN field.
	USB0_INTEN_ERROREN_Msk = 0x2
	// Bit ERROREN.
	USB0_INTEN_ERROREN = 0x2
	// Disables the ERROR interrupt.
	USB0_INTEN_ERROREN_0 = 0x0
	// Enables the ERROR interrupt.
	USB0_INTEN_ERROREN_1 = 0x1
	// Position of SOFTOKEN field.
	USB0_INTEN_SOFTOKEN_Pos = 0x2
	// Bit mask of SOFTOKEN field.
	USB0_INTEN_SOFTOKEN_Msk = 0x4
	// Bit SOFTOKEN.
	USB0_INTEN_SOFTOKEN = 0x4
	// Disbles the SOFTOK interrupt.
	USB0_INTEN_SOFTOKEN_0 = 0x0
	// Enables the SOFTOK interrupt.
	USB0_INTEN_SOFTOKEN_1 = 0x1
	// Position of TOKDNEEN field.
	USB0_INTEN_TOKDNEEN_Pos = 0x3
	// Bit mask of TOKDNEEN field.
	USB0_INTEN_TOKDNEEN_Msk = 0x8
	// Bit TOKDNEEN.
	USB0_INTEN_TOKDNEEN = 0x8
	// Disables the TOKDNE interrupt.
	USB0_INTEN_TOKDNEEN_0 = 0x0
	// Enables the TOKDNE interrupt.
	USB0_INTEN_TOKDNEEN_1 = 0x1
	// Position of SLEEPEN field.
	USB0_INTEN_SLEEPEN_Pos = 0x4
	// Bit mask of SLEEPEN field.
	USB0_INTEN_SLEEPEN_Msk = 0x10
	// Bit SLEEPEN.
	USB0_INTEN_SLEEPEN = 0x10
	// Disables the SLEEP interrupt.
	USB0_INTEN_SLEEPEN_0 = 0x0
	// Enables the SLEEP interrupt.
	USB0_INTEN_SLEEPEN_1 = 0x1
	// Position of RESUMEEN field.
	USB0_INTEN_RESUMEEN_Pos = 0x5
	// Bit mask of RESUMEEN field.
	USB0_INTEN_RESUMEEN_Msk = 0x20
	// Bit RESUMEEN.
	USB0_INTEN_RESUMEEN = 0x20
	// Disables the RESUME interrupt.
	USB0_INTEN_RESUMEEN_0 = 0x0
	// Enables the RESUME interrupt.
	USB0_INTEN_RESUMEEN_1 = 0x1
	// Position of ATTACHEN field.
	USB0_INTEN_ATTACHEN_Pos = 0x6
	// Bit mask of ATTACHEN field.
	USB0_INTEN_ATTACHEN_Msk = 0x40
	// Bit ATTACHEN.
	USB0_INTEN_ATTACHEN = 0x40
	// Disables the ATTACH interrupt.
	USB0_INTEN_ATTACHEN_0 = 0x0
	// Enables the ATTACH interrupt.
	USB0_INTEN_ATTACHEN_1 = 0x1
	// Position of STALLEN field.
	USB0_INTEN_STALLEN_Pos = 0x7
	// Bit mask of STALLEN field.
	USB0_INTEN_STALLEN_Msk = 0x80
	// Bit STALLEN.
	USB0_INTEN_STALLEN = 0x80
	// Diasbles the STALL interrupt.
	USB0_INTEN_STALLEN_0 = 0x0
	// Enables the STALL interrupt.
	USB0_INTEN_STALLEN_1 = 0x1

	// ERRSTAT: Error Interrupt Status register
	// Position of PIDERR field.
	USB0_ERRSTAT_PIDERR_Pos = 0x0
	// Bit mask of PIDERR field.
	USB0_ERRSTAT_PIDERR_Msk = 0x1
	// Bit PIDERR.
	USB0_ERRSTAT_PIDERR = 0x1
	// Position of CRC5EOF field.
	USB0_ERRSTAT_CRC5EOF_Pos = 0x1
	// Bit mask of CRC5EOF field.
	USB0_ERRSTAT_CRC5EOF_Msk = 0x2
	// Bit CRC5EOF.
	USB0_ERRSTAT_CRC5EOF = 0x2
	// Position of CRC16 field.
	USB0_ERRSTAT_CRC16_Pos = 0x2
	// Bit mask of CRC16 field.
	USB0_ERRSTAT_CRC16_Msk = 0x4
	// Bit CRC16.
	USB0_ERRSTAT_CRC16 = 0x4
	// Position of DFN8 field.
	USB0_ERRSTAT_DFN8_Pos = 0x3
	// Bit mask of DFN8 field.
	USB0_ERRSTAT_DFN8_Msk = 0x8
	// Bit DFN8.
	USB0_ERRSTAT_DFN8 = 0x8
	// Position of BTOERR field.
	USB0_ERRSTAT_BTOERR_Pos = 0x4
	// Bit mask of BTOERR field.
	USB0_ERRSTAT_BTOERR_Msk = 0x10
	// Bit BTOERR.
	USB0_ERRSTAT_BTOERR = 0x10
	// Position of DMAERR field.
	USB0_ERRSTAT_DMAERR_Pos = 0x5
	// Bit mask of DMAERR field.
	USB0_ERRSTAT_DMAERR_Msk = 0x20
	// Bit DMAERR.
	USB0_ERRSTAT_DMAERR = 0x20
	// Position of BTSERR field.
	USB0_ERRSTAT_BTSERR_Pos = 0x7
	// Bit mask of BTSERR field.
	USB0_ERRSTAT_BTSERR_Msk = 0x80
	// Bit BTSERR.
	USB0_ERRSTAT_BTSERR = 0x80

	// ERREN: Error Interrupt Enable register
	// Position of PIDERREN field.
	USB0_ERREN_PIDERREN_Pos = 0x0
	// Bit mask of PIDERREN field.
	USB0_ERREN_PIDERREN_Msk = 0x1
	// Bit PIDERREN.
	USB0_ERREN_PIDERREN = 0x1
	// Disables the PIDERR interrupt.
	USB0_ERREN_PIDERREN_0 = 0x0
	// Enters the PIDERR interrupt.
	USB0_ERREN_PIDERREN_1 = 0x1
	// Position of CRC5EOFEN field.
	USB0_ERREN_CRC5EOFEN_Pos = 0x1
	// Bit mask of CRC5EOFEN field.
	USB0_ERREN_CRC5EOFEN_Msk = 0x2
	// Bit CRC5EOFEN.
	USB0_ERREN_CRC5EOFEN = 0x2
	// Disables the CRC5/EOF interrupt.
	USB0_ERREN_CRC5EOFEN_0 = 0x0
	// Enables the CRC5/EOF interrupt.
	USB0_ERREN_CRC5EOFEN_1 = 0x1
	// Position of CRC16EN field.
	USB0_ERREN_CRC16EN_Pos = 0x2
	// Bit mask of CRC16EN field.
	USB0_ERREN_CRC16EN_Msk = 0x4
	// Bit CRC16EN.
	USB0_ERREN_CRC16EN = 0x4
	// Disables the CRC16 interrupt.
	USB0_ERREN_CRC16EN_0 = 0x0
	// Enables the CRC16 interrupt.
	USB0_ERREN_CRC16EN_1 = 0x1
	// Position of DFN8EN field.
	USB0_ERREN_DFN8EN_Pos = 0x3
	// Bit mask of DFN8EN field.
	USB0_ERREN_DFN8EN_Msk = 0x8
	// Bit DFN8EN.
	USB0_ERREN_DFN8EN = 0x8
	// Disables the DFN8 interrupt.
	USB0_ERREN_DFN8EN_0 = 0x0
	// Enables the DFN8 interrupt.
	USB0_ERREN_DFN8EN_1 = 0x1
	// Position of BTOERREN field.
	USB0_ERREN_BTOERREN_Pos = 0x4
	// Bit mask of BTOERREN field.
	USB0_ERREN_BTOERREN_Msk = 0x10
	// Bit BTOERREN.
	USB0_ERREN_BTOERREN = 0x10
	// Disables the BTOERR interrupt.
	USB0_ERREN_BTOERREN_0 = 0x0
	// Enables the BTOERR interrupt.
	USB0_ERREN_BTOERREN_1 = 0x1
	// Position of DMAERREN field.
	USB0_ERREN_DMAERREN_Pos = 0x5
	// Bit mask of DMAERREN field.
	USB0_ERREN_DMAERREN_Msk = 0x20
	// Bit DMAERREN.
	USB0_ERREN_DMAERREN = 0x20
	// Disables the DMAERR interrupt.
	USB0_ERREN_DMAERREN_0 = 0x0
	// Enables the DMAERR interrupt.
	USB0_ERREN_DMAERREN_1 = 0x1
	// Position of BTSERREN field.
	USB0_ERREN_BTSERREN_Pos = 0x7
	// Bit mask of BTSERREN field.
	USB0_ERREN_BTSERREN_Msk = 0x80
	// Bit BTSERREN.
	USB0_ERREN_BTSERREN = 0x80
	// Disables the BTSERR interrupt.
	USB0_ERREN_BTSERREN_0 = 0x0
	// Enables the BTSERR interrupt.
	USB0_ERREN_BTSERREN_1 = 0x1

	// STAT: Status register
	// Position of ODD field.
	USB0_STAT_ODD_Pos = 0x2
	// Bit mask of ODD field.
	USB0_STAT_ODD_Msk = 0x4
	// Bit ODD.
	USB0_STAT_ODD = 0x4
	// Position of TX field.
	USB0_STAT_TX_Pos = 0x3
	// Bit mask of TX field.
	USB0_STAT_TX_Msk = 0x8
	// Bit TX.
	USB0_STAT_TX = 0x8
	// The most recent transaction was a receive operation.
	USB0_STAT_TX_0 = 0x0
	// The most recent transaction was a transmit operation.
	USB0_STAT_TX_1 = 0x1
	// Position of ENDP field.
	USB0_STAT_ENDP_Pos = 0x4
	// Bit mask of ENDP field.
	USB0_STAT_ENDP_Msk = 0xf0

	// CTL: Control register
	// Position of USBENSOFEN field.
	USB0_CTL_USBENSOFEN_Pos = 0x0
	// Bit mask of USBENSOFEN field.
	USB0_CTL_USBENSOFEN_Msk = 0x1
	// Bit USBENSOFEN.
	USB0_CTL_USBENSOFEN = 0x1
	// Disables the USB Module.
	USB0_CTL_USBENSOFEN_0 = 0x0
	// Enables the USB Module.
	USB0_CTL_USBENSOFEN_1 = 0x1
	// Position of ODDRST field.
	USB0_CTL_ODDRST_Pos = 0x1
	// Bit mask of ODDRST field.
	USB0_CTL_ODDRST_Msk = 0x2
	// Bit ODDRST.
	USB0_CTL_ODDRST = 0x2
	// Position of RESUME field.
	USB0_CTL_RESUME_Pos = 0x2
	// Bit mask of RESUME field.
	USB0_CTL_RESUME_Msk = 0x4
	// Bit RESUME.
	USB0_CTL_RESUME = 0x4
	// Position of HOSTMODEEN field.
	USB0_CTL_HOSTMODEEN_Pos = 0x3
	// Bit mask of HOSTMODEEN field.
	USB0_CTL_HOSTMODEEN_Msk = 0x8
	// Bit HOSTMODEEN.
	USB0_CTL_HOSTMODEEN = 0x8
	// Position of RESET field.
	USB0_CTL_RESET_Pos = 0x4
	// Bit mask of RESET field.
	USB0_CTL_RESET_Msk = 0x10
	// Bit RESET.
	USB0_CTL_RESET = 0x10
	// Position of TXSUSPENDTOKENBUSY field.
	USB0_CTL_TXSUSPENDTOKENBUSY_Pos = 0x5
	// Bit mask of TXSUSPENDTOKENBUSY field.
	USB0_CTL_TXSUSPENDTOKENBUSY_Msk = 0x20
	// Bit TXSUSPENDTOKENBUSY.
	USB0_CTL_TXSUSPENDTOKENBUSY = 0x20
	// Position of SE0 field.
	USB0_CTL_SE0_Pos = 0x6
	// Bit mask of SE0 field.
	USB0_CTL_SE0_Msk = 0x40
	// Bit SE0.
	USB0_CTL_SE0 = 0x40
	// Position of JSTATE field.
	USB0_CTL_JSTATE_Pos = 0x7
	// Bit mask of JSTATE field.
	USB0_CTL_JSTATE_Msk = 0x80
	// Bit JSTATE.
	USB0_CTL_JSTATE = 0x80

	// ADDR: Address register
	// Position of ADDR field.
	USB0_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	USB0_ADDR_ADDR_Msk = 0x7f
	// Position of LSEN field.
	USB0_ADDR_LSEN_Pos = 0x7
	// Bit mask of LSEN field.
	USB0_ADDR_LSEN_Msk = 0x80
	// Bit LSEN.
	USB0_ADDR_LSEN = 0x80

	// BDTPAGE1: BDT Page register 1
	// Position of BDTBA field.
	USB0_BDTPAGE1_BDTBA_Pos = 0x1
	// Bit mask of BDTBA field.
	USB0_BDTPAGE1_BDTBA_Msk = 0xfe

	// FRMNUML: Frame Number register Low
	// Position of FRM field.
	USB0_FRMNUML_FRM_Pos = 0x0
	// Bit mask of FRM field.
	USB0_FRMNUML_FRM_Msk = 0xff

	// FRMNUMH: Frame Number register High
	// Position of FRM field.
	USB0_FRMNUMH_FRM_Pos = 0x0
	// Bit mask of FRM field.
	USB0_FRMNUMH_FRM_Msk = 0x7

	// TOKEN: Token register
	// Position of TOKENENDPT field.
	USB0_TOKEN_TOKENENDPT_Pos = 0x0
	// Bit mask of TOKENENDPT field.
	USB0_TOKEN_TOKENENDPT_Msk = 0xf
	// Position of TOKENPID field.
	USB0_TOKEN_TOKENPID_Pos = 0x4
	// Bit mask of TOKENPID field.
	USB0_TOKEN_TOKENPID_Msk = 0xf0
	// OUT Token. USB Module performs an OUT (TX) transaction.
	USB0_TOKEN_TOKENPID_0001 = 0x1
	// IN Token. USB Module performs an In (RX) transaction.
	USB0_TOKEN_TOKENPID_1001 = 0x9
	// SETUP Token. USB Module performs a SETUP (TX) transaction
	USB0_TOKEN_TOKENPID_1101 = 0xd

	// SOFTHLD: SOF Threshold register
	// Position of CNT field.
	USB0_SOFTHLD_CNT_Pos = 0x0
	// Bit mask of CNT field.
	USB0_SOFTHLD_CNT_Msk = 0xff

	// BDTPAGE2: BDT Page Register 2
	// Position of BDTBA field.
	USB0_BDTPAGE2_BDTBA_Pos = 0x0
	// Bit mask of BDTBA field.
	USB0_BDTPAGE2_BDTBA_Msk = 0xff

	// BDTPAGE3: BDT Page Register 3
	// Position of BDTBA field.
	USB0_BDTPAGE3_BDTBA_Pos = 0x0
	// Bit mask of BDTBA field.
	USB0_BDTPAGE3_BDTBA_Msk = 0xff

	// ENDPT0: Endpoint Control register
	// Position of EPHSHK field.
	USB0_ENDPT_EPHSHK_Pos = 0x0
	// Bit mask of EPHSHK field.
	USB0_ENDPT_EPHSHK_Msk = 0x1
	// Bit EPHSHK.
	USB0_ENDPT_EPHSHK = 0x1
	// Position of EPSTALL field.
	USB0_ENDPT_EPSTALL_Pos = 0x1
	// Bit mask of EPSTALL field.
	USB0_ENDPT_EPSTALL_Msk = 0x2
	// Bit EPSTALL.
	USB0_ENDPT_EPSTALL = 0x2
	// Position of EPTXEN field.
	USB0_ENDPT_EPTXEN_Pos = 0x2
	// Bit mask of EPTXEN field.
	USB0_ENDPT_EPTXEN_Msk = 0x4
	// Bit EPTXEN.
	USB0_ENDPT_EPTXEN = 0x4
	// Position of EPRXEN field.
	USB0_ENDPT_EPRXEN_Pos = 0x3
	// Bit mask of EPRXEN field.
	USB0_ENDPT_EPRXEN_Msk = 0x8
	// Bit EPRXEN.
	USB0_ENDPT_EPRXEN = 0x8
	// Position of EPCTLDIS field.
	USB0_ENDPT_EPCTLDIS_Pos = 0x4
	// Bit mask of EPCTLDIS field.
	USB0_ENDPT_EPCTLDIS_Msk = 0x10
	// Bit EPCTLDIS.
	USB0_ENDPT_EPCTLDIS = 0x10
	// Position of RETRYDIS field.
	USB0_ENDPT_RETRYDIS_Pos = 0x6
	// Bit mask of RETRYDIS field.
	USB0_ENDPT_RETRYDIS_Msk = 0x40
	// Bit RETRYDIS.
	USB0_ENDPT_RETRYDIS = 0x40
	// Position of HOSTWOHUB field.
	USB0_ENDPT_HOSTWOHUB_Pos = 0x7
	// Bit mask of HOSTWOHUB field.
	USB0_ENDPT_HOSTWOHUB_Msk = 0x80
	// Bit HOSTWOHUB.
	USB0_ENDPT_HOSTWOHUB = 0x80

	// USBCTRL: USB Control register
	// Position of PDE field.
	USB0_USBCTRL_PDE_Pos = 0x6
	// Bit mask of PDE field.
	USB0_USBCTRL_PDE_Msk = 0x40
	// Bit PDE.
	USB0_USBCTRL_PDE = 0x40
	// Weak pulldowns are disabled on D+ and D-.
	USB0_USBCTRL_PDE_0 = 0x0
	// Weak pulldowns are enabled on D+ and D-.
	USB0_USBCTRL_PDE_1 = 0x1
	// Position of SUSP field.
	USB0_USBCTRL_SUSP_Pos = 0x7
	// Bit mask of SUSP field.
	USB0_USBCTRL_SUSP_Msk = 0x80
	// Bit SUSP.
	USB0_USBCTRL_SUSP = 0x80
	// USB transceiver is not in suspend state.
	USB0_USBCTRL_SUSP_0 = 0x0
	// USB transceiver is in suspend state.
	USB0_USBCTRL_SUSP_1 = 0x1

	// OBSERVE: USB OTG Observe register
	// Position of DMPD field.
	USB0_OBSERVE_DMPD_Pos = 0x4
	// Bit mask of DMPD field.
	USB0_OBSERVE_DMPD_Msk = 0x10
	// Bit DMPD.
	USB0_OBSERVE_DMPD = 0x10
	// D- pulldown disabled.
	USB0_OBSERVE_DMPD_0 = 0x0
	// D- pulldown enabled.
	USB0_OBSERVE_DMPD_1 = 0x1
	// Position of DPPD field.
	USB0_OBSERVE_DPPD_Pos = 0x6
	// Bit mask of DPPD field.
	USB0_OBSERVE_DPPD_Msk = 0x40
	// Bit DPPD.
	USB0_OBSERVE_DPPD = 0x40
	// D+ pulldown disabled.
	USB0_OBSERVE_DPPD_0 = 0x0
	// D+ pulldown enabled.
	USB0_OBSERVE_DPPD_1 = 0x1
	// Position of DPPU field.
	USB0_OBSERVE_DPPU_Pos = 0x7
	// Bit mask of DPPU field.
	USB0_OBSERVE_DPPU_Msk = 0x80
	// Bit DPPU.
	USB0_OBSERVE_DPPU = 0x80
	// D+ pullup disabled.
	USB0_OBSERVE_DPPU_0 = 0x0
	// D+ pullup enabled.
	USB0_OBSERVE_DPPU_1 = 0x1

	// CONTROL: USB OTG Control register
	// Position of DPPULLUPNONOTG field.
	USB0_CONTROL_DPPULLUPNONOTG_Pos = 0x4
	// Bit mask of DPPULLUPNONOTG field.
	USB0_CONTROL_DPPULLUPNONOTG_Msk = 0x10
	// Bit DPPULLUPNONOTG.
	USB0_CONTROL_DPPULLUPNONOTG = 0x10
	// DP Pullup in non-OTG device mode is not enabled.
	USB0_CONTROL_DPPULLUPNONOTG_0 = 0x0
	// DP Pullup in non-OTG device mode is enabled.
	USB0_CONTROL_DPPULLUPNONOTG_1 = 0x1

	// USBTRC0: USB Transceiver Control register 0
	// Position of USB_RESUME_INT field.
	USB0_USBTRC0_USB_RESUME_INT_Pos = 0x0
	// Bit mask of USB_RESUME_INT field.
	USB0_USBTRC0_USB_RESUME_INT_Msk = 0x1
	// Bit USB_RESUME_INT.
	USB0_USBTRC0_USB_RESUME_INT = 0x1
	// No interrupt was generated.
	USB0_USBTRC0_USB_RESUME_INT_0 = 0x0
	// Interrupt was generated because of the USB asynchronous interrupt.
	USB0_USBTRC0_USB_RESUME_INT_1 = 0x1
	// Position of SYNC_DET field.
	USB0_USBTRC0_SYNC_DET_Pos = 0x1
	// Bit mask of SYNC_DET field.
	USB0_USBTRC0_SYNC_DET_Msk = 0x2
	// Bit SYNC_DET.
	USB0_USBTRC0_SYNC_DET = 0x2
	// Synchronous interrupt has not been detected.
	USB0_USBTRC0_SYNC_DET_0 = 0x0
	// Synchronous interrupt has been detected.
	USB0_USBTRC0_SYNC_DET_1 = 0x1
	// Position of USBRESMEN field.
	USB0_USBTRC0_USBRESMEN_Pos = 0x5
	// Bit mask of USBRESMEN field.
	USB0_USBTRC0_USBRESMEN_Msk = 0x20
	// Bit USBRESMEN.
	USB0_USBTRC0_USBRESMEN = 0x20
	// USB asynchronous wakeup from suspend mode disabled.
	USB0_USBTRC0_USBRESMEN_0 = 0x0
	// USB asynchronous wakeup from suspend mode enabled. The asynchronous resume interrupt differs from the synchronous resume interrupt in that it asynchronously detects K-state using the unfiltered state of the D+ and D- pins. This interupt should only be enabled when the Transceiver is suspended.
	USB0_USBTRC0_USBRESMEN_1 = 0x1
	// Position of USBRESET field.
	USB0_USBTRC0_USBRESET_Pos = 0x7
	// Bit mask of USBRESET field.
	USB0_USBTRC0_USBRESET_Msk = 0x80
	// Bit USBRESET.
	USB0_USBTRC0_USBRESET = 0x80
	// Normal USB module operation.
	USB0_USBTRC0_USBRESET_0 = 0x0
	// Returns the USB module to its reset state.
	USB0_USBTRC0_USBRESET_1 = 0x1

	// USBFRMADJUST: Frame Adjust Register
	// Position of ADJ field.
	USB0_USBFRMADJUST_ADJ_Pos = 0x0
	// Bit mask of ADJ field.
	USB0_USBFRMADJUST_ADJ_Msk = 0xff
)

// Constants for CMP0: High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
const (
	// CR0: CMP Control Register 0
	// Position of HYSTCTR field.
	CMP0_CR0_HYSTCTR_Pos = 0x0
	// Bit mask of HYSTCTR field.
	CMP0_CR0_HYSTCTR_Msk = 0x3
	// Level 0
	CMP0_CR0_HYSTCTR_00 = 0x0
	// Level 1
	CMP0_CR0_HYSTCTR_01 = 0x1
	// Level 2
	CMP0_CR0_HYSTCTR_10 = 0x2
	// Level 3
	CMP0_CR0_HYSTCTR_11 = 0x3
	// Position of FILTER_CNT field.
	CMP0_CR0_FILTER_CNT_Pos = 0x4
	// Bit mask of FILTER_CNT field.
	CMP0_CR0_FILTER_CNT_Msk = 0x70
	// Filter is disabled. If SE = 1, then COUT is a logic 0. This is not a legal state, and is not recommended. If SE = 0, COUT = COUTA.
	CMP0_CR0_FILTER_CNT_000 = 0x0
	// One sample must agree. The comparator output is simply sampled.
	CMP0_CR0_FILTER_CNT_001 = 0x1
	// 2 consecutive samples must agree.
	CMP0_CR0_FILTER_CNT_010 = 0x2
	// 3 consecutive samples must agree.
	CMP0_CR0_FILTER_CNT_011 = 0x3
	// 4 consecutive samples must agree.
	CMP0_CR0_FILTER_CNT_100 = 0x4
	// 5 consecutive samples must agree.
	CMP0_CR0_FILTER_CNT_101 = 0x5
	// 6 consecutive samples must agree.
	CMP0_CR0_FILTER_CNT_110 = 0x6
	// 7 consecutive samples must agree.
	CMP0_CR0_FILTER_CNT_111 = 0x7

	// CR1: CMP Control Register 1
	// Position of EN field.
	CMP0_CR1_EN_Pos = 0x0
	// Bit mask of EN field.
	CMP0_CR1_EN_Msk = 0x1
	// Bit EN.
	CMP0_CR1_EN = 0x1
	// Analog Comparator is disabled.
	CMP0_CR1_EN_0 = 0x0
	// Analog Comparator is enabled.
	CMP0_CR1_EN_1 = 0x1
	// Position of OPE field.
	CMP0_CR1_OPE_Pos = 0x1
	// Bit mask of OPE field.
	CMP0_CR1_OPE_Msk = 0x2
	// Bit OPE.
	CMP0_CR1_OPE = 0x2
	// CMPO is not available on the associated CMPO output pin. If the comparator does not own the pin, this field has no effect.
	CMP0_CR1_OPE_0 = 0x0
	// CMPO is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the field, this bit has no effect.
	CMP0_CR1_OPE_1 = 0x1
	// Position of COS field.
	CMP0_CR1_COS_Pos = 0x2
	// Bit mask of COS field.
	CMP0_CR1_COS_Msk = 0x4
	// Bit COS.
	CMP0_CR1_COS = 0x4
	// Set the filtered comparator output (CMPO) to equal COUT.
	CMP0_CR1_COS_0 = 0x0
	// Set the unfiltered comparator output (CMPO) to equal COUTA.
	CMP0_CR1_COS_1 = 0x1
	// Position of INV field.
	CMP0_CR1_INV_Pos = 0x3
	// Bit mask of INV field.
	CMP0_CR1_INV_Msk = 0x8
	// Bit INV.
	CMP0_CR1_INV = 0x8
	// Does not invert the comparator output.
	CMP0_CR1_INV_0 = 0x0
	// Inverts the comparator output.
	CMP0_CR1_INV_1 = 0x1
	// Position of PMODE field.
	CMP0_CR1_PMODE_Pos = 0x4
	// Bit mask of PMODE field.
	CMP0_CR1_PMODE_Msk = 0x10
	// Bit PMODE.
	CMP0_CR1_PMODE = 0x10
	// Low-Speed (LS) Comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
	CMP0_CR1_PMODE_0 = 0x0
	// High-Speed (HS) Comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.
	CMP0_CR1_PMODE_1 = 0x1
	// Position of TRIGM field.
	CMP0_CR1_TRIGM_Pos = 0x5
	// Bit mask of TRIGM field.
	CMP0_CR1_TRIGM_Msk = 0x20
	// Bit TRIGM.
	CMP0_CR1_TRIGM = 0x20
	// Trigger mode is disabled.
	CMP0_CR1_TRIGM_0 = 0x0
	// Trigger mode is enabled.
	CMP0_CR1_TRIGM_1 = 0x1
	// Position of WE field.
	CMP0_CR1_WE_Pos = 0x6
	// Bit mask of WE field.
	CMP0_CR1_WE_Msk = 0x40
	// Bit WE.
	CMP0_CR1_WE = 0x40
	// Windowing mode is not selected.
	CMP0_CR1_WE_0 = 0x0
	// Windowing mode is selected.
	CMP0_CR1_WE_1 = 0x1
	// Position of SE field.
	CMP0_CR1_SE_Pos = 0x7
	// Bit mask of SE field.
	CMP0_CR1_SE_Msk = 0x80
	// Bit SE.
	CMP0_CR1_SE = 0x80
	// Sampling mode is not selected.
	CMP0_CR1_SE_0 = 0x0
	// Sampling mode is selected.
	CMP0_CR1_SE_1 = 0x1

	// FPR: CMP Filter Period Register
	// Position of FILT_PER field.
	CMP0_FPR_FILT_PER_Pos = 0x0
	// Bit mask of FILT_PER field.
	CMP0_FPR_FILT_PER_Msk = 0xff

	// SCR: CMP Status and Control Register
	// Position of COUT field.
	CMP0_SCR_COUT_Pos = 0x0
	// Bit mask of COUT field.
	CMP0_SCR_COUT_Msk = 0x1
	// Bit COUT.
	CMP0_SCR_COUT = 0x1
	// Position of CFF field.
	CMP0_SCR_CFF_Pos = 0x1
	// Bit mask of CFF field.
	CMP0_SCR_CFF_Msk = 0x2
	// Bit CFF.
	CMP0_SCR_CFF = 0x2
	// Falling-edge on COUT has not been detected.
	CMP0_SCR_CFF_0 = 0x0
	// Falling-edge on COUT has occurred.
	CMP0_SCR_CFF_1 = 0x1
	// Position of CFR field.
	CMP0_SCR_CFR_Pos = 0x2
	// Bit mask of CFR field.
	CMP0_SCR_CFR_Msk = 0x4
	// Bit CFR.
	CMP0_SCR_CFR = 0x4
	// Rising-edge on COUT has not been detected.
	CMP0_SCR_CFR_0 = 0x0
	// Rising-edge on COUT has occurred.
	CMP0_SCR_CFR_1 = 0x1
	// Position of IEF field.
	CMP0_SCR_IEF_Pos = 0x3
	// Bit mask of IEF field.
	CMP0_SCR_IEF_Msk = 0x8
	// Bit IEF.
	CMP0_SCR_IEF = 0x8
	// Interrupt is disabled.
	CMP0_SCR_IEF_0 = 0x0
	// Interrupt is enabled.
	CMP0_SCR_IEF_1 = 0x1
	// Position of IER field.
	CMP0_SCR_IER_Pos = 0x4
	// Bit mask of IER field.
	CMP0_SCR_IER_Msk = 0x10
	// Bit IER.
	CMP0_SCR_IER = 0x10
	// Interrupt is disabled.
	CMP0_SCR_IER_0 = 0x0
	// Interrupt is enabled.
	CMP0_SCR_IER_1 = 0x1
	// Position of DMAEN field.
	CMP0_SCR_DMAEN_Pos = 0x6
	// Bit mask of DMAEN field.
	CMP0_SCR_DMAEN_Msk = 0x40
	// Bit DMAEN.
	CMP0_SCR_DMAEN = 0x40
	// DMA is disabled.
	CMP0_SCR_DMAEN_0 = 0x0
	// DMA is enabled.
	CMP0_SCR_DMAEN_1 = 0x1

	// DACCR: DAC Control Register
	// Position of VOSEL field.
	CMP0_DACCR_VOSEL_Pos = 0x0
	// Bit mask of VOSEL field.
	CMP0_DACCR_VOSEL_Msk = 0x3f
	// Position of VRSEL field.
	CMP0_DACCR_VRSEL_Pos = 0x6
	// Bit mask of VRSEL field.
	CMP0_DACCR_VRSEL_Msk = 0x40
	// Bit VRSEL.
	CMP0_DACCR_VRSEL = 0x40
	// V is selected as resistor ladder network supply reference V. in1 in
	CMP0_DACCR_VRSEL_0 = 0x0
	// V is selected as resistor ladder network supply reference V. in2 in
	CMP0_DACCR_VRSEL_1 = 0x1
	// Position of DACEN field.
	CMP0_DACCR_DACEN_Pos = 0x7
	// Bit mask of DACEN field.
	CMP0_DACCR_DACEN_Msk = 0x80
	// Bit DACEN.
	CMP0_DACCR_DACEN = 0x80
	// DAC is disabled.
	CMP0_DACCR_DACEN_0 = 0x0
	// DAC is enabled.
	CMP0_DACCR_DACEN_1 = 0x1

	// MUXCR: MUX Control Register
	// Position of MSEL field.
	CMP0_MUXCR_MSEL_Pos = 0x0
	// Bit mask of MSEL field.
	CMP0_MUXCR_MSEL_Msk = 0x7
	// IN0
	CMP0_MUXCR_MSEL_000 = 0x0
	// IN1
	CMP0_MUXCR_MSEL_001 = 0x1
	// IN2
	CMP0_MUXCR_MSEL_010 = 0x2
	// IN3
	CMP0_MUXCR_MSEL_011 = 0x3
	// IN4
	CMP0_MUXCR_MSEL_100 = 0x4
	// IN5
	CMP0_MUXCR_MSEL_101 = 0x5
	// IN6
	CMP0_MUXCR_MSEL_110 = 0x6
	// IN7
	CMP0_MUXCR_MSEL_111 = 0x7
	// Position of PSEL field.
	CMP0_MUXCR_PSEL_Pos = 0x3
	// Bit mask of PSEL field.
	CMP0_MUXCR_PSEL_Msk = 0x38
	// IN0
	CMP0_MUXCR_PSEL_000 = 0x0
	// IN1
	CMP0_MUXCR_PSEL_001 = 0x1
	// IN2
	CMP0_MUXCR_PSEL_010 = 0x2
	// IN3
	CMP0_MUXCR_PSEL_011 = 0x3
	// IN4
	CMP0_MUXCR_PSEL_100 = 0x4
	// IN5
	CMP0_MUXCR_PSEL_101 = 0x5
	// IN6
	CMP0_MUXCR_PSEL_110 = 0x6
	// IN7
	CMP0_MUXCR_PSEL_111 = 0x7
	// Position of PSTM field.
	CMP0_MUXCR_PSTM_Pos = 0x7
	// Bit mask of PSTM field.
	CMP0_MUXCR_PSTM_Msk = 0x80
	// Bit PSTM.
	CMP0_MUXCR_PSTM = 0x80
	// Pass Through Mode is disabled.
	CMP0_MUXCR_PSTM_0 = 0x0
	// Pass Through Mode is enabled.
	CMP0_MUXCR_PSTM_1 = 0x1
)

// Constants for SPI0: Serial Peripheral Interface
const (
	// S: SPI Status Register
	// Position of MODF field.
	SPI_S_MODF_Pos = 0x4
	// Bit mask of MODF field.
	SPI_S_MODF_Msk = 0x10
	// Bit MODF.
	SPI_S_MODF = 0x10
	// No mode fault error
	SPI_S_MODF_0 = 0x0
	// Mode fault error detected
	SPI_S_MODF_1 = 0x1
	// Position of SPTEF field.
	SPI_S_SPTEF_Pos = 0x5
	// Bit mask of SPTEF field.
	SPI_S_SPTEF_Msk = 0x20
	// Bit SPTEF.
	SPI_S_SPTEF = 0x20
	// SPI transmit buffer not empty (when FIFOMODE is not present or is 0) or SPI FIFO not empty (when FIFOMODE is 1)
	SPI_S_SPTEF_0 = 0x0
	// SPI transmit buffer empty (when FIFOMODE is not present or is 0) or SPI FIFO empty (when FIFOMODE is 1)
	SPI_S_SPTEF_1 = 0x1
	// Position of SPMF field.
	SPI_S_SPMF_Pos = 0x6
	// Bit mask of SPMF field.
	SPI_S_SPMF_Msk = 0x40
	// Bit SPMF.
	SPI_S_SPMF = 0x40
	// Value in the receive data buffer does not match the value in the MH:ML registers
	SPI_S_SPMF_0 = 0x0
	// Value in the receive data buffer matches the value in the MH:ML registers
	SPI_S_SPMF_1 = 0x1
	// Position of SPRF field.
	SPI_S_SPRF_Pos = 0x7
	// Bit mask of SPRF field.
	SPI_S_SPRF_Msk = 0x80
	// Bit SPRF.
	SPI_S_SPRF = 0x80
	// No data available in the receive data buffer (when FIFOMODE is not present or is 0) or Read FIFO is not full (when FIFOMODE is 1)
	SPI_S_SPRF_0 = 0x0
	// Data available in the receive data buffer (when FIFOMODE is not present or is 0) or Read FIFO is full (when FIFOMODE is 1)
	SPI_S_SPRF_1 = 0x1

	// BR: SPI Baud Rate Register
	// Position of SPR field.
	SPI_BR_SPR_Pos = 0x0
	// Bit mask of SPR field.
	SPI_BR_SPR_Msk = 0xf
	// Baud rate divisor is 2.
	SPI_BR_SPR_0000 = 0x0
	// Baud rate divisor is 4.
	SPI_BR_SPR_0001 = 0x1
	// Baud rate divisor is 8.
	SPI_BR_SPR_0010 = 0x2
	// Baud rate divisor is 16.
	SPI_BR_SPR_0011 = 0x3
	// Baud rate divisor is 32.
	SPI_BR_SPR_0100 = 0x4
	// Baud rate divisor is 64.
	SPI_BR_SPR_0101 = 0x5
	// Baud rate divisor is 128.
	SPI_BR_SPR_0110 = 0x6
	// Baud rate divisor is 256.
	SPI_BR_SPR_0111 = 0x7
	// Baud rate divisor is 512.
	SPI_BR_SPR_1000 = 0x8
	// Position of SPPR field.
	SPI_BR_SPPR_Pos = 0x4
	// Bit mask of SPPR field.
	SPI_BR_SPPR_Msk = 0x70
	// Baud rate prescaler divisor is 1.
	SPI_BR_SPPR_000 = 0x0
	// Baud rate prescaler divisor is 2.
	SPI_BR_SPPR_001 = 0x1
	// Baud rate prescaler divisor is 3.
	SPI_BR_SPPR_010 = 0x2
	// Baud rate prescaler divisor is 4.
	SPI_BR_SPPR_011 = 0x3
	// Baud rate prescaler divisor is 5.
	SPI_BR_SPPR_100 = 0x4
	// Baud rate prescaler divisor is 6.
	SPI_BR_SPPR_101 = 0x5
	// Baud rate prescaler divisor is 7.
	SPI_BR_SPPR_110 = 0x6
	// Baud rate prescaler divisor is 8.
	SPI_BR_SPPR_111 = 0x7

	// C2: SPI Control Register 2
	// Position of SPC0 field.
	SPI_C2_SPC0_Pos = 0x0
	// Bit mask of SPC0 field.
	SPI_C2_SPC0_Msk = 0x1
	// Bit SPC0.
	SPI_C2_SPC0 = 0x1
	// SPI uses separate pins for data input and data output (pin mode is normal). In master mode of operation: MISO is master in and MOSI is master out. In slave mode of operation: MISO is slave out and MOSI is slave in.
	SPI_C2_SPC0_0 = 0x0
	// SPI configured for single-wire bidirectional operation (pin mode is bidirectional). In master mode of operation: MISO is not used by SPI; MOSI is master in when BIDIROE is 0 or master I/O when BIDIROE is 1. In slave mode of operation: MISO is slave in when BIDIROE is 0 or slave I/O when BIDIROE is 1; MOSI is not used by SPI.
	SPI_C2_SPC0_1 = 0x1
	// Position of SPISWAI field.
	SPI_C2_SPISWAI_Pos = 0x1
	// Bit mask of SPISWAI field.
	SPI_C2_SPISWAI_Msk = 0x2
	// Bit SPISWAI.
	SPI_C2_SPISWAI = 0x2
	// SPI clocks continue to operate in Wait mode.
	SPI_C2_SPISWAI_0 = 0x0
	// SPI clocks stop when the MCU enters Wait mode.
	SPI_C2_SPISWAI_1 = 0x1
	// Position of RXDMAE field.
	SPI_C2_RXDMAE_Pos = 0x2
	// Bit mask of RXDMAE field.
	SPI_C2_RXDMAE_Msk = 0x4
	// Bit RXDMAE.
	SPI_C2_RXDMAE = 0x4
	// DMA request for receive is disabled and interrupt from SPRF is allowed
	SPI_C2_RXDMAE_0 = 0x0
	// DMA request for receive is enabled and interrupt from SPRF is disabled
	SPI_C2_RXDMAE_1 = 0x1
	// Position of BIDIROE field.
	SPI_C2_BIDIROE_Pos = 0x3
	// Bit mask of BIDIROE field.
	SPI_C2_BIDIROE_Msk = 0x8
	// Bit BIDIROE.
	SPI_C2_BIDIROE = 0x8
	// Output driver disabled so SPI data I/O pin acts as an input
	SPI_C2_BIDIROE_0 = 0x0
	// SPI I/O pin enabled as an output
	SPI_C2_BIDIROE_1 = 0x1
	// Position of MODFEN field.
	SPI_C2_MODFEN_Pos = 0x4
	// Bit mask of MODFEN field.
	SPI_C2_MODFEN_Msk = 0x10
	// Bit MODFEN.
	SPI_C2_MODFEN = 0x10
	// Mode fault function disabled, master SS pin reverts to general-purpose I/O not controlled by SPI
	SPI_C2_MODFEN_0 = 0x0
	// Mode fault function enabled, master SS pin acts as the mode fault input or the slave select output
	SPI_C2_MODFEN_1 = 0x1
	// Position of TXDMAE field.
	SPI_C2_TXDMAE_Pos = 0x5
	// Bit mask of TXDMAE field.
	SPI_C2_TXDMAE_Msk = 0x20
	// Bit TXDMAE.
	SPI_C2_TXDMAE = 0x20
	// DMA request for transmit is disabled and interrupt from SPTEF is allowed
	SPI_C2_TXDMAE_0 = 0x0
	// DMA request for transmit is enabled and interrupt from SPTEF is disabled
	SPI_C2_TXDMAE_1 = 0x1
	// Position of SPIMODE field.
	SPI_C2_SPIMODE_Pos = 0x6
	// Bit mask of SPIMODE field.
	SPI_C2_SPIMODE_Msk = 0x40
	// Bit SPIMODE.
	SPI_C2_SPIMODE = 0x40
	// 8-bit SPI shift register, match register, and buffers
	SPI_C2_SPIMODE_0 = 0x0
	// 16-bit SPI shift register, match register, and buffers
	SPI_C2_SPIMODE_1 = 0x1
	// Position of SPMIE field.
	SPI_C2_SPMIE_Pos = 0x7
	// Bit mask of SPMIE field.
	SPI_C2_SPMIE_Msk = 0x80
	// Bit SPMIE.
	SPI_C2_SPMIE = 0x80
	// Interrupts from SPMF inhibited (use polling)
	SPI_C2_SPMIE_0 = 0x0
	// When SPMF is 1, requests a hardware interrupt
	SPI_C2_SPMIE_1 = 0x1

	// C1: SPI Control Register 1
	// Position of LSBFE field.
	SPI_C1_LSBFE_Pos = 0x0
	// Bit mask of LSBFE field.
	SPI_C1_LSBFE_Msk = 0x1
	// Bit LSBFE.
	SPI_C1_LSBFE = 0x1
	// SPI serial data transfers start with the most significant bit.
	SPI_C1_LSBFE_0 = 0x0
	// SPI serial data transfers start with the least significant bit.
	SPI_C1_LSBFE_1 = 0x1
	// Position of SSOE field.
	SPI_C1_SSOE_Pos = 0x1
	// Bit mask of SSOE field.
	SPI_C1_SSOE_Msk = 0x2
	// Bit SSOE.
	SPI_C1_SSOE = 0x2
	// When C2[MODFEN] is 0: In master mode, SS pin function is general-purpose I/O (not SPI). In slave mode, SS pin function is slave select input. When C2[MODFEN] is 1: In master mode, SS pin function is SS input for mode fault. In slave mode, SS pin function is slave select input.
	SPI_C1_SSOE_0 = 0x0
	// When C2[MODFEN] is 0: In master mode, SS pin function is general-purpose I/O (not SPI). In slave mode, SS pin function is slave select input. When C2[MODFEN] is 1: In master mode, SS pin function is automatic SS output. In slave mode: SS pin function is slave select input.
	SPI_C1_SSOE_1 = 0x1
	// Position of CPHA field.
	SPI_C1_CPHA_Pos = 0x2
	// Bit mask of CPHA field.
	SPI_C1_CPHA_Msk = 0x4
	// Bit CPHA.
	SPI_C1_CPHA = 0x4
	// First edge on SPSCK occurs at the middle of the first cycle of a data transfer.
	SPI_C1_CPHA_0 = 0x0
	// First edge on SPSCK occurs at the start of the first cycle of a data transfer.
	SPI_C1_CPHA_1 = 0x1
	// Position of CPOL field.
	SPI_C1_CPOL_Pos = 0x3
	// Bit mask of CPOL field.
	SPI_C1_CPOL_Msk = 0x8
	// Bit CPOL.
	SPI_C1_CPOL = 0x8
	// Active-high SPI clock (idles low)
	SPI_C1_CPOL_0 = 0x0
	// Active-low SPI clock (idles high)
	SPI_C1_CPOL_1 = 0x1
	// Position of MSTR field.
	SPI_C1_MSTR_Pos = 0x4
	// Bit mask of MSTR field.
	SPI_C1_MSTR_Msk = 0x10
	// Bit MSTR.
	SPI_C1_MSTR = 0x10
	// SPI module configured as a slave SPI device
	SPI_C1_MSTR_0 = 0x0
	// SPI module configured as a master SPI device
	SPI_C1_MSTR_1 = 0x1
	// Position of SPTIE field.
	SPI_C1_SPTIE_Pos = 0x5
	// Bit mask of SPTIE field.
	SPI_C1_SPTIE_Msk = 0x20
	// Bit SPTIE.
	SPI_C1_SPTIE = 0x20
	// Interrupts from SPTEF inhibited (use polling)
	SPI_C1_SPTIE_0 = 0x0
	// When SPTEF is 1, hardware interrupt requested
	SPI_C1_SPTIE_1 = 0x1
	// Position of SPE field.
	SPI_C1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_C1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_C1_SPE = 0x40
	// SPI system inactive
	SPI_C1_SPE_0 = 0x0
	// SPI system enabled
	SPI_C1_SPE_1 = 0x1
	// Position of SPIE field.
	SPI_C1_SPIE_Pos = 0x7
	// Bit mask of SPIE field.
	SPI_C1_SPIE_Msk = 0x80
	// Bit SPIE.
	SPI_C1_SPIE = 0x80
	// Interrupts from SPRF and MODF are inhibited-use polling (when FIFOMODE is not present or is 0) or Read FIFO Full Interrupts are disabled (when FIFOMODE is 1)
	SPI_C1_SPIE_0 = 0x0
	// Request a hardware interrupt when SPRF or MODF is 1 (when FIFOMODE is not present or is 0) or Read FIFO Full Interrupts are enabled (when FIFOMODE is 1)
	SPI_C1_SPIE_1 = 0x1

	// ML: SPI Match Register low
	// Position of Bits field.
	SPI_ML_Bits_Pos = 0x0
	// Bit mask of Bits field.
	SPI_ML_Bits_Msk = 0xff

	// MH: SPI match register high
	// Position of Bits field.
	SPI_MH_Bits_Pos = 0x0
	// Bit mask of Bits field.
	SPI_MH_Bits_Msk = 0xff

	// DL: SPI Data Register low
	// Position of Bits field.
	SPI_DL_Bits_Pos = 0x0
	// Bit mask of Bits field.
	SPI_DL_Bits_Msk = 0xff

	// DH: SPI data register high
	// Position of Bits field.
	SPI_DH_Bits_Pos = 0x0
	// Bit mask of Bits field.
	SPI_DH_Bits_Msk = 0xff
)

// Constants for LLWU: Low leakage wakeup unit
const (
	// PE1: LLWU Pin Enable 1 register
	// Position of WUPE0 field.
	LLWU_PE1_WUPE0_Pos = 0x0
	// Bit mask of WUPE0 field.
	LLWU_PE1_WUPE0_Msk = 0x3
	// External input pin disabled as wakeup input
	LLWU_PE1_WUPE0_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE1_WUPE0_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE1_WUPE0_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE1_WUPE0_11 = 0x3
	// Position of WUPE1 field.
	LLWU_PE1_WUPE1_Pos = 0x2
	// Bit mask of WUPE1 field.
	LLWU_PE1_WUPE1_Msk = 0xc
	// External input pin disabled as wakeup input
	LLWU_PE1_WUPE1_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE1_WUPE1_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE1_WUPE1_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE1_WUPE1_11 = 0x3
	// Position of WUPE2 field.
	LLWU_PE1_WUPE2_Pos = 0x4
	// Bit mask of WUPE2 field.
	LLWU_PE1_WUPE2_Msk = 0x30
	// External input pin disabled as wakeup input
	LLWU_PE1_WUPE2_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE1_WUPE2_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE1_WUPE2_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE1_WUPE2_11 = 0x3
	// Position of WUPE3 field.
	LLWU_PE1_WUPE3_Pos = 0x6
	// Bit mask of WUPE3 field.
	LLWU_PE1_WUPE3_Msk = 0xc0
	// External input pin disabled as wakeup input
	LLWU_PE1_WUPE3_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE1_WUPE3_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE1_WUPE3_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE1_WUPE3_11 = 0x3

	// PE2: LLWU Pin Enable 2 register
	// Position of WUPE4 field.
	LLWU_PE2_WUPE4_Pos = 0x0
	// Bit mask of WUPE4 field.
	LLWU_PE2_WUPE4_Msk = 0x3
	// External input pin disabled as wakeup input
	LLWU_PE2_WUPE4_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE2_WUPE4_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE2_WUPE4_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE2_WUPE4_11 = 0x3
	// Position of WUPE5 field.
	LLWU_PE2_WUPE5_Pos = 0x2
	// Bit mask of WUPE5 field.
	LLWU_PE2_WUPE5_Msk = 0xc
	// External input pin disabled as wakeup input
	LLWU_PE2_WUPE5_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE2_WUPE5_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE2_WUPE5_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE2_WUPE5_11 = 0x3
	// Position of WUPE6 field.
	LLWU_PE2_WUPE6_Pos = 0x4
	// Bit mask of WUPE6 field.
	LLWU_PE2_WUPE6_Msk = 0x30
	// External input pin disabled as wakeup input
	LLWU_PE2_WUPE6_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE2_WUPE6_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE2_WUPE6_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE2_WUPE6_11 = 0x3
	// Position of WUPE7 field.
	LLWU_PE2_WUPE7_Pos = 0x6
	// Bit mask of WUPE7 field.
	LLWU_PE2_WUPE7_Msk = 0xc0
	// External input pin disabled as wakeup input
	LLWU_PE2_WUPE7_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE2_WUPE7_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE2_WUPE7_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE2_WUPE7_11 = 0x3

	// PE3: LLWU Pin Enable 3 register
	// Position of WUPE8 field.
	LLWU_PE3_WUPE8_Pos = 0x0
	// Bit mask of WUPE8 field.
	LLWU_PE3_WUPE8_Msk = 0x3
	// External input pin disabled as wakeup input
	LLWU_PE3_WUPE8_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE3_WUPE8_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE3_WUPE8_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE3_WUPE8_11 = 0x3
	// Position of WUPE9 field.
	LLWU_PE3_WUPE9_Pos = 0x2
	// Bit mask of WUPE9 field.
	LLWU_PE3_WUPE9_Msk = 0xc
	// External input pin disabled as wakeup input
	LLWU_PE3_WUPE9_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE3_WUPE9_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE3_WUPE9_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE3_WUPE9_11 = 0x3
	// Position of WUPE10 field.
	LLWU_PE3_WUPE10_Pos = 0x4
	// Bit mask of WUPE10 field.
	LLWU_PE3_WUPE10_Msk = 0x30
	// External input pin disabled as wakeup input
	LLWU_PE3_WUPE10_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE3_WUPE10_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE3_WUPE10_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE3_WUPE10_11 = 0x3
	// Position of WUPE11 field.
	LLWU_PE3_WUPE11_Pos = 0x6
	// Bit mask of WUPE11 field.
	LLWU_PE3_WUPE11_Msk = 0xc0
	// External input pin disabled as wakeup input
	LLWU_PE3_WUPE11_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE3_WUPE11_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE3_WUPE11_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE3_WUPE11_11 = 0x3

	// PE4: LLWU Pin Enable 4 register
	// Position of WUPE12 field.
	LLWU_PE4_WUPE12_Pos = 0x0
	// Bit mask of WUPE12 field.
	LLWU_PE4_WUPE12_Msk = 0x3
	// External input pin disabled as wakeup input
	LLWU_PE4_WUPE12_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE4_WUPE12_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE4_WUPE12_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE4_WUPE12_11 = 0x3
	// Position of WUPE13 field.
	LLWU_PE4_WUPE13_Pos = 0x2
	// Bit mask of WUPE13 field.
	LLWU_PE4_WUPE13_Msk = 0xc
	// External input pin disabled as wakeup input
	LLWU_PE4_WUPE13_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE4_WUPE13_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE4_WUPE13_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE4_WUPE13_11 = 0x3
	// Position of WUPE14 field.
	LLWU_PE4_WUPE14_Pos = 0x4
	// Bit mask of WUPE14 field.
	LLWU_PE4_WUPE14_Msk = 0x30
	// External input pin disabled as wakeup input
	LLWU_PE4_WUPE14_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE4_WUPE14_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE4_WUPE14_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE4_WUPE14_11 = 0x3
	// Position of WUPE15 field.
	LLWU_PE4_WUPE15_Pos = 0x6
	// Bit mask of WUPE15 field.
	LLWU_PE4_WUPE15_Msk = 0xc0
	// External input pin disabled as wakeup input
	LLWU_PE4_WUPE15_00 = 0x0
	// External input pin enabled with rising edge detection
	LLWU_PE4_WUPE15_01 = 0x1
	// External input pin enabled with falling edge detection
	LLWU_PE4_WUPE15_10 = 0x2
	// External input pin enabled with any change detection
	LLWU_PE4_WUPE15_11 = 0x3

	// ME: LLWU Module Enable register
	// Position of WUME0 field.
	LLWU_ME_WUME0_Pos = 0x0
	// Bit mask of WUME0 field.
	LLWU_ME_WUME0_Msk = 0x1
	// Bit WUME0.
	LLWU_ME_WUME0 = 0x1
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME0_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME0_1 = 0x1
	// Position of WUME1 field.
	LLWU_ME_WUME1_Pos = 0x1
	// Bit mask of WUME1 field.
	LLWU_ME_WUME1_Msk = 0x2
	// Bit WUME1.
	LLWU_ME_WUME1 = 0x2
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME1_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME1_1 = 0x1
	// Position of WUME2 field.
	LLWU_ME_WUME2_Pos = 0x2
	// Bit mask of WUME2 field.
	LLWU_ME_WUME2_Msk = 0x4
	// Bit WUME2.
	LLWU_ME_WUME2 = 0x4
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME2_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME2_1 = 0x1
	// Position of WUME3 field.
	LLWU_ME_WUME3_Pos = 0x3
	// Bit mask of WUME3 field.
	LLWU_ME_WUME3_Msk = 0x8
	// Bit WUME3.
	LLWU_ME_WUME3 = 0x8
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME3_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME3_1 = 0x1
	// Position of WUME4 field.
	LLWU_ME_WUME4_Pos = 0x4
	// Bit mask of WUME4 field.
	LLWU_ME_WUME4_Msk = 0x10
	// Bit WUME4.
	LLWU_ME_WUME4 = 0x10
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME4_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME4_1 = 0x1
	// Position of WUME5 field.
	LLWU_ME_WUME5_Pos = 0x5
	// Bit mask of WUME5 field.
	LLWU_ME_WUME5_Msk = 0x20
	// Bit WUME5.
	LLWU_ME_WUME5 = 0x20
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME5_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME5_1 = 0x1
	// Position of WUME6 field.
	LLWU_ME_WUME6_Pos = 0x6
	// Bit mask of WUME6 field.
	LLWU_ME_WUME6_Msk = 0x40
	// Bit WUME6.
	LLWU_ME_WUME6 = 0x40
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME6_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME6_1 = 0x1
	// Position of WUME7 field.
	LLWU_ME_WUME7_Pos = 0x7
	// Bit mask of WUME7 field.
	LLWU_ME_WUME7_Msk = 0x80
	// Bit WUME7.
	LLWU_ME_WUME7 = 0x80
	// Internal module flag not used as wakeup source
	LLWU_ME_WUME7_0 = 0x0
	// Internal module flag used as wakeup source
	LLWU_ME_WUME7_1 = 0x1

	// F1: LLWU Flag 1 register
	// Position of WUF0 field.
	LLWU_F1_WUF0_Pos = 0x0
	// Bit mask of WUF0 field.
	LLWU_F1_WUF0_Msk = 0x1
	// Bit WUF0.
	LLWU_F1_WUF0 = 0x1
	// LLWU_P0 input was not a wakeup source
	LLWU_F1_WUF0_0 = 0x0
	// LLWU_P0 input was a wakeup source
	LLWU_F1_WUF0_1 = 0x1
	// Position of WUF1 field.
	LLWU_F1_WUF1_Pos = 0x1
	// Bit mask of WUF1 field.
	LLWU_F1_WUF1_Msk = 0x2
	// Bit WUF1.
	LLWU_F1_WUF1 = 0x2
	// LLWU_P1 input was not a wakeup source
	LLWU_F1_WUF1_0 = 0x0
	// LLWU_P1 input was a wakeup source
	LLWU_F1_WUF1_1 = 0x1
	// Position of WUF2 field.
	LLWU_F1_WUF2_Pos = 0x2
	// Bit mask of WUF2 field.
	LLWU_F1_WUF2_Msk = 0x4
	// Bit WUF2.
	LLWU_F1_WUF2 = 0x4
	// LLWU_P2 input was not a wakeup source
	LLWU_F1_WUF2_0 = 0x0
	// LLWU_P2 input was a wakeup source
	LLWU_F1_WUF2_1 = 0x1
	// Position of WUF3 field.
	LLWU_F1_WUF3_Pos = 0x3
	// Bit mask of WUF3 field.
	LLWU_F1_WUF3_Msk = 0x8
	// Bit WUF3.
	LLWU_F1_WUF3 = 0x8
	// LLWU_P3 input was not a wake-up source
	LLWU_F1_WUF3_0 = 0x0
	// LLWU_P3 input was a wake-up source
	LLWU_F1_WUF3_1 = 0x1
	// Position of WUF4 field.
	LLWU_F1_WUF4_Pos = 0x4
	// Bit mask of WUF4 field.
	LLWU_F1_WUF4_Msk = 0x10
	// Bit WUF4.
	LLWU_F1_WUF4 = 0x10
	// LLWU_P4 input was not a wakeup source
	LLWU_F1_WUF4_0 = 0x0
	// LLWU_P4 input was a wakeup source
	LLWU_F1_WUF4_1 = 0x1
	// Position of WUF5 field.
	LLWU_F1_WUF5_Pos = 0x5
	// Bit mask of WUF5 field.
	LLWU_F1_WUF5_Msk = 0x20
	// Bit WUF5.
	LLWU_F1_WUF5 = 0x20
	// LLWU_P5 input was not a wakeup source
	LLWU_F1_WUF5_0 = 0x0
	// LLWU_P5 input was a wakeup source
	LLWU_F1_WUF5_1 = 0x1
	// Position of WUF6 field.
	LLWU_F1_WUF6_Pos = 0x6
	// Bit mask of WUF6 field.
	LLWU_F1_WUF6_Msk = 0x40
	// Bit WUF6.
	LLWU_F1_WUF6 = 0x40
	// LLWU_P6 input was not a wakeup source
	LLWU_F1_WUF6_0 = 0x0
	// LLWU_P6 input was a wakeup source
	LLWU_F1_WUF6_1 = 0x1
	// Position of WUF7 field.
	LLWU_F1_WUF7_Pos = 0x7
	// Bit mask of WUF7 field.
	LLWU_F1_WUF7_Msk = 0x80
	// Bit WUF7.
	LLWU_F1_WUF7 = 0x80
	// LLWU_P7 input was not a wakeup source
	LLWU_F1_WUF7_0 = 0x0
	// LLWU_P7 input was a wakeup source
	LLWU_F1_WUF7_1 = 0x1

	// F2: LLWU Flag 2 register
	// Position of WUF8 field.
	LLWU_F2_WUF8_Pos = 0x0
	// Bit mask of WUF8 field.
	LLWU_F2_WUF8_Msk = 0x1
	// Bit WUF8.
	LLWU_F2_WUF8 = 0x1
	// LLWU_P8 input was not a wakeup source
	LLWU_F2_WUF8_0 = 0x0
	// LLWU_P8 input was a wakeup source
	LLWU_F2_WUF8_1 = 0x1
	// Position of WUF9 field.
	LLWU_F2_WUF9_Pos = 0x1
	// Bit mask of WUF9 field.
	LLWU_F2_WUF9_Msk = 0x2
	// Bit WUF9.
	LLWU_F2_WUF9 = 0x2
	// LLWU_P9 input was not a wakeup source
	LLWU_F2_WUF9_0 = 0x0
	// LLWU_P9 input was a wakeup source
	LLWU_F2_WUF9_1 = 0x1
	// Position of WUF10 field.
	LLWU_F2_WUF10_Pos = 0x2
	// Bit mask of WUF10 field.
	LLWU_F2_WUF10_Msk = 0x4
	// Bit WUF10.
	LLWU_F2_WUF10 = 0x4
	// LLWU_P10 input was not a wakeup source
	LLWU_F2_WUF10_0 = 0x0
	// LLWU_P10 input was a wakeup source
	LLWU_F2_WUF10_1 = 0x1
	// Position of WUF11 field.
	LLWU_F2_WUF11_Pos = 0x3
	// Bit mask of WUF11 field.
	LLWU_F2_WUF11_Msk = 0x8
	// Bit WUF11.
	LLWU_F2_WUF11 = 0x8
	// LLWU_P11 input was not a wakeup source
	LLWU_F2_WUF11_0 = 0x0
	// LLWU_P11 input was a wakeup source
	LLWU_F2_WUF11_1 = 0x1
	// Position of WUF12 field.
	LLWU_F2_WUF12_Pos = 0x4
	// Bit mask of WUF12 field.
	LLWU_F2_WUF12_Msk = 0x10
	// Bit WUF12.
	LLWU_F2_WUF12 = 0x10
	// LLWU_P12 input was not a wakeup source
	LLWU_F2_WUF12_0 = 0x0
	// LLWU_P12 input was a wakeup source
	LLWU_F2_WUF12_1 = 0x1
	// Position of WUF13 field.
	LLWU_F2_WUF13_Pos = 0x5
	// Bit mask of WUF13 field.
	LLWU_F2_WUF13_Msk = 0x20
	// Bit WUF13.
	LLWU_F2_WUF13 = 0x20
	// LLWU_P13 input was not a wakeup source
	LLWU_F2_WUF13_0 = 0x0
	// LLWU_P13 input was a wakeup source
	LLWU_F2_WUF13_1 = 0x1
	// Position of WUF14 field.
	LLWU_F2_WUF14_Pos = 0x6
	// Bit mask of WUF14 field.
	LLWU_F2_WUF14_Msk = 0x40
	// Bit WUF14.
	LLWU_F2_WUF14 = 0x40
	// LLWU_P14 input was not a wakeup source
	LLWU_F2_WUF14_0 = 0x0
	// LLWU_P14 input was a wakeup source
	LLWU_F2_WUF14_1 = 0x1
	// Position of WUF15 field.
	LLWU_F2_WUF15_Pos = 0x7
	// Bit mask of WUF15 field.
	LLWU_F2_WUF15_Msk = 0x80
	// Bit WUF15.
	LLWU_F2_WUF15 = 0x80
	// LLWU_P15 input was not a wakeup source
	LLWU_F2_WUF15_0 = 0x0
	// LLWU_P15 input was a wakeup source
	LLWU_F2_WUF15_1 = 0x1

	// F3: LLWU Flag 3 register
	// Position of MWUF0 field.
	LLWU_F3_MWUF0_Pos = 0x0
	// Bit mask of MWUF0 field.
	LLWU_F3_MWUF0_Msk = 0x1
	// Bit MWUF0.
	LLWU_F3_MWUF0 = 0x1
	// Module 0 input was not a wakeup source
	LLWU_F3_MWUF0_0 = 0x0
	// Module 0 input was a wakeup source
	LLWU_F3_MWUF0_1 = 0x1
	// Position of MWUF1 field.
	LLWU_F3_MWUF1_Pos = 0x1
	// Bit mask of MWUF1 field.
	LLWU_F3_MWUF1_Msk = 0x2
	// Bit MWUF1.
	LLWU_F3_MWUF1 = 0x2
	// Module 1 input was not a wakeup source
	LLWU_F3_MWUF1_0 = 0x0
	// Module 1 input was a wakeup source
	LLWU_F3_MWUF1_1 = 0x1
	// Position of MWUF2 field.
	LLWU_F3_MWUF2_Pos = 0x2
	// Bit mask of MWUF2 field.
	LLWU_F3_MWUF2_Msk = 0x4
	// Bit MWUF2.
	LLWU_F3_MWUF2 = 0x4
	// Module 2 input was not a wakeup source
	LLWU_F3_MWUF2_0 = 0x0
	// Module 2 input was a wakeup source
	LLWU_F3_MWUF2_1 = 0x1
	// Position of MWUF3 field.
	LLWU_F3_MWUF3_Pos = 0x3
	// Bit mask of MWUF3 field.
	LLWU_F3_MWUF3_Msk = 0x8
	// Bit MWUF3.
	LLWU_F3_MWUF3 = 0x8
	// Module 3 input was not a wakeup source
	LLWU_F3_MWUF3_0 = 0x0
	// Module 3 input was a wakeup source
	LLWU_F3_MWUF3_1 = 0x1
	// Position of MWUF4 field.
	LLWU_F3_MWUF4_Pos = 0x4
	// Bit mask of MWUF4 field.
	LLWU_F3_MWUF4_Msk = 0x10
	// Bit MWUF4.
	LLWU_F3_MWUF4 = 0x10
	// Module 4 input was not a wakeup source
	LLWU_F3_MWUF4_0 = 0x0
	// Module 4 input was a wakeup source
	LLWU_F3_MWUF4_1 = 0x1
	// Position of MWUF5 field.
	LLWU_F3_MWUF5_Pos = 0x5
	// Bit mask of MWUF5 field.
	LLWU_F3_MWUF5_Msk = 0x20
	// Bit MWUF5.
	LLWU_F3_MWUF5 = 0x20
	// Module 5 input was not a wakeup source
	LLWU_F3_MWUF5_0 = 0x0
	// Module 5 input was a wakeup source
	LLWU_F3_MWUF5_1 = 0x1
	// Position of MWUF6 field.
	LLWU_F3_MWUF6_Pos = 0x6
	// Bit mask of MWUF6 field.
	LLWU_F3_MWUF6_Msk = 0x40
	// Bit MWUF6.
	LLWU_F3_MWUF6 = 0x40
	// Module 6 input was not a wakeup source
	LLWU_F3_MWUF6_0 = 0x0
	// Module 6 input was a wakeup source
	LLWU_F3_MWUF6_1 = 0x1
	// Position of MWUF7 field.
	LLWU_F3_MWUF7_Pos = 0x7
	// Bit mask of MWUF7 field.
	LLWU_F3_MWUF7_Msk = 0x80
	// Bit MWUF7.
	LLWU_F3_MWUF7 = 0x80
	// Module 7 input was not a wakeup source
	LLWU_F3_MWUF7_0 = 0x0
	// Module 7 input was a wakeup source
	LLWU_F3_MWUF7_1 = 0x1

	// FILT1: LLWU Pin Filter 1 register
	// Position of FILTSEL field.
	LLWU_FILT1_FILTSEL_Pos = 0x0
	// Bit mask of FILTSEL field.
	LLWU_FILT1_FILTSEL_Msk = 0xf
	// Select LLWU_P0 for filter
	LLWU_FILT1_FILTSEL_0000 = 0x0
	// Select LLWU_P15 for filter
	LLWU_FILT1_FILTSEL_1111 = 0xf
	// Position of FILTE field.
	LLWU_FILT1_FILTE_Pos = 0x5
	// Bit mask of FILTE field.
	LLWU_FILT1_FILTE_Msk = 0x60
	// Filter disabled
	LLWU_FILT1_FILTE_00 = 0x0
	// Filter posedge detect enabled
	LLWU_FILT1_FILTE_01 = 0x1
	// Filter negedge detect enabled
	LLWU_FILT1_FILTE_10 = 0x2
	// Filter any edge detect enabled
	LLWU_FILT1_FILTE_11 = 0x3
	// Position of FILTF field.
	LLWU_FILT1_FILTF_Pos = 0x7
	// Bit mask of FILTF field.
	LLWU_FILT1_FILTF_Msk = 0x80
	// Bit FILTF.
	LLWU_FILT1_FILTF = 0x80
	// Pin Filter 1 was not a wakeup source
	LLWU_FILT1_FILTF_0 = 0x0
	// Pin Filter 1 was a wakeup source
	LLWU_FILT1_FILTF_1 = 0x1

	// FILT2: LLWU Pin Filter 2 register
	// Position of FILTSEL field.
	LLWU_FILT2_FILTSEL_Pos = 0x0
	// Bit mask of FILTSEL field.
	LLWU_FILT2_FILTSEL_Msk = 0xf
	// Select LLWU_P0 for filter
	LLWU_FILT2_FILTSEL_0000 = 0x0
	// Select LLWU_P15 for filter
	LLWU_FILT2_FILTSEL_1111 = 0xf
	// Position of FILTE field.
	LLWU_FILT2_FILTE_Pos = 0x5
	// Bit mask of FILTE field.
	LLWU_FILT2_FILTE_Msk = 0x60
	// Filter disabled
	LLWU_FILT2_FILTE_00 = 0x0
	// Filter posedge detect enabled
	LLWU_FILT2_FILTE_01 = 0x1
	// Filter negedge detect enabled
	LLWU_FILT2_FILTE_10 = 0x2
	// Filter any edge detect enabled
	LLWU_FILT2_FILTE_11 = 0x3
	// Position of FILTF field.
	LLWU_FILT2_FILTF_Pos = 0x7
	// Bit mask of FILTF field.
	LLWU_FILT2_FILTF_Msk = 0x80
	// Bit FILTF.
	LLWU_FILT2_FILTF = 0x80
	// Pin Filter 2 was not a wakeup source
	LLWU_FILT2_FILTF_0 = 0x0
	// Pin Filter 2 was a wakeup source
	LLWU_FILT2_FILTF_1 = 0x1
)

// Constants for PMC: Power Management Controller
const (
	// LVDSC1: Low Voltage Detect Status And Control 1 register
	// Position of LVDV field.
	PMC_LVDSC1_LVDV_Pos = 0x0
	// Bit mask of LVDV field.
	PMC_LVDSC1_LVDV_Msk = 0x3
	// Low trip point selected (V LVD = V LVDL )
	PMC_LVDSC1_LVDV_00 = 0x0
	// High trip point selected (V LVD = V LVDH )
	PMC_LVDSC1_LVDV_01 = 0x1
	// Position of LVDRE field.
	PMC_LVDSC1_LVDRE_Pos = 0x4
	// Bit mask of LVDRE field.
	PMC_LVDSC1_LVDRE_Msk = 0x10
	// Bit LVDRE.
	PMC_LVDSC1_LVDRE = 0x10
	// LVDF does not generate hardware resets
	PMC_LVDSC1_LVDRE_0 = 0x0
	// Force an MCU reset when LVDF = 1
	PMC_LVDSC1_LVDRE_1 = 0x1
	// Position of LVDIE field.
	PMC_LVDSC1_LVDIE_Pos = 0x5
	// Bit mask of LVDIE field.
	PMC_LVDSC1_LVDIE_Msk = 0x20
	// Bit LVDIE.
	PMC_LVDSC1_LVDIE = 0x20
	// Hardware interrupt disabled (use polling)
	PMC_LVDSC1_LVDIE_0 = 0x0
	// Request a hardware interrupt when LVDF = 1
	PMC_LVDSC1_LVDIE_1 = 0x1
	// Position of LVDACK field.
	PMC_LVDSC1_LVDACK_Pos = 0x6
	// Bit mask of LVDACK field.
	PMC_LVDSC1_LVDACK_Msk = 0x40
	// Bit LVDACK.
	PMC_LVDSC1_LVDACK = 0x40
	// Position of LVDF field.
	PMC_LVDSC1_LVDF_Pos = 0x7
	// Bit mask of LVDF field.
	PMC_LVDSC1_LVDF_Msk = 0x80
	// Bit LVDF.
	PMC_LVDSC1_LVDF = 0x80
	// Low-voltage event not detected
	PMC_LVDSC1_LVDF_0 = 0x0
	// Low-voltage event detected
	PMC_LVDSC1_LVDF_1 = 0x1

	// LVDSC2: Low Voltage Detect Status And Control 2 register
	// Position of LVWV field.
	PMC_LVDSC2_LVWV_Pos = 0x0
	// Bit mask of LVWV field.
	PMC_LVDSC2_LVWV_Msk = 0x3
	// Low trip point selected (VLVW = VLVW1)
	PMC_LVDSC2_LVWV_00 = 0x0
	// Mid 1 trip point selected (VLVW = VLVW2)
	PMC_LVDSC2_LVWV_01 = 0x1
	// Mid 2 trip point selected (VLVW = VLVW3)
	PMC_LVDSC2_LVWV_10 = 0x2
	// High trip point selected (VLVW = VLVW4)
	PMC_LVDSC2_LVWV_11 = 0x3
	// Position of LVWIE field.
	PMC_LVDSC2_LVWIE_Pos = 0x5
	// Bit mask of LVWIE field.
	PMC_LVDSC2_LVWIE_Msk = 0x20
	// Bit LVWIE.
	PMC_LVDSC2_LVWIE = 0x20
	// Hardware interrupt disabled (use polling)
	PMC_LVDSC2_LVWIE_0 = 0x0
	// Request a hardware interrupt when LVWF = 1
	PMC_LVDSC2_LVWIE_1 = 0x1
	// Position of LVWACK field.
	PMC_LVDSC2_LVWACK_Pos = 0x6
	// Bit mask of LVWACK field.
	PMC_LVDSC2_LVWACK_Msk = 0x40
	// Bit LVWACK.
	PMC_LVDSC2_LVWACK = 0x40
	// Position of LVWF field.
	PMC_LVDSC2_LVWF_Pos = 0x7
	// Bit mask of LVWF field.
	PMC_LVDSC2_LVWF_Msk = 0x80
	// Bit LVWF.
	PMC_LVDSC2_LVWF = 0x80
	// Low-voltage warning event not detected
	PMC_LVDSC2_LVWF_0 = 0x0
	// Low-voltage warning event detected
	PMC_LVDSC2_LVWF_1 = 0x1

	// REGSC: Regulator Status And Control register
	// Position of BGBE field.
	PMC_REGSC_BGBE_Pos = 0x0
	// Bit mask of BGBE field.
	PMC_REGSC_BGBE_Msk = 0x1
	// Bit BGBE.
	PMC_REGSC_BGBE = 0x1
	// Bandgap buffer not enabled
	PMC_REGSC_BGBE_0 = 0x0
	// Bandgap buffer enabled
	PMC_REGSC_BGBE_1 = 0x1
	// Position of REGONS field.
	PMC_REGSC_REGONS_Pos = 0x2
	// Bit mask of REGONS field.
	PMC_REGSC_REGONS_Msk = 0x4
	// Bit REGONS.
	PMC_REGSC_REGONS = 0x4
	// Regulator is in stop regulation or in transition to/from it
	PMC_REGSC_REGONS_0 = 0x0
	// Regulator is in run regulation
	PMC_REGSC_REGONS_1 = 0x1
	// Position of ACKISO field.
	PMC_REGSC_ACKISO_Pos = 0x3
	// Bit mask of ACKISO field.
	PMC_REGSC_ACKISO_Msk = 0x8
	// Bit ACKISO.
	PMC_REGSC_ACKISO = 0x8
	// Peripherals and I/O pads are in normal run state.
	PMC_REGSC_ACKISO_0 = 0x0
	// Certain peripherals and I/O pads are in an isolated and latched state.
	PMC_REGSC_ACKISO_1 = 0x1
	// Position of BGEN field.
	PMC_REGSC_BGEN_Pos = 0x4
	// Bit mask of BGEN field.
	PMC_REGSC_BGEN_Msk = 0x10
	// Bit BGEN.
	PMC_REGSC_BGEN = 0x10
	// Bandgap voltage reference is disabled in VLPx , LLS , and VLLSx modes.
	PMC_REGSC_BGEN_0 = 0x0
	// Bandgap voltage reference is enabled in VLPx , LLS , and VLLSx modes.
	PMC_REGSC_BGEN_1 = 0x1
)

// Constants for SMC: System Mode Controller
const (
	// PMPROT: Power Mode Protection register
	// Position of AVLLS field.
	SMC_PMPROT_AVLLS_Pos = 0x1
	// Bit mask of AVLLS field.
	SMC_PMPROT_AVLLS_Msk = 0x2
	// Bit AVLLS.
	SMC_PMPROT_AVLLS = 0x2
	// Any VLLSx mode is not allowed
	SMC_PMPROT_AVLLS_0 = 0x0
	// Any VLLSx mode is allowed
	SMC_PMPROT_AVLLS_1 = 0x1
	// Position of ALLS field.
	SMC_PMPROT_ALLS_Pos = 0x3
	// Bit mask of ALLS field.
	SMC_PMPROT_ALLS_Msk = 0x8
	// Bit ALLS.
	SMC_PMPROT_ALLS = 0x8
	// LLS is not allowed
	SMC_PMPROT_ALLS_0 = 0x0
	// LLS is allowed
	SMC_PMPROT_ALLS_1 = 0x1
	// Position of AVLP field.
	SMC_PMPROT_AVLP_Pos = 0x5
	// Bit mask of AVLP field.
	SMC_PMPROT_AVLP_Msk = 0x20
	// Bit AVLP.
	SMC_PMPROT_AVLP = 0x20
	// VLPR, VLPW, and VLPS are not allowed.
	SMC_PMPROT_AVLP_0 = 0x0
	// VLPR, VLPW, and VLPS are allowed.
	SMC_PMPROT_AVLP_1 = 0x1

	// PMCTRL: Power Mode Control register
	// Position of STOPM field.
	SMC_PMCTRL_STOPM_Pos = 0x0
	// Bit mask of STOPM field.
	SMC_PMCTRL_STOPM_Msk = 0x7
	// Normal Stop (STOP)
	SMC_PMCTRL_STOPM_000 = 0x0
	// Very-Low-Power Stop (VLPS)
	SMC_PMCTRL_STOPM_010 = 0x2
	// Low-Leakage Stop (LLS)
	SMC_PMCTRL_STOPM_011 = 0x3
	// Very-Low-Leakage Stop (VLLSx)
	SMC_PMCTRL_STOPM_100 = 0x4
	// Reseved
	SMC_PMCTRL_STOPM_110 = 0x6
	// Position of STOPA field.
	SMC_PMCTRL_STOPA_Pos = 0x3
	// Bit mask of STOPA field.
	SMC_PMCTRL_STOPA_Msk = 0x8
	// Bit STOPA.
	SMC_PMCTRL_STOPA = 0x8
	// The previous stop mode entry was successsful.
	SMC_PMCTRL_STOPA_0 = 0x0
	// The previous stop mode entry was aborted.
	SMC_PMCTRL_STOPA_1 = 0x1
	// Position of RUNM field.
	SMC_PMCTRL_RUNM_Pos = 0x5
	// Bit mask of RUNM field.
	SMC_PMCTRL_RUNM_Msk = 0x60
	// Normal Run mode (RUN)
	SMC_PMCTRL_RUNM_00 = 0x0
	// Very-Low-Power Run mode (VLPR)
	SMC_PMCTRL_RUNM_10 = 0x2

	// STOPCTRL: Stop Control Register
	// Position of VLLSM field.
	SMC_STOPCTRL_VLLSM_Pos = 0x0
	// Bit mask of VLLSM field.
	SMC_STOPCTRL_VLLSM_Msk = 0x7
	// VLLS0
	SMC_STOPCTRL_VLLSM_000 = 0x0
	// VLLS1
	SMC_STOPCTRL_VLLSM_001 = 0x1
	// VLLS3
	SMC_STOPCTRL_VLLSM_011 = 0x3
	// Position of PORPO field.
	SMC_STOPCTRL_PORPO_Pos = 0x5
	// Bit mask of PORPO field.
	SMC_STOPCTRL_PORPO_Msk = 0x20
	// Bit PORPO.
	SMC_STOPCTRL_PORPO = 0x20
	// POR detect circuit is enabled in VLLS0
	SMC_STOPCTRL_PORPO_0 = 0x0
	// POR detect circuit is disabled in VLLS0
	SMC_STOPCTRL_PORPO_1 = 0x1
	// Position of PSTOPO field.
	SMC_STOPCTRL_PSTOPO_Pos = 0x6
	// Bit mask of PSTOPO field.
	SMC_STOPCTRL_PSTOPO_Msk = 0xc0
	// STOP - Normal Stop mode
	SMC_STOPCTRL_PSTOPO_00 = 0x0
	// PSTOP1 - Partial Stop with both system and bus clocks disabled
	SMC_STOPCTRL_PSTOPO_01 = 0x1
	// PSTOP2 - Partial Stop with system clock disabled and bus clock enabled
	SMC_STOPCTRL_PSTOPO_10 = 0x2

	// PMSTAT: Power Mode Status register
	// Position of PMSTAT field.
	SMC_PMSTAT_PMSTAT_Pos = 0x0
	// Bit mask of PMSTAT field.
	SMC_PMSTAT_PMSTAT_Msk = 0x7f
)

// Constants for RCM: Reset Control Module
const (
	// SRS0: System Reset Status Register 0
	// Position of WAKEUP field.
	RCM_SRS0_WAKEUP_Pos = 0x0
	// Bit mask of WAKEUP field.
	RCM_SRS0_WAKEUP_Msk = 0x1
	// Bit WAKEUP.
	RCM_SRS0_WAKEUP = 0x1
	// Reset not caused by LLWU module wakeup source
	RCM_SRS0_WAKEUP_0 = 0x0
	// Reset caused by LLWU module wakeup source
	RCM_SRS0_WAKEUP_1 = 0x1
	// Position of LVD field.
	RCM_SRS0_LVD_Pos = 0x1
	// Bit mask of LVD field.
	RCM_SRS0_LVD_Msk = 0x2
	// Bit LVD.
	RCM_SRS0_LVD = 0x2
	// Reset not caused by LVD trip or POR
	RCM_SRS0_LVD_0 = 0x0
	// Reset caused by LVD trip or POR
	RCM_SRS0_LVD_1 = 0x1
	// Position of LOC field.
	RCM_SRS0_LOC_Pos = 0x2
	// Bit mask of LOC field.
	RCM_SRS0_LOC_Msk = 0x4
	// Bit LOC.
	RCM_SRS0_LOC = 0x4
	// Reset not caused by a loss of external clock.
	RCM_SRS0_LOC_0 = 0x0
	// Reset caused by a loss of external clock.
	RCM_SRS0_LOC_1 = 0x1
	// Position of LOL field.
	RCM_SRS0_LOL_Pos = 0x3
	// Bit mask of LOL field.
	RCM_SRS0_LOL_Msk = 0x8
	// Bit LOL.
	RCM_SRS0_LOL = 0x8
	// Reset not caused by a loss of lock in the PLL
	RCM_SRS0_LOL_0 = 0x0
	// Reset caused by a loss of lock in the PLL
	RCM_SRS0_LOL_1 = 0x1
	// Position of WDOG field.
	RCM_SRS0_WDOG_Pos = 0x5
	// Bit mask of WDOG field.
	RCM_SRS0_WDOG_Msk = 0x20
	// Bit WDOG.
	RCM_SRS0_WDOG = 0x20
	// Reset not caused by watchdog timeout
	RCM_SRS0_WDOG_0 = 0x0
	// Reset caused by watchdog timeout
	RCM_SRS0_WDOG_1 = 0x1
	// Position of PIN field.
	RCM_SRS0_PIN_Pos = 0x6
	// Bit mask of PIN field.
	RCM_SRS0_PIN_Msk = 0x40
	// Bit PIN.
	RCM_SRS0_PIN = 0x40
	// Reset not caused by external reset pin
	RCM_SRS0_PIN_0 = 0x0
	// Reset caused by external reset pin
	RCM_SRS0_PIN_1 = 0x1
	// Position of POR field.
	RCM_SRS0_POR_Pos = 0x7
	// Bit mask of POR field.
	RCM_SRS0_POR_Msk = 0x80
	// Bit POR.
	RCM_SRS0_POR = 0x80
	// Reset not caused by POR
	RCM_SRS0_POR_0 = 0x0
	// Reset caused by POR
	RCM_SRS0_POR_1 = 0x1

	// SRS1: System Reset Status Register 1
	// Position of LOCKUP field.
	RCM_SRS1_LOCKUP_Pos = 0x1
	// Bit mask of LOCKUP field.
	RCM_SRS1_LOCKUP_Msk = 0x2
	// Bit LOCKUP.
	RCM_SRS1_LOCKUP = 0x2
	// Reset not caused by core LOCKUP event
	RCM_SRS1_LOCKUP_0 = 0x0
	// Reset caused by core LOCKUP event
	RCM_SRS1_LOCKUP_1 = 0x1
	// Position of SW field.
	RCM_SRS1_SW_Pos = 0x2
	// Bit mask of SW field.
	RCM_SRS1_SW_Msk = 0x4
	// Bit SW.
	RCM_SRS1_SW = 0x4
	// Reset not caused by software setting of SYSRESETREQ bit
	RCM_SRS1_SW_0 = 0x0
	// Reset caused by software setting of SYSRESETREQ bit
	RCM_SRS1_SW_1 = 0x1
	// Position of MDM_AP field.
	RCM_SRS1_MDM_AP_Pos = 0x3
	// Bit mask of MDM_AP field.
	RCM_SRS1_MDM_AP_Msk = 0x8
	// Bit MDM_AP.
	RCM_SRS1_MDM_AP = 0x8
	// Reset not caused by host debugger system setting of the System Reset Request bit
	RCM_SRS1_MDM_AP_0 = 0x0
	// Reset caused by host debugger system setting of the System Reset Request bit
	RCM_SRS1_MDM_AP_1 = 0x1
	// Position of SACKERR field.
	RCM_SRS1_SACKERR_Pos = 0x5
	// Bit mask of SACKERR field.
	RCM_SRS1_SACKERR_Msk = 0x20
	// Bit SACKERR.
	RCM_SRS1_SACKERR = 0x20
	// Reset not caused by peripheral failure to acknowledge attempt to enter stop mode
	RCM_SRS1_SACKERR_0 = 0x0
	// Reset caused by peripheral failure to acknowledge attempt to enter stop mode
	RCM_SRS1_SACKERR_1 = 0x1

	// RPFC: Reset Pin Filter Control register
	// Position of RSTFLTSRW field.
	RCM_RPFC_RSTFLTSRW_Pos = 0x0
	// Bit mask of RSTFLTSRW field.
	RCM_RPFC_RSTFLTSRW_Msk = 0x3
	// All filtering disabled
	RCM_RPFC_RSTFLTSRW_00 = 0x0
	// Bus clock filter enabled for normal operation
	RCM_RPFC_RSTFLTSRW_01 = 0x1
	// LPO clock filter enabled for normal operation
	RCM_RPFC_RSTFLTSRW_10 = 0x2
	// Position of RSTFLTSS field.
	RCM_RPFC_RSTFLTSS_Pos = 0x2
	// Bit mask of RSTFLTSS field.
	RCM_RPFC_RSTFLTSS_Msk = 0x4
	// Bit RSTFLTSS.
	RCM_RPFC_RSTFLTSS = 0x4
	// All filtering disabled
	RCM_RPFC_RSTFLTSS_0 = 0x0
	// LPO clock filter enabled
	RCM_RPFC_RSTFLTSS_1 = 0x1

	// RPFW: Reset Pin Filter Width register
	// Position of RSTFLTSEL field.
	RCM_RPFW_RSTFLTSEL_Pos = 0x0
	// Bit mask of RSTFLTSEL field.
	RCM_RPFW_RSTFLTSEL_Msk = 0x1f
	// Bus clock filter count is 1
	RCM_RPFW_RSTFLTSEL_00000 = 0x0
	// Bus clock filter count is 2
	RCM_RPFW_RSTFLTSEL_00001 = 0x1
	// Bus clock filter count is 3
	RCM_RPFW_RSTFLTSEL_00010 = 0x2
	// Bus clock filter count is 4
	RCM_RPFW_RSTFLTSEL_00011 = 0x3
	// Bus clock filter count is 5
	RCM_RPFW_RSTFLTSEL_00100 = 0x4
	// Bus clock filter count is 6
	RCM_RPFW_RSTFLTSEL_00101 = 0x5
	// Bus clock filter count is 7
	RCM_RPFW_RSTFLTSEL_00110 = 0x6
	// Bus clock filter count is 8
	RCM_RPFW_RSTFLTSEL_00111 = 0x7
	// Bus clock filter count is 9
	RCM_RPFW_RSTFLTSEL_01000 = 0x8
	// Bus clock filter count is 10
	RCM_RPFW_RSTFLTSEL_01001 = 0x9
	// Bus clock filter count is 11
	RCM_RPFW_RSTFLTSEL_01010 = 0xa
	// Bus clock filter count is 12
	RCM_RPFW_RSTFLTSEL_01011 = 0xb
	// Bus clock filter count is 13
	RCM_RPFW_RSTFLTSEL_01100 = 0xc
	// Bus clock filter count is 14
	RCM_RPFW_RSTFLTSEL_01101 = 0xd
	// Bus clock filter count is 15
	RCM_RPFW_RSTFLTSEL_01110 = 0xe
	// Bus clock filter count is 16
	RCM_RPFW_RSTFLTSEL_01111 = 0xf
	// Bus clock filter count is 17
	RCM_RPFW_RSTFLTSEL_10000 = 0x10
	// Bus clock filter count is 18
	RCM_RPFW_RSTFLTSEL_10001 = 0x11
	// Bus clock filter count is 19
	RCM_RPFW_RSTFLTSEL_10010 = 0x12
	// Bus clock filter count is 20
	RCM_RPFW_RSTFLTSEL_10011 = 0x13
	// Bus clock filter count is 21
	RCM_RPFW_RSTFLTSEL_10100 = 0x14
	// Bus clock filter count is 22
	RCM_RPFW_RSTFLTSEL_10101 = 0x15
	// Bus clock filter count is 23
	RCM_RPFW_RSTFLTSEL_10110 = 0x16
	// Bus clock filter count is 24
	RCM_RPFW_RSTFLTSEL_10111 = 0x17
	// Bus clock filter count is 25
	RCM_RPFW_RSTFLTSEL_11000 = 0x18
	// Bus clock filter count is 26
	RCM_RPFW_RSTFLTSEL_11001 = 0x19
	// Bus clock filter count is 27
	RCM_RPFW_RSTFLTSEL_11010 = 0x1a
	// Bus clock filter count is 28
	RCM_RPFW_RSTFLTSEL_11011 = 0x1b
	// Bus clock filter count is 29
	RCM_RPFW_RSTFLTSEL_11100 = 0x1c
	// Bus clock filter count is 30
	RCM_RPFW_RSTFLTSEL_11101 = 0x1d
	// Bus clock filter count is 31
	RCM_RPFW_RSTFLTSEL_11110 = 0x1e
	// Bus clock filter count is 32
	RCM_RPFW_RSTFLTSEL_11111 = 0x1f
)

// Constants for GPIOA: General Purpose Input/Output
const (
	// PDOR: Port Data Output Register
	// Position of PDO field.
	GPIO_PDOR_PDO_Pos = 0x0
	// Bit mask of PDO field.
	GPIO_PDOR_PDO_Msk = 0xffffffff
	// Logic level 0 is driven on pin, provided pin is configured for general-purpose output.
	GPIO_PDOR_PDO_0 = 0x0
	// Logic level 1 is driven on pin, provided pin is configured for general-purpose output.
	GPIO_PDOR_PDO_1 = 0x1

	// PSOR: Port Set Output Register
	// Position of PTSO field.
	GPIO_PSOR_PTSO_Pos = 0x0
	// Bit mask of PTSO field.
	GPIO_PSOR_PTSO_Msk = 0xffffffff
	// Corresponding bit in PDORn does not change.
	GPIO_PSOR_PTSO_0 = 0x0
	// Corresponding bit in PDORn is set to logic 1.
	GPIO_PSOR_PTSO_1 = 0x1

	// PCOR: Port Clear Output Register
	// Position of PTCO field.
	GPIO_PCOR_PTCO_Pos = 0x0
	// Bit mask of PTCO field.
	GPIO_PCOR_PTCO_Msk = 0xffffffff
	// Corresponding bit in PDORn does not change.
	GPIO_PCOR_PTCO_0 = 0x0
	// Corresponding bit in PDORn is cleared to logic 0.
	GPIO_PCOR_PTCO_1 = 0x1

	// PTOR: Port Toggle Output Register
	// Position of PTTO field.
	GPIO_PTOR_PTTO_Pos = 0x0
	// Bit mask of PTTO field.
	GPIO_PTOR_PTTO_Msk = 0xffffffff
	// Corresponding bit in PDORn does not change.
	GPIO_PTOR_PTTO_0 = 0x0
	// Corresponding bit in PDORn is set to the inverse of its existing logic state.
	GPIO_PTOR_PTTO_1 = 0x1

	// PDIR: Port Data Input Register
	// Position of PDI field.
	GPIO_PDIR_PDI_Pos = 0x0
	// Bit mask of PDI field.
	GPIO_PDIR_PDI_Msk = 0xffffffff
	// Pin logic level is logic 0, or is not configured for use by digital function.
	GPIO_PDIR_PDI_0 = 0x0
	// Pin logic level is logic 1.
	GPIO_PDIR_PDI_1 = 0x1

	// PDDR: Port Data Direction Register
	// Position of PDD field.
	GPIO_PDDR_PDD_Pos = 0x0
	// Bit mask of PDD field.
	GPIO_PDDR_PDD_Msk = 0xffffffff
	// Pin is configured as general-purpose input, for the GPIO function.
	GPIO_PDDR_PDD_0 = 0x0
	// Pin is configured as general-purpose output, for the GPIO function.
	GPIO_PDDR_PDD_1 = 0x1
)

// Constants for SystemControl: System Control Block
const (
	// CPUID: CPUID Base Register
	// Position of REVISION field.
	SystemControl_CPUID_REVISION_Pos = 0x0
	// Bit mask of REVISION field.
	SystemControl_CPUID_REVISION_Msk = 0xf
	// Position of PARTNO field.
	SystemControl_CPUID_PARTNO_Pos = 0x4
	// Bit mask of PARTNO field.
	SystemControl_CPUID_PARTNO_Msk = 0xfff0
	// Position of ARCHITECTURE field.
	SystemControl_CPUID_ARCHITECTURE_Pos = 0x10
	// Bit mask of ARCHITECTURE field.
	SystemControl_CPUID_ARCHITECTURE_Msk = 0xf0000
	// Position of VARIANT field.
	SystemControl_CPUID_VARIANT_Pos = 0x14
	// Bit mask of VARIANT field.
	SystemControl_CPUID_VARIANT_Msk = 0xf00000
	// Position of IMPLEMENTER field.
	SystemControl_CPUID_IMPLEMENTER_Pos = 0x18
	// Bit mask of IMPLEMENTER field.
	SystemControl_CPUID_IMPLEMENTER_Msk = 0xff000000

	// ICSR: Interrupt Control and State Register
	// Position of VECTPENDING field.
	SystemControl_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SystemControl_ICSR_VECTPENDING_Msk = 0x3f000
	// Position of PENDSTCLR field.
	SystemControl_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SystemControl_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SystemControl_ICSR_PENDSTCLR = 0x2000000
	// no effect
	SystemControl_ICSR_PENDSTCLR_0 = 0x0
	// removes the pending state from the SysTick exception
	SystemControl_ICSR_PENDSTCLR_1 = 0x1
	// Position of PENDSTSET field.
	SystemControl_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SystemControl_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SystemControl_ICSR_PENDSTSET = 0x4000000
	// write: no effect; read: SysTick exception is not pending
	SystemControl_ICSR_PENDSTSET_0 = 0x0
	// write: changes SysTick exception state to pending; read: SysTick exception is pending
	SystemControl_ICSR_PENDSTSET_1 = 0x1
	// Position of PENDSVCLR field.
	SystemControl_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SystemControl_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SystemControl_ICSR_PENDSVCLR = 0x8000000
	// no effect
	SystemControl_ICSR_PENDSVCLR_0 = 0x0
	// removes the pending state from the PendSV exception
	SystemControl_ICSR_PENDSVCLR_1 = 0x1
	// Position of PENDSVSET field.
	SystemControl_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SystemControl_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SystemControl_ICSR_PENDSVSET = 0x10000000
	// write: no effect; read: PendSV exception is not pending
	SystemControl_ICSR_PENDSVSET_0 = 0x0
	// write: changes PendSV exception state to pending; read: PendSV exception is pending
	SystemControl_ICSR_PENDSVSET_1 = 0x1
	// Position of NMIPENDSET field.
	SystemControl_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SystemControl_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SystemControl_ICSR_NMIPENDSET = 0x80000000
	// write: no effect; read: NMI exception is not pending
	SystemControl_ICSR_NMIPENDSET_0 = 0x0
	// write: changes NMI exception state to pending; read: NMI exception is pending
	SystemControl_ICSR_NMIPENDSET_1 = 0x1

	// VTOR: Vector Table Offset Register
	// Position of TBLOFF field.
	SystemControl_VTOR_TBLOFF_Pos = 0x7
	// Bit mask of TBLOFF field.
	SystemControl_VTOR_TBLOFF_Msk = 0xffffff80

	// AIRCR: Application Interrupt and Reset Control Register
	// Position of VECTCLRACTIVE field.
	SystemControl_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SystemControl_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SystemControl_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SystemControl_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SystemControl_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SystemControl_AIRCR_SYSRESETREQ = 0x4
	// no system reset request
	SystemControl_AIRCR_SYSRESETREQ_0 = 0x0
	// asserts a signal to the outer system that requests a reset
	SystemControl_AIRCR_SYSRESETREQ_1 = 0x1
	// Position of ENDIANNESS field.
	SystemControl_AIRCR_ENDIANNESS_Pos = 0xf
	// Bit mask of ENDIANNESS field.
	SystemControl_AIRCR_ENDIANNESS_Msk = 0x8000
	// Bit ENDIANNESS.
	SystemControl_AIRCR_ENDIANNESS = 0x8000
	// Little-endian
	SystemControl_AIRCR_ENDIANNESS_0 = 0x0
	// Big-endian
	SystemControl_AIRCR_ENDIANNESS_1 = 0x1
	// Position of VECTKEY field.
	SystemControl_AIRCR_VECTKEY_Pos = 0x10
	// Bit mask of VECTKEY field.
	SystemControl_AIRCR_VECTKEY_Msk = 0xffff0000

	// SCR: System Control Register
	// Position of SLEEPONEXIT field.
	SystemControl_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SystemControl_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SystemControl_SCR_SLEEPONEXIT = 0x2
	// do not sleep when returning to Thread mode
	SystemControl_SCR_SLEEPONEXIT_0 = 0x0
	// enter sleep, or deep sleep, on return from an ISR
	SystemControl_SCR_SLEEPONEXIT_1 = 0x1
	// Position of SLEEPDEEP field.
	SystemControl_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SystemControl_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SystemControl_SCR_SLEEPDEEP = 0x4
	// sleep
	SystemControl_SCR_SLEEPDEEP_0 = 0x0
	// deep sleep
	SystemControl_SCR_SLEEPDEEP_1 = 0x1
	// Position of SEVONPEND field.
	SystemControl_SCR_SEVONPEND_Pos = 0x4
	// Bit mask of SEVONPEND field.
	SystemControl_SCR_SEVONPEND_Msk = 0x10
	// Bit SEVONPEND.
	SystemControl_SCR_SEVONPEND = 0x10
	// only enabled interrupts or events can wakeup the processor, disabled interrupts are excluded
	SystemControl_SCR_SEVONPEND_0 = 0x0
	// enabled events and all interrupts, including disabled interrupts, can wakeup the processor
	SystemControl_SCR_SEVONPEND_1 = 0x1

	// CCR: Configuration and Control Register
	// Position of UNALIGN_TRP field.
	SystemControl_CCR_UNALIGN_TRP_Pos = 0x3
	// Bit mask of UNALIGN_TRP field.
	SystemControl_CCR_UNALIGN_TRP_Msk = 0x8
	// Bit UNALIGN_TRP.
	SystemControl_CCR_UNALIGN_TRP = 0x8
	// Position of STKALIGN field.
	SystemControl_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SystemControl_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SystemControl_CCR_STKALIGN = 0x200

	// SHPR2: System Handler Priority Register 2
	// Position of PRI_11 field.
	SystemControl_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SystemControl_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System Handler Priority Register 3
	// Position of PRI_14 field.
	SystemControl_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SystemControl_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SystemControl_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SystemControl_SHPR3_PRI_15_Msk = 0xff000000

	// SHCSR: System Handler Control and State Register
	// Position of SVCALLPENDED field.
	SystemControl_SHCSR_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SystemControl_SHCSR_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SystemControl_SHCSR_SVCALLPENDED = 0x8000
	// exception is not pending
	SystemControl_SHCSR_SVCALLPENDED_0 = 0x0
	// exception is pending
	SystemControl_SHCSR_SVCALLPENDED_1 = 0x1

	// DFSR: Debug Fault Status Register
	// Position of HALTED field.
	SystemControl_DFSR_HALTED_Pos = 0x0
	// Bit mask of HALTED field.
	SystemControl_DFSR_HALTED_Msk = 0x1
	// Bit HALTED.
	SystemControl_DFSR_HALTED = 0x1
	// No active halt request debug event
	SystemControl_DFSR_HALTED_0 = 0x0
	// Halt request debug event active
	SystemControl_DFSR_HALTED_1 = 0x1
	// Position of BKPT field.
	SystemControl_DFSR_BKPT_Pos = 0x1
	// Bit mask of BKPT field.
	SystemControl_DFSR_BKPT_Msk = 0x2
	// Bit BKPT.
	SystemControl_DFSR_BKPT = 0x2
	// No current breakpoint debug event
	SystemControl_DFSR_BKPT_0 = 0x0
	// At least one current breakpoint debug event
	SystemControl_DFSR_BKPT_1 = 0x1
	// Position of DWTTRAP field.
	SystemControl_DFSR_DWTTRAP_Pos = 0x2
	// Bit mask of DWTTRAP field.
	SystemControl_DFSR_DWTTRAP_Msk = 0x4
	// Bit DWTTRAP.
	SystemControl_DFSR_DWTTRAP = 0x4
	// No current debug events generated by the DWT
	SystemControl_DFSR_DWTTRAP_0 = 0x0
	// At least one current debug event generated by the DWT
	SystemControl_DFSR_DWTTRAP_1 = 0x1
	// Position of VCATCH field.
	SystemControl_DFSR_VCATCH_Pos = 0x3
	// Bit mask of VCATCH field.
	SystemControl_DFSR_VCATCH_Msk = 0x8
	// Bit VCATCH.
	SystemControl_DFSR_VCATCH = 0x8
	// No Vector catch triggered
	SystemControl_DFSR_VCATCH_0 = 0x0
	// Vector catch triggered
	SystemControl_DFSR_VCATCH_1 = 0x1
	// Position of EXTERNAL field.
	SystemControl_DFSR_EXTERNAL_Pos = 0x4
	// Bit mask of EXTERNAL field.
	SystemControl_DFSR_EXTERNAL_Msk = 0x10
	// Bit EXTERNAL.
	SystemControl_DFSR_EXTERNAL = 0x10
	// No EDBGRQ debug event
	SystemControl_DFSR_EXTERNAL_0 = 0x0
	// EDBGRQ debug event
	SystemControl_DFSR_EXTERNAL_1 = 0x1
)

// Constants for SysTick: System timer
const (
	// CSR: SysTick Control and Status Register
	// Position of ENABLE field.
	SysTick_CSR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SysTick_CSR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	SysTick_CSR_ENABLE = 0x1
	// counter disabled
	SysTick_CSR_ENABLE_0 = 0x0
	// counter enabled
	SysTick_CSR_ENABLE_1 = 0x1
	// Position of TICKINT field.
	SysTick_CSR_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	SysTick_CSR_TICKINT_Msk = 0x2
	// Bit TICKINT.
	SysTick_CSR_TICKINT = 0x2
	// counting down to 0 does not assert the SysTick exception request
	SysTick_CSR_TICKINT_0 = 0x0
	// counting down to 0 asserts the SysTick exception request
	SysTick_CSR_TICKINT_1 = 0x1
	// Position of CLKSOURCE field.
	SysTick_CSR_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	SysTick_CSR_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	SysTick_CSR_CLKSOURCE = 0x4
	// external clock
	SysTick_CSR_CLKSOURCE_0 = 0x0
	// processor clock
	SysTick_CSR_CLKSOURCE_1 = 0x1
	// Position of COUNTFLAG field.
	SysTick_CSR_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	SysTick_CSR_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	SysTick_CSR_COUNTFLAG = 0x10000

	// RVR: SysTick Reload Value Register
	// Position of RELOAD field.
	SysTick_RVR_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	SysTick_RVR_RELOAD_Msk = 0xffffff

	// CVR: SysTick Current Value Register
	// Position of CURRENT field.
	SysTick_CVR_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	SysTick_CVR_CURRENT_Msk = 0xffffff

	// CALIB: SysTick Calibration Value Register
	// Position of TENMS field.
	SysTick_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	SysTick_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	SysTick_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	SysTick_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	SysTick_CALIB_SKEW = 0x40000000
	// 10ms calibration value is exact
	SysTick_CALIB_SKEW_0 = 0x0
	// 10ms calibration value is inexact, because of the clock frequency
	SysTick_CALIB_SKEW_1 = 0x1
	// Position of NOREF field.
	SysTick_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	SysTick_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	SysTick_CALIB_NOREF = 0x80000000
	// The reference clock is provided
	SysTick_CALIB_NOREF_0 = 0x0
	// The reference clock is not provided
	SysTick_CALIB_NOREF_1 = 0x1
)

// Constants for NVIC: Nested Vectored Interrupt Controller
const (
	// NVIC_ISER: Interrupt Set Enable Register
	// Position of SETENA0 field.
	NVIC_NVIC_ISER_SETENA0_Pos = 0x0
	// Bit mask of SETENA0 field.
	NVIC_NVIC_ISER_SETENA0_Msk = 0x1
	// Bit SETENA0.
	NVIC_NVIC_ISER_SETENA0 = 0x1
	// write: no effect; read: DMA channel 0 transfer complete and error interrupt disabled
	NVIC_NVIC_ISER_SETENA0_0 = 0x0
	// write: enable DMA channel 0 transfer complete and error interrupt; read: DMA channel 0 transfer complete and error interrupt enabled
	NVIC_NVIC_ISER_SETENA0_1 = 0x1
	// Position of SETENA1 field.
	NVIC_NVIC_ISER_SETENA1_Pos = 0x1
	// Bit mask of SETENA1 field.
	NVIC_NVIC_ISER_SETENA1_Msk = 0x2
	// Bit SETENA1.
	NVIC_NVIC_ISER_SETENA1 = 0x2
	// write: no effect; read: DMA channel 1 transfer complete and error interrupt disabled
	NVIC_NVIC_ISER_SETENA1_0 = 0x0
	// write: enable DMA channel 1 transfer complete and error interrupt; read: DMA channel 1 transfer complete and error interrupt enabled
	NVIC_NVIC_ISER_SETENA1_1 = 0x1
	// Position of SETENA2 field.
	NVIC_NVIC_ISER_SETENA2_Pos = 0x2
	// Bit mask of SETENA2 field.
	NVIC_NVIC_ISER_SETENA2_Msk = 0x4
	// Bit SETENA2.
	NVIC_NVIC_ISER_SETENA2 = 0x4
	// write: no effect; read: DMA channel 2 transfer complete and error interrupt disabled
	NVIC_NVIC_ISER_SETENA2_0 = 0x0
	// write: enable DMA channel 2 transfer complete and error interrupt; read: DMA channel 2 transfer complete and error interrupt enabled
	NVIC_NVIC_ISER_SETENA2_1 = 0x1
	// Position of SETENA3 field.
	NVIC_NVIC_ISER_SETENA3_Pos = 0x3
	// Bit mask of SETENA3 field.
	NVIC_NVIC_ISER_SETENA3_Msk = 0x8
	// Bit SETENA3.
	NVIC_NVIC_ISER_SETENA3 = 0x8
	// write: no effect; read: DMA channel 3 transfer complete and error interrupt disabled
	NVIC_NVIC_ISER_SETENA3_0 = 0x0
	// write: enable DMA channel 3 transfer complete and error interrupt; read: DMA channel 3 transfer complete and error interrupt enabled
	NVIC_NVIC_ISER_SETENA3_1 = 0x1
	// Position of SETENA4 field.
	NVIC_NVIC_ISER_SETENA4_Pos = 0x4
	// Bit mask of SETENA4 field.
	NVIC_NVIC_ISER_SETENA4_Msk = 0x10
	// Bit SETENA4.
	NVIC_NVIC_ISER_SETENA4 = 0x10
	// write: no effect; read: Reserved iv 20 interrupt disabled
	NVIC_NVIC_ISER_SETENA4_0 = 0x0
	// write: enable Reserved iv 20 interrupt; read: Reserved iv 20 interrupt enabled
	NVIC_NVIC_ISER_SETENA4_1 = 0x1
	// Position of SETENA5 field.
	NVIC_NVIC_ISER_SETENA5_Pos = 0x5
	// Bit mask of SETENA5 field.
	NVIC_NVIC_ISER_SETENA5_Msk = 0x20
	// Bit SETENA5.
	NVIC_NVIC_ISER_SETENA5 = 0x20
	// write: no effect; read: FTFA command complete and read collision interrupt disabled
	NVIC_NVIC_ISER_SETENA5_0 = 0x0
	// write: enable FTFA command complete and read collision interrupt; read: FTFA command complete and read collision interrupt enabled
	NVIC_NVIC_ISER_SETENA5_1 = 0x1
	// Position of SETENA6 field.
	NVIC_NVIC_ISER_SETENA6_Pos = 0x6
	// Bit mask of SETENA6 field.
	NVIC_NVIC_ISER_SETENA6_Msk = 0x40
	// Bit SETENA6.
	NVIC_NVIC_ISER_SETENA6 = 0x40
	// write: no effect; read: low-voltage detect and low-voltage warning interrupt disabled
	NVIC_NVIC_ISER_SETENA6_0 = 0x0
	// write: enable low-voltage detect and low-voltage warning interrupt; read: low-voltage detect and low-voltage warning interrupt enabled
	NVIC_NVIC_ISER_SETENA6_1 = 0x1
	// Position of SETENA7 field.
	NVIC_NVIC_ISER_SETENA7_Pos = 0x7
	// Bit mask of SETENA7 field.
	NVIC_NVIC_ISER_SETENA7_Msk = 0x80
	// Bit SETENA7.
	NVIC_NVIC_ISER_SETENA7 = 0x80
	// write: no effect; read: low leakage wakeup interrupt disabled
	NVIC_NVIC_ISER_SETENA7_0 = 0x0
	// write: enable low leakage wakeup interrupt; read: low leakage wakeup interrupt enabled
	NVIC_NVIC_ISER_SETENA7_1 = 0x1
	// Position of SETENA8 field.
	NVIC_NVIC_ISER_SETENA8_Pos = 0x8
	// Bit mask of SETENA8 field.
	NVIC_NVIC_ISER_SETENA8_Msk = 0x100
	// Bit SETENA8.
	NVIC_NVIC_ISER_SETENA8 = 0x100
	// write: no effect; read: inter-integrated circuit 0 interrupt disabled
	NVIC_NVIC_ISER_SETENA8_0 = 0x0
	// write: enable inter-integrated circuit 0 interrupt; read: inter-integrated circuit 0 interrupt enabled
	NVIC_NVIC_ISER_SETENA8_1 = 0x1
	// Position of SETENA9 field.
	NVIC_NVIC_ISER_SETENA9_Pos = 0x9
	// Bit mask of SETENA9 field.
	NVIC_NVIC_ISER_SETENA9_Msk = 0x200
	// Bit SETENA9.
	NVIC_NVIC_ISER_SETENA9 = 0x200
	// write: no effect; read: inter-integrated circuit 1 interrupt disabled
	NVIC_NVIC_ISER_SETENA9_0 = 0x0
	// write: enable inter-integrated circuit 1 interrupt; read: inter-integrated circuit 1 interrupt enabled
	NVIC_NVIC_ISER_SETENA9_1 = 0x1
	// Position of SETENA10 field.
	NVIC_NVIC_ISER_SETENA10_Pos = 0xa
	// Bit mask of SETENA10 field.
	NVIC_NVIC_ISER_SETENA10_Msk = 0x400
	// Bit SETENA10.
	NVIC_NVIC_ISER_SETENA10 = 0x400
	// write: no effect; read: serial peripheral interface 0 interrupt disabled
	NVIC_NVIC_ISER_SETENA10_0 = 0x0
	// write: enable serial peripheral interface 0 interrupt; read: serial peripheral interface 0 interrupt enabled
	NVIC_NVIC_ISER_SETENA10_1 = 0x1
	// Position of SETENA11 field.
	NVIC_NVIC_ISER_SETENA11_Pos = 0xb
	// Bit mask of SETENA11 field.
	NVIC_NVIC_ISER_SETENA11_Msk = 0x800
	// Bit SETENA11.
	NVIC_NVIC_ISER_SETENA11 = 0x800
	// write: no effect; read: serial peripheral interface 1 interrupt disabled
	NVIC_NVIC_ISER_SETENA11_0 = 0x0
	// write: enable serial peripheral interface 1 interrupt; read: serial peripheral interface 1 interrupt enabled
	NVIC_NVIC_ISER_SETENA11_1 = 0x1
	// Position of SETENA12 field.
	NVIC_NVIC_ISER_SETENA12_Pos = 0xc
	// Bit mask of SETENA12 field.
	NVIC_NVIC_ISER_SETENA12_Msk = 0x1000
	// Bit SETENA12.
	NVIC_NVIC_ISER_SETENA12 = 0x1000
	// write: no effect; read: UART0 status and error interrupt disabled
	NVIC_NVIC_ISER_SETENA12_0 = 0x0
	// write: enable UART0 status and error interrupt; read: UART0 status and error interrupt enabled
	NVIC_NVIC_ISER_SETENA12_1 = 0x1
	// Position of SETENA13 field.
	NVIC_NVIC_ISER_SETENA13_Pos = 0xd
	// Bit mask of SETENA13 field.
	NVIC_NVIC_ISER_SETENA13_Msk = 0x2000
	// Bit SETENA13.
	NVIC_NVIC_ISER_SETENA13 = 0x2000
	// write: no effect; read: UART1 status and error interrupt disabled
	NVIC_NVIC_ISER_SETENA13_0 = 0x0
	// write: enable UART1 status and error interrupt; read: UART1 status and error interrupt enabled
	NVIC_NVIC_ISER_SETENA13_1 = 0x1
	// Position of SETENA14 field.
	NVIC_NVIC_ISER_SETENA14_Pos = 0xe
	// Bit mask of SETENA14 field.
	NVIC_NVIC_ISER_SETENA14_Msk = 0x4000
	// Bit SETENA14.
	NVIC_NVIC_ISER_SETENA14 = 0x4000
	// write: no effect; read: UART2 status and error interrupt disabled
	NVIC_NVIC_ISER_SETENA14_0 = 0x0
	// write: enable UART2 status and error interrupt; read: UART2 status and error interrupt enabled
	NVIC_NVIC_ISER_SETENA14_1 = 0x1
	// Position of SETENA15 field.
	NVIC_NVIC_ISER_SETENA15_Pos = 0xf
	// Bit mask of SETENA15 field.
	NVIC_NVIC_ISER_SETENA15_Msk = 0x8000
	// Bit SETENA15.
	NVIC_NVIC_ISER_SETENA15 = 0x8000
	// write: no effect; read: Analog-to-digital converter 0 interrupt disabled
	NVIC_NVIC_ISER_SETENA15_0 = 0x0
	// write: enable Analog-to-digital converter 0 interrupt; read: Analog-to-digital converter 0 interrupt enabled
	NVIC_NVIC_ISER_SETENA15_1 = 0x1
	// Position of SETENA16 field.
	NVIC_NVIC_ISER_SETENA16_Pos = 0x10
	// Bit mask of SETENA16 field.
	NVIC_NVIC_ISER_SETENA16_Msk = 0x10000
	// Bit SETENA16.
	NVIC_NVIC_ISER_SETENA16 = 0x10000
	// write: no effect; read: Comparator 0 interrupt disabled
	NVIC_NVIC_ISER_SETENA16_0 = 0x0
	// write: enable Comparator 0 interrupt; read: Comparator 0 interrupt enabled
	NVIC_NVIC_ISER_SETENA16_1 = 0x1
	// Position of SETENA17 field.
	NVIC_NVIC_ISER_SETENA17_Pos = 0x11
	// Bit mask of SETENA17 field.
	NVIC_NVIC_ISER_SETENA17_Msk = 0x20000
	// Bit SETENA17.
	NVIC_NVIC_ISER_SETENA17 = 0x20000
	// write: no effect; read: Timer PWM module 0 interrupt disabled
	NVIC_NVIC_ISER_SETENA17_0 = 0x0
	// write: enable Timer PWM module 0 interrupt; read: Timer PWM module 0 interrupt enabled
	NVIC_NVIC_ISER_SETENA17_1 = 0x1
	// Position of SETENA18 field.
	NVIC_NVIC_ISER_SETENA18_Pos = 0x12
	// Bit mask of SETENA18 field.
	NVIC_NVIC_ISER_SETENA18_Msk = 0x40000
	// Bit SETENA18.
	NVIC_NVIC_ISER_SETENA18 = 0x40000
	// write: no effect; read: Timer PWM module 1 interrupt disabled
	NVIC_NVIC_ISER_SETENA18_0 = 0x0
	// write: enable Timer PWM module 1 interrupt; read: Timer PWM module 1 interrupt enabled
	NVIC_NVIC_ISER_SETENA18_1 = 0x1
	// Position of SETENA19 field.
	NVIC_NVIC_ISER_SETENA19_Pos = 0x13
	// Bit mask of SETENA19 field.
	NVIC_NVIC_ISER_SETENA19_Msk = 0x80000
	// Bit SETENA19.
	NVIC_NVIC_ISER_SETENA19 = 0x80000
	// write: no effect; read: Timer PWM module 2 interrupt disabled
	NVIC_NVIC_ISER_SETENA19_0 = 0x0
	// write: enable Timer PWM module 2 interrupt; read: Timer PWM module 2 interrupt enabled
	NVIC_NVIC_ISER_SETENA19_1 = 0x1
	// Position of SETENA20 field.
	NVIC_NVIC_ISER_SETENA20_Pos = 0x14
	// Bit mask of SETENA20 field.
	NVIC_NVIC_ISER_SETENA20_Msk = 0x100000
	// Bit SETENA20.
	NVIC_NVIC_ISER_SETENA20 = 0x100000
	// write: no effect; read: real time clock alarm interrupt disabled
	NVIC_NVIC_ISER_SETENA20_0 = 0x0
	// write: enable real time clock alarm interrupt; read: real time clock alarm interrupt enabled
	NVIC_NVIC_ISER_SETENA20_1 = 0x1
	// Position of SETENA21 field.
	NVIC_NVIC_ISER_SETENA21_Pos = 0x15
	// Bit mask of SETENA21 field.
	NVIC_NVIC_ISER_SETENA21_Msk = 0x200000
	// Bit SETENA21.
	NVIC_NVIC_ISER_SETENA21 = 0x200000
	// write: no effect; read: real time clock seconds interrupt disabled
	NVIC_NVIC_ISER_SETENA21_0 = 0x0
	// write: enable real time clock seconds interrupt; read: real time clock seconds interrupt enabled
	NVIC_NVIC_ISER_SETENA21_1 = 0x1
	// Position of SETENA22 field.
	NVIC_NVIC_ISER_SETENA22_Pos = 0x16
	// Bit mask of SETENA22 field.
	NVIC_NVIC_ISER_SETENA22_Msk = 0x400000
	// Bit SETENA22.
	NVIC_NVIC_ISER_SETENA22 = 0x400000
	// write: no effect; read: periodic interrupt timer all channels interrupt disabled
	NVIC_NVIC_ISER_SETENA22_0 = 0x0
	// write: enable periodic interrupt timer all channels interrupt; read: periodic interrupt timer all channels interrupt enabled
	NVIC_NVIC_ISER_SETENA22_1 = 0x1
	// Position of SETENA23 field.
	NVIC_NVIC_ISER_SETENA23_Pos = 0x17
	// Bit mask of SETENA23 field.
	NVIC_NVIC_ISER_SETENA23_Msk = 0x800000
	// Bit SETENA23.
	NVIC_NVIC_ISER_SETENA23 = 0x800000
	// write: no effect; read: integrated interchip sound 0 interrupt disabled
	NVIC_NVIC_ISER_SETENA23_0 = 0x0
	// write: enable integrated interchip sound 0 interrupt; read: integrated interchip sound 0 interrupt enabled
	NVIC_NVIC_ISER_SETENA23_1 = 0x1
	// Position of SETENA24 field.
	NVIC_NVIC_ISER_SETENA24_Pos = 0x18
	// Bit mask of SETENA24 field.
	NVIC_NVIC_ISER_SETENA24_Msk = 0x1000000
	// Bit SETENA24.
	NVIC_NVIC_ISER_SETENA24 = 0x1000000
	// write: no effect; read: universal serial bus on the go interrupt disabled
	NVIC_NVIC_ISER_SETENA24_0 = 0x0
	// write: enable universal serial bus on the go interrupt; read: universal serial bus on the go interrupt enabled
	NVIC_NVIC_ISER_SETENA24_1 = 0x1
	// Position of SETENA25 field.
	NVIC_NVIC_ISER_SETENA25_Pos = 0x19
	// Bit mask of SETENA25 field.
	NVIC_NVIC_ISER_SETENA25_Msk = 0x2000000
	// Bit SETENA25.
	NVIC_NVIC_ISER_SETENA25 = 0x2000000
	// write: no effect; read: digital-to-analog converter 0 interrupt disabled
	NVIC_NVIC_ISER_SETENA25_0 = 0x0
	// write: enable digital-to-analog converter 0 interrupt; read: digital-to-analog converter 0 interrupt enabled
	NVIC_NVIC_ISER_SETENA25_1 = 0x1
	// Position of SETENA26 field.
	NVIC_NVIC_ISER_SETENA26_Pos = 0x1a
	// Bit mask of SETENA26 field.
	NVIC_NVIC_ISER_SETENA26_Msk = 0x4000000
	// Bit SETENA26.
	NVIC_NVIC_ISER_SETENA26 = 0x4000000
	// write: no effect; read: touch sensing input interrupt disabled
	NVIC_NVIC_ISER_SETENA26_0 = 0x0
	// write: enable touch sensing input interrupt; read: touch sensing input interrupt enabled
	NVIC_NVIC_ISER_SETENA26_1 = 0x1
	// Position of SETENA27 field.
	NVIC_NVIC_ISER_SETENA27_Pos = 0x1b
	// Bit mask of SETENA27 field.
	NVIC_NVIC_ISER_SETENA27_Msk = 0x8000000
	// Bit SETENA27.
	NVIC_NVIC_ISER_SETENA27 = 0x8000000
	// write: no effect; read: multipurpose clock generator interrupt disabled
	NVIC_NVIC_ISER_SETENA27_0 = 0x0
	// write: enable multipurpose clock generator interrupt; read: multipurpose clock generator interrupt enabled
	NVIC_NVIC_ISER_SETENA27_1 = 0x1
	// Position of SETENA28 field.
	NVIC_NVIC_ISER_SETENA28_Pos = 0x1c
	// Bit mask of SETENA28 field.
	NVIC_NVIC_ISER_SETENA28_Msk = 0x10000000
	// Bit SETENA28.
	NVIC_NVIC_ISER_SETENA28 = 0x10000000
	// write: no effect; read: Low-Power Timer interrupt disabled
	NVIC_NVIC_ISER_SETENA28_0 = 0x0
	// write: enable Low-Power Timer interrupt; read: Low-Power Timer interrupt enabled
	NVIC_NVIC_ISER_SETENA28_1 = 0x1
	// Position of SETENA29 field.
	NVIC_NVIC_ISER_SETENA29_Pos = 0x1d
	// Bit mask of SETENA29 field.
	NVIC_NVIC_ISER_SETENA29_Msk = 0x20000000
	// Bit SETENA29.
	NVIC_NVIC_ISER_SETENA29 = 0x20000000
	// write: no effect; read: Reserved iv 45 interrupt disabled
	NVIC_NVIC_ISER_SETENA29_0 = 0x0
	// write: enable Reserved iv 45 interrupt; read: Reserved iv 45 interrupt enabled
	NVIC_NVIC_ISER_SETENA29_1 = 0x1
	// Position of SETENA30 field.
	NVIC_NVIC_ISER_SETENA30_Pos = 0x1e
	// Bit mask of SETENA30 field.
	NVIC_NVIC_ISER_SETENA30_Msk = 0x40000000
	// Bit SETENA30.
	NVIC_NVIC_ISER_SETENA30 = 0x40000000
	// write: no effect; read: PORTA pin detect interrupt disabled
	NVIC_NVIC_ISER_SETENA30_0 = 0x0
	// write: enable PORTA pin detect interrupt; read: PORTA pin detect interrupt enabled
	NVIC_NVIC_ISER_SETENA30_1 = 0x1
	// Position of SETENA31 field.
	NVIC_NVIC_ISER_SETENA31_Pos = 0x1f
	// Bit mask of SETENA31 field.
	NVIC_NVIC_ISER_SETENA31_Msk = 0x80000000
	// Bit SETENA31.
	NVIC_NVIC_ISER_SETENA31 = 0x80000000
	// write: no effect; read: PORTC and PORTD pin detect interrupt disabled
	NVIC_NVIC_ISER_SETENA31_0 = 0x0
	// write: enable PORTC and PORTD pin detect interrupt; read: PORTC and PORTD pin detect interrupt enabled
	NVIC_NVIC_ISER_SETENA31_1 = 0x1

	// NVIC_ICER: Interrupt Clear Enable Register
	// Position of CLRENA0 field.
	NVIC_NVIC_ICER_CLRENA0_Pos = 0x0
	// Bit mask of CLRENA0 field.
	NVIC_NVIC_ICER_CLRENA0_Msk = 0x1
	// Bit CLRENA0.
	NVIC_NVIC_ICER_CLRENA0 = 0x1
	// write: no effect; read: DMA channel 0 transfer complete and error interrupt disabled
	NVIC_NVIC_ICER_CLRENA0_0 = 0x0
	// write: disable DMA channel 0 transfer complete and error interrupt; read: DMA channel 0 transfer complete and error interrupt enabled
	NVIC_NVIC_ICER_CLRENA0_1 = 0x1
	// Position of CLRENA1 field.
	NVIC_NVIC_ICER_CLRENA1_Pos = 0x1
	// Bit mask of CLRENA1 field.
	NVIC_NVIC_ICER_CLRENA1_Msk = 0x2
	// Bit CLRENA1.
	NVIC_NVIC_ICER_CLRENA1 = 0x2
	// write: no effect; read: DMA channel 1 transfer complete and error interrupt disabled
	NVIC_NVIC_ICER_CLRENA1_0 = 0x0
	// write: disable DMA channel 1 transfer complete and error interrupt; read: DMA channel 1 transfer complete and error interrupt enabled
	NVIC_NVIC_ICER_CLRENA1_1 = 0x1
	// Position of CLRENA2 field.
	NVIC_NVIC_ICER_CLRENA2_Pos = 0x2
	// Bit mask of CLRENA2 field.
	NVIC_NVIC_ICER_CLRENA2_Msk = 0x4
	// Bit CLRENA2.
	NVIC_NVIC_ICER_CLRENA2 = 0x4
	// write: no effect; read: DMA channel 2 transfer complete and error interrupt disabled
	NVIC_NVIC_ICER_CLRENA2_0 = 0x0
	// write: disable DMA channel 2 transfer complete and error interrupt; read: DMA channel 2 transfer complete and error interrupt enabled
	NVIC_NVIC_ICER_CLRENA2_1 = 0x1
	// Position of CLRENA3 field.
	NVIC_NVIC_ICER_CLRENA3_Pos = 0x3
	// Bit mask of CLRENA3 field.
	NVIC_NVIC_ICER_CLRENA3_Msk = 0x8
	// Bit CLRENA3.
	NVIC_NVIC_ICER_CLRENA3 = 0x8
	// write: no effect; read: DMA channel 3 transfer complete and error interrupt disabled
	NVIC_NVIC_ICER_CLRENA3_0 = 0x0
	// write: disable DMA channel 3 transfer complete and error interrupt; read: DMA channel 3 transfer complete and error interrupt enabled
	NVIC_NVIC_ICER_CLRENA3_1 = 0x1
	// Position of CLRENA4 field.
	NVIC_NVIC_ICER_CLRENA4_Pos = 0x4
	// Bit mask of CLRENA4 field.
	NVIC_NVIC_ICER_CLRENA4_Msk = 0x10
	// Bit CLRENA4.
	NVIC_NVIC_ICER_CLRENA4 = 0x10
	// write: no effect; read: Reserved iv 20 interrupt disabled
	NVIC_NVIC_ICER_CLRENA4_0 = 0x0
	// write: disable Reserved iv 20 interrupt; read: Reserved iv 20 interrupt enabled
	NVIC_NVIC_ICER_CLRENA4_1 = 0x1
	// Position of CLRENA5 field.
	NVIC_NVIC_ICER_CLRENA5_Pos = 0x5
	// Bit mask of CLRENA5 field.
	NVIC_NVIC_ICER_CLRENA5_Msk = 0x20
	// Bit CLRENA5.
	NVIC_NVIC_ICER_CLRENA5 = 0x20
	// write: no effect; read: FTFA command complete and read collision interrupt disabled
	NVIC_NVIC_ICER_CLRENA5_0 = 0x0
	// write: disable FTFA command complete and read collision interrupt; read: FTFA command complete and read collision interrupt enabled
	NVIC_NVIC_ICER_CLRENA5_1 = 0x1
	// Position of CLRENA6 field.
	NVIC_NVIC_ICER_CLRENA6_Pos = 0x6
	// Bit mask of CLRENA6 field.
	NVIC_NVIC_ICER_CLRENA6_Msk = 0x40
	// Bit CLRENA6.
	NVIC_NVIC_ICER_CLRENA6 = 0x40
	// write: no effect; read: low-voltage detect and low-voltage warning interrupt disabled
	NVIC_NVIC_ICER_CLRENA6_0 = 0x0
	// write: disable low-voltage detect and low-voltage warning interrupt; read: low-voltage detect and low-voltage warning interrupt enabled
	NVIC_NVIC_ICER_CLRENA6_1 = 0x1
	// Position of CLRENA7 field.
	NVIC_NVIC_ICER_CLRENA7_Pos = 0x7
	// Bit mask of CLRENA7 field.
	NVIC_NVIC_ICER_CLRENA7_Msk = 0x80
	// Bit CLRENA7.
	NVIC_NVIC_ICER_CLRENA7 = 0x80
	// write: no effect; read: low leakage wakeup interrupt disabled
	NVIC_NVIC_ICER_CLRENA7_0 = 0x0
	// write: disable low leakage wakeup interrupt; read: low leakage wakeup interrupt enabled
	NVIC_NVIC_ICER_CLRENA7_1 = 0x1
	// Position of CLRENA8 field.
	NVIC_NVIC_ICER_CLRENA8_Pos = 0x8
	// Bit mask of CLRENA8 field.
	NVIC_NVIC_ICER_CLRENA8_Msk = 0x100
	// Bit CLRENA8.
	NVIC_NVIC_ICER_CLRENA8 = 0x100
	// write: no effect; read: inter-integrated circuit 0 interrupt disabled
	NVIC_NVIC_ICER_CLRENA8_0 = 0x0
	// write: disable inter-integrated circuit 0 interrupt; read: inter-integrated circuit 0 interrupt enabled
	NVIC_NVIC_ICER_CLRENA8_1 = 0x1
	// Position of CLRENA9 field.
	NVIC_NVIC_ICER_CLRENA9_Pos = 0x9
	// Bit mask of CLRENA9 field.
	NVIC_NVIC_ICER_CLRENA9_Msk = 0x200
	// Bit CLRENA9.
	NVIC_NVIC_ICER_CLRENA9 = 0x200
	// write: no effect; read: inter-integrated circuit 1 interrupt disabled
	NVIC_NVIC_ICER_CLRENA9_0 = 0x0
	// write: disable inter-integrated circuit 1 interrupt; read: inter-integrated circuit 1 interrupt enabled
	NVIC_NVIC_ICER_CLRENA9_1 = 0x1
	// Position of CLRENA10 field.
	NVIC_NVIC_ICER_CLRENA10_Pos = 0xa
	// Bit mask of CLRENA10 field.
	NVIC_NVIC_ICER_CLRENA10_Msk = 0x400
	// Bit CLRENA10.
	NVIC_NVIC_ICER_CLRENA10 = 0x400
	// write: no effect; read: serial peripheral interface 0 interrupt disabled
	NVIC_NVIC_ICER_CLRENA10_0 = 0x0
	// write: disable serial peripheral interface 0 interrupt; read: serial peripheral interface 0 interrupt enabled
	NVIC_NVIC_ICER_CLRENA10_1 = 0x1
	// Position of CLRENA11 field.
	NVIC_NVIC_ICER_CLRENA11_Pos = 0xb
	// Bit mask of CLRENA11 field.
	NVIC_NVIC_ICER_CLRENA11_Msk = 0x800
	// Bit CLRENA11.
	NVIC_NVIC_ICER_CLRENA11 = 0x800
	// write: no effect; read: serial peripheral interface 1 interrupt disabled
	NVIC_NVIC_ICER_CLRENA11_0 = 0x0
	// write: disable serial peripheral interface 1 interrupt; read: serial peripheral interface 1 interrupt enabled
	NVIC_NVIC_ICER_CLRENA11_1 = 0x1
	// Position of CLRENA12 field.
	NVIC_NVIC_ICER_CLRENA12_Pos = 0xc
	// Bit mask of CLRENA12 field.
	NVIC_NVIC_ICER_CLRENA12_Msk = 0x1000
	// Bit CLRENA12.
	NVIC_NVIC_ICER_CLRENA12 = 0x1000
	// write: no effect; read: UART0 status and error interrupt disabled
	NVIC_NVIC_ICER_CLRENA12_0 = 0x0
	// write: disable UART0 status and error interrupt; read: UART0 status and error interrupt enabled
	NVIC_NVIC_ICER_CLRENA12_1 = 0x1
	// Position of CLRENA13 field.
	NVIC_NVIC_ICER_CLRENA13_Pos = 0xd
	// Bit mask of CLRENA13 field.
	NVIC_NVIC_ICER_CLRENA13_Msk = 0x2000
	// Bit CLRENA13.
	NVIC_NVIC_ICER_CLRENA13 = 0x2000
	// write: no effect; read: UART1 status and error interrupt disabled
	NVIC_NVIC_ICER_CLRENA13_0 = 0x0
	// write: disable UART1 status and error interrupt; read: UART1 status and error interrupt enabled
	NVIC_NVIC_ICER_CLRENA13_1 = 0x1
	// Position of CLRENA14 field.
	NVIC_NVIC_ICER_CLRENA14_Pos = 0xe
	// Bit mask of CLRENA14 field.
	NVIC_NVIC_ICER_CLRENA14_Msk = 0x4000
	// Bit CLRENA14.
	NVIC_NVIC_ICER_CLRENA14 = 0x4000
	// write: no effect; read: UART2 status and error interrupt disabled
	NVIC_NVIC_ICER_CLRENA14_0 = 0x0
	// write: disable UART2 status and error interrupt; read: UART2 status and error interrupt enabled
	NVIC_NVIC_ICER_CLRENA14_1 = 0x1
	// Position of CLRENA15 field.
	NVIC_NVIC_ICER_CLRENA15_Pos = 0xf
	// Bit mask of CLRENA15 field.
	NVIC_NVIC_ICER_CLRENA15_Msk = 0x8000
	// Bit CLRENA15.
	NVIC_NVIC_ICER_CLRENA15 = 0x8000
	// write: no effect; read: Analog-to-digital converter 0 interrupt disabled
	NVIC_NVIC_ICER_CLRENA15_0 = 0x0
	// write: disable Analog-to-digital converter 0 interrupt; read: Analog-to-digital converter 0 interrupt enabled
	NVIC_NVIC_ICER_CLRENA15_1 = 0x1
	// Position of CLRENA16 field.
	NVIC_NVIC_ICER_CLRENA16_Pos = 0x10
	// Bit mask of CLRENA16 field.
	NVIC_NVIC_ICER_CLRENA16_Msk = 0x10000
	// Bit CLRENA16.
	NVIC_NVIC_ICER_CLRENA16 = 0x10000
	// write: no effect; read: Comparator 0 interrupt disabled
	NVIC_NVIC_ICER_CLRENA16_0 = 0x0
	// write: disable Comparator 0 interrupt; read: Comparator 0 interrupt enabled
	NVIC_NVIC_ICER_CLRENA16_1 = 0x1
	// Position of CLRENA17 field.
	NVIC_NVIC_ICER_CLRENA17_Pos = 0x11
	// Bit mask of CLRENA17 field.
	NVIC_NVIC_ICER_CLRENA17_Msk = 0x20000
	// Bit CLRENA17.
	NVIC_NVIC_ICER_CLRENA17 = 0x20000
	// write: no effect; read: Timer PWM module 0 interrupt disabled
	NVIC_NVIC_ICER_CLRENA17_0 = 0x0
	// write: disable Timer PWM module 0 interrupt; read: Timer PWM module 0 interrupt enabled
	NVIC_NVIC_ICER_CLRENA17_1 = 0x1
	// Position of CLRENA18 field.
	NVIC_NVIC_ICER_CLRENA18_Pos = 0x12
	// Bit mask of CLRENA18 field.
	NVIC_NVIC_ICER_CLRENA18_Msk = 0x40000
	// Bit CLRENA18.
	NVIC_NVIC_ICER_CLRENA18 = 0x40000
	// write: no effect; read: Timer PWM module 1 interrupt disabled
	NVIC_NVIC_ICER_CLRENA18_0 = 0x0
	// write: disable Timer PWM module 1 interrupt; read: Timer PWM module 1 interrupt enabled
	NVIC_NVIC_ICER_CLRENA18_1 = 0x1
	// Position of CLRENA19 field.
	NVIC_NVIC_ICER_CLRENA19_Pos = 0x13
	// Bit mask of CLRENA19 field.
	NVIC_NVIC_ICER_CLRENA19_Msk = 0x80000
	// Bit CLRENA19.
	NVIC_NVIC_ICER_CLRENA19 = 0x80000
	// write: no effect; read: Timer PWM module 2 interrupt disabled
	NVIC_NVIC_ICER_CLRENA19_0 = 0x0
	// write: disable Timer PWM module 2 interrupt; read: Timer PWM module 2 interrupt enabled
	NVIC_NVIC_ICER_CLRENA19_1 = 0x1
	// Position of CLRENA20 field.
	NVIC_NVIC_ICER_CLRENA20_Pos = 0x14
	// Bit mask of CLRENA20 field.
	NVIC_NVIC_ICER_CLRENA20_Msk = 0x100000
	// Bit CLRENA20.
	NVIC_NVIC_ICER_CLRENA20 = 0x100000
	// write: no effect; read: real time clock alarm interrupt disabled
	NVIC_NVIC_ICER_CLRENA20_0 = 0x0
	// write: disable real time clock alarm interrupt; read: real time clock alarm interrupt enabled
	NVIC_NVIC_ICER_CLRENA20_1 = 0x1
	// Position of CLRENA21 field.
	NVIC_NVIC_ICER_CLRENA21_Pos = 0x15
	// Bit mask of CLRENA21 field.
	NVIC_NVIC_ICER_CLRENA21_Msk = 0x200000
	// Bit CLRENA21.
	NVIC_NVIC_ICER_CLRENA21 = 0x200000
	// write: no effect; read: real time clock seconds interrupt disabled
	NVIC_NVIC_ICER_CLRENA21_0 = 0x0
	// write: disable real time clock seconds interrupt; read: real time clock seconds interrupt enabled
	NVIC_NVIC_ICER_CLRENA21_1 = 0x1
	// Position of CLRENA22 field.
	NVIC_NVIC_ICER_CLRENA22_Pos = 0x16
	// Bit mask of CLRENA22 field.
	NVIC_NVIC_ICER_CLRENA22_Msk = 0x400000
	// Bit CLRENA22.
	NVIC_NVIC_ICER_CLRENA22 = 0x400000
	// write: no effect; read: periodic interrupt timer all channels interrupt disabled
	NVIC_NVIC_ICER_CLRENA22_0 = 0x0
	// write: disable periodic interrupt timer all channels interrupt; read: periodic interrupt timer all channels interrupt enabled
	NVIC_NVIC_ICER_CLRENA22_1 = 0x1
	// Position of CLRENA23 field.
	NVIC_NVIC_ICER_CLRENA23_Pos = 0x17
	// Bit mask of CLRENA23 field.
	NVIC_NVIC_ICER_CLRENA23_Msk = 0x800000
	// Bit CLRENA23.
	NVIC_NVIC_ICER_CLRENA23 = 0x800000
	// write: no effect; read: integrated interchip sound 0 interrupt disabled
	NVIC_NVIC_ICER_CLRENA23_0 = 0x0
	// write: disable integrated interchip sound 0 interrupt; read: integrated interchip sound 0 interrupt enabled
	NVIC_NVIC_ICER_CLRENA23_1 = 0x1
	// Position of CLRENA24 field.
	NVIC_NVIC_ICER_CLRENA24_Pos = 0x18
	// Bit mask of CLRENA24 field.
	NVIC_NVIC_ICER_CLRENA24_Msk = 0x1000000
	// Bit CLRENA24.
	NVIC_NVIC_ICER_CLRENA24 = 0x1000000
	// write: no effect; read: universal serial bus on the go interrupt disabled
	NVIC_NVIC_ICER_CLRENA24_0 = 0x0
	// write: disable universal serial bus on the go interrupt; read: universal serial bus on the go interrupt enabled
	NVIC_NVIC_ICER_CLRENA24_1 = 0x1
	// Position of CLRENA25 field.
	NVIC_NVIC_ICER_CLRENA25_Pos = 0x19
	// Bit mask of CLRENA25 field.
	NVIC_NVIC_ICER_CLRENA25_Msk = 0x2000000
	// Bit CLRENA25.
	NVIC_NVIC_ICER_CLRENA25 = 0x2000000
	// write: no effect; read: digital-to-analog converter 0 interrupt disabled
	NVIC_NVIC_ICER_CLRENA25_0 = 0x0
	// write: disable digital-to-analog converter 0 interrupt; read: digital-to-analog converter 0 interrupt enabled
	NVIC_NVIC_ICER_CLRENA25_1 = 0x1
	// Position of CLRENA26 field.
	NVIC_NVIC_ICER_CLRENA26_Pos = 0x1a
	// Bit mask of CLRENA26 field.
	NVIC_NVIC_ICER_CLRENA26_Msk = 0x4000000
	// Bit CLRENA26.
	NVIC_NVIC_ICER_CLRENA26 = 0x4000000
	// write: no effect; read: touch sensing input interrupt disabled
	NVIC_NVIC_ICER_CLRENA26_0 = 0x0
	// write: disable touch sensing input interrupt; read: touch sensing input interrupt enabled
	NVIC_NVIC_ICER_CLRENA26_1 = 0x1
	// Position of CLRENA27 field.
	NVIC_NVIC_ICER_CLRENA27_Pos = 0x1b
	// Bit mask of CLRENA27 field.
	NVIC_NVIC_ICER_CLRENA27_Msk = 0x8000000
	// Bit CLRENA27.
	NVIC_NVIC_ICER_CLRENA27 = 0x8000000
	// write: no effect; read: multipurpose clock generator interrupt disabled
	NVIC_NVIC_ICER_CLRENA27_0 = 0x0
	// write: disable multipurpose clock generator interrupt; read: multipurpose clock generator interrupt enabled
	NVIC_NVIC_ICER_CLRENA27_1 = 0x1
	// Position of CLRENA28 field.
	NVIC_NVIC_ICER_CLRENA28_Pos = 0x1c
	// Bit mask of CLRENA28 field.
	NVIC_NVIC_ICER_CLRENA28_Msk = 0x10000000
	// Bit CLRENA28.
	NVIC_NVIC_ICER_CLRENA28 = 0x10000000
	// write: no effect; read: Low-Power Timer interrupt disabled
	NVIC_NVIC_ICER_CLRENA28_0 = 0x0
	// write: disable Low-Power Timer interrupt; read: Low-Power Timer interrupt enabled
	NVIC_NVIC_ICER_CLRENA28_1 = 0x1
	// Position of CLRENA29 field.
	NVIC_NVIC_ICER_CLRENA29_Pos = 0x1d
	// Bit mask of CLRENA29 field.
	NVIC_NVIC_ICER_CLRENA29_Msk = 0x20000000
	// Bit CLRENA29.
	NVIC_NVIC_ICER_CLRENA29 = 0x20000000
	// write: no effect; read: Reserved iv 45 interrupt disabled
	NVIC_NVIC_ICER_CLRENA29_0 = 0x0
	// write: disable Reserved iv 45 interrupt; read: Reserved iv 45 interrupt enabled
	NVIC_NVIC_ICER_CLRENA29_1 = 0x1
	// Position of CLRENA30 field.
	NVIC_NVIC_ICER_CLRENA30_Pos = 0x1e
	// Bit mask of CLRENA30 field.
	NVIC_NVIC_ICER_CLRENA30_Msk = 0x40000000
	// Bit CLRENA30.
	NVIC_NVIC_ICER_CLRENA30 = 0x40000000
	// write: no effect; read: PORTA pin detect interrupt disabled
	NVIC_NVIC_ICER_CLRENA30_0 = 0x0
	// write: disable PORTA pin detect interrupt; read: PORTA pin detect interrupt enabled
	NVIC_NVIC_ICER_CLRENA30_1 = 0x1
	// Position of CLRENA31 field.
	NVIC_NVIC_ICER_CLRENA31_Pos = 0x1f
	// Bit mask of CLRENA31 field.
	NVIC_NVIC_ICER_CLRENA31_Msk = 0x80000000
	// Bit CLRENA31.
	NVIC_NVIC_ICER_CLRENA31 = 0x80000000
	// write: no effect; read: PORTC and PORTD pin detect interrupt disabled
	NVIC_NVIC_ICER_CLRENA31_0 = 0x0
	// write: disable PORTC and PORTD pin detect interrupt; read: PORTC and PORTD pin detect interrupt enabled
	NVIC_NVIC_ICER_CLRENA31_1 = 0x1

	// NVIC_ISPR: Interrupt Set Pending Register
	// Position of SETPEND0 field.
	NVIC_NVIC_ISPR_SETPEND0_Pos = 0x0
	// Bit mask of SETPEND0 field.
	NVIC_NVIC_ISPR_SETPEND0_Msk = 0x1
	// Bit SETPEND0.
	NVIC_NVIC_ISPR_SETPEND0 = 0x1
	// write: no effect; read: DMA channel 0 transfer complete and error interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND0_0 = 0x0
	// write: changes the DMA channel 0 transfer complete and error interrupt state to pending; read: DMA channel 0 transfer complete and error interrupt is pending
	NVIC_NVIC_ISPR_SETPEND0_1 = 0x1
	// Position of SETPEND1 field.
	NVIC_NVIC_ISPR_SETPEND1_Pos = 0x1
	// Bit mask of SETPEND1 field.
	NVIC_NVIC_ISPR_SETPEND1_Msk = 0x2
	// Bit SETPEND1.
	NVIC_NVIC_ISPR_SETPEND1 = 0x2
	// write: no effect; read: DMA channel 1 transfer complete and error interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND1_0 = 0x0
	// write: changes the DMA channel 1 transfer complete and error interrupt state to pending; read: DMA channel 1 transfer complete and error interrupt is pending
	NVIC_NVIC_ISPR_SETPEND1_1 = 0x1
	// Position of SETPEND2 field.
	NVIC_NVIC_ISPR_SETPEND2_Pos = 0x2
	// Bit mask of SETPEND2 field.
	NVIC_NVIC_ISPR_SETPEND2_Msk = 0x4
	// Bit SETPEND2.
	NVIC_NVIC_ISPR_SETPEND2 = 0x4
	// write: no effect; read: DMA channel 2 transfer complete and error interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND2_0 = 0x0
	// write: changes the DMA channel 2 transfer complete and error interrupt state to pending; read: DMA channel 2 transfer complete and error interrupt is pending
	NVIC_NVIC_ISPR_SETPEND2_1 = 0x1
	// Position of SETPEND3 field.
	NVIC_NVIC_ISPR_SETPEND3_Pos = 0x3
	// Bit mask of SETPEND3 field.
	NVIC_NVIC_ISPR_SETPEND3_Msk = 0x8
	// Bit SETPEND3.
	NVIC_NVIC_ISPR_SETPEND3 = 0x8
	// write: no effect; read: DMA channel 3 transfer complete and error interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND3_0 = 0x0
	// write: changes the DMA channel 3 transfer complete and error interrupt state to pending; read: DMA channel 3 transfer complete and error interrupt is pending
	NVIC_NVIC_ISPR_SETPEND3_1 = 0x1
	// Position of SETPEND4 field.
	NVIC_NVIC_ISPR_SETPEND4_Pos = 0x4
	// Bit mask of SETPEND4 field.
	NVIC_NVIC_ISPR_SETPEND4_Msk = 0x10
	// Bit SETPEND4.
	NVIC_NVIC_ISPR_SETPEND4 = 0x10
	// write: no effect; read: Reserved iv 20 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND4_0 = 0x0
	// write: changes the Reserved iv 20 interrupt state to pending; read: Reserved iv 20 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND4_1 = 0x1
	// Position of SETPEND5 field.
	NVIC_NVIC_ISPR_SETPEND5_Pos = 0x5
	// Bit mask of SETPEND5 field.
	NVIC_NVIC_ISPR_SETPEND5_Msk = 0x20
	// Bit SETPEND5.
	NVIC_NVIC_ISPR_SETPEND5 = 0x20
	// write: no effect; read: FTFA command complete and read collision interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND5_0 = 0x0
	// write: changes the FTFA command complete and read collision interrupt state to pending; read: FTFA command complete and read collision interrupt is pending
	NVIC_NVIC_ISPR_SETPEND5_1 = 0x1
	// Position of SETPEND6 field.
	NVIC_NVIC_ISPR_SETPEND6_Pos = 0x6
	// Bit mask of SETPEND6 field.
	NVIC_NVIC_ISPR_SETPEND6_Msk = 0x40
	// Bit SETPEND6.
	NVIC_NVIC_ISPR_SETPEND6 = 0x40
	// write: no effect; read: low-voltage detect and low-voltage warning interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND6_0 = 0x0
	// write: changes the low-voltage detect and low-voltage warning interrupt state to pending; read: low-voltage detect and low-voltage warning interrupt is pending
	NVIC_NVIC_ISPR_SETPEND6_1 = 0x1
	// Position of SETPEND7 field.
	NVIC_NVIC_ISPR_SETPEND7_Pos = 0x7
	// Bit mask of SETPEND7 field.
	NVIC_NVIC_ISPR_SETPEND7_Msk = 0x80
	// Bit SETPEND7.
	NVIC_NVIC_ISPR_SETPEND7 = 0x80
	// write: no effect; read: low leakage wakeup interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND7_0 = 0x0
	// write: changes the low leakage wakeup interrupt state to pending; read: low leakage wakeup interrupt is pending
	NVIC_NVIC_ISPR_SETPEND7_1 = 0x1
	// Position of SETPEND8 field.
	NVIC_NVIC_ISPR_SETPEND8_Pos = 0x8
	// Bit mask of SETPEND8 field.
	NVIC_NVIC_ISPR_SETPEND8_Msk = 0x100
	// Bit SETPEND8.
	NVIC_NVIC_ISPR_SETPEND8 = 0x100
	// write: no effect; read: inter-integrated circuit 0 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND8_0 = 0x0
	// write: changes the inter-integrated circuit 0 interrupt state to pending; read: inter-integrated circuit 0 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND8_1 = 0x1
	// Position of SETPEND9 field.
	NVIC_NVIC_ISPR_SETPEND9_Pos = 0x9
	// Bit mask of SETPEND9 field.
	NVIC_NVIC_ISPR_SETPEND9_Msk = 0x200
	// Bit SETPEND9.
	NVIC_NVIC_ISPR_SETPEND9 = 0x200
	// write: no effect; read: inter-integrated circuit 1 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND9_0 = 0x0
	// write: changes the inter-integrated circuit 1 interrupt state to pending; read: inter-integrated circuit 1 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND9_1 = 0x1
	// Position of SETPEND10 field.
	NVIC_NVIC_ISPR_SETPEND10_Pos = 0xa
	// Bit mask of SETPEND10 field.
	NVIC_NVIC_ISPR_SETPEND10_Msk = 0x400
	// Bit SETPEND10.
	NVIC_NVIC_ISPR_SETPEND10 = 0x400
	// write: no effect; read: serial peripheral interface 0 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND10_0 = 0x0
	// write: changes the serial peripheral interface 0 interrupt state to pending; read: serial peripheral interface 0 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND10_1 = 0x1
	// Position of SETPEND11 field.
	NVIC_NVIC_ISPR_SETPEND11_Pos = 0xb
	// Bit mask of SETPEND11 field.
	NVIC_NVIC_ISPR_SETPEND11_Msk = 0x800
	// Bit SETPEND11.
	NVIC_NVIC_ISPR_SETPEND11 = 0x800
	// write: no effect; read: serial peripheral interface 1 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND11_0 = 0x0
	// write: changes the serial peripheral interface 1 interrupt state to pending; read: serial peripheral interface 1 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND11_1 = 0x1
	// Position of SETPEND12 field.
	NVIC_NVIC_ISPR_SETPEND12_Pos = 0xc
	// Bit mask of SETPEND12 field.
	NVIC_NVIC_ISPR_SETPEND12_Msk = 0x1000
	// Bit SETPEND12.
	NVIC_NVIC_ISPR_SETPEND12 = 0x1000
	// write: no effect; read: UART0 status and error interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND12_0 = 0x0
	// write: changes the UART0 status and error interrupt state to pending; read: UART0 status and error interrupt is pending
	NVIC_NVIC_ISPR_SETPEND12_1 = 0x1
	// Position of SETPEND13 field.
	NVIC_NVIC_ISPR_SETPEND13_Pos = 0xd
	// Bit mask of SETPEND13 field.
	NVIC_NVIC_ISPR_SETPEND13_Msk = 0x2000
	// Bit SETPEND13.
	NVIC_NVIC_ISPR_SETPEND13 = 0x2000
	// write: no effect; read: UART1 status and error interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND13_0 = 0x0
	// write: changes the UART1 status and error interrupt state to pending; read: UART1 status and error interrupt is pending
	NVIC_NVIC_ISPR_SETPEND13_1 = 0x1
	// Position of SETPEND14 field.
	NVIC_NVIC_ISPR_SETPEND14_Pos = 0xe
	// Bit mask of SETPEND14 field.
	NVIC_NVIC_ISPR_SETPEND14_Msk = 0x4000
	// Bit SETPEND14.
	NVIC_NVIC_ISPR_SETPEND14 = 0x4000
	// write: no effect; read: UART2 status and error interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND14_0 = 0x0
	// write: changes the UART2 status and error interrupt state to pending; read: UART2 status and error interrupt is pending
	NVIC_NVIC_ISPR_SETPEND14_1 = 0x1
	// Position of SETPEND15 field.
	NVIC_NVIC_ISPR_SETPEND15_Pos = 0xf
	// Bit mask of SETPEND15 field.
	NVIC_NVIC_ISPR_SETPEND15_Msk = 0x8000
	// Bit SETPEND15.
	NVIC_NVIC_ISPR_SETPEND15 = 0x8000
	// write: no effect; read: Analog-to-digital converter 0 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND15_0 = 0x0
	// write: changes the Analog-to-digital converter 0 interrupt state to pending; read: Analog-to-digital converter 0 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND15_1 = 0x1
	// Position of SETPEND16 field.
	NVIC_NVIC_ISPR_SETPEND16_Pos = 0x10
	// Bit mask of SETPEND16 field.
	NVIC_NVIC_ISPR_SETPEND16_Msk = 0x10000
	// Bit SETPEND16.
	NVIC_NVIC_ISPR_SETPEND16 = 0x10000
	// write: no effect; read: Comparator 0 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND16_0 = 0x0
	// write: changes the Comparator 0 interrupt state to pending; read: Comparator 0 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND16_1 = 0x1
	// Position of SETPEND17 field.
	NVIC_NVIC_ISPR_SETPEND17_Pos = 0x11
	// Bit mask of SETPEND17 field.
	NVIC_NVIC_ISPR_SETPEND17_Msk = 0x20000
	// Bit SETPEND17.
	NVIC_NVIC_ISPR_SETPEND17 = 0x20000
	// write: no effect; read: Timer PWM module 0 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND17_0 = 0x0
	// write: changes the Timer PWM module 0 interrupt state to pending; read: Timer PWM module 0 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND17_1 = 0x1
	// Position of SETPEND18 field.
	NVIC_NVIC_ISPR_SETPEND18_Pos = 0x12
	// Bit mask of SETPEND18 field.
	NVIC_NVIC_ISPR_SETPEND18_Msk = 0x40000
	// Bit SETPEND18.
	NVIC_NVIC_ISPR_SETPEND18 = 0x40000
	// write: no effect; read: Timer PWM module 1 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND18_0 = 0x0
	// write: changes the Timer PWM module 1 interrupt state to pending; read: Timer PWM module 1 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND18_1 = 0x1
	// Position of SETPEND19 field.
	NVIC_NVIC_ISPR_SETPEND19_Pos = 0x13
	// Bit mask of SETPEND19 field.
	NVIC_NVIC_ISPR_SETPEND19_Msk = 0x80000
	// Bit SETPEND19.
	NVIC_NVIC_ISPR_SETPEND19 = 0x80000
	// write: no effect; read: Timer PWM module 2 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND19_0 = 0x0
	// write: changes the Timer PWM module 2 interrupt state to pending; read: Timer PWM module 2 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND19_1 = 0x1
	// Position of SETPEND20 field.
	NVIC_NVIC_ISPR_SETPEND20_Pos = 0x14
	// Bit mask of SETPEND20 field.
	NVIC_NVIC_ISPR_SETPEND20_Msk = 0x100000
	// Bit SETPEND20.
	NVIC_NVIC_ISPR_SETPEND20 = 0x100000
	// write: no effect; read: real time clock alarm interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND20_0 = 0x0
	// write: changes the real time clock alarm interrupt state to pending; read: real time clock alarm interrupt is pending
	NVIC_NVIC_ISPR_SETPEND20_1 = 0x1
	// Position of SETPEND21 field.
	NVIC_NVIC_ISPR_SETPEND21_Pos = 0x15
	// Bit mask of SETPEND21 field.
	NVIC_NVIC_ISPR_SETPEND21_Msk = 0x200000
	// Bit SETPEND21.
	NVIC_NVIC_ISPR_SETPEND21 = 0x200000
	// write: no effect; read: real time clock seconds interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND21_0 = 0x0
	// write: changes the real time clock seconds interrupt state to pending; read: real time clock seconds interrupt is pending
	NVIC_NVIC_ISPR_SETPEND21_1 = 0x1
	// Position of SETPEND22 field.
	NVIC_NVIC_ISPR_SETPEND22_Pos = 0x16
	// Bit mask of SETPEND22 field.
	NVIC_NVIC_ISPR_SETPEND22_Msk = 0x400000
	// Bit SETPEND22.
	NVIC_NVIC_ISPR_SETPEND22 = 0x400000
	// write: no effect; read: periodic interrupt timer all channels interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND22_0 = 0x0
	// write: changes the periodic interrupt timer all channels interrupt state to pending; read: periodic interrupt timer all channels interrupt is pending
	NVIC_NVIC_ISPR_SETPEND22_1 = 0x1
	// Position of SETPEND23 field.
	NVIC_NVIC_ISPR_SETPEND23_Pos = 0x17
	// Bit mask of SETPEND23 field.
	NVIC_NVIC_ISPR_SETPEND23_Msk = 0x800000
	// Bit SETPEND23.
	NVIC_NVIC_ISPR_SETPEND23 = 0x800000
	// write: no effect; read: integrated interchip sound 0 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND23_0 = 0x0
	// write: changes the integrated interchip sound 0 interrupt state to pending; read: integrated interchip sound 0 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND23_1 = 0x1
	// Position of SETPEND24 field.
	NVIC_NVIC_ISPR_SETPEND24_Pos = 0x18
	// Bit mask of SETPEND24 field.
	NVIC_NVIC_ISPR_SETPEND24_Msk = 0x1000000
	// Bit SETPEND24.
	NVIC_NVIC_ISPR_SETPEND24 = 0x1000000
	// write: no effect; read: universal serial bus on the go interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND24_0 = 0x0
	// write: changes the universal serial bus on the go interrupt state to pending; read: universal serial bus on the go interrupt is pending
	NVIC_NVIC_ISPR_SETPEND24_1 = 0x1
	// Position of SETPEND25 field.
	NVIC_NVIC_ISPR_SETPEND25_Pos = 0x19
	// Bit mask of SETPEND25 field.
	NVIC_NVIC_ISPR_SETPEND25_Msk = 0x2000000
	// Bit SETPEND25.
	NVIC_NVIC_ISPR_SETPEND25 = 0x2000000
	// write: no effect; read: digital-to-analog converter 0 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND25_0 = 0x0
	// write: changes the digital-to-analog converter 0 interrupt state to pending; read: digital-to-analog converter 0 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND25_1 = 0x1
	// Position of SETPEND26 field.
	NVIC_NVIC_ISPR_SETPEND26_Pos = 0x1a
	// Bit mask of SETPEND26 field.
	NVIC_NVIC_ISPR_SETPEND26_Msk = 0x4000000
	// Bit SETPEND26.
	NVIC_NVIC_ISPR_SETPEND26 = 0x4000000
	// write: no effect; read: touch sensing input interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND26_0 = 0x0
	// write: changes the touch sensing input interrupt state to pending; read: touch sensing input interrupt is pending
	NVIC_NVIC_ISPR_SETPEND26_1 = 0x1
	// Position of SETPEND27 field.
	NVIC_NVIC_ISPR_SETPEND27_Pos = 0x1b
	// Bit mask of SETPEND27 field.
	NVIC_NVIC_ISPR_SETPEND27_Msk = 0x8000000
	// Bit SETPEND27.
	NVIC_NVIC_ISPR_SETPEND27 = 0x8000000
	// write: no effect; read: multipurpose clock generator interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND27_0 = 0x0
	// write: changes the multipurpose clock generator interrupt state to pending; read: multipurpose clock generator interrupt is pending
	NVIC_NVIC_ISPR_SETPEND27_1 = 0x1
	// Position of SETPEND28 field.
	NVIC_NVIC_ISPR_SETPEND28_Pos = 0x1c
	// Bit mask of SETPEND28 field.
	NVIC_NVIC_ISPR_SETPEND28_Msk = 0x10000000
	// Bit SETPEND28.
	NVIC_NVIC_ISPR_SETPEND28 = 0x10000000
	// write: no effect; read: Low-Power Timer interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND28_0 = 0x0
	// write: changes the Low-Power Timer interrupt state to pending; read: Low-Power Timer interrupt is pending
	NVIC_NVIC_ISPR_SETPEND28_1 = 0x1
	// Position of SETPEND29 field.
	NVIC_NVIC_ISPR_SETPEND29_Pos = 0x1d
	// Bit mask of SETPEND29 field.
	NVIC_NVIC_ISPR_SETPEND29_Msk = 0x20000000
	// Bit SETPEND29.
	NVIC_NVIC_ISPR_SETPEND29 = 0x20000000
	// write: no effect; read: Reserved iv 45 interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND29_0 = 0x0
	// write: changes the Reserved iv 45 interrupt state to pending; read: Reserved iv 45 interrupt is pending
	NVIC_NVIC_ISPR_SETPEND29_1 = 0x1
	// Position of SETPEND30 field.
	NVIC_NVIC_ISPR_SETPEND30_Pos = 0x1e
	// Bit mask of SETPEND30 field.
	NVIC_NVIC_ISPR_SETPEND30_Msk = 0x40000000
	// Bit SETPEND30.
	NVIC_NVIC_ISPR_SETPEND30 = 0x40000000
	// write: no effect; read: PORTA pin detect interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND30_0 = 0x0
	// write: changes the PORTA pin detect interrupt state to pending; read: PORTA pin detect interrupt is pending
	NVIC_NVIC_ISPR_SETPEND30_1 = 0x1
	// Position of SETPEND31 field.
	NVIC_NVIC_ISPR_SETPEND31_Pos = 0x1f
	// Bit mask of SETPEND31 field.
	NVIC_NVIC_ISPR_SETPEND31_Msk = 0x80000000
	// Bit SETPEND31.
	NVIC_NVIC_ISPR_SETPEND31 = 0x80000000
	// write: no effect; read: PORTC and PORTD pin detect interrupt is not pending
	NVIC_NVIC_ISPR_SETPEND31_0 = 0x0
	// write: changes the PORTC and PORTD pin detect interrupt state to pending; read: PORTC and PORTD pin detect interrupt is pending
	NVIC_NVIC_ISPR_SETPEND31_1 = 0x1

	// NVIC_ICPR: Interrupt Clear Pending Register
	// Position of CLRPEND0 field.
	NVIC_NVIC_ICPR_CLRPEND0_Pos = 0x0
	// Bit mask of CLRPEND0 field.
	NVIC_NVIC_ICPR_CLRPEND0_Msk = 0x1
	// Bit CLRPEND0.
	NVIC_NVIC_ICPR_CLRPEND0 = 0x1
	// write: no effect; read: DMA channel 0 transfer complete and error interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND0_0 = 0x0
	// write: removes pending state from the DMA channel 0 transfer complete and error interrupt; read: DMA channel 0 transfer complete and error interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND0_1 = 0x1
	// Position of CLRPEND1 field.
	NVIC_NVIC_ICPR_CLRPEND1_Pos = 0x1
	// Bit mask of CLRPEND1 field.
	NVIC_NVIC_ICPR_CLRPEND1_Msk = 0x2
	// Bit CLRPEND1.
	NVIC_NVIC_ICPR_CLRPEND1 = 0x2
	// write: no effect; read: DMA channel 1 transfer complete and error interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND1_0 = 0x0
	// write: removes pending state from the DMA channel 1 transfer complete and error interrupt; read: DMA channel 1 transfer complete and error interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND1_1 = 0x1
	// Position of CLRPEND2 field.
	NVIC_NVIC_ICPR_CLRPEND2_Pos = 0x2
	// Bit mask of CLRPEND2 field.
	NVIC_NVIC_ICPR_CLRPEND2_Msk = 0x4
	// Bit CLRPEND2.
	NVIC_NVIC_ICPR_CLRPEND2 = 0x4
	// write: no effect; read: DMA channel 2 transfer complete and error interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND2_0 = 0x0
	// write: removes pending state from the DMA channel 2 transfer complete and error interrupt; read: DMA channel 2 transfer complete and error interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND2_1 = 0x1
	// Position of CLRPEND3 field.
	NVIC_NVIC_ICPR_CLRPEND3_Pos = 0x3
	// Bit mask of CLRPEND3 field.
	NVIC_NVIC_ICPR_CLRPEND3_Msk = 0x8
	// Bit CLRPEND3.
	NVIC_NVIC_ICPR_CLRPEND3 = 0x8
	// write: no effect; read: DMA channel 3 transfer complete and error interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND3_0 = 0x0
	// write: removes pending state from the DMA channel 3 transfer complete and error interrupt; read: DMA channel 3 transfer complete and error interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND3_1 = 0x1
	// Position of CLRPEND4 field.
	NVIC_NVIC_ICPR_CLRPEND4_Pos = 0x4
	// Bit mask of CLRPEND4 field.
	NVIC_NVIC_ICPR_CLRPEND4_Msk = 0x10
	// Bit CLRPEND4.
	NVIC_NVIC_ICPR_CLRPEND4 = 0x10
	// write: no effect; read: Reserved iv 20 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND4_0 = 0x0
	// write: removes pending state from the Reserved iv 20 interrupt; read: Reserved iv 20 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND4_1 = 0x1
	// Position of CLRPEND5 field.
	NVIC_NVIC_ICPR_CLRPEND5_Pos = 0x5
	// Bit mask of CLRPEND5 field.
	NVIC_NVIC_ICPR_CLRPEND5_Msk = 0x20
	// Bit CLRPEND5.
	NVIC_NVIC_ICPR_CLRPEND5 = 0x20
	// write: no effect; read: FTFA command complete and read collision interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND5_0 = 0x0
	// write: removes pending state from the FTFA command complete and read collision interrupt; read: FTFA command complete and read collision interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND5_1 = 0x1
	// Position of CLRPEND6 field.
	NVIC_NVIC_ICPR_CLRPEND6_Pos = 0x6
	// Bit mask of CLRPEND6 field.
	NVIC_NVIC_ICPR_CLRPEND6_Msk = 0x40
	// Bit CLRPEND6.
	NVIC_NVIC_ICPR_CLRPEND6 = 0x40
	// write: no effect; read: low-voltage detect and low-voltage warning interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND6_0 = 0x0
	// write: removes pending state from the low-voltage detect and low-voltage warning interrupt; read: low-voltage detect and low-voltage warning interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND6_1 = 0x1
	// Position of CLRPEND7 field.
	NVIC_NVIC_ICPR_CLRPEND7_Pos = 0x7
	// Bit mask of CLRPEND7 field.
	NVIC_NVIC_ICPR_CLRPEND7_Msk = 0x80
	// Bit CLRPEND7.
	NVIC_NVIC_ICPR_CLRPEND7 = 0x80
	// write: no effect; read: low leakage wakeup interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND7_0 = 0x0
	// write: removes pending state from the low leakage wakeup interrupt; read: low leakage wakeup interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND7_1 = 0x1
	// Position of CLRPEND8 field.
	NVIC_NVIC_ICPR_CLRPEND8_Pos = 0x8
	// Bit mask of CLRPEND8 field.
	NVIC_NVIC_ICPR_CLRPEND8_Msk = 0x100
	// Bit CLRPEND8.
	NVIC_NVIC_ICPR_CLRPEND8 = 0x100
	// write: no effect; read: inter-integrated circuit 0 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND8_0 = 0x0
	// write: removes pending state from the inter-integrated circuit 0 interrupt; read: inter-integrated circuit 0 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND8_1 = 0x1
	// Position of CLRPEND9 field.
	NVIC_NVIC_ICPR_CLRPEND9_Pos = 0x9
	// Bit mask of CLRPEND9 field.
	NVIC_NVIC_ICPR_CLRPEND9_Msk = 0x200
	// Bit CLRPEND9.
	NVIC_NVIC_ICPR_CLRPEND9 = 0x200
	// write: no effect; read: inter-integrated circuit 1 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND9_0 = 0x0
	// write: removes pending state from the inter-integrated circuit 1 interrupt; read: inter-integrated circuit 1 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND9_1 = 0x1
	// Position of CLRPEND10 field.
	NVIC_NVIC_ICPR_CLRPEND10_Pos = 0xa
	// Bit mask of CLRPEND10 field.
	NVIC_NVIC_ICPR_CLRPEND10_Msk = 0x400
	// Bit CLRPEND10.
	NVIC_NVIC_ICPR_CLRPEND10 = 0x400
	// write: no effect; read: serial peripheral interface 0 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND10_0 = 0x0
	// write: removes pending state from the serial peripheral interface 0 interrupt; read: serial peripheral interface 0 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND10_1 = 0x1
	// Position of CLRPEND11 field.
	NVIC_NVIC_ICPR_CLRPEND11_Pos = 0xb
	// Bit mask of CLRPEND11 field.
	NVIC_NVIC_ICPR_CLRPEND11_Msk = 0x800
	// Bit CLRPEND11.
	NVIC_NVIC_ICPR_CLRPEND11 = 0x800
	// write: no effect; read: serial peripheral interface 1 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND11_0 = 0x0
	// write: removes pending state from the serial peripheral interface 1 interrupt; read: serial peripheral interface 1 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND11_1 = 0x1
	// Position of CLRPEND12 field.
	NVIC_NVIC_ICPR_CLRPEND12_Pos = 0xc
	// Bit mask of CLRPEND12 field.
	NVIC_NVIC_ICPR_CLRPEND12_Msk = 0x1000
	// Bit CLRPEND12.
	NVIC_NVIC_ICPR_CLRPEND12 = 0x1000
	// write: no effect; read: UART0 status and error interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND12_0 = 0x0
	// write: removes pending state from the UART0 status and error interrupt; read: UART0 status and error interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND12_1 = 0x1
	// Position of CLRPEND13 field.
	NVIC_NVIC_ICPR_CLRPEND13_Pos = 0xd
	// Bit mask of CLRPEND13 field.
	NVIC_NVIC_ICPR_CLRPEND13_Msk = 0x2000
	// Bit CLRPEND13.
	NVIC_NVIC_ICPR_CLRPEND13 = 0x2000
	// write: no effect; read: UART1 status and error interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND13_0 = 0x0
	// write: removes pending state from the UART1 status and error interrupt; read: UART1 status and error interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND13_1 = 0x1
	// Position of CLRPEND14 field.
	NVIC_NVIC_ICPR_CLRPEND14_Pos = 0xe
	// Bit mask of CLRPEND14 field.
	NVIC_NVIC_ICPR_CLRPEND14_Msk = 0x4000
	// Bit CLRPEND14.
	NVIC_NVIC_ICPR_CLRPEND14 = 0x4000
	// write: no effect; read: UART2 status and error interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND14_0 = 0x0
	// write: removes pending state from the UART2 status and error interrupt; read: UART2 status and error interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND14_1 = 0x1
	// Position of CLRPEND15 field.
	NVIC_NVIC_ICPR_CLRPEND15_Pos = 0xf
	// Bit mask of CLRPEND15 field.
	NVIC_NVIC_ICPR_CLRPEND15_Msk = 0x8000
	// Bit CLRPEND15.
	NVIC_NVIC_ICPR_CLRPEND15 = 0x8000
	// write: no effect; read: Analog-to-digital converter 0 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND15_0 = 0x0
	// write: removes pending state from the Analog-to-digital converter 0 interrupt; read: Analog-to-digital converter 0 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND15_1 = 0x1
	// Position of CLRPEND16 field.
	NVIC_NVIC_ICPR_CLRPEND16_Pos = 0x10
	// Bit mask of CLRPEND16 field.
	NVIC_NVIC_ICPR_CLRPEND16_Msk = 0x10000
	// Bit CLRPEND16.
	NVIC_NVIC_ICPR_CLRPEND16 = 0x10000
	// write: no effect; read: Comparator 0 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND16_0 = 0x0
	// write: removes pending state from the Comparator 0 interrupt; read: Comparator 0 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND16_1 = 0x1
	// Position of CLRPEND17 field.
	NVIC_NVIC_ICPR_CLRPEND17_Pos = 0x11
	// Bit mask of CLRPEND17 field.
	NVIC_NVIC_ICPR_CLRPEND17_Msk = 0x20000
	// Bit CLRPEND17.
	NVIC_NVIC_ICPR_CLRPEND17 = 0x20000
	// write: no effect; read: Timer PWM module 0 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND17_0 = 0x0
	// write: removes pending state from the Timer PWM module 0 interrupt; read: Timer PWM module 0 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND17_1 = 0x1
	// Position of CLRPEND18 field.
	NVIC_NVIC_ICPR_CLRPEND18_Pos = 0x12
	// Bit mask of CLRPEND18 field.
	NVIC_NVIC_ICPR_CLRPEND18_Msk = 0x40000
	// Bit CLRPEND18.
	NVIC_NVIC_ICPR_CLRPEND18 = 0x40000
	// write: no effect; read: Timer PWM module 1 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND18_0 = 0x0
	// write: removes pending state from the Timer PWM module 1 interrupt; read: Timer PWM module 1 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND18_1 = 0x1
	// Position of CLRPEND19 field.
	NVIC_NVIC_ICPR_CLRPEND19_Pos = 0x13
	// Bit mask of CLRPEND19 field.
	NVIC_NVIC_ICPR_CLRPEND19_Msk = 0x80000
	// Bit CLRPEND19.
	NVIC_NVIC_ICPR_CLRPEND19 = 0x80000
	// write: no effect; read: Timer PWM module 2 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND19_0 = 0x0
	// write: removes pending state from the Timer PWM module 2 interrupt; read: Timer PWM module 2 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND19_1 = 0x1
	// Position of CLRPEND20 field.
	NVIC_NVIC_ICPR_CLRPEND20_Pos = 0x14
	// Bit mask of CLRPEND20 field.
	NVIC_NVIC_ICPR_CLRPEND20_Msk = 0x100000
	// Bit CLRPEND20.
	NVIC_NVIC_ICPR_CLRPEND20 = 0x100000
	// write: no effect; read: real time clock alarm interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND20_0 = 0x0
	// write: removes pending state from the real time clock alarm interrupt; read: real time clock alarm interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND20_1 = 0x1
	// Position of CLRPEND21 field.
	NVIC_NVIC_ICPR_CLRPEND21_Pos = 0x15
	// Bit mask of CLRPEND21 field.
	NVIC_NVIC_ICPR_CLRPEND21_Msk = 0x200000
	// Bit CLRPEND21.
	NVIC_NVIC_ICPR_CLRPEND21 = 0x200000
	// write: no effect; read: real time clock seconds interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND21_0 = 0x0
	// write: removes pending state from the real time clock seconds interrupt; read: real time clock seconds interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND21_1 = 0x1
	// Position of CLRPEND22 field.
	NVIC_NVIC_ICPR_CLRPEND22_Pos = 0x16
	// Bit mask of CLRPEND22 field.
	NVIC_NVIC_ICPR_CLRPEND22_Msk = 0x400000
	// Bit CLRPEND22.
	NVIC_NVIC_ICPR_CLRPEND22 = 0x400000
	// write: no effect; read: periodic interrupt timer all channels interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND22_0 = 0x0
	// write: removes pending state from the periodic interrupt timer all channels interrupt; read: periodic interrupt timer all channels interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND22_1 = 0x1
	// Position of CLRPEND23 field.
	NVIC_NVIC_ICPR_CLRPEND23_Pos = 0x17
	// Bit mask of CLRPEND23 field.
	NVIC_NVIC_ICPR_CLRPEND23_Msk = 0x800000
	// Bit CLRPEND23.
	NVIC_NVIC_ICPR_CLRPEND23 = 0x800000
	// write: no effect; read: integrated interchip sound 0 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND23_0 = 0x0
	// write: removes pending state from the integrated interchip sound 0 interrupt; read: integrated interchip sound 0 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND23_1 = 0x1
	// Position of CLRPEND24 field.
	NVIC_NVIC_ICPR_CLRPEND24_Pos = 0x18
	// Bit mask of CLRPEND24 field.
	NVIC_NVIC_ICPR_CLRPEND24_Msk = 0x1000000
	// Bit CLRPEND24.
	NVIC_NVIC_ICPR_CLRPEND24 = 0x1000000
	// write: no effect; read: universal serial bus on the go interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND24_0 = 0x0
	// write: removes pending state from the universal serial bus on the go interrupt; read: universal serial bus on the go interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND24_1 = 0x1
	// Position of CLRPEND25 field.
	NVIC_NVIC_ICPR_CLRPEND25_Pos = 0x19
	// Bit mask of CLRPEND25 field.
	NVIC_NVIC_ICPR_CLRPEND25_Msk = 0x2000000
	// Bit CLRPEND25.
	NVIC_NVIC_ICPR_CLRPEND25 = 0x2000000
	// write: no effect; read: digital-to-analog converter 0 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND25_0 = 0x0
	// write: removes pending state from the digital-to-analog converter 0 interrupt; read: digital-to-analog converter 0 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND25_1 = 0x1
	// Position of CLRPEND26 field.
	NVIC_NVIC_ICPR_CLRPEND26_Pos = 0x1a
	// Bit mask of CLRPEND26 field.
	NVIC_NVIC_ICPR_CLRPEND26_Msk = 0x4000000
	// Bit CLRPEND26.
	NVIC_NVIC_ICPR_CLRPEND26 = 0x4000000
	// write: no effect; read: touch sensing input interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND26_0 = 0x0
	// write: removes pending state from the touch sensing input interrupt; read: touch sensing input interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND26_1 = 0x1
	// Position of CLRPEND27 field.
	NVIC_NVIC_ICPR_CLRPEND27_Pos = 0x1b
	// Bit mask of CLRPEND27 field.
	NVIC_NVIC_ICPR_CLRPEND27_Msk = 0x8000000
	// Bit CLRPEND27.
	NVIC_NVIC_ICPR_CLRPEND27 = 0x8000000
	// write: no effect; read: multipurpose clock generator interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND27_0 = 0x0
	// write: removes pending state from the multipurpose clock generator interrupt; read: multipurpose clock generator interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND27_1 = 0x1
	// Position of CLRPEND28 field.
	NVIC_NVIC_ICPR_CLRPEND28_Pos = 0x1c
	// Bit mask of CLRPEND28 field.
	NVIC_NVIC_ICPR_CLRPEND28_Msk = 0x10000000
	// Bit CLRPEND28.
	NVIC_NVIC_ICPR_CLRPEND28 = 0x10000000
	// write: no effect; read: Low-Power Timer interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND28_0 = 0x0
	// write: removes pending state from the Low-Power Timer interrupt; read: Low-Power Timer interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND28_1 = 0x1
	// Position of CLRPEND29 field.
	NVIC_NVIC_ICPR_CLRPEND29_Pos = 0x1d
	// Bit mask of CLRPEND29 field.
	NVIC_NVIC_ICPR_CLRPEND29_Msk = 0x20000000
	// Bit CLRPEND29.
	NVIC_NVIC_ICPR_CLRPEND29 = 0x20000000
	// write: no effect; read: Reserved iv 45 interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND29_0 = 0x0
	// write: removes pending state from the Reserved iv 45 interrupt; read: Reserved iv 45 interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND29_1 = 0x1
	// Position of CLRPEND30 field.
	NVIC_NVIC_ICPR_CLRPEND30_Pos = 0x1e
	// Bit mask of CLRPEND30 field.
	NVIC_NVIC_ICPR_CLRPEND30_Msk = 0x40000000
	// Bit CLRPEND30.
	NVIC_NVIC_ICPR_CLRPEND30 = 0x40000000
	// write: no effect; read: PORTA pin detect interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND30_0 = 0x0
	// write: removes pending state from the PORTA pin detect interrupt; read: PORTA pin detect interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND30_1 = 0x1
	// Position of CLRPEND31 field.
	NVIC_NVIC_ICPR_CLRPEND31_Pos = 0x1f
	// Bit mask of CLRPEND31 field.
	NVIC_NVIC_ICPR_CLRPEND31_Msk = 0x80000000
	// Bit CLRPEND31.
	NVIC_NVIC_ICPR_CLRPEND31 = 0x80000000
	// write: no effect; read: PORTC and PORTD pin detect interrupt is not pending
	NVIC_NVIC_ICPR_CLRPEND31_0 = 0x0
	// write: removes pending state from the PORTC and PORTD pin detect interrupt; read: PORTC and PORTD pin detect interrupt is pending
	NVIC_NVIC_ICPR_CLRPEND31_1 = 0x1

	// NVIC_IPR0: Interrupt Priority Register 0
	// Position of PRI_0 field.
	NVIC_NVIC_IPR0_PRI_0_Pos = 0x0
	// Bit mask of PRI_0 field.
	NVIC_NVIC_IPR0_PRI_0_Msk = 0xff
	// Position of PRI_1 field.
	NVIC_NVIC_IPR0_PRI_1_Pos = 0x8
	// Bit mask of PRI_1 field.
	NVIC_NVIC_IPR0_PRI_1_Msk = 0xff00
	// Position of PRI_2 field.
	NVIC_NVIC_IPR0_PRI_2_Pos = 0x10
	// Bit mask of PRI_2 field.
	NVIC_NVIC_IPR0_PRI_2_Msk = 0xff0000
	// Position of PRI_3 field.
	NVIC_NVIC_IPR0_PRI_3_Pos = 0x18
	// Bit mask of PRI_3 field.
	NVIC_NVIC_IPR0_PRI_3_Msk = 0xff000000

	// NVIC_IPR1: Interrupt Priority Register 1
	// Position of PRI_4 field.
	NVIC_NVIC_IPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	NVIC_NVIC_IPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	NVIC_NVIC_IPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	NVIC_NVIC_IPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	NVIC_NVIC_IPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	NVIC_NVIC_IPR1_PRI_6_Msk = 0xff0000
	// Position of PRI_7 field.
	NVIC_NVIC_IPR1_PRI_7_Pos = 0x18
	// Bit mask of PRI_7 field.
	NVIC_NVIC_IPR1_PRI_7_Msk = 0xff000000

	// NVIC_IPR2: Interrupt Priority Register 2
	// Position of PRI_8 field.
	NVIC_NVIC_IPR2_PRI_8_Pos = 0x0
	// Bit mask of PRI_8 field.
	NVIC_NVIC_IPR2_PRI_8_Msk = 0xff
	// Position of PRI_9 field.
	NVIC_NVIC_IPR2_PRI_9_Pos = 0x8
	// Bit mask of PRI_9 field.
	NVIC_NVIC_IPR2_PRI_9_Msk = 0xff00
	// Position of PRI_10 field.
	NVIC_NVIC_IPR2_PRI_10_Pos = 0x10
	// Bit mask of PRI_10 field.
	NVIC_NVIC_IPR2_PRI_10_Msk = 0xff0000
	// Position of PRI_11 field.
	NVIC_NVIC_IPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	NVIC_NVIC_IPR2_PRI_11_Msk = 0xff000000

	// NVIC_IPR3: Interrupt Priority Register 3
	// Position of PRI_12 field.
	NVIC_NVIC_IPR3_PRI_12_Pos = 0x0
	// Bit mask of PRI_12 field.
	NVIC_NVIC_IPR3_PRI_12_Msk = 0xff
	// Position of PRI_13 field.
	NVIC_NVIC_IPR3_PRI_13_Pos = 0x8
	// Bit mask of PRI_13 field.
	NVIC_NVIC_IPR3_PRI_13_Msk = 0xff00
	// Position of PRI_14 field.
	NVIC_NVIC_IPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	NVIC_NVIC_IPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	NVIC_NVIC_IPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	NVIC_NVIC_IPR3_PRI_15_Msk = 0xff000000

	// NVIC_IPR4: Interrupt Priority Register 4
	// Position of PRI_16 field.
	NVIC_NVIC_IPR4_PRI_16_Pos = 0x0
	// Bit mask of PRI_16 field.
	NVIC_NVIC_IPR4_PRI_16_Msk = 0xff
	// Position of PRI_17 field.
	NVIC_NVIC_IPR4_PRI_17_Pos = 0x8
	// Bit mask of PRI_17 field.
	NVIC_NVIC_IPR4_PRI_17_Msk = 0xff00
	// Position of PRI_18 field.
	NVIC_NVIC_IPR4_PRI_18_Pos = 0x10
	// Bit mask of PRI_18 field.
	NVIC_NVIC_IPR4_PRI_18_Msk = 0xff0000
	// Position of PRI_19 field.
	NVIC_NVIC_IPR4_PRI_19_Pos = 0x18
	// Bit mask of PRI_19 field.
	NVIC_NVIC_IPR4_PRI_19_Msk = 0xff000000

	// NVIC_IPR5: Interrupt Priority Register 5
	// Position of PRI_20 field.
	NVIC_NVIC_IPR5_PRI_20_Pos = 0x0
	// Bit mask of PRI_20 field.
	NVIC_NVIC_IPR5_PRI_20_Msk = 0xff
	// Position of PRI_21 field.
	NVIC_NVIC_IPR5_PRI_21_Pos = 0x8
	// Bit mask of PRI_21 field.
	NVIC_NVIC_IPR5_PRI_21_Msk = 0xff00
	// Position of PRI_22 field.
	NVIC_NVIC_IPR5_PRI_22_Pos = 0x10
	// Bit mask of PRI_22 field.
	NVIC_NVIC_IPR5_PRI_22_Msk = 0xff0000
	// Position of PRI_23 field.
	NVIC_NVIC_IPR5_PRI_23_Pos = 0x18
	// Bit mask of PRI_23 field.
	NVIC_NVIC_IPR5_PRI_23_Msk = 0xff000000

	// NVIC_IPR6: Interrupt Priority Register 6
	// Position of PRI_24 field.
	NVIC_NVIC_IPR6_PRI_24_Pos = 0x0
	// Bit mask of PRI_24 field.
	NVIC_NVIC_IPR6_PRI_24_Msk = 0xff
	// Position of PRI_25 field.
	NVIC_NVIC_IPR6_PRI_25_Pos = 0x8
	// Bit mask of PRI_25 field.
	NVIC_NVIC_IPR6_PRI_25_Msk = 0xff00
	// Position of PRI_26 field.
	NVIC_NVIC_IPR6_PRI_26_Pos = 0x10
	// Bit mask of PRI_26 field.
	NVIC_NVIC_IPR6_PRI_26_Msk = 0xff0000
	// Position of PRI_27 field.
	NVIC_NVIC_IPR6_PRI_27_Pos = 0x18
	// Bit mask of PRI_27 field.
	NVIC_NVIC_IPR6_PRI_27_Msk = 0xff000000

	// NVIC_IPR7: Interrupt Priority Register 7
	// Position of PRI_28 field.
	NVIC_NVIC_IPR7_PRI_28_Pos = 0x0
	// Bit mask of PRI_28 field.
	NVIC_NVIC_IPR7_PRI_28_Msk = 0xff
	// Position of PRI_29 field.
	NVIC_NVIC_IPR7_PRI_29_Pos = 0x8
	// Bit mask of PRI_29 field.
	NVIC_NVIC_IPR7_PRI_29_Msk = 0xff00
	// Position of PRI_30 field.
	NVIC_NVIC_IPR7_PRI_30_Pos = 0x10
	// Bit mask of PRI_30 field.
	NVIC_NVIC_IPR7_PRI_30_Msk = 0xff0000
	// Position of PRI_31 field.
	NVIC_NVIC_IPR7_PRI_31_Pos = 0x18
	// Bit mask of PRI_31 field.
	NVIC_NVIC_IPR7_PRI_31_Msk = 0xff000000
)

// Constants for MTB: Micro Trace Buffer
const (
	// POSITION: MTB Position Register
	// Position of WRAP field.
	MTB_POSITION_WRAP_Pos = 0x2
	// Bit mask of WRAP field.
	MTB_POSITION_WRAP_Msk = 0x4
	// Bit WRAP.
	MTB_POSITION_WRAP = 0x4
	// Position of POINTER field.
	MTB_POSITION_POINTER_Pos = 0x3
	// Bit mask of POINTER field.
	MTB_POSITION_POINTER_Msk = 0xfffffff8

	// MASTER: MTB Master Register
	// Position of MASK field.
	MTB_MASTER_MASK_Pos = 0x0
	// Bit mask of MASK field.
	MTB_MASTER_MASK_Msk = 0x1f
	// Position of TSTARTEN field.
	MTB_MASTER_TSTARTEN_Pos = 0x5
	// Bit mask of TSTARTEN field.
	MTB_MASTER_TSTARTEN_Msk = 0x20
	// Bit TSTARTEN.
	MTB_MASTER_TSTARTEN = 0x20
	// Position of TSTOPEN field.
	MTB_MASTER_TSTOPEN_Pos = 0x6
	// Bit mask of TSTOPEN field.
	MTB_MASTER_TSTOPEN_Msk = 0x40
	// Bit TSTOPEN.
	MTB_MASTER_TSTOPEN = 0x40
	// Position of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV_Pos = 0x7
	// Bit mask of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV_Msk = 0x80
	// Bit SFRWPRIV.
	MTB_MASTER_SFRWPRIV = 0x80
	// Position of RAMPRIV field.
	MTB_MASTER_RAMPRIV_Pos = 0x8
	// Bit mask of RAMPRIV field.
	MTB_MASTER_RAMPRIV_Msk = 0x100
	// Bit RAMPRIV.
	MTB_MASTER_RAMPRIV = 0x100
	// Position of HALTREQ field.
	MTB_MASTER_HALTREQ_Pos = 0x9
	// Bit mask of HALTREQ field.
	MTB_MASTER_HALTREQ_Msk = 0x200
	// Bit HALTREQ.
	MTB_MASTER_HALTREQ = 0x200
	// Position of EN field.
	MTB_MASTER_EN_Pos = 0x1f
	// Bit mask of EN field.
	MTB_MASTER_EN_Msk = 0x80000000
	// Bit EN.
	MTB_MASTER_EN = 0x80000000

	// FLOW: MTB Flow Register
	// Position of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP_Pos = 0x0
	// Bit mask of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP_Msk = 0x1
	// Bit AUTOSTOP.
	MTB_FLOW_AUTOSTOP = 0x1
	// Position of AUTOHALT field.
	MTB_FLOW_AUTOHALT_Pos = 0x1
	// Bit mask of AUTOHALT field.
	MTB_FLOW_AUTOHALT_Msk = 0x2
	// Bit AUTOHALT.
	MTB_FLOW_AUTOHALT = 0x2
	// Position of WATERMARK field.
	MTB_FLOW_WATERMARK_Pos = 0x3
	// Bit mask of WATERMARK field.
	MTB_FLOW_WATERMARK_Msk = 0xfffffff8

	// BASE: MTB Base Register
	// Position of BASEADDR field.
	MTB_BASE_BASEADDR_Pos = 0x0
	// Bit mask of BASEADDR field.
	MTB_BASE_BASEADDR_Msk = 0xffffffff

	// MODECTRL: Integration Mode Control Register
	// Position of MODECTRL field.
	MTB_MODECTRL_MODECTRL_Pos = 0x0
	// Bit mask of MODECTRL field.
	MTB_MODECTRL_MODECTRL_Msk = 0xffffffff

	// TAGSET: Claim TAG Set Register
	// Position of TAGSET field.
	MTB_TAGSET_TAGSET_Pos = 0x0
	// Bit mask of TAGSET field.
	MTB_TAGSET_TAGSET_Msk = 0xffffffff

	// TAGCLEAR: Claim TAG Clear Register
	// Position of TAGCLEAR field.
	MTB_TAGCLEAR_TAGCLEAR_Pos = 0x0
	// Bit mask of TAGCLEAR field.
	MTB_TAGCLEAR_TAGCLEAR_Msk = 0xffffffff

	// LOCKACCESS: Lock Access Register
	// Position of LOCKACCESS field.
	MTB_LOCKACCESS_LOCKACCESS_Pos = 0x0
	// Bit mask of LOCKACCESS field.
	MTB_LOCKACCESS_LOCKACCESS_Msk = 0xffffffff

	// LOCKSTAT: Lock Status Register
	// Position of LOCKSTAT field.
	MTB_LOCKSTAT_LOCKSTAT_Pos = 0x0
	// Bit mask of LOCKSTAT field.
	MTB_LOCKSTAT_LOCKSTAT_Msk = 0xffffffff

	// AUTHSTAT: Authentication Status Register
	// Position of BIT0 field.
	MTB_AUTHSTAT_BIT0_Pos = 0x0
	// Bit mask of BIT0 field.
	MTB_AUTHSTAT_BIT0_Msk = 0x1
	// Bit BIT0.
	MTB_AUTHSTAT_BIT0 = 0x1
	// Position of BIT1 field.
	MTB_AUTHSTAT_BIT1_Pos = 0x1
	// Bit mask of BIT1 field.
	MTB_AUTHSTAT_BIT1_Msk = 0x2
	// Bit BIT1.
	MTB_AUTHSTAT_BIT1 = 0x2
	// Position of BIT2 field.
	MTB_AUTHSTAT_BIT2_Pos = 0x2
	// Bit mask of BIT2 field.
	MTB_AUTHSTAT_BIT2_Msk = 0x4
	// Bit BIT2.
	MTB_AUTHSTAT_BIT2 = 0x4
	// Position of BIT3 field.
	MTB_AUTHSTAT_BIT3_Pos = 0x3
	// Bit mask of BIT3 field.
	MTB_AUTHSTAT_BIT3_Msk = 0x8
	// Bit BIT3.
	MTB_AUTHSTAT_BIT3 = 0x8

	// DEVICEARCH: Device Architecture Register
	// Position of DEVICEARCH field.
	MTB_DEVICEARCH_DEVICEARCH_Pos = 0x0
	// Bit mask of DEVICEARCH field.
	MTB_DEVICEARCH_DEVICEARCH_Msk = 0xffffffff

	// DEVICECFG: Device Configuration Register
	// Position of DEVICECFG field.
	MTB_DEVICECFG_DEVICECFG_Pos = 0x0
	// Bit mask of DEVICECFG field.
	MTB_DEVICECFG_DEVICECFG_Msk = 0xffffffff

	// DEVICETYPID: Device Type Identifier Register
	// Position of DEVICETYPID field.
	MTB_DEVICETYPID_DEVICETYPID_Pos = 0x0
	// Bit mask of DEVICETYPID field.
	MTB_DEVICETYPID_DEVICETYPID_Msk = 0xffffffff

	// PERIPHID4: Peripheral ID Register
	// Position of PERIPHID field.
	MTB_PERIPHID_PERIPHID_Pos = 0x0
	// Bit mask of PERIPHID field.
	MTB_PERIPHID_PERIPHID_Msk = 0xffffffff

	// COMPID0: Component ID Register
	// Position of COMPID field.
	MTB_COMPID_COMPID_Pos = 0x0
	// Bit mask of COMPID field.
	MTB_COMPID_COMPID_Msk = 0xffffffff
)

// Constants for MTBDWT: MTB data watchpoint and trace
const (
	// CTRL: MTB DWT Control Register
	// Position of DWTCFGCTRL field.
	MTBDWT_CTRL_DWTCFGCTRL_Pos = 0x0
	// Bit mask of DWTCFGCTRL field.
	MTBDWT_CTRL_DWTCFGCTRL_Msk = 0xfffffff
	// Position of NUMCMP field.
	MTBDWT_CTRL_NUMCMP_Pos = 0x1c
	// Bit mask of NUMCMP field.
	MTBDWT_CTRL_NUMCMP_Msk = 0xf0000000

	// COMP0: MTB_DWT Comparator Register
	// Position of COMP field.
	MTBDWT_COMP_COMP_Pos = 0x0
	// Bit mask of COMP field.
	MTBDWT_COMP_COMP_Msk = 0xffffffff

	// MASK0: MTB_DWT Comparator Mask Register
	// Position of MASK field.
	MTBDWT_MASK_MASK_Pos = 0x0
	// Bit mask of MASK field.
	MTBDWT_MASK_MASK_Msk = 0x1f

	// FCT0: MTB_DWT Comparator Function Register 0
	// Position of FUNCTION field.
	MTBDWT_FCT0_FUNCTION_Pos = 0x0
	// Bit mask of FUNCTION field.
	MTBDWT_FCT0_FUNCTION_Msk = 0xf
	// Disabled.
	MTBDWT_FCT0_FUNCTION_0000 = 0x0
	// Instruction fetch.
	MTBDWT_FCT0_FUNCTION_0100 = 0x4
	// Data operand read.
	MTBDWT_FCT0_FUNCTION_0101 = 0x5
	// Data operand write.
	MTBDWT_FCT0_FUNCTION_0110 = 0x6
	// Data operand (read + write).
	MTBDWT_FCT0_FUNCTION_0111 = 0x7
	// Position of DATAVMATCH field.
	MTBDWT_FCT0_DATAVMATCH_Pos = 0x8
	// Bit mask of DATAVMATCH field.
	MTBDWT_FCT0_DATAVMATCH_Msk = 0x100
	// Bit DATAVMATCH.
	MTBDWT_FCT0_DATAVMATCH = 0x100
	// Perform address comparison.
	MTBDWT_FCT0_DATAVMATCH_0 = 0x0
	// Perform data value comparison.
	MTBDWT_FCT0_DATAVMATCH_1 = 0x1
	// Position of DATAVSIZE field.
	MTBDWT_FCT0_DATAVSIZE_Pos = 0xa
	// Bit mask of DATAVSIZE field.
	MTBDWT_FCT0_DATAVSIZE_Msk = 0xc00
	// Byte.
	MTBDWT_FCT0_DATAVSIZE_00 = 0x0
	// Halfword.
	MTBDWT_FCT0_DATAVSIZE_01 = 0x1
	// Word.
	MTBDWT_FCT0_DATAVSIZE_10 = 0x2
	// Reserved. Any attempts to use this value results in UNPREDICTABLE behavior.
	MTBDWT_FCT0_DATAVSIZE_11 = 0x3
	// Position of DATAVADDR0 field.
	MTBDWT_FCT0_DATAVADDR0_Pos = 0xc
	// Bit mask of DATAVADDR0 field.
	MTBDWT_FCT0_DATAVADDR0_Msk = 0xf000
	// Position of MATCHED field.
	MTBDWT_FCT0_MATCHED_Pos = 0x18
	// Bit mask of MATCHED field.
	MTBDWT_FCT0_MATCHED_Msk = 0x1000000
	// Bit MATCHED.
	MTBDWT_FCT0_MATCHED = 0x1000000
	// No match.
	MTBDWT_FCT0_MATCHED_0 = 0x0
	// Match occurred.
	MTBDWT_FCT0_MATCHED_1 = 0x1

	// FCT1: MTB_DWT Comparator Function Register 1
	// Position of FUNCTION field.
	MTBDWT_FCT1_FUNCTION_Pos = 0x0
	// Bit mask of FUNCTION field.
	MTBDWT_FCT1_FUNCTION_Msk = 0xf
	// Disabled.
	MTBDWT_FCT1_FUNCTION_0000 = 0x0
	// Instruction fetch.
	MTBDWT_FCT1_FUNCTION_0100 = 0x4
	// Data operand read.
	MTBDWT_FCT1_FUNCTION_0101 = 0x5
	// Data operand write.
	MTBDWT_FCT1_FUNCTION_0110 = 0x6
	// Data operand (read + write).
	MTBDWT_FCT1_FUNCTION_0111 = 0x7
	// Position of MATCHED field.
	MTBDWT_FCT1_MATCHED_Pos = 0x18
	// Bit mask of MATCHED field.
	MTBDWT_FCT1_MATCHED_Msk = 0x1000000
	// Bit MATCHED.
	MTBDWT_FCT1_MATCHED = 0x1000000
	// No match.
	MTBDWT_FCT1_MATCHED_0 = 0x0
	// Match occurred.
	MTBDWT_FCT1_MATCHED_1 = 0x1

	// TBCTRL: MTB_DWT Trace Buffer Control Register
	// Position of ACOMP0 field.
	MTBDWT_TBCTRL_ACOMP0_Pos = 0x0
	// Bit mask of ACOMP0 field.
	MTBDWT_TBCTRL_ACOMP0_Msk = 0x1
	// Bit ACOMP0.
	MTBDWT_TBCTRL_ACOMP0 = 0x1
	// Trigger TSTOP based on the assertion of MTBDWT_FCT0[MATCHED].
	MTBDWT_TBCTRL_ACOMP0_0 = 0x0
	// Trigger TSTART based on the assertion of MTBDWT_FCT0[MATCHED].
	MTBDWT_TBCTRL_ACOMP0_1 = 0x1
	// Position of ACOMP1 field.
	MTBDWT_TBCTRL_ACOMP1_Pos = 0x1
	// Bit mask of ACOMP1 field.
	MTBDWT_TBCTRL_ACOMP1_Msk = 0x2
	// Bit ACOMP1.
	MTBDWT_TBCTRL_ACOMP1 = 0x2
	// Trigger TSTOP based on the assertion of MTBDWT_FCT1[MATCHED].
	MTBDWT_TBCTRL_ACOMP1_0 = 0x0
	// Trigger TSTART based on the assertion of MTBDWT_FCT1[MATCHED].
	MTBDWT_TBCTRL_ACOMP1_1 = 0x1
	// Position of NUMCOMP field.
	MTBDWT_TBCTRL_NUMCOMP_Pos = 0x1c
	// Bit mask of NUMCOMP field.
	MTBDWT_TBCTRL_NUMCOMP_Msk = 0xf0000000

	// DEVICECFG: Device Configuration Register
	// Position of DEVICECFG field.
	MTBDWT_DEVICECFG_DEVICECFG_Pos = 0x0
	// Bit mask of DEVICECFG field.
	MTBDWT_DEVICECFG_DEVICECFG_Msk = 0xffffffff

	// DEVICETYPID: Device Type Identifier Register
	// Position of DEVICETYPID field.
	MTBDWT_DEVICETYPID_DEVICETYPID_Pos = 0x0
	// Bit mask of DEVICETYPID field.
	MTBDWT_DEVICETYPID_DEVICETYPID_Msk = 0xffffffff

	// PERIPHID4: Peripheral ID Register
	// Position of PERIPHID field.
	MTBDWT_PERIPHID_PERIPHID_Pos = 0x0
	// Bit mask of PERIPHID field.
	MTBDWT_PERIPHID_PERIPHID_Msk = 0xffffffff

	// COMPID0: Component ID Register
	// Position of COMPID field.
	MTBDWT_COMPID_COMPID_Pos = 0x0
	// Bit mask of COMPID field.
	MTBDWT_COMPID_COMPID_Msk = 0xffffffff
)

// Constants for ROM: System ROM
const (
	// ENTRY0: Entry
	// Position of ENTRY field.
	ROM_ENTRY_ENTRY_Pos = 0x0
	// Bit mask of ENTRY field.
	ROM_ENTRY_ENTRY_Msk = 0xffffffff

	// TABLEMARK: End of Table Marker Register
	// Position of MARK field.
	ROM_TABLEMARK_MARK_Pos = 0x0
	// Bit mask of MARK field.
	ROM_TABLEMARK_MARK_Msk = 0xffffffff

	// SYSACCESS: System Access Register
	// Position of SYSACCESS field.
	ROM_SYSACCESS_SYSACCESS_Pos = 0x0
	// Bit mask of SYSACCESS field.
	ROM_SYSACCESS_SYSACCESS_Msk = 0xffffffff

	// PERIPHID4: Peripheral ID Register
	// Position of PERIPHID field.
	ROM_PERIPHID_PERIPHID_Pos = 0x0
	// Bit mask of PERIPHID field.
	ROM_PERIPHID_PERIPHID_Msk = 0xffffffff

	// COMPID0: Component ID Register
	// Position of COMPID field.
	ROM_COMPID_COMPID_Pos = 0x0
	// Bit mask of COMPID field.
	ROM_COMPID_COMPID_Msk = 0xffffffff
)

// Constants for MCM: Core Platform Miscellaneous Control Module
const (
	// PLASC: Crossbar Switch (AXBS) Slave Configuration
	// Position of ASC field.
	MCM_PLASC_ASC_Pos = 0x0
	// Bit mask of ASC field.
	MCM_PLASC_ASC_Msk = 0xff
	// A bus slave connection to AXBS input port n is absent.
	MCM_PLASC_ASC_0 = 0x0
	// A bus slave connection to AXBS input port n is present.
	MCM_PLASC_ASC_1 = 0x1

	// PLAMC: Crossbar Switch (AXBS) Master Configuration
	// Position of AMC field.
	MCM_PLAMC_AMC_Pos = 0x0
	// Bit mask of AMC field.
	MCM_PLAMC_AMC_Msk = 0xff
	// A bus master connection to AXBS input port n is absent
	MCM_PLAMC_AMC_0 = 0x0
	// A bus master connection to AXBS input port n is present
	MCM_PLAMC_AMC_1 = 0x1

	// PLACR: Platform Control Register
	// Position of ARB field.
	MCM_PLACR_ARB_Pos = 0x9
	// Bit mask of ARB field.
	MCM_PLACR_ARB_Msk = 0x200
	// Bit ARB.
	MCM_PLACR_ARB = 0x200
	// Fixed-priority arbitration for the crossbar masters
	MCM_PLACR_ARB_0 = 0x0
	// Round-robin arbitration for the crossbar masters
	MCM_PLACR_ARB_1 = 0x1
	// Position of CFCC field.
	MCM_PLACR_CFCC_Pos = 0xa
	// Bit mask of CFCC field.
	MCM_PLACR_CFCC_Msk = 0x400
	// Bit CFCC.
	MCM_PLACR_CFCC = 0x400
	// Position of DFCDA field.
	MCM_PLACR_DFCDA_Pos = 0xb
	// Bit mask of DFCDA field.
	MCM_PLACR_DFCDA_Msk = 0x800
	// Bit DFCDA.
	MCM_PLACR_DFCDA = 0x800
	// Enable flash controller data caching
	MCM_PLACR_DFCDA_0 = 0x0
	// Disable flash controller data caching.
	MCM_PLACR_DFCDA_1 = 0x1
	// Position of DFCIC field.
	MCM_PLACR_DFCIC_Pos = 0xc
	// Bit mask of DFCIC field.
	MCM_PLACR_DFCIC_Msk = 0x1000
	// Bit DFCIC.
	MCM_PLACR_DFCIC = 0x1000
	// Enable flash controller instruction caching.
	MCM_PLACR_DFCIC_0 = 0x0
	// Disable flash controller instruction caching.
	MCM_PLACR_DFCIC_1 = 0x1
	// Position of DFCC field.
	MCM_PLACR_DFCC_Pos = 0xd
	// Bit mask of DFCC field.
	MCM_PLACR_DFCC_Msk = 0x2000
	// Bit DFCC.
	MCM_PLACR_DFCC = 0x2000
	// Enable flash controller cache.
	MCM_PLACR_DFCC_0 = 0x0
	// Disable flash controller cache.
	MCM_PLACR_DFCC_1 = 0x1
	// Position of EFDS field.
	MCM_PLACR_EFDS_Pos = 0xe
	// Bit mask of EFDS field.
	MCM_PLACR_EFDS_Msk = 0x4000
	// Bit EFDS.
	MCM_PLACR_EFDS = 0x4000
	// Disable flash data speculation.
	MCM_PLACR_EFDS_0 = 0x0
	// Enable flash data speculation.
	MCM_PLACR_EFDS_1 = 0x1
	// Position of DFCS field.
	MCM_PLACR_DFCS_Pos = 0xf
	// Bit mask of DFCS field.
	MCM_PLACR_DFCS_Msk = 0x8000
	// Bit DFCS.
	MCM_PLACR_DFCS = 0x8000
	// Enable flash controller speculation.
	MCM_PLACR_DFCS_0 = 0x0
	// Disable flash controller speculation.
	MCM_PLACR_DFCS_1 = 0x1
	// Position of ESFC field.
	MCM_PLACR_ESFC_Pos = 0x10
	// Bit mask of ESFC field.
	MCM_PLACR_ESFC_Msk = 0x10000
	// Bit ESFC.
	MCM_PLACR_ESFC = 0x10000
	// Disable stalling flash controller when flash is busy.
	MCM_PLACR_ESFC_0 = 0x0
	// Enable stalling flash controller when flash is busy.
	MCM_PLACR_ESFC_1 = 0x1

	// CPO: Compute Operation Control Register
	// Position of CPOREQ field.
	MCM_CPO_CPOREQ_Pos = 0x0
	// Bit mask of CPOREQ field.
	MCM_CPO_CPOREQ_Msk = 0x1
	// Bit CPOREQ.
	MCM_CPO_CPOREQ = 0x1
	// Request is cleared.
	MCM_CPO_CPOREQ_0 = 0x0
	// Request Compute Operation.
	MCM_CPO_CPOREQ_1 = 0x1
	// Position of CPOACK field.
	MCM_CPO_CPOACK_Pos = 0x1
	// Bit mask of CPOACK field.
	MCM_CPO_CPOACK_Msk = 0x2
	// Bit CPOACK.
	MCM_CPO_CPOACK = 0x2
	// Compute operation entry has not completed or compute operation exit has completed.
	MCM_CPO_CPOACK_0 = 0x0
	// Compute operation entry has completed or compute operation exit has not completed.
	MCM_CPO_CPOACK_1 = 0x1
	// Position of CPOWOI field.
	MCM_CPO_CPOWOI_Pos = 0x2
	// Bit mask of CPOWOI field.
	MCM_CPO_CPOWOI_Msk = 0x4
	// Bit CPOWOI.
	MCM_CPO_CPOWOI = 0x4
	// No effect.
	MCM_CPO_CPOWOI_0 = 0x0
	// When set, the CPOREQ is cleared on any interrupt or exception vector fetch.
	MCM_CPO_CPOWOI_1 = 0x1
)

// Constants for FGPIOA: General Purpose Input/Output
const (
	// PDOR: Port Data Output Register
	// Position of PDO field.
	FGPIO_PDOR_PDO_Pos = 0x0
	// Bit mask of PDO field.
	FGPIO_PDOR_PDO_Msk = 0xffffffff
	// Logic level 0 is driven on pin, provided pin is configured for general-purpose output.
	FGPIO_PDOR_PDO_0 = 0x0
	// Logic level 1 is driven on pin, provided pin is configured for general-purpose output.
	FGPIO_PDOR_PDO_1 = 0x1

	// PSOR: Port Set Output Register
	// Position of PTSO field.
	FGPIO_PSOR_PTSO_Pos = 0x0
	// Bit mask of PTSO field.
	FGPIO_PSOR_PTSO_Msk = 0xffffffff
	// Corresponding bit in PDORn does not change.
	FGPIO_PSOR_PTSO_0 = 0x0
	// Corresponding bit in PDORn is set to logic 1.
	FGPIO_PSOR_PTSO_1 = 0x1

	// PCOR: Port Clear Output Register
	// Position of PTCO field.
	FGPIO_PCOR_PTCO_Pos = 0x0
	// Bit mask of PTCO field.
	FGPIO_PCOR_PTCO_Msk = 0xffffffff
	// Corresponding bit in PDORn does not change.
	FGPIO_PCOR_PTCO_0 = 0x0
	// Corresponding bit in PDORn is cleared to logic 0.
	FGPIO_PCOR_PTCO_1 = 0x1

	// PTOR: Port Toggle Output Register
	// Position of PTTO field.
	FGPIO_PTOR_PTTO_Pos = 0x0
	// Bit mask of PTTO field.
	FGPIO_PTOR_PTTO_Msk = 0xffffffff
	// Corresponding bit in PDORn does not change.
	FGPIO_PTOR_PTTO_0 = 0x0
	// Corresponding bit in PDORn is set to the inverse of its existing logic state.
	FGPIO_PTOR_PTTO_1 = 0x1

	// PDIR: Port Data Input Register
	// Position of PDI field.
	FGPIO_PDIR_PDI_Pos = 0x0
	// Bit mask of PDI field.
	FGPIO_PDIR_PDI_Msk = 0xffffffff
	// Pin logic level is logic 0, or is not configured for use by digital function.
	FGPIO_PDIR_PDI_0 = 0x0
	// Pin logic level is logic 1.
	FGPIO_PDIR_PDI_1 = 0x1

	// PDDR: Port Data Direction Register
	// Position of PDD field.
	FGPIO_PDDR_PDD_Pos = 0x0
	// Bit mask of PDD field.
	FGPIO_PDDR_PDD_Msk = 0xffffffff
	// Pin is configured as general-purpose input, for the GPIO function.
	FGPIO_PDDR_PDD_0 = 0x0
	// Pin is configured as general-purpose output, for the GPIO function.
	FGPIO_PDDR_PDD_1 = 0x1
)
