/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.print.Pageable;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.actions.Openable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.text.Annotation;
import org.openide.text.BackwardPosition;
import org.openide.text.Bundle;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DefaultPrintable;
import org.openide.text.Line;
import org.openide.text.UndoRedoManager;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.UserQuestionException;

public final class NbDocument {
    public static final Object GUARDED = new AttributeSet.CharacterAttribute(){};
    private static final SimpleAttributeSet ATTR_ADD = new SimpleAttributeSet();
    private static final SimpleAttributeSet ATTR_REMOVE = new SimpleAttributeSet();
    @Deprecated
    public static final String BREAKPOINT_STYLE_NAME = "NbBreakpointStyle";
    @Deprecated
    public static final String ERROR_STYLE_NAME = "NbErrorStyle";
    @Deprecated
    public static final String CURRENT_STYLE_NAME = "NbCurrentStyle";
    @Deprecated
    public static final String NORMAL_STYLE_NAME = "NbNormalStyle";

    private NbDocument() {
    }

    public static Element findLineRootElement(StyledDocument styledDocument) {
        NbDocument.checkDocParameter(styledDocument);
        Element element = styledDocument.getParagraphElement(0).getParentElement();
        if (element == null) {
            element = styledDocument.getDefaultRootElement();
        }
        return element;
    }

    public static int findLineNumber(StyledDocument styledDocument, int n) {
        return new DocumentRenderer(0, styledDocument, n).renderToInt();
    }

    public static int findLineColumn(StyledDocument styledDocument, int n) {
        return new DocumentRenderer(1, styledDocument, n).renderToInt();
    }

    public static int findLineOffset(StyledDocument styledDocument, int n) {
        return new DocumentRenderer(2, styledDocument, n).renderToInt();
    }

    public static Position createPosition(Document document, int n, Position.Bias bias) throws BadLocationException {
        NbDocument.checkDocParameter(document);
        if (document instanceof PositionBiasable) {
            return ((PositionBiasable)document).createPosition(n, bias);
        }
        if (bias == Position.Bias.Forward) {
            return document.createPosition(n);
        }
        return BackwardPosition.create(document, n);
    }

    public static void markGuarded(StyledDocument styledDocument, int n, int n2) {
        NbDocument.checkDocParameter(styledDocument);
        styledDocument.setCharacterAttributes(n, n2, ATTR_ADD, false);
    }

    public static void unmarkGuarded(StyledDocument styledDocument, int n, int n2) {
        NbDocument.checkDocParameter(styledDocument);
        styledDocument.setCharacterAttributes(n, n2, ATTR_REMOVE, false);
    }

    public static void insertGuarded(StyledDocument styledDocument, int n, String string) throws BadLocationException {
        NbDocument.checkDocParameter(styledDocument);
        styledDocument.insertString(n, string, ATTR_ADD);
    }

    @Deprecated
    public static void markBreakpoint(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(BREAKPOINT_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(BREAKPOINT_STYLE_NAME, null);
            if (style == null) {
                return;
            }
            style.addAttribute(StyleConstants.ColorConstants.Background, Color.red);
            style.addAttribute(StyleConstants.ColorConstants.Foreground, Color.white);
        }
        styledDocument.setLogicalStyle(n, style);
    }

    @Deprecated
    public static void markError(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(ERROR_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(ERROR_STYLE_NAME, null);
            if (style == null) {
                return;
            }
            style.addAttribute(StyleConstants.ColorConstants.Background, Color.green);
            style.addAttribute(StyleConstants.ColorConstants.Foreground, Color.black);
        }
        styledDocument.setLogicalStyle(n, style);
    }

    @Deprecated
    public static void markCurrent(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(CURRENT_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(CURRENT_STYLE_NAME, null);
            if (style == null) {
                return;
            }
            style.addAttribute(StyleConstants.ColorConstants.Background, Color.blue);
            style.addAttribute(StyleConstants.ColorConstants.Foreground, Color.white);
        }
        styledDocument.setLogicalStyle(n, style);
    }

    @Deprecated
    public static void markNormal(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(NORMAL_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(NORMAL_STYLE_NAME, null);
        }
        if (style != null) {
            styledDocument.setLogicalStyle(n, style);
        }
    }

    public static JEditorPane findRecentEditorPane(EditorCookie editorCookie) {
        assert (SwingUtilities.isEventDispatchThread()) : "NbDocument.findInitializedPaneForActiveTC must be called from AWT thread only";
        if (editorCookie instanceof CloneableEditorSupport) {
            JEditorPane jEditorPane = ((CloneableEditorSupport)((Object)editorCookie)).getRecentPane();
            return jEditorPane;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray != null) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAtomic(StyledDocument styledDocument, Runnable runnable) {
        NbDocument.checkDocParameter(styledDocument);
        if (styledDocument instanceof WriteLockable) {
            ((WriteLockable)((Object)styledDocument)).runAtomic(runnable);
        } else {
            StyledDocument styledDocument2 = styledDocument;
            synchronized (styledDocument2) {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAtomicAsUser(StyledDocument styledDocument, Runnable runnable) throws BadLocationException {
        NbDocument.checkDocParameter(styledDocument);
        if (styledDocument instanceof WriteLockable) {
            ((WriteLockable)((Object)styledDocument)).runAtomicAsUser(runnable);
        } else {
            StyledDocument styledDocument2 = styledDocument;
            synchronized (styledDocument2) {
                runnable.run();
            }
        }
    }

    private static void checkDocParameter(Document document) {
        if (document == null) {
            throw new NullPointerException("Invalid doc parameter. Document may not be null!");
        }
    }

    public static Object findPageable(StyledDocument styledDocument) {
        if (styledDocument instanceof Pageable) {
            return styledDocument;
        }
        if (styledDocument instanceof java.awt.print.Printable) {
            return styledDocument;
        }
        return new DefaultPrintable(styledDocument);
    }

    public static void addAnnotation(StyledDocument styledDocument, Position position, int n, Annotation annotation) {
        if (!(styledDocument instanceof Annotatable)) {
            return;
        }
        ((Annotatable)((Object)styledDocument)).addAnnotation(position, n, annotation);
    }

    public static void removeAnnotation(StyledDocument styledDocument, Annotation annotation) {
        if (!(styledDocument instanceof Annotatable)) {
            return;
        }
        ((Annotatable)((Object)styledDocument)).removeAnnotation(annotation);
    }

    public static <T extends UndoableEdit> T getEditToBeUndoneOfType(EditorCookie editorCookie, Class<T> clazz) {
        return NbDocument.getEditToBeUndoneRedoneOfType(editorCookie, clazz, false);
    }

    public static <T extends UndoableEdit> T getEditToBeRedoneOfType(EditorCookie editorCookie, Class<T> clazz) {
        return NbDocument.getEditToBeUndoneRedoneOfType(editorCookie, clazz, true);
    }

    private static <T extends UndoableEdit> T getEditToBeUndoneRedoneOfType(EditorCookie editorCookie, Class<T> clazz, boolean bl) {
        UndoRedo.Manager manager;
        if (editorCookie instanceof CloneableEditorSupport && (manager = ((CloneableEditorSupport)((Object)editorCookie)).getUndoRedo()) instanceof UndoRedoManager) {
            UndoRedoManager undoRedoManager = (UndoRedoManager)manager;
            UndoableEdit undoableEdit = undoRedoManager.editToBeUndoneRedone(bl);
            if (clazz.isInstance(undoableEdit)) {
                return (T)((UndoableEdit)clazz.cast(undoableEdit));
            }
            if (undoableEdit instanceof List) {
                List list = (List)((Object)undoableEdit);
                for (int i = list.size() - 1; i >= 0; --i) {
                    undoableEdit = (UndoableEdit)list.get(i);
                    if (!clazz.isInstance(undoableEdit)) continue;
                    UndoableEdit undoableEdit2 = undoableEdit;
                    return (T)undoableEdit2;
                }
            }
        }
        return null;
    }

    public static StyledDocument getDocument(Lookup.Provider provider) {
        block5: {
            try {
                EditorCookie editorCookie = (EditorCookie)provider.getLookup().lookup(EditorCookie.class);
                if (editorCookie == null) break block5;
                StyledDocument styledDocument = null;
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (UserQuestionException userQuestionException) {
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), Bundle.TXT_Question(), 0));
                    if (object != NotifyDescriptor.YES_OPTION) {
                        return null;
                    }
                    userQuestionException.confirmed();
                    styledDocument = editorCookie.openDocument();
                }
                return styledDocument;
            }
            catch (IOException iOException) {
                Logger.getLogger(NbDocument.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
        return null;
    }

    public static boolean openDocument(Lookup.Provider provider, int n, Line.ShowOpenType showOpenType, Line.ShowVisibilityType showVisibilityType) {
        StyledDocument styledDocument;
        assert (provider != null);
        LineCookie lineCookie = (LineCookie)provider.getLookup().lookup(LineCookie.class);
        if (lineCookie != null && n != -1 && (styledDocument = NbDocument.getDocument(provider)) != null) {
            int n2 = NbDocument.findLineNumber(styledDocument, n);
            int n3 = NbDocument.findLineColumn(styledDocument, n);
            Line line = null;
            try {
                line = lineCookie.getLineSet().getCurrent(n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                line = lineCookie.getLineSet().getCurrent(0);
            }
            if (line != null) {
                NbDocument.doShow(line, n3, showOpenType, showVisibilityType);
                return true;
            }
        }
        if ((styledDocument = (Openable)provider.getLookup().lookup(Openable.class)) != null) {
            NbDocument.doOpen((Openable)styledDocument);
            return true;
        }
        return false;
    }

    public static boolean openDocument(Lookup.Provider provider, int n, int n2, Line.ShowOpenType showOpenType, Line.ShowVisibilityType showVisibilityType) {
        Object object;
        assert (provider != null);
        LineCookie lineCookie = (LineCookie)provider.getLookup().lookup(LineCookie.class);
        if (lineCookie != null && n >= 0 && n2 >= -1 && (object = NbDocument.getDocument(provider)) != null) {
            Line line = null;
            try {
                line = lineCookie.getLineSet().getCurrent(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                line = lineCookie.getLineSet().getCurrent(0);
            }
            if (line != null) {
                NbDocument.doShow(line, n2, showOpenType, showVisibilityType);
                return true;
            }
        }
        if ((object = (Openable)provider.getLookup().lookup(Openable.class)) != null) {
            NbDocument.doOpen(object);
            return true;
        }
        return false;
    }

    private static void doShow(final Line line, final int n, final Line.ShowOpenType showOpenType, final Line.ShowVisibilityType showVisibilityType) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                line.show(showOpenType, showVisibilityType, n);
            }
        });
    }

    private static void doOpen(final Openable openable) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                openable.open();
            }
        });
    }

    static {
        ATTR_ADD.addAttribute(GUARDED, Boolean.TRUE);
        ATTR_REMOVE.addAttribute(GUARDED, Boolean.FALSE);
    }

    private static final class DocumentRenderer
    implements Runnable {
        private static final int FIND_LINE_NUMBER = 0;
        private static final int FIND_LINE_COLUMN = 1;
        private static final int FIND_LINE_OFFSET = 2;
        private StyledDocument doc;
        private int opCode;
        private int argInt;
        private int retInt;

        DocumentRenderer(int n, StyledDocument styledDocument, int n2) {
            this.opCode = n;
            this.doc = styledDocument;
            this.argInt = n2;
        }

        int renderToInt() {
            if (this.doc != null) {
                this.doc.render(this);
            }
            return this.retInt;
        }

        @Override
        public void run() {
            switch (this.opCode) {
                case 0: {
                    Element element = NbDocument.findLineRootElement(this.doc);
                    this.retInt = element.getElementIndex(this.argInt);
                    break;
                }
                case 1: {
                    Element element = NbDocument.findLineRootElement(this.doc);
                    int n = element.getElementIndex(this.argInt);
                    this.retInt = this.argInt - element.getElement(n).getStartOffset();
                    break;
                }
                case 2: {
                    Element element = NbDocument.findLineRootElement(this.doc);
                    Element element2 = element.getElement(this.argInt);
                    if (element2 == null) {
                        throw new IndexOutOfBoundsException("Index=" + this.argInt + " is out of bounds.");
                    }
                    this.retInt = element2.getStartOffset();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static interface Annotatable
    extends Document {
        public void addAnnotation(Position var1, int var2, Annotation var3);

        public void removeAnnotation(Annotation var1);
    }

    public static interface CustomToolbar
    extends Document {
        public JToolBar createToolbar(JEditorPane var1);
    }

    public static interface CustomEditor
    extends Document {
        public Component createEditor(JEditorPane var1);
    }

    public static interface PositionBiasable
    extends Document {
        public Position createPosition(int var1, Position.Bias var2) throws BadLocationException;
    }

    public static interface Printable
    extends Document {
        public AttributedCharacterIterator[] createPrintIterators();
    }

    public static interface WriteLockable
    extends Document {
        public void runAtomic(Runnable var1);

        public void runAtomicAsUser(Runnable var1) throws BadLocationException;
    }
}

