/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.event.BackgroundEvent;
import org.jdesktop.swingx.event.BackgroundListener;

public class BackgroundWorker
extends AbstractBean {
    private List<BackgroundListener> listeners = new ArrayList<BackgroundListener>();
    private DelegateWorker delegate = new DelegateWorker();
    private ExecutorService executor;
    private boolean running = false;

    public boolean isDone() {
        this.running = false;
        return false;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void setProgress(float progress) {
        if (progress < 0.0f || progress > 1.0f) {
            throw new IllegalArgumentException("the value should be from 0 to 1");
        }
        int percent = (int)(progress * 100.0f);
        this.delegate.setProgressPercent(percent);
    }

    public final float getProgress() {
        return (float)this.delegate.getProgress() / 100.0f;
    }

    public final void setProgressPercent(int percent) {
        this.delegate.setProgressPercent(percent);
    }

    public final int getProgressPercent() {
        return this.delegate.getProgress();
    }

    protected final void setExecutorService(ExecutorService svc) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method can only be called on the EDT");
        }
        if (this.running) {
            throw new IllegalStateException("Cannot set the executor service if the worker is running");
        }
        ExecutorService old = this.executor;
        this.executor = svc;
        this.firePropertyChange("executorService", old, this.executor);
    }

    protected final ExecutorService getExecutorService() {
        return this.executor;
    }

    public void execute() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method can only be called on the EDT");
        }
        if (this.running) {
            throw new IllegalStateException("A background task is already in progress");
        }
        this.delegate = new DelegateWorker();
        boolean oldDone = this.isDone();
        this.running = true;
        this.firePropertyChange("running", false, true);
        this.firePropertyChange("done", oldDone, false);
        this.fireStartedEvent();
        if (this.executor == null) {
            this.delegate.execute();
        } else {
            this.executor.submit((Runnable)((Object)this.delegate));
        }
    }

    public void publish(Object ... chunks) {
        this.delegate.doPublish(chunks);
    }

    public void addBackgroundListener(BackgroundListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeBackgroundListener(BackgroundListener listener) {
        this.listeners.remove(listener);
    }

    public BackgroundListener[] getBackgroundListeners() {
        return this.listeners.toArray(new BackgroundListener[0]);
    }

    private void fireStartedEvent() {
        BackgroundEvent evt = new BackgroundEvent(this);
        for (BackgroundListener listener : this.listeners) {
            listener.started(evt);
        }
    }

    private void fireDoneEvent() {
        BackgroundEvent evt = new BackgroundEvent(this);
        for (BackgroundListener listener : this.listeners) {
            listener.done(evt);
        }
    }

    private void fireDoInBackgroundEvent() {
        BackgroundEvent evt = new BackgroundEvent(this);
        for (BackgroundListener listener : this.listeners) {
            listener.doInBackground(evt);
        }
    }

    private void fireProcessEvent(Object[] data) {
        BackgroundEvent evt = new BackgroundEvent(this, data);
        for (BackgroundListener listener : this.listeners) {
            listener.process(evt);
        }
    }

    private final class DelegateWorker
    extends SwingWorker
    implements PropertyChangeListener {
        private DelegateWorker() {
            this.addPropertyChangeListener(this);
        }

        protected Object doInBackground() throws Exception {
            BackgroundWorker.this.fireDoInBackgroundEvent();
            return null;
        }

        protected void done() {
            BackgroundWorker.this.fireDoneEvent();
            BackgroundWorker.this.running = false;
            this.firePropertyChange("running", true, false);
            this.firePropertyChange("done", false, true);
        }

        protected void process(Object ... chunks) {
            BackgroundWorker.this.fireProcessEvent(chunks);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress".equals(evt.getPropertyName())) {
                float oldProgress = (float)((Integer)evt.getOldValue()).intValue() / 100.0f;
                float newProgress = (float)((Integer)evt.getNewValue()).intValue() / 100.0f;
                BackgroundWorker.this.firePropertyChange("progress", Float.valueOf(oldProgress), Float.valueOf(newProgress));
                BackgroundWorker.this.firePropertyChange("progressPercent", evt.getOldValue(), evt.getNewValue());
            }
        }

        private void setProgressPercent(int percent) {
            super.setProgress(percent);
        }

        private void doPublish(Object ... chunks) {
            super.publish(chunks);
        }
    }
}

