/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.cli.ICommandLineParameterHandler;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class CommandLineParameterDescriptor {
    private final String name;
    private final String longName;
    private final String description;
    private final boolean hasArg;
    private final boolean exitAfterExecute;
    private final boolean exclusiveMode;
    private final boolean forceNewInstance;
    private final boolean contextInitializer;
    private final ICommandLineParameterHandler handler;

    public CommandLineParameterDescriptor(IConfigurationElement config) throws Exception {
        this.name = config.getAttribute("name");
        this.longName = config.getAttribute("longName");
        this.description = config.getAttribute("description");
        this.hasArg = CommonUtils.toBoolean((Object)config.getAttribute("hasArg"));
        this.exitAfterExecute = CommonUtils.toBoolean((Object)config.getAttribute("exitAfterExecute"));
        this.exclusiveMode = CommonUtils.toBoolean((Object)config.getAttribute("exclusiveMode"));
        this.forceNewInstance = CommonUtils.toBoolean((Object)config.getAttribute("forceNewInstance"));
        this.contextInitializer = CommonUtils.toBoolean((Object)config.getAttribute("contextInitializer"));
        Bundle cBundle = Platform.getBundle((String)config.getContributor().getName());
        Class implClass = cBundle.loadClass(config.getAttribute("handler"));
        this.handler = (ICommandLineParameterHandler)implClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isExclusiveMode() {
        return this.exclusiveMode;
    }

    public boolean isExitAfterExecute() {
        return this.exitAfterExecute;
    }

    public boolean isForceNewInstance() {
        return this.forceNewInstance;
    }

    public ICommandLineParameterHandler getHandler() {
        return this.handler;
    }

    public boolean hasArg() {
        return this.hasArg;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isContextInitializer() {
        return this.contextInitializer;
    }
}

