/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.encode;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.utils.Base64;

public class SecuredPasswordEncrypter
implements PasswordEncrypter {
    private static final byte[] PASSWORD_ENCRYPTION_KEY = "sdf@!#$verf^wv%6Fwe%$$#FFGwfsdefwfe135s$^H)dg".getBytes(Charset.defaultCharset());
    public static final String SCHEME_DESEDE = "DESede";
    public static final String SCHEME_DES = "DES";
    private static final String CHARSET = "UTF8";
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;

    public SecuredPasswordEncrypter() throws EncryptionException {
        this(SCHEME_DES);
    }

    public SecuredPasswordEncrypter(String encryptionScheme) throws EncryptionException {
        try {
            if (encryptionScheme.equals(SCHEME_DESEDE)) {
                this.keySpec = new DESedeKeySpec(PASSWORD_ENCRYPTION_KEY);
            } else if (encryptionScheme.equals(SCHEME_DES)) {
                this.keySpec = new DESKeySpec(PASSWORD_ENCRYPTION_KEY);
            } else {
                throw new IllegalArgumentException("Encryption scheme not supported: " + encryptionScheme);
            }
            this.keyFactory = SecretKeyFactory.getInstance(encryptionScheme);
            this.cipher = Cipher.getInstance(encryptionScheme);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public String decrypt(String encryptedString) throws EncryptionException {
        if (encryptedString == null || encryptedString.trim().length() <= 0) {
            throw new IllegalArgumentException("Empty encrypted string");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(2, key);
            byte[] cleartext = Base64.decode((String)encryptedString);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return new String(ciphertext, CHARSET);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }
}

