/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Rule {
    private final Location location;
    private final List<Tag> tags;
    private final String keyword;
    private final String name;
    private final String description;
    private final List<RuleChild> children;
    private final String id;

    public Rule(Location location, List<Tag> tags, String keyword, String name, String description, List<RuleChild> children, String id) {
        this.location = Objects.requireNonNull(location, "Rule.location cannot be null");
        this.tags = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(tags, "Rule.tags cannot be null")));
        this.keyword = Objects.requireNonNull(keyword, "Rule.keyword cannot be null");
        this.name = Objects.requireNonNull(name, "Rule.name cannot be null");
        this.description = Objects.requireNonNull(description, "Rule.description cannot be null");
        this.children = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(children, "Rule.children cannot be null")));
        this.id = Objects.requireNonNull(id, "Rule.id cannot be null");
    }

    public Location getLocation() {
        return this.location;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<RuleChild> getChildren() {
        return this.children;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule that = (Rule)o;
        return this.location.equals(that.location) && this.tags.equals(that.tags) && this.keyword.equals(that.keyword) && this.name.equals(that.name) && this.description.equals(that.description) && this.children.equals(that.children) && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.tags, this.keyword, this.name, this.description, this.children, this.id);
    }

    public String toString() {
        return "Rule{location=" + this.location + ", tags=" + this.tags + ", keyword=" + this.keyword + ", name=" + this.name + ", description=" + this.description + ", children=" + this.children + ", id=" + this.id + '}';
    }
}

