/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.Selection;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.ProgressDialog;
import tim.prune.save.SettingsForExport;
import tim.prune.save.xml.GpxCacherList;
import tim.prune.save.xml.XmlUtils;

public class GpxWriter {
    private final ProgressDialog _progress;
    private final SettingsForExport _settings;
    private int _selectionStart = -1;
    private int _selectionEnd = -1;
    private static final String GPX_CREATOR = "GpsPrune v23 activityworkshop.net";

    public GpxWriter(ProgressDialog progressDialog, SettingsForExport settingsForExport) {
        this._progress = progressDialog;
        this._settings = settingsForExport;
    }

    public int exportData(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, String string, String string2, GpxCacherList gpxCacherList) throws IOException {
        outputStreamWriter.write(GpxWriter.getXmlHeaderString(outputStreamWriter));
        String string3 = GpxWriter.getGpxHeaderString(gpxCacherList);
        boolean bl = string3.toUpperCase().indexOf("GPX/1/1") > 0;
        outputStreamWriter.write(string3);
        String string4 = string != null && !string.equals("") ? XmlUtils.fixCdata(string) : "GpsPruneTrack";
        String string5 = string2 != null && !string2.equals("") ? XmlUtils.fixCdata(string2) : "Export from GpsPrune";
        GpxWriter.writeNameAndDescription(outputStreamWriter, string4, string5, bl);
        this.setSelectionRange(trackInfo.getSelection());
        Track track = trackInfo.getTrack();
        int n = track.getNumPoints();
        if (this._progress != null) {
            this._progress.setMaximumValue(n);
        }
        int n2 = 0;
        List<String> list = this.getPointSources(track, gpxCacherList);
        if (this._settings.getExportWaypoints()) {
            n2 += this.writeWaypoints(outputStreamWriter, track, list);
        }
        if (this._settings.getExportTrackPoints() || this._settings.getExportPhotoPoints() || this._settings.getExportAudioPoints()) {
            n2 += this.writeTrackPoints(outputStreamWriter, track, true, list, "<rtept", "\t<rte><number>1</number>\n", null, "\t</rte>\n");
            String string6 = "\t<trk>\n\t\t<name>" + string4 + "</name>\n\t\t<number>1</number>\n\t\t<trkseg>\n";
            n2 += this.writeTrackPoints(outputStreamWriter, track, false, list, "<trkpt", string6, "\t</trkseg>\n\t<trkseg>\n", "\t\t</trkseg>\n\t</trk>\n");
        }
        outputStreamWriter.write("</gpx>\n");
        return n2;
    }

    private List<String> getPointSources(Track track, GpxCacherList gpxCacherList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = track.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            String string = null;
            if (this.shouldExportIndex(n2)) {
                DataPoint dataPoint = track.getPoint(n2);
                string = gpxCacherList == null ? null : GpxWriter.getPointSource(gpxCacherList, dataPoint);
            }
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    private void setSelectionRange(Selection selection) {
        this._selectionStart = this._settings.getExportJustSelection() ? selection.getStart() : -1;
        this._selectionEnd = this._settings.getExportJustSelection() ? selection.getEnd() : -1;
    }

    private boolean shouldExportIndex(int n) {
        if (this._selectionStart == -1 || this._selectionEnd == -1) {
            return true;
        }
        return n >= this._selectionStart && n <= this._selectionEnd;
    }

    private static void writeNameAndDescription(OutputStreamWriter outputStreamWriter, String string, String string2, boolean bl) throws IOException {
        if (bl) {
            outputStreamWriter.write("\t<metadata>\n");
        }
        if (string != null && !string.equals("")) {
            if (bl) {
                outputStreamWriter.write(9);
            }
            outputStreamWriter.write("\t<name>");
            outputStreamWriter.write(string);
            outputStreamWriter.write("</name>\n");
        }
        if (bl) {
            outputStreamWriter.write(9);
        }
        outputStreamWriter.write("\t<desc>");
        outputStreamWriter.write(string2);
        outputStreamWriter.write("</desc>\n");
        if (bl) {
            outputStreamWriter.write("\t</metadata>\n");
        }
    }

    private static String getXmlHeaderString(OutputStreamWriter outputStreamWriter) {
        return "<?xml version=\"1.0\" encoding=\"" + XmlUtils.getEncoding(outputStreamWriter) + "\"?>\n";
    }

    private static String getGpxHeaderString(GpxCacherList gpxCacherList) {
        String string = null;
        if (gpxCacherList != null) {
            string = gpxCacherList.getFirstHeader();
        }
        if (string == null || string.length() < 5) {
            string = "<gpx version=\"1.0\" creator=\"GpsPrune v23 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/0\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">\n";
        }
        return String.valueOf(string) + "\n";
    }

    private int writeWaypoints(Writer writer, Track track, List<String> list) throws IOException {
        int n = track.getNumPoints();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint;
            if (this.shouldExportIndex(n3) && (dataPoint = track.getPoint(n3)).isWaypoint()) {
                String string;
                if (this._progress != null) {
                    if (this._progress.wasCancelled()) {
                        return -1;
                    }
                    this._progress.setValue(n3);
                }
                if ((string = list.get(n3)) != null) {
                    if (!this._settings.getExportTimestamps()) {
                        string = GpxWriter.stripTime(string);
                    }
                    writer.write(9);
                    writer.write(string);
                    writer.write(10);
                } else {
                    this.exportWaypoint(dataPoint, writer);
                }
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private void exportWaypoint(DataPoint dataPoint, Writer writer) throws IOException {
        String string;
        String string2;
        String string3;
        writer.write("\t<wpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">\n");
        if (dataPoint.hasAltitude() || this._settings.getExportMissingAltitudesAsZero()) {
            writer.write("\t\t<ele>");
            writer.write(dataPoint.hasAltitude() ? dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES) : "0");
            writer.write("</ele>\n");
        }
        if (dataPoint.hasTimestamp() && this._settings.getExportTimestamps()) {
            writer.write("\t\t<time>");
            writer.write(dataPoint.getTimestamp().getText(Timestamp.Format.ISO8601, null));
            writer.write("</time>\n");
        }
        writer.write("\t\t<name>");
        writer.write(XmlUtils.fixCdata(dataPoint.getWaypointName().trim()));
        writer.write("</name>\n");
        String string4 = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.DESCRIPTION));
        if (string4 != null && !string4.equals("")) {
            writer.write("\t\t<desc>");
            writer.write(string4);
            writer.write("</desc>\n");
        }
        if ((string3 = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.COMMENT))) != null && !string3.equals("")) {
            writer.write("\t\t<cmt>");
            writer.write(string3);
            writer.write("</cmt>\n");
        }
        if ((string2 = XmlUtils.fixCdata(dataPoint.getFieldValue(Field.SYMBOL))) != null && !string2.equals("")) {
            writer.write("\t\t<sym>");
            writer.write(string2);
            writer.write("</sym>\n");
        }
        if (this._settings.getExportPhotoPoints() && dataPoint.getPhoto() != null) {
            writer.write("\t\t");
            writer.write(GpxWriter.makeMediaLink(dataPoint.getPhoto()));
            writer.write(10);
        }
        if (this._settings.getExportAudioPoints() && dataPoint.getAudio() != null) {
            writer.write("\t\t");
            writer.write(GpxWriter.makeMediaLink(dataPoint.getAudio()));
            writer.write(10);
        }
        if ((string = dataPoint.getFieldValue(Field.WAYPT_TYPE)) != null && !(string = string.trim()).equals("")) {
            writer.write("\t\t<type>");
            writer.write(string);
            writer.write("</type>\n");
        }
        writer.write("\t</wpt>\n");
    }

    private static String getPointSource(GpxCacherList gpxCacherList, DataPoint dataPoint) {
        if (gpxCacherList == null || dataPoint == null) {
            return null;
        }
        String string = gpxCacherList.getSourceString(dataPoint);
        if (string == null || !dataPoint.isModified()) {
            return string;
        }
        string = GpxWriter.replaceGpxTags(string, "lat=\"", "\"", dataPoint.getLatitude().output(17));
        string = GpxWriter.replaceGpxTags(string, "lon=\"", "\"", dataPoint.getLongitude().output(17));
        string = GpxWriter.replaceGpxTags(string, "<ele>", "</ele>", dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES));
        string = GpxWriter.replaceGpxTags(string, "<time>", "</time>", dataPoint.getTimestamp().getText(Timestamp.Format.ISO8601, null));
        if (dataPoint.isWaypoint()) {
            if ((string = GpxWriter.replaceGpxTags(string, "<name>", "</name>", XmlUtils.fixCdata(dataPoint.getWaypointName()))) != null) {
                string = string.replaceAll("<description>", "<desc>").replaceAll("</description>", "</desc>");
            }
            string = GpxWriter.replaceGpxTags(string, "<desc>", "</desc>", XmlUtils.fixCdata(dataPoint.getFieldValue(Field.DESCRIPTION)));
            string = GpxWriter.replaceGpxTags(string, "<cmt>", "</cmt>", dataPoint.getFieldValue(Field.COMMENT));
            string = GpxWriter.replaceGpxTags(string, "<type>", "</type>", dataPoint.getFieldValue(Field.WAYPT_TYPE));
            string = GpxWriter.replaceGpxTags(string, "<sym>", "</sym>", dataPoint.getFieldValue(Field.SYMBOL));
        }
        if (string != null && (dataPoint.hasMedia() || string.indexOf("</link>") > 0)) {
            string = GpxWriter.replaceMediaLinks(string, GpxWriter.makeMediaLink(dataPoint));
        }
        return string;
    }

    private int writeTrackPoints(OutputStreamWriter outputStreamWriter, Track track, boolean bl, List<String> list, String string, String string2, String string3, String string4) throws IOException {
        int n = track.getNumPoints();
        int n2 = 0;
        boolean bl2 = this._settings.getExportTrackPoints();
        boolean bl3 = this._settings.getExportPhotoPoints();
        boolean bl4 = this._settings.getExportAudioPoints();
        boolean bl5 = this._settings.getExportTimestamps();
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint;
            if (this.shouldExportIndex(n3) && !(dataPoint = track.getPoint(n3)).isWaypoint()) {
                if (this._progress != null) {
                    this._progress.setValue(n3);
                }
                if (dataPoint.getPhoto() == null && bl2 || dataPoint.getPhoto() != null && bl3 || dataPoint.getAudio() != null && bl4) {
                    String string5 = list.get(n3);
                    if (string5 != null && !string5.trim().toLowerCase().startsWith(string)) {
                        string5 = null;
                    }
                    if (string5 != null || !bl) {
                        if (n2 > 0 && dataPoint.getSegmentStart() && string3 != null) {
                            outputStreamWriter.write(string3);
                        }
                        if (n2 == 0) {
                            outputStreamWriter.write(string2);
                        }
                        if (string5 != null) {
                            if (!bl5) {
                                string5 = GpxWriter.stripTime(string5);
                            }
                            outputStreamWriter.write(string5);
                            outputStreamWriter.write(10);
                        } else if (!bl) {
                            this.exportTrackpoint(dataPoint, outputStreamWriter);
                        }
                        ++n2;
                    }
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            outputStreamWriter.write(string4);
        }
        return n2;
    }

    private static String replaceGpxTags(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3, n + string2.length());
        if (n > 0 && n2 > 0) {
            String string5 = string.substring(n + string2.length(), n2);
            if (string4 != null && string5.equals(string4)) {
                return string;
            }
            if (string4 == null || string4.equals("")) {
                return String.valueOf(string.substring(0, n)) + string.substring(n2 + string3.length());
            }
            return String.valueOf(string.substring(0, n + string2.length())) + string4 + string.substring(n2);
        }
        if (string4 == null || string4.equals("")) {
            return string;
        }
        return null;
    }

    private static String replaceMediaLinks(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("<link");
        int n2 = string.lastIndexOf("</link>");
        if (n > 0 && n2 > 0) {
            String string3 = string.substring(n, n2 + "</link>".length());
            if (string2 != null && string3.equals(string2)) {
                return string;
            }
            if (string2 == null || string2.equals("")) {
                return String.valueOf(string.substring(0, n)) + string.substring(n2 + "</link>".length());
            }
            return String.valueOf(string.substring(0, n)) + string2 + string.substring(n2 + "</link>".length());
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        return null;
    }

    private void exportTrackpoint(DataPoint dataPoint, Writer writer) throws IOException {
        Timestamp timestamp;
        writer.write("\t\t\t<trkpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">\n");
        if (dataPoint.hasAltitude() || this._settings.getExportMissingAltitudesAsZero()) {
            writer.write("\t\t\t\t<ele>");
            writer.write(dataPoint.hasAltitude() ? dataPoint.getAltitude().getStringValue(UnitSetLibrary.UNITS_METRES) : "0");
            writer.write("</ele>\n");
        }
        if ((timestamp = this.getPointTimestamp(dataPoint)) != null && this._settings.getExportTimestamps()) {
            writer.write("\t\t\t\t<time>");
            writer.write(timestamp.getText(Timestamp.Format.ISO8601, null));
            writer.write("</time>\n");
        }
        if (dataPoint.getPhoto() != null && this._settings.getExportPhotoPoints()) {
            writer.write("\t\t\t\t");
            writer.write(GpxWriter.makeMediaLink(dataPoint.getPhoto()));
            writer.write("\n");
        }
        if (dataPoint.getAudio() != null && this._settings.getExportAudioPoints()) {
            writer.write(GpxWriter.makeMediaLink(dataPoint.getAudio()));
        }
        writer.write("\t\t\t</trkpt>\n");
    }

    private static String stripTime(String string) {
        return string.replaceAll("[ \t]*<time>.*?</time>", "");
    }

    private Timestamp getPointTimestamp(DataPoint dataPoint) {
        if (dataPoint.hasTimestamp()) {
            return dataPoint.getTimestamp();
        }
        if (dataPoint.getPhoto() != null && this._settings.getExportPhotoPoints() && dataPoint.getPhoto().hasTimestamp()) {
            return dataPoint.getPhoto().getTimestamp();
        }
        if (dataPoint.getAudio() != null && this._settings.getExportAudioPoints() && dataPoint.getAudio().hasTimestamp()) {
            return dataPoint.getAudio().getTimestamp();
        }
        return null;
    }

    private static String makeMediaLink(DataPoint dataPoint) {
        Photo photo = dataPoint.getPhoto();
        AudioClip audioClip = dataPoint.getAudio();
        if (photo == null && audioClip == null) {
            return null;
        }
        String string = "";
        if (photo != null) {
            string = GpxWriter.makeMediaLink(photo);
        }
        if (audioClip != null) {
            string = String.valueOf(string) + GpxWriter.makeMediaLink(audioClip);
        }
        return string;
    }

    private static String makeMediaLink(MediaObject mediaObject) {
        if (mediaObject.getFile() != null) {
            return "<link href=\"" + mediaObject.getFile().getAbsolutePath() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        if (mediaObject.getUrl() != null) {
            return "<link href=\"" + mediaObject.getUrl() + "\"><text>" + mediaObject.getName() + "</text></link>";
        }
        return "";
    }
}

