/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import git4idea.GitStashUsageCollector;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitNewCommitMessageActionDialogKt;
import git4idea.util.GitUIUtil;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0014J\b\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020\u0016H\u0014J\b\u0010$\u001a\u00020\u0016H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lgit4idea/stash/ui/GitStashDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "defaultRoot", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "rootComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "currentBranchLabel", "Lcom/intellij/ui/components/JBLabel;", "stashMessageEditor", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "keepIndexCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "selectedRoot", "getSelectedRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "message", "", "getMessage", "()Ljava/lang/String;", "keepIndex", "", "getKeepIndex", "()Z", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "dispose", "getPreferredFocusedComponent", "getDimensionServiceKey", "getHelpId", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashDialog.kt\ngit4idea/stash/ui/GitStashDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class GitStashDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final ComboBox<VirtualFile> rootComboBox;
    @NotNull
    private final JBLabel currentBranchLabel;
    @NotNull
    private final CommitMessage stashMessageEditor;
    @NotNull
    private final JBCheckBox keepIndexCheckBox;

    public GitStashDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @NotNull VirtualFile defaultRoot) {
        ComboBox it;
        ComboBox comboBox;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)defaultRoot, (String)"defaultRoot");
        super(project, true);
        this.project = project;
        ComboBox comboBox2 = comboBox = new ComboBox();
        GitStashDialog gitStashDialog = this;
        boolean bl = false;
        it.setToolTipText(GitBundle.message("common.git.root.tooltip", new Object[0]));
        gitStashDialog.rootComboBox = comboBox;
        it = comboBox = new JBLabel();
        gitStashDialog = this;
        boolean bl2 = false;
        it.setToolTipText(GitBundle.message("common.current.branch.tooltip", new Object[0]));
        gitStashDialog.currentBranchLabel = comboBox;
        it = comboBox = new CommitMessage(this.project, false, false, true);
        gitStashDialog = this;
        boolean bl3 = false;
        it.setPreferredSize((Dimension)JBUI.size((int)400, (int)60));
        it.setToolTipText(GitBundle.message("stash.message.tooltip", new Object[0]));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)it));
        gitStashDialog.stashMessageEditor = comboBox;
        it = comboBox = new JBCheckBox(GitBundle.message("stash.keep.index", new Object[0]));
        gitStashDialog = this;
        boolean bl4 = false;
        it.setToolTipText(GitBundle.message("stash.keep.index.tooltip", new Object[0]));
        gitStashDialog.keepIndexCheckBox = comboBox;
        this.setTitle(GitBundle.message("stash.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("stash.button", new Object[0]));
        GitUIUtil.setupRootChooser(this.project, roots, defaultRoot, (JComboBox)this.rootComboBox, (JLabel)this.currentBranchLabel);
        this.init();
    }

    @NotNull
    public final VirtualFile getSelectedRoot() {
        Object object = this.rootComboBox.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (VirtualFile)object;
    }

    @NotNull
    public final String getMessage() {
        String string = this.stashMessageEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final boolean getKeepIndex() {
        return this.keepIndexCheckBox.isSelected();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> GitStashDialog.createCenterPanel$lambda$7(this, arg_0));
    }

    protected void doOKAction() {
        super.doOKAction();
        GitStashUsageCollector.logStashPushDialog(((CharSequence)this.getMessage()).length() > 0, this.getKeepIndex());
    }

    protected void dispose() {
        if (((CharSequence)this.getMessage()).length() > 0) {
            VcsConfiguration.getInstance((Project)this.project).saveCommitMessage(this.getMessage());
        }
        super.dispose();
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.stashMessageEditor.getEditorField();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
        return (JComponent)editorTextField;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    protected String getHelpId() {
        return "reference.VersionControl.Git.Stash";
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4(GitStashDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.rootComboBox);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$5(GitStashDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.currentBranchLabel);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6(GitStashDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.keepIndexCheckBox);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7(GitStashDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = GitBundle.message("common.git.root", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> GitStashDialog.createCenterPanel$lambda$7$lambda$4(this$0, arg_0));
        String string2 = GitBundle.message("common.current.branch", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> GitStashDialog.createCenterPanel$lambda$7$lambda$5(this$0, arg_0));
        CommitMessage commitMessage = this$0.stashMessageEditor;
        String string3 = GitBundle.message("stash.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        GitNewCommitMessageActionDialogKt.commitMessageWithLabelAndToolbar($this$panel, commitMessage, string3);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitStashDialog.createCenterPanel$lambda$7$lambda$6(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }
}

