/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Slices an image based on a starting index and a stopping index, and a
step size.


This class is designed to facilitate the implementation of extended
sliced based indexing into images.

The input and output image must be of the same dimension.

The input parameters are a starting and stopping index as well as a
stepping size. The starting index indicates the first pixels to be
used and for each dimension the index is incremented by the step until
the index is equal to or "beyond" the stopping index. If the step is
negative then the image will be reversed in the dimension, and the
stopping index is expected to be less then the starting index. If the
stopping index is already beyond the starting index then an image of
size zero will be returned.

The output image's starting index is always zero. The origin is the
physical location of the starting index. The output directions cosine
matrix is that of the input but with sign changes matching that of the
step's sign.


In certain combinations such as with start=1, and step&gt;1 while the
physical location of the center of the pixel remains the same, the
extent (edge to edge space) of the output image will be beyond the
extent of the original image.

See:
 itk::simple::Slice for the procedural interface

 itk::SliceImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSliceImageFilter.h
*/
public class SliceImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SliceImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SliceImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SliceImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SliceImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SliceImageFilter::~SliceImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SliceImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SliceImageFilter::SliceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SliceImageFilter() {
    this(SimpleITKJNI.new_SliceImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SliceImageFilter::SetStart(std::vector&lt; int32_t &gt; Start)

Set/Get the first index extracted from the input image

*/
public  void setStart(VectorInt32 Start) {
    SimpleITKJNI.SliceImageFilter_setStart(swigCPtr, this, VectorInt32.getCPtr(Start), Start);
  }

  /**
std::vector&lt;int32_t&gt; itk::simple::SliceImageFilter::GetStart() const

Set/Get the first index extracted from the input image

*/
public  VectorInt32 getStart() {
    return new VectorInt32(SimpleITKJNI.SliceImageFilter_getStart(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::SliceImageFilter::SetStop(std::vector&lt; int32_t &gt; Stop)

Set/Get the excluded end of the range

*/
public  void setStop(VectorInt32 Stop) {
    SimpleITKJNI.SliceImageFilter_setStop(swigCPtr, this, VectorInt32.getCPtr(Stop), Stop);
  }

  /**
std::vector&lt;int32_t&gt; itk::simple::SliceImageFilter::GetStop() const

Set/Get the excluded end of the range

*/
public  VectorInt32 getStop() {
    return new VectorInt32(SimpleITKJNI.SliceImageFilter_getStop(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::SliceImageFilter::SetStep(std::vector&lt; int &gt; Step)

Set/Get the stride of indexes extracted An exception will be generated
if 0.

*/
public  void setStep(VectorInt32 Step) {
    SimpleITKJNI.SliceImageFilter_setStep__SWIG_0(swigCPtr, this, VectorInt32.getCPtr(Step), Step);
  }

  /**
Self&amp; itk::simple::SliceImageFilter::SetStep(std::vector&lt; int &gt; Step)

Set/Get the stride of indexes extracted An exception will be generated
if 0.

*/
public  void setStep(int value) {
    SimpleITKJNI.SliceImageFilter_setStep__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;int&gt; itk::simple::SliceImageFilter::GetStep() const

Set/Get the stride of indexes extracted An exception will be generated
if 0.

*/
public  VectorInt32 getStep() {
    return new VectorInt32(SimpleITKJNI.SliceImageFilter_getStep(swigCPtr, this), true);
  }

  /**
std::string itk::simple::SliceImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SliceImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SliceImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SliceImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SliceImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SliceImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
