/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.ProviderException;

final class GHASH {
    private static final int AES_BLOCK_SIZE = 16;
    private final long[] subkeyH;
    private final long[] state;
    private long stateSave0;
    private long stateSave1;

    private static long getLong(byte[] byArray, int n) {
        long l = 0L;
        int n2 = n + 8;
        for (int i = n; i < n2; ++i) {
            l = (l << 8) + (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    private static void putLong(byte[] byArray, int n, long l) {
        int n2 = n + 8;
        for (int i = n2 - 1; i >= n; --i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
    }

    private static void blockMult(long[] lArray, long[] lArray2) {
        long l;
        long l2;
        int n;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = lArray2[0];
        long l6 = lArray2[1];
        long l7 = lArray[0];
        for (n = 0; n < 64; ++n) {
            l2 = l7 >> 63;
            l3 ^= l5 & l2;
            l4 ^= l6 & l2;
            l2 = l6 << 63 >> 63;
            l = l5 & 1L;
            l5 >>>= 1;
            l6 = l6 >>> 1 | l << 63;
            l5 ^= 0xE100000000000000L & l2;
            l7 <<= 1;
        }
        l7 = lArray[1];
        for (n = 64; n < 127; ++n) {
            l2 = l7 >> 63;
            l3 ^= l5 & l2;
            l4 ^= l6 & l2;
            l2 = l6 << 63 >> 63;
            l = l5 & 1L;
            l5 >>>= 1;
            l6 = l6 >>> 1 | l << 63;
            l5 ^= 0xE100000000000000L & l2;
            l7 <<= 1;
        }
        long l8 = l7 >> 63;
        lArray[0] = l3 ^= l5 & l8;
        lArray[1] = l4 ^= l6 & l8;
    }

    GHASH(byte[] byArray) throws ProviderException {
        if (byArray == null || byArray.length != 16) {
            throw new ProviderException("Internal error");
        }
        this.state = new long[2];
        this.subkeyH = new long[2];
        this.subkeyH[0] = GHASH.getLong(byArray, 0);
        this.subkeyH[1] = GHASH.getLong(byArray, 8);
    }

    void reset() {
        this.state[0] = 0L;
        this.state[1] = 0L;
    }

    void save() {
        this.stateSave0 = this.state[0];
        this.stateSave1 = this.state[1];
    }

    void restore() {
        this.state[0] = this.stateSave0;
        this.state[1] = this.stateSave1;
    }

    private static void processBlock(byte[] byArray, int n, long[] lArray, long[] lArray2) {
        lArray[0] = lArray[0] ^ GHASH.getLong(byArray, n);
        lArray[1] = lArray[1] ^ GHASH.getLong(byArray, n + 8);
        GHASH.blockMult(lArray, lArray2);
    }

    void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    void update(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        GHASH.ghashRangeCheck(byArray, n, n2, this.state, this.subkeyH);
        GHASH.processBlocks(byArray, n, n2 / 16, this.state, this.subkeyH);
    }

    private static void ghashRangeCheck(byte[] byArray, int n, int n2, long[] lArray, long[] lArray2) {
        if (n2 < 0) {
            throw new RuntimeException("invalid input length: " + n2);
        }
        if (n < 0) {
            throw new RuntimeException("invalid offset: " + n);
        }
        if (n2 > byArray.length - n) {
            throw new RuntimeException("input length out of bound: " + n2 + " > " + (byArray.length - n));
        }
        if (n2 % 16 != 0) {
            throw new RuntimeException("input length/block size mismatch: " + n2);
        }
        if (lArray.length != 2) {
            throw new RuntimeException("internal state has invalid length: " + lArray.length);
        }
        if (lArray2.length != 2) {
            throw new RuntimeException("internal subkeyH has invalid length: " + lArray2.length);
        }
    }

    private static void processBlocks(byte[] byArray, int n, int n2, long[] lArray, long[] lArray2) {
        int n3 = n;
        while (n2 > 0) {
            GHASH.processBlock(byArray, n3, lArray, lArray2);
            --n2;
            n3 += 16;
        }
    }

    byte[] digest() {
        byte[] byArray = new byte[16];
        GHASH.putLong(byArray, 0, this.state[0]);
        GHASH.putLong(byArray, 8, this.state[1]);
        this.reset();
        return byArray;
    }
}

