/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.util.regex.PatternSyntaxException;

public class Globs {
    private static final String regexMetaChars = ".^$+{[]|()";
    private static final String globMetaChars = "\\*?[{";
    private static char EOL = '\u0000';

    private Globs() {
    }

    private static boolean isRegexMeta(char c) {
        return regexMetaChars.indexOf(c) != -1;
    }

    private static boolean isGlobMeta(char c) {
        return globMetaChars.indexOf(c) != -1;
    }

    private static char next(String string, int n) {
        if (n < string.length()) {
            return string.charAt(n);
        }
        return EOL;
    }

    private static String toRegexPattern(String string, boolean bl) {
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder("^");
        int n = 0;
        block10: while (n < string.length()) {
            char c = string.charAt(n++);
            switch (c) {
                case '\\': {
                    char c2;
                    if (n == string.length()) {
                        throw new PatternSyntaxException("No character to escape", string, n - 1);
                    }
                    if (Globs.isGlobMeta(c2 = string.charAt(n++)) || Globs.isRegexMeta(c2)) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c2);
                    continue block10;
                }
                case '/': {
                    if (bl) {
                        stringBuilder.append("\\\\");
                        continue block10;
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
                case '[': {
                    if (bl) {
                        stringBuilder.append("[[^\\\\]&&[");
                    } else {
                        stringBuilder.append("[[^/]&&[");
                    }
                    if (Globs.next(string, n) == '^') {
                        stringBuilder.append("\\^");
                        ++n;
                    } else {
                        if (Globs.next(string, n) == '!') {
                            stringBuilder.append('^');
                            ++n;
                        }
                        if (Globs.next(string, n) == '-') {
                            stringBuilder.append('-');
                            ++n;
                        }
                    }
                    boolean bl3 = false;
                    char c3 = '\u0000';
                    while (n < string.length() && (c = string.charAt(n++)) != ']') {
                        if (c == '/' || bl && c == '\\') {
                            throw new PatternSyntaxException("Explicit 'name separator' in class", string, n - 1);
                        }
                        if (c == '\\' || c == '[' || c == '&' && Globs.next(string, n) == '&') {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                        if (c == '-') {
                            if (!bl3) {
                                throw new PatternSyntaxException("Invalid range", string, n - 1);
                            }
                            if ((c = Globs.next(string, n++)) == EOL || c == ']') break;
                            if (c < c3) {
                                throw new PatternSyntaxException("Invalid range", string, n - 3);
                            }
                            stringBuilder.append(c);
                            bl3 = false;
                            continue;
                        }
                        bl3 = true;
                        c3 = c;
                    }
                    if (c != ']') {
                        throw new PatternSyntaxException("Missing ']", string, n - 1);
                    }
                    stringBuilder.append("]]");
                    continue block10;
                }
                case '{': {
                    if (bl2) {
                        throw new PatternSyntaxException("Cannot nest groups", string, n - 1);
                    }
                    stringBuilder.append("(?:(?:");
                    bl2 = true;
                    continue block10;
                }
                case '}': {
                    if (bl2) {
                        stringBuilder.append("))");
                        bl2 = false;
                        continue block10;
                    }
                    stringBuilder.append('}');
                    continue block10;
                }
                case ',': {
                    if (bl2) {
                        stringBuilder.append(")|(?:");
                        continue block10;
                    }
                    stringBuilder.append(',');
                    continue block10;
                }
                case '*': {
                    if (Globs.next(string, n) == '*') {
                        stringBuilder.append(".*");
                        ++n;
                        continue block10;
                    }
                    if (bl) {
                        stringBuilder.append("[^\\\\]*");
                        continue block10;
                    }
                    stringBuilder.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    if (bl) {
                        stringBuilder.append("[^\\\\]");
                        continue block10;
                    }
                    stringBuilder.append("[^/]");
                    continue block10;
                }
            }
            if (Globs.isRegexMeta(c)) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        if (bl2) {
            throw new PatternSyntaxException("Missing '}", string, n - 1);
        }
        return stringBuilder.append('$').toString();
    }

    static String toUnixRegexPattern(String string) {
        return Globs.toRegexPattern(string, false);
    }

    static String toWindowsRegexPattern(String string) {
        return Globs.toRegexPattern(string, true);
    }
}

