/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.kafka.common.metadata.DelegationTokenRecord;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;

public final class DelegationTokenData {
    private final TokenInformation tokenInformation;

    public static DelegationTokenData fromRecord(DelegationTokenRecord record) {
        ArrayList<KafkaPrincipal> renewers = new ArrayList<KafkaPrincipal>();
        for (String renewerString : record.renewers()) {
            renewers.add(SecurityUtils.parseKafkaPrincipal((String)renewerString));
        }
        return new DelegationTokenData(TokenInformation.fromRecord((String)record.tokenId(), (KafkaPrincipal)SecurityUtils.parseKafkaPrincipal((String)record.owner()), (KafkaPrincipal)SecurityUtils.parseKafkaPrincipal((String)record.requester()), renewers, (long)record.issueTimestamp(), (long)record.maxTimestamp(), (long)record.expirationTimestamp()));
    }

    public DelegationTokenData(TokenInformation tokenInformation) {
        this.tokenInformation = tokenInformation;
    }

    public TokenInformation tokenInformation() {
        return this.tokenInformation;
    }

    public DelegationTokenRecord toRecord() {
        return new DelegationTokenRecord().setOwner(this.tokenInformation.ownerAsString()).setRequester(this.tokenInformation.tokenRequesterAsString()).setRenewers(new ArrayList<String>(this.tokenInformation.renewersAsString())).setIssueTimestamp(this.tokenInformation.issueTimestamp()).setMaxTimestamp(this.tokenInformation.maxTimestamp()).setExpirationTimestamp(this.tokenInformation.expiryTimestamp()).setTokenId(this.tokenInformation.tokenId());
    }

    public int hashCode() {
        return Objects.hash(this.tokenInformation);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DelegationTokenData.class)) {
            return false;
        }
        DelegationTokenData other = (DelegationTokenData)o;
        return this.tokenInformation.equals((Object)other.tokenInformation);
    }

    public String toString() {
        return "DelegationTokenData(tokenInformation=[hidden])";
    }
}

