/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.config.Config;

public interface CodeGenProvider {
    public String providerId();

    @Deprecated
    default public String inputExtension() {
        return null;
    }

    default public String[] inputExtensions() {
        if (this.inputExtension() != null) {
            return new String[]{this.inputExtension()};
        }
        return new String[0];
    }

    public String inputDirectory();

    default public Path getInputDirectory() {
        return null;
    }

    default public void init(ApplicationModel model, Map<String, String> properties) {
    }

    public boolean trigger(CodeGenContext var1) throws CodeGenException;

    default public boolean shouldRun(Path sourceDir, Config config) {
        return Files.isDirectory(sourceDir, new LinkOption[0]);
    }

    public static Path resolve(Path path) {
        return Objects.requireNonNull(path).resolve(".");
    }
}

