/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class AttributeRequiredByMetadataValidator
implements SimpleValidator {
    public static final String ERROR_USER_ATTRIBUTE_REQUIRED = "error-user-attribute-required";
    public static final String ID = "up-attribute-required-by-metadata-value";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        AttributeContext attContext = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext();
        AttributeMetadata metadata = attContext.getMetadata();
        if (!metadata.isRequired(attContext)) {
            return context;
        }
        if (metadata.isReadOnly(attContext)) {
            return context;
        }
        List values = (List)input;
        if (values == null || values.isEmpty()) {
            context.addError(new ValidationError(ID, inputHint, ERROR_USER_ATTRIBUTE_REQUIRED));
        } else {
            for (String value : values) {
                if (!Validation.isBlank(value)) continue;
                context.addError(new ValidationError(ID, inputHint, ERROR_USER_ATTRIBUTE_REQUIRED));
                return context;
            }
        }
        return context;
    }
}

