/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.util;

import java.io.StringWriter;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.util.TransformerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ArtifactResponseUtil {
    private ArtifactResponseUtil() {
    }

    public static Optional<String> convertResponseToString(Document document) {
        return ArtifactResponseUtil.extractResponseElement(document).map(ArtifactResponseUtil::nodeToString);
    }

    static String nodeToString(Node node) {
        try {
            StringWriter writer = new StringWriter();
            TransformerUtil.getTransformer().transform(new DOMSource(node), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (TransformerException | ConfigurationException e) {
            throw new IllegalStateException("Error converting node to string", e);
        }
    }

    static Optional<Element> extractResponseElement(Document document) {
        NodeList responseNodeList = document.getElementsByTagNameNS(JBossSAMLConstants.RESPONSE__PROTOCOL.getNsUri().get(), JBossSAMLConstants.RESPONSE__PROTOCOL.get());
        if (responseNodeList.getLength() != 1) {
            return Optional.empty();
        }
        Node responseNode = responseNodeList.item(0);
        if (responseNode.getNodeType() != 1) {
            return Optional.empty();
        }
        return Optional.of((Element)responseNode);
    }
}

