import java.lang.reflect.Method;
import java.sql.*;
import java.util.HashMap;
import java.util.Date;
import java.net.InetAddress;

public class BurpExtender implements IBurpExtender {

	Connection db_connection = null;
	HashMap<Integer,Request> burpRequests = null;
	
	public BurpExtender() {
		System.out.println("[+] Loading WMAP plugin 0.1");
		burpRequests = new HashMap<Integer,Request>();
	}
	
	@Override
	public void applicationClosing() {
		System.out.println("[+] Closing database connection");	
		try {
			db_connection.close();
		}
		catch(SQLException exception) {
			System.out.println("[-] Error: Can't close database connection");
		}
		
		System.out.println("[+] Unloading WMAP plugin");
	}
	
	@Override
	public byte[] processProxyMessage(int messageReference,
			boolean messageIsRequest, String remoteHost, int remotePort,
			boolean serviceIsHttps, String httpMethod, String url,
			String resourceType, String statusCode, String responseContentType,
			byte[] message, int[] action) {
		
			// resolve the IP:
			InetAddress ipAddress = null;
			try {
				ipAddress = InetAddress.getByName(remoteHost);
			}
			catch (Exception exception) {
				System.err.println("[-] Error: can't resolve host. This shouldn't happen.");
			}
			
			if (messageIsRequest) {

				
				Request request = new Request();
				
				String pathAndQuery[] = url.split("\\?");
				request.setPath(pathAndQuery[0].substring(1));
				
				if(pathAndQuery.length == 2) 	request.setQuery(pathAndQuery[1]);
				request.setHost(ipAddress.getHostAddress());
				request.setPort(remotePort);
				request.setSSL(serviceIsHttps);
				request.setMethod(httpMethod);
				request.setBody(message);
				request.setHeader(message);
				request.setTimestamp(new Date());
				burpRequests.put(messageReference, request);

			}
			else {
				try {
					
					
					Request request = burpRequests.remove(messageReference);
					
					request.setResponseCode(statusCode);
					request.setResponseHeader(message);
					request.setResponseBody(message);
					System.out.println("[+] Adding request: " + request.getMethod() + "|" + request.getPath() + "|" + request.getTimestamp());
					PreparedStatement insertStatement = db_connection.prepareStatement("INSERT INTO requests(host,port,ssl,meth,path,headers,query,body,respcode,resphead,response,created )" +
					"VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
					
					
					insertStatement.setString(1, request.getHost());
					insertStatement.setInt(2, request.getPort());
					insertStatement.setBoolean(3, request.getSSL());
					insertStatement.setString(4, request.getMethod());
					insertStatement.setString(5, request.getPath());
					insertStatement.setString(6, request.getHeader());
					insertStatement.setString(7, request.getQuery());
					insertStatement.setString(8, request.getBody());
					insertStatement.setString(9, request.getResponseCode());
					insertStatement.setString(10, request.getResponseHeader());
					insertStatement.setString(11, request.getResponseBody());
					insertStatement.setString(12, request.getTimestamp().toString());
					insertStatement.executeUpdate();
				}
				catch(SQLException exception) {
				
				}
			}
			
		
		return null;
	}

	@Override
	public void registerHttpRequestMethod(Method makeHttpRequestMethod,
			Object makeHttpRequestObject) {
		// TODO Auto-generated method stub

	}
	
	private void usage() {
		System.err.println("[-] Error: Please set the database parameter.");
		System.err.println("[-] Example: database=test.db");
		System.exit(1);		
	}

	@Override
	public void setCommandLineArgs(String[] args) {
		
		// I know we can solve this with one if, but it doesn't work, don't ask me why...
		if (args.length == 0) {
			usage();
		}
	
		String[] parameters = args[0].split("="); 
		
		if (!parameters[0].equals("database") || parameters.length != 2) {
			usage();
		}
		
		System.out.println("[+] Using database: " + parameters[1]);
		try {
			Class.forName("org.sqlite.JDBC");
			db_connection = DriverManager.getConnection("jdbc:sqlite:" + parameters[1]);
		}
		catch(Exception ex) {
			System.err.println("[-] Error: Can't create connection: " + parameters[1]);
			System.exit(1);
		}
	}

}
