/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonParsingException;
import oracle.jdbc.driver.json.OracleJsonExceptions;

public final class JakartaExceptionFactory
implements OracleJsonExceptions.ExceptionFactory {
    public static JakartaExceptionFactory INSTANCE = new JakartaExceptionFactory();

    private JakartaExceptionFactory() {
    }

    @Override
    public RuntimeException createJsonException(String message, Throwable cause) {
        return new JsonException(message, cause);
    }

    @Override
    public RuntimeException createJsonException(String message) {
        return new JsonException(message);
    }

    @Override
    public RuntimeException createGenerationException(String message, Throwable cause) {
        return new JsonGenerationException(message, cause);
    }

    @Override
    public RuntimeException createGenerationException(String message) {
        return new JsonGenerationException(message);
    }

    @Override
    public RuntimeException createParsingException(String message, Throwable cause) {
        return new JsonParsingException(message, cause, null);
    }

    @Override
    public RuntimeException createParsingException(String message) {
        return new JsonParsingException(message, null);
    }
}

