/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.opensearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.opensearch.action.admin.cluster.node.info.PluginsAndModules;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.node.Node;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.node.remotestore.RemoteStoreNodeService;
import org.opensearch.plugins.PluginInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\fJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/opensearch/replication/util/ValidationUtil;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "validateIndexSettings", "", "environment", "Lorg/opensearch/env/Environment;", "followerIndex", "", "leaderSettings", "Lorg/opensearch/common/settings/Settings;", "overriddenSettings", "metadataCreateIndexService", "Lorg/opensearch/cluster/metadata/MetadataCreateIndexService;", "validateAnalyzerSettings", "validateName", "name", "validationException", "Lorg/opensearch/common/ValidationException;", "validatePattern", "pattern", "validateLeaderIndexMetadata", "leaderIndexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "validateLeaderIndexState", "leaderAlias", "leaderIndex", "leaderClusterState", "Lorg/opensearch/cluster/ClusterState;", "checkKNNEligibility", "nodesInfoResponse", "Lorg/opensearch/action/admin/cluster/node/info/NodesInfoResponse;", "isRemoteStoreEnabledCluster", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "isRemoteEnabledOrMigrating", "opensearch-cross-cluster-replication"})
public final class ValidationUtil {
    @NotNull
    public static final ValidationUtil INSTANCE = new ValidationUtil();
    private static final Logger log = LogManager.getLogger(ValidationUtil.class);

    private ValidationUtil() {
    }

    public final void validateIndexSettings(@NotNull Environment environment, @NotNull String followerIndex, @NotNull Settings leaderSettings, @NotNull Settings overriddenSettings, @NotNull MetadataCreateIndexService metadataCreateIndexService) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)followerIndex, (String)"followerIndex");
        Intrinsics.checkNotNullParameter((Object)leaderSettings, (String)"leaderSettings");
        Intrinsics.checkNotNullParameter((Object)overriddenSettings, (String)"overriddenSettings");
        Intrinsics.checkNotNullParameter((Object)metadataCreateIndexService, (String)"metadataCreateIndexService");
        Settings[] settingsArray = new Settings[]{leaderSettings, overriddenSettings};
        Settings[] settingsList = settingsArray;
        Settings.Builder desiredSettingsBuilder = Settings.builder();
        for (Settings settings : settingsList) {
            for (String key : settings.keySet()) {
                desiredSettingsBuilder.copy(key, settings);
            }
        }
        Settings desiredSettings = desiredSettingsBuilder.build();
        metadataCreateIndexService.validateIndexSettings(followerIndex, desiredSettings, false);
        this.validateAnalyzerSettings(environment, leaderSettings, overriddenSettings);
    }

    public final void validateAnalyzerSettings(@NotNull Environment environment, @NotNull Settings leaderSettings, @NotNull Settings overriddenSettings) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)leaderSettings, (String)"leaderSettings");
        Intrinsics.checkNotNullParameter((Object)overriddenSettings, (String)"overriddenSettings");
        Settings analyserSettings = leaderSettings.filter(ValidationUtil::validateAnalyzerSettings$lambda$0);
        for (String analyserSetting : analyserSettings.keySet()) {
            Path path;
            String settingValue = overriddenSettings.hasValue(analyserSetting) ? overriddenSettings.get(analyserSetting) : analyserSettings.get(analyserSetting);
            Intrinsics.checkNotNullExpressionValue((Object)environment.configDir().resolve(settingValue), (String)"resolve(...)");
            if (Files.exists(path, new LinkOption[0])) continue;
            String message = "IOException while reading " + analyserSetting + ": " + path;
            log.error(message);
            throw new ResourceNotFoundException(message, new Object[0]);
        }
    }

    public final void validateName(@NotNull String name, @NotNull ValidationException validationException) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)validationException, (String)"validationException");
        String string = name;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)name)) {
            validationException.addValidationError("Value " + name + " must be lowercase");
        }
        if (!Strings.validFileName((String)name)) {
            validationException.addValidationError("Value " + name + " must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"#", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)":", (boolean)false, (int)2, null)) {
            validationException.addValidationError("Value " + name + " must not contain '#' or ':'");
        }
        if (Intrinsics.areEqual((Object)name, (Object)".") || Intrinsics.areEqual((Object)name, (Object)"..")) {
            validationException.addValidationError("Value " + name + " must not be '.' or '..'");
        }
        if (StringsKt.startsWith$default((CharSequence)name, (char)'_', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)name, (char)'-', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)name, (char)'+', (boolean)false, (int)2, null)) {
            validationException.addValidationError("Value " + name + " must not start with '_' or '-' or '+'");
        }
        try {
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = name.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            int byteCount = byArray.length;
            if (byteCount > 255) {
                validationException.addValidationError("Value " + name + " must not be longer than 255 bytes");
            }
        }
        catch (UnsupportedEncodingException e) {
            validationException.addValidationError("Unable to determine length of " + name);
        }
        if (StringsKt.startsWith$default((String)name, (String)".", (boolean)false, (int)2, null)) {
            validationException.addValidationError("Value " + name + " must not start with '.'");
        }
    }

    public final void validatePattern(@Nullable String pattern, @NotNull ValidationException validationException) {
        block11: {
            block10: {
                block9: {
                    block8: {
                        CharSequence charSequence;
                        Intrinsics.checkNotNullParameter((Object)validationException, (String)"validationException");
                        if (!Strings.validFileNameExcludingAstrix((String)pattern)) {
                            validationException.addValidationError("Autofollow pattern: " + pattern + " must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
                        }
                        if ((charSequence = (CharSequence)pattern) == null || charSequence.length() == 0) {
                            validationException.addValidationError("Autofollow pattern: " + pattern + " must not be empty");
                        }
                        String string = pattern;
                        if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"#", (boolean)false, (int)2, null) : false) break block8;
                        String string2 = pattern;
                        if (!(string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)":", (boolean)false, (int)2, null) : false)) break block9;
                    }
                    validationException.addValidationError("Autofollow pattern: " + pattern + " must not contain '#' or ':'");
                }
                String string = pattern;
                if (string != null ? StringsKt.startsWith$default((CharSequence)string, (char)'_', (boolean)false, (int)2, null) : false) break block10;
                String string3 = pattern;
                if (!(string3 != null ? StringsKt.startsWith$default((CharSequence)string3, (char)'-', (boolean)false, (int)2, null) : false)) break block11;
            }
            validationException.addValidationError("Autofollow pattern: " + pattern + " must not start with '_' or '-'");
        }
    }

    private final void validateLeaderIndexMetadata(IndexMetadata leaderIndexMetadata) {
        if (Version.CURRENT.before(leaderIndexMetadata.getCreationVersion())) {
            String err = "Leader index[" + leaderIndexMetadata.getIndex().getName() + "] is on higher version [" + leaderIndexMetadata.getCreationVersion() + "] than follower [" + Version.CURRENT + "]";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
        if (Version.CURRENT.before(leaderIndexMetadata.getUpgradedVersion())) {
            String err = "Leader index[" + leaderIndexMetadata.getIndex().getName() + "] is upgraded with higher version [" + leaderIndexMetadata.getUpgradedVersion() + "] than follower [" + Version.CURRENT + "]";
            log.error(err);
            throw new IllegalArgumentException(err);
        }
    }

    public final void validateLeaderIndexState(@NotNull String leaderAlias, @NotNull String leaderIndex, @NotNull ClusterState leaderClusterState) {
        Intrinsics.checkNotNullParameter((Object)leaderAlias, (String)"leaderAlias");
        Intrinsics.checkNotNullParameter((Object)leaderIndex, (String)"leaderIndex");
        Intrinsics.checkNotNullParameter((Object)leaderClusterState, (String)"leaderClusterState");
        IndexMetadata indexMetadata = leaderClusterState.getMetadata().index(leaderIndex);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(leaderAlias + ":" + leaderIndex);
        }
        IndexMetadata leaderIndexMetadata = indexMetadata;
        this.validateLeaderIndexMetadata(leaderIndexMetadata);
        if (!leaderClusterState.getRoutingTable().index(leaderIndex).allPrimaryShardsActive()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("Primary shards in the Index[" + leaderAlias + ":" + leaderIndex + "] are not active");
            throw validationException;
        }
    }

    public final void checkKNNEligibility(@NotNull NodesInfoResponse nodesInfoResponse, @NotNull String leaderIndex) {
        Intrinsics.checkNotNullParameter((Object)nodesInfoResponse, (String)"nodesInfoResponse");
        Intrinsics.checkNotNullParameter((Object)leaderIndex, (String)"leaderIndex");
        if (!nodesInfoResponse.getNodes().stream().flatMap(arg_0 -> ValidationUtil.checkKNNEligibility$lambda$2(ValidationUtil::checkKNNEligibility$lambda$1, arg_0)).anyMatch(arg_0 -> ValidationUtil.checkKNNEligibility$lambda$4(ValidationUtil::checkKNNEligibility$lambda$3, arg_0))) {
            throw new IllegalStateException("Cannot proceed with replication for k-NN enabled index " + leaderIndex + " as knn plugin is not installed.");
        }
    }

    public final boolean isRemoteStoreEnabledCluster(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        return !clusterService.getSettings().getByPrefix(Node.NODE_ATTRIBUTES.getKey() + RemoteStoreNodeAttribute.REMOTE_STORE_NODE_ATTRIBUTE_KEY_PREFIX).isEmpty();
    }

    public final boolean isRemoteEnabledOrMigrating(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        return this.isRemoteStoreEnabledCluster(clusterService) || ((RemoteStoreNodeService.CompatibilityMode)clusterService.getClusterSettings().get(RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING)).equals((Object)RemoteStoreNodeService.CompatibilityMode.MIXED);
    }

    private static final boolean validateAnalyzerSettings$lambda$0(String k) {
        String string = k;
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        return new Regex("index.analysis.*path").matches(charSequence);
    }

    private static final Stream checkKNNEligibility$lambda$1(NodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        return ((PluginsAndModules)nodeInfo.getInfo(PluginsAndModules.class)).getPluginInfos().stream();
    }

    private static final Stream checkKNNEligibility$lambda$2(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean checkKNNEligibility$lambda$3(PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter((Object)pluginInfo, (String)"pluginInfo");
        return Intrinsics.areEqual((Object)pluginInfo.getClassname(), (Object)"org.opensearch.knn.plugin.KNNPlugin");
    }

    private static final boolean checkKNNEligibility$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

