/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ContainerFormat;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportToS3TaskSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportToS3TaskSpecification> {
    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskImageFormat").getter(ExportToS3TaskSpecification.getter(ExportToS3TaskSpecification::diskImageFormatAsString)).setter(ExportToS3TaskSpecification.setter(Builder::diskImageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageFormat").unmarshallLocationName("diskImageFormat").build()}).build();
    private static final SdkField<String> CONTAINER_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerFormat").getter(ExportToS3TaskSpecification.getter(ExportToS3TaskSpecification::containerFormatAsString)).setter(ExportToS3TaskSpecification.setter(Builder::containerFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerFormat").unmarshallLocationName("containerFormat").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(ExportToS3TaskSpecification.getter(ExportToS3TaskSpecification::s3Bucket)).setter(ExportToS3TaskSpecification.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").unmarshallLocationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(ExportToS3TaskSpecification.getter(ExportToS3TaskSpecification::s3Prefix)).setter(ExportToS3TaskSpecification.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").unmarshallLocationName("s3Prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_IMAGE_FORMAT_FIELD, CONTAINER_FORMAT_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportToS3TaskSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String diskImageFormat;
    private final String containerFormat;
    private final String s3Bucket;
    private final String s3Prefix;

    private ExportToS3TaskSpecification(BuilderImpl builder) {
        this.diskImageFormat = builder.diskImageFormat;
        this.containerFormat = builder.containerFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
    }

    public final DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(this.diskImageFormat);
    }

    public final String diskImageFormatAsString() {
        return this.diskImageFormat;
    }

    public final ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(this.containerFormat);
    }

    public final String containerFormatAsString() {
        return this.containerFormat;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3TaskSpecification)) {
            return false;
        }
        ExportToS3TaskSpecification other = (ExportToS3TaskSpecification)obj;
        return Objects.equals(this.diskImageFormatAsString(), other.diskImageFormatAsString()) && Objects.equals(this.containerFormatAsString(), other.containerFormatAsString()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Prefix(), other.s3Prefix());
    }

    public final String toString() {
        return ToString.builder((String)"ExportToS3TaskSpecification").add("DiskImageFormat", (Object)this.diskImageFormatAsString()).add("ContainerFormat", (Object)this.containerFormatAsString()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Prefix", (Object)this.s3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiskImageFormat": {
                return Optional.ofNullable(clazz.cast(this.diskImageFormatAsString()));
            }
            case "ContainerFormat": {
                return Optional.ofNullable(clazz.cast(this.containerFormatAsString()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DiskImageFormat", DISK_IMAGE_FORMAT_FIELD);
        map.put("ContainerFormat", CONTAINER_FORMAT_FIELD);
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportToS3TaskSpecification, T> g) {
        return obj -> g.apply((ExportToS3TaskSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String diskImageFormat;
        private String containerFormat;
        private String s3Bucket;
        private String s3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3TaskSpecification model) {
            this.diskImageFormat(model.diskImageFormat);
            this.containerFormat(model.containerFormat);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
        }

        public final String getDiskImageFormat() {
            return this.diskImageFormat;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final String getContainerFormat() {
            return this.containerFormat;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat == null ? null : containerFormat.toString());
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public ExportToS3TaskSpecification build() {
            return new ExportToS3TaskSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportToS3TaskSpecification> {
        public Builder diskImageFormat(String var1);

        public Builder diskImageFormat(DiskImageFormat var1);

        public Builder containerFormat(String var1);

        public Builder containerFormat(ContainerFormat var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);
    }
}

