/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSnapshotRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportSnapshotRequest> {
    private static final SdkField<ClientData> CLIENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientData").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::clientData)).setter(ImportSnapshotRequest.setter(Builder::clientData)).constructor(ClientData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientData").unmarshallLocationName("ClientData").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::clientToken)).setter(ImportSnapshotRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::description)).setter(ImportSnapshotRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<SnapshotDiskContainer> DISK_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiskContainer").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::diskContainer)).setter(ImportSnapshotRequest.setter(Builder::diskContainer)).constructor(SnapshotDiskContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskContainer").unmarshallLocationName("DiskContainer").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::dryRun)).setter(ImportSnapshotRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::encrypted)).setter(ImportSnapshotRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::kmsKeyId)).setter(ImportSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("KmsKeyId").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::roleName)).setter(ImportSnapshotRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").unmarshallLocationName("RoleName").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(ImportSnapshotRequest.getter(ImportSnapshotRequest::tagSpecifications)).setter(ImportSnapshotRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_DATA_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DISK_CONTAINER_FIELD, DRY_RUN_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, ROLE_NAME_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportSnapshotRequest.memberNameToFieldInitializer();
    private final ClientData clientData;
    private final String clientToken;
    private final String description;
    private final SnapshotDiskContainer diskContainer;
    private final Boolean dryRun;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String roleName;
    private final List<TagSpecification> tagSpecifications;

    private ImportSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainer = builder.diskContainer;
        this.dryRun = builder.dryRun;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.roleName = builder.roleName;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final ClientData clientData() {
        return this.clientData;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final SnapshotDiskContainer diskContainer() {
        return this.diskContainer;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientData());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotRequest)) {
            return false;
        }
        ImportSnapshotRequest other = (ImportSnapshotRequest)((Object)obj);
        return Objects.equals(this.clientData(), other.clientData()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.diskContainer(), other.diskContainer()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.roleName(), other.roleName()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"ImportSnapshotRequest").add("ClientData", (Object)this.clientData()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("DiskContainer", (Object)this.diskContainer()).add("DryRun", (Object)this.dryRun()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("RoleName", (Object)this.roleName()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientData": {
                return Optional.ofNullable(clazz.cast(this.clientData()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiskContainer": {
                return Optional.ofNullable(clazz.cast(this.diskContainer()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientData", CLIENT_DATA_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DiskContainer", DISK_CONTAINER_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportSnapshotRequest, T> g) {
        return obj -> g.apply((ImportSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private ClientData clientData;
        private String clientToken;
        private String description;
        private SnapshotDiskContainer diskContainer;
        private Boolean dryRun;
        private Boolean encrypted;
        private String kmsKeyId;
        private String roleName;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotRequest model) {
            super(model);
            this.clientData(model.clientData);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.diskContainer(model.diskContainer);
            this.dryRun(model.dryRun);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.roleName(model.roleName);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final ClientData.Builder getClientData() {
            return this.clientData != null ? this.clientData.toBuilder() : null;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SnapshotDiskContainer.Builder getDiskContainer() {
            return this.diskContainer != null ? this.diskContainer.toBuilder() : null;
        }

        public final void setDiskContainer(SnapshotDiskContainer.BuilderImpl diskContainer) {
            this.diskContainer = diskContainer != null ? diskContainer.build() : null;
        }

        @Override
        public final Builder diskContainer(SnapshotDiskContainer diskContainer) {
            this.diskContainer = diskContainer;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSnapshotRequest build() {
            return new ImportSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportSnapshotRequest> {
        public Builder clientData(ClientData var1);

        default public Builder clientData(Consumer<ClientData.Builder> clientData) {
            return this.clientData((ClientData)((ClientData.Builder)ClientData.builder().applyMutation(clientData)).build());
        }

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder diskContainer(SnapshotDiskContainer var1);

        default public Builder diskContainer(Consumer<SnapshotDiskContainer.Builder> diskContainer) {
            return this.diskContainer((SnapshotDiskContainer)((SnapshotDiskContainer.Builder)SnapshotDiskContainer.builder().applyMutation(diskContainer)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder roleName(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

