/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class OpenResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, OpenResponse> {
    @Nullable
    private final Boolean acknowledged;
    @Nonnull
    private final Map<String, JsonData> metadata;
    @Nullable
    private final Boolean shardsAcknowledged;
    @Nullable
    private final String task;
    public static final JsonpDeserializer<OpenResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenResponse::setupOpenResponseDeserializer);

    private OpenResponse(Builder builder) {
        this.acknowledged = builder.acknowledged;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.shardsAcknowledged = builder.shardsAcknowledged;
        this.task = builder.task;
    }

    public static OpenResponse of(Function<Builder, ObjectBuilder<OpenResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean acknowledged() {
        return this.acknowledged;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final Boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Nullable
    public final String task() {
        return this.task;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.acknowledged != null) {
            generator.writeKey("acknowledged");
            generator.write(this.acknowledged.booleanValue());
        }
        if (this.shardsAcknowledged != null) {
            generator.writeKey("shards_acknowledged");
            generator.write(this.shardsAcknowledged.booleanValue());
        }
        if (this.task != null) {
            generator.writeKey("task");
            generator.write(this.task);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupOpenResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
        op.add(Builder::task, JsonpDeserializer.stringDeserializer(), "task");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.acknowledged);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.shardsAcknowledged);
        result = 31 * result + Objects.hashCode(this.task);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenResponse other = (OpenResponse)o;
        return Objects.equals(this.acknowledged, other.acknowledged) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.shardsAcknowledged, other.shardsAcknowledged) && Objects.equals(this.task, other.task);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, OpenResponse> {
        @Nullable
        private Boolean acknowledged;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Boolean shardsAcknowledged;
        @Nullable
        private String task;

        public Builder() {
        }

        private Builder(OpenResponse o) {
            this.acknowledged = o.acknowledged;
            this.metadata = Builder._mapCopy(o.metadata);
            this.shardsAcknowledged = o.shardsAcknowledged;
            this.task = o.task;
        }

        private Builder(Builder o) {
            this.acknowledged = o.acknowledged;
            this.metadata = Builder._mapCopy(o.metadata);
            this.shardsAcknowledged = o.shardsAcknowledged;
            this.task = o.task;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder acknowledged(@Nullable Boolean value) {
            this.acknowledged = value;
            return this;
        }

        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder shardsAcknowledged(@Nullable Boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Nonnull
        public final Builder task(@Nullable String value) {
            this.task = value;
            return this;
        }

        @Override
        @Nonnull
        public OpenResponse build() {
            this._checkSingleUse();
            return new OpenResponse(this);
        }
    }
}

