/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.support.XContentHttpChunk;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.http.HttpChunk;
import org.opensearch.ml.action.prediction.TransportPredictionStreamTaskAction;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.input.remote.RemoteInferenceMLInput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.StreamingRestChannel;
import org.opensearch.transport.StreamTransportResponseHandler;
import org.opensearch.transport.StreamTransportService;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.client.node.NodeClient;
import org.opensearch.transport.stream.StreamTransportResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RestMLPredictionStreamAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLPredictionStreamAction.class);
    private static final String ML_PREDICTION_STREAM_ACTION = "ml_prediction_stream_action";
    private MLModelManager modelManager;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private ClusterService clusterService;

    public RestMLPredictionStreamAction(MLModelManager modelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting, ClusterService clusterService) {
        this.modelManager = modelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.clusterService = clusterService;
    }

    public String getName() {
        return ML_PREDICTION_STREAM_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_predict/stream", "/_plugins/_ml", "model_id")));
    }

    public boolean supportsContentStream() {
        return true;
    }

    public boolean supportsStreaming() {
        return true;
    }

    public boolean allowsUnsafeBuffers() {
        return true;
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isStreamEnabled()) {
            throw new IllegalStateException("Streaming is currently disabled. To enable it, update the setting \"plugins.ml_commons.stream_enabled\" to true.");
        }
        String userAlgorithm = request.param("algorithm");
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        Optional<FunctionName> functionName = this.modelManager.getOptionalModelFunctionName(modelId);
        if (!functionName.isPresent() && !this.isModelValid(modelId, request, client)) {
            throw new OpenSearchStatusException("Failed to find model", RestStatus.NOT_FOUND, new Object[0]);
        }
        return channel -> {
            StreamingRestChannel streamingChannel = (StreamingRestChannel)channel;
            Map<String, List<String>> headers = Map.of("Content-Type", List.of("text/event-stream"), "Cache-Control", List.of("no-cache"), "Connection", List.of("keep-alive"));
            streamingChannel.prepareResponse(RestStatus.OK, headers);
            Flux.from((Publisher)streamingChannel).ofType(HttpChunk.class).concatMap(chunk -> {
                CompletableFuture<HttpChunk> future = new CompletableFuture<HttpChunk>();
                try {
                    BytesReference chunkContent = chunk.content();
                    if (functionName.isPresent()) {
                        MLPredictionTaskRequest taskRequest = this.getRequest(modelId, ((FunctionName)functionName.get()).name(), request, chunkContent);
                        this.executeStreamingRequest(client, taskRequest, streamingChannel, future);
                    } else {
                        this.loadModelAndExecuteStreaming(client, modelId, userAlgorithm, request, chunkContent, streamingChannel, future);
                    }
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
                return Mono.fromCompletionStage(future);
            }).doOnNext(arg_0 -> ((StreamingRestChannel)streamingChannel).sendChunk(arg_0)).onErrorComplete(ex -> {
                try {
                    streamingChannel.sendResponse((RestResponse)new BytesRestResponse((RestChannel)streamingChannel, (Exception)ex));
                    return true;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).subscribe();
        };
    }

    private boolean isModelValid(String modelId, RestRequest request, NodeClient client) throws IOException {
        try {
            CompletableFuture future = new CompletableFuture();
            try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
                this.modelManager.getModel(modelId, TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request), (ActionListener<MLModel>)ActionListener.runBefore((ActionListener)ActionListener.wrap(future::complete, future::completeExceptionally), () -> ((ThreadContext.StoredContext)context).restore()));
            }
            future.get(5L, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to validate model {}", (Object)e.getMessage());
            return false;
        }
    }

    private void loadModelAndExecuteStreaming(NodeClient client, String modelId, String userAlgorithm, RestRequest request, BytesReference chunkContent, StreamingRestChannel channel, CompletableFuture<HttpChunk> future) {
        ActionListener listener = ActionListener.wrap(mlModel -> {
            try {
                String modelType = mlModel.getAlgorithm().name();
                String modelAlgorithm = Objects.requireNonNullElse(userAlgorithm, modelType);
                MLPredictionTaskRequest taskRequest = this.getRequest(modelId, modelAlgorithm, request, chunkContent);
                this.executeStreamingRequest(client, taskRequest, channel, future);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        }, future::completeExceptionally);
        try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
            this.modelManager.getModel(modelId, TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request), (ActionListener<MLModel>)ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
    }

    private void executeStreamingRequest(final NodeClient client, MLPredictionTaskRequest taskRequest, final StreamingRestChannel channel, final CompletableFuture<HttpChunk> future) {
        StreamTransportResponseHandler<MLTaskResponse> handler = new StreamTransportResponseHandler<MLTaskResponse>(){

            public void handleStreamResponse(StreamTransportResponse<MLTaskResponse> streamResponse) {
                try {
                    MLTaskResponse response = (MLTaskResponse)streamResponse.nextResponse();
                    if (response != null) {
                        HttpChunk responseChunk = RestMLPredictionStreamAction.this.convertToHttpChunk(response);
                        channel.sendChunk(responseChunk);
                        client.threadPool().executor("opensearch_ml_predict_stream").execute(() -> this.handleStreamResponse(streamResponse));
                    } else {
                        log.info("No more responses, closing stream");
                        streamResponse.close();
                        future.complete(XContentHttpChunk.last());
                    }
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    log.error("Error in stream handling", (Throwable)e);
                }
            }

            public void handleException(TransportException exp) {
                future.completeExceptionally((Throwable)exp);
            }

            public String executor() {
                return "same";
            }

            public MLTaskResponse read(StreamInput in) throws IOException {
                return new MLTaskResponse(in);
            }
        };
        StreamTransportService streamTransportService = TransportPredictionStreamTaskAction.getStreamTransportService();
        streamTransportService.sendRequest(this.clusterService.localNode(), "cluster:admin/opensearch/ml/predict/stream", (TransportRequest)taskRequest, TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STREAM).build(), (TransportResponseHandler)handler);
    }

    @VisibleForTesting
    MLPredictionTaskRequest getRequest(String modelId, String algorithm, RestRequest request, BytesReference content) throws IOException {
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        ConnectorAction.ActionType actionType = ConnectorAction.ActionType.from((String)RestActionUtils.getActionTypeFromRestRequest(request));
        if (!FunctionName.REMOTE.name().equals(algorithm)) {
            throw new IllegalStateException("Streaming is only supported for remote models");
        }
        if (!this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (ConnectorAction.ActionType.BATCH_PREDICT == actionType) {
            throw new IllegalStateException("Streaming is not supported for batch predict.");
        }
        if (!ConnectorAction.ActionType.isValidActionInModelPrediction((ConnectorAction.ActionType)actionType)) {
            throw new IllegalArgumentException("Wrong action type in the rest request path!");
        }
        XContentParser parser = request.getMediaType().xContent().createParser(request.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)content.streamInput());
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = MLInput.parse((XContentParser)parser, (String)algorithm, (ConnectorAction.ActionType)actionType);
        if (FunctionName.REMOTE.name().contentEquals(algorithm)) {
            RemoteInferenceMLInput input = (RemoteInferenceMLInput)mlInput;
            RemoteInferenceInputDataSet inputDataSet = (RemoteInferenceInputDataSet)input.getInputDataset();
            inputDataSet.getParameters().put("stream", String.valueOf(true));
            return new MLPredictionTaskRequest(modelId, (MLInput)input, null, tenantId);
        }
        return new MLPredictionTaskRequest(modelId, mlInput, null, tenantId);
    }

    private HttpChunk convertToHttpChunk(MLTaskResponse response) throws IOException {
        Object sseData;
        boolean isLast = false;
        try {
            Map<String, ?> dataMap = this.extractDataMap(response);
            if (dataMap.containsKey("error")) {
                String errorMessage = (String)dataMap.get("error");
                sseData = String.format("data: {\"error\": \"%s\"}\n\n", errorMessage.replace("\"", "\\\"").replace("\n", "\\n"));
                isLast = true;
            } else {
                String content = dataMap.containsKey("content") ? (String)dataMap.get("content") : "";
                isLast = dataMap.containsKey("is_last") ? Boolean.TRUE.equals(dataMap.get("is_last")) : false;
                LinkedHashMap<String, Object> chunkData = new LinkedHashMap<String, Object>();
                chunkData.put("content", content);
                chunkData.put("is_last", isLast);
                ModelTensor tensor = ModelTensor.builder().name("response").dataAsMap(chunkData).build();
                ModelTensors tensors = ModelTensors.builder().mlModelTensors(List.of(tensor)).build();
                ModelTensorOutput tensorOutput = ModelTensorOutput.builder().mlModelOutputs(List.of(tensors)).build();
                XContentBuilder builder = XContentFactory.jsonBuilder();
                tensorOutput.toXContent(builder, ToXContent.EMPTY_PARAMS);
                sseData = "data: " + builder.toString() + "\n\n";
            }
        }
        catch (Exception e) {
            log.error("Failed to process response", (Throwable)e);
            sseData = "data: {\"error\": \"Processing failed\"}\n\n";
            isLast = true;
        }
        return this.createHttpChunk((String)sseData, isLast);
    }

    private Map<String, ?> extractDataMap(MLTaskResponse response) {
        ModelTensors tensors;
        ModelTensorOutput output = (ModelTensorOutput)response.getOutput();
        if (output != null && !output.getMlModelOutputs().isEmpty() && !(tensors = (ModelTensors)output.getMlModelOutputs().get(0)).getMlModelTensors().isEmpty()) {
            return ((ModelTensor)tensors.getMlModelTensors().get(0)).getDataAsMap();
        }
        return Map.of();
    }

    private HttpChunk createHttpChunk(String sseData, final boolean isLast) {
        final BytesReference bytesRef = BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(sseData.getBytes()));
        return new HttpChunk(){

            public void close() {
                if (bytesRef instanceof Releasable) {
                    ((Releasable)bytesRef).close();
                }
            }

            public boolean isLast() {
                return isLast;
            }

            public BytesReference content() {
                return bytesRef;
            }
        };
    }
}

