/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.settings;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.SettingsChangeListener;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;

public class MLFeatureEnabledSetting {
    private volatile Boolean isRemoteInferenceEnabled;
    private volatile Boolean isAgentFrameworkEnabled;
    private volatile Boolean isLocalModelEnabled;
    private volatile Boolean isConnectorPrivateIpEnabled;
    private volatile Boolean isControllerEnabled;
    private volatile Boolean isBatchIngestionEnabled;
    private volatile Boolean isBatchInferenceEnabled;
    private volatile Boolean isMultiTenancyEnabled;
    private volatile Boolean isMcpServerEnabled;
    private volatile Boolean isRagSearchPipelineEnabled;
    private volatile Boolean isMetricCollectionEnabled;
    private volatile Boolean isStaticMetricCollectionEnabled;
    private volatile Boolean isExecuteToolEnabled;
    private volatile Boolean isMcpConnectorEnabled;
    private volatile Boolean isAgenticMemoryEnabled;
    private volatile Boolean isIndexInsightEnabled;
    private volatile Boolean isStreamEnabled;
    private final List<SettingsChangeListener> listeners = new ArrayList<SettingsChangeListener>();

    public MLFeatureEnabledSetting(ClusterService clusterService, Settings settings) {
        this.isRemoteInferenceEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED.get(settings);
        this.isAgentFrameworkEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_AGENT_FRAMEWORK_ENABLED.get(settings);
        this.isLocalModelEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ENABLED.get(settings);
        this.isConnectorPrivateIpEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_CONNECTOR_PRIVATE_IP_ENABLED.get(settings);
        this.isControllerEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_CONTROLLER_ENABLED.get(settings);
        this.isBatchIngestionEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INGESTION_ENABLED.get(settings);
        this.isBatchInferenceEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INFERENCE_ENABLED.get(settings);
        this.isMultiTenancyEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MULTI_TENANCY_ENABLED.get(settings);
        this.isMcpServerEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MCP_SERVER_ENABLED.get(settings);
        this.isRagSearchPipelineEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_RAG_PIPELINE_FEATURE_ENABLED.get(settings);
        this.isMetricCollectionEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_METRIC_COLLECTION_ENABLED.get(settings);
        this.isStaticMetricCollectionEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_STATIC_METRIC_COLLECTION_ENABLED.get(settings);
        this.isExecuteToolEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_EXECUTE_TOOL_ENABLED.get(settings);
        this.isMcpConnectorEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MCP_CONNECTOR_ENABLED.get(settings);
        this.isAgenticMemoryEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_ENABLED.get(settings);
        this.isIndexInsightEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_INDEX_INSIGHT_FEATURE_ENABLED.get(settings);
        this.isStreamEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_STREAM_ENABLED.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED, it -> {
            this.isRemoteInferenceEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_AGENT_FRAMEWORK_ENABLED, it -> {
            this.isAgentFrameworkEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ENABLED, it -> {
            this.isLocalModelEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_CONNECTOR_PRIVATE_IP_ENABLED, it -> {
            this.isConnectorPrivateIpEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_CONTROLLER_ENABLED, it -> {
            this.isControllerEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INGESTION_ENABLED, it -> {
            this.isBatchIngestionEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INFERENCE_ENABLED, it -> {
            this.isBatchInferenceEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MCP_SERVER_ENABLED, it -> {
            this.isMcpServerEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_RAG_PIPELINE_FEATURE_ENABLED, it -> {
            this.isRagSearchPipelineEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_EXECUTE_TOOL_ENABLED, it -> {
            this.isExecuteToolEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MCP_CONNECTOR_ENABLED, it -> {
            this.isMcpConnectorEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_ENABLED, it -> {
            this.isAgenticMemoryEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_STREAM_ENABLED, it -> {
            this.isStreamEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_INDEX_INSIGHT_FEATURE_ENABLED, it -> {
            this.isIndexInsightEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_STATIC_METRIC_COLLECTION_ENABLED, it -> {
            this.isStaticMetricCollectionEnabled = it;
            for (SettingsChangeListener listener : this.listeners) {
                listener.onStaticMetricCollectionEnabledChanged((boolean)it);
            }
        });
    }

    public boolean isRemoteInferenceEnabled() {
        return this.isRemoteInferenceEnabled;
    }

    public boolean isAgentFrameworkEnabled() {
        return this.isAgentFrameworkEnabled;
    }

    public boolean isLocalModelEnabled() {
        return this.isLocalModelEnabled;
    }

    public boolean isConnectorPrivateIpEnabled() {
        return this.isConnectorPrivateIpEnabled;
    }

    public Boolean isControllerEnabled() {
        return this.isControllerEnabled;
    }

    public Boolean isOfflineBatchIngestionEnabled() {
        return this.isBatchIngestionEnabled;
    }

    public Boolean isOfflineBatchInferenceEnabled() {
        return this.isBatchInferenceEnabled;
    }

    public boolean isMultiTenancyEnabled() {
        return this.isMultiTenancyEnabled;
    }

    public boolean isMcpServerEnabled() {
        return this.isMcpServerEnabled;
    }

    public void addListener(SettingsChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean isRagSearchPipelineEnabled() {
        return this.isRagSearchPipelineEnabled;
    }

    public boolean isMetricCollectionEnabled() {
        return this.isMetricCollectionEnabled;
    }

    public boolean isStaticMetricCollectionEnabled() {
        return this.isStaticMetricCollectionEnabled;
    }

    public boolean isToolExecuteEnabled() {
        return this.isExecuteToolEnabled;
    }

    public boolean isAgenticMemoryEnabled() {
        return this.isAgenticMemoryEnabled;
    }

    @VisibleForTesting
    public void notifyMultiTenancyListeners(boolean isEnabled) {
        for (SettingsChangeListener listener : this.listeners) {
            listener.onMultiTenancyEnabledChanged(isEnabled);
        }
    }

    public boolean isMcpConnectorEnabled() {
        return this.isMcpConnectorEnabled;
    }

    public boolean isIndexInsightEnabled() {
        return this.isIndexInsightEnabled;
    }

    public boolean isStreamEnabled() {
        return this.isStreamEnabled;
    }
}

