# This file has been autogenerated by the pywayland scanner

# Copyright 2023 David Redondo
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlDataSource
from .xdg_toplevel_drag_v1 import XdgToplevelDragV1


class XdgToplevelDragManagerV1(Interface):
    """Move a window during a drag

    This protocol enhances normal drag and drop with the ability to move a
    window at the same time. This allows having detachable parts of a window
    that when dragged out of it become a new window and can be dragged over an
    existing window to be reattached.

    A typical workflow would be when the user starts dragging on top of a
    detachable part of a window, the client would create a
    :class:`~pywayland.protocol.wayland.WlDataSource` and a
    :class:`~pywayland.protocol.xdg_toplevel_drag_v1.XdgToplevelDragV1` object
    and start the drag as normal via :func:`WlDataDevice.start_drag()
    <pywayland.protocol.wayland.WlDataDevice.start_drag>`. Once the client
    determines that the detachable window contents should be detached from the
    originating window, it creates a new
    :class:`~pywayland.protocol.xdg_shell.XdgToplevel` with these contents and
    issues a :func:`XdgToplevelDragV1.attach()
    <pywayland.protocol.xdg_toplevel_drag_v1.XdgToplevelDragV1.attach>` request
    before mapping it. From now on the new window is moved by the compositor
    during the drag as if the client called :func:`XdgToplevel.move()
    <pywayland.protocol.xdg_shell.XdgToplevel.move>`.

    Dragging an existing window is similar. The client creates a
    :class:`~pywayland.protocol.xdg_toplevel_drag_v1.XdgToplevelDragV1` object
    and attaches the existing toplevel before starting the drag.

    Clients use the existing drag and drop mechanism to detect when a window
    can be docked or undocked. If the client wants to snap a window into a
    parent window it should delete or unmap the dragged top-level. If the
    contents should be detached again it attaches a new toplevel as described
    above. If a drag operation is cancelled without being dropped, clients
    should revert to the previous state, deleting any newly created windows as
    appropriate. When a drag operation ends as indicated by
    :func:`WlDataSource.dnd_drop_performed()
    <pywayland.protocol.wayland.WlDataSource.dnd_drop_performed>` the dragged
    toplevel window's final position is determined as if a xdg_toplevel_move
    operation ended.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "xdg_toplevel_drag_manager_v1"
    version = 1

    class error(enum.IntEnum):
        invalid_source = 0


class XdgToplevelDragManagerV1Proxy(Proxy[XdgToplevelDragManagerV1]):
    interface = XdgToplevelDragManagerV1

    @XdgToplevelDragManagerV1.request()
    def destroy(self) -> None:
        """Destroy the :class:`XdgToplevelDragManagerV1` object

        Destroy this :class:`XdgToplevelDragManagerV1` object. Other objects,
        including
        :class:`~pywayland.protocol.xdg_toplevel_drag_v1.XdgToplevelDragV1`
        objects created by this factory, are not affected by this request.
        """
        self._marshal(0)
        self._destroy()

    @XdgToplevelDragManagerV1.request(
        Argument(ArgumentType.NewId, interface=XdgToplevelDragV1),
        Argument(ArgumentType.Object, interface=WlDataSource),
    )
    def get_xdg_toplevel_drag(self, data_source: WlDataSource) -> Proxy[XdgToplevelDragV1]:
        """Get an xdg_toplevel_drag for a :class:`~pywayland.protocol.wayland.WlDataSource`

        Create an xdg_toplevel_drag for a drag and drop operation that is going
        to be started with data_source.

        This request can only be made on sources used in drag-and-drop, so it
        must be performed before :func:`WlDataDevice.start_drag()
        <pywayland.protocol.wayland.WlDataDevice.start_drag>`. Attempting to
        use the source other than for drag-and-drop such as in
        :func:`WlDataDevice.set_selection()
        <pywayland.protocol.wayland.WlDataDevice.set_selection>` will raise an
        invalid_source error.

        Destroying data_source while a toplevel is attached to the
        xdg_toplevel_drag is undefined.

        :param data_source:
        :type data_source:
            :class:`~pywayland.protocol.wayland.WlDataSource`
        :returns:
            :class:`~pywayland.protocol.xdg_toplevel_drag_v1.XdgToplevelDragV1`
        """
        id = self._marshal_constructor(1, XdgToplevelDragV1, data_source)
        return id


class XdgToplevelDragManagerV1Resource(Resource):
    interface = XdgToplevelDragManagerV1


class XdgToplevelDragManagerV1Global(Global):
    interface = XdgToplevelDragManagerV1


XdgToplevelDragManagerV1._gen_c()
XdgToplevelDragManagerV1.proxy_class = XdgToplevelDragManagerV1Proxy
XdgToplevelDragManagerV1.resource_class = XdgToplevelDragManagerV1Resource
XdgToplevelDragManagerV1.global_class = XdgToplevelDragManagerV1Global
