/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.cff;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.cff.CffStandardStrings;
import jogamp.graph.font.typecast.cff.Index;

public class StringIndex
extends Index {
    public StringIndex(DataInput dataInput) throws IOException {
        super(dataInput);
    }

    public String getString(int n) {
        if (n < CffStandardStrings.standardStrings.length) {
            return CffStandardStrings.standardStrings[n];
        }
        if ((n -= CffStandardStrings.standardStrings.length) >= this.getCount()) {
            return null;
        }
        int n2 = this.getOffset(n) - 1;
        int n3 = this.getOffset(n + 1) - n2 - 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < n2 + n3; ++i) {
            stringBuilder.append((char)this.getData()[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        int n = CffStandardStrings.standardStrings.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getCount(); ++i) {
            stringBuilder.append(n + i).append(": ");
            stringBuilder.append(this.getString(n + i)).append("\n");
        }
        return stringBuilder.toString();
    }
}

