/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.Glossary;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsType;
import java.io.IOException;

public abstract class AbstractGlsCommand
extends Command {
    protected GlossariesSty sty;
    protected String entryLabelPrefix = "";

    public AbstractGlsCommand(String string, GlossariesSty glossariesSty) {
        super(string);
        this.sty = glossariesSty;
    }

    protected GlossaryEntry getEntry(String string) {
        return this.sty.getEntry(string);
    }

    protected Glossary getGlossary(String string) {
        return this.sty.getGlossary(string);
    }

    protected GlsLabel expandToEntryLabel(String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandToEntryLabel(teXParser.getListener().getControlSequence(string), teXParser, teXObjectList);
    }

    protected GlsLabel expandToEntryLabel(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof TeXObjectList && ((TeXObjectList)teXObject).size() == 1) {
            teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
        }
        if (teXObject instanceof GlsLabel) {
            return (GlsLabel)teXObject;
        }
        String string = teXParser.expandToString(teXObject, teXObjectList);
        GlossaryEntry glossaryEntry = this.getEntry(string);
        return new GlsLabel("@@glslabel@" + string, string, glossaryEntry);
    }

    protected TeXObject getFieldValue(GlsLabel glsLabel, String string) {
        if (glsLabel == null) {
            return null;
        }
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        TeXObject teXObject = null;
        if (glossaryEntry == null) {
            ControlSequence controlSequence = this.sty.getParser().getControlSequence(String.format("glo@%s@%s", glsLabel.getLabel(), string));
            if (controlSequence != null) {
                teXObject = controlSequence instanceof GenericCommand ? (TeXObject)((GenericCommand)controlSequence).getDefinition().clone() : controlSequence;
            }
        } else {
            teXObject = glossaryEntry.get(string);
        }
        return teXObject;
    }

    protected KeyValList popModifier(TeXObjectList teXObjectList) throws IOException {
        return this.sty.popModifier(teXObjectList);
    }

    protected KeyValList popOptKeyValList(TeXObjectList teXObjectList) throws IOException {
        return this.sty.popOptKeyValList(teXObjectList);
    }

    protected KeyValList popOptKeyValList(TeXObjectList teXObjectList, boolean bl) throws IOException {
        return this.sty.popOptKeyValList(teXObjectList, bl);
    }

    protected KeyValList popKeyValList(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        if (teXObject instanceof KeyValList) {
            return (KeyValList)teXObject;
        }
        return KeyValList.getList(teXParser, teXObject);
    }

    public void setEntryLabelPrefix(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.entryLabelPrefix = string;
    }

    public String getEntryLabelPrefix() {
        return this.entryLabelPrefix;
    }

    protected GlsLabel popEntryLabel(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = null;
        TeXObject teXObject2 = null;
        if (teXObjectList != null && !teXObjectList.isEmpty() && (teXObject = (TeXObject)teXObjectList.firstElement()) instanceof GlsLabel && ((GlsLabel)teXObject).getEntry() != null) {
            teXObject2 = (GlsLabel)teXObjectList.remove(0);
        }
        if (teXObject2 == null) {
            teXObject = this.popArg(teXParser, teXObjectList);
            if (teXObject instanceof GlsLabel) {
                teXObject2 = (GlsLabel)teXObject;
            }
        } else {
            teXObject = teXObject2;
        }
        String string = this.getEntryLabelPrefix();
        if (teXObject2 != null && (!string.isEmpty() || ((GlsLabel)teXObject2).getLabel().startsWith(string))) {
            ((GlsLabel)teXObject2).refresh(this.sty);
            return teXObject2;
        }
        String string2 = string + teXParser.expandToString(teXObject, teXObjectList);
        GlossaryEntry glossaryEntry = this.getEntry(string2);
        return new GlsLabel("@@glslabel@" + string2, string2, glossaryEntry);
    }

    protected GlsLabel popEntryLabel(String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string2;
        TeXObject teXObject = null;
        String string3 = this.getEntryLabelPrefix();
        GlsLabel glsLabel = null;
        if (teXObjectList != null && !teXObjectList.isEmpty() && (teXObject = (TeXObject)teXObjectList.firstElement()) instanceof GlsLabel) {
            glsLabel = (GlsLabel)teXObjectList.remove(0);
        }
        if (glsLabel == null && (teXObject = this.popArg(teXParser, teXObjectList)) instanceof GlsLabel) {
            glsLabel = (GlsLabel)teXObject;
        }
        if (glsLabel != null) {
            if ((string3.isEmpty() || glsLabel.getLabel().startsWith(string3)) && glsLabel.getName().equals(string)) {
                if (glsLabel.getEntry() == null) {
                    glsLabel.refresh(this.sty);
                }
                return glsLabel;
            }
            string2 = string3 + glsLabel.getLabel();
        } else {
            string2 = string3 + teXParser.expandToString(teXObject, teXObjectList);
        }
        GlossaryEntry glossaryEntry = this.getEntry(string2);
        return new GlsLabel(string, string2, glossaryEntry);
    }

    protected GlsType popGlossaryLabel(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        if (teXObject instanceof GlsType) {
            ((GlsType)teXObject).refresh(this.sty);
            return (GlsType)teXObject;
        }
        String string = teXParser.expandToString(teXObject, teXObjectList);
        Glossary glossary = this.getGlossary(string);
        return new GlsType("@@glstype@" + string, string, glossary);
    }

    protected void setCurrentAbbreviationStyle(String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        ControlSequence controlSequence = teXParser.getControlSequence("@glsabbrv@current@" + string);
        if (controlSequence == null) {
            controlSequence = teXParser.getControlSequence("@glsabbrv@current@abbreviation");
        }
        if (controlSequence != null) {
            String string2 = teXParser.expandToString(controlSequence, teXObjectList);
            controlSequence = teXParser.getControlSequence("@glsabbrv@dispstyle@setup@" + string2);
            if (controlSequence != null) {
                if (teXObjectList == teXParser || teXObjectList == null) {
                    controlSequence.process(teXParser);
                } else {
                    controlSequence.process(teXParser, teXObjectList);
                }
            }
            if ((controlSequence = teXParser.getControlSequence("@glsabbrv@dispstyle@fmts@" + string2)) != null) {
                if (teXObjectList == teXParser || teXObjectList == null) {
                    controlSequence.process(teXParser);
                } else {
                    controlSequence.process(teXParser, teXObjectList);
                }
            }
        }
    }

    protected void setCurrentAbbreviationStyleFmts(String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        ControlSequence controlSequence = teXParser.getControlSequence("@glsabbrv@current@" + string);
        if (controlSequence == null) {
            controlSequence = teXParser.getControlSequence("@glsabbrv@current@abbreviation");
        }
        if (controlSequence != null) {
            String string2 = teXParser.expandToString(controlSequence, teXObjectList);
            controlSequence = teXParser.getControlSequence("@glsabbrv@dispstyle@fmts@" + string2);
            if (controlSequence != null) {
                if (teXObjectList == teXParser || teXObjectList == null) {
                    controlSequence.process(teXParser);
                } else {
                    controlSequence.process(teXParser, teXObjectList);
                }
            }
        }
    }

    public GlossariesSty getSty() {
        return this.sty;
    }
}

