/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rdr.ZlibInStream;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.JpegDecompressor;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ServerParams;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class TightDecoder
extends Decoder {
    static final int TIGHT_MAX_WIDTH = 2048;
    static final int TIGHT_MIN_TO_COMPRESS = 12;
    static final int tightExplicitFilter = 4;
    static final int tightFill = 8;
    static final int tightJpeg = 9;
    static final int tightMaxSubencoding = 9;
    static final int tightFilterCopy = 0;
    static final int tightFilterPalette = 1;
    static final int tightFilterGradient = 2;
    private ZlibInStream[] zis = new ZlibInStream[4];

    public TightDecoder() {
        super(Decoder.DecoderFlags.DecoderPartiallyOrdered);
        for (int i = 0; i < 4; ++i) {
            this.zis[i] = new ZlibInStream();
        }
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ServerParams serverParams, OutStream outStream) {
        int n;
        int n2 = inStream.readU8();
        outStream.writeU8(n2);
        if ((n2 >>= 4) == 8) {
            if (serverParams.pf().is888()) {
                outStream.copyBytes(inStream, 3);
            } else {
                outStream.copyBytes(inStream, serverParams.pf().bpp / 8);
            }
            return;
        }
        if (n2 == 9) {
            int n3 = this.readCompact(inStream);
            outStream.writeOpaque32(n3);
            outStream.copyBytes(inStream, n3);
            return;
        }
        if (n2 > 9) {
            throw new Exception("TightDecoder: bad subencoding value received");
        }
        int n4 = 0;
        if (rect.width() > 2048) {
            throw new Exception("TightDecoder: too large rectangle (" + rect.width() + " pixels)");
        }
        if ((n2 & 4) != 0) {
            n = inStream.readU8() & 0xFF;
            outStream.writeU8(n);
            switch (n) {
                case 1: {
                    n4 = inStream.readU8() + 1;
                    outStream.writeU32(n4 - 1);
                    if (serverParams.pf().is888()) {
                        outStream.copyBytes(inStream, n4 * 3);
                        break;
                    }
                    outStream.copyBytes(inStream, n4 * serverParams.pf().bpp / 8);
                    break;
                }
                case 2: {
                    if (serverParams.pf().bpp != 8) break;
                    throw new Exception("TightDecoder: invalid BPP for gradient filter");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new Exception("TightDecoder: unknown filter code received");
                }
            }
        }
        n = n4 != 0 ? (n4 <= 2 ? (rect.width() + 7) / 8 : rect.width()) : (serverParams.pf().is888() ? rect.width() * 3 : rect.width() * serverParams.pf().bpp / 8);
        int n5 = rect.height() * n;
        if (n5 < 12) {
            outStream.copyBytes(inStream, n5);
        } else {
            int n6 = this.readCompact(inStream);
            outStream.writeOpaque32(n6);
            outStream.copyBytes(inStream, n6);
        }
    }

    @Override
    public boolean doRectsConflict(Rect rect, Object object, int n, Rect rect2, Object object2, int n2, ServerParams serverParams) {
        assert (n >= 1);
        assert (n2 >= 1);
        byte by = ((byte[])object)[0];
        byte by2 = ((byte[])object2)[0];
        if ((by & 0x80) == 0) {
            by = (byte)(by | 1 << (by >> 4 & 3));
        }
        if ((by2 & 0x80) == 0) {
            by2 = (byte)(by2 | 1 << (by2 >> 4 & 3));
        }
        return (by & 0xF & (by2 & 0xF)) != 0;
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ServerParams serverParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        Object object2;
        int n2;
        int n3;
        int n4;
        PixelFormat pixelFormat = serverParams.pf();
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
        assert (n >= 1);
        int n5 = byteBuffer.get() & 0xFF;
        --n;
        for (n4 = 0; n4 < 4; ++n4) {
            if ((n5 & 1) != 0) {
                this.zis[n4].reset();
            }
            n5 >>= 1;
        }
        if (n5 == 8) {
            if (pixelFormat.is888()) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
                assert (n >= 3);
                pixelFormat.bufferFromRGB(byteBuffer2.duplicate(), byteBuffer, 1);
                modifiablePixelBuffer.fillRect(pixelFormat, rect, byteBuffer2.array());
            } else {
                assert (n >= pixelFormat.bpp / 8);
                byte[] byArray = new byte[pixelFormat.bpp / 8];
                byteBuffer.get(byArray);
                modifiablePixelBuffer.fillRect(pixelFormat, rect, byArray);
            }
            return;
        }
        if (n5 == 9) {
            JpegDecompressor jpegDecompressor = new JpegDecompressor();
            assert (n >= 4);
            n4 = byteBuffer.getInt();
            n -= 4;
            jpegDecompressor.decompress(byteBuffer, n4, modifiablePixelBuffer, rect, modifiablePixelBuffer.getPF());
            modifiablePixelBuffer.commitBufferRW(rect);
            return;
        }
        if (n5 > 9) {
            throw new Exception("TightDecoder: bad subencoding value received");
        }
        n4 = 0;
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(1024);
        boolean bl = false;
        if ((n5 & 4) != 0) {
            assert (n >= 1);
            n3 = byteBuffer.get();
            switch (n3) {
                case 1: {
                    assert (n >= 1);
                    n4 = byteBuffer.getInt() + 1;
                    n -= 4;
                    if (pixelFormat.is888()) {
                        ByteBuffer byteBuffer4 = ByteBuffer.allocate(n4 * 3);
                        assert (n >= byteBuffer4.capacity());
                        byteBuffer.get(byteBuffer4.array(), 0, byteBuffer4.capacity());
                        n -= byteBuffer4.capacity();
                        pixelFormat.bufferFromRGB(byteBuffer3.duplicate(), byteBuffer4, n4);
                        break;
                    }
                    int n6 = n4 * pixelFormat.bpp / 8;
                    assert (n >= n6);
                    byteBuffer.get(byteBuffer3.array(), 0, n6);
                    n -= n6;
                    break;
                }
                case 2: {
                    bl = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        n3 = n4 != 0 ? (n4 <= 2 ? (rect.width() + 7) / 8 : rect.width()) : (pixelFormat.is888() ? rect.width() * 3 : rect.width() * pixelFormat.bpp / 8);
        int n7 = rect.height() * n3;
        if (n7 < 12) {
            assert (n >= n7);
        } else {
            assert (n >= 4);
            int n8 = byteBuffer.getInt();
            assert ((n -= 4) >= n8);
            n2 = n5 & 3;
            object2 = new MemInStream(byteBuffer.array(), byteBuffer.position(), n8);
            this.zis[n2].setUnderlying((InStream)object2, n8);
            ByteBuffer byteBuffer5 = ByteBuffer.allocate(n7);
            this.zis[n2].readBytes(byteBuffer5, n7);
            this.zis[n2].flushUnderlying();
            this.zis[n2].setUnderlying(null, 0);
            object2 = null;
            byteBuffer = (ByteBuffer)byteBuffer5.flip();
            n = n7;
        }
        ByteBuffer byteBuffer6 = ByteBuffer.allocate(rect.area() * pixelFormat.bpp / 8);
        n2 = rect.width();
        if (n4 == 0) {
            if (bl) {
                if (pixelFormat.is888()) {
                    this.FilterGradient24(byteBuffer, pixelFormat, byteBuffer6, n2, rect);
                } else {
                    switch (pixelFormat.bpp) {
                        case 8: {
                            assert (false);
                            break;
                        }
                        case 16: {
                            this.FilterGradient(byteBuffer, pixelFormat, byteBuffer6, n2, rect);
                            break;
                        }
                        case 32: {
                            this.FilterGradient(byteBuffer, pixelFormat, byteBuffer6, n2, rect);
                        }
                    }
                }
            } else {
                int n9;
                object2 = (ByteBuffer)byteBuffer6.duplicate().mark();
                ByteBuffer byteBuffer7 = byteBuffer.duplicate();
                int n10 = rect.width();
                if (pixelFormat.is888()) {
                    for (n9 = rect.height(); n9 > 0; --n9) {
                        pixelFormat.bufferFromRGB(((ByteBuffer)object2).duplicate(), byteBuffer7.duplicate(), n10);
                        ((ByteBuffer)object2).position(((Buffer)object2).position() + n2 * pixelFormat.bpp / 8);
                        byteBuffer7.position(byteBuffer7.position() + n10 * 3);
                    }
                } else {
                    while (n9 > 0) {
                        ((ByteBuffer)object2).put(byteBuffer7.array(), byteBuffer7.position(), n10 * pixelFormat.bpp / 8);
                        ((ByteBuffer)object2).reset().position(((Buffer)object2).position() + n2 * pixelFormat.bpp / 8).mark();
                        byteBuffer7.position(byteBuffer7.position() + n10 * pixelFormat.bpp / 8);
                        --n9;
                    }
                }
            }
        } else {
            switch (pixelFormat.bpp) {
                case 8: {
                    this.FilterPalette8(byteBuffer3, n4, byteBuffer, byteBuffer6, n2, rect);
                    break;
                }
                case 16: {
                    this.FilterPalette16(byteBuffer3.asShortBuffer(), n4, byteBuffer, byteBuffer6.asShortBuffer(), n2, rect);
                    break;
                }
                case 32: {
                    this.FilterPalette32(byteBuffer3.asIntBuffer(), n4, byteBuffer, byteBuffer6.asIntBuffer(), n2, rect);
                }
            }
        }
        modifiablePixelBuffer.imageRect(pixelFormat, rect, byteBuffer6.array());
    }

    private final void FilterGradient24(ByteBuffer byteBuffer, PixelFormat pixelFormat, ByteBuffer byteBuffer2, int n, Rect rect) {
        byte[] byArray = new byte[6144];
        byte[] byArray2 = new byte[6144];
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(3);
        int[] nArray = new int[3];
        int n2 = rect.height();
        int n3 = rect.width();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                if (j == 0) {
                    for (n4 = 0; n4 < 3; ++n4) {
                        byteBuffer3.put(n4, (byte)(byteBuffer.get(i * n3 * 3 + n4) + byArray[n4]));
                        byArray2[n4] = byteBuffer3.get(n4);
                    }
                    pixelFormat.bufferFromRGB((ByteBuffer)byteBuffer2.duplicate().position(i * n), byteBuffer3, 1);
                    continue;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    nArray[n4] = byArray[j * 3 + n4] + byteBuffer3.get(n4) - byArray[(j - 1) * 3 + n4];
                    if (nArray[n4] > 255) {
                        nArray[n4] = 255;
                    } else if (nArray[n4] < 0) {
                        nArray[n4] = 0;
                    }
                    byteBuffer3.put(n4, (byte)(byteBuffer.get((i * n3 + j) * 3 + n4) + nArray[n4]));
                    byArray2[j * 3 + n4] = byteBuffer3.get(n4);
                }
                pixelFormat.bufferFromRGB((ByteBuffer)byteBuffer2.duplicate().position(i * n + j), byteBuffer3, 1);
            }
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        }
    }

    private final void FilterGradient(ByteBuffer byteBuffer, PixelFormat pixelFormat, ByteBuffer byteBuffer2, int n, Rect rect) {
        byte[] byArray = new byte[2048];
        byte[] byArray2 = new byte[2048];
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(3);
        int[] nArray = new int[3];
        int n2 = rect.height();
        int n3 = rect.width();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                if (j == 0) {
                    pixelFormat.rgbFromBuffer(byteBuffer3.duplicate(), (ByteBuffer)byteBuffer.position(i * n3), 1);
                    for (n4 = 0; n4 < 3; ++n4) {
                        byteBuffer3.put(n4, (byte)(byteBuffer3.get(n4) + byArray[n4]));
                    }
                    System.arraycopy(byteBuffer3.array(), 0, byArray2, 0, byteBuffer3.capacity());
                    pixelFormat.bufferFromRGB((ByteBuffer)byteBuffer2.duplicate().position(i * n), byteBuffer3, 1);
                    continue;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    nArray[n4] = byArray[j * 3 + n4] + byteBuffer3.get(n4) - byArray[(j - 1) * 3 + n4];
                    if (nArray[n4] > 255) {
                        nArray[n4] = 255;
                        continue;
                    }
                    if (nArray[n4] >= 0) continue;
                    nArray[n4] = 0;
                }
                pixelFormat.rgbFromBuffer(byteBuffer3.duplicate(), (ByteBuffer)byteBuffer.position(i * n3 + j), 1);
                for (n4 = 0; n4 < 3; ++n4) {
                    byteBuffer3.put(n4, (byte)(byteBuffer3.get(n4) + nArray[n4]));
                }
                System.arraycopy(byteBuffer3.array(), 0, byArray2, j * 3, byteBuffer3.capacity());
                pixelFormat.bufferFromRGB((ByteBuffer)byteBuffer2.duplicate().position(i * n + j), byteBuffer3, 1);
            }
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        }
    }

    private void FilterPalette8(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, int n2, Rect rect) {
        int n3;
        int n4 = rect.width();
        int n5 = n2 - n4;
        ByteBuffer byteBuffer4 = byteBuffer3.duplicate();
        ByteBuffer byteBuffer5 = byteBuffer2.duplicate();
        if (n <= 2) {
            for (n3 = rect.height(); n3 > 0; --n3) {
                int n6;
                byte by;
                for (int i = 0; i < n4 / 8; ++i) {
                    by = byteBuffer5.get();
                    for (n6 = 7; n6 >= 0; --n6) {
                        byteBuffer4.put(byteBuffer.get(by >> n6 & 1));
                    }
                }
                if (n4 % 8 != 0) {
                    by = byteBuffer5.get();
                    for (n6 = 7; n6 >= 8 - n4 % 8; --n6) {
                        byteBuffer4.put(byteBuffer.get(by >> n6 & 1));
                    }
                }
                byteBuffer4.position(byteBuffer4.position() + n5);
            }
        } else {
            while (n3 > 0) {
                int n7 = byteBuffer4.position() + n4;
                while (byteBuffer4.position() < n7) {
                    byteBuffer4.put(byteBuffer.get(byteBuffer5.get()));
                }
                byteBuffer4.position(byteBuffer4.position() + n5);
                --n3;
            }
        }
    }

    private void FilterPalette16(ShortBuffer shortBuffer, int n, ByteBuffer byteBuffer, ShortBuffer shortBuffer2, int n2, Rect rect) {
        int n3;
        int n4 = rect.width();
        int n5 = n2 - n4;
        ShortBuffer shortBuffer3 = shortBuffer2.duplicate();
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        if (n <= 2) {
            for (n3 = rect.height(); n3 > 0; --n3) {
                int n6;
                byte by;
                for (int i = 0; i < n4 / 8; ++i) {
                    by = byteBuffer2.get();
                    for (n6 = 7; n6 >= 0; --n6) {
                        shortBuffer3.put(shortBuffer.get(by >> n6 & 1));
                    }
                }
                if (n4 % 8 != 0) {
                    by = byteBuffer2.get();
                    for (n6 = 7; n6 >= 8 - n4 % 8; --n6) {
                        shortBuffer3.put(shortBuffer.get(by >> n6 & 1));
                    }
                }
                shortBuffer3.position(shortBuffer3.position() + n5);
            }
        } else {
            while (n3 > 0) {
                int n7 = shortBuffer3.position() + n4;
                while (shortBuffer3.position() < n7) {
                    shortBuffer3.put(shortBuffer.get(byteBuffer2.get()));
                }
                shortBuffer3.position(shortBuffer3.position() + n5);
                --n3;
            }
        }
    }

    private void FilterPalette32(IntBuffer intBuffer, int n, ByteBuffer byteBuffer, IntBuffer intBuffer2, int n2, Rect rect) {
        int n3;
        int n4 = rect.width();
        int n5 = n2 - n4;
        IntBuffer intBuffer3 = intBuffer2.duplicate();
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        if (n <= 2) {
            for (n3 = rect.height(); n3 > 0; --n3) {
                int n6;
                byte by;
                for (int i = 0; i < n4 / 8; ++i) {
                    by = byteBuffer2.get();
                    for (n6 = 7; n6 >= 0; --n6) {
                        intBuffer3.put(intBuffer.get(by >> n6 & 1));
                    }
                }
                if (n4 % 8 != 0) {
                    by = byteBuffer2.get();
                    for (n6 = 7; n6 >= 8 - n4 % 8; --n6) {
                        intBuffer3.put(intBuffer.get(by >> n6 & 1));
                    }
                }
                intBuffer3.position(intBuffer3.position() + n5);
            }
        } else {
            while (n3 > 0) {
                int n7 = intBuffer3.position() + n4;
                while (intBuffer3.position() < n7) {
                    intBuffer3.put(intBuffer.get(byteBuffer2.get() & 0xFF));
                }
                intBuffer3.position(intBuffer3.position() + n5);
                --n3;
            }
        }
    }

    public final int readCompact(InStream inStream) {
        byte by = (byte)inStream.readU8();
        int n = by & 0x7F;
        if ((by & 0x80) != 0) {
            by = (byte)inStream.readU8();
            n |= (by & 0x7F) << 7;
            if ((by & 0x80) != 0) {
                by = (byte)inStream.readU8();
                n |= (by & 0xFF) << 14;
            }
        }
        return n;
    }
}

