/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGridGUI.Application.Editor;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ParametersField
extends JTable {
    private final String _noDefault = "No default";
    private DefaultTableModel _model;
    private Vector<String> _columnNames;
    private Editor _editor;
    private TableCellEditor _cellEditor;

    public ParametersField(Editor editor) {
        this._editor = editor;
        this._columnNames = new Vector(2);
        this._columnNames.add("Name");
        this._columnNames.add("Default value");
        JComboBox<String> comboBox = new JComboBox<String>(new String[]{"No default"});
        comboBox.setEditable(true);
        this._cellEditor = new DefaultCellEditor(comboBox);
        int fontSize = this.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this.rowHeight < minRowHeight) {
            this.setRowHeight(minRowHeight);
        }
        AbstractAction deleteRow = new AbstractAction("Delete selected row(s)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow;
                if (ParametersField.this.isEditing()) {
                    ParametersField.this.getCellEditor().stopCellEditing();
                }
                while ((selectedRow = ParametersField.this.getSelectedRow()) != -1) {
                    ParametersField.this._model.removeRow(selectedRow);
                }
            }
        };
        this.getActionMap().put("delete", deleteRow);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    public void set(List<String> names, Map<String, String> values) {
        Vector vector = new Vector(names.size());
        for (String name : names) {
            Vector<String> row = new Vector<String>(2);
            row.add(name);
            String val = values.get(name);
            if (val == null) {
                row.add("No default");
            } else {
                row.add(val);
            }
            vector.add(row);
        }
        Vector<String> newRow = new Vector<String>(2);
        newRow.add("");
        newRow.add("No default");
        vector.add(newRow);
        this._model = new DefaultTableModel(vector, this._columnNames);
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Object lastKey = ParametersField.this._model.getValueAt(ParametersField.this._model.getRowCount() - 1, 0);
                if (lastKey != null && !lastKey.equals("")) {
                    ParametersField.this._model.addRow(new Object[]{"", "No default"});
                }
                ParametersField.this._editor.updated();
            }
        });
        this.setModel(this._model);
        TableColumn valColumn = this.getColumnModel().getColumn(1);
        valColumn.setCellEditor(this._cellEditor);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public Map<String, String> get(List<String> names) {
        assert (names != null);
        HashMap<String, String> values = new HashMap<String, String>();
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        for (Vector row : vector) {
            String name = row.elementAt(0).toString();
            if (name == null || (name = name.trim()).equals("")) continue;
            names.add(name);
            String val = row.elementAt(1).toString();
            if (val == "No default") continue;
            assert (val != null);
            values.put(name, val);
        }
        return values;
    }
}

