# ALPM PKGBUILD Bridge

This project hosts the `alpm-pkgbuild-bridge.sh` script, which is called by the [`alpm-pkgbuild`] crate in the [`alpm`] project.

The script takes any [`PKGBUILD`] file and exports all scoped and unscoped variables from it in a consistent format, that's then parsed by the `alpm-pkgbuild` crate.
It acts as a bridge between bash and rust code and does no validation on any of the data itself.

### Setup

To contribute to this repository, you'll need some tooling to be installed and git to be properly configured to add sign-off sections to commit messages.

To do so quickly use these commands:

- `just install-pacman-dev-packages` - Installs all required development packages, which are listed in the `.env` file.
- `just configure-git` - Adds pre-commit and pre-push hooks, and sets up sign-off messages.

### Installation

Use `just install /destination/dir` to install the script to `/destination/dir/alpm-pkgbuild-bridge`.

### Commandline

<!--
```bash
# Use a custom, temporary directory for testing
test_tmpdir="$(mktemp --directory --suffix '.buildinfo-test')"
OUTPUT_FILE="$test_tmpdir/bridge_output"
```
-->

Run the bridge script on a local test `PKGBUILD` file:

```bash
./alpm-pkgbuild-bridge.sh tests/TEST_PKGBUILD > $OUTPUT_FILE
```

<!--
```bash
# Assert that the command's output equal the expected output.

# Compare it with the expected file
diff --ignore-trailing-space "$OUTPUT_FILE" "tests/TEST_PKGBUILD.expected"
```

-->

### Example output

```
VAR GLOBAL ARRAY arch "x86_64"
VAR GLOBAL ARRAY license "MIT"
VAR GLOBAL STRING pkgbase "zola"
VAR GLOBAL STRING pkgdesc "An opinionated static site generator"
VAR GLOBAL STRING pkgname "zola"
VAR GLOBAL STRING pkgrel "1"
VAR GLOBAL STRING pkgver "0.20.0"
VAR GLOBAL STRING url "https://github.com/getzola/zola"
VAR GLOBAL ARRAY depends "gcc-libs"
VAR GLOBAL ARRAY makedepends "cargo"
VAR GLOBAL ARRAY source "zola-0.20.0.tar.gz::https://github.com/getzola/zola/archive/v0.20.0.tar.gz"
VAR GLOBAL ARRAY sha256sums "ed0274b4139e5ebae1bfac045a635d952e50dc238fdc39cb730b032167f8bb4a"
FUNCTION package
```

[`alpm`]: https://gitlab.archlinux.org/archlinux/alpm/alpm
[`alpm-pkgbuild`]: https://gitlab.archlinux.org/archlinux/alpm/alpm/-/tree/main/alpm-pkgbuild?ref_type=heads
[PKGBUILD]: https://man.archlinux.org/man/PKGBUILD.5
