﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amplify/Amplify_EXPORTS.h>
#include <aws/amplify/model/JobSummary.h>
#include <aws/amplify/model/Step.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Amplify {
namespace Model {

/**
 * <p> Describes an execution job for an Amplify app. </p><p><h3>See Also:</h3>
 * <a href="http://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/Job">AWS API
 * Reference</a></p>
 */
class Job {
 public:
  AWS_AMPLIFY_API Job() = default;
  AWS_AMPLIFY_API Job(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFY_API Job& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> Describes the summary for an execution job for an Amplify app. </p>
   */
  inline const JobSummary& GetSummary() const { return m_summary; }
  inline bool SummaryHasBeenSet() const { return m_summaryHasBeenSet; }
  template <typename SummaryT = JobSummary>
  void SetSummary(SummaryT&& value) {
    m_summaryHasBeenSet = true;
    m_summary = std::forward<SummaryT>(value);
  }
  template <typename SummaryT = JobSummary>
  Job& WithSummary(SummaryT&& value) {
    SetSummary(std::forward<SummaryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The execution steps for an execution job, for an Amplify app. </p>
   */
  inline const Aws::Vector<Step>& GetSteps() const { return m_steps; }
  inline bool StepsHasBeenSet() const { return m_stepsHasBeenSet; }
  template <typename StepsT = Aws::Vector<Step>>
  void SetSteps(StepsT&& value) {
    m_stepsHasBeenSet = true;
    m_steps = std::forward<StepsT>(value);
  }
  template <typename StepsT = Aws::Vector<Step>>
  Job& WithSteps(StepsT&& value) {
    SetSteps(std::forward<StepsT>(value));
    return *this;
  }
  template <typename StepsT = Step>
  Job& AddSteps(StepsT&& value) {
    m_stepsHasBeenSet = true;
    m_steps.emplace_back(std::forward<StepsT>(value));
    return *this;
  }
  ///@}
 private:
  JobSummary m_summary;

  Aws::Vector<Step> m_steps;
  bool m_summaryHasBeenSet = false;
  bool m_stepsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Amplify
}  // namespace Aws
